/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-10-10 15:32:36 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wor4890_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=290 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor4890_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=6916 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor4890_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor4890_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=727 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor4890_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor4890_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor4890_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor4890_fbv` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` int NOT NULL DEFAULT '0',
  `type` int NOT NULL DEFAULT '0',
  `ord` int DEFAULT '0',
  `created_by` int DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor4890_fbv_attachment_folder` (
  `folder_id` int unsigned NOT NULL,
  `attachment_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`folder_id`,`attachment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor4890_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor4890_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=37491 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor4890_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=162 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor4890_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor4890_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor4890_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor4890_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor4890_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor4890_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor4890_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor4890_wfauditevents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `request_id` bigint unsigned NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor4890_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int unsigned NOT NULL DEFAULT '0',
  `unixday` int unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor4890_wfblocks7` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` int unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int unsigned DEFAULT '0',
  `blockedHits` int unsigned DEFAULT '0',
  `expiration` bigint unsigned NOT NULL DEFAULT '0',
  `parameters` text,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB AUTO_INCREMENT=2325 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor4890_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor4890_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor4890_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor4890_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `real_path` text NOT NULL,
  `knownFile` tinyint unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor4890_wfhits` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint DEFAULT '0',
  `statusCode` int NOT NULL DEFAULT '200',
  `isGoogle` tinyint NOT NULL,
  `userID` int unsigned NOT NULL,
  `newVisit` tinyint unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=InnoDB AUTO_INCREMENT=4788 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor4890_wfhoover` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor4890_wfissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB AUTO_INCREMENT=918 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor4890_wfknownfilelist` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `wordpress_path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10182 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor4890_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor4890_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int unsigned NOT NULL,
  `failed` tinyint unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor4890_wflogins` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=InnoDB AUTO_INCREMENT=1899 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor4890_wfls_2fa_secrets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int unsigned NOT NULL,
  `vtime` int unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor4890_wfls_role_counts` (
  `serialized_roles` varbinary(255) NOT NULL,
  `two_factor_inactive` tinyint(1) NOT NULL,
  `user_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`serialized_roles`,`two_factor_inactive`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

CREATE TABLE `wor4890_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor4890_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int NOT NULL DEFAULT '1000',
  `ctime` int unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor4890_wfpendingissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor4890_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor4890_wfsecurityevents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor4890_wfsnipcache` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int unsigned NOT NULL DEFAULT '0',
  `type` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=3998 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor4890_wfstatus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=12839 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor4890_wftrafficrates` (
  `eMin` int unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor4890_wfwaffailures` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `throwable` text NOT NULL,
  `rule_id` int unsigned DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wor4890_wpforms_logs` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `types` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `create_at` datetime NOT NULL,
  `form_id` bigint DEFAULT NULL,
  `entry_id` bigint DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor4890_wpforms_payment_meta` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `payment_id` bigint NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `payment_id` (`payment_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor4890_wpforms_payments` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `form_id` bigint NOT NULL,
  `status` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subtotal_amount` decimal(26,8) NOT NULL DEFAULT '0.00000000',
  `discount_amount` decimal(26,8) NOT NULL DEFAULT '0.00000000',
  `total_amount` decimal(26,8) NOT NULL DEFAULT '0.00000000',
  `currency` varchar(3) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `entry_id` bigint NOT NULL DEFAULT '0',
  `gateway` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `type` varchar(12) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `mode` varchar(4) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `transaction_id` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `customer_id` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subscription_id` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `subscription_status` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `date_created_gmt` datetime NOT NULL,
  `date_updated_gmt` datetime NOT NULL,
  `is_published` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `status` (`status`(8)),
  KEY `total_amount` (`total_amount`),
  KEY `type` (`type`(8)),
  KEY `transaction_id` (`transaction_id`(32)),
  KEY `customer_id` (`customer_id`(32)),
  KEY `subscription_id` (`subscription_id`(32)),
  KEY `subscription_status` (`subscription_status`(8)),
  KEY `title` (`title`(64))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wor4890_wpforms_tasks_meta` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `action` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wor4890_actionscheduler_actions */
INSERT INTO `wor4890_actionscheduler_actions` VALUES("170", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-09-12 18:10:14", "2025-09-12 18:10:14", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757700614;s:18:\"\0*\0first_timestamp\";i:1754066174;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757700614;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-09-12 19:00:43", "2025-09-12 19:00:43", "4667", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("180", "wpforms_process_forms_locator_scan", "complete", "2025-09-10 09:00:36", "2025-09-10 09:00:36", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757494836;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757494836;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-10 09:02:07", "2025-09-10 09:02:07", "4365", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("181", "wpforms_process_purge_spam", "complete", "2025-09-10 09:00:36", "2025-09-10 09:00:36", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757494836;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757494836;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-10 09:02:07", "2025-09-10 09:02:07", "4365", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("182", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-10 09:00:36", "2025-09-10 09:00:36", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757494836;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757494836;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-10 09:02:07", "2025-09-10 09:02:07", "4365", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("183", "wpforms_process_forms_locator_scan", "complete", "2025-09-11 09:02:07", "2025-09-11 09:02:07", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757581327;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757581327;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-11 09:23:55", "2025-09-11 09:23:55", "4506", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("184", "wpforms_process_purge_spam", "complete", "2025-09-11 09:02:07", "2025-09-11 09:02:07", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757581327;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757581327;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-11 09:23:55", "2025-09-11 09:23:55", "4506", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("185", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-11 09:02:07", "2025-09-11 09:02:07", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757581327;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757581327;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-11 09:23:55", "2025-09-11 09:23:55", "4506", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("186", "wpforms_process_forms_locator_scan", "complete", "2025-09-12 09:23:55", "2025-09-12 09:23:55", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757669035;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757669035;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-12 09:29:53", "2025-09-12 09:29:53", "4634", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("187", "wpforms_process_purge_spam", "complete", "2025-09-12 09:23:55", "2025-09-12 09:23:55", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757669035;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757669035;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-12 09:29:53", "2025-09-12 09:29:53", "4634", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("188", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-12 09:23:55", "2025-09-12 09:23:55", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757669035;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757669035;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-12 09:29:53", "2025-09-12 09:29:53", "4634", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("189", "wpforms_process_forms_locator_scan", "complete", "2025-09-13 09:29:53", "2025-09-13 09:29:53", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757755793;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757755793;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-13 09:38:34", "2025-09-13 09:38:34", "4719", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("190", "wpforms_process_purge_spam", "complete", "2025-09-13 09:29:53", "2025-09-13 09:29:53", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757755793;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757755793;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-13 09:38:34", "2025-09-13 09:38:34", "4719", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("191", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-13 09:29:53", "2025-09-13 09:29:53", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757755793;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757755793;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-13 09:38:34", "2025-09-13 09:38:34", "4719", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("192", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-09-19 19:00:43", "2025-09-19 19:00:43", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758308443;s:18:\"\0*\0first_timestamp\";i:1754066174;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758308443;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-09-19 20:08:18", "2025-09-19 20:08:18", "5367", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("193", "wpforms_process_forms_locator_scan", "complete", "2025-09-14 09:38:34", "2025-09-14 09:38:34", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757842714;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757842714;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-14 10:05:25", "2025-09-14 10:05:25", "4827", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("194", "wpforms_process_purge_spam", "complete", "2025-09-14 09:38:34", "2025-09-14 09:38:34", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757842714;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757842714;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-14 10:05:25", "2025-09-14 10:05:25", "4827", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("195", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-14 09:38:34", "2025-09-14 09:38:34", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757842714;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757842714;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-14 10:05:25", "2025-09-14 10:05:25", "4827", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("196", "wpforms_process_forms_locator_scan", "complete", "2025-09-15 10:05:25", "2025-09-15 10:05:25", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757930725;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757930725;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-15 10:10:45", "2025-09-15 10:10:45", "4974", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("197", "wpforms_process_purge_spam", "complete", "2025-09-15 10:05:25", "2025-09-15 10:05:25", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757930725;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757930725;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-15 10:10:45", "2025-09-15 10:10:45", "4974", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("198", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-15 10:05:25", "2025-09-15 10:05:25", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757930725;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757930725;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-15 10:10:45", "2025-09-15 10:10:45", "4974", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("199", "wpforms_process_forms_locator_scan", "complete", "2025-09-16 10:10:45", "2025-09-16 10:10:45", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758017445;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758017445;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-16 10:28:10", "2025-09-16 10:28:10", "5112", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("200", "wpforms_process_purge_spam", "complete", "2025-09-16 10:10:45", "2025-09-16 10:10:45", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758017445;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758017445;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-16 10:28:10", "2025-09-16 10:28:10", "5112", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("201", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-16 10:10:45", "2025-09-16 10:10:45", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758017445;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758017445;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-16 10:28:10", "2025-09-16 10:28:10", "5112", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("202", "wpforms_process_forms_locator_scan", "complete", "2025-09-17 10:28:10", "2025-09-17 10:28:10", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758104890;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758104890;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-17 11:34:55", "2025-09-17 11:34:55", "5186", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("203", "wpforms_process_purge_spam", "complete", "2025-09-17 10:28:10", "2025-09-17 10:28:10", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758104890;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758104890;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-17 11:34:55", "2025-09-17 11:34:55", "5186", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("204", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-17 10:28:10", "2025-09-17 10:28:10", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758104890;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758104890;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-17 11:34:55", "2025-09-17 11:34:55", "5186", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("205", "wpforms_process_forms_locator_scan", "complete", "2025-09-18 11:34:55", "2025-09-18 11:34:55", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758195295;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758195295;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-18 11:52:14", "2025-09-18 11:52:14", "5283", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("206", "wpforms_process_purge_spam", "complete", "2025-09-18 11:34:55", "2025-09-18 11:34:55", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758195295;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758195295;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-18 11:52:14", "2025-09-18 11:52:14", "5283", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("207", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-18 11:34:55", "2025-09-18 11:34:55", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758195295;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758195295;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-18 11:52:14", "2025-09-18 11:52:14", "5283", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("208", "wpforms_process_forms_locator_scan", "complete", "2025-09-19 11:52:14", "2025-09-19 11:52:14", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758282734;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758282734;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-19 12:10:16", "2025-09-19 12:10:16", "5347", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("209", "wpforms_process_purge_spam", "complete", "2025-09-19 11:52:14", "2025-09-19 11:52:14", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758282734;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758282734;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-19 12:10:16", "2025-09-19 12:10:16", "5347", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("210", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-19 11:52:14", "2025-09-19 11:52:14", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758282734;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758282734;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-19 12:10:16", "2025-09-19 12:10:16", "5347", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("211", "wpforms_process_forms_locator_scan", "complete", "2025-09-20 12:10:16", "2025-09-20 12:10:16", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758370216;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758370216;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-20 13:17:12", "2025-09-20 13:17:12", "5410", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("212", "wpforms_process_purge_spam", "complete", "2025-09-20 12:10:16", "2025-09-20 12:10:16", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758370216;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758370216;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-20 13:17:12", "2025-09-20 13:17:12", "5410", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("213", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-20 12:10:16", "2025-09-20 12:10:16", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758370216;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758370216;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-20 13:17:12", "2025-09-20 13:17:12", "5410", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("214", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-09-26 20:08:18", "2025-09-26 20:08:18", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758917298;s:18:\"\0*\0first_timestamp\";i:1754066174;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758917298;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-09-26 20:54:44", "2025-09-26 20:54:44", "5940", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("215", "wpforms_process_forms_locator_scan", "complete", "2025-09-21 13:17:12", "2025-09-21 13:17:12", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758460632;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758460632;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-21 13:41:51", "2025-09-21 13:41:51", "5490", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("216", "wpforms_process_purge_spam", "complete", "2025-09-21 13:17:12", "2025-09-21 13:17:12", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758460632;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758460632;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-21 13:41:51", "2025-09-21 13:41:51", "5490", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("217", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-21 13:17:12", "2025-09-21 13:17:12", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758460632;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758460632;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-21 13:41:51", "2025-09-21 13:41:51", "5490", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("218", "wpforms_process_forms_locator_scan", "complete", "2025-09-22 13:41:51", "2025-09-22 13:41:51", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758548511;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758548511;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-22 14:16:34", "2025-09-22 14:16:34", "5546", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("219", "wpforms_process_purge_spam", "complete", "2025-09-22 13:41:51", "2025-09-22 13:41:51", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758548511;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758548511;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-22 14:16:34", "2025-09-22 14:16:34", "5546", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("220", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-22 13:41:51", "2025-09-22 13:41:51", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758548511;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758548511;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-22 14:16:34", "2025-09-22 14:16:34", "5546", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("221", "wpforms_process_forms_locator_scan", "complete", "2025-09-23 14:16:34", "2025-09-23 14:16:34", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758636994;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758636994;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-23 14:46:43", "2025-09-23 14:46:43", "5674", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("222", "wpforms_process_purge_spam", "complete", "2025-09-23 14:16:34", "2025-09-23 14:16:34", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758636994;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758636994;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-23 14:46:43", "2025-09-23 14:46:43", "5674", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("223", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-23 14:16:34", "2025-09-23 14:16:34", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758636994;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758636994;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-23 14:46:43", "2025-09-23 14:46:43", "5674", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("224", "wpforms_process_forms_locator_scan", "complete", "2025-09-24 14:46:43", "2025-09-24 14:46:43", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758725203;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758725203;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-24 14:53:28", "2025-09-24 14:53:28", "5785", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("225", "wpforms_process_purge_spam", "complete", "2025-09-24 14:46:43", "2025-09-24 14:46:43", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758725203;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758725203;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-24 14:53:28", "2025-09-24 14:53:28", "5785", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("226", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-24 14:46:43", "2025-09-24 14:46:43", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758725203;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758725203;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-24 14:53:28", "2025-09-24 14:53:28", "5785", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("227", "wpforms_process_forms_locator_scan", "complete", "2025-09-25 14:53:28", "2025-09-25 14:53:28", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758812008;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758812008;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-25 14:53:46", "2025-09-25 14:53:46", "5851", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("228", "wpforms_process_purge_spam", "complete", "2025-09-25 14:53:28", "2025-09-25 14:53:28", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758812008;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758812008;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-25 14:53:46", "2025-09-25 14:53:46", "5851", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("229", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-25 14:53:28", "2025-09-25 14:53:28", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758812008;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758812008;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-25 14:53:46", "2025-09-25 14:53:46", "5851", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("230", "wpforms_process_forms_locator_scan", "complete", "2025-09-26 14:53:46", "2025-09-26 14:53:46", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758898426;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758898426;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-26 15:05:06", "2025-09-26 15:05:06", "5924", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("231", "wpforms_process_purge_spam", "complete", "2025-09-26 14:53:46", "2025-09-26 14:53:46", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758898426;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758898426;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-26 15:05:06", "2025-09-26 15:05:06", "5924", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("232", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-26 14:53:46", "2025-09-26 14:53:46", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758898426;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758898426;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-26 15:05:06", "2025-09-26 15:05:06", "5924", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("233", "wpforms_process_forms_locator_scan", "complete", "2025-09-27 15:05:06", "2025-09-27 15:05:06", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758985506;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758985506;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-27 15:13:32", "2025-09-27 15:13:32", "6036", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("234", "wpforms_process_purge_spam", "complete", "2025-09-27 15:05:06", "2025-09-27 15:05:06", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758985506;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758985506;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-27 15:13:32", "2025-09-27 15:13:32", "6036", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("235", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-27 15:05:06", "2025-09-27 15:05:06", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758985506;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758985506;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-27 15:13:32", "2025-09-27 15:13:32", "6036", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("236", "wpforms_email_summaries_fetch_info_blocks", "complete", "2025-10-03 20:54:44", "2025-10-03 20:54:44", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759524884;s:18:\"\0*\0first_timestamp\";i:1754066174;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759524884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "1", "2025-10-03 21:00:24", "2025-10-03 21:00:24", "6435", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("237", "wpforms_process_forms_locator_scan", "complete", "2025-09-28 15:13:32", "2025-09-28 15:13:32", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759072412;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759072412;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-28 15:44:08", "2025-09-28 15:44:08", "6115", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("238", "wpforms_process_purge_spam", "complete", "2025-09-28 15:13:32", "2025-09-28 15:13:32", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759072412;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759072412;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-28 15:44:08", "2025-09-28 15:44:08", "6115", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("239", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-28 15:13:32", "2025-09-28 15:13:32", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759072412;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759072412;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-28 15:44:08", "2025-09-28 15:44:08", "6115", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("240", "wpforms_process_forms_locator_scan", "complete", "2025-09-29 15:44:08", "2025-09-29 15:44:08", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759160648;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759160648;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-29 15:53:06", "2025-09-29 15:53:06", "6198", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("241", "wpforms_process_purge_spam", "complete", "2025-09-29 15:44:08", "2025-09-29 15:44:08", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759160648;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759160648;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-29 15:53:06", "2025-09-29 15:53:06", "6198", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("242", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-29 15:44:08", "2025-09-29 15:44:08", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759160648;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759160648;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-29 15:53:06", "2025-09-29 15:53:06", "6198", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("243", "wpforms_process_forms_locator_scan", "complete", "2025-09-30 15:53:06", "2025-09-30 15:53:06", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759247586;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759247586;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-30 17:08:24", "2025-09-30 17:08:24", "6276", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("244", "wpforms_process_purge_spam", "complete", "2025-09-30 15:53:06", "2025-09-30 15:53:06", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759247586;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759247586;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-30 17:08:24", "2025-09-30 17:08:24", "6276", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("245", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-30 15:53:06", "2025-09-30 15:53:06", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759247586;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759247586;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-09-30 17:08:24", "2025-09-30 17:08:24", "6276", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("246", "wpforms_process_forms_locator_scan", "complete", "2025-10-01 17:08:24", "2025-10-01 17:08:24", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759338504;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759338504;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-01 17:23:51", "2025-10-01 17:23:51", "6333", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("247", "wpforms_process_purge_spam", "complete", "2025-10-01 17:08:24", "2025-10-01 17:08:24", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759338504;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759338504;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-01 17:23:51", "2025-10-01 17:23:51", "6333", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("248", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-01 17:08:24", "2025-10-01 17:08:24", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759338504;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759338504;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-10-01 17:23:51", "2025-10-01 17:23:51", "6333", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("249", "wpforms_process_forms_locator_scan", "complete", "2025-10-02 17:23:51", "2025-10-02 17:23:51", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759425831;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759425831;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-02 17:24:54", "2025-10-02 17:24:54", "6391", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("250", "wpforms_process_purge_spam", "complete", "2025-10-02 17:23:51", "2025-10-02 17:23:51", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759425831;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759425831;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-02 17:24:54", "2025-10-02 17:24:54", "6391", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("251", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-02 17:23:51", "2025-10-02 17:23:51", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759425831;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759425831;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-10-02 17:24:54", "2025-10-02 17:24:54", "6391", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("252", "wpforms_process_forms_locator_scan", "complete", "2025-10-03 17:24:54", "2025-10-03 17:24:54", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759512294;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759512294;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-03 17:27:57", "2025-10-03 17:27:57", "6431", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("253", "wpforms_process_purge_spam", "complete", "2025-10-03 17:24:54", "2025-10-03 17:24:54", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759512294;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759512294;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-03 17:27:57", "2025-10-03 17:27:57", "6431", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("254", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-03 17:24:54", "2025-10-03 17:24:54", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759512294;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759512294;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-10-03 17:27:57", "2025-10-03 17:27:57", "6431", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("255", "wpforms_process_forms_locator_scan", "complete", "2025-10-04 17:27:57", "2025-10-04 17:27:57", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759598877;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759598877;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-04 17:45:38", "2025-10-04 17:45:38", "6474", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("256", "wpforms_process_purge_spam", "complete", "2025-10-04 17:27:57", "2025-10-04 17:27:57", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759598877;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759598877;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-04 17:45:38", "2025-10-04 17:45:38", "6474", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("257", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-04 17:27:57", "2025-10-04 17:27:57", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759598877;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759598877;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-10-04 17:45:38", "2025-10-04 17:45:38", "6474", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("258", "wpforms_email_summaries_fetch_info_blocks", "pending", "2025-10-10 21:00:24", "2025-10-10 21:00:24", "10", "{\"tasks_meta_id\":null}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760130024;s:18:\"\0*\0first_timestamp\";i:1754066174;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760130024;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("259", "wpforms_process_forms_locator_scan", "complete", "2025-10-05 17:45:38", "2025-10-05 17:45:38", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759686338;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759686338;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-05 17:46:42", "2025-10-05 17:46:42", "6541", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("260", "wpforms_process_purge_spam", "complete", "2025-10-05 17:45:38", "2025-10-05 17:45:38", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759686338;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759686338;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-05 17:46:42", "2025-10-05 17:46:42", "6541", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("261", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-05 17:45:38", "2025-10-05 17:45:38", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759686338;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759686338;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-10-05 17:46:42", "2025-10-05 17:46:42", "6541", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("262", "wpforms_process_forms_locator_scan", "complete", "2025-10-06 17:46:42", "2025-10-06 17:46:42", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759772802;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759772802;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-06 19:22:06", "2025-10-06 19:22:06", "6594", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("263", "wpforms_process_purge_spam", "complete", "2025-10-06 17:46:42", "2025-10-06 17:46:42", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759772802;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759772802;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-06 19:22:06", "2025-10-06 19:22:06", "6594", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("264", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-06 17:46:42", "2025-10-06 17:46:42", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759772802;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759772802;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-10-06 19:22:06", "2025-10-06 19:22:06", "6594", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("265", "wpforms_process_forms_locator_scan", "complete", "2025-10-07 19:22:06", "2025-10-07 19:22:06", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759864926;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759864926;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-07 19:31:11", "2025-10-07 19:31:11", "6632", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("266", "wpforms_process_purge_spam", "complete", "2025-10-07 19:22:06", "2025-10-07 19:22:06", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759864926;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759864926;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-07 19:31:11", "2025-10-07 19:31:11", "6632", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("267", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-07 19:22:06", "2025-10-07 19:22:06", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759864926;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759864926;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-10-07 19:31:11", "2025-10-07 19:31:11", "6632", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("268", "wpforms_process_forms_locator_scan", "complete", "2025-10-08 19:31:11", "2025-10-08 19:31:11", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759951871;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759951871;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-08 20:13:59", "2025-10-08 20:13:59", "6689", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("269", "wpforms_process_purge_spam", "complete", "2025-10-08 19:31:11", "2025-10-08 19:31:11", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759951871;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759951871;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-08 20:13:59", "2025-10-08 20:13:59", "6689", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("270", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-08 19:31:11", "2025-10-08 19:31:11", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759951871;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759951871;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-10-08 20:13:59", "2025-10-08 20:13:59", "6689", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("271", "wpforms_process_forms_locator_scan", "complete", "2025-10-09 20:13:59", "2025-10-09 20:13:59", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760040839;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760040839;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-09 20:25:55", "2025-10-09 20:25:55", "6754", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("272", "wpforms_process_purge_spam", "complete", "2025-10-09 20:13:59", "2025-10-09 20:13:59", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760040839;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760040839;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-10-09 20:25:55", "2025-10-09 20:25:55", "6754", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("273", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-09 20:13:59", "2025-10-09 20:13:59", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760040839;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760040839;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-10-09 20:25:55", "2025-10-09 20:25:55", "6754", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("274", "wpforms_process_forms_locator_scan", "pending", "2025-10-10 20:25:55", "2025-10-10 20:25:55", "10", "{\"tasks_meta_id\":1}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760127955;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760127955;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("275", "wpforms_process_purge_spam", "pending", "2025-10-10 20:25:55", "2025-10-10 20:25:55", "10", "{\"tasks_meta_id\":2}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760127955;s:18:\"\0*\0first_timestamp\";i:1753810088;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760127955;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("276", "action_scheduler_run_recurring_actions_schedule_hook", "pending", "2025-10-10 20:25:55", "2025-10-10 20:25:55", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760127955;s:18:\"\0*\0first_timestamp\";i:1753981301;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760127955;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("277", "wpforms_admin_notifications_update", "complete", "2025-10-10 13:06:28", "2025-10-10 13:06:28", "10", "{\"tasks_meta_id\":6}", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-10-10 13:07:33", "2025-10-10 13:07:33", "6817", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("278", "wpforms_admin_addons_cache_update", "pending", "2025-10-17 13:06:39", "2025-10-17 13:06:39", "10", "{\"tasks_meta_id\":7}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760706399;s:18:\"\0*\0first_timestamp\";i:1760706399;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760706399;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("279", "wpforms_admin_builder_templates_cache_update", "pending", "2025-10-17 13:06:39", "2025-10-17 13:06:39", "10", "{\"tasks_meta_id\":8}", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760706399;s:18:\"\0*\0first_timestamp\";i:1760706399;s:13:\"\0*\0recurrence\";i:604800;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760706399;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:604800;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("280", "action_scheduler/migration_hook", "complete", "2025-10-10 13:50:07", "2025-10-10 13:50:07", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760104207;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760104207;}", "1", "1", "2025-10-10 13:50:24", "2025-10-10 13:50:24", "6852", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("281", "instawp_send_heartbeat", "complete", "2025-10-10 13:50:15", "2025-10-10 13:50:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760104215;s:18:\"\0*\0first_timestamp\";i:1760104215;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760104215;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-10-10 13:50:24", "2025-10-10 13:50:24", "6852", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("282", "instawp_handle_heartbeat", "complete", "2025-10-10 13:50:15", "2025-10-10 13:50:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760104215;s:18:\"\0*\0first_timestamp\";i:1760104215;s:13:\"\0*\0recurrence\";i:14400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760104215;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:14400;}", "4", "1", "2025-10-10 13:50:24", "2025-10-10 13:50:24", "6852", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("283", "instawp_prepare_large_files_list", "complete", "2025-10-10 13:50:15", "2025-10-10 13:50:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760104215;s:18:\"\0*\0first_timestamp\";i:1760104215;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760104215;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "4", "1", "2025-10-10 13:50:25", "2025-10-10 13:50:25", "6852", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("284", "instawp_clean_migrate_files", "complete", "2025-10-10 13:50:15", "2025-10-10 13:50:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760104215;s:18:\"\0*\0first_timestamp\";i:1760104215;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760104215;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2025-10-10 13:50:25", "2025-10-10 13:50:25", "6852", NULL);
INSERT INTO `wor4890_actionscheduler_actions` VALUES("289", "action_scheduler/migration_hook", "complete", "2025-10-10 13:56:33", "2025-10-10 13:56:33", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760104593;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760104593;}", "1", "1", "2025-10-10 13:57:28", "2025-10-10 13:57:28", "6860", NULL);

/* INSERT TABLE DATA: wor4890_actionscheduler_groups */
INSERT INTO `wor4890_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wor4890_actionscheduler_groups` VALUES("2", "wpforms");
INSERT INTO `wor4890_actionscheduler_groups` VALUES("3", "ActionScheduler");
INSERT INTO `wor4890_actionscheduler_groups` VALUES("4", "instawp-connect");

/* INSERT TABLE DATA: wor4890_actionscheduler_logs */
INSERT INTO `wor4890_actionscheduler_logs` VALUES("373", "170", "action created", "2025-09-05 18:10:14", "2025-09-05 18:10:14");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("403", "180", "action created", "2025-09-09 09:00:36", "2025-09-09 09:00:36");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("406", "181", "action created", "2025-09-09 09:00:36", "2025-09-09 09:00:36");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("409", "182", "action created", "2025-09-09 09:00:36", "2025-09-09 09:00:36");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("410", "180", "action started via WP Cron", "2025-09-10 09:02:07", "2025-09-10 09:02:07");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("411", "180", "action complete via WP Cron", "2025-09-10 09:02:07", "2025-09-10 09:02:07");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("412", "183", "action created", "2025-09-10 09:02:07", "2025-09-10 09:02:07");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("413", "181", "action started via WP Cron", "2025-09-10 09:02:07", "2025-09-10 09:02:07");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("414", "181", "action complete via WP Cron", "2025-09-10 09:02:07", "2025-09-10 09:02:07");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("415", "184", "action created", "2025-09-10 09:02:07", "2025-09-10 09:02:07");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("416", "182", "action started via WP Cron", "2025-09-10 09:02:07", "2025-09-10 09:02:07");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("417", "182", "action complete via WP Cron", "2025-09-10 09:02:07", "2025-09-10 09:02:07");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("418", "185", "action created", "2025-09-10 09:02:07", "2025-09-10 09:02:07");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("419", "183", "action started via WP Cron", "2025-09-11 09:23:55", "2025-09-11 09:23:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("420", "183", "action complete via WP Cron", "2025-09-11 09:23:55", "2025-09-11 09:23:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("421", "186", "action created", "2025-09-11 09:23:55", "2025-09-11 09:23:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("422", "184", "action started via WP Cron", "2025-09-11 09:23:55", "2025-09-11 09:23:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("423", "184", "action complete via WP Cron", "2025-09-11 09:23:55", "2025-09-11 09:23:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("424", "187", "action created", "2025-09-11 09:23:55", "2025-09-11 09:23:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("425", "185", "action started via WP Cron", "2025-09-11 09:23:55", "2025-09-11 09:23:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("426", "185", "action complete via WP Cron", "2025-09-11 09:23:55", "2025-09-11 09:23:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("427", "188", "action created", "2025-09-11 09:23:55", "2025-09-11 09:23:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("428", "186", "action started via WP Cron", "2025-09-12 09:29:53", "2025-09-12 09:29:53");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("429", "186", "action complete via WP Cron", "2025-09-12 09:29:53", "2025-09-12 09:29:53");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("430", "189", "action created", "2025-09-12 09:29:53", "2025-09-12 09:29:53");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("431", "187", "action started via WP Cron", "2025-09-12 09:29:53", "2025-09-12 09:29:53");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("432", "187", "action complete via WP Cron", "2025-09-12 09:29:53", "2025-09-12 09:29:53");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("433", "190", "action created", "2025-09-12 09:29:53", "2025-09-12 09:29:53");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("434", "188", "action started via WP Cron", "2025-09-12 09:29:53", "2025-09-12 09:29:53");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("435", "188", "action complete via WP Cron", "2025-09-12 09:29:53", "2025-09-12 09:29:53");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("436", "191", "action created", "2025-09-12 09:29:53", "2025-09-12 09:29:53");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("437", "170", "action started via WP Cron", "2025-09-12 19:00:43", "2025-09-12 19:00:43");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("438", "170", "action complete via WP Cron", "2025-09-12 19:00:43", "2025-09-12 19:00:43");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("439", "192", "action created", "2025-09-12 19:00:43", "2025-09-12 19:00:43");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("440", "189", "action started via WP Cron", "2025-09-13 09:38:34", "2025-09-13 09:38:34");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("441", "189", "action complete via WP Cron", "2025-09-13 09:38:34", "2025-09-13 09:38:34");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("442", "193", "action created", "2025-09-13 09:38:34", "2025-09-13 09:38:34");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("443", "190", "action started via WP Cron", "2025-09-13 09:38:34", "2025-09-13 09:38:34");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("444", "190", "action complete via WP Cron", "2025-09-13 09:38:34", "2025-09-13 09:38:34");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("445", "194", "action created", "2025-09-13 09:38:34", "2025-09-13 09:38:34");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("446", "191", "action started via WP Cron", "2025-09-13 09:38:34", "2025-09-13 09:38:34");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("447", "191", "action complete via WP Cron", "2025-09-13 09:38:34", "2025-09-13 09:38:34");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("448", "195", "action created", "2025-09-13 09:38:34", "2025-09-13 09:38:34");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("449", "193", "action started via WP Cron", "2025-09-14 10:05:25", "2025-09-14 10:05:25");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("450", "193", "action complete via WP Cron", "2025-09-14 10:05:25", "2025-09-14 10:05:25");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("451", "196", "action created", "2025-09-14 10:05:25", "2025-09-14 10:05:25");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("452", "194", "action started via WP Cron", "2025-09-14 10:05:25", "2025-09-14 10:05:25");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("453", "194", "action complete via WP Cron", "2025-09-14 10:05:25", "2025-09-14 10:05:25");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("454", "197", "action created", "2025-09-14 10:05:25", "2025-09-14 10:05:25");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("455", "195", "action started via WP Cron", "2025-09-14 10:05:25", "2025-09-14 10:05:25");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("456", "195", "action complete via WP Cron", "2025-09-14 10:05:25", "2025-09-14 10:05:25");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("457", "198", "action created", "2025-09-14 10:05:25", "2025-09-14 10:05:25");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("458", "196", "action started via WP Cron", "2025-09-15 10:10:45", "2025-09-15 10:10:45");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("459", "196", "action complete via WP Cron", "2025-09-15 10:10:45", "2025-09-15 10:10:45");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("460", "199", "action created", "2025-09-15 10:10:45", "2025-09-15 10:10:45");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("461", "197", "action started via WP Cron", "2025-09-15 10:10:45", "2025-09-15 10:10:45");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("462", "197", "action complete via WP Cron", "2025-09-15 10:10:45", "2025-09-15 10:10:45");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("463", "200", "action created", "2025-09-15 10:10:45", "2025-09-15 10:10:45");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("464", "198", "action started via WP Cron", "2025-09-15 10:10:45", "2025-09-15 10:10:45");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("465", "198", "action complete via WP Cron", "2025-09-15 10:10:45", "2025-09-15 10:10:45");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("466", "201", "action created", "2025-09-15 10:10:45", "2025-09-15 10:10:45");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("467", "199", "action started via WP Cron", "2025-09-16 10:28:10", "2025-09-16 10:28:10");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("468", "199", "action complete via WP Cron", "2025-09-16 10:28:10", "2025-09-16 10:28:10");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("469", "202", "action created", "2025-09-16 10:28:10", "2025-09-16 10:28:10");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("470", "200", "action started via WP Cron", "2025-09-16 10:28:10", "2025-09-16 10:28:10");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("471", "200", "action complete via WP Cron", "2025-09-16 10:28:10", "2025-09-16 10:28:10");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("472", "203", "action created", "2025-09-16 10:28:10", "2025-09-16 10:28:10");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("473", "201", "action started via WP Cron", "2025-09-16 10:28:10", "2025-09-16 10:28:10");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("474", "201", "action complete via WP Cron", "2025-09-16 10:28:10", "2025-09-16 10:28:10");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("475", "204", "action created", "2025-09-16 10:28:10", "2025-09-16 10:28:10");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("476", "202", "action started via WP Cron", "2025-09-17 11:34:55", "2025-09-17 11:34:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("477", "202", "action complete via WP Cron", "2025-09-17 11:34:55", "2025-09-17 11:34:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("478", "205", "action created", "2025-09-17 11:34:55", "2025-09-17 11:34:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("479", "203", "action started via WP Cron", "2025-09-17 11:34:55", "2025-09-17 11:34:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("480", "203", "action complete via WP Cron", "2025-09-17 11:34:55", "2025-09-17 11:34:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("481", "206", "action created", "2025-09-17 11:34:55", "2025-09-17 11:34:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("482", "204", "action started via WP Cron", "2025-09-17 11:34:55", "2025-09-17 11:34:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("483", "204", "action complete via WP Cron", "2025-09-17 11:34:55", "2025-09-17 11:34:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("484", "207", "action created", "2025-09-17 11:34:55", "2025-09-17 11:34:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("485", "205", "action started via WP Cron", "2025-09-18 11:52:14", "2025-09-18 11:52:14");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("486", "205", "action complete via WP Cron", "2025-09-18 11:52:14", "2025-09-18 11:52:14");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("487", "208", "action created", "2025-09-18 11:52:14", "2025-09-18 11:52:14");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("488", "206", "action started via WP Cron", "2025-09-18 11:52:14", "2025-09-18 11:52:14");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("489", "206", "action complete via WP Cron", "2025-09-18 11:52:14", "2025-09-18 11:52:14");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("490", "209", "action created", "2025-09-18 11:52:14", "2025-09-18 11:52:14");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("491", "207", "action started via WP Cron", "2025-09-18 11:52:14", "2025-09-18 11:52:14");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("492", "207", "action complete via WP Cron", "2025-09-18 11:52:14", "2025-09-18 11:52:14");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("493", "210", "action created", "2025-09-18 11:52:14", "2025-09-18 11:52:14");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("494", "208", "action started via WP Cron", "2025-09-19 12:10:16", "2025-09-19 12:10:16");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("495", "208", "action complete via WP Cron", "2025-09-19 12:10:16", "2025-09-19 12:10:16");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("496", "211", "action created", "2025-09-19 12:10:16", "2025-09-19 12:10:16");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("497", "209", "action started via WP Cron", "2025-09-19 12:10:16", "2025-09-19 12:10:16");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("498", "209", "action complete via WP Cron", "2025-09-19 12:10:16", "2025-09-19 12:10:16");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("499", "212", "action created", "2025-09-19 12:10:16", "2025-09-19 12:10:16");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("500", "210", "action started via WP Cron", "2025-09-19 12:10:16", "2025-09-19 12:10:16");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("501", "210", "action complete via WP Cron", "2025-09-19 12:10:16", "2025-09-19 12:10:16");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("502", "213", "action created", "2025-09-19 12:10:16", "2025-09-19 12:10:16");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("503", "192", "action started via WP Cron", "2025-09-19 20:08:18", "2025-09-19 20:08:18");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("504", "192", "action complete via WP Cron", "2025-09-19 20:08:18", "2025-09-19 20:08:18");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("505", "214", "action created", "2025-09-19 20:08:18", "2025-09-19 20:08:18");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("506", "211", "action started via WP Cron", "2025-09-20 13:17:12", "2025-09-20 13:17:12");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("507", "211", "action complete via WP Cron", "2025-09-20 13:17:12", "2025-09-20 13:17:12");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("508", "215", "action created", "2025-09-20 13:17:12", "2025-09-20 13:17:12");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("509", "212", "action started via WP Cron", "2025-09-20 13:17:12", "2025-09-20 13:17:12");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("510", "212", "action complete via WP Cron", "2025-09-20 13:17:12", "2025-09-20 13:17:12");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("511", "216", "action created", "2025-09-20 13:17:12", "2025-09-20 13:17:12");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("512", "213", "action started via WP Cron", "2025-09-20 13:17:12", "2025-09-20 13:17:12");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("513", "213", "action complete via WP Cron", "2025-09-20 13:17:12", "2025-09-20 13:17:12");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("514", "217", "action created", "2025-09-20 13:17:12", "2025-09-20 13:17:12");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("515", "215", "action started via WP Cron", "2025-09-21 13:41:51", "2025-09-21 13:41:51");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("516", "215", "action complete via WP Cron", "2025-09-21 13:41:51", "2025-09-21 13:41:51");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("517", "218", "action created", "2025-09-21 13:41:51", "2025-09-21 13:41:51");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("518", "216", "action started via WP Cron", "2025-09-21 13:41:51", "2025-09-21 13:41:51");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("519", "216", "action complete via WP Cron", "2025-09-21 13:41:51", "2025-09-21 13:41:51");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("520", "219", "action created", "2025-09-21 13:41:51", "2025-09-21 13:41:51");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("521", "217", "action started via WP Cron", "2025-09-21 13:41:51", "2025-09-21 13:41:51");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("522", "217", "action complete via WP Cron", "2025-09-21 13:41:51", "2025-09-21 13:41:51");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("523", "220", "action created", "2025-09-21 13:41:51", "2025-09-21 13:41:51");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("524", "218", "action started via WP Cron", "2025-09-22 14:16:34", "2025-09-22 14:16:34");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("525", "218", "action complete via WP Cron", "2025-09-22 14:16:34", "2025-09-22 14:16:34");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("526", "221", "action created", "2025-09-22 14:16:34", "2025-09-22 14:16:34");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("527", "219", "action started via WP Cron", "2025-09-22 14:16:34", "2025-09-22 14:16:34");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("528", "219", "action complete via WP Cron", "2025-09-22 14:16:34", "2025-09-22 14:16:34");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("529", "222", "action created", "2025-09-22 14:16:34", "2025-09-22 14:16:34");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("530", "220", "action started via WP Cron", "2025-09-22 14:16:34", "2025-09-22 14:16:34");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("531", "220", "action complete via WP Cron", "2025-09-22 14:16:34", "2025-09-22 14:16:34");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("532", "223", "action created", "2025-09-22 14:16:34", "2025-09-22 14:16:34");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("533", "221", "action started via WP Cron", "2025-09-23 14:46:43", "2025-09-23 14:46:43");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("534", "221", "action complete via WP Cron", "2025-09-23 14:46:43", "2025-09-23 14:46:43");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("535", "224", "action created", "2025-09-23 14:46:43", "2025-09-23 14:46:43");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("536", "222", "action started via WP Cron", "2025-09-23 14:46:43", "2025-09-23 14:46:43");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("537", "222", "action complete via WP Cron", "2025-09-23 14:46:43", "2025-09-23 14:46:43");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("538", "225", "action created", "2025-09-23 14:46:43", "2025-09-23 14:46:43");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("539", "223", "action started via WP Cron", "2025-09-23 14:46:43", "2025-09-23 14:46:43");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("540", "223", "action complete via WP Cron", "2025-09-23 14:46:43", "2025-09-23 14:46:43");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("541", "226", "action created", "2025-09-23 14:46:43", "2025-09-23 14:46:43");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("542", "224", "action started via WP Cron", "2025-09-24 14:53:28", "2025-09-24 14:53:28");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("543", "224", "action complete via WP Cron", "2025-09-24 14:53:28", "2025-09-24 14:53:28");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("544", "227", "action created", "2025-09-24 14:53:28", "2025-09-24 14:53:28");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("545", "225", "action started via WP Cron", "2025-09-24 14:53:28", "2025-09-24 14:53:28");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("546", "225", "action complete via WP Cron", "2025-09-24 14:53:28", "2025-09-24 14:53:28");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("547", "228", "action created", "2025-09-24 14:53:28", "2025-09-24 14:53:28");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("548", "226", "action started via WP Cron", "2025-09-24 14:53:28", "2025-09-24 14:53:28");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("549", "226", "action complete via WP Cron", "2025-09-24 14:53:28", "2025-09-24 14:53:28");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("550", "229", "action created", "2025-09-24 14:53:28", "2025-09-24 14:53:28");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("551", "227", "action started via WP Cron", "2025-09-25 14:53:46", "2025-09-25 14:53:46");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("552", "227", "action complete via WP Cron", "2025-09-25 14:53:46", "2025-09-25 14:53:46");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("553", "230", "action created", "2025-09-25 14:53:46", "2025-09-25 14:53:46");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("554", "228", "action started via WP Cron", "2025-09-25 14:53:46", "2025-09-25 14:53:46");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("555", "228", "action complete via WP Cron", "2025-09-25 14:53:46", "2025-09-25 14:53:46");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("556", "231", "action created", "2025-09-25 14:53:46", "2025-09-25 14:53:46");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("557", "229", "action started via WP Cron", "2025-09-25 14:53:46", "2025-09-25 14:53:46");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("558", "229", "action complete via WP Cron", "2025-09-25 14:53:46", "2025-09-25 14:53:46");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("559", "232", "action created", "2025-09-25 14:53:46", "2025-09-25 14:53:46");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("560", "230", "action started via WP Cron", "2025-09-26 15:05:06", "2025-09-26 15:05:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("561", "230", "action complete via WP Cron", "2025-09-26 15:05:06", "2025-09-26 15:05:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("562", "233", "action created", "2025-09-26 15:05:06", "2025-09-26 15:05:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("563", "231", "action started via WP Cron", "2025-09-26 15:05:06", "2025-09-26 15:05:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("564", "231", "action complete via WP Cron", "2025-09-26 15:05:06", "2025-09-26 15:05:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("565", "234", "action created", "2025-09-26 15:05:06", "2025-09-26 15:05:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("566", "232", "action started via WP Cron", "2025-09-26 15:05:06", "2025-09-26 15:05:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("567", "232", "action complete via WP Cron", "2025-09-26 15:05:06", "2025-09-26 15:05:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("568", "235", "action created", "2025-09-26 15:05:06", "2025-09-26 15:05:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("569", "214", "action started via WP Cron", "2025-09-26 20:54:44", "2025-09-26 20:54:44");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("570", "214", "action complete via WP Cron", "2025-09-26 20:54:44", "2025-09-26 20:54:44");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("571", "236", "action created", "2025-09-26 20:54:44", "2025-09-26 20:54:44");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("572", "233", "action started via WP Cron", "2025-09-27 15:13:32", "2025-09-27 15:13:32");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("573", "233", "action complete via WP Cron", "2025-09-27 15:13:32", "2025-09-27 15:13:32");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("574", "237", "action created", "2025-09-27 15:13:32", "2025-09-27 15:13:32");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("575", "234", "action started via WP Cron", "2025-09-27 15:13:32", "2025-09-27 15:13:32");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("576", "234", "action complete via WP Cron", "2025-09-27 15:13:32", "2025-09-27 15:13:32");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("577", "238", "action created", "2025-09-27 15:13:32", "2025-09-27 15:13:32");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("578", "235", "action started via WP Cron", "2025-09-27 15:13:32", "2025-09-27 15:13:32");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("579", "235", "action complete via WP Cron", "2025-09-27 15:13:32", "2025-09-27 15:13:32");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("580", "239", "action created", "2025-09-27 15:13:32", "2025-09-27 15:13:32");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("581", "237", "action started via WP Cron", "2025-09-28 15:44:08", "2025-09-28 15:44:08");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("582", "237", "action complete via WP Cron", "2025-09-28 15:44:08", "2025-09-28 15:44:08");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("583", "240", "action created", "2025-09-28 15:44:08", "2025-09-28 15:44:08");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("584", "238", "action started via WP Cron", "2025-09-28 15:44:08", "2025-09-28 15:44:08");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("585", "238", "action complete via WP Cron", "2025-09-28 15:44:08", "2025-09-28 15:44:08");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("586", "241", "action created", "2025-09-28 15:44:08", "2025-09-28 15:44:08");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("587", "239", "action started via WP Cron", "2025-09-28 15:44:08", "2025-09-28 15:44:08");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("588", "239", "action complete via WP Cron", "2025-09-28 15:44:08", "2025-09-28 15:44:08");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("589", "242", "action created", "2025-09-28 15:44:08", "2025-09-28 15:44:08");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("590", "240", "action started via WP Cron", "2025-09-29 15:53:06", "2025-09-29 15:53:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("591", "240", "action complete via WP Cron", "2025-09-29 15:53:06", "2025-09-29 15:53:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("592", "243", "action created", "2025-09-29 15:53:06", "2025-09-29 15:53:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("593", "241", "action started via WP Cron", "2025-09-29 15:53:06", "2025-09-29 15:53:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("594", "241", "action complete via WP Cron", "2025-09-29 15:53:06", "2025-09-29 15:53:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("595", "244", "action created", "2025-09-29 15:53:06", "2025-09-29 15:53:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("596", "242", "action started via WP Cron", "2025-09-29 15:53:06", "2025-09-29 15:53:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("597", "242", "action complete via WP Cron", "2025-09-29 15:53:06", "2025-09-29 15:53:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("598", "245", "action created", "2025-09-29 15:53:06", "2025-09-29 15:53:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("599", "243", "action started via WP Cron", "2025-09-30 17:08:24", "2025-09-30 17:08:24");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("600", "243", "action complete via WP Cron", "2025-09-30 17:08:24", "2025-09-30 17:08:24");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("601", "246", "action created", "2025-09-30 17:08:24", "2025-09-30 17:08:24");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("602", "244", "action started via WP Cron", "2025-09-30 17:08:24", "2025-09-30 17:08:24");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("603", "244", "action complete via WP Cron", "2025-09-30 17:08:24", "2025-09-30 17:08:24");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("604", "247", "action created", "2025-09-30 17:08:24", "2025-09-30 17:08:24");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("605", "245", "action started via WP Cron", "2025-09-30 17:08:24", "2025-09-30 17:08:24");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("606", "245", "action complete via WP Cron", "2025-09-30 17:08:24", "2025-09-30 17:08:24");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("607", "248", "action created", "2025-09-30 17:08:24", "2025-09-30 17:08:24");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("608", "246", "action started via WP Cron", "2025-10-01 17:23:51", "2025-10-01 17:23:51");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("609", "246", "action complete via WP Cron", "2025-10-01 17:23:51", "2025-10-01 17:23:51");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("610", "249", "action created", "2025-10-01 17:23:51", "2025-10-01 17:23:51");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("611", "247", "action started via WP Cron", "2025-10-01 17:23:51", "2025-10-01 17:23:51");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("612", "247", "action complete via WP Cron", "2025-10-01 17:23:51", "2025-10-01 17:23:51");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("613", "250", "action created", "2025-10-01 17:23:51", "2025-10-01 17:23:51");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("614", "248", "action started via WP Cron", "2025-10-01 17:23:51", "2025-10-01 17:23:51");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("615", "248", "action complete via WP Cron", "2025-10-01 17:23:51", "2025-10-01 17:23:51");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("616", "251", "action created", "2025-10-01 17:23:51", "2025-10-01 17:23:51");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("617", "249", "action started via WP Cron", "2025-10-02 17:24:54", "2025-10-02 17:24:54");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("618", "249", "action complete via WP Cron", "2025-10-02 17:24:54", "2025-10-02 17:24:54");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("619", "252", "action created", "2025-10-02 17:24:54", "2025-10-02 17:24:54");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("620", "250", "action started via WP Cron", "2025-10-02 17:24:54", "2025-10-02 17:24:54");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("621", "250", "action complete via WP Cron", "2025-10-02 17:24:54", "2025-10-02 17:24:54");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("622", "253", "action created", "2025-10-02 17:24:54", "2025-10-02 17:24:54");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("623", "251", "action started via WP Cron", "2025-10-02 17:24:54", "2025-10-02 17:24:54");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("624", "251", "action complete via WP Cron", "2025-10-02 17:24:54", "2025-10-02 17:24:54");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("625", "254", "action created", "2025-10-02 17:24:54", "2025-10-02 17:24:54");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("626", "252", "action started via WP Cron", "2025-10-03 17:27:57", "2025-10-03 17:27:57");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("627", "252", "action complete via WP Cron", "2025-10-03 17:27:57", "2025-10-03 17:27:57");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("628", "255", "action created", "2025-10-03 17:27:57", "2025-10-03 17:27:57");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("629", "253", "action started via WP Cron", "2025-10-03 17:27:57", "2025-10-03 17:27:57");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("630", "253", "action complete via WP Cron", "2025-10-03 17:27:57", "2025-10-03 17:27:57");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("631", "256", "action created", "2025-10-03 17:27:57", "2025-10-03 17:27:57");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("632", "254", "action started via WP Cron", "2025-10-03 17:27:57", "2025-10-03 17:27:57");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("633", "254", "action complete via WP Cron", "2025-10-03 17:27:57", "2025-10-03 17:27:57");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("634", "257", "action created", "2025-10-03 17:27:57", "2025-10-03 17:27:57");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("635", "236", "action started via WP Cron", "2025-10-03 21:00:24", "2025-10-03 21:00:24");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("636", "236", "action complete via WP Cron", "2025-10-03 21:00:24", "2025-10-03 21:00:24");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("637", "258", "action created", "2025-10-03 21:00:24", "2025-10-03 21:00:24");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("638", "255", "action started via WP Cron", "2025-10-04 17:45:38", "2025-10-04 17:45:38");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("639", "255", "action complete via WP Cron", "2025-10-04 17:45:38", "2025-10-04 17:45:38");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("640", "259", "action created", "2025-10-04 17:45:38", "2025-10-04 17:45:38");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("641", "256", "action started via WP Cron", "2025-10-04 17:45:38", "2025-10-04 17:45:38");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("642", "256", "action complete via WP Cron", "2025-10-04 17:45:38", "2025-10-04 17:45:38");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("643", "260", "action created", "2025-10-04 17:45:38", "2025-10-04 17:45:38");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("644", "257", "action started via WP Cron", "2025-10-04 17:45:38", "2025-10-04 17:45:38");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("645", "257", "action complete via WP Cron", "2025-10-04 17:45:38", "2025-10-04 17:45:38");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("646", "261", "action created", "2025-10-04 17:45:38", "2025-10-04 17:45:38");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("647", "259", "action started via WP Cron", "2025-10-05 17:46:42", "2025-10-05 17:46:42");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("648", "259", "action complete via WP Cron", "2025-10-05 17:46:42", "2025-10-05 17:46:42");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("649", "262", "action created", "2025-10-05 17:46:42", "2025-10-05 17:46:42");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("650", "260", "action started via WP Cron", "2025-10-05 17:46:42", "2025-10-05 17:46:42");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("651", "260", "action complete via WP Cron", "2025-10-05 17:46:42", "2025-10-05 17:46:42");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("652", "263", "action created", "2025-10-05 17:46:42", "2025-10-05 17:46:42");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("653", "261", "action started via WP Cron", "2025-10-05 17:46:42", "2025-10-05 17:46:42");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("654", "261", "action complete via WP Cron", "2025-10-05 17:46:42", "2025-10-05 17:46:42");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("655", "264", "action created", "2025-10-05 17:46:42", "2025-10-05 17:46:42");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("656", "262", "action started via WP Cron", "2025-10-06 19:22:06", "2025-10-06 19:22:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("657", "262", "action complete via WP Cron", "2025-10-06 19:22:06", "2025-10-06 19:22:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("658", "265", "action created", "2025-10-06 19:22:06", "2025-10-06 19:22:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("659", "263", "action started via WP Cron", "2025-10-06 19:22:06", "2025-10-06 19:22:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("660", "263", "action complete via WP Cron", "2025-10-06 19:22:06", "2025-10-06 19:22:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("661", "266", "action created", "2025-10-06 19:22:06", "2025-10-06 19:22:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("662", "264", "action started via WP Cron", "2025-10-06 19:22:06", "2025-10-06 19:22:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("663", "264", "action complete via WP Cron", "2025-10-06 19:22:06", "2025-10-06 19:22:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("664", "267", "action created", "2025-10-06 19:22:06", "2025-10-06 19:22:06");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("665", "265", "action started via WP Cron", "2025-10-07 19:31:11", "2025-10-07 19:31:11");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("666", "265", "action complete via WP Cron", "2025-10-07 19:31:11", "2025-10-07 19:31:11");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("667", "268", "action created", "2025-10-07 19:31:11", "2025-10-07 19:31:11");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("668", "266", "action started via WP Cron", "2025-10-07 19:31:11", "2025-10-07 19:31:11");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("669", "266", "action complete via WP Cron", "2025-10-07 19:31:11", "2025-10-07 19:31:11");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("670", "269", "action created", "2025-10-07 19:31:11", "2025-10-07 19:31:11");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("671", "267", "action started via WP Cron", "2025-10-07 19:31:11", "2025-10-07 19:31:11");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("672", "267", "action complete via WP Cron", "2025-10-07 19:31:11", "2025-10-07 19:31:11");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("673", "270", "action created", "2025-10-07 19:31:11", "2025-10-07 19:31:11");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("674", "268", "action started via WP Cron", "2025-10-08 20:13:59", "2025-10-08 20:13:59");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("675", "268", "action complete via WP Cron", "2025-10-08 20:13:59", "2025-10-08 20:13:59");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("676", "271", "action created", "2025-10-08 20:13:59", "2025-10-08 20:13:59");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("677", "269", "action started via WP Cron", "2025-10-08 20:13:59", "2025-10-08 20:13:59");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("678", "269", "action complete via WP Cron", "2025-10-08 20:13:59", "2025-10-08 20:13:59");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("679", "272", "action created", "2025-10-08 20:13:59", "2025-10-08 20:13:59");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("680", "270", "action started via WP Cron", "2025-10-08 20:13:59", "2025-10-08 20:13:59");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("681", "270", "action complete via WP Cron", "2025-10-08 20:13:59", "2025-10-08 20:13:59");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("682", "273", "action created", "2025-10-08 20:13:59", "2025-10-08 20:13:59");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("683", "271", "action started via WP Cron", "2025-10-09 20:25:55", "2025-10-09 20:25:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("684", "271", "action complete via WP Cron", "2025-10-09 20:25:55", "2025-10-09 20:25:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("685", "274", "action created", "2025-10-09 20:25:55", "2025-10-09 20:25:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("686", "272", "action started via WP Cron", "2025-10-09 20:25:55", "2025-10-09 20:25:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("687", "272", "action complete via WP Cron", "2025-10-09 20:25:55", "2025-10-09 20:25:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("688", "275", "action created", "2025-10-09 20:25:55", "2025-10-09 20:25:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("689", "273", "action started via WP Cron", "2025-10-09 20:25:55", "2025-10-09 20:25:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("690", "273", "action complete via WP Cron", "2025-10-09 20:25:55", "2025-10-09 20:25:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("691", "276", "action created", "2025-10-09 20:25:55", "2025-10-09 20:25:55");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("692", "277", "action created", "2025-10-10 13:06:28", "2025-10-10 13:06:28");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("693", "278", "action created", "2025-10-10 13:06:39", "2025-10-10 13:06:39");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("694", "279", "action created", "2025-10-10 13:06:39", "2025-10-10 13:06:39");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("695", "277", "action started via WP Cron", "2025-10-10 13:07:33", "2025-10-10 13:07:33");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("696", "277", "action complete via WP Cron", "2025-10-10 13:07:33", "2025-10-10 13:07:33");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("697", "280", "action created", "2025-10-10 13:49:07", "2025-10-10 13:49:07");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("698", "281", "action created", "2025-10-10 13:50:15", "2025-10-10 13:50:15");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("699", "282", "action created", "2025-10-10 13:50:15", "2025-10-10 13:50:15");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("700", "283", "action created", "2025-10-10 13:50:15", "2025-10-10 13:50:15");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("701", "284", "action created", "2025-10-10 13:50:15", "2025-10-10 13:50:15");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("702", "280", "action started via WP Cron", "2025-10-10 13:50:24", "2025-10-10 13:50:24");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("703", "280", "action complete via WP Cron", "2025-10-10 13:50:24", "2025-10-10 13:50:24");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("704", "281", "action started via WP Cron", "2025-10-10 13:50:24", "2025-10-10 13:50:24");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("705", "281", "action complete via WP Cron", "2025-10-10 13:50:24", "2025-10-10 13:50:24");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("707", "282", "action started via WP Cron", "2025-10-10 13:50:24", "2025-10-10 13:50:24");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("708", "282", "action complete via WP Cron", "2025-10-10 13:50:24", "2025-10-10 13:50:24");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("710", "283", "action started via WP Cron", "2025-10-10 13:50:24", "2025-10-10 13:50:24");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("711", "283", "action complete via WP Cron", "2025-10-10 13:50:25", "2025-10-10 13:50:25");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("713", "284", "action started via WP Cron", "2025-10-10 13:50:25", "2025-10-10 13:50:25");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("714", "284", "action complete via WP Cron", "2025-10-10 13:50:25", "2025-10-10 13:50:25");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("716", "289", "action created", "2025-10-10 13:55:33", "2025-10-10 13:55:33");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("725", "289", "action started via WP Cron", "2025-10-10 13:57:28", "2025-10-10 13:57:28");
INSERT INTO `wor4890_actionscheduler_logs` VALUES("726", "289", "action complete via WP Cron", "2025-10-10 13:57:28", "2025-10-10 13:57:28");

/* INSERT TABLE DATA: wor4890_comments */
INSERT INTO `wor4890_comments` VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2025-03-25 23:50:31", "2025-03-25 23:50:31", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wor4890_duplicator_packages */
INSERT INTO `wor4890_duplicator_packages` VALUES("1", "20251010_mangoknow", "d1938e4742cb175a2848_20251010153009", "-1", "2025-10-10 15:30:44", "M4ngoKn0w", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-10 15:30:09\";s:7:\"Version\";s:8:\"1.5.13.3\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.43\";s:10:\"VersionPHP\";s:6:\"8.4.10\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:18:\"20251010_mangoknow\";s:4:\"Hash\";s:35:\"d1938e4742cb175a2848_20251010153009\";s:8:\"NameHash\";s:54:\"20251010_mangoknow_d1938e4742cb175a2848_20251010153009\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:64:\"20251010_mangoknow_d1938e4742cb175a2848_20251010153009_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"-1.0\";s:6:\"WPUser\";s:9:\"M4ngoKn0w\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:66:\"20251010_mangoknow_d1938e4742cb175a2848_20251010153009_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:23:\"/home/mangokm/MangoKnow\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1557;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11728;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-10 15:30:09\";s:7:\"Version\";s:8:\"1.5.13.3\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.43\";s:10:\"VersionPHP\";s:6:\"8.4.10\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:18:\"20251010_mangoknow\";s:4:\"Hash\";s:35:\"d1938e4742cb175a2848_20251010153009\";s:8:\"NameHash\";s:54:\"20251010_mangoknow_d1938e4742cb175a2848_20251010153009\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:72:\"20251010_mangoknow_d1938e4742cb175a2848_20251010153009_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:37:\"/home/mangokm/MangoKnow/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:67:\"20251010_mangoknow_d1938e4742cb175a2848_20251010153009_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:55:\"Percona Server (GPL), Release \'34\', Revision \'e2841f91\'\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:123:\"/home/mangokm/MangoKnow/wp-content/backups-dup-lite/tmp/20251010_mangoknow_d1938e4742cb175a2848_20251010153009_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:32:\"/home/mangokm/MangoKnow/wp-admin\";i:1;s:35:\"/home/mangokm/MangoKnow/wp-includes\";i:2;s:44:\"/home/mangokm/MangoKnow/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:23:\"/home/mangokm/MangoKnow\";i:1;s:23:\"/home/mangokm/MangoKnow\";i:2;s:34:\"/home/mangokm/MangoKnow/wp-content\";i:3;s:42:\"/home/mangokm/MangoKnow/wp-content/uploads\";i:4;s:42:\"/home/mangokm/MangoKnow/wp-content/plugins\";i:5;s:45:\"/home/mangokm/MangoKnow/wp-content/mu-plugins\";i:6;s:41:\"/home/mangokm/MangoKnow/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:55:\"/home/mangokm/MangoKnow/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");
INSERT INTO `wor4890_duplicator_packages` VALUES("2", "20251010_mangoknow", "2729d61ccb91770f5100_20251010153222", "21", "2025-10-10 15:32:36", "M4ngoKn0w", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-10 15:32:22\";s:7:\"Version\";s:8:\"1.5.13.3\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.43\";s:10:\"VersionPHP\";s:6:\"8.4.10\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:2;s:4:\"Name\";s:18:\"20251010_mangoknow\";s:4:\"Hash\";s:35:\"2729d61ccb91770f5100_20251010153222\";s:8:\"NameHash\";s:54:\"20251010_mangoknow_2729d61ccb91770f5100_20251010153222\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:64:\"20251010_mangoknow_2729d61ccb91770f5100_20251010153222_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.3\";s:6:\"WPUser\";s:9:\"M4ngoKn0w\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:66:\"20251010_mangoknow_2729d61ccb91770f5100_20251010153222_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:23:\"/home/mangokm/MangoKnow\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1557;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11728;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-10 15:32:22\";s:7:\"Version\";s:8:\"1.5.13.3\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.43\";s:10:\"VersionPHP\";s:6:\"8.4.10\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:18:\"20251010_mangoknow\";s:4:\"Hash\";s:35:\"2729d61ccb91770f5100_20251010153222\";s:8:\"NameHash\";s:54:\"20251010_mangoknow_2729d61ccb91770f5100_20251010153222\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:72:\"20251010_mangoknow_2729d61ccb91770f5100_20251010153222_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:37:\"/home/mangokm/MangoKnow/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:67:\"20251010_mangoknow_2729d61ccb91770f5100_20251010153222_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:55:\"Percona Server (GPL), Release \'34\', Revision \'e2841f91\'\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:123:\"/home/mangokm/MangoKnow/wp-content/backups-dup-lite/tmp/20251010_mangoknow_2729d61ccb91770f5100_20251010153222_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:32:\"/home/mangokm/MangoKnow/wp-admin\";i:1;s:35:\"/home/mangokm/MangoKnow/wp-includes\";i:2;s:44:\"/home/mangokm/MangoKnow/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:23:\"/home/mangokm/MangoKnow\";i:1;s:23:\"/home/mangokm/MangoKnow\";i:2;s:34:\"/home/mangokm/MangoKnow/wp-content\";i:3;s:42:\"/home/mangokm/MangoKnow/wp-content/uploads\";i:4;s:42:\"/home/mangokm/MangoKnow/wp-content/plugins\";i:5;s:45:\"/home/mangokm/MangoKnow/wp-content/mu-plugins\";i:6;s:41:\"/home/mangokm/MangoKnow/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:55:\"/home/mangokm/MangoKnow/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wor4890_fbv */
INSERT INTO `wor4890_fbv` VALUES("1", "Stock Images", "0", "0", "0", "0");
INSERT INTO `wor4890_fbv` VALUES("2", "Logos", "0", "0", "1", "0");

/* INSERT TABLE DATA: wor4890_fbv_attachment_folder */
INSERT INTO `wor4890_fbv_attachment_folder` VALUES("1", "52");
INSERT INTO `wor4890_fbv_attachment_folder` VALUES("1", "54");
INSERT INTO `wor4890_fbv_attachment_folder` VALUES("2", "57");
INSERT INTO `wor4890_fbv_attachment_folder` VALUES("2", "58");
INSERT INTO `wor4890_fbv_attachment_folder` VALUES("2", "59");
INSERT INTO `wor4890_fbv_attachment_folder` VALUES("2", "60");

/* INSERT TABLE DATA: wor4890_options */
INSERT INTO `wor4890_options` VALUES("1", "siteurl", "http://mangoknow.com", "yes");
INSERT INTO `wor4890_options` VALUES("2", "home", "http://mangoknow.com", "yes");
INSERT INTO `wor4890_options` VALUES("3", "blogname", "Mango Know", "yes");
INSERT INTO `wor4890_options` VALUES("4", "blogdescription", "English Language Learning Resources", "yes");
INSERT INTO `wor4890_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wor4890_options` VALUES("6", "admin_email", "catfleetdesign@gmail.com", "yes");
INSERT INTO `wor4890_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wor4890_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wor4890_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wor4890_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wor4890_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wor4890_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wor4890_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wor4890_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wor4890_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wor4890_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wor4890_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wor4890_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wor4890_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wor4890_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wor4890_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wor4890_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wor4890_options` VALUES("23", "date_format", "j F Y", "yes");
INSERT INTO `wor4890_options` VALUES("24", "time_format", "H:i", "yes");
INSERT INTO `wor4890_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wor4890_options` VALUES("26", "comment_moderation", "", "yes");
INSERT INTO `wor4890_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wor4890_options` VALUES("28", "permalink_structure", "/index.php/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `wor4890_options` VALUES("29", "rewrite_rules", "a:118:{s:17:\"^serve-instawp/?$\";s:25:\"index.php?instawp_serve=1\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:57:\"index.php/category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:52:\"index.php/category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:33:\"index.php/category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:45:\"index.php/category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:27:\"index.php/category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:54:\"index.php/tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:49:\"index.php/tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:30:\"index.php/tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:42:\"index.php/tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:24:\"index.php/tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:55:\"index.php/type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:50:\"index.php/type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:31:\"index.php/type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:43:\"index.php/type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:25:\"index.php/type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:46:\"index.php/seedprod/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"index.php/seedprod/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"index.php/seedprod/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"index.php/seedprod/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"index.php/seedprod/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"index.php/seedprod/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"index.php/seedprod/([^/]+)/embed/?$\";s:41:\"index.php?seedprod=$matches[1]&embed=true\";s:39:\"index.php/seedprod/([^/]+)/trackback/?$\";s:35:\"index.php?seedprod=$matches[1]&tb=1\";s:47:\"index.php/seedprod/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?seedprod=$matches[1]&paged=$matches[2]\";s:54:\"index.php/seedprod/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?seedprod=$matches[1]&cpage=$matches[2]\";s:43:\"index.php/seedprod/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?seedprod=$matches[1]&page=$matches[2]\";s:35:\"index.php/seedprod/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"index.php/seedprod/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"index.php/seedprod/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"index.php/seedprod/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"index.php/seedprod/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"index.php/seedprod/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:42:\"index.php/feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:37:\"index.php/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:18:\"index.php/embed/?$\";s:21:\"index.php?&embed=true\";s:30:\"index.php/page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:37:\"index.php/comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=20&cpage=$matches[1]\";s:45:\"index.php/instawp-database-manager(/(.*))?/?$\";s:47:\"index.php?&instawp-database-manager=$matches[2]\";s:51:\"index.php/comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:46:\"index.php/comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:27:\"index.php/comments/embed/?$\";s:21:\"index.php?&embed=true\";s:54:\"index.php/search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:49:\"index.php/search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:30:\"index.php/search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:42:\"index.php/search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:24:\"index.php/search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:57:\"index.php/author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:52:\"index.php/author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:33:\"index.php/author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:45:\"index.php/author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:27:\"index.php/author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:79:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:74:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:55:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:67:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:49:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:66:\"index.php/([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:61:\"index.php/([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:42:\"index.php/([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:54:\"index.php/([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:36:\"index.php/([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:53:\"index.php/([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:48:\"index.php/([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:29:\"index.php/([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:41:\"index.php/([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:23:\"index.php/([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:68:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:78:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:98:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:93:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:93:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:74:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:63:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:67:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:87:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:82:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:75:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:82:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:71:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:57:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:67:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:87:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:82:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:82:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:63:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:74:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:61:\"index.php/([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:48:\"index.php/([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:37:\"index.php/.?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"index.php/.?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"index.php/.?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"index.php/.?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"index.php/.?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"index.php/.?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"index.php/(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:30:\"index.php/(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:50:\"index.php/(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:45:\"index.php/(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:38:\"index.php/(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:45:\"index.php/(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:53:\"index.php/(.?.+?)/instawp-database-manager(/(.*))?/?$\";s:67:\"index.php?pagename=$matches[1]&instawp-database-manager=$matches[3]\";s:34:\"index.php/(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `wor4890_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wor4890_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wor4890_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wor4890_options` VALUES("33", "active_plugins", "a:6:{i:0;s:27:\"coming-soon/coming-soon.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:21:\"filebird/filebird.php\";i:3;s:27:\"updraftplus/updraftplus.php\";i:4;s:23:\"wordfence/wordfence.php\";i:5;s:24:\"wpforms-lite/wpforms.php\";}", "yes");
INSERT INTO `wor4890_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wor4890_options` VALUES("35", "ping_sites", "https://rpc.pingomatic.com/", "yes");
INSERT INTO `wor4890_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wor4890_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wor4890_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wor4890_options` VALUES("39", "recently_edited", "a:3:{i:0;s:79:\"/home/mangokm/MangoKnow/wp-content/themes/mango-know-hestia-child/functions.php\";i:2;s:75:\"/home/mangokm/MangoKnow/wp-content/themes/mango-know-hestia-child/style.css\";i:3;s:0:\"\";}", "no");
INSERT INTO `wor4890_options` VALUES("40", "template", "hestia", "yes");
INSERT INTO `wor4890_options` VALUES("41", "stylesheet", "mango-know-hestia-child", "yes");
INSERT INTO `wor4890_options` VALUES("42", "comment_registration", "1", "yes");
INSERT INTO `wor4890_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wor4890_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wor4890_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wor4890_options` VALUES("46", "db_version", "60421", "yes");
INSERT INTO `wor4890_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wor4890_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wor4890_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wor4890_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wor4890_options` VALUES("51", "show_on_front", "page", "on");
INSERT INTO `wor4890_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wor4890_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wor4890_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wor4890_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wor4890_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wor4890_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wor4890_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wor4890_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wor4890_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wor4890_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wor4890_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wor4890_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wor4890_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wor4890_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wor4890_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wor4890_options` VALUES("67", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wor4890_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wor4890_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wor4890_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wor4890_options` VALUES("71", "page_comments", "", "yes");
INSERT INTO `wor4890_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wor4890_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wor4890_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wor4890_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wor4890_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wor4890_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wor4890_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wor4890_options` VALUES("79", "uninstall_plugins", "a:0:{}", "no");
INSERT INTO `wor4890_options` VALUES("80", "timezone_string", "", "yes");
INSERT INTO `wor4890_options` VALUES("81", "page_for_posts", "22", "on");
INSERT INTO `wor4890_options` VALUES("82", "page_on_front", "20", "on");
INSERT INTO `wor4890_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wor4890_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wor4890_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wor4890_options` VALUES("86", "site_icon", "60", "on");
INSERT INTO `wor4890_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wor4890_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wor4890_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wor4890_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wor4890_options` VALUES("91", "admin_email_lifespan", "1775653586", "yes");
INSERT INTO `wor4890_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wor4890_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wor4890_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wor4890_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wor4890_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wor4890_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wor4890_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "off");
INSERT INTO `wor4890_options` VALUES("99", "initial_db_version", "51917", "yes");
INSERT INTO `wor4890_options` VALUES("100", "wor4890_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:64:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `wor4890_options` VALUES("101", "fresh_site", "0", "off");
INSERT INTO `wor4890_options` VALUES("102", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor4890_options` VALUES("103", "sidebars_widgets", "a:11:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:9:\"sidebar-1\";a:0:{}s:17:\"subscribe-widgets\";a:0:{}s:19:\"sidebar-woocommerce\";a:0:{}s:15:\"sidebar-top-bar\";a:0:{}s:14:\"header-sidebar\";a:0:{}s:17:\"sidebar-big-title\";a:0:{}s:18:\"footer-one-widgets\";a:0:{}s:18:\"footer-two-widgets\";a:0:{}s:20:\"footer-three-widgets\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wor4890_options` VALUES("104", "cron", "a:20:{i:1760110403;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1760111432;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1760112307;a:1:{s:21:\"wordfence_ls_ntp_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1760112871;a:1:{s:26:\"wordfence_daily_autoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1760112886;a:2:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1760116698;a:1:{s:33:\"updraftplus_clean_temporary_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1760118842;a:2:{s:25:\"filebird_remove_zip_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:28:\"filebird_every_12_hours_jobs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1760140232;a:4:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1760141029;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1760141030;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1760141135;a:1:{s:22:\"seedprod_notifications\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1760159931;a:2:{s:14:\"updraft_backup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:23:\"updraft_backup_database\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1760313600;a:2:{s:28:\"wpforms_email_summaries_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}s:33:\"wpforms_weekly_entries_count_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1760330968;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"ee43e5be6922991fd9fdf67c9a84d221\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1760330968;}}}}i:1760371200;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1760486660;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1760486735;a:1:{s:29:\"seedprod_lite_fetch_help_docs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1760572232;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1760590168;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"ec2039b90f12d657a0edfc5099706fbd\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1760590168;}}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wor4890_options` VALUES("105", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor4890_options` VALUES("106", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor4890_options` VALUES("107", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor4890_options` VALUES("108", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor4890_options` VALUES("109", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor4890_options` VALUES("110", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor4890_options` VALUES("111", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor4890_options` VALUES("112", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor4890_options` VALUES("113", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor4890_options` VALUES("114", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor4890_options` VALUES("115", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor4890_options` VALUES("116", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wor4890_options` VALUES("118", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wor4890_options` VALUES("121", "theme_mods_twentytwentytwo", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1753720956;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wor4890_options` VALUES("124", "https_detection_errors", "a:0:{}", "off");
INSERT INTO `wor4890_options` VALUES("132", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wor4890_options` VALUES("133", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wor4890_options` VALUES("134", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:5:\"6.8.2\";s:5:\"files\";a:536:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:26:\"post-content/style-rtl.css\";i:309;s:30:\"post-content/style-rtl.min.css\";i:310;s:22:\"post-content/style.css\";i:311;s:26:\"post-content/style.min.css\";i:312;s:23:\"post-date/style-rtl.css\";i:313;s:27:\"post-date/style-rtl.min.css\";i:314;s:19:\"post-date/style.css\";i:315;s:23:\"post-date/style.min.css\";i:316;s:27:\"post-excerpt/editor-rtl.css\";i:317;s:31:\"post-excerpt/editor-rtl.min.css\";i:318;s:23:\"post-excerpt/editor.css\";i:319;s:27:\"post-excerpt/editor.min.css\";i:320;s:26:\"post-excerpt/style-rtl.css\";i:321;s:30:\"post-excerpt/style-rtl.min.css\";i:322;s:22:\"post-excerpt/style.css\";i:323;s:26:\"post-excerpt/style.min.css\";i:324;s:34:\"post-featured-image/editor-rtl.css\";i:325;s:38:\"post-featured-image/editor-rtl.min.css\";i:326;s:30:\"post-featured-image/editor.css\";i:327;s:34:\"post-featured-image/editor.min.css\";i:328;s:33:\"post-featured-image/style-rtl.css\";i:329;s:37:\"post-featured-image/style-rtl.min.css\";i:330;s:29:\"post-featured-image/style.css\";i:331;s:33:\"post-featured-image/style.min.css\";i:332;s:34:\"post-navigation-link/style-rtl.css\";i:333;s:38:\"post-navigation-link/style-rtl.min.css\";i:334;s:30:\"post-navigation-link/style.css\";i:335;s:34:\"post-navigation-link/style.min.css\";i:336;s:27:\"post-template/style-rtl.css\";i:337;s:31:\"post-template/style-rtl.min.css\";i:338;s:23:\"post-template/style.css\";i:339;s:27:\"post-template/style.min.css\";i:340;s:24:\"post-terms/style-rtl.css\";i:341;s:28:\"post-terms/style-rtl.min.css\";i:342;s:20:\"post-terms/style.css\";i:343;s:24:\"post-terms/style.min.css\";i:344;s:24:\"post-title/style-rtl.css\";i:345;s:28:\"post-title/style-rtl.min.css\";i:346;s:20:\"post-title/style.css\";i:347;s:24:\"post-title/style.min.css\";i:348;s:26:\"preformatted/style-rtl.css\";i:349;s:30:\"preformatted/style-rtl.min.css\";i:350;s:22:\"preformatted/style.css\";i:351;s:26:\"preformatted/style.min.css\";i:352;s:24:\"pullquote/editor-rtl.css\";i:353;s:28:\"pullquote/editor-rtl.min.css\";i:354;s:20:\"pullquote/editor.css\";i:355;s:24:\"pullquote/editor.min.css\";i:356;s:23:\"pullquote/style-rtl.css\";i:357;s:27:\"pullquote/style-rtl.min.css\";i:358;s:19:\"pullquote/style.css\";i:359;s:23:\"pullquote/style.min.css\";i:360;s:23:\"pullquote/theme-rtl.css\";i:361;s:27:\"pullquote/theme-rtl.min.css\";i:362;s:19:\"pullquote/theme.css\";i:363;s:23:\"pullquote/theme.min.css\";i:364;s:39:\"query-pagination-numbers/editor-rtl.css\";i:365;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:366;s:35:\"query-pagination-numbers/editor.css\";i:367;s:39:\"query-pagination-numbers/editor.min.css\";i:368;s:31:\"query-pagination/editor-rtl.css\";i:369;s:35:\"query-pagination/editor-rtl.min.css\";i:370;s:27:\"query-pagination/editor.css\";i:371;s:31:\"query-pagination/editor.min.css\";i:372;s:30:\"query-pagination/style-rtl.css\";i:373;s:34:\"query-pagination/style-rtl.min.css\";i:374;s:26:\"query-pagination/style.css\";i:375;s:30:\"query-pagination/style.min.css\";i:376;s:25:\"query-title/style-rtl.css\";i:377;s:29:\"query-title/style-rtl.min.css\";i:378;s:21:\"query-title/style.css\";i:379;s:25:\"query-title/style.min.css\";i:380;s:25:\"query-total/style-rtl.css\";i:381;s:29:\"query-total/style-rtl.min.css\";i:382;s:21:\"query-total/style.css\";i:383;s:25:\"query-total/style.min.css\";i:384;s:20:\"query/editor-rtl.css\";i:385;s:24:\"query/editor-rtl.min.css\";i:386;s:16:\"query/editor.css\";i:387;s:20:\"query/editor.min.css\";i:388;s:19:\"quote/style-rtl.css\";i:389;s:23:\"quote/style-rtl.min.css\";i:390;s:15:\"quote/style.css\";i:391;s:19:\"quote/style.min.css\";i:392;s:19:\"quote/theme-rtl.css\";i:393;s:23:\"quote/theme-rtl.min.css\";i:394;s:15:\"quote/theme.css\";i:395;s:19:\"quote/theme.min.css\";i:396;s:23:\"read-more/style-rtl.css\";i:397;s:27:\"read-more/style-rtl.min.css\";i:398;s:19:\"read-more/style.css\";i:399;s:23:\"read-more/style.min.css\";i:400;s:18:\"rss/editor-rtl.css\";i:401;s:22:\"rss/editor-rtl.min.css\";i:402;s:14:\"rss/editor.css\";i:403;s:18:\"rss/editor.min.css\";i:404;s:17:\"rss/style-rtl.css\";i:405;s:21:\"rss/style-rtl.min.css\";i:406;s:13:\"rss/style.css\";i:407;s:17:\"rss/style.min.css\";i:408;s:21:\"search/editor-rtl.css\";i:409;s:25:\"search/editor-rtl.min.css\";i:410;s:17:\"search/editor.css\";i:411;s:21:\"search/editor.min.css\";i:412;s:20:\"search/style-rtl.css\";i:413;s:24:\"search/style-rtl.min.css\";i:414;s:16:\"search/style.css\";i:415;s:20:\"search/style.min.css\";i:416;s:20:\"search/theme-rtl.css\";i:417;s:24:\"search/theme-rtl.min.css\";i:418;s:16:\"search/theme.css\";i:419;s:20:\"search/theme.min.css\";i:420;s:24:\"separator/editor-rtl.css\";i:421;s:28:\"separator/editor-rtl.min.css\";i:422;s:20:\"separator/editor.css\";i:423;s:24:\"separator/editor.min.css\";i:424;s:23:\"separator/style-rtl.css\";i:425;s:27:\"separator/style-rtl.min.css\";i:426;s:19:\"separator/style.css\";i:427;s:23:\"separator/style.min.css\";i:428;s:23:\"separator/theme-rtl.css\";i:429;s:27:\"separator/theme-rtl.min.css\";i:430;s:19:\"separator/theme.css\";i:431;s:23:\"separator/theme.min.css\";i:432;s:24:\"shortcode/editor-rtl.css\";i:433;s:28:\"shortcode/editor-rtl.min.css\";i:434;s:20:\"shortcode/editor.css\";i:435;s:24:\"shortcode/editor.min.css\";i:436;s:24:\"site-logo/editor-rtl.css\";i:437;s:28:\"site-logo/editor-rtl.min.css\";i:438;s:20:\"site-logo/editor.css\";i:439;s:24:\"site-logo/editor.min.css\";i:440;s:23:\"site-logo/style-rtl.css\";i:441;s:27:\"site-logo/style-rtl.min.css\";i:442;s:19:\"site-logo/style.css\";i:443;s:23:\"site-logo/style.min.css\";i:444;s:27:\"site-tagline/editor-rtl.css\";i:445;s:31:\"site-tagline/editor-rtl.min.css\";i:446;s:23:\"site-tagline/editor.css\";i:447;s:27:\"site-tagline/editor.min.css\";i:448;s:26:\"site-tagline/style-rtl.css\";i:449;s:30:\"site-tagline/style-rtl.min.css\";i:450;s:22:\"site-tagline/style.css\";i:451;s:26:\"site-tagline/style.min.css\";i:452;s:25:\"site-title/editor-rtl.css\";i:453;s:29:\"site-title/editor-rtl.min.css\";i:454;s:21:\"site-title/editor.css\";i:455;s:25:\"site-title/editor.min.css\";i:456;s:24:\"site-title/style-rtl.css\";i:457;s:28:\"site-title/style-rtl.min.css\";i:458;s:20:\"site-title/style.css\";i:459;s:24:\"site-title/style.min.css\";i:460;s:26:\"social-link/editor-rtl.css\";i:461;s:30:\"social-link/editor-rtl.min.css\";i:462;s:22:\"social-link/editor.css\";i:463;s:26:\"social-link/editor.min.css\";i:464;s:27:\"social-links/editor-rtl.css\";i:465;s:31:\"social-links/editor-rtl.min.css\";i:466;s:23:\"social-links/editor.css\";i:467;s:27:\"social-links/editor.min.css\";i:468;s:26:\"social-links/style-rtl.css\";i:469;s:30:\"social-links/style-rtl.min.css\";i:470;s:22:\"social-links/style.css\";i:471;s:26:\"social-links/style.min.css\";i:472;s:21:\"spacer/editor-rtl.css\";i:473;s:25:\"spacer/editor-rtl.min.css\";i:474;s:17:\"spacer/editor.css\";i:475;s:21:\"spacer/editor.min.css\";i:476;s:20:\"spacer/style-rtl.css\";i:477;s:24:\"spacer/style-rtl.min.css\";i:478;s:16:\"spacer/style.css\";i:479;s:20:\"spacer/style.min.css\";i:480;s:20:\"table/editor-rtl.css\";i:481;s:24:\"table/editor-rtl.min.css\";i:482;s:16:\"table/editor.css\";i:483;s:20:\"table/editor.min.css\";i:484;s:19:\"table/style-rtl.css\";i:485;s:23:\"table/style-rtl.min.css\";i:486;s:15:\"table/style.css\";i:487;s:19:\"table/style.min.css\";i:488;s:19:\"table/theme-rtl.css\";i:489;s:23:\"table/theme-rtl.min.css\";i:490;s:15:\"table/theme.css\";i:491;s:19:\"table/theme.min.css\";i:492;s:24:\"tag-cloud/editor-rtl.css\";i:493;s:28:\"tag-cloud/editor-rtl.min.css\";i:494;s:20:\"tag-cloud/editor.css\";i:495;s:24:\"tag-cloud/editor.min.css\";i:496;s:23:\"tag-cloud/style-rtl.css\";i:497;s:27:\"tag-cloud/style-rtl.min.css\";i:498;s:19:\"tag-cloud/style.css\";i:499;s:23:\"tag-cloud/style.min.css\";i:500;s:28:\"template-part/editor-rtl.css\";i:501;s:32:\"template-part/editor-rtl.min.css\";i:502;s:24:\"template-part/editor.css\";i:503;s:28:\"template-part/editor.min.css\";i:504;s:27:\"template-part/theme-rtl.css\";i:505;s:31:\"template-part/theme-rtl.min.css\";i:506;s:23:\"template-part/theme.css\";i:507;s:27:\"template-part/theme.min.css\";i:508;s:30:\"term-description/style-rtl.css\";i:509;s:34:\"term-description/style-rtl.min.css\";i:510;s:26:\"term-description/style.css\";i:511;s:30:\"term-description/style.min.css\";i:512;s:27:\"text-columns/editor-rtl.css\";i:513;s:31:\"text-columns/editor-rtl.min.css\";i:514;s:23:\"text-columns/editor.css\";i:515;s:27:\"text-columns/editor.min.css\";i:516;s:26:\"text-columns/style-rtl.css\";i:517;s:30:\"text-columns/style-rtl.min.css\";i:518;s:22:\"text-columns/style.css\";i:519;s:26:\"text-columns/style.min.css\";i:520;s:19:\"verse/style-rtl.css\";i:521;s:23:\"verse/style-rtl.min.css\";i:522;s:15:\"verse/style.css\";i:523;s:19:\"verse/style.min.css\";i:524;s:20:\"video/editor-rtl.css\";i:525;s:24:\"video/editor-rtl.min.css\";i:526;s:16:\"video/editor.css\";i:527;s:20:\"video/editor.min.css\";i:528;s:19:\"video/style-rtl.css\";i:529;s:23:\"video/style-rtl.min.css\";i:530;s:15:\"video/style.css\";i:531;s:19:\"video/style.min.css\";i:532;s:19:\"video/theme-rtl.css\";i:533;s:23:\"video/theme-rtl.min.css\";i:534;s:15:\"video/theme.css\";i:535;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `wor4890_options` VALUES("137", "wp_attachment_pages_enabled", "1", "on");
INSERT INTO `wor4890_options` VALUES("138", "user_count", "1", "off");
INSERT INTO `wor4890_options` VALUES("139", "db_upgraded", "", "on");
INSERT INTO `wor4890_options` VALUES("146", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:24:\"catfleetdesign@gmail.com\";s:7:\"version\";s:5:\"6.8.3\";s:9:\"timestamp\";i:1759277776;}", "off");
INSERT INTO `wor4890_options` VALUES("147", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"37b6ddafaa9c815c815f2fa3a93c6165\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:0:\"\";s:12:\"core/columns\";s:0:\"\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `wor4890_options` VALUES("168", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `wor4890_options` VALUES("169", "recently_activated", "a:2:{s:35:\"instawp-connect/instawp-connect.php\";i:1760104532;s:47:\"wpvivid-backuprestore/wpvivid-backuprestore.php\";i:1760104146;}", "off");
INSERT INTO `wor4890_options` VALUES("181", "finished_updating_comment_type", "1", "auto");
INSERT INTO `wor4890_options` VALUES("182", "wordfence_ls_version", "1.1.15", "auto");
INSERT INTO `wor4890_options` VALUES("183", "wfls_last_role_change", "1742947497", "off");
INSERT INTO `wor4890_options` VALUES("184", "wordfence_version", "8.1.0", "auto");
INSERT INTO `wor4890_options` VALUES("185", "wordfence_case", "1", "auto");
INSERT INTO `wor4890_options` VALUES("186", "wordfence_installed", "1", "auto");
INSERT INTO `wor4890_options` VALUES("187", "wordfenceActivated", "1", "auto");
INSERT INTO `wor4890_options` VALUES("188", "wf_plugin_act_error", "", "auto");
INSERT INTO `wor4890_options` VALUES("203", "seedprod_migration_run_once", "1", "auto");
INSERT INTO `wor4890_options` VALUES("204", "seedprod_run_activation", "1", "auto");
INSERT INTO `wor4890_options` VALUES("205", "seedprod_settings", "{\"api_key\":\"\",\"enable_coming_soon_mode\":true,\"enable_maintenance_mode\":false,\"enable_login_mode\":false,\"enable_404_mode\":false}", "auto");
INSERT INTO `wor4890_options` VALUES("206", "seedprod_over_time", "a:3:{s:17:\"installed_version\";s:7:\"6.18.15\";s:14:\"installed_date\";i:1742947535;s:13:\"installed_pro\";s:4:\"lite\";}", "auto");
INSERT INTO `wor4890_options` VALUES("207", "seedprod_token", "0b56eb58-257e-4d28-8a8c-5747372bf62a", "auto");
INSERT INTO `wor4890_options` VALUES("211", "seedprod_dismiss_setup_wizard", "1", "auto");
INSERT INTO `wor4890_options` VALUES("212", "seedprod_notifications", "a:4:{s:6:\"update\";i:1760055041;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `wor4890_options` VALUES("213", "seedprod_app_settings", "{  \n   \"facebook_g_app_id\":\"\",\n   \"google_places_app_key\":\"\",\n   \"yelp_app_api_key\":\"\",\n   \"disable_seedprod_button\":false,\n   \"disable_seedprod_notification\":false\n}", "auto");
INSERT INTO `wor4890_options` VALUES("214", "seedprod_onetime_flush_rewrite", "1", "auto");
INSERT INTO `wor4890_options` VALUES("215", "seedprod_one_click_upgrade", "0520f0b34f5ca557dbe0282774e7516b121e58f14e2f4f0cffc0ce6eae77deea591c529ad939387b9cdc83150437a2462e810b2ed849b7a6db659dc3475a901a", "auto");
INSERT INTO `wor4890_options` VALUES("216", "seedprod_review", "a:2:{s:4:\"time\";i:1753719237;s:9:\"dismissed\";b:1;}", "auto");
INSERT INTO `wor4890_options` VALUES("217", "seedprod_verify_wizard_options", "[\"installall\",\"rafflepress\",\"allinoneseo\",\"ga\",\"wpforms\",\"optinmonster\"]", "auto");
INSERT INTO `wor4890_options` VALUES("218", "seedprod_allow_usage_tracking", "1", "auto");
INSERT INTO `wor4890_options` VALUES("219", "seedprod_free_templates_subscribed", "1", "auto");
INSERT INTO `wor4890_options` VALUES("220", "seedprod_coming_soon_page_id", "5", "auto");
INSERT INTO `wor4890_options` VALUES("221", "seedprod_stripe_connect_origin", "9f0fe2ab-0e26-426d-a8eb-b30efc080857", "auto");
INSERT INTO `wor4890_options` VALUES("222", "seedprod_validate_json", "", "auto");
INSERT INTO `wor4890_options` VALUES("223", "seedprod_maintenance_mode_page_id", "", "auto");
INSERT INTO `wor4890_options` VALUES("224", "seedprod_login_page_id", "", "auto");
INSERT INTO `wor4890_options` VALUES("225", "seedprod_404_page_id", "", "auto");
INSERT INTO `wor4890_options` VALUES("338", "_transient_health-check-site-status-result", "{\"good\":19,\"recommended\":4,\"critical\":0}", "on");
INSERT INTO `wor4890_options` VALUES("785", "wordfence_syncAttackDataAttempts", "0", "off");
INSERT INTO `wor4890_options` VALUES("787", "wordfence_syncingAttackData", "0", "off");
INSERT INTO `wor4890_options` VALUES("790", "wordfence_lastSyncAttackData", "1759712950", "off");
INSERT INTO `wor4890_options` VALUES("16129", "can_compress_scripts", "0", "on");
INSERT INTO `wor4890_options` VALUES("16140", "auto_update_plugins", "a:5:{i:0;s:27:\"coming-soon/coming-soon.php\";i:1;s:23:\"wordfence/wordfence.php\";i:2;s:27:\"updraftplus/updraftplus.php\";i:4;s:24:\"wpforms-lite/wpforms.php\";i:5;s:21:\"filebird/filebird.php\";}", "off");
INSERT INTO `wor4890_options` VALUES("16163", "current_theme", "Mango Know Hestia Child", "auto");
INSERT INTO `wor4890_options` VALUES("16164", "theme_mods_twentytwentyfive", "a:4:{i:0;b:0;s:19:\"wp_classic_sidebars\";a:0:{}s:18:\"nav_menu_locations\";a:0:{}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1753723020;s:4:\"data\";a:1:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wor4890_options` VALUES("16165", "theme_switched", "", "auto");
INSERT INTO `wor4890_options` VALUES("16168", "auto_update_themes", "a:2:{i:0;s:16:\"twentytwentyfive\";i:1;s:6:\"hestia\";}", "off");
INSERT INTO `wor4890_options` VALUES("16194", "theme_mods_mango-know-hestia-child", "a:31:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:3;}s:28:\"zerif_frontpage_was_imported\";s:9:\"not-zerif\";s:16:\"hestia_body_font\";s:28:\"Arial, Helvetica, sans-serif\";s:18:\"hestia_ribbon_hide\";b:0;s:18:\"custom_css_post_id\";i:-1;s:31:\"hestia_feature_thumbnail_buffer\";s:91:\"http://mangoknow.com/wp-content/uploads/2025/07/alphabet-class-conceptual-301926-scaled.jpg\";s:24:\"hestia_feature_thumbnail\";s:91:\"http://mangoknow.com/wp-content/uploads/2025/07/alphabet-class-conceptual-301926-scaled.jpg\";s:22:\"hestia_big_title_title\";s:35:\"English Language Learning Resources\";s:21:\"hestia_big_title_text\";s:26:\"For all your ESL/EFL needs\";s:28:\"hestia_big_title_button_text\";s:8:\"See more\";s:28:\"hestia_big_title_button_link\";s:6:\"#about\";s:20:\"hestia_contact_title\";s:12:\"Get in Touch\";s:26:\"hestia_contact_content_new\";s:0:\"\";s:26:\"hestia_blog_sidebar_layout\";s:10:\"full-width\";s:21:\"hestia_slider_content\";s:340:\"[{\"image_url\":\"https:\\/\\/mangoknow.com\\/wp-content\\/themes\\/hestia\\/assets\\/img\\/slider1.jpg\",\"title\":\"Lorem Ipsum\",\"subtitle\":\"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\",\"text\":\"Button\",\"link\":\"#\",\"id\":\"customizer_repeater_56d7ea7f40a56\",\"color\":\"#e91e63\"}]\";s:26:\"disable_frontpage_sections\";b:0;s:17:\"hestia_about_hide\";b:0;s:16:\"hestia_blog_hide\";b:0;s:12:\"accent_color\";s:7:\"#ffbc00\";s:29:\"hestia_contact_form_shortcode\";s:17:\"[wpforms id=\"43\"]\";s:21:\"hestia_subscribe_hide\";b:1;s:17:\"hestia_blog_title\";s:6:\"Latest\";s:20:\"hestia_blog_subtitle\";s:42:\"The most recent topics, articles and news.\";s:23:\"hestia_contact_subtitle\";s:69:\"Fill in the form or enter your details to sign up for the newsletter.\";s:27:\"hestia_big_title_background\";s:89:\"http://mangoknow.com/wp-content/uploads/2025/07/abc-alphabet-blackboard-265076-scaled.jpg\";s:12:\"header_image\";s:13:\"remove-header\";s:16:\"background_image\";s:0:\"\";s:28:\"hestia_header_image_sitewide\";b:0;s:25:\"hestia_contact_background\";s:91:\"http://mangoknow.com/wp-content/uploads/2025/07/alphabet-class-conceptual-301926-scaled.jpg\";s:11:\"custom_logo\";i:58;}", "on");
INSERT INTO `wor4890_options` VALUES("16201", "hestia_install", "1753723021", "auto");
INSERT INTO `wor4890_options` VALUES("16212", "hestia_had_elementor", "no", "auto");
INSERT INTO `wor4890_options` VALUES("16213", "hestia_time_activated", "1753723021", "auto");
INSERT INTO `wor4890_options` VALUES("16214", "hestia_load_shim", "no", "auto");
INSERT INTO `wor4890_options` VALUES("16229", "updraftplus_version", "1.25.8", "on");
INSERT INTO `wor4890_options` VALUES("16231", "updraftplus_tour_cancelled_on", "intro", "on");
INSERT INTO `wor4890_options` VALUES("16232", "updraft_lastmessage", "Binary zip: error (code: -1) (Oct 10 15:28:16)", "on");
INSERT INTO `wor4890_options` VALUES("16233", "updraft_updraftvault", "a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-8cdfd3337bd084f968a237988f8f5a10\";a:3:{s:5:\"token\";s:0:\"\";s:5:\"email\";s:0:\"\";s:5:\"quota\";i:-1;}}}", "on");
INSERT INTO `wor4890_options` VALUES("16234", "updraft_dropbox", "a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-165383e0c58e7db640318f8121fd977e\";a:4:{s:6:\"appkey\";s:0:\"\";s:6:\"secret\";s:0:\"\";s:6:\"folder\";s:0:\"\";s:15:\"tk_access_token\";s:0:\"\";}}}", "on");
INSERT INTO `wor4890_options` VALUES("16235", "updraft_s3", "a:2:{s:7:\"version\";s:1:\"1\";s:8:\"settings\";a:1:{s:34:\"s-ec7c3e9687dc195e3ff75107b3ea26f1\";a:3:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";}}}", "on");
INSERT INTO `wor4890_options` VALUES("16236", "updraft_cloudfiles", "a:2:{s:7:\"version\";s:1:\"1\";s:8:\"settings\";a:1:{s:34:\"s-0c2095e7ee7fdc7594afde7eaaec79e5\";a:5:{s:7:\"authurl\";s:35:\"https://auth.api.rackspacecloud.com\";s:6:\"region\";s:3:\"DFW\";s:4:\"user\";s:0:\"\";s:6:\"apikey\";s:0:\"\";s:4:\"path\";s:0:\"\";}}}", "on");
INSERT INTO `wor4890_options` VALUES("16237", "updraft_googledrive", "a:2:{s:7:\"version\";i:1;s:8:\"settings\";a:1:{s:34:\"s-e0037bb8018a1d848bc43f055a141a13\";a:10:{s:8:\"clientid\";s:0:\"\";s:6:\"secret\";s:0:\"\";s:5:\"token\";s:0:\"\";s:6:\"folder\";s:11:\"UpdraftPlus\";s:7:\"user_id\";s:64:\"43f8b9286d908311cdb330deeace6b5e2e0817781bd2dc9ac92fd578273f067c\";s:16:\"tmp_access_token\";a:4:{s:12:\"access_token\";s:253:\"ya29.A0AS3H6Nx2ZV9XEOij2E6tFc6QI8c-z9p4rdhJqTFn2TQyRdCK3No_VGvHQ7WYhDyrPQO-9WoHsCoIH215u3E9tjL-ecCLWvQZ0CBazt6lUX5r-6VNlTySRnd-g2bbUsYR7DbSbJX7bNeD4PpEfQutRBfpz31CVF0x5845EDcZN8Si7zurscNNBI_6rUkn-Gyk6QjcluoaCgYKAfESARESFQHGX2Mi5cC5P_bAMY2PUWnVd_mSJw0206\";s:7:\"created\";i:1753723157;s:10:\"expires_in\";i:3599;s:13:\"refresh_token\";s:0:\"\";}s:5:\"scope\";a:2:{i:0;s:10:\"drive.file\";i:1;s:16:\"userinfo.profile\";}s:10:\"expires_in\";i:1753726726;s:9:\"ownername\";s:9:\"Cat Fleet\";s:10:\"owneremail\";s:24:\"catfleetdesign@gmail.com\";}}}", "on");
INSERT INTO `wor4890_options` VALUES("16238", "updraft_onedrive", "a:1:{s:7:\"version\";s:1:\"1\";}", "on");
INSERT INTO `wor4890_options` VALUES("16239", "updraft_ftp", "a:2:{s:7:\"version\";s:1:\"1\";s:8:\"settings\";a:1:{s:34:\"s-0389df766e29751873b8cef93e66eba0\";a:5:{s:4:\"host\";s:0:\"\";s:4:\"user\";s:0:\"\";s:4:\"pass\";s:0:\"\";s:4:\"path\";s:0:\"\";s:7:\"passive\";s:1:\"1\";}}}", "on");
INSERT INTO `wor4890_options` VALUES("16240", "updraft_azure", "a:1:{s:7:\"version\";s:1:\"1\";}", "on");
INSERT INTO `wor4890_options` VALUES("16241", "updraft_sftp", "a:1:{s:7:\"version\";s:1:\"1\";}", "on");
INSERT INTO `wor4890_options` VALUES("16242", "updraft_googlecloud", "a:1:{s:7:\"version\";s:1:\"1\";}", "on");
INSERT INTO `wor4890_options` VALUES("16243", "updraft_backblaze", "a:1:{s:7:\"version\";s:1:\"1\";}", "on");
INSERT INTO `wor4890_options` VALUES("16244", "updraft_webdav", "a:1:{s:7:\"version\";s:1:\"1\";}", "on");
INSERT INTO `wor4890_options` VALUES("16245", "updraft_s3generic", "a:2:{s:7:\"version\";s:1:\"1\";s:8:\"settings\";a:1:{s:34:\"s-fea2d4a83235c9d35a6fe6fdefc539e2\";a:6:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";s:8:\"endpoint\";s:0:\"\";s:19:\"bucket_access_style\";s:10:\"path_style\";s:17:\"signature_version\";s:2:\"v4\";}}}", "on");
INSERT INTO `wor4890_options` VALUES("16246", "updraft_pcloud", "a:1:{s:7:\"version\";s:1:\"1\";}", "on");
INSERT INTO `wor4890_options` VALUES("16247", "updraft_openstack", "a:2:{s:7:\"version\";s:1:\"1\";s:8:\"settings\";a:1:{s:34:\"s-3b941d7a43137819ad2edab07fd61edb\";a:6:{s:7:\"authurl\";s:0:\"\";s:6:\"tenant\";s:0:\"\";s:6:\"region\";s:0:\"\";s:4:\"user\";s:0:\"\";s:8:\"password\";s:0:\"\";s:4:\"path\";s:0:\"\";}}}", "on");
INSERT INTO `wor4890_options` VALUES("16248", "updraft_dreamobjects", "a:2:{s:7:\"version\";s:1:\"1\";s:8:\"settings\";a:1:{s:34:\"s-e847149f0a6e4ed55cc296156e104688\";a:4:{s:9:\"accesskey\";s:0:\"\";s:9:\"secretkey\";s:0:\"\";s:4:\"path\";s:0:\"\";s:8:\"endpoint\";s:23:\"s3.us-east-005.dream.io\";}}}", "on");
INSERT INTO `wor4890_options` VALUES("16249", "updraftplus-addons_siteid", "bb83a8074a050671bce537f9ab9bb750", "off");
INSERT INTO `wor4890_options` VALUES("16250", "updraft_retain_extrarules", "a:0:{}", "on");
INSERT INTO `wor4890_options` VALUES("16251", "updraft_email", "", "on");
INSERT INTO `wor4890_options` VALUES("16252", "updraft_report_warningsonly", "a:0:{}", "on");
INSERT INTO `wor4890_options` VALUES("16253", "updraft_report_wholebackup", "a:0:{}", "on");
INSERT INTO `wor4890_options` VALUES("16254", "updraft_extradbs", "a:0:{}", "on");
INSERT INTO `wor4890_options` VALUES("16255", "updraft_include_more_path", "a:0:{}", "on");
INSERT INTO `wor4890_options` VALUES("16256", "updraft_interval", "daily", "on");
INSERT INTO `wor4890_options` VALUES("16257", "updraft_retain", "7", "on");
INSERT INTO `wor4890_options` VALUES("16260", "updraft_interval_database", "daily", "on");
INSERT INTO `wor4890_options` VALUES("16261", "updraft_retain_db", "7", "on");
INSERT INTO `wor4890_options` VALUES("16262", "updraft_include_plugins", "1", "on");
INSERT INTO `wor4890_options` VALUES("16263", "updraft_include_themes", "1", "on");
INSERT INTO `wor4890_options` VALUES("16264", "updraft_include_uploads", "1", "on");
INSERT INTO `wor4890_options` VALUES("16265", "updraft_include_uploads_exclude", "backup*,*backups,backwpup*,wp-clone,snapshots", "on");
INSERT INTO `wor4890_options` VALUES("16266", "updraft_include_mu-plugins", "1", "on");
INSERT INTO `wor4890_options` VALUES("16267", "updraft_include_others", "1", "on");
INSERT INTO `wor4890_options` VALUES("16268", "updraft_include_others_exclude", "upgrade,cache,updraft,backup*,*backups,mysql.sql,debug.log", "on");
INSERT INTO `wor4890_options` VALUES("16269", "updraft_split_every", "400", "on");
INSERT INTO `wor4890_options` VALUES("16270", "updraft_delete_local", "1", "on");
INSERT INTO `wor4890_options` VALUES("16271", "updraft_dir", "updraft", "on");
INSERT INTO `wor4890_options` VALUES("16272", "updraft_service", "", "on");
INSERT INTO `wor4890_options` VALUES("16273", "updraft_debug_mode", "0", "on");
INSERT INTO `wor4890_options` VALUES("16274", "updraft_ssl_useservercerts", "0", "on");
INSERT INTO `wor4890_options` VALUES("16275", "updraft_ssl_disableverify", "0", "on");
INSERT INTO `wor4890_options` VALUES("16276", "updraft_ssl_nossl", "0", "on");
INSERT INTO `wor4890_options` VALUES("16298", "wp_calendar_block_has_published_posts", "1", "auto");
INSERT INTO `wor4890_options` VALUES("16299", "nav_menu_options", "a:1:{s:8:\"auto_add\";a:0:{}}", "auto");
INSERT INTO `wor4890_options` VALUES("16313", "WPLANG", "en_GB", "auto");
INSERT INTO `wor4890_options` VALUES("16314", "new_admin_email", "catfleetdesign@gmail.com", "auto");
INSERT INTO `wor4890_options` VALUES("16319", "hestia_sync_needed", "", "auto");
INSERT INTO `wor4890_options` VALUES("16412", "updraftplus_unlocked_fd", "1", "no");
INSERT INTO `wor4890_options` VALUES("16413", "updraftplus_last_lock_time_fd", "2025-10-10 06:29:27", "no");
INSERT INTO `wor4890_options` VALUES("16414", "updraftplus_semaphore_fd", "0", "no");
INSERT INTO `wor4890_options` VALUES("16415", "updraft_last_scheduled_fd", "1760077767", "auto");
INSERT INTO `wor4890_options` VALUES("16417", "updraft_backup_history", "a:7:{i:1760077767;a:19:{s:7:\"plugins\";a:1:{i:0;s:58:\"backup_2025-10-10-0629_Mango_Know_aabfc5d14af2-plugins.zip\";}s:12:\"plugins-size\";i:34807745;s:6:\"themes\";a:1:{i:0;s:57:\"backup_2025-10-10-0629_Mango_Know_aabfc5d14af2-themes.zip\";}s:11:\"themes-size\";i:9267797;s:7:\"uploads\";a:1:{i:0;s:58:\"backup_2025-10-10-0629_Mango_Know_aabfc5d14af2-uploads.zip\";}s:12:\"uploads-size\";i:4099143;s:6:\"others\";a:1:{i:0;s:57:\"backup_2025-10-10-0629_Mango_Know_aabfc5d14af2-others.zip\";}s:11:\"others-size\";i:17447052;s:2:\"db\";s:52:\"backup_2025-10-10-0629_Mango_Know_aabfc5d14af2-db.gz\";s:7:\"db-size\";i:2088904;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"99ec65c237d87a15dfe41b05a00bc5e10f58b1a3\";s:7:\"themes0\";s:40:\"e7829dcbd6e52dcd532606925f4771f03eee981f\";s:8:\"uploads0\";s:40:\"7b6574f73006186d3fc11fde54c18977e17a5d9b\";s:7:\"others0\";s:40:\"43e94bb843d67cdb2c5ebbd0b094063fe696e11c\";s:3:\"db0\";s:40:\"b1cb9d00f97bd776fb562458d0fcc40c802fe15f\";}s:6:\"sha256\";a:5:{s:8:\"plugins0\";s:64:\"56dbae0a3b60f377bfd5b6d39c6eb08ca189f3e1060fdbeaef66b53d75de8874\";s:7:\"themes0\";s:64:\"6780587373ea055f08eb65299977ee1de0b70fb75741bd79835827b5a2d50d98\";s:8:\"uploads0\";s:64:\"aaf4e5e292de57228cd73b12241fe4e2b5778dea0df070097a0a309a25448558\";s:7:\"others0\";s:64:\"f2f4cc7978b132da0867c7dca9460d1cf2f97557e2a9af8c087bd3e6496a13d8\";s:3:\"db0\";s:64:\"b0067d9a30216f277d66263134cb44302e11add75d8ac32e2497b6c48196a1c6\";}}s:5:\"nonce\";s:12:\"aabfc5d14af2\";s:7:\"service\";a:0:{}s:20:\"service_instance_ids\";a:0:{}s:11:\"always_keep\";b:0;s:19:\"files_enumerated_at\";a:4:{s:7:\"plugins\";i:1760077767;s:6:\"themes\";i:1760077779;s:7:\"uploads\";i:1760077779;s:6:\"others\";i:1760077779;}s:18:\"created_by_version\";s:6:\"1.25.8\";s:21:\"last_saved_by_version\";s:6:\"1.25.8\";s:12:\"is_multisite\";b:0;}i:1759991766;a:19:{s:7:\"plugins\";a:1:{i:0;s:58:\"backup_2025-10-09-0636_Mango_Know_980205bfc853-plugins.zip\";}s:12:\"plugins-size\";i:34807745;s:6:\"themes\";a:1:{i:0;s:57:\"backup_2025-10-09-0636_Mango_Know_980205bfc853-themes.zip\";}s:11:\"themes-size\";i:9267797;s:7:\"uploads\";a:1:{i:0;s:58:\"backup_2025-10-09-0636_Mango_Know_980205bfc853-uploads.zip\";}s:12:\"uploads-size\";i:4099143;s:6:\"others\";a:1:{i:0;s:57:\"backup_2025-10-09-0636_Mango_Know_980205bfc853-others.zip\";}s:11:\"others-size\";i:17447541;s:2:\"db\";s:52:\"backup_2025-10-09-0636_Mango_Know_980205bfc853-db.gz\";s:7:\"db-size\";i:2088065;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"c902fff22883066334743c5d42f4ca3eea0414c8\";s:7:\"themes0\";s:40:\"c91ff9dd9103af54b6f42764f698e3040981a68c\";s:8:\"uploads0\";s:40:\"1e69773c0782b3af7b3e1aac4e81de6ce35beac5\";s:7:\"others0\";s:40:\"fe56114a63b0f03a55e6b0971bb4b86d22d5bbe3\";s:3:\"db0\";s:40:\"2706495f7e4bff7bffa4f4041d544faef3335c8b\";}s:6:\"sha256\";a:5:{s:8:\"plugins0\";s:64:\"38b537bc77a03c38731fcbcaa78057726723b63ab66b13c0ea08418c16de77bf\";s:7:\"themes0\";s:64:\"8df1781ac941fc6f8eeb65da0006d6a70a4e05655fbf41196515a038808605d2\";s:8:\"uploads0\";s:64:\"d734b1c956f50d8cd229b83412457a6a2c187d56747f5350b4d1284ac0fd2ab3\";s:7:\"others0\";s:64:\"a22f34dc12b0a78dc3396a458792beb97b055f09e99091d5fce8b3d5c93ecf3b\";s:3:\"db0\";s:64:\"90c92559161c326cf14ad5ed4c2cd78be5e0018e5e50b308f0278ecb77ee9693\";}}s:5:\"nonce\";s:12:\"980205bfc853\";s:7:\"service\";a:0:{}s:20:\"service_instance_ids\";a:0:{}s:11:\"always_keep\";b:0;s:19:\"files_enumerated_at\";a:4:{s:7:\"plugins\";i:1759991766;s:6:\"themes\";i:1759991779;s:7:\"uploads\";i:1759991780;s:6:\"others\";i:1759991780;}s:18:\"created_by_version\";s:6:\"1.25.8\";s:21:\"last_saved_by_version\";s:6:\"1.25.8\";s:12:\"is_multisite\";b:0;}i:1759903487;a:19:{s:7:\"plugins\";a:1:{i:0;s:58:\"backup_2025-10-08-0604_Mango_Know_322663a547ac-plugins.zip\";}s:12:\"plugins-size\";i:34807745;s:6:\"themes\";a:1:{i:0;s:57:\"backup_2025-10-08-0604_Mango_Know_322663a547ac-themes.zip\";}s:11:\"themes-size\";i:9267797;s:7:\"uploads\";a:1:{i:0;s:58:\"backup_2025-10-08-0604_Mango_Know_322663a547ac-uploads.zip\";}s:12:\"uploads-size\";i:4099143;s:6:\"others\";a:1:{i:0;s:57:\"backup_2025-10-08-0604_Mango_Know_322663a547ac-others.zip\";}s:11:\"others-size\";i:17440913;s:2:\"db\";s:52:\"backup_2025-10-08-0604_Mango_Know_322663a547ac-db.gz\";s:7:\"db-size\";i:2088056;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"7e7904faf21bbebde75be6b289aee6a7932a9977\";s:7:\"themes0\";s:40:\"ffba982f7762d695819c5149d597c052f6d4d385\";s:8:\"uploads0\";s:40:\"6014072ad189ad35a75836eef155653c34066ab1\";s:7:\"others0\";s:40:\"f9202422882f5659d606f05391a816b9db5c43c7\";s:3:\"db0\";s:40:\"d06d946ba35cc7b1759575a42ab6d6cf519153fb\";}s:6:\"sha256\";a:5:{s:8:\"plugins0\";s:64:\"86b20fa82f7307ddacbdc3c27a644b1bfc8b1afee425a65e2f8019cae26771c4\";s:7:\"themes0\";s:64:\"83058b8734b204f44e100201f777f70ad56ff69171a0304f6e8ed0bafa52d168\";s:8:\"uploads0\";s:64:\"20f9cbe8c851cc09c254423fb02211d98ef4f672d486cbdcf0b9739511200962\";s:7:\"others0\";s:64:\"626cc5f29038508669df44be6035567f4c7a420ecd58d81dcb319c45746406ee\";s:3:\"db0\";s:64:\"4a173c0021e37539ad25c18c8afb7f1c8e2b69f57b8eaad054a872ecb95dc4fc\";}}s:5:\"nonce\";s:12:\"322663a547ac\";s:7:\"service\";a:0:{}s:20:\"service_instance_ids\";a:0:{}s:11:\"always_keep\";b:0;s:19:\"files_enumerated_at\";a:4:{s:7:\"plugins\";i:1759903487;s:6:\"themes\";i:1759903500;s:7:\"uploads\";i:1759903500;s:6:\"others\";i:1759903501;}s:18:\"created_by_version\";s:6:\"1.25.8\";s:21:\"last_saved_by_version\";s:6:\"1.25.8\";s:12:\"is_multisite\";b:0;}i:1759815884;a:19:{s:7:\"plugins\";a:1:{i:0;s:58:\"backup_2025-10-07-0544_Mango_Know_6c2ac907f3e4-plugins.zip\";}s:12:\"plugins-size\";i:34807745;s:6:\"themes\";a:1:{i:0;s:57:\"backup_2025-10-07-0544_Mango_Know_6c2ac907f3e4-themes.zip\";}s:11:\"themes-size\";i:9267797;s:7:\"uploads\";a:1:{i:0;s:58:\"backup_2025-10-07-0544_Mango_Know_6c2ac907f3e4-uploads.zip\";}s:12:\"uploads-size\";i:4099143;s:6:\"others\";a:1:{i:0;s:57:\"backup_2025-10-07-0544_Mango_Know_6c2ac907f3e4-others.zip\";}s:11:\"others-size\";i:17441047;s:2:\"db\";s:52:\"backup_2025-10-07-0544_Mango_Know_6c2ac907f3e4-db.gz\";s:7:\"db-size\";i:2091388;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"97c3281da4254609411bd223d9296a0b58f7994d\";s:7:\"themes0\";s:40:\"a99076ce73677018ef3996047b21182cf1152bda\";s:8:\"uploads0\";s:40:\"fe48689932da6b210bed3dd28e3fb1696a778ae1\";s:7:\"others0\";s:40:\"eba304eef81dab94aad3411a3c572223d023e9d7\";s:3:\"db0\";s:40:\"827f9a60a1a1dc2b4b81e3bd8cbf168445705177\";}s:6:\"sha256\";a:5:{s:8:\"plugins0\";s:64:\"a28a4a452fe8425560899ad95acc24d38d112843af50c93a7772bdc86d6585d1\";s:7:\"themes0\";s:64:\"147851306c7c25405bfcc1bf4f8abaa61ca75622da4ba26af4bcd8acc2c187e3\";s:8:\"uploads0\";s:64:\"142b43a3874d96afc101c3a8a722d06a6cbb01c3157bcc528079f2c3ccf4bfb1\";s:7:\"others0\";s:64:\"a7e648814f43d0e965b30d01eaaf35fe2275f18a8e297b9a12929a7b16e6a482\";s:3:\"db0\";s:64:\"d0a76982c8d3c9faf23027d038f89e4b40b8a1db71b74b8c4c3182f723784da5\";}}s:5:\"nonce\";s:12:\"6c2ac907f3e4\";s:7:\"service\";a:0:{}s:20:\"service_instance_ids\";a:0:{}s:11:\"always_keep\";b:0;s:19:\"files_enumerated_at\";a:4:{s:7:\"plugins\";i:1759815884;s:6:\"themes\";i:1759815896;s:7:\"uploads\";i:1759815896;s:6:\"others\";i:1759815896;}s:18:\"created_by_version\";s:6:\"1.25.8\";s:21:\"last_saved_by_version\";s:6:\"1.25.8\";s:12:\"is_multisite\";b:0;}i:1759728887;a:19:{s:7:\"plugins\";a:1:{i:0;s:58:\"backup_2025-10-06-0534_Mango_Know_27ea07a0fba0-plugins.zip\";}s:12:\"plugins-size\";i:34791433;s:6:\"themes\";a:1:{i:0;s:57:\"backup_2025-10-06-0534_Mango_Know_27ea07a0fba0-themes.zip\";}s:11:\"themes-size\";i:9267797;s:7:\"uploads\";a:1:{i:0;s:58:\"backup_2025-10-06-0534_Mango_Know_27ea07a0fba0-uploads.zip\";}s:12:\"uploads-size\";i:4099143;s:6:\"others\";a:1:{i:0;s:57:\"backup_2025-10-06-0534_Mango_Know_27ea07a0fba0-others.zip\";}s:11:\"others-size\";i:17443206;s:2:\"db\";s:52:\"backup_2025-10-06-0534_Mango_Know_27ea07a0fba0-db.gz\";s:7:\"db-size\";i:2088585;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"55ff51dff03554f678a2696f41f49e365dfc5ab7\";s:7:\"themes0\";s:40:\"e50e561310d186355d4a3899f549b5d5da3277c8\";s:8:\"uploads0\";s:40:\"4769dae422898106818038390346f8fb69a8fda1\";s:7:\"others0\";s:40:\"b33d37d1741484a2d298b2dbb6f1a199331c0501\";s:3:\"db0\";s:40:\"d0070e79b598f74e93f7aad0717897f5d586b5e5\";}s:6:\"sha256\";a:5:{s:8:\"plugins0\";s:64:\"a54f60d812867985aa5f3319bd4371e0f14257a455dd1621bd43151b0798f590\";s:7:\"themes0\";s:64:\"f90d69e7c3b6e7c10faa341ad56d0fe14788f924b382c29def22628018290fa5\";s:8:\"uploads0\";s:64:\"e6a843b90127b82f40812d3a5ccfe38b0f680aa0dc1b57901c25449601cdad8d\";s:7:\"others0\";s:64:\"63823f6ef788a92ceedb141facd98a81da05f71d42dcf08aa5ba3a18a700c404\";s:3:\"db0\";s:64:\"be14d2953605d5206cefbea25e31d4b5fcac7b5c62e8920c717cfd256cbc4afc\";}}s:5:\"nonce\";s:12:\"27ea07a0fba0\";s:7:\"service\";a:0:{}s:20:\"service_instance_ids\";a:0:{}s:11:\"always_keep\";b:0;s:19:\"files_enumerated_at\";a:4:{s:7:\"plugins\";i:1759728887;s:6:\"themes\";i:1759728900;s:7:\"uploads\";i:1759728900;s:6:\"others\";i:1759728901;}s:18:\"created_by_version\";s:6:\"1.25.7\";s:21:\"last_saved_by_version\";s:6:\"1.25.7\";s:12:\"is_multisite\";b:0;}i:1759643242;a:19:{s:7:\"plugins\";a:1:{i:0;s:58:\"backup_2025-10-05-0547_Mango_Know_ca009cf1a3f1-plugins.zip\";}s:12:\"plugins-size\";i:34791433;s:6:\"themes\";a:1:{i:0;s:57:\"backup_2025-10-05-0547_Mango_Know_ca009cf1a3f1-themes.zip\";}s:11:\"themes-size\";i:9267797;s:7:\"uploads\";a:1:{i:0;s:58:\"backup_2025-10-05-0547_Mango_Know_ca009cf1a3f1-uploads.zip\";}s:12:\"uploads-size\";i:4099143;s:6:\"others\";a:1:{i:0;s:57:\"backup_2025-10-05-0547_Mango_Know_ca009cf1a3f1-others.zip\";}s:11:\"others-size\";i:17442352;s:2:\"db\";s:52:\"backup_2025-10-05-0547_Mango_Know_ca009cf1a3f1-db.gz\";s:7:\"db-size\";i:2087724;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"1ad0b9a52a145e76898c4991761241adf1912291\";s:7:\"themes0\";s:40:\"a27b92761f4bc35a8a3c0a8dacd4ba7debad3356\";s:8:\"uploads0\";s:40:\"1a7570fcee987fc5ae1e5eada13fc086565d2039\";s:7:\"others0\";s:40:\"f655eef35a52562411b9098e19f8a23aab3e5572\";s:3:\"db0\";s:40:\"86a333510643eac8d90d21312d1f6c58dedceccf\";}s:6:\"sha256\";a:5:{s:8:\"plugins0\";s:64:\"287c8039a38d563d72043fd0859fe5dbe8db9ec947dd92e81870a7734182bf0f\";s:7:\"themes0\";s:64:\"a79f55b467744d832e32c457a0ba572f9ea5ac3a005e12c5018742d1f48ab37b\";s:8:\"uploads0\";s:64:\"6d9c2275b16e10dda763b69745f1c8daf8a63911c3cbb3dd5b6629dc84a8ef49\";s:7:\"others0\";s:64:\"998dd1ea2b49fb85fa2da23b2d76203326c0673ee59e458f39f9cf6501294fdf\";s:3:\"db0\";s:64:\"04fb43e60831d2cb8481c49815b3295dce0196a144b29edb4575be5cdfd20fd8\";}}s:5:\"nonce\";s:12:\"ca009cf1a3f1\";s:7:\"service\";a:0:{}s:20:\"service_instance_ids\";a:0:{}s:11:\"always_keep\";b:0;s:19:\"files_enumerated_at\";a:4:{s:7:\"plugins\";i:1759643242;s:6:\"themes\";i:1759643254;s:7:\"uploads\";i:1759643255;s:6:\"others\";i:1759643255;}s:18:\"created_by_version\";s:6:\"1.25.7\";s:21:\"last_saved_by_version\";s:6:\"1.25.7\";s:12:\"is_multisite\";b:0;}i:1759557129;a:19:{s:7:\"plugins\";a:1:{i:0;s:58:\"backup_2025-10-04-0552_Mango_Know_fdb27755c0b1-plugins.zip\";}s:12:\"plugins-size\";i:34791433;s:6:\"themes\";a:1:{i:0;s:57:\"backup_2025-10-04-0552_Mango_Know_fdb27755c0b1-themes.zip\";}s:11:\"themes-size\";i:9267797;s:7:\"uploads\";a:1:{i:0;s:58:\"backup_2025-10-04-0552_Mango_Know_fdb27755c0b1-uploads.zip\";}s:12:\"uploads-size\";i:4099143;s:6:\"others\";a:1:{i:0;s:57:\"backup_2025-10-04-0552_Mango_Know_fdb27755c0b1-others.zip\";}s:11:\"others-size\";i:17442332;s:2:\"db\";s:52:\"backup_2025-10-04-0552_Mango_Know_fdb27755c0b1-db.gz\";s:7:\"db-size\";i:2101467;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"2cdae8402a9e31f149c07fd4933e302345a9af99\";s:7:\"themes0\";s:40:\"75441f55413b09c5b24c864b9b9322ed92e7b540\";s:8:\"uploads0\";s:40:\"8401748ce0d45368c456b827dd69814200c72f27\";s:7:\"others0\";s:40:\"0d966380aa921a1ccc9588b55ba6284593d8098f\";s:3:\"db0\";s:40:\"70b632df348291bde5abe86ec07fb54c2f1a168b\";}s:6:\"sha256\";a:5:{s:8:\"plugins0\";s:64:\"63d6b6b3dd36e49f747a4d039f9b2f88cafa549878484bd6638ec3cac5f0c29f\";s:7:\"themes0\";s:64:\"87373987bb6f4eb83485111179c4add0b41f17c9b6a90a45fea6731f81951fbb\";s:8:\"uploads0\";s:64:\"cfd717eb7eb453da270fa7a095ca5133143f35095a7865d0033b9155d5e9c2b8\";s:7:\"others0\";s:64:\"22f199cf00edcc36b15e76f72d2796ce5ea5d81b0daca314dbee86f8f9a36439\";s:3:\"db0\";s:64:\"485f044f9a95230a601a86a6f3155ec0b7c8953a222b66a456c249446ae90007\";}}s:5:\"nonce\";s:12:\"fdb27755c0b1\";s:7:\"service\";a:0:{}s:20:\"service_instance_ids\";a:0:{}s:11:\"always_keep\";b:0;s:19:\"files_enumerated_at\";a:4:{s:7:\"plugins\";i:1759557129;s:6:\"themes\";i:1759557141;s:7:\"uploads\";i:1759557141;s:6:\"others\";i:1759557141;}s:18:\"created_by_version\";s:6:\"1.25.7\";s:21:\"last_saved_by_version\";s:6:\"1.25.7\";s:12:\"is_multisite\";b:0;}}", "off");
INSERT INTO `wor4890_options` VALUES("16418", "updraft_last_backup", "a:6:{s:26:\"nonincremental_backup_time\";i:1760077767;s:11:\"backup_time\";i:1760077767;s:12:\"backup_array\";a:11:{s:7:\"plugins\";a:1:{i:0;s:58:\"backup_2025-10-10-0629_Mango_Know_aabfc5d14af2-plugins.zip\";}s:12:\"plugins-size\";i:34807745;s:6:\"themes\";a:1:{i:0;s:57:\"backup_2025-10-10-0629_Mango_Know_aabfc5d14af2-themes.zip\";}s:11:\"themes-size\";i:9267797;s:7:\"uploads\";a:1:{i:0;s:58:\"backup_2025-10-10-0629_Mango_Know_aabfc5d14af2-uploads.zip\";}s:12:\"uploads-size\";i:4099143;s:6:\"others\";a:1:{i:0;s:57:\"backup_2025-10-10-0629_Mango_Know_aabfc5d14af2-others.zip\";}s:11:\"others-size\";i:17447052;s:2:\"db\";s:52:\"backup_2025-10-10-0629_Mango_Know_aabfc5d14af2-db.gz\";s:7:\"db-size\";i:2088904;s:9:\"checksums\";a:2:{s:4:\"sha1\";a:5:{s:8:\"plugins0\";s:40:\"99ec65c237d87a15dfe41b05a00bc5e10f58b1a3\";s:7:\"themes0\";s:40:\"e7829dcbd6e52dcd532606925f4771f03eee981f\";s:8:\"uploads0\";s:40:\"7b6574f73006186d3fc11fde54c18977e17a5d9b\";s:7:\"others0\";s:40:\"43e94bb843d67cdb2c5ebbd0b094063fe696e11c\";s:3:\"db0\";s:40:\"b1cb9d00f97bd776fb562458d0fcc40c802fe15f\";}s:6:\"sha256\";a:5:{s:8:\"plugins0\";s:64:\"56dbae0a3b60f377bfd5b6d39c6eb08ca189f3e1060fdbeaef66b53d75de8874\";s:7:\"themes0\";s:64:\"6780587373ea055f08eb65299977ee1de0b70fb75741bd79835827b5a2d50d98\";s:8:\"uploads0\";s:64:\"aaf4e5e292de57228cd73b12241fe4e2b5778dea0df070097a0a309a25448558\";s:7:\"others0\";s:64:\"f2f4cc7978b132da0867c7dca9460d1cf2f97557e2a9af8c087bd3e6496a13d8\";s:3:\"db0\";s:64:\"b0067d9a30216f277d66263134cb44302e11add75d8ac32e2497b6c48196a1c6\";}}}s:7:\"success\";i:1;s:6:\"errors\";a:0:{}s:12:\"backup_nonce\";s:12:\"aabfc5d14af2\";}", "on");
INSERT INTO `wor4890_options` VALUES("16550", "module_check_time", "1753809937", "auto");
INSERT INTO `wor4890_options` VALUES("16551", "obfx_new_user", "yes", "auto");
INSERT INTO `wor4890_options` VALUES("16552", "themeisle_companion_install", "1753809938", "auto");
INSERT INTO `wor4890_options` VALUES("16569", "action_scheduler_hybrid_store_demarkation", "43", "auto");
INSERT INTO `wor4890_options` VALUES("16570", "schema-ActionScheduler_StoreSchema", "8.0.1753964891", "auto");
INSERT INTO `wor4890_options` VALUES("16571", "schema-ActionScheduler_LoggerSchema", "3.0.1753809983", "auto");
INSERT INTO `wor4890_options` VALUES("16572", "wpforms_version", "1.9.6.2", "auto");
INSERT INTO `wor4890_options` VALUES("16573", "wpforms_version_lite", "1.9.6.2", "auto");
INSERT INTO `wor4890_options` VALUES("16574", "wpforms_activated", "a:1:{s:4:\"lite\";i:1753809983;}", "auto");
INSERT INTO `wor4890_options` VALUES("16579", "action_scheduler_lock_async-request-runner", "68e927070725d9.49206888|1760110403", "no");
INSERT INTO `wor4890_options` VALUES("16580", "wpforms_versions_lite", "a:19:{s:5:\"1.5.9\";i:0;s:7:\"1.6.7.2\";i:0;s:5:\"1.6.8\";i:0;s:5:\"1.7.5\";i:0;s:7:\"1.7.5.1\";i:0;s:5:\"1.7.7\";i:0;s:5:\"1.8.2\";i:0;s:5:\"1.8.3\";i:0;s:5:\"1.8.4\";i:0;s:5:\"1.8.6\";i:0;s:5:\"1.8.7\";i:0;s:5:\"1.9.1\";i:0;s:5:\"1.9.2\";i:0;s:7:\"1.9.6.2\";i:1753809984;s:5:\"1.9.7\";i:1754916343;s:7:\"1.9.7.1\";i:1753965951;s:7:\"1.9.7.2\";i:1754571175;s:7:\"1.9.7.3\";i:1754916343;s:7:\"1.9.8.1\";i:1758801481;}", "auto");
INSERT INTO `wor4890_options` VALUES("16583", "wpforms_constant_contact_version", "3", "auto");
INSERT INTO `wor4890_options` VALUES("16584", "wpforms_forms_first_created", "1753809984", "off");
INSERT INTO `wor4890_options` VALUES("16585", "hestia_wpforms_default_menu", "1", "auto");
INSERT INTO `wor4890_options` VALUES("16586", "widget_wpforms-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wor4890_options` VALUES("16589", "wpforms_settings", "a:2:{s:13:\"modern-markup\";s:1:\"0\";s:20:\"modern-markup-is-set\";b:1;}", "auto");
INSERT INTO `wor4890_options` VALUES("16592", "wpforms_admin_notices", "a:2:{s:14:\"review_request\";a:2:{s:4:\"time\";i:1753809985;s:9:\"dismissed\";b:0;}s:19:\"review_lite_request\";a:2:{s:4:\"time\";i:1760101599;s:9:\"dismissed\";b:1;}}", "on");
INSERT INTO `wor4890_options` VALUES("16593", "wpforms_splash_version", "1.8.6", "auto");
INSERT INTO `wor4890_options` VALUES("16610", "wpforms_crypto_secret_key", "/B+htZkYCmBOsvEujNQr5M8ApMFnFoj20qz5zDkgbvI=", "auto");
INSERT INTO `wor4890_options` VALUES("16613", "as_has_wp_comment_logs", "no", "on");
INSERT INTO `wor4890_options` VALUES("16614", "wpforms_process_forms_locator_status", "completed", "auto");
INSERT INTO `wor4890_options` VALUES("16615", "wpforms_notifications", "a:4:{s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}s:6:\"update\";i:1760101653;}", "auto");
INSERT INTO `wor4890_options` VALUES("16618", "dismissed-hestia_info_obfx", "1", "auto");
INSERT INTO `wor4890_options` VALUES("16662", "dismissed-hestia_info_otter_blocks", "1", "auto");
INSERT INTO `wor4890_options` VALUES("16669", "themeisle_sdk_promotions", "{\"masteriyo-plugins-install\":1753811610}", "auto");
INSERT INTO `wor4890_options` VALUES("16679", "fbv_is_new_user", "1", "auto");
INSERT INTO `wor4890_options` VALUES("16680", "fbv_first_time_active", "1", "auto");
INSERT INTO `wor4890_options` VALUES("16682", "fbv_version", "6.4.9", "auto");
INSERT INTO `wor4890_options` VALUES("16683", "fbv_review", "0", "auto");
INSERT INTO `wor4890_options` VALUES("16686", "filebird_saved_downloads", "a:0:{}", "auto");
INSERT INTO `wor4890_options` VALUES("16693", "site_logo", "58", "auto");
INSERT INTO `wor4890_options` VALUES("17223", "_wpforms_transient_upload_htaccess_file", "a:3:{s:4:\"size\";i:737;s:5:\"mtime\";i:1755882915;s:5:\"ctime\";i:1755882915;}", "on");
INSERT INTO `wor4890_options` VALUES("17224", "_wpforms_transient_wpforms_/home/mangokm/MangoKnow/wp-content/uploads/wpforms/cache/.htaccess_file", "a:3:{s:4:\"size\";i:446;s:5:\"mtime\";i:1760101599;s:5:\"ctime\";i:1760101599;}", "on");
INSERT INTO `wor4890_options` VALUES("17464", "category_children", "a:2:{i:5;a:3:{i:0;i:4;i:1;i:6;i:2;i:7;}i:10;a:5:{i:0;i:11;i:1;i:12;i:2;i:13;i:3;i:14;i:4;i:15;}}", "auto");
INSERT INTO `wor4890_options` VALUES("18240", "wpforms_email_summaries_fetch_info_blocks_last_run", "1759525224", "auto");
INSERT INTO `wor4890_options` VALUES("22545", "wpforms_version_upgraded_from", "1.9.7.2", "auto");
INSERT INTO `wor4890_options` VALUES("22546", "wpforms_version_previous", "1.9.7.3", "auto");
INSERT INTO `wor4890_options` VALUES("34281", "filebird_backup_2025_09_25_18_16_51", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("34360", "filebird_backup_2025_09_26_05_57_38", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("34497", "filebird_backup_2025_09_26_18_17_30", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("34629", "filebird_backup_2025_09_27_06_01_29", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("34793", "filebird_backup_2025_09_27_18_10_21", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("34895", "filebird_backup_2025_09_28_06_26_15", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("35005", "filebird_backup_2025_09_28_17_56_54", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("35099", "filebird_backup_2025_09_29_06_09_03", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("35243", "filebird_backup_2025_09_29_17_59_45", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("35334", "filebird_backup_2025_09_30_06_12_07", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("35470", "filebird_backup_2025_09_30_18_05_35", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("35575", "filebird_backup_2025_10_01_06_17_02", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("35657", "filebird_backup_2025_10_01_18_02_04", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("35746", "filebird_backup_2025_10_02_05_59_25", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("35850", "filebird_backup_2025_10_02_18_03_45", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("35919", "filebird_backup_2025_10_03_06_06_54", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("35993", "filebird_backup_2025_10_03_19_19_32", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("36051", "filebird_backup_2025_10_04_06_09_21", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("36144", "filebird_backup_2025_10_04_18_26_06", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("36253", "filebird_backup_2025_10_05_06_15_44", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("36358", "filebird_backup_2025_10_05_18_08_05", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("36457", "filebird_backup_2025_10_06_06_18_21", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("36532", "_transient_timeout_hestia_all_languages", "1760383326", "off");
INSERT INTO `wor4890_options` VALUES("36533", "_transient_hestia_all_languages", "a:1:{s:12:\"translations\";a:54:{i:0;a:7:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2020-09-16 20:01:08\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}}i:1;a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2024-11-27 16:52:51\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}}i:2;a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2019-08-14 07:21:53\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}}i:3;a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2024-04-08 09:14:56\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}}i:4;a:7:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2024-12-11 10:58:58\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}}i:5;a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2025-09-18 18:26:18\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}}i:6;a:7:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2020-04-06 18:08:23\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}}i:7;a:7:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2020-04-06 18:08:55\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}}i:8;a:7:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2020-04-06 18:09:13\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:81:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}}i:9;a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2025-10-04 15:03:56\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}}i:10;a:7:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2025-08-11 20:55:33\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}}i:11;a:7:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2025-05-26 12:21:34\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}}i:12;a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2024-12-11 11:01:42\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}}i:13;a:7:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2024-10-27 06:09:51\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}}i:14;a:7:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2024-10-27 06:05:26\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}}i:15;a:7:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2020-06-17 11:45:30\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}}i:16;a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2024-02-01 15:37:51\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}}i:17;a:7:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2024-10-16 13:52:01\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}}i:18;a:7:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2022-07-01 17:09:06\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}}i:19;a:7:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2022-07-01 17:09:25\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}}i:20;a:7:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2022-07-06 15:06:36\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}}i:21;a:7:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2019-04-15 15:28:52\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}}i:22;a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2025-07-24 17:18:50\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}}i:23;a:7:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2022-07-01 17:09:44\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}}i:24;a:7:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2025-08-14 17:48:29\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}}i:25;a:7:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2025-02-02 09:02:19\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}}i:26;a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2019-07-24 14:13:37\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}}i:27;a:7:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2024-12-11 11:07:39\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}}i:28;a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2020-11-22 00:31:36\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}}i:29;a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2025-03-17 10:38:28\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}}i:30;a:7:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2025-07-29 09:24:03\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}}i:31;a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2019-09-07 15:48:28\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}}i:32;a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2022-12-16 13:42:26\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}}i:33;a:7:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2019-03-14 03:21:33\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}}i:34;a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2025-05-24 19:47:25\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}}i:35;a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2025-07-24 14:02:45\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}}i:36;a:7:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2024-12-27 07:23:49\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}}i:37;a:7:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2024-12-02 06:26:19\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}}i:38;a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2024-04-30 08:53:11\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}}i:39;a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2025-07-24 22:20:04\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}}i:40;a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2025-07-25 10:48:56\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}}i:41;a:7:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2025-07-27 16:45:51\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:79:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}}i:42;a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2025-07-24 11:02:16\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}}i:43;a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2024-12-11 11:09:30\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}}i:44;a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2018-12-19 12:52:09\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}}i:45;a:7:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2025-07-24 18:33:41\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}}i:46;a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2025-09-05 06:30:42\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}}i:47;a:7:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2019-08-01 04:47:12\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}}i:48;a:7:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2020-04-02 16:37:40\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}}i:49;a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2025-09-01 13:32:37\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}}i:50;a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2024-12-11 11:11:11\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}}i:51;a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2025-01-15 07:51:57\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}}i:52;a:7:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2019-12-03 06:32:28\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}}i:53;a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"3.3.3\";s:7:\"updated\";s:19:\"2020-11-17 12:01:13\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/translation/theme/hestia/3.3.3/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}}}}", "off");
INSERT INTO `wor4890_options` VALUES("36534", "_transient_timeout_tisdk_has_support_page", "1760383326", "off");
INSERT INTO `wor4890_options` VALUES("36535", "_transient_tisdk_has_support_page", "no", "off");
INSERT INTO `wor4890_options` VALUES("36536", "_transient_timeout_tisdk_has_donate_page", "1760383326", "off");
INSERT INTO `wor4890_options` VALUES("36537", "_transient_tisdk_has_donate_page", "no", "off");
INSERT INTO `wor4890_options` VALUES("36543", "filebird_backup_2025_10_06_19_22_06", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("36617", "filebird_backup_2025_10_07_06_01_33", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("36706", "filebird_backup_2025_10_07_19_31_11", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("36769", "filebird_backup_2025_10_08_06_05_10", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("36865", "filebird_backup_2025_10_08_18_03_31", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("36963", "filebird_backup_2025_10_09_06_36_29", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("37060", "filebird_backup_2025_10_09_18_08_42", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("37081", "_transient_timeout_tsk_attachment_count", "1760127954", "off");
INSERT INTO `wor4890_options` VALUES("37082", "_transient_tsk_attachment_count", "13", "off");
INSERT INTO `wor4890_options` VALUES("37083", "_transient_timeout_tsk_posts_count", "1760127954", "off");
INSERT INTO `wor4890_options` VALUES("37084", "_transient_tsk_posts_count", "a:2:{s:11:\"total_posts\";i:6;s:9:\"old_posts\";i:0;}", "off");
INSERT INTO `wor4890_options` VALUES("37157", "updraft_combine_jobs_around", "1760159931", "on");
INSERT INTO `wor4890_options` VALUES("37158", "filebird_backup_2025_10_10_06_29_49", "a:2:{i:0;a:7:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"\"Stock Images\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"0\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:5:\"52|54\";}i:1;a:7:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:7:\"\"Logos\"\";s:6:\"parent\";s:1:\"0\";s:4:\"type\";s:1:\"0\";s:3:\"ord\";s:1:\"1\";s:10:\"created_by\";s:1:\"0\";s:14:\"attachment_ids\";s:11:\"57|58|59|60\";}}", "off");
INSERT INTO `wor4890_options` VALUES("37241", "_site_transient_timeout_available_translations", "1760112352", "off");
INSERT INTO `wor4890_options` VALUES("37242", "_site_transient_available_translations", "a:131:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:6:\"6.0.11\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.0.11/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2024-02-13 12:49:38\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.7/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-10 08:09:09\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2024-01-19 08:58:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.7/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2024-12-26 00:37:42\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.28/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-06-26 09:35:39\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-01 14:03:28\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-09 10:17:57\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-09 08:25:54\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-05 08:42:11\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-01 02:38:52\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-06-05 10:10:20\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-09 01:29:11\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-09 01:29:26\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.8.3/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-28 10:25:03\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-28 10:25:24\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/6.8.3/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-21 14:54:13\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-29 13:22:09\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-30 21:52:12\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-05-22 11:56:25\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-08 12:55:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-08-19 23:02:24\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-08-19 08:40:47\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2024-10-16 21:04:12\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-01 22:54:47\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-02 21:15:15\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-08 01:26:01\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-09 03:23:24\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2023-10-16 16:00:04\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:6:\"5.8.12\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.8.12/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.18/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.23\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.23/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-29 19:09:09\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-30 21:17:40\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-06 09:50:37\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-05 12:26:55\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-02-14 17:29:08\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-02 18:18:37\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-01 04:49:09\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-25 05:20:17\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-01 15:38:59\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"6.5.7\";s:7:\"updated\";s:19:\"2024-02-01 23:56:53\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.7/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2023-04-30 13:56:46\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2022-12-25 12:53:23\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.8/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-02 21:35:41\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-08-29 04:27:18\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.34\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.34/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2024-05-04 18:39:24\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2025-02-06 05:17:11\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-02 23:56:46\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-06-09 13:56:03\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-08-16 04:17:52\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.28/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-10 10:26:23\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-03 12:44:05\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.28/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-04-14 08:02:58\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-07-05 11:40:39\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2024-07-18 02:49:24\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.23\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.23/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-22 16:17:50\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-01 23:59:20\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-07 19:14:21\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.8.3/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:3:\"kir\";a:8:{s:8:\"language\";s:3:\"kir\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-17 05:00:42\";s:12:\"english_name\";s:6:\"Kyrgyz\";s:11:\"native_name\";s:16:\"Кыргызча\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.8.3/kir.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ky\";i:2;s:3:\"kir\";i:3;s:3:\"kir\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Улантуу\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-27 20:51:17\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-15 19:11:43\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:6:\"6.0.11\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.0.11/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-09 13:26:53\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.5.7\";s:7:\"updated\";s:19:\"2024-06-20 17:22:06\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.7/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-08-26 17:30:52\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.17\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.17/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.39\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.39/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-09 19:23:11\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-23 09:31:59\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-30 21:34:29\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-30 21:41:15\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.8.3/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-01 07:26:29\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-03 22:11:25\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.35\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.35/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-08-30 11:47:36\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-10 08:00:47\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-10 08:01:51\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.8.3/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2023-08-21 12:15:00\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-08 18:49:40\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-30 19:16:19\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.18/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-10 10:45:04\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-04-24 16:58:02\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.8.3/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-08-14 09:44:53\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-04-18 09:38:51\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-08 20:51:20\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-30 19:20:59\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-06-28 12:50:48\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.39\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.39/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:6:\"5.8.12\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.8.12/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-08 16:09:09\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-04-16 23:11:08\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-29 21:46:36\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"6.8\";s:7:\"updated\";s:19:\"2025-04-18 21:10:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.8/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.18/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-09-01 09:12:13\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.3/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-07-29 06:55:14\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"6.8.3\";s:7:\"updated\";s:19:\"2025-10-01 08:48:55\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.3/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}", "off");
INSERT INTO `wor4890_options` VALUES("37243", "_transient_timeout_wflginfl_00000000000000000000ffffbe7229d3", "1760115971", "off");
INSERT INTO `wor4890_options` VALUES("37244", "_transient_wflginfl_00000000000000000000ffffbe7229d3", "2", "off");
INSERT INTO `wor4890_options` VALUES("37245", "_transient_timeout_wfcredentialstatus_1", "1760105181", "off");
INSERT INTO `wor4890_options` VALUES("37246", "_transient_wfcredentialstatus_1", "0b0ef3fcbae28f377a35f2781b834aa7ad43074e31890bcf5e4fa4afbd740bdee", "off");
INSERT INTO `wor4890_options` VALUES("37248", "_wpforms_transient_timeout_splash.json", "1760706387", "off");
INSERT INTO `wor4890_options` VALUES("37249", "_wpforms_transient_splash.json", "1760101587", "off");
INSERT INTO `wor4890_options` VALUES("37250", "_site_transient_timeout_browser_18d80dc2693ed7800c625d78219364fb", "1760706387", "off");
INSERT INTO `wor4890_options` VALUES("37251", "_site_transient_browser_18d80dc2693ed7800c625d78219364fb", "a:10:{s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:5:\"143.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:32:\"https://www.mozilla.org/firefox/\";s:7:\"img_src\";s:44:\"http://s.w.org/images/browsers/firefox.png?1\";s:11:\"img_src_ssl\";s:45:\"https://s.w.org/images/browsers/firefox.png?1\";s:15:\"current_version\";s:2:\"56\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wor4890_options` VALUES("37252", "_site_transient_timeout_php_check_f97435f29f75964c6616760b2555a445", "1760706387", "off");
INSERT INTO `wor4890_options` VALUES("37253", "_site_transient_php_check_f97435f29f75964c6616760b2555a445", "a:5:{s:19:\"recommended_version\";s:3:\"8.3\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wor4890_options` VALUES("37254", "_transient_timeout_action_scheduler_last_pastdue_actions_check", "1760123188", "off");
INSERT INTO `wor4890_options` VALUES("37255", "_transient_action_scheduler_last_pastdue_actions_check", "1760101588", "off");
INSERT INTO `wor4890_options` VALUES("37256", "themeisle_sdk_notifications", "a:2:{s:17:\"last_notification\";a:2:{s:2:\"id\";s:18:\"hestia_logger_flag\";s:10:\"display_at\";i:1760101588;}s:24:\"last_notification_active\";i:1760101595;}", "auto");
INSERT INTO `wor4890_options` VALUES("37257", "_transient_timeout_wpforms_dash_widget_lite_entries_by_form", "1760140801", "off");
INSERT INTO `wor4890_options` VALUES("37258", "_transient_wpforms_dash_widget_lite_entries_by_form", "a:1:{i:43;a:3:{s:7:\"form_id\";i:43;s:5:\"count\";i:0;s:5:\"title\";s:6:\"Hestia\";}}", "off");
INSERT INTO `wor4890_options` VALUES("37259", "_transient_timeout_feed_9bc1b9ec726e1f508c5207949084454a", "1760144788", "off");
INSERT INTO `wor4890_options` VALUES("37260", "_transient_feed_9bc1b9ec726e1f508c5207949084454a", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Themeisle Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"https://themeisle.com/blog/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"WordPress Tutorials and Reviews for Beginners and Advanced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 24 Sep 2025 11:47:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wordpress.org/?v=6.8.3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:158:\"https://mllj2j8xvfl0.i.optimole.com/cb:c5QE.37290/w:32/h:32/q:mauto/f:best/https://themeisle.com/blog/wp-content/uploads/2019/05/cropped-cropped-favicon-2.png\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Themeisle Blog\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"https://themeisle.com/blog/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:62:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n		\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"Meet Masteriyo – A Free LearnDash Alternative\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://themeisle.com/blog/meet-masteriyo-free-learndash-alternative/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://themeisle.com/blog/meet-masteriyo-free-learndash-alternative/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 23 Sep 2025 17:01:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:17:\"WordPress Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://themeisle.com/blog/?p=113061\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:624:\"<p>Most people trying to build anything on top of WordPress would rather not empty their wallets while doing so. Building an LMS solution - or an online course platform - is not any different. I know that feeling well. You want to set up lessons, quizzes, and then actually sell your course without hitting a paywall too soon. That\'s where Masteriyo enters the picture and LearnDash exits it.</p>\n<p>The post <a href=\"https://themeisle.com/blog/meet-masteriyo-free-learndash-alternative/\">Meet Masteriyo &#8211; A Free LearnDash Alternative</a> appeared first on <a href=\"https://themeisle.com/blog\">Themeisle Blog</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Karol K\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://themeisle.com/blog/meet-masteriyo-free-learndash-alternative/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:59:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"RSS Feeds List: 100 Most Popular RSS Feeds\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:42:\"https://themeisle.com/blog/rss-feeds-list/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://themeisle.com/blog/rss-feeds-list/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Aug 2025 12:55:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Resources\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://themeisle.com/blog/?p=112613\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:307:\"<p>We compiled a list of the most popular RSS feeds for news, tech, business, sports, travel, health, and more.</p>\n<p>The post <a href=\"https://themeisle.com/blog/rss-feeds-list/\">RSS Feeds List: 100 Most Popular RSS Feeds</a> appeared first on <a href=\"https://themeisle.com/blog\">Themeisle Blog</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Harshit Arora\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"https://themeisle.com/blog/rss-feeds-list/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:62:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n		\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"How to Sell Digital Products on Multiple Domains with a Single WordPress Installation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://themeisle.com/blog/multiple-domains-single-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://themeisle.com/blog/multiple-domains-single-wordpress/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 14 May 2025 08:03:07 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:17:\"WordPress Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://themeisle.com/blog/?p=111832\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:390:\"<p>Here\'s an awesome tool that lets you set up and manage multiple domains from a single WordPress installation. Learn how it works.</p>\n<p>The post <a href=\"https://themeisle.com/blog/multiple-domains-single-wordpress/\">How to Sell Digital Products on Multiple Domains with a Single WordPress Installation</a> appeared first on <a href=\"https://themeisle.com/blog\">Themeisle Blog</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Harshit Arora\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://themeisle.com/blog/multiple-domains-single-wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:59:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"Masteriyo Joins Themeisle — A New Era for WordPress Course Creation 🚀\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://themeisle.com/blog/masteriyo-joins-themeisle/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:61:\"https://themeisle.com/blog/masteriyo-joins-themeisle/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 24 Apr 2025 22:07:52 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://themeisle.com/blog/?p=111474\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:624:\"<p>We’re thrilled to share something exciting — Masteriyo, the modern and user-friendly LMS plugin from ThemeGrill, is now officially part of the Themeisle product suite! This partnership brings together two experienced WordPress teams. We’re united by a shared vision: to make course creation and selling effortless, accessible, and enjoyable for every WordPress user. 🎁 A...</p>\n<p>The post <a href=\"https://themeisle.com/blog/masteriyo-joins-themeisle/\">Masteriyo Joins Themeisle — A New Era for WordPress Course Creation 🚀</a> appeared first on <a href=\"https://themeisle.com/blog\">Themeisle Blog</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Harshit Arora\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://themeisle.com/blog/masteriyo-joins-themeisle/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:62:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n		\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Best SSH Hosting for WordPress Sites on Shared Servers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://themeisle.com/blog/best-ssh-hosting-for-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://themeisle.com/blog/best-ssh-hosting-for-wordpress/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 01 Apr 2025 14:39:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:19:\"Hosting Comparisons\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:17:\"WordPress Hosting\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://themeisle.com/blog/?p=110713\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:679:\"<p>Shared hosting is what most website owners rely on when first launching a WordPress site. But at some point shared hosting starts to feel limiting. Maybe you need to make server-level adjustments or export a large database, but you also don\'t want to upgrade to a dedicated server or a VPS. That\'s where SSH access can come in real handy. In this post, I\'ll share my favorite SSH hosting options for WordPress sites to point you in the right direction.</p>\n<p>The post <a href=\"https://themeisle.com/blog/best-ssh-hosting-for-wordpress/\">Best SSH Hosting for WordPress Sites on Shared Servers</a> appeared first on <a href=\"https://themeisle.com/blog\">Themeisle Blog</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Martin Dubovic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://themeisle.com/blog/best-ssh-hosting-for-wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:59:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"How to Accept Donations on WordPress: For Non-Profits or Anyone Else\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://themeisle.com/blog/accept-donations-on-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://themeisle.com/blog/accept-donations-on-wordpress/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Mar 2025 13:02:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"WordPress Tutorials\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://themeisle.com/blog/?p=12255\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:453:\"<p>In this post, I\'ll show you not only how to create a great-looking donations form on WordPress, but also how to set up the backend - how to collect donations and have them deposited to an account of your choosing.</p>\n<p>The post <a href=\"https://themeisle.com/blog/accept-donations-on-wordpress/\">How to Accept Donations on WordPress: For Non-Profits or Anyone Else</a> appeared first on <a href=\"https://themeisle.com/blog\">Themeisle Blog</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Karol K\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://themeisle.com/blog/accept-donations-on-wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:62:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n		\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"How to Sell Products on WordPress Without WooCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://themeisle.com/blog/sell-products-on-wordpress-without-woocommerce/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://themeisle.com/blog/sell-products-on-wordpress-without-woocommerce/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 03 Mar 2025 14:27:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:9:\"Ecommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:17:\"WordPress Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://themeisle.com/blog/?p=110393\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:606:\"<p>WooCommerce has long been the default solution for selling products on WordPress sites. However, that doesn\'t always make it the best choice for every single product-selling scenario. Fortunately, WordPress offers several fantastic alternatives. One of my personal favorites is a plugin called WP Full Pay and in this tutorial I\'m going to teach you how to use it.</p>\n<p>The post <a href=\"https://themeisle.com/blog/sell-products-on-wordpress-without-woocommerce/\">How to Sell Products on WordPress Without WooCommerce</a> appeared first on <a href=\"https://themeisle.com/blog\">Themeisle Blog</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Martin Dubovic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:79:\"https://themeisle.com/blog/sell-products-on-wordpress-without-woocommerce/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:62:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n		\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"How to Accept Recurring Payments in WordPress (There’s a Free Solution)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://themeisle.com/blog/recurring-payments-in-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://themeisle.com/blog/recurring-payments-in-wordpress/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 25 Feb 2025 08:47:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:9:\"Ecommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:19:\"WordPress Tutorials\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://themeisle.com/blog/?p=110366\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:560:\"<p>Setting up recurring payments directly through your WordPress site can transform the way you collect payments for subscriptions, memberships, or even donations. Instead of needing to chase down invoices every month, you can automate the entire process and ask your customers to approve the purchase only once.</p>\n<p>The post <a href=\"https://themeisle.com/blog/recurring-payments-in-wordpress/\">How to Accept Recurring Payments in WordPress (There&#8217;s a Free Solution)</a> appeared first on <a href=\"https://themeisle.com/blog\">Themeisle Blog</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Karol K\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://themeisle.com/blog/recurring-payments-in-wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:59:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"How to Integrate Stripe With WordPress: Easiest Method for 2025\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://themeisle.com/blog/integrate-stripe-with-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://themeisle.com/blog/integrate-stripe-with-wordpress/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Feb 2025 09:11:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"Tools\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://themeisle.com/blog/?p=110195\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:471:\"<p>Accepting payments on your WordPress site doesn\'t have to be complicated. With Stripe and the WP Full Pay plugin, you can set up a secure, user-friendly payment system in just a few steps. Oh, and did I mention you can do it for free?</p>\n<p>The post <a href=\"https://themeisle.com/blog/integrate-stripe-with-wordpress/\">How to Integrate Stripe With WordPress: Easiest Method for 2025</a> appeared first on <a href=\"https://themeisle.com/blog\">Themeisle Blog</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Karol K\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://themeisle.com/blog/integrate-stripe-with-wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:62:\"\n		\n		\n					\n		\n		\n		\n				\n		\n		\n\n					\n		\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"Neve 4.0 ‘Sarmizegetusa’: A Smarter WordPress Theme Experience\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://themeisle.com/blog/neve-4-0-sarmizegetusa/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://themeisle.com/blog/neve-4-0-sarmizegetusa/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 03 Feb 2025 10:00:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:16:\"WordPress Themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://themeisle.com/blog/?p=109432\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:331:\"<p>Neve 4.0. A smarter, faster way to build exceptional websites that stand out from the crowd.</p>\n<p>The post <a href=\"https://themeisle.com/blog/neve-4-0-sarmizegetusa/\">Neve 4.0 &#8216;Sarmizegetusa&#8217;: A Smarter WordPress Theme Experience</a> appeared first on <a href=\"https://themeisle.com/blog\">Themeisle Blog</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Harshit Arora\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://themeisle.com/blog/neve-4-0-sarmizegetusa/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://themeisle.com/blog/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:15:{s:4:\"date\";s:29:\"Fri, 10 Oct 2025 13:06:28 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:6:\"cf-ray\";s:20:\"98c655d088b951e4-CDG\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:18:\"permissions-policy\";s:62:\"ch-viewport-width=(self \"https://mllj2j8xvfl0.i.optimole.com\")\";s:7:\"x-verti\";s:120:\"If you\'re reading this, you should visit https://careers.vertistudio.com/jobs and apply to join us, mention this header.\";s:27:\"access-control-allow-origin\";s:1:\"*\";s:4:\"link\";s:111:\"<https://themeisle.com/blog/wp-json/>; rel=\"https://api.w.org/\", <https://themeisle.com/blog/>; rel=\"canonical\"\";s:13:\"last-modified\";s:29:\"Mon, 06 Oct 2025 19:32:13 GMT\";s:13:\"cache-control\";s:35:\"public, max-age=0, s-maxage=2592000\";s:16:\"content-encoding\";s:4:\"gzip\";s:15:\"cf-cache-status\";s:3:\"HIT\";s:3:\"age\";s:4:\"4312\";s:6:\"server\";s:10:\"cloudflare\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";}}s:5:\"build\";i:1742946652;s:21:\"cache_expiration_time\";i:1760144788;s:23:\"__cache_expiration_time\";i:1760144788;}", "off");
INSERT INTO `wor4890_options` VALUES("37261", "_transient_timeout_feed_mod_9bc1b9ec726e1f508c5207949084454a", "1760144788", "off");
INSERT INTO `wor4890_options` VALUES("37262", "_transient_feed_mod_9bc1b9ec726e1f508c5207949084454a", "1760101588", "off");
INSERT INTO `wor4890_options` VALUES("37263", "_transient_timeout_feed_41e43183af30f3b40ed25f48cc2ea3f8", "1760144789", "off");
INSERT INTO `wor4890_options` VALUES("37264", "_transient_feed_41e43183af30f3b40ed25f48cc2ea3f8", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:46:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"WPShout\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"https://wpshout.com/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"A hub for advanced WordPress users, developers & savvy business owners.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 10 Sep 2025 04:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"https://wordpress.org/?v=6.8.2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:145:\"https://iotvnaw69daj.i.optimole.com/cb:FUms.67a93/w:32/h:32/q:mauto/f:best/https://wpshout.com/wp-content/uploads/2024/04/cropped-main-icon1x.png\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"WPShout\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"https://wpshout.com/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:8:{i:0;a:6:{s:4:\"data\";s:66:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"What’s the Best Cache Plugin for WordPress? 5 Options Compared for 2025\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wpshout.com/best-cache-plugin-for-wordpress/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wpshout.com/best-cache-plugin-for-wordpress/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 10 Sep 2025 04:00:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"WordPress Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpshout.com/?p=118534\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:938:\"<img width=\"150\" height=\"150\" src=\"https://iotvnaw69daj.i.optimole.com/cb:FUms.67a93/w:150/h:150/q:mauto/rt:fill/g:ce/f:best/https://wpshout.com/wp-content/uploads/2023/02/Best-Cache-WordPress-Plugins.png\" class=\"attachment-thumbnail size-thumbnail wp-post-image\" alt=\"Best Cache WordPress Plugins\" decoding=\"async\" srcset=\"https://iotvnaw69daj.i.optimole.com/cb:FUms.67a93/w:150/h:150/q:mauto/rt:fill/g:ce/f:best/https://wpshout.com/wp-content/uploads/2023/02/Best-Cache-WordPress-Plugins.png 150w, https://iotvnaw69daj.i.optimole.com/cb:FUms.67a93/w:150/h:150/q:mauto/rt:fill/g:ce/f:best/dpr:2/https://wpshout.com/wp-content/uploads/2023/02/Best-Cache-WordPress-Plugins.png 2x\" sizes=\"(max-width: 150px) 100vw, 150px\" />Your site is slow. People leave. Google shrugs. You tweak your theme, compress your images, scream into the void. Still slow… The problem might be your cache plugin, or rather the cache plugin you\'re not using yet.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Karol K\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wpshout.com/best-cache-plugin-for-wordpress/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:29:\"http://search.yahoo.com/mrss/\";a:2:{s:9:\"thumbnail\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"url\";s:19:\"https://wpshout.com\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:6:{s:4:\"data\";s:7:\"\n			\n		\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"url\";s:19:\"https://wpshout.com\";s:6:\"medium\";s:5:\"image\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:29:\"http://search.yahoo.com/mrss/\";a:1:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"Best Cache WordPress Plugins\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:1;a:6:{s:4:\"data\";s:66:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:85:\"Neve WordPress Theme Review: 1,200+ Five-Star Ratings Can’t Be Wrong…or Can They?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wpshout.com/neve-wordpress-theme-review/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wpshout.com/neve-wordpress-theme-review/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Jun 2025 09:39:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Themes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpshout.com/?p=148418\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1034:\"<img width=\"150\" height=\"150\" src=\"https://iotvnaw69daj.i.optimole.com/cb:FUms.67a93/w:150/h:150/q:mauto/rt:fill/g:ce/f:best/https://wpshout.com/wp-content/uploads/2025/06/Neve-review.png\" class=\"attachment-thumbnail size-thumbnail wp-post-image\" alt=\"Neve review\" decoding=\"async\" srcset=\"https://iotvnaw69daj.i.optimole.com/cb:FUms.67a93/w:150/h:150/q:mauto/rt:fill/g:ce/f:best/https://wpshout.com/wp-content/uploads/2025/06/Neve-review.png 150w, https://iotvnaw69daj.i.optimole.com/cb:FUms.67a93/w:150/h:150/q:mauto/rt:fill/g:ce/f:best/dpr:2/https://wpshout.com/wp-content/uploads/2025/06/Neve-review.png 2x\" sizes=\"(max-width: 150px) 100vw, 150px\" />Neve has long been considered one of the top ten WordPress themes in the official WordPress repository. It consistently gets high ratings and is active on hundreds of thousands of websites. It\'s obvious that many people like it, but does that mean it\'s a good choice for you? In this review we peel back the curtain and give you all the information you need to make that decision.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Martin Dubovic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wpshout.com/neve-wordpress-theme-review/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:29:\"http://search.yahoo.com/mrss/\";a:2:{s:9:\"thumbnail\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"url\";s:19:\"https://wpshout.com\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:6:{s:4:\"data\";s:7:\"\n			\n		\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"url\";s:19:\"https://wpshout.com\";s:6:\"medium\";s:5:\"image\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:29:\"http://search.yahoo.com/mrss/\";a:1:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Neve review\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:2;a:6:{s:4:\"data\";s:66:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"The FAIR Package Manager Just Launched as a WordPress Repository Alternative – but What Exactly Is It?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wpshout.com/fair-package-manager-wordpress-org-alternative/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wpshout.com/fair-package-manager-wordpress-org-alternative/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Jun 2025 10:16:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpshout.com/?p=150779\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1212:\"<img width=\"150\" height=\"150\" src=\"https://iotvnaw69daj.i.optimole.com/cb:FUms.67a93/w:150/h:150/q:mauto/rt:fill/g:ce/f:best/https://wpshout.com/wp-content/uploads/2025/06/FAIR-Package-Manager-Just-Launched-as-a-WordPress-Repository-Alternative.png\" class=\"attachment-thumbnail size-thumbnail wp-post-image\" alt=\"FAIR Package Manager Just Launched as a WordPress Repository Alternative\" decoding=\"async\" srcset=\"https://iotvnaw69daj.i.optimole.com/cb:FUms.67a93/w:150/h:150/q:mauto/rt:fill/g:ce/f:best/https://wpshout.com/wp-content/uploads/2025/06/FAIR-Package-Manager-Just-Launched-as-a-WordPress-Repository-Alternative.png 150w, https://iotvnaw69daj.i.optimole.com/cb:FUms.67a93/w:150/h:150/q:mauto/rt:fill/g:ce/f:best/dpr:2/https://wpshout.com/wp-content/uploads/2025/06/FAIR-Package-Manager-Just-Launched-as-a-WordPress-Repository-Alternative.png 2x\" sizes=\"(max-width: 150px) 100vw, 150px\" />A few days ago, the annual WordCamp Europe meetup took place in the picturesque city of Basel, Switzerland. The biggest announcement from the event was the new FAIR Package Manager - but what exactly is it? In this article we dive into the details, including Matt Mullenweg\'s reaction when asked about it on stage.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Martin Dubovic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wpshout.com/fair-package-manager-wordpress-org-alternative/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:29:\"http://search.yahoo.com/mrss/\";a:2:{s:9:\"thumbnail\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"url\";s:19:\"https://wpshout.com\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:6:{s:4:\"data\";s:7:\"\n			\n		\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"url\";s:19:\"https://wpshout.com\";s:6:\"medium\";s:5:\"image\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:29:\"http://search.yahoo.com/mrss/\";a:1:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"FAIR Package Manager Just Launched as a WordPress Repository Alternative\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:3;a:6:{s:4:\"data\";s:66:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"I Tried Hostinger’s New Horizons AI Developer Tool: Is the Hype Justified?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wpshout.com/hostinger-horizons-review/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wpshout.com/hostinger-horizons-review/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 May 2025 07:40:33 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Software & Tools\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpshout.com/?p=150420\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1085:\"<img width=\"150\" height=\"150\" src=\"https://iotvnaw69daj.i.optimole.com/cb:FUms.67a93/w:150/h:150/q:mauto/rt:fill/g:ce/f:best/https://wpshout.com/wp-content/uploads/2025/05/I-Tried-Hostingers-New-Horizons-AI.png\" class=\"attachment-thumbnail size-thumbnail wp-post-image\" alt=\"I Tried Hostingers New Horizons AI\" decoding=\"async\" srcset=\"https://iotvnaw69daj.i.optimole.com/cb:FUms.67a93/w:150/h:150/q:mauto/rt:fill/g:ce/f:best/https://wpshout.com/wp-content/uploads/2025/05/I-Tried-Hostingers-New-Horizons-AI.png 150w, https://iotvnaw69daj.i.optimole.com/cb:FUms.67a93/w:150/h:150/q:mauto/rt:fill/g:ce/f:best/dpr:2/https://wpshout.com/wp-content/uploads/2025/05/I-Tried-Hostingers-New-Horizons-AI.png 2x\" sizes=\"(max-width: 150px) 100vw, 150px\" />Hostinger Horizons is marketed as an easy way for non-developers without a technical background to build their own apps, but it can also be used to build websites. I decided to try both and in this post I will share the results with you. I\'ll also provide my overall thoughts on Hostinger Horizons\'s strengths, limitations, and usefulness.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Martin Dubovic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wpshout.com/hostinger-horizons-review/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:29:\"http://search.yahoo.com/mrss/\";a:2:{s:9:\"thumbnail\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"url\";s:19:\"https://wpshout.com\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:6:{s:4:\"data\";s:7:\"\n			\n		\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"url\";s:19:\"https://wpshout.com\";s:6:\"medium\";s:5:\"image\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:29:\"http://search.yahoo.com/mrss/\";a:1:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"I Tried Hostingers New Horizons AI\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:4;a:6:{s:4:\"data\";s:66:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"Google Just Released an Avalanche of New AI Tools…Here’s the Breakdown\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:43:\"https://wpshout.com/google-new-ai-releases/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wpshout.com/google-new-ai-releases/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 26 May 2025 09:27:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Software & Tools\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpshout.com/?p=150504\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:920:\"<img width=\"150\" height=\"150\" src=\"https://iotvnaw69daj.i.optimole.com/cb:FUms.67a93/w:150/h:150/q:mauto/rt:fill/g:ce/f:best/https://wpshout.com/wp-content/uploads/2025/05/Google-I-O-New-AI-Tools.png\" class=\"attachment-thumbnail size-thumbnail wp-post-image\" alt=\"Google I O New AI Tools\" decoding=\"async\" srcset=\"https://iotvnaw69daj.i.optimole.com/cb:FUms.67a93/w:150/h:150/q:mauto/rt:fill/g:ce/f:best/https://wpshout.com/wp-content/uploads/2025/05/Google-I-O-New-AI-Tools.png 150w, https://iotvnaw69daj.i.optimole.com/cb:FUms.67a93/w:150/h:150/q:mauto/rt:fill/g:ce/f:best/dpr:2/https://wpshout.com/wp-content/uploads/2025/05/Google-I-O-New-AI-Tools.png 2x\" sizes=\"(max-width: 150px) 100vw, 150px\" />During Google\'s annual I/O developer conference, they simultaneously released a combination of dozens of other AI tools and features - literally dozens. Here are the top six, along with a summary of some of the others.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Martin Dubovic\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wpshout.com/google-new-ai-releases/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:29:\"http://search.yahoo.com/mrss/\";a:2:{s:9:\"thumbnail\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"url\";s:19:\"https://wpshout.com\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:6:{s:4:\"data\";s:7:\"\n			\n		\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"url\";s:19:\"https://wpshout.com\";s:6:\"medium\";s:5:\"image\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:29:\"http://search.yahoo.com/mrss/\";a:1:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"Google I O New AI Tools\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:5;a:6:{s:4:\"data\";s:69:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"Win a Free Spot in Modern WordPress Fast Track\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wpshout.com/win-a-free-spot-in-modern-wordpress-fast-track/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wpshout.com/win-a-free-spot-in-modern-wordpress-fast-track/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 13 May 2025 13:50:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Ideas & Inspiration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpshout.com/?p=150248\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1269:\"<img width=\"150\" height=\"150\" src=\"https://iotvnaw69daj.i.optimole.com/cb:FUms.67a93/w:150/h:150/q:mauto/rt:fill/g:ce/f:best/https://wpshout.com/wp-content/uploads/2025/05/course-giveaway.jpg\" class=\"attachment-thumbnail size-thumbnail wp-post-image\" alt=\"course giveaway\" decoding=\"async\" srcset=\"https://iotvnaw69daj.i.optimole.com/cb:FUms.67a93/w:150/h:150/q:mauto/rt:fill/g:ce/f:best/https://wpshout.com/wp-content/uploads/2025/05/course-giveaway.jpg 150w, https://iotvnaw69daj.i.optimole.com/cb:FUms.67a93/w:150/h:150/q:mauto/rt:fill/g:ce/f:best/dpr:2/https://wpshout.com/wp-content/uploads/2025/05/course-giveaway.jpg 2x\" sizes=\"(max-width: 150px) 100vw, 150px\" />We believe everyone deserves access to quality WordPress development education, regardless of financial circumstances. That&#8217;s why we&#8217;re excited to announce that we&#8217;re giving away one free spot in our upcoming Modern WordPress Fast Track course to someone who couldn&#8217;t otherwise afford it. About the Course Modern WordPress Fast Track is a 10-week course that will&#8230;&#160;<a href=\"https://wpshout.com/win-a-free-spot-in-modern-wordpress-fast-track/\" rel=\"bookmark\">Read More &#187;<span class=\"screen-reader-text\">Win a Free Spot in Modern WordPress Fast Track</span></a>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Milica Aleksandric\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://wpshout.com/win-a-free-spot-in-modern-wordpress-fast-track/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:29:\"http://search.yahoo.com/mrss/\";a:2:{s:7:\"content\";a:2:{i:0;a:6:{s:4:\"data\";s:23:\"\n			\n			\n			\n			\n			\n		\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"url\";s:41:\"https://player.vimeo.com/video/1080142443\";s:8:\"duration\";s:3:\"162\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:29:\"http://search.yahoo.com/mrss/\";a:5:{s:6:\"player\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"url\";s:41:\"https://player.vimeo.com/video/1080142443\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"Win a Free Spot in Modern WordPress Fast Track\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:300:\"We believe everyone deserves access to quality WordPress development education, regardless of financial circumstances. That\'s why we\'re excited to announce that we\'re giving away one free spot in our upcoming Modern WordPress Fast Track course to someone who couldn\'t otherwise afford it. About the C\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"thumbnail\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"url\";s:19:\"https://wpshout.com\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"keywords\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:7:\"\n			\n		\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"url\";s:19:\"https://wpshout.com\";s:6:\"medium\";s:5:\"image\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:29:\"http://search.yahoo.com/mrss/\";a:1:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"course giveaway\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:9:\"thumbnail\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"url\";s:19:\"https://wpshout.com\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:66:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"Optimole Review – I Actually Tried It. Here’s What It Did to My Images\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://wpshout.com/optimole-review/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wpshout.com/optimole-review/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 12 May 2025 10:40:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"WordPress Plugins\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpshout.com/?p=150178\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:848:\"<img width=\"150\" height=\"150\" src=\"https://iotvnaw69daj.i.optimole.com/cb:FUms.67a93/w:150/h:150/q:mauto/rt:fill/g:ce/f:best/https://wpshout.com/wp-content/uploads/2025/05/Optimole-Review.png\" class=\"attachment-thumbnail size-thumbnail wp-post-image\" alt=\"Optimole Review\" decoding=\"async\" srcset=\"https://iotvnaw69daj.i.optimole.com/cb:FUms.67a93/w:150/h:150/q:mauto/rt:fill/g:ce/f:best/https://wpshout.com/wp-content/uploads/2025/05/Optimole-Review.png 150w, https://iotvnaw69daj.i.optimole.com/cb:FUms.67a93/w:150/h:150/q:mauto/rt:fill/g:ce/f:best/dpr:2/https://wpshout.com/wp-content/uploads/2025/05/Optimole-Review.png 2x\" sizes=\"(max-width: 150px) 100vw, 150px\" />Images can quietly wreck your site. They generally slow pages down, eat bandwidth, and frustrate users if they take too long to load - especially on mobile. Any solution to this?\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Karol K\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"https://wpshout.com/optimole-review/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:29:\"http://search.yahoo.com/mrss/\";a:2:{s:9:\"thumbnail\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"url\";s:19:\"https://wpshout.com\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:6:{s:4:\"data\";s:7:\"\n			\n		\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"url\";s:19:\"https://wpshout.com\";s:6:\"medium\";s:5:\"image\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:29:\"http://search.yahoo.com/mrss/\";a:1:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Optimole Review\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}i:7;a:6:{s:4:\"data\";s:66:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n		\n					\n			\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"We Just Launched the WordPress Development Course for the Modern Era\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wpshout.com/meet-our-new-wordpress-development-course/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wpshout.com/meet-our-new-wordpress-development-course/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 02 May 2025 07:30:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wpshout.com/?p=149920\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:826:\"<img width=\"150\" height=\"150\" src=\"https://iotvnaw69daj.i.optimole.com/cb:FUms.67a93/w:150/h:150/q:mauto/rt:fill/g:ce/f:best/https://wpshout.com/wp-content/uploads/2025/05/introducing-course.jpg\" class=\"attachment-thumbnail size-thumbnail wp-post-image\" alt=\"introducing course\" decoding=\"async\" srcset=\"https://iotvnaw69daj.i.optimole.com/cb:FUms.67a93/w:150/h:150/q:mauto/rt:fill/g:ce/f:best/https://wpshout.com/wp-content/uploads/2025/05/introducing-course.jpg 150w, https://iotvnaw69daj.i.optimole.com/cb:FUms.67a93/w:150/h:150/q:mauto/rt:fill/g:ce/f:best/dpr:2/https://wpshout.com/wp-content/uploads/2025/05/introducing-course.jpg 2x\" sizes=\"(max-width: 150px) 100vw, 150px\" />We\'re thrilled to announce Modern WordPress Fast Track – a WordPress development course designed to take you from zero to mastery in 10 weeks.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Milica Aleksandric\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wpshout.com/meet-our-new-wordpress-development-course/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:29:\"http://search.yahoo.com/mrss/\";a:2:{s:9:\"thumbnail\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:3:\"url\";s:19:\"https://wpshout.com\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"content\";a:1:{i:0;a:6:{s:4:\"data\";s:7:\"\n			\n		\";s:7:\"attribs\";a:1:{s:0:\"\";a:2:{s:3:\"url\";s:19:\"https://wpshout.com\";s:6:\"medium\";s:5:\"image\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:29:\"http://search.yahoo.com/mrss/\";a:1:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"introducing course\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:4:\"type\";s:4:\"html\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:25:\"https://wpshout.com/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:15:{s:4:\"date\";s:29:\"Fri, 10 Oct 2025 13:06:29 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:6:\"cf-ray\";s:20:\"98c655d34fd7d0a2-CDG\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:18:\"permissions-policy\";s:62:\"ch-viewport-width=(self \"https://iotvnaw69daj.i.optimole.com\")\";s:7:\"x-verti\";s:120:\"If you\'re reading this, you should visit https://careers.vertistudio.com/jobs and apply to join us, mention this header.\";s:27:\"access-control-allow-origin\";s:1:\"*\";s:4:\"link\";s:97:\"<https://wpshout.com/wp-json/>; rel=\"https://api.w.org/\", <https://wpshout.com/>; rel=\"canonical\"\";s:13:\"last-modified\";s:29:\"Wed, 08 Oct 2025 18:34:58 GMT\";s:13:\"cache-control\";s:35:\"public, max-age=0, s-maxage=2592000\";s:16:\"content-encoding\";s:4:\"gzip\";s:15:\"cf-cache-status\";s:3:\"HIT\";s:3:\"age\";s:2:\"69\";s:6:\"server\";s:10:\"cloudflare\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";}}s:5:\"build\";i:1742946652;s:21:\"cache_expiration_time\";i:1760144789;s:23:\"__cache_expiration_time\";i:1760144789;}", "off");
INSERT INTO `wor4890_options` VALUES("37265", "_transient_timeout_feed_mod_41e43183af30f3b40ed25f48cc2ea3f8", "1760144789", "off");
INSERT INTO `wor4890_options` VALUES("37266", "_transient_feed_mod_41e43183af30f3b40ed25f48cc2ea3f8", "1760101589", "off");
INSERT INTO `wor4890_options` VALUES("37267", "_transient_timeout_themeisle_sdk_feed_items", "1760274389", "off");
INSERT INTO `wor4890_options` VALUES("37268", "_transient_themeisle_sdk_feed_items", "a:5:{i:0;a:3:{s:5:\"title\";s:47:\"Meet Masteriyo – A Free LearnDash Alternative\";s:4:\"date\";i:1758646902;s:4:\"link\";s:69:\"https://themeisle.com/blog/meet-masteriyo-free-learndash-alternative/\";}i:1;a:3:{s:5:\"title\";s:73:\"What’s the Best Cache Plugin for WordPress? 5 Options Compared for 2025\";s:4:\"date\";i:1757476800;s:4:\"link\";s:52:\"https://wpshout.com/best-cache-plugin-for-wordpress/\";}i:2;a:3:{s:5:\"title\";s:42:\"RSS Feeds List: 100 Most Popular RSS Feeds\";s:4:\"date\";i:1755867320;s:4:\"link\";s:42:\"https://themeisle.com/blog/rss-feeds-list/\";}i:3;a:3:{s:5:\"title\";s:85:\"Neve WordPress Theme Review: 1,200+ Five-Star Ratings Can’t Be Wrong…or Can They?\";s:4:\"date\";i:1750671542;s:4:\"link\";s:48:\"https://wpshout.com/neve-wordpress-theme-review/\";}i:4;a:3:{s:5:\"title\";s:104:\"The FAIR Package Manager Just Launched as a WordPress Repository Alternative – but What Exactly Is It?\";s:4:\"date\";i:1749464202;s:4:\"link\";s:67:\"https://wpshout.com/fair-package-manager-wordpress-org-alternative/\";}}", "off");
INSERT INTO `wor4890_options` VALUES("37269", "_transient_timeout_themeisle_sdk_products", "1760123190", "off");
INSERT INTO `wor4890_options` VALUES("37270", "_transient_themeisle_sdk_products", "a:6:{i:0;a:4:{s:4:\"name\";s:4:\"Neve\";s:4:\"type\";s:5:\"theme\";s:4:\"slug\";s:4:\"neve\";s:8:\"installs\";i:200000;}i:1;a:4:{s:4:\"name\";s:6:\"Hestia\";s:4:\"type\";s:5:\"theme\";s:4:\"slug\";s:6:\"hestia\";s:8:\"installs\";i:90000;}i:2;a:4:{s:4:\"name\";s:90:\"Orbit Fox: Duplicate Page, Menu Icons, SVG Support, Cookie Notice, Custom Fonts &amp; More\";s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:19:\"themeisle-companion\";s:8:\"installs\";i:100000;}i:3;a:4:{s:4:\"name\";s:82:\"Otter Blocks &#8211; Gutenberg Blocks, Page Builder for Gutenberg Editor &amp; FSE\";s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:12:\"otter-blocks\";s:8:\"installs\";i:300000;}i:4;a:4:{s:4:\"name\";s:98:\"RSS Aggregator by Feedzy – Feed to Post, Autoblogging, News &amp; YouTube Video Feeds Aggregator\";s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:16:\"feedzy-rss-feeds\";s:8:\"installs\";i:50000;}i:5;a:4:{s:4:\"name\";s:51:\"Visualizer: Tables and Charts Manager for WordPress\";s:4:\"type\";s:6:\"plugin\";s:4:\"slug\";s:10:\"visualizer\";s:8:\"installs\";i:20000;}}", "off");
INSERT INTO `wor4890_options` VALUES("37272", "hestia_logger_flag", "no", "auto");
INSERT INTO `wor4890_options` VALUES("37273", "_wpforms_transient_timeout_addons.json", "1760706399", "off");
INSERT INTO `wor4890_options` VALUES("37274", "_wpforms_transient_addons.json", "1760101599", "off");
INSERT INTO `wor4890_options` VALUES("37275", "_wpforms_transient_timeout_templates.json", "1760706399", "off");
INSERT INTO `wor4890_options` VALUES("37276", "_wpforms_transient_templates.json", "1760101599", "off");
INSERT INTO `wor4890_options` VALUES("37280", "_transient_timeout_hestia_333versions", "1760533659", "off");
INSERT INTO `wor4890_options` VALUES("37281", "_transient_hestia_333versions", "a:152:{i:0;a:2:{s:7:\"version\";s:5:\"1.0.6\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.1.0.6.zip\";}i:1;a:2:{s:7:\"version\";s:5:\"1.0.8\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.1.0.8.zip\";}i:2;a:2:{s:7:\"version\";s:6:\"1.0.11\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.0.11.zip\";}i:3;a:2:{s:7:\"version\";s:6:\"1.0.12\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.0.12.zip\";}i:4;a:2:{s:7:\"version\";s:6:\"1.1.19\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.19.zip\";}i:5;a:2:{s:7:\"version\";s:6:\"1.1.20\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.20.zip\";}i:6;a:2:{s:7:\"version\";s:6:\"1.1.21\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.21.zip\";}i:7;a:2:{s:7:\"version\";s:6:\"1.1.22\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.22.zip\";}i:8;a:2:{s:7:\"version\";s:6:\"1.1.23\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.23.zip\";}i:9;a:2:{s:7:\"version\";s:6:\"1.1.24\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.24.zip\";}i:10;a:2:{s:7:\"version\";s:6:\"1.1.25\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.25.zip\";}i:11;a:2:{s:7:\"version\";s:6:\"1.1.28\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.28.zip\";}i:12;a:2:{s:7:\"version\";s:6:\"1.1.29\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.29.zip\";}i:13;a:2:{s:7:\"version\";s:6:\"1.1.30\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.30.zip\";}i:14;a:2:{s:7:\"version\";s:6:\"1.1.31\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.31.zip\";}i:15;a:2:{s:7:\"version\";s:6:\"1.1.32\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.32.zip\";}i:16;a:2:{s:7:\"version\";s:6:\"1.1.33\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.33.zip\";}i:17;a:2:{s:7:\"version\";s:6:\"1.1.36\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.36.zip\";}i:18;a:2:{s:7:\"version\";s:6:\"1.1.37\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.37.zip\";}i:19;a:2:{s:7:\"version\";s:6:\"1.1.38\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.38.zip\";}i:20;a:2:{s:7:\"version\";s:6:\"1.1.39\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.39.zip\";}i:21;a:2:{s:7:\"version\";s:6:\"1.1.40\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.40.zip\";}i:22;a:2:{s:7:\"version\";s:6:\"1.1.41\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.41.zip\";}i:23;a:2:{s:7:\"version\";s:6:\"1.1.42\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.42.zip\";}i:24;a:2:{s:7:\"version\";s:6:\"1.1.43\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.43.zip\";}i:25;a:2:{s:7:\"version\";s:6:\"1.1.44\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.44.zip\";}i:26;a:2:{s:7:\"version\";s:6:\"1.1.45\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.45.zip\";}i:27;a:2:{s:7:\"version\";s:6:\"1.1.46\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.46.zip\";}i:28;a:2:{s:7:\"version\";s:6:\"1.1.47\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.47.zip\";}i:29;a:2:{s:7:\"version\";s:6:\"1.1.48\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.48.zip\";}i:30;a:2:{s:7:\"version\";s:6:\"1.1.50\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.50.zip\";}i:31;a:2:{s:7:\"version\";s:6:\"1.1.51\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.51.zip\";}i:32;a:2:{s:7:\"version\";s:6:\"1.1.52\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.52.zip\";}i:33;a:2:{s:7:\"version\";s:6:\"1.1.53\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.53.zip\";}i:34;a:2:{s:7:\"version\";s:6:\"1.1.54\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.54.zip\";}i:35;a:2:{s:7:\"version\";s:6:\"1.1.55\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.55.zip\";}i:36;a:2:{s:7:\"version\";s:6:\"1.1.56\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.56.zip\";}i:37;a:2:{s:7:\"version\";s:6:\"1.1.57\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.57.zip\";}i:38;a:2:{s:7:\"version\";s:6:\"1.1.58\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.58.zip\";}i:39;a:2:{s:7:\"version\";s:6:\"1.1.59\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.59.zip\";}i:40;a:2:{s:7:\"version\";s:6:\"1.1.60\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.60.zip\";}i:41;a:2:{s:7:\"version\";s:6:\"1.1.61\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.61.zip\";}i:42;a:2:{s:7:\"version\";s:6:\"1.1.62\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.62.zip\";}i:43;a:2:{s:7:\"version\";s:6:\"1.1.63\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.63.zip\";}i:44;a:2:{s:7:\"version\";s:6:\"1.1.65\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.65.zip\";}i:45;a:2:{s:7:\"version\";s:6:\"1.1.66\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.66.zip\";}i:46;a:2:{s:7:\"version\";s:6:\"1.1.70\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.70.zip\";}i:47;a:2:{s:7:\"version\";s:6:\"1.1.71\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.71.zip\";}i:48;a:2:{s:7:\"version\";s:6:\"1.1.72\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.72.zip\";}i:49;a:2:{s:7:\"version\";s:6:\"1.1.73\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.73.zip\";}i:50;a:2:{s:7:\"version\";s:6:\"1.1.74\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.74.zip\";}i:51;a:2:{s:7:\"version\";s:6:\"1.1.76\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.76.zip\";}i:52;a:2:{s:7:\"version\";s:6:\"1.1.77\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.77.zip\";}i:53;a:2:{s:7:\"version\";s:6:\"1.1.79\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.79.zip\";}i:54;a:2:{s:7:\"version\";s:6:\"1.1.80\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.80.zip\";}i:55;a:2:{s:7:\"version\";s:6:\"1.1.81\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.81.zip\";}i:56;a:2:{s:7:\"version\";s:6:\"1.1.82\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.82.zip\";}i:57;a:2:{s:7:\"version\";s:6:\"1.1.83\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.83.zip\";}i:58;a:2:{s:7:\"version\";s:6:\"1.1.84\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.84.zip\";}i:59;a:2:{s:7:\"version\";s:6:\"1.1.85\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.85.zip\";}i:60;a:2:{s:7:\"version\";s:6:\"1.1.86\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.1.1.86.zip\";}i:61;a:2:{s:7:\"version\";s:5:\"2.0.3\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.0.3.zip\";}i:62;a:2:{s:7:\"version\";s:5:\"2.0.4\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.0.4.zip\";}i:63;a:2:{s:7:\"version\";s:5:\"2.0.5\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.0.5.zip\";}i:64;a:2:{s:7:\"version\";s:5:\"2.0.6\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.0.6.zip\";}i:65;a:2:{s:7:\"version\";s:5:\"2.0.7\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.0.7.zip\";}i:66;a:2:{s:7:\"version\";s:5:\"2.0.8\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.0.8.zip\";}i:67;a:2:{s:7:\"version\";s:5:\"2.0.9\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.0.9.zip\";}i:68;a:2:{s:7:\"version\";s:6:\"2.0.10\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.2.0.10.zip\";}i:69;a:2:{s:7:\"version\";s:6:\"2.0.11\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.2.0.11.zip\";}i:70;a:2:{s:7:\"version\";s:6:\"2.0.12\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.2.0.12.zip\";}i:71;a:2:{s:7:\"version\";s:6:\"2.0.13\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.2.0.13.zip\";}i:72;a:2:{s:7:\"version\";s:6:\"2.0.14\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.2.0.14.zip\";}i:73;a:2:{s:7:\"version\";s:6:\"2.0.15\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.2.0.15.zip\";}i:74;a:2:{s:7:\"version\";s:6:\"2.0.16\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.2.0.16.zip\";}i:75;a:2:{s:7:\"version\";s:6:\"2.0.17\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.2.0.17.zip\";}i:76;a:2:{s:7:\"version\";s:6:\"2.0.18\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.2.0.18.zip\";}i:77;a:2:{s:7:\"version\";s:6:\"2.0.19\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.2.0.19.zip\";}i:78;a:2:{s:7:\"version\";s:5:\"2.1.0\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.1.0.zip\";}i:79;a:2:{s:7:\"version\";s:5:\"2.1.1\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.1.1.zip\";}i:80;a:2:{s:7:\"version\";s:5:\"2.2.0\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.2.0.zip\";}i:81;a:2:{s:7:\"version\";s:5:\"2.2.1\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.2.1.zip\";}i:82;a:2:{s:7:\"version\";s:5:\"2.3.0\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.3.0.zip\";}i:83;a:2:{s:7:\"version\";s:5:\"2.4.0\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.4.0.zip\";}i:84;a:2:{s:7:\"version\";s:5:\"2.4.1\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.4.1.zip\";}i:85;a:2:{s:7:\"version\";s:5:\"2.4.2\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.4.2.zip\";}i:86;a:2:{s:7:\"version\";s:5:\"2.4.4\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.4.4.zip\";}i:87;a:2:{s:7:\"version\";s:5:\"2.4.5\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.4.5.zip\";}i:88;a:2:{s:7:\"version\";s:5:\"2.4.6\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.4.6.zip\";}i:89;a:2:{s:7:\"version\";s:5:\"2.4.7\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.4.7.zip\";}i:90;a:2:{s:7:\"version\";s:5:\"2.4.8\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.4.8.zip\";}i:91;a:2:{s:7:\"version\";s:5:\"2.4.9\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.4.9.zip\";}i:92;a:2:{s:7:\"version\";s:5:\"2.5.0\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.5.0.zip\";}i:93;a:2:{s:7:\"version\";s:5:\"2.5.1\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.5.1.zip\";}i:94;a:2:{s:7:\"version\";s:5:\"2.5.3\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.5.3.zip\";}i:95;a:2:{s:7:\"version\";s:5:\"2.5.4\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.5.4.zip\";}i:96;a:2:{s:7:\"version\";s:5:\"2.5.5\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.5.5.zip\";}i:97;a:2:{s:7:\"version\";s:5:\"2.5.6\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.5.6.zip\";}i:98;a:2:{s:7:\"version\";s:5:\"2.5.7\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.2.5.7.zip\";}i:99;a:2:{s:7:\"version\";s:5:\"3.0.0\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.0.0.zip\";}i:100;a:2:{s:7:\"version\";s:5:\"3.0.1\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.0.1.zip\";}i:101;a:2:{s:7:\"version\";s:5:\"3.0.2\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.0.2.zip\";}i:102;a:2:{s:7:\"version\";s:5:\"3.0.3\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.0.3.zip\";}i:103;a:2:{s:7:\"version\";s:5:\"3.0.4\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.0.4.zip\";}i:104;a:2:{s:7:\"version\";s:5:\"3.0.5\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.0.5.zip\";}i:105;a:2:{s:7:\"version\";s:5:\"3.0.6\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.0.6.zip\";}i:106;a:2:{s:7:\"version\";s:5:\"3.0.8\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.0.8.zip\";}i:107;a:2:{s:7:\"version\";s:5:\"3.0.9\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.0.9.zip\";}i:108;a:2:{s:7:\"version\";s:6:\"3.0.10\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.3.0.10.zip\";}i:109;a:2:{s:7:\"version\";s:6:\"3.0.11\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.3.0.11.zip\";}i:110;a:2:{s:7:\"version\";s:6:\"3.0.13\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.3.0.13.zip\";}i:111;a:2:{s:7:\"version\";s:6:\"3.0.14\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.3.0.14.zip\";}i:112;a:2:{s:7:\"version\";s:6:\"3.0.16\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.3.0.16.zip\";}i:113;a:2:{s:7:\"version\";s:6:\"3.0.17\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.3.0.17.zip\";}i:114;a:2:{s:7:\"version\";s:6:\"3.0.18\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.3.0.18.zip\";}i:115;a:2:{s:7:\"version\";s:6:\"3.0.19\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.3.0.19.zip\";}i:116;a:2:{s:7:\"version\";s:6:\"3.0.20\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.3.0.20.zip\";}i:117;a:2:{s:7:\"version\";s:6:\"3.0.21\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.3.0.21.zip\";}i:118;a:2:{s:7:\"version\";s:6:\"3.0.22\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.3.0.22.zip\";}i:119;a:2:{s:7:\"version\";s:6:\"3.0.23\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.3.0.23.zip\";}i:120;a:2:{s:7:\"version\";s:6:\"3.0.24\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.3.0.24.zip\";}i:121;a:2:{s:7:\"version\";s:6:\"3.0.25\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.3.0.25.zip\";}i:122;a:2:{s:7:\"version\";s:6:\"3.0.26\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.3.0.26.zip\";}i:123;a:2:{s:7:\"version\";s:6:\"3.0.27\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.3.0.27.zip\";}i:124;a:2:{s:7:\"version\";s:6:\"3.0.29\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.3.0.29.zip\";}i:125;a:2:{s:7:\"version\";s:6:\"3.0.30\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.3.0.30.zip\";}i:126;a:2:{s:7:\"version\";s:5:\"3.1.0\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.1.0.zip\";}i:127;a:2:{s:7:\"version\";s:5:\"3.1.1\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.1.1.zip\";}i:128;a:2:{s:7:\"version\";s:5:\"3.1.2\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.1.2.zip\";}i:129;a:2:{s:7:\"version\";s:5:\"3.1.3\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.1.3.zip\";}i:130;a:2:{s:7:\"version\";s:5:\"3.1.4\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.1.4.zip\";}i:131;a:2:{s:7:\"version\";s:5:\"3.1.6\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.1.6.zip\";}i:132;a:2:{s:7:\"version\";s:5:\"3.1.7\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.1.7.zip\";}i:133;a:2:{s:7:\"version\";s:5:\"3.1.8\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.1.8.zip\";}i:134;a:2:{s:7:\"version\";s:5:\"3.1.9\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.1.9.zip\";}i:135;a:2:{s:7:\"version\";s:6:\"3.1.10\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.3.1.10.zip\";}i:136;a:2:{s:7:\"version\";s:5:\"3.2.0\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.2.0.zip\";}i:137;a:2:{s:7:\"version\";s:5:\"3.2.1\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.2.1.zip\";}i:138;a:2:{s:7:\"version\";s:5:\"3.2.2\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.2.2.zip\";}i:139;a:2:{s:7:\"version\";s:5:\"3.2.3\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.2.3.zip\";}i:140;a:2:{s:7:\"version\";s:5:\"3.2.4\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.2.4.zip\";}i:141;a:2:{s:7:\"version\";s:5:\"3.2.5\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.2.5.zip\";}i:142;a:2:{s:7:\"version\";s:5:\"3.2.6\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.2.6.zip\";}i:143;a:2:{s:7:\"version\";s:5:\"3.2.7\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.2.7.zip\";}i:144;a:2:{s:7:\"version\";s:5:\"3.2.8\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.2.8.zip\";}i:145;a:2:{s:7:\"version\";s:5:\"3.2.9\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.2.9.zip\";}i:146;a:2:{s:7:\"version\";s:6:\"3.2.10\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.3.2.10.zip\";}i:147;a:2:{s:7:\"version\";s:6:\"3.2.11\";s:3:\"url\";s:55:\"https://downloads.wordpress.org/theme/hestia.3.2.11.zip\";}i:148;a:2:{s:7:\"version\";s:5:\"3.3.0\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.3.0.zip\";}i:149;a:2:{s:7:\"version\";s:5:\"3.3.1\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.3.1.zip\";}i:150;a:2:{s:7:\"version\";s:5:\"3.3.2\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.3.2.zip\";}i:151;a:2:{s:7:\"version\";s:5:\"3.3.3\";s:3:\"url\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.3.3.zip\";}}", "off");
INSERT INTO `wor4890_options` VALUES("37330", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1760114857", "off");
INSERT INTO `wor4890_options` VALUES("37331", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "O:8:\"stdClass\":100:{s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";i:7514;}s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";i:4925;}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";i:2799;}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";i:2757;}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";i:2145;}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";i:2105;}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";i:2054;}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";i:1960;}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";i:1670;}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";i:1646;}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";i:1617;}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";i:1561;}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";i:1515;}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";i:1513;}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";i:1490;}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";i:1358;}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";i:1331;}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";i:1318;}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";i:1269;}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";i:1179;}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";i:1162;}s:7:\"payment\";a:3:{s:4:\"name\";s:7:\"payment\";s:4:\"slug\";s:7:\"payment\";s:5:\"count\";i:1063;}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";i:1061;}s:5:\"block\";a:3:{s:4:\"name\";s:5:\"block\";s:4:\"slug\";s:5:\"block\";s:5:\"count\";i:1061;}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";i:1055;}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";i:1051;}s:9:\"gutenberg\";a:3:{s:4:\"name\";s:9:\"gutenberg\";s:4:\"slug\";s:9:\"gutenberg\";s:5:\"count\";i:1035;}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";i:1009;}s:9:\"elementor\";a:3:{s:4:\"name\";s:9:\"elementor\";s:4:\"slug\";s:9:\"elementor\";s:5:\"count\";i:987;}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";i:964;}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";i:949;}s:15:\"payment-gateway\";a:3:{s:4:\"name\";s:15:\"payment gateway\";s:4:\"slug\";s:15:\"payment-gateway\";s:5:\"count\";i:935;}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";i:931;}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";i:919;}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";i:913;}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";i:889;}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";i:860;}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";i:813;}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";i:786;}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";i:781;}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";i:770;}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";i:769;}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";i:759;}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";i:755;}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";i:721;}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";i:713;}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"ajax\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";i:700;}s:11:\"performance\";a:3:{s:4:\"name\";s:11:\"performance\";s:4:\"slug\";s:11:\"performance\";s:5:\"count\";i:691;}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";i:679;}s:4:\"chat\";a:3:{s:4:\"name\";s:4:\"chat\";s:4:\"slug\";s:4:\"chat\";s:5:\"count\";i:679;}s:8:\"shipping\";a:3:{s:4:\"name\";s:8:\"shipping\";s:4:\"slug\";s:8:\"shipping\";s:5:\"count\";i:678;}s:2:\"ai\";a:3:{s:4:\"name\";s:2:\"AI\";s:4:\"slug\";s:2:\"ai\";s:5:\"count\";i:677;}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";i:676;}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";i:665;}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";i:653;}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";i:645;}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";i:642;}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";i:641;}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"css\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";i:636;}s:14:\"contact-form-7\";a:3:{s:4:\"name\";s:14:\"contact form 7\";s:4:\"slug\";s:14:\"contact-form-7\";s:5:\"count\";i:628;}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";i:622;}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";i:617;}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";i:609;}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";i:608;}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";i:604;}s:5:\"forms\";a:3:{s:4:\"name\";s:5:\"forms\";s:4:\"slug\";s:5:\"forms\";s:5:\"count\";i:603;}s:6:\"blocks\";a:3:{s:4:\"name\";s:6:\"blocks\";s:4:\"slug\";s:6:\"blocks\";s:5:\"count\";i:598;}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";i:590;}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";i:579;}s:5:\"popup\";a:3:{s:4:\"name\";s:5:\"popup\";s:4:\"slug\";s:5:\"popup\";s:5:\"count\";i:580;}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";i:579;}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";i:578;}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";i:570;}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";i:569;}s:8:\"payments\";a:3:{s:4:\"name\";s:8:\"payments\";s:4:\"slug\";s:8:\"payments\";s:5:\"count\";i:567;}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";i:555;}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";i:537;}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";i:532;}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";i:527;}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";i:525;}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";i:516;}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";i:509;}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";i:506;}s:8:\"checkout\";a:3:{s:4:\"name\";s:8:\"checkout\";s:4:\"slug\";s:8:\"checkout\";s:5:\"count\";i:504;}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";i:503;}s:7:\"gateway\";a:3:{s:4:\"name\";s:7:\"gateway\";s:4:\"slug\";s:7:\"gateway\";s:5:\"count\";i:478;}s:6:\"import\";a:3:{s:4:\"name\";s:6:\"import\";s:4:\"slug\";s:6:\"import\";s:5:\"count\";i:473;}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";i:472;}s:8:\"redirect\";a:3:{s:4:\"name\";s:8:\"redirect\";s:4:\"slug\";s:8:\"redirect\";s:5:\"count\";i:472;}s:12:\"notification\";a:3:{s:4:\"name\";s:12:\"notification\";s:4:\"slug\";s:12:\"notification\";s:5:\"count\";i:471;}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";i:463;}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";i:459;}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";i:457;}s:5:\"cache\";a:3:{s:4:\"name\";s:5:\"cache\";s:4:\"slug\";s:5:\"cache\";s:5:\"count\";i:446;}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"news\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";i:440;}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";i:430;}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";i:427;}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";i:423;}s:8:\"products\";a:3:{s:4:\"name\";s:8:\"products\";s:4:\"slug\";s:8:\"products\";s:5:\"count\";i:419;}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";i:419;}}", "off");
INSERT INTO `wor4890_options` VALUES("37354", "wpvivid_check_htaccess_rule_free", "1", "off");
INSERT INTO `wor4890_options` VALUES("37357", "_transient_timeout_as-post-store-dependencies-met", "1760190547", "off");
INSERT INTO `wor4890_options` VALUES("37358", "_transient_as-post-store-dependencies-met", "yes", "off");
INSERT INTO `wor4890_options` VALUES("37368", "instawp_sync_tab_roles", "a:1:{i:0;s:13:\"administrator\";}", "off");
INSERT INTO `wor4890_options` VALUES("37372", "instawp_heartbeat_failed", "1", "off");
INSERT INTO `wor4890_options` VALUES("37375", "_transient_timeout_dirsize_cache", "2075464253", "off");
INSERT INTO `wor4890_options` VALUES("37376", "_transient_dirsize_cache", "a:1435:{s:40:\"/home/mangokm/MangoKnow/wp-admin/network\";i:126233;s:38:\"/home/mangokm/MangoKnow/wp-admin/maint\";i:7611;s:41:\"/home/mangokm/MangoKnow/wp-admin/includes\";i:3089012;s:49:\"/home/mangokm/MangoKnow/wp-admin/css/colors/ocean\";i:79467;s:49:\"/home/mangokm/MangoKnow/wp-admin/css/colors/light\";i:83275;s:50:\"/home/mangokm/MangoKnow/wp-admin/css/colors/modern\";i:83520;s:52:\"/home/mangokm/MangoKnow/wp-admin/css/colors/midnight\";i:84671;s:50:\"/home/mangokm/MangoKnow/wp-admin/css/colors/coffee\";i:80361;s:53:\"/home/mangokm/MangoKnow/wp-admin/css/colors/ectoplasm\";i:83892;s:48:\"/home/mangokm/MangoKnow/wp-admin/css/colors/blue\";i:82449;s:51:\"/home/mangokm/MangoKnow/wp-admin/css/colors/sunrise\";i:86121;s:43:\"/home/mangokm/MangoKnow/wp-admin/css/colors\";i:689979;s:36:\"/home/mangokm/MangoKnow/wp-admin/css\";i:2623520;s:39:\"/home/mangokm/MangoKnow/wp-admin/images\";i:427294;s:37:\"/home/mangokm/MangoKnow/wp-admin/user\";i:3758;s:43:\"/home/mangokm/MangoKnow/wp-admin/js/widgets\";i:139432;s:35:\"/home/mangokm/MangoKnow/wp-admin/js\";i:1997290;s:32:\"/home/mangokm/MangoKnow/wp-admin\";i:9218826;s:42:\"/home/mangokm/MangoKnow/wp-content/upgrade\";i:0;s:54:\"/home/mangokm/MangoKnow/wp-content/upgrade-temp-backup\";i:0;s:67:\"/home/mangokm/MangoKnow/wp-content/wpvividbackups/wpvivid_log/error\";i:79;s:61:\"/home/mangokm/MangoKnow/wp-content/wpvividbackups/wpvivid_log\";i:158;s:49:\"/home/mangokm/MangoKnow/wp-content/wpvividbackups\";i:237;s:42:\"/home/mangokm/MangoKnow/wp-content/updraft\";i:474426586;s:51:\"/home/mangokm/MangoKnow/wp-content/languages/themes\";i:884857;s:52:\"/home/mangokm/MangoKnow/wp-content/languages/plugins\";i:17136734;s:44:\"/home/mangokm/MangoKnow/wp-content/languages\";i:42009811;s:41:\"/home/mangokm/MangoKnow/wp-content/wflogs\";i:12126760;s:50:\"/home/mangokm/MangoKnow/wp-content/wpvivid_staging\";i:79;s:58:\"/home/mangokm/MangoKnow/wp-content/wpvivid_uploads/Isolate\";i:0;s:50:\"/home/mangokm/MangoKnow/wp-content/wpvivid_uploads\";i:0;s:34:\"/home/mangokm/MangoKnow/wp-content\";i:528563501;s:53:\"/home/mangokm/MangoKnow/wp-includes/interactivity-api\";i:57534;s:45:\"/home/mangokm/MangoKnow/wp-includes/PHPMailer\";i:233633;s:46:\"/home/mangokm/MangoKnow/wp-includes/php-compat\";i:1253;s:54:\"/home/mangokm/MangoKnow/wp-includes/rest-api/endpoints\";i:870700;s:51:\"/home/mangokm/MangoKnow/wp-includes/rest-api/search\";i:16916;s:51:\"/home/mangokm/MangoKnow/wp-includes/rest-api/fields\";i:22750;s:44:\"/home/mangokm/MangoKnow/wp-includes/rest-api\";i:1001929;s:57:\"/home/mangokm/MangoKnow/wp-includes/Requests/src/Response\";i:3101;s:56:\"/home/mangokm/MangoKnow/wp-includes/Requests/src/Utility\";i:7176;s:55:\"/home/mangokm/MangoKnow/wp-includes/Requests/src/Cookie\";i:4363;s:53:\"/home/mangokm/MangoKnow/wp-includes/Requests/src/Auth\";i:2541;s:63:\"/home/mangokm/MangoKnow/wp-includes/Requests/src/Exception/Http\";i:16715;s:68:\"/home/mangokm/MangoKnow/wp-includes/Requests/src/Exception/Transport\";i:1397;s:58:\"/home/mangokm/MangoKnow/wp-includes/Requests/src/Exception\";i:22464;s:54:\"/home/mangokm/MangoKnow/wp-includes/Requests/src/Proxy\";i:4217;s:58:\"/home/mangokm/MangoKnow/wp-includes/Requests/src/Transport\";i:35470;s:48:\"/home/mangokm/MangoKnow/wp-includes/Requests/src\";i:214849;s:52:\"/home/mangokm/MangoKnow/wp-includes/Requests/library\";i:261;s:44:\"/home/mangokm/MangoKnow/wp-includes/Requests\";i:215110;s:50:\"/home/mangokm/MangoKnow/wp-includes/block-bindings\";i:3610;s:57:\"/home/mangokm/MangoKnow/wp-includes/css/dist/block-editor\";i:620037;s:60:\"/home/mangokm/MangoKnow/wp-includes/css/dist/reusable-blocks\";i:2290;s:58:\"/home/mangokm/MangoKnow/wp-includes/css/dist/block-library\";i:804012;s:57:\"/home/mangokm/MangoKnow/wp-includes/css/dist/edit-widgets\";i:90952;s:55:\"/home/mangokm/MangoKnow/wp-includes/css/dist/components\";i:366079;s:59:\"/home/mangokm/MangoKnow/wp-includes/css/dist/format-library\";i:5024;s:60:\"/home/mangokm/MangoKnow/wp-includes/css/dist/block-directory\";i:15464;s:54:\"/home/mangokm/MangoKnow/wp-includes/css/dist/edit-post\";i:61540;s:62:\"/home/mangokm/MangoKnow/wp-includes/css/dist/customize-widgets\";i:25296;s:56:\"/home/mangokm/MangoKnow/wp-includes/css/dist/preferences\";i:6314;s:53:\"/home/mangokm/MangoKnow/wp-includes/css/dist/commands\";i:13442;s:65:\"/home/mangokm/MangoKnow/wp-includes/css/dist/list-reusable-blocks\";i:17852;s:48:\"/home/mangokm/MangoKnow/wp-includes/css/dist/nux\";i:11874;s:54:\"/home/mangokm/MangoKnow/wp-includes/css/dist/edit-site\";i:590018;s:53:\"/home/mangokm/MangoKnow/wp-includes/css/dist/patterns\";i:7442;s:51:\"/home/mangokm/MangoKnow/wp-includes/css/dist/editor\";i:243084;s:52:\"/home/mangokm/MangoKnow/wp-includes/css/dist/widgets\";i:23740;s:44:\"/home/mangokm/MangoKnow/wp-includes/css/dist\";i:2904460;s:39:\"/home/mangokm/MangoKnow/wp-includes/css\";i:3551277;s:42:\"/home/mangokm/MangoKnow/wp-includes/assets\";i:28376;s:68:\"/home/mangokm/MangoKnow/wp-includes/blocks/query-pagination-previous\";i:1051;s:61:\"/home/mangokm/MangoKnow/wp-includes/blocks/navigation-submenu\";i:6204;s:52:\"/home/mangokm/MangoKnow/wp-includes/blocks/list-item\";i:1471;s:57:\"/home/mangokm/MangoKnow/wp-includes/blocks/page-list-item\";i:1109;s:48:\"/home/mangokm/MangoKnow/wp-includes/blocks/group\";i:8051;s:54:\"/home/mangokm/MangoKnow/wp-includes/blocks/query-total\";i:1520;s:52:\"/home/mangokm/MangoKnow/wp-includes/blocks/shortcode\";i:2918;s:64:\"/home/mangokm/MangoKnow/wp-includes/blocks/post-author-biography\";i:1507;s:56:\"/home/mangokm/MangoKnow/wp-includes/blocks/legacy-widget\";i:556;s:71:\"/home/mangokm/MangoKnow/wp-includes/blocks/comments-pagination-previous\";i:1023;s:48:\"/home/mangokm/MangoKnow/wp-includes/blocks/image\";i:66363;s:55:\"/home/mangokm/MangoKnow/wp-includes/blocks/post-excerpt\";i:3285;s:60:\"/home/mangokm/MangoKnow/wp-includes/blocks/comment-edit-link\";i:1654;s:50:\"/home/mangokm/MangoKnow/wp-includes/blocks/details\";i:2260;s:52:\"/home/mangokm/MangoKnow/wp-includes/blocks/separator\";i:5126;s:49:\"/home/mangokm/MangoKnow/wp-includes/blocks/button\";i:14327;s:55:\"/home/mangokm/MangoKnow/wp-includes/blocks/site-tagline\";i:2149;s:49:\"/home/mangokm/MangoKnow/wp-includes/blocks/column\";i:1636;s:55:\"/home/mangokm/MangoKnow/wp-includes/blocks/widget-group\";i:400;s:55:\"/home/mangokm/MangoKnow/wp-includes/blocks/social-links\";i:60255;s:47:\"/home/mangokm/MangoKnow/wp-includes/blocks/list\";i:2338;s:48:\"/home/mangokm/MangoKnow/wp-includes/blocks/verse\";i:2144;s:47:\"/home/mangokm/MangoKnow/wp-includes/blocks/more\";i:3770;s:48:\"/home/mangokm/MangoKnow/wp-includes/blocks/quote\";i:7166;s:49:\"/home/mangokm/MangoKnow/wp-includes/blocks/search\";i:19632;s:62:\"/home/mangokm/MangoKnow/wp-includes/blocks/comment-author-name\";i:1677;s:51:\"/home/mangokm/MangoKnow/wp-includes/blocks/comments\";i:29695;s:52:\"/home/mangokm/MangoKnow/wp-includes/blocks/pullquote\";i:8859;s:53:\"/home/mangokm/MangoKnow/wp-includes/blocks/post-title\";i:2849;s:59:\"/home/mangokm/MangoKnow/wp-includes/blocks/query-pagination\";i:5775;s:48:\"/home/mangokm/MangoKnow/wp-includes/blocks/table\";i:27384;s:53:\"/home/mangokm/MangoKnow/wp-includes/blocks/categories\";i:4020;s:59:\"/home/mangokm/MangoKnow/wp-includes/blocks/comment-template\";i:3037;s:61:\"/home/mangokm/MangoKnow/wp-includes/blocks/comment-reply-link\";i:1447;s:61:\"/home/mangokm/MangoKnow/wp-includes/blocks/post-comments-form\";i:10059;s:47:\"/home/mangokm/MangoKnow/wp-includes/blocks/file\";i:11820;s:53:\"/home/mangokm/MangoKnow/wp-includes/blocks/navigation\";i:131175;s:55:\"/home/mangokm/MangoKnow/wp-includes/blocks/text-columns\";i:3054;s:51:\"/home/mangokm/MangoKnow/wp-includes/blocks/freeform\";i:41624;s:53:\"/home/mangokm/MangoKnow/wp-includes/blocks/site-title\";i:3051;s:48:\"/home/mangokm/MangoKnow/wp-includes/blocks/audio\";i:3675;s:50:\"/home/mangokm/MangoKnow/wp-includes/blocks/missing\";i:617;s:48:\"/home/mangokm/MangoKnow/wp-includes/blocks/cover\";i:87729;s:52:\"/home/mangokm/MangoKnow/wp-includes/blocks/post-date\";i:1665;s:46:\"/home/mangokm/MangoKnow/wp-includes/blocks/rss\";i:4900;s:58:\"/home/mangokm/MangoKnow/wp-includes/blocks/latest-comments\";i:6816;s:50:\"/home/mangokm/MangoKnow/wp-includes/blocks/pattern\";i:411;s:55:\"/home/mangokm/MangoKnow/wp-includes/blocks/post-content\";i:1778;s:58:\"/home/mangokm/MangoKnow/wp-includes/blocks/navigation-link\";i:10406;s:53:\"/home/mangokm/MangoKnow/wp-includes/blocks/media-text\";i:16904;s:52:\"/home/mangokm/MangoKnow/wp-includes/blocks/paragraph\";i:7421;s:54:\"/home/mangokm/MangoKnow/wp-includes/blocks/social-link\";i:3510;s:59:\"/home/mangokm/MangoKnow/wp-includes/blocks/query-no-results\";i:901;s:47:\"/home/mangokm/MangoKnow/wp-includes/blocks/html\";i:3770;s:52:\"/home/mangokm/MangoKnow/wp-includes/blocks/footnotes\";i:2642;s:63:\"/home/mangokm/MangoKnow/wp-includes/blocks/post-navigation-link\";i:4010;s:54:\"/home/mangokm/MangoKnow/wp-includes/blocks/query-title\";i:1721;s:55:\"/home/mangokm/MangoKnow/wp-includes/blocks/latest-posts\";i:11447;s:56:\"/home/mangokm/MangoKnow/wp-includes/blocks/template-part\";i:6686;s:49:\"/home/mangokm/MangoKnow/wp-includes/blocks/spacer\";i:4737;s:59:\"/home/mangokm/MangoKnow/wp-includes/blocks/term-description\";i:2070;s:67:\"/home/mangokm/MangoKnow/wp-includes/blocks/comments-pagination-next\";i:1011;s:54:\"/home/mangokm/MangoKnow/wp-includes/blocks/post-author\";i:3959;s:47:\"/home/mangokm/MangoKnow/wp-includes/blocks/code\";i:2828;s:52:\"/home/mangokm/MangoKnow/wp-includes/blocks/site-logo\";i:15709;s:64:\"/home/mangokm/MangoKnow/wp-includes/blocks/query-pagination-next\";i:1039;s:50:\"/home/mangokm/MangoKnow/wp-includes/blocks/buttons\";i:11544;s:50:\"/home/mangokm/MangoKnow/wp-includes/blocks/columns\";i:9193;s:52:\"/home/mangokm/MangoKnow/wp-includes/blocks/tag-cloud\";i:4274;s:49:\"/home/mangokm/MangoKnow/wp-includes/blocks/avatar\";i:2296;s:48:\"/home/mangokm/MangoKnow/wp-includes/blocks/query\";i:12952;s:58:\"/home/mangokm/MangoKnow/wp-includes/blocks/comment-content\";i:1838;s:48:\"/home/mangokm/MangoKnow/wp-includes/blocks/video\";i:8844;s:48:\"/home/mangokm/MangoKnow/wp-includes/blocks/embed\";i:11420;s:55:\"/home/mangokm/MangoKnow/wp-includes/blocks/comment-date\";i:1562;s:51:\"/home/mangokm/MangoKnow/wp-includes/blocks/archives\";i:2233;s:52:\"/home/mangokm/MangoKnow/wp-includes/blocks/page-list\";i:8293;s:51:\"/home/mangokm/MangoKnow/wp-includes/blocks/nextpage\";i:3039;s:48:\"/home/mangokm/MangoKnow/wp-includes/blocks/block\";i:587;s:57:\"/home/mangokm/MangoKnow/wp-includes/blocks/comments-title\";i:1745;s:67:\"/home/mangokm/MangoKnow/wp-includes/blocks/query-pagination-numbers\";i:1942;s:62:\"/home/mangokm/MangoKnow/wp-includes/blocks/comments-pagination\";i:8917;s:50:\"/home/mangokm/MangoKnow/wp-includes/blocks/gallery\";i:78452;s:51:\"/home/mangokm/MangoKnow/wp-includes/blocks/calendar\";i:3804;s:70:\"/home/mangokm/MangoKnow/wp-includes/blocks/comments-pagination-numbers\";i:1833;s:53:\"/home/mangokm/MangoKnow/wp-includes/blocks/post-terms\";i:1981;s:55:\"/home/mangokm/MangoKnow/wp-includes/blocks/preformatted\";i:1907;s:50:\"/home/mangokm/MangoKnow/wp-includes/blocks/heading\";i:5866;s:51:\"/home/mangokm/MangoKnow/wp-includes/blocks/loginout\";i:1474;s:56:\"/home/mangokm/MangoKnow/wp-includes/blocks/post-template\";i:7967;s:52:\"/home/mangokm/MangoKnow/wp-includes/blocks/home-link\";i:1130;s:59:\"/home/mangokm/MangoKnow/wp-includes/blocks/post-author-name\";i:1673;s:52:\"/home/mangokm/MangoKnow/wp-includes/blocks/read-more\";i:2428;s:62:\"/home/mangokm/MangoKnow/wp-includes/blocks/post-featured-image\";i:29843;s:42:\"/home/mangokm/MangoKnow/wp-includes/blocks\";i:1535843;s:39:\"/home/mangokm/MangoKnow/wp-includes/ID3\";i:1160011;s:48:\"/home/mangokm/MangoKnow/wp-includes/style-engine\";i:48119;s:45:\"/home/mangokm/MangoKnow/wp-includes/customize\";i:178475;s:43:\"/home/mangokm/MangoKnow/wp-includes/widgets\";i:158198;s:54:\"/home/mangokm/MangoKnow/wp-includes/Text/Diff/Renderer\";i:5528;s:52:\"/home/mangokm/MangoKnow/wp-includes/Text/Diff/Engine\";i:31802;s:45:\"/home/mangokm/MangoKnow/wp-includes/Text/Diff\";i:44136;s:40:\"/home/mangokm/MangoKnow/wp-includes/Text\";i:57248;s:54:\"/home/mangokm/MangoKnow/wp-includes/sitemaps/providers\";i:17599;s:44:\"/home/mangokm/MangoKnow/wp-includes/sitemaps\";i:47547;s:48:\"/home/mangokm/MangoKnow/wp-includes/theme-compat\";i:15656;s:41:\"/home/mangokm/MangoKnow/wp-includes/fonts\";i:327011;s:55:\"/home/mangokm/MangoKnow/wp-includes/SimplePie/src/Cache\";i:68936;s:55:\"/home/mangokm/MangoKnow/wp-includes/SimplePie/src/Parse\";i:26853;s:65:\"/home/mangokm/MangoKnow/wp-includes/SimplePie/src/XML/Declaration\";i:9451;s:53:\"/home/mangokm/MangoKnow/wp-includes/SimplePie/src/XML\";i:9451;s:61:\"/home/mangokm/MangoKnow/wp-includes/SimplePie/src/Decode/HTML\";i:17241;s:56:\"/home/mangokm/MangoKnow/wp-includes/SimplePie/src/Decode\";i:17241;s:62:\"/home/mangokm/MangoKnow/wp-includes/SimplePie/src/Content/Type\";i:9290;s:57:\"/home/mangokm/MangoKnow/wp-includes/SimplePie/src/Content\";i:9290;s:54:\"/home/mangokm/MangoKnow/wp-includes/SimplePie/src/HTTP\";i:14907;s:53:\"/home/mangokm/MangoKnow/wp-includes/SimplePie/src/Net\";i:8737;s:49:\"/home/mangokm/MangoKnow/wp-includes/SimplePie/src\";i:716234;s:69:\"/home/mangokm/MangoKnow/wp-includes/SimplePie/library/SimplePie/Cache\";i:15217;s:76:\"/home/mangokm/MangoKnow/wp-includes/SimplePie/library/SimplePie/Content/Type\";i:2482;s:71:\"/home/mangokm/MangoKnow/wp-includes/SimplePie/library/SimplePie/Content\";i:2482;s:69:\"/home/mangokm/MangoKnow/wp-includes/SimplePie/library/SimplePie/Parse\";i:2419;s:68:\"/home/mangokm/MangoKnow/wp-includes/SimplePie/library/SimplePie/HTTP\";i:2427;s:67:\"/home/mangokm/MangoKnow/wp-includes/SimplePie/library/SimplePie/Net\";i:2407;s:75:\"/home/mangokm/MangoKnow/wp-includes/SimplePie/library/SimplePie/Decode/HTML\";i:23828;s:70:\"/home/mangokm/MangoKnow/wp-includes/SimplePie/library/SimplePie/Decode\";i:23828;s:79:\"/home/mangokm/MangoKnow/wp-includes/SimplePie/library/SimplePie/XML/Declaration\";i:2493;s:67:\"/home/mangokm/MangoKnow/wp-includes/SimplePie/library/SimplePie/XML\";i:2493;s:63:\"/home/mangokm/MangoKnow/wp-includes/SimplePie/library/SimplePie\";i:101578;s:53:\"/home/mangokm/MangoKnow/wp-includes/SimplePie/library\";i:118803;s:45:\"/home/mangokm/MangoKnow/wp-includes/SimplePie\";i:839047;s:50:\"/home/mangokm/MangoKnow/wp-includes/block-patterns\";i:8951;s:74:\"/home/mangokm/MangoKnow/wp-includes/sodium_compat/namespaced/Core/Poly1305\";i:112;s:79:\"/home/mangokm/MangoKnow/wp-includes/sodium_compat/namespaced/Core/Curve25519/Ge\";i:602;s:76:\"/home/mangokm/MangoKnow/wp-includes/sodium_compat/namespaced/Core/Curve25519\";i:820;s:74:\"/home/mangokm/MangoKnow/wp-includes/sodium_compat/namespaced/Core/ChaCha20\";i:224;s:65:\"/home/mangokm/MangoKnow/wp-includes/sodium_compat/namespaced/Core\";i:2444;s:60:\"/home/mangokm/MangoKnow/wp-includes/sodium_compat/namespaced\";i:2698;s:67:\"/home/mangokm/MangoKnow/wp-includes/sodium_compat/src/Core/ChaCha20\";i:5264;s:72:\"/home/mangokm/MangoKnow/wp-includes/sodium_compat/src/Core/Curve25519/Ge\";i:10572;s:69:\"/home/mangokm/MangoKnow/wp-includes/sodium_compat/src/Core/Curve25519\";i:124336;s:64:\"/home/mangokm/MangoKnow/wp-includes/sodium_compat/src/Core/AEGIS\";i:14759;s:67:\"/home/mangokm/MangoKnow/wp-includes/sodium_compat/src/Core/Poly1305\";i:12912;s:71:\"/home/mangokm/MangoKnow/wp-includes/sodium_compat/src/Core/SecretStream\";i:3624;s:65:\"/home/mangokm/MangoKnow/wp-includes/sodium_compat/src/Core/Base64\";i:15456;s:62:\"/home/mangokm/MangoKnow/wp-includes/sodium_compat/src/Core/AES\";i:12651;s:58:\"/home/mangokm/MangoKnow/wp-includes/sodium_compat/src/Core\";i:499975;s:59:\"/home/mangokm/MangoKnow/wp-includes/sodium_compat/src/PHP52\";i:4116;s:69:\"/home/mangokm/MangoKnow/wp-includes/sodium_compat/src/Core32/ChaCha20\";i:6407;s:73:\"/home/mangokm/MangoKnow/wp-includes/sodium_compat/src/Core32/SecretStream\";i:3656;s:69:\"/home/mangokm/MangoKnow/wp-includes/sodium_compat/src/Core32/Poly1305\";i:15965;s:74:\"/home/mangokm/MangoKnow/wp-includes/sodium_compat/src/Core32/Curve25519/Ge\";i:8177;s:71:\"/home/mangokm/MangoKnow/wp-includes/sodium_compat/src/Core32/Curve25519\";i:122690;s:60:\"/home/mangokm/MangoKnow/wp-includes/sodium_compat/src/Core32\";i:437041;s:53:\"/home/mangokm/MangoKnow/wp-includes/sodium_compat/src\";i:1268866;s:53:\"/home/mangokm/MangoKnow/wp-includes/sodium_compat/lib\";i:99005;s:49:\"/home/mangokm/MangoKnow/wp-includes/sodium_compat\";i:1377044;s:48:\"/home/mangokm/MangoKnow/wp-includes/images/media\";i:5263;s:50:\"/home/mangokm/MangoKnow/wp-includes/images/crystal\";i:15541;s:50:\"/home/mangokm/MangoKnow/wp-includes/images/smilies\";i:10082;s:42:\"/home/mangokm/MangoKnow/wp-includes/images\";i:102178;s:40:\"/home/mangokm/MangoKnow/wp-includes/pomo\";i:57146;s:40:\"/home/mangokm/MangoKnow/wp-includes/l10n\";i:31237;s:39:\"/home/mangokm/MangoKnow/wp-includes/IXR\";i:33910;s:44:\"/home/mangokm/MangoKnow/wp-includes/html-api\";i:536362;s:50:\"/home/mangokm/MangoKnow/wp-includes/block-supports\";i:132630;s:48:\"/home/mangokm/MangoKnow/wp-includes/certificates\";i:226307;s:48:\"/home/mangokm/MangoKnow/wp-includes/js/swfupload\";i:8715;s:61:\"/home/mangokm/MangoKnow/wp-includes/js/mediaelement/renderers\";i:18880;s:51:\"/home/mangokm/MangoKnow/wp-includes/js/mediaelement\";i:721307;s:63:\"/home/mangokm/MangoKnow/wp-includes/js/dist/script-modules/a11y\";i:5613;s:78:\"/home/mangokm/MangoKnow/wp-includes/js/dist/script-modules/block-library/image\";i:22849;s:79:\"/home/mangokm/MangoKnow/wp-includes/js/dist/script-modules/block-library/search\";i:5460;s:83:\"/home/mangokm/MangoKnow/wp-includes/js/dist/script-modules/block-library/navigation\";i:11881;s:77:\"/home/mangokm/MangoKnow/wp-includes/js/dist/script-modules/block-library/file\";i:3826;s:77:\"/home/mangokm/MangoKnow/wp-includes/js/dist/script-modules/block-library/form\";i:2559;s:78:\"/home/mangokm/MangoKnow/wp-includes/js/dist/script-modules/block-library/query\";i:6276;s:72:\"/home/mangokm/MangoKnow/wp-includes/js/dist/script-modules/block-library\";i:52851;s:79:\"/home/mangokm/MangoKnow/wp-includes/js/dist/script-modules/interactivity-router\";i:21116;s:72:\"/home/mangokm/MangoKnow/wp-includes/js/dist/script-modules/interactivity\";i:312802;s:58:\"/home/mangokm/MangoKnow/wp-includes/js/dist/script-modules\";i:392382;s:50:\"/home/mangokm/MangoKnow/wp-includes/js/dist/vendor\";i:2701413;s:55:\"/home/mangokm/MangoKnow/wp-includes/js/dist/development\";i:179848;s:43:\"/home/mangokm/MangoKnow/wp-includes/js/dist\";i:22295514;s:47:\"/home/mangokm/MangoKnow/wp-includes/js/plupload\";i:490754;s:49:\"/home/mangokm/MangoKnow/wp-includes/js/codemirror\";i:1287141;s:43:\"/home/mangokm/MangoKnow/wp-includes/js/crop\";i:20004;s:48:\"/home/mangokm/MangoKnow/wp-includes/js/jquery/ui\";i:787634;s:45:\"/home/mangokm/MangoKnow/wp-includes/js/jquery\";i:1304968;s:52:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/langs\";i:15529;s:68:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/skins/lightgray/fonts\";i:155760;s:66:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/skins/lightgray/img\";i:2856;s:62:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/skins/lightgray\";i:210254;s:69:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/skins/wordpress/images\";i:16653;s:62:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/skins/wordpress\";i:25413;s:52:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/skins\";i:235667;s:52:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/utils\";i:18826;s:60:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/themes/modern\";i:446221;s:60:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/themes/inlite\";i:452642;s:53:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/themes\";i:898863;s:66:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/plugins/wpeditimage\";i:37709;s:62:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/plugins/charmap\";i:31811;s:69:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/plugins/directionality\";i:2749;s:64:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/plugins/wpgallery\";i:4806;s:64:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/plugins/wpdialogs\";i:3761;s:61:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/plugins/wpview\";i:8985;s:67:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/plugins/wpautoresize\";i:8332;s:64:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/plugins/wordpress\";i:50553;s:57:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/plugins/hr\";i:1347;s:68:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/plugins/wptextpattern\";i:11923;s:64:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/plugins/textcolor\";i:16237;s:60:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/plugins/media\";i:57914;s:63:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/plugins/tabfocus\";i:5336;s:59:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/plugins/link\";i:32949;s:60:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/plugins/image\";i:55874;s:65:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/plugins/fullscreen\";i:7779;s:61:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/plugins/wplink\";i:26786;s:62:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/plugins/wpemoji\";i:5099;s:66:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/plugins/colorpicker\";i:4910;s:67:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/plugins/compat3x/css\";i:8179;s:63:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/plugins/compat3x\";i:21758;s:60:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/plugins/lists\";i:97383;s:60:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/plugins/paste\";i:113193;s:54:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce/plugins\";i:607194;s:46:\"/home/mangokm/MangoKnow/wp-includes/js/tinymce\";i:2856553;s:47:\"/home/mangokm/MangoKnow/wp-includes/js/thickbox\";i:31323;s:44:\"/home/mangokm/MangoKnow/wp-includes/js/jcrop\";i:24976;s:52:\"/home/mangokm/MangoKnow/wp-includes/js/imgareaselect\";i:49553;s:38:\"/home/mangokm/MangoKnow/wp-includes/js\";i:31513410;s:35:\"/home/mangokm/MangoKnow/wp-includes\";i:50940969;s:23:\"/home/mangokm/MangoKnow\";i:588913894;s:75:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/vendor/wptt/webfont-loader\";i:22651;s:60:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/vendor/wptt\";i:22651;s:89:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/vendor/codeinwp/themeisle-sdk/src/Common\";i:8970;s:90:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/vendor/codeinwp/themeisle-sdk/src/Modules\";i:233918;s:82:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/vendor/codeinwp/themeisle-sdk/src\";i:271659;s:103:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/vendor/codeinwp/themeisle-sdk/assets/js/build/tracking\";i:37866;s:107:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/vendor/codeinwp/themeisle-sdk/assets/js/build/float_widget\";i:6041;s:100:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/vendor/codeinwp/themeisle-sdk/assets/js/build/about\";i:17544;s:101:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/vendor/codeinwp/themeisle-sdk/assets/js/build/survey\";i:2476;s:101:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/vendor/codeinwp/themeisle-sdk/assets/js/build/promos\";i:25811;s:94:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/vendor/codeinwp/themeisle-sdk/assets/js/build\";i:89738;s:88:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/vendor/codeinwp/themeisle-sdk/assets/js\";i:89738;s:98:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/vendor/codeinwp/themeisle-sdk/assets/images/otter\";i:293973;s:92:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/vendor/codeinwp/themeisle-sdk/assets/images\";i:526894;s:85:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/vendor/codeinwp/themeisle-sdk/assets\";i:616632;s:78:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/vendor/codeinwp/themeisle-sdk\";i:958241;s:64:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/vendor/codeinwp\";i:958241;s:64:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/vendor/composer\";i:49558;s:55:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/vendor\";i:1031198;s:63:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/template-parts\";i:6700;s:63:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/page-templates\";i:2861;s:59:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/assets/img\";i:5990027;s:78:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/assets/jquery-smartwizard/css\";i:43153;s:77:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/assets/jquery-smartwizard/js\";i:49821;s:74:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/assets/jquery-smartwizard\";i:92974;s:59:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/assets/css\";i:570610;s:62:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/assets/js/src\";i:148494;s:68:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/assets/js/admin/src\";i:15372;s:64:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/assets/js/admin\";i:149112;s:58:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/assets/js\";i:350827;s:72:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/assets/font-awesome/css\";i:722580;s:77:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/assets/font-awesome/webfonts\";i:1010640;s:68:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/assets/font-awesome\";i:1733220;s:69:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/assets/bootstrap/css\";i:244995;s:68:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/assets/bootstrap/js\";i:65748;s:65:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/assets/bootstrap\";i:311827;s:55:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/assets\";i:9049485;s:67:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/content-import\";i:71014;s:58:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/hooks\";i:19027;s:68:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/views/pluggable\";i:1534;s:63:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/views/blog\";i:61348;s:63:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/views/main\";i:30783;s:65:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/views/inline\";i:42858;s:69:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/views/front-page\";i:43183;s:58:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/views\";i:232139;s:80:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer/views/front-page\";i:6377;s:69:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer/views\";i:6377;s:91:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer/controls/ui/customizer-tabs\";i:15905;s:97:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer/controls/ui/helper-plugin-install\";i:9259;s:90:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer/controls/ui/subscribe-info\";i:4060;s:93:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer/controls/ui/customizer-scroll\";i:3605;s:75:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer/controls/ui\";i:60374;s:99:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer/controls/custom-controls/dimensions\";i:12446;s:109:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer/controls/custom-controls/subcontrols-allowing\";i:14993;s:111:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer/controls/custom-controls/common-functionalities\";i:3644;s:114:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer/controls/custom-controls/customizer-page-editor/js\";i:4005;s:111:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer/controls/custom-controls/customizer-page-editor\";i:15784;s:107:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer/controls/custom-controls/alpha-color-picker\";i:17325;s:100:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer/controls/custom-controls/range-value\";i:16086;s:101:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer/controls/custom-controls/multi-select\";i:3557;s:109:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer/controls/custom-controls/repeater/icon-picker\";i:9793;s:97:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer/controls/custom-controls/repeater\";i:54918;s:103:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer/controls/custom-controls/section-hiding\";i:8412;s:106:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer/controls/custom-controls/sortable-elements\";i:19394;s:102:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer/controls/custom-controls/font-selector\";i:7270;s:88:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer/controls/custom-controls\";i:173829;s:72:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer/controls\";i:234203;s:74:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer/front-page\";i:51032;s:71:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer/general\";i:78573;s:74:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer/view-hooks\";i:8901;s:63:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/customizer\";i:396611;s:68:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/infinite-scroll\";i:6297;s:82:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/admin/metabox/controls/assets\";i:4489;s:75:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/admin/metabox/controls\";i:13952;s:66:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/admin/metabox\";i:25102;s:68:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/admin/dashboard\";i:24120;s:58:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/admin\";i:63725;s:83:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/modules/woo_enhancements/views\";i:6353;s:77:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/modules/woo_enhancements\";i:17831;s:60:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/modules\";i:17831;s:60:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/helpers\";i:57098;s:66:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/core/abstract\";i:14205;s:63:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/core/types\";i:3546;s:57:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/core\";i:103258;s:65:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/setup-wizard\";i:29161;s:79:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/compatibility/child-themes\";i:11832;s:80:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/compatibility/max-mega-menu\";i:3796;s:79:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/compatibility/page-builder\";i:12710;s:82:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/compatibility/starter-content\";i:11285;s:75:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/compatibility/wp-forms\";i:4217;s:78:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/compatibility/woocommerce\";i:27833;s:85:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/compatibility/block-patterns/img\";i:163294;s:81:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/compatibility/block-patterns\";i:231894;s:66:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc/compatibility\";i:324897;s:52:\"/home/mangokm/MangoKnow/wp-content/themes/hestia/inc\";i:1330078;s:48:\"/home/mangokm/MangoKnow/wp-content/themes/hestia\";i:13737659;s:65:\"/home/mangokm/MangoKnow/wp-content/themes/mango-know-hestia-child\";i:367908;s:41:\"/home/mangokm/MangoKnow/wp-content/themes\";i:14105595;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/templates/wp-admin/notices\";i:13165;s:82:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/templates/wp-admin/advanced\";i:12994;s:105:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/templates/wp-admin/settings/exclude-settings-modal\";i:596;s:82:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/templates/wp-admin/settings\";i:109806;s:73:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/templates/wp-admin\";i:135965;s:64:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/templates\";i:135965;s:66:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/central/css\";i:3177;s:70:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/central/modules\";i:289798;s:70:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/central/classes\";i:5986;s:65:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/central/js\";i:26213;s:69:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/central/images\";i:13902;s:62:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/central\";i:438443;s:57:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/js\";i:43611;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/css/tether-shepherd/.min\";i:0;s:74:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/css/tether-shepherd\";i:143359;s:58:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/css\";i:434564;s:69:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/images/notices\";i:325945;s:67:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/images/icons\";i:24518;s:75:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/images/other-plugins\";i:96806;s:75:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/images/addons-images\";i:142451;s:61:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/images\";i:822883;s:70:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/pcloud\";i:12476;s:71:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/blockui\";i:47759;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/checkout-embed/assets\";i:11244;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/checkout-embed\";i:17434;s:80:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/labelauty/images\";i:472;s:73:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/labelauty\";i:36039;s:89:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/jquery-ui.dialog.extended\";i:14405;s:90:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/jstree/themes/default-dark\";i:73945;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/jstree/themes/default\";i:68432;s:77:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/jstree/themes\";i:142377;s:70:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/jstree\";i:594994;s:77:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/Google/Logger\";i:18584;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/Google/Verifier\";i:3307;s:76:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/Google/Cache\";i:17424;s:75:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/Google/Task\";i:8322;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/Google/Service\";i:383774;s:76:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/Google/Utils\";i:9475;s:75:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/Google/Http\";i:37196;s:77:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/Google/Signer\";i:4124;s:75:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/Google/Auth\";i:37154;s:73:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/Google/IO\";i:161886;s:70:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/Google\";i:733762;s:76:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/updraftclone\";i:31783;s:74:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/cloudfiles\";i:151462;s:70:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/tether\";i:82884;s:70:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/images\";i:29508;s:84:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/jquery.serializeJSON\";i:20249;s:87:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/Dropbox2/OAuth/Consumer\";i:42129;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/Dropbox2/OAuth/Storage\";i:11679;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/Dropbox2/OAuth\";i:53808;s:72:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/Dropbox2\";i:69788;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/tether-shepherd\";i:80786;s:71:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/select2\";i:265313;s:74:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes/handlebars\";i:395258;s:63:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/includes\";i:4138062;s:62:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/methods\";i:479250;s:64:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/languages\";i:13064984;s:82:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/psr/http-message/src\";i:46833;s:83:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/psr/http-message/docs\";i:15040;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/psr/http-message\";i:65167;s:82:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/psr/log/Psr/Log/Test\";i:9427;s:77:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/psr/log/Psr/Log\";i:20898;s:73:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/psr/log/Psr\";i:20898;s:69:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/psr/log\";i:23891;s:65:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/psr\";i:89058;s:118:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/rackspace/php-opencloud/lib/OpenCloud/Identity/Constants\";i:755;s:117:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/rackspace/php-opencloud/lib/OpenCloud/Identity/Resource\";i:16089;s:108:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/rackspace/php-opencloud/lib/OpenCloud/Identity\";i:22790;s:121:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/rackspace/php-opencloud/lib/OpenCloud/ObjectStore/Exception\";i:5636;s:118:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/rackspace/php-opencloud/lib/OpenCloud/ObjectStore/Upload\";i:34608;s:116:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/rackspace/php-opencloud/lib/OpenCloud/ObjectStore/Enum\";i:854;s:120:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/rackspace/php-opencloud/lib/OpenCloud/ObjectStore/Resource\";i:57351;s:121:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/rackspace/php-opencloud/lib/OpenCloud/ObjectStore/Constants\";i:1917;s:111:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/rackspace/php-opencloud/lib/OpenCloud/ObjectStore\";i:114248;s:114:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/rackspace/php-opencloud/lib/OpenCloud/Common/Service\";i:28878;s:115:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/rackspace/php-opencloud/lib/OpenCloud/Common/Resource\";i:23040;s:117:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/rackspace/php-opencloud/lib/OpenCloud/Common/Exceptions\";i:77739;s:116:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/rackspace/php-opencloud/lib/OpenCloud/Common/Constants\";i:6623;s:119:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/rackspace/php-opencloud/lib/OpenCloud/Common/Http/Message\";i:2972;s:111:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/rackspace/php-opencloud/lib/OpenCloud/Common/Http\";i:4183;s:117:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/rackspace/php-opencloud/lib/OpenCloud/Common/Collection\";i:16997;s:110:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/rackspace/php-opencloud/lib/OpenCloud/Common/Log\";i:5833;s:106:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/rackspace/php-opencloud/lib/OpenCloud/Common\";i:194611;s:112:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/rackspace/php-opencloud/lib/OpenCloud/CDN/Resource\";i:4334;s:103:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/rackspace/php-opencloud/lib/OpenCloud/CDN\";i:9767;s:99:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/rackspace/php-opencloud/lib/OpenCloud\";i:366792;s:89:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/rackspace/php-opencloud/lib\";i:367448;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/rackspace/php-opencloud\";i:380269;s:71:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/rackspace\";i:380269;s:94:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/brumann/polyfill-unserialize/src\";i:6471;s:90:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/brumann/polyfill-unserialize\";i:13661;s:69:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/brumann\";i:13661;s:87:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/eher/oauth/src/Eher/OAuth\";i:27074;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/eher/oauth/src/Eher\";i:27074;s:76:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/eher/oauth/src\";i:27074;s:72:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/eher/oauth\";i:27840;s:66:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/eher\";i:27840;s:90:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/paragonie/random_compat/dist\";i:703;s:89:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/paragonie/random_compat/lib\";i:43330;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/paragonie/random_compat\";i:46038;s:71:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/paragonie\";i:46038;s:91:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/mikemccabe/json-patch-php/src\";i:16737;s:87:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/mikemccabe/json-patch-php\";i:34562;s:72:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/mikemccabe\";i:34562;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzlehttp/psr7/src\";i:171673;s:77:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzlehttp/psr7\";i:211895;s:90:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzlehttp/guzzle/src/Cookie\";i:27613;s:93:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzlehttp/guzzle/src/Exception\";i:8419;s:91:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzlehttp/guzzle/src/Handler\";i:59205;s:83:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzlehttp/guzzle/src\";i:197096;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzlehttp/guzzle\";i:335105;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzlehttp/promises/src\";i:57602;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzlehttp/promises\";i:79743;s:72:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzlehttp\";i:626743;s:70:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/composer\";i:122705;s:105:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/symfony/polyfill-intl-idn/Resources/unidata\";i:268978;s:97:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/symfony/polyfill-intl-idn/Resources\";i:268978;s:87:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/symfony/polyfill-intl-idn\";i:307158;s:100:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/symfony/polyfill-php70/Resources/stubs\";i:726;s:94:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/symfony/polyfill-php70/Resources\";i:726;s:84:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/symfony/polyfill-php70\";i:6857;s:106:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/symfony/event-dispatcher/DependencyInjection\";i:4306;s:92:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/symfony/event-dispatcher/Debug\";i:13890;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/symfony/event-dispatcher\";i:48258;s:112:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/symfony/polyfill-intl-normalizer/Resources/unidata\";i:137233;s:110:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/symfony/polyfill-intl-normalizer/Resources/stubs\";i:337;s:104:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/symfony/polyfill-intl-normalizer/Resources\";i:137570;s:94:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/symfony/polyfill-intl-normalizer\";i:150244;s:105:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/symfony/polyfill-mbstring/Resources/unidata\";i:55556;s:97:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/symfony/polyfill-mbstring/Resources\";i:56387;s:87:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/symfony/polyfill-mbstring\";i:94302;s:84:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/symfony/polyfill-php72\";i:11495;s:69:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/symfony\";i:618314;s:96:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/phpseclib/phpseclib/phpseclib/Math\";i:128985;s:100:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/phpseclib/phpseclib/phpseclib/Net/SFTP\";i:21872;s:95:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/phpseclib/phpseclib/phpseclib/Net\";i:405984;s:108:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/phpseclib/phpseclib/phpseclib/System/SSH/Agent\";i:6238;s:102:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/phpseclib/phpseclib/phpseclib/System/SSH\";i:16935;s:98:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/phpseclib/phpseclib/phpseclib/System\";i:16935;s:97:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/phpseclib/phpseclib/phpseclib/Crypt\";i:522876;s:101:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/phpseclib/phpseclib/phpseclib/File/ASN1\";i:870;s:96:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/phpseclib/phpseclib/phpseclib/File\";i:268333;s:91:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/phpseclib/phpseclib/phpseclib\";i:1343789;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/phpseclib/phpseclib\";i:1352383;s:71:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/phpseclib\";i:1352383;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/components/jquery\";i:920067;s:72:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/components\";i:920067;s:106:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Http/Message/Header\";i:9844;s:99:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Http/Message\";i:111359;s:101:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Http/Exception\";i:8744;s:107:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Http/QueryAggregator\";i:2390;s:101:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Http/Resources\";i:250394;s:96:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Http/Curl\";i:42554;s:91:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Http\";i:547692;s:93:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Stream\";i:23218;s:106:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Service/Description\";i:73510;s:102:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Service/Builder\";i:11299;s:103:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Service/Resource\";i:21289;s:104:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Service/Exception\";i:5175;s:110:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Service/Command/Factory\";i:10071;s:126:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Service/Command/LocationVisitor/Request\";i:19774;s:127:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Service/Command/LocationVisitor/Response\";i:14837;s:118:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Service/Command/LocationVisitor\";i:39430;s:102:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Service/Command\";i:85906;s:94:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Service\";i:218051;s:99:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Plugin/Oauth\";i:10949;s:101:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Plugin/Backoff\";i:20176;s:99:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Plugin/Cache\";i:36113;s:98:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Plugin/Mock\";i:7654;s:97:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Plugin/Log\";i:6608;s:97:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Plugin/Md5\";i:6303;s:102:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Plugin/CurlAuth\";i:2078;s:110:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Plugin/Cookie/Exception\";i:170;s:110:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Plugin/Cookie/CookieJar\";i:12080;s:100:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Plugin/Cookie\";i:27437;s:117:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Plugin/ErrorResponse/Exception\";i:161;s:107:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Plugin/ErrorResponse\";i:4336;s:99:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Plugin/Async\";i:3637;s:101:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Plugin/History\";i:4589;s:93:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Plugin\";i:131244;s:95:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Iterator\";i:5538;s:90:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Log\";i:12255;s:92:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Cache\";i:12244;s:97:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Parser/Url\";i:1960;s:105:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Parser/UriTemplate\";i:9419;s:100:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Parser/Cookie\";i:6214;s:101:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Parser/Message\";i:6940;s:93:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Parser\";i:26953;s:102:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Batch/Exception\";i:2699;s:92:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Batch\";i:26836;s:97:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Inflection\";i:5787;s:103:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Common/Exception\";i:3464;s:93:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle/Common\";i:20491;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src/Guzzle\";i:1030309;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle/src\";i:1030309;s:75:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle/guzzle\";i:1110818;s:68:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/guzzle\";i:1110818;s:89:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/ralouphie/getallheaders/src\";i:1640;s:91:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/ralouphie/getallheaders/tests\";i:3595;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/ralouphie/getallheaders\";i:8082;s:71:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/ralouphie\";i:8082;s:104:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/team-updraft/common-libs/src/updraft-tasks\";i:47316;s:108:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/team-updraft/common-libs/src/updraft-semaphore\";i:9101;s:106:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/team-updraft/common-libs/src/updraft-notices\";i:8102;s:102:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/team-updraft/common-libs/src/updraft-rpc\";i:83094;s:90:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/team-updraft/common-libs/src\";i:147613;s:89:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/team-updraft/common-libs/CI\";i:1206;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/team-updraft/common-libs\";i:149996;s:74:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor/team-updraft\";i:149996;s:61:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus/vendor\";i:5501307;s:54:\"/home/mangokm/MangoKnow/wp-content/plugins/updraftplus\";i:26539461;s:65:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/views/notices\";i:1420;s:66:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/views/settings\";i:1843;s:66:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/views/particle\";i:1233;s:57:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/views\";i:4496;s:96:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/vendor/enshrined/svg-sanitize/src/Exceptions\";i:792;s:102:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/vendor/enshrined/svg-sanitize/src/ElementReference\";i:9511;s:90:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/vendor/enshrined/svg-sanitize/src/data\";i:14520;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/vendor/enshrined/svg-sanitize/src\";i:49796;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/vendor/enshrined/svg-sanitize\";i:72156;s:68:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/vendor/enshrined\";i:72156;s:62:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/vendor/bin\";i:0;s:67:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/vendor/composer\";i:41591;s:58:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/vendor\";i:114495;s:66:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/includes/Admin\";i:6908;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/includes/Controller/Import/Methods\";i:9984;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/includes/Controller/Import\";i:17722;s:71:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/includes/Controller\";i:41493;s:66:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/includes/Model\";i:26752;s:67:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/includes/Blocks\";i:3011;s:66:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/includes/Utils\";i:4631;s:65:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/includes/Rest\";i:10345;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/includes/Classes/Attachment\";i:2229;s:76:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/includes/Classes/Modules\";i:4758;s:68:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/includes/Classes\";i:46010;s:72:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/includes/Support/ACF\";i:3919;s:68:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/includes/Support\";i:27079;s:60:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/includes\";i:191885;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/blocks/filebird-gallery/build\";i:216029;s:82:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/blocks/filebird-gallery/.turbo\";i:0;s:80:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/blocks/filebird-gallery/dist\";i:0;s:75:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/blocks/filebird-gallery\";i:218090;s:58:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/blocks\";i:218090;s:62:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/assets/img\";i:360208;s:72:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/assets/js/photoswipe\";i:51314;s:61:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/assets/js\";i:61289;s:73:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/assets/css/photoswipe\";i:16752;s:62:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/assets/css\";i:16752;s:63:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/assets/dist\";i:819932;s:58:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/assets\";i:1258181;s:66:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/i18n/languages\";i:1107083;s:56:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird/i18n\";i:1107083;s:51:\"/home/mangokm/MangoKnow/wp-content/plugins/filebird\";i:2930803;s:68:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/iwp-serve\";i:23961;s:67:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/iwp-dest\";i:17820;s:72:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/assets/images\";i:5541;s:69:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/assets/css\";i:46294;s:68:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/assets/js\";i:89311;s:69:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/assets/src\";i:5658;s:65:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/assets\";i:146804;s:68:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/languages\";i:28889;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/migrate/templates/ajax\";i:13990;s:82:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/migrate/templates/debug\";i:8049;s:76:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/migrate/templates\";i:142815;s:80:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/migrate/assets/images\";i:78992;s:77:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/migrate/assets/css\";i:16977;s:73:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/migrate/assets\";i:95969;s:66:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/migrate\";i:243479;s:110:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/File/ASN1/Maps\";i:95182;s:105:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/File/ASN1\";i:96002;s:100:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/File\";i:320949;s:105:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Exception\";i:6721;s:115:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Crypt/Common/Traits\";i:2776;s:126:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Crypt/Common/Formats/Signature\";i:1257;s:121:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Crypt/Common/Formats/Keys\";i:61885;s:116:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Crypt/Common/Formats\";i:63142;s:108:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Crypt/Common\";i:213004;s:117:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Crypt/DH/Formats/Keys\";i:5951;s:112:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Crypt/DH/Formats\";i:5951;s:104:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Crypt/DH\";i:9495;s:117:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Crypt/EC/Formats/Keys\";i:82874;s:122:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Crypt/EC/Formats/Signature\";i:5692;s:112:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Crypt/EC/Formats\";i:88566;s:111:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Crypt/EC/Curves\";i:94479;s:115:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Crypt/EC/BaseCurves\";i:58699;s:104:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Crypt/EC\";i:258295;s:118:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Crypt/RSA/Formats/Keys\";i:47955;s:113:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Crypt/RSA/Formats\";i:47955;s:105:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Crypt/RSA\";i:79373;s:118:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Crypt/DSA/Formats/Keys\";i:22656;s:123:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Crypt/DSA/Formats/Signature\";i:3607;s:113:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Crypt/DSA/Formats\";i:26263;s:105:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Crypt/DSA\";i:34362;s:101:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Crypt\";i:1030136;s:104:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Net/SFTP\";i:21505;s:99:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Net\";i:349840;s:112:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Common/Functions\";i:16354;s:102:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Common\";i:16354;s:120:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/System/SSH/Common/Traits\";i:789;s:113:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/System/SSH/Common\";i:789;s:112:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/System/SSH/Agent\";i:9007;s:106:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/System/SSH\";i:18802;s:102:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/System\";i:18802;s:123:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Math/BigInteger/Engines/GMP\";i:892;s:137:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Math/BigInteger/Engines/BCMath/Reductions\";i:10091;s:126:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Math/BigInteger/Engines/BCMath\";i:14602;s:134:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Math/BigInteger/Engines/PHP/Reductions\";i:37717;s:123:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Math/BigInteger/Engines/PHP\";i:45858;s:119:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Math/BigInteger/Engines\";i:195176;s:111:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Math/BigInteger\";i:195176;s:111:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Math/PrimeField\";i:10681;s:112:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Math/BinaryField\";i:13774;s:119:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Math/Common/FiniteField\";i:1024;s:107:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Math/Common\";i:1399;s:100:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib/Math\";i:251985;s:95:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib/phpseclib\";i:1995632;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib/phpseclib\";i:1997785;s:75:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/phpseclib\";i:1997785;s:98:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/wp-cli/wp-config-transformer/src\";i:11259;s:94:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/wp-cli/wp-config-transformer\";i:13899;s:72:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/wp-cli\";i:13899;s:93:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/instawp/connect-helpers/src\";i:84988;s:89:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/instawp/connect-helpers\";i:86545;s:73:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/instawp\";i:86545;s:74:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/composer\";i:156535;s:105:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/woocommerce/action-scheduler/deprecated\";i:13482;s:114:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/woocommerce/action-scheduler/lib/cron-expression\";i:29943;s:98:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/woocommerce/action-scheduler/lib\";i:33661;s:114:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/woocommerce/action-scheduler/classes/data-stores\";i:107282;s:110:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/woocommerce/action-scheduler/classes/actions\";i:5692;s:112:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/woocommerce/action-scheduler/classes/migration\";i:28258;s:109:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/woocommerce/action-scheduler/classes/schema\";i:8265;s:116:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/woocommerce/action-scheduler/classes/WP_CLI/Action\";i:25921;s:109:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/woocommerce/action-scheduler/classes/WP_CLI\";i:66355;s:112:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/woocommerce/action-scheduler/classes/abstracts\";i:91627;s:112:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/woocommerce/action-scheduler/classes/schedules\";i:11643;s:102:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/woocommerce/action-scheduler/classes\";i:429738;s:94:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/woocommerce/action-scheduler\";i:556649;s:77:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/woocommerce\";i:556649;s:94:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/paragonie/random_compat/dist\";i:703;s:95:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/paragonie/random_compat/other\";i:1633;s:93:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/paragonie/random_compat/lib\";i:1327;s:89:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/paragonie/random_compat\";i:5722;s:102:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/paragonie/constant_time_encoding/src\";i:61964;s:98:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/paragonie/constant_time_encoding\";i:64369;s:75:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor/paragonie\";i:70091;s:65:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/vendor\";i:2882252;s:75:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/includes/updates\";i:4116;s:84:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/includes/database-manager\";i:2582;s:72:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/includes/sync\";i:223941;s:80:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/includes/activity-log\";i:30427;s:72:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/includes/apis\";i:96873;s:67:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/includes\";i:660560;s:67:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/admin/js\";i:90522;s:68:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/admin/css\";i:69228;s:71:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/admin/images\";i:5983;s:64:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect/admin\";i:172092;s:58:\"/home/mangokm/MangoKnow/wp-content/plugins/instawp-connect\";i:4224952;s:64:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/languages\";i:701410;s:90:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/app/backwards/themes/default/images\";i:835;s:97:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/app/backwards/themes/default/bootstrap/css\";i:121865;s:96:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/app/backwards/themes/default/bootstrap/js\";i:37045;s:93:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/app/backwards/themes/default/bootstrap\";i:158910;s:83:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/app/backwards/themes/default\";i:163775;s:75:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/app/backwards/themes\";i:163775;s:68:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/app/backwards\";i:212005;s:67:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/app/includes\";i:168281;s:58:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/app\";i:957165;s:69:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/resources/post\";i:30656;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/resources/data-templates\";i:1676063;s:70:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/resources/views\";i:84408;s:64:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/resources\";i:1791127;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/public/img/font-previews\";i:55693;s:72:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/public/img/wpcode\";i:1212443;s:68:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/public/img/bg\";i:258262;s:76:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/public/img/drag-icons\";i:21613;s:65:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/public/img\";i:2386227;s:71:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/public/svg/logos\";i:157510;s:65:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/public/svg\";i:197481;s:82:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/public/fontawesome/webfonts\";i:1017392;s:77:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/public/fontawesome/css\";i:96518;s:73:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/public/fontawesome\";i:1113910;s:64:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/public/js\";i:1063459;s:89:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/public/css/photoswipe/default-skin\";i:14574;s:76:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/public/css/photoswipe\";i:19641;s:65:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/public/css\";i:2126731;s:82:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/public/lite/vue-backend/img\";i:8476;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/public/lite/vue-backend/js\";i:3787567;s:82:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/public/lite/vue-backend/css\";i:39628;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/public/lite/vue-backend\";i:3838321;s:66:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/public/lite\";i:3838321;s:61:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon/public\";i:10726129;s:54:\"/home/mangokm/MangoKnow/wp-content/plugins/coming-soon\";i:14215918;s:74:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/includes/providers\";i:62988;s:71:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/includes/fields\";i:316870;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/includes/admin/builder/panels\";i:67420;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/includes/admin/builder\";i:149229;s:70:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/includes/admin\";i:367375;s:74:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/includes/functions\";i:161009;s:74:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/includes/templates\";i:11754;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/includes/emails/templates\";i:23742;s:71:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/includes/emails\";i:46277;s:64:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/includes\";i:1135866;s:103:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/symfony/polyfill-iconv/Resources/charset\";i:1520414;s:95:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/symfony/polyfill-iconv/Resources\";i:1520414;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/symfony/polyfill-iconv\";i:1551918;s:101:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/symfony/polyfill-php80/Resources/stubs\";i:2168;s:95:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/symfony/polyfill-php80/Resources\";i:2168;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/symfony/polyfill-php80\";i:10598;s:106:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/symfony/polyfill-mbstring/Resources/unidata\";i:59463;s:98:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/symfony/polyfill-mbstring/Resources\";i:59463;s:88:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/symfony/polyfill-mbstring\";i:115179;s:70:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/symfony\";i:1677695;s:102:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/woocommerce/action-scheduler/deprecated\";i:13482;s:113:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/woocommerce/action-scheduler/classes/WP_CLI/Action\";i:25921;s:106:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/woocommerce/action-scheduler/classes/WP_CLI\";i:66355;s:106:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/woocommerce/action-scheduler/classes/schema\";i:8265;s:107:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/woocommerce/action-scheduler/classes/actions\";i:5692;s:109:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/woocommerce/action-scheduler/classes/abstracts\";i:91627;s:109:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/woocommerce/action-scheduler/classes/schedules\";i:11643;s:111:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/woocommerce/action-scheduler/classes/data-stores\";i:107282;s:109:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/woocommerce/action-scheduler/classes/migration\";i:28258;s:99:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/woocommerce/action-scheduler/classes\";i:429738;s:111:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/woocommerce/action-scheduler/lib/cron-expression\";i:29943;s:95:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/woocommerce/action-scheduler/lib\";i:33661;s:91:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/woocommerce/action-scheduler\";i:534789;s:74:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/woocommerce\";i:534789;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/psr/log/Psr/Log\";i:11471;s:74:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/psr/log/Psr\";i:11471;s:70:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/psr/log\";i:12556;s:66:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/psr\";i:12556;s:71:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor/composer\";i:1041497;s:62:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor\";i:3267285;s:107:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/symfony/css-selector/Parser/Handler\";i:10671;s:109:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/symfony/css-selector/Parser/Tokenizer\";i:6663;s:108:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/symfony/css-selector/Parser/Shortcut\";i:6020;s:99:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/symfony/css-selector/Parser\";i:43546;s:102:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/symfony/css-selector/Exception\";i:4401;s:108:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/symfony/css-selector/XPath/Extension\";i:27324;s:98:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/symfony/css-selector/XPath\";i:38130;s:97:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/symfony/css-selector/Node\";i:17356;s:92:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/symfony/css-selector\";i:106537;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/symfony\";i:106537;s:122:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/tijsverkoyen/css-to-inline-styles/src/Css/Property\";i:4795;s:118:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/tijsverkoyen/css-to-inline-styles/src/Css/Rule\";i:6555;s:113:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/tijsverkoyen/css-to-inline-styles/src/Css\";i:13274;s:109:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/tijsverkoyen/css-to-inline-styles/src\";i:20598;s:105:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/tijsverkoyen/css-to-inline-styles\";i:20598;s:84:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/tijsverkoyen\";i:20598;s:104:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/core-interfaces/src/Sdk\";i:879;s:105:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/core-interfaces/src/Http\";i:2114;s:114:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/core-interfaces/src/Core/Response\";i:423;s:120:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/core-interfaces/src/Core/Authentication\";i:615;s:113:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/core-interfaces/src/Core/Request\";i:4460;s:112:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/core-interfaces/src/Core/Logger\";i:613;s:105:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/core-interfaces/src/Core\";i:6652;s:100:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/core-interfaces/src\";i:9645;s:96:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/core-interfaces\";i:10714;s:104:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/core/src/Response/Types\";i:8405;s:98:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/core/src/Response\";i:19767;s:110:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/core/src/Logger/Configuration\";i:5790;s:96:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/core/src/Logger\";i:12482;s:99:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/core/src/Types/Sdk\";i:12095;s:95:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/core/src/Types\";i:13663;s:95:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/core/src/Utils\";i:42864;s:111:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/core/src/TestCase/BodyMatchers\";i:12211;s:98:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/core/src/TestCase\";i:21554;s:108:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/core/src/Request/Parameters\";i:21633;s:97:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/core/src/Request\";i:32582;s:100:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/core/src/Exceptions\";i:647;s:104:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/core/src/Authentication\";i:4785;s:89:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/core/src\";i:159848;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/core\";i:160917;s:104:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/unirest-php/src/Request\";i:5551;s:96:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/unirest-php/src\";i:32251;s:92:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/unirest-php\";i:33432;s:99:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/jsonmapper/example\";i:971;s:95:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/jsonmapper/src\";i:91489;s:91:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic/jsonmapper\";i:92460;s:80:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/apimatic\";i:297523;s:121:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/Injector\";i:28272;s:125:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/EntityLookup\";i:5311;s:130:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/Language/messages\";i:4068;s:121:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/Language\";i:4068;s:120:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/Printer\";i:25911;s:124:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/AttrDef/CSS\";i:52900;s:130:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/AttrDef/URI/Email\";i:854;s:124:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/AttrDef/URI\";i:9951;s:125:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/AttrDef/HTML\";i:16113;s:120:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/AttrDef\";i:95989;s:126:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/AttrTransform\";i:23591;s:119:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/Filter\";i:16545;s:128:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/HTMLModule/Tidy\";i:9530;s:123:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/HTMLModule\";i:55317;s:122:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/URIFilter\";i:13591;s:122:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/URIScheme\";i:12036;s:121:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/Strategy\";i:46643;s:138:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/DefinitionCache/Decorator\";i:3798;s:128:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/DefinitionCache\";i:16779;s:117:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/Node\";i:3912;s:118:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/Lexer\";i:201531;s:125:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/TagTransform\";i:4398;s:121:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/ChildDef\";i:23655;s:118:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/Token\";i:5251;s:122:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/VarParser\";i:5939;s:133:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/ConfigSchema/Builder\";i:5533;s:137:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/ConfigSchema/Interchange\";i:3081;s:125:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier/ConfigSchema\";i:52700;s:112:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library/HTMLPurifier\";i:964740;s:99:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier/library\";i:1002660;s:91:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang/htmlpurifier\";i:1029116;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/ezyang\";i:1029116;s:99:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/true/punycode/src/Exception\";i:682;s:89:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/true/punycode/src\";i:11338;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/true/punycode\";i:12396;s:76:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/true\";i:12396;s:94:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/square/square/src/Http\";i:4599;s:104:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/square/square/src/Authentication\";i:2247;s:105:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/square/square/src/Models/Builders\";i:1902850;s:96:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/square/square/src/Models\";i:6459757;s:95:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/square/square/src/Utils\";i:4689;s:94:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/square/square/src/Apis\";i:428025;s:100:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/square/square/src/Exceptions\";i:1437;s:89:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/square/square/src\";i:6936772;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/square/square\";i:6939549;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/square\";i:6939549;s:123:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/php-jsonpointer/php-jsonpointer/src/Rs/Json/Pointer\";i:422;s:115:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/php-jsonpointer/php-jsonpointer/src/Rs/Json\";i:5904;s:110:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/php-jsonpointer/php-jsonpointer/src/Rs\";i:5904;s:107:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/php-jsonpointer/php-jsonpointer/src\";i:5904;s:103:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/php-jsonpointer/php-jsonpointer\";i:5904;s:87:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/php-jsonpointer\";i:5904;s:94:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/data\";i:215352;s:114:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/FinancialConnections\";i:15037;s:100:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Events\";i:2172;s:102:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Identity\";i:12950;s:104:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Forwarding\";i:4538;s:107:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/ApiOperations\";i:16009;s:105:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/TestHelpers\";i:4513;s:104:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/V2/Billing\";i:3514;s:96:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/V2\";i:9165;s:107:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/BillingPortal\";i:8445;s:102:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Checkout\";i:15279;s:99:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Sigma\";i:2861;s:97:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Tax\";i:21039;s:101:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Billing\";i:27016;s:109:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Exception/OAuth\";i:2743;s:103:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Exception\";i:15782;s:101:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Issuing\";i:49550;s:99:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Radar\";i:13272;s:103:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/EventData\";i:1226;s:101:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Climate\";i:11692;s:111:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Service/Reporting\";i:4105;s:112:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Service/Forwarding\";i:2365;s:115:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Service/BillingPortal\";i:4089;s:110:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Service/Identity\";i:8070;s:105:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Service/Tax\";i:9232;s:114:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Service/Entitlements\";i:4395;s:110:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Service/Checkout\";i:4280;s:122:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Service/TestHelpers/Treasury\";i:11615;s:122:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Service/TestHelpers/Terminal\";i:1595;s:121:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Service/TestHelpers/Issuing\";i:12839;s:113:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Service/TestHelpers\";i:32813;s:112:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Service/V2/Billing\";i:4982;s:109:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Service/V2/Core\";i:6536;s:104:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Service/V2\";i:12193;s:109:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Service/Climate\";i:6851;s:109:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Service/Billing\";i:15731;s:106:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Service/Apps\";i:2745;s:109:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Service/Issuing\";i:22500;s:122:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Service/FinancialConnections\";i:8344;s:107:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Service/Sigma\";i:1982;s:107:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Service/Radar\";i:8206;s:110:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Service/Terminal\";i:13406;s:110:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Service/Treasury\";i:22720;s:101:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Service\";i:416222;s:106:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Entitlements\";i:6783;s:104:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/HttpClient\";i:28457;s:102:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Treasury\";i:53791;s:103:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Reporting\";i:7707;s:98:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Apps\";i:4326;s:102:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Terminal\";i:19285;s:98:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib/Util\";i:40325;s:93:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php/lib\";i:1466543;s:89:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe/stripe-php\";i:1704087;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed/stripe\";i:1704087;s:71:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/vendor_prefixed\";i:10115710;s:93:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/lite/templates/admin/entries/overview\";i:16000;s:91:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/lite/templates/admin/entries/single\";i:19649;s:84:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/lite/templates/admin/entries\";i:36447;s:76:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/lite/templates/admin\";i:39932;s:95:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/lite/templates/education/admin/settings\";i:1357;s:99:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/lite/templates/education/admin/lite-connect\";i:2550;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/lite/templates/education/admin\";i:8813;s:101:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/lite/templates/education/builder/lite-connect\";i:4458;s:88:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/lite/templates/education/builder\";i:8075;s:80:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/lite/templates/education\";i:20241;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/lite/templates/builder\";i:5029;s:70:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/lite/templates\";i:65202;s:60:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/lite\";i:102700;s:84:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/lite/js/admin/entries\";i:6234;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/lite/js/admin/education\";i:27136;s:84:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/lite/js/admin/builder\";i:3262;s:76:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/lite/js/admin\";i:53888;s:93:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/lite/js/integrations/elementor\";i:10959;s:93:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/lite/js/integrations/gutenberg\";i:715471;s:83:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/lite/js/integrations\";i:726430;s:70:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/lite/js\";i:780318;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/lite/images/sample\";i:1529221;s:74:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/lite/images\";i:1529221;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/lite/css/admin/entries\";i:54181;s:77:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/lite/css/admin\";i:54181;s:71:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/lite/css\";i:174576;s:67:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/lite\";i:2484115;s:75:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/email\";i:11105;s:91:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/empty-states/payments\";i:125520;s:82:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/empty-states\";i:305806;s:74:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/smtp\";i:109842;s:76:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/splash\";i:7422;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/payments/status\";i:5202;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/payments/single\";i:10173;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/payments\";i:21777;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/entry-automation\";i:216953;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/richtext\";i:15600;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/gutenberg\";i:128506;s:88:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/privacy-compliance\";i:132671;s:76:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/stripe\";i:4303;s:90:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/lite-settings-access\";i:415352;s:92:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/frontend/file-download\";i:1351;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/frontend\";i:1351;s:97:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/integrations/elementor/font\";i:18380;s:92:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/integrations/elementor\";i:18833;s:89:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/integrations/stripe\";i:3157;s:92:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/integrations/gutenberg\";i:3779;s:87:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/integrations/divi\";i:692;s:94:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/integrations/woocommerce\";i:10601;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/integrations/ai\";i:52276;s:82:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/integrations\";i:89338;s:82:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/lite-connect\";i:8307;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/constant-contact\";i:395931;s:77:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/builder\";i:104929;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/anti-spam\";i:14012;s:75:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/about\";i:671740;s:87:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/admin-flyout-menu\";i:8689;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/challenge\";i:115111;s:83:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/pdf-education\";i:1777;s:87:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/coupons-education\";i:218083;s:75:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/phone\";i:1883;s:91:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/geolocation-education\";i:418254;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images/community\";i:23081;s:69:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/images\";i:4025958;s:72:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/languages\";i:458174;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/lib/jquery.confirm\";i:41024;s:84:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/lib/jquery.minicolors\";i:23788;s:71:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/lib/lity\";i:8371;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/lib/font-awesome/fonts\";i:950853;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/lib/font-awesome\";i:983257;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/lib/jquery.tooltipster\";i:46842;s:84:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/lib/jquery.timepicker\";i:16638;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/lib/wpforms-multiselect\";i:15590;s:76:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/lib/flatpickr\";i:65803;s:66:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/lib\";i:1748339;s:68:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/fonts\";i:16607;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/frontend/fields\";i:45933;s:74:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/frontend\";i:249097;s:90:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/admin/education/pointers\";i:3103;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/admin/education\";i:99228;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/admin/challenge\";i:59073;s:80:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/admin/payments\";i:44301;s:77:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/admin/pages\";i:27826;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/admin/logger\";i:3651;s:77:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/admin/email\";i:21876;s:77:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/admin/share\";i:100841;s:94:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/admin/builder/themes/modules\";i:99739;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/admin/builder/themes\";i:111118;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/admin/builder/fields\";i:38756;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/admin/builder\";i:962215;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/admin/splash\";i:3803;s:77:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/admin/forms\";i:44009;s:71:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/admin\";i:1516136;s:91:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/integrations/square/admin\";i:33200;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/integrations/square\";i:62026;s:88:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/integrations/elementor\";i:110218;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/integrations/stripe\";i:118540;s:102:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/integrations/ai/chat-element/modules\";i:23189;s:94:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/integrations/ai/chat-element\";i:81839;s:104:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/integrations/ai/form-generator/modules\";i:48204;s:96:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/integrations/ai/form-generator\";i:56740;s:89:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/integrations/ai/choices\";i:10537;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/integrations/ai\";i:149116;s:96:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/integrations/gutenberg/modules\";i:129871;s:88:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/integrations/gutenberg\";i:199646;s:98:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/integrations/constant-contact-v3\";i:29375;s:83:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/integrations/divi\";i:226491;s:90:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/integrations/woocommerce\";i:1952;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/integrations/wpcode\";i:4859;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/integrations\";i:902223;s:71:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js/share\";i:8604;s:65:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/js\";i:2676060;s:83:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/css/frontend/classic\";i:378411;s:82:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/css/frontend/modern\";i:465372;s:75:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/css/frontend\";i:854032;s:74:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/css/builder\";i:861814;s:82:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/css/emails/partials\";i:21177;s:73:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/css/emails\";i:167033;s:72:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/css/admin\";i:73998;s:82:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/css/integrations/ai\";i:94119;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/css/integrations/stripe\";i:59411;s:91:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/css/integrations/woocommerce\";i:2730;s:91:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/css/integrations/square/divi\";i:43119;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/css/integrations/square\";i:79322;s:84:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/css/integrations/divi\";i:2008453;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/css/integrations\";i:2244035;s:66:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets/css\";i:5210471;s:62:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/assets\";i:16619724;s:72:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/emails\";i:48889;s:88:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/integrations/elementor\";i:2049;s:106:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/integrations/constant-contact-v3/builder\";i:4379;s:98:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/integrations/constant-contact-v3\";i:4379;s:93:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/integrations/stripe/builder\";i:3149;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/integrations/stripe\";i:3149;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/integrations/wpcode\";i:4642;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/integrations\";i:14219;s:77:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/admin/pages\";i:6671;s:87:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/admin/payments/single\";i:16799;s:80:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/admin/payments\";i:23725;s:77:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/admin/forms\";i:2360;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/admin/challenge\";i:11462;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/admin/splash\";i:3989;s:89:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/admin/form-embed-wizard\";i:5913;s:88:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/admin/dashboard/widget\";i:3141;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/admin/dashboard\";i:3141;s:80:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/admin/settings\";i:5445;s:93:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/admin/empty-states/payments\";i:3141;s:84:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/admin/empty-states\";i:5886;s:82:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/admin/components\";i:4550;s:71:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/admin\";i:79558;s:91:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/education/admin/edit-post\";i:1162;s:90:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/education/admin/payments\";i:1468;s:90:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/education/admin/settings\";i:1144;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/education/admin\";i:6855;s:75:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/education\";i:6855;s:83:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/builder/revisions\";i:4401;s:82:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/builder/antispam\";i:1203;s:87:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/builder/notifications\";i:2938;s:84:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/builder/fullscreen\";i:3658;s:91:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/builder/payment/recurring\";i:911;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/builder/payment\";i:2215;s:80:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/builder/themes\";i:8434;s:73:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/builder\";i:39346;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/fields/number-slider\";i:2114;s:80:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/fields/content\";i:2206;s:84:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/fields/file-upload\";i:2939;s:93:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/fields/internal-information\";i:2010;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/fields/total\";i:3210;s:72:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates/fields\";i:12479;s:65:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/templates\";i:203650;s:67:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Helpers\";i:76874;s:72:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Requirements\";i:37574;s:76:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Migrations/Tasks\";i:5266;s:70:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Migrations\";i:38634;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/SmartTags/SmartTag\";i:42392;s:69:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/SmartTags\";i:59432;s:89:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Base/Tables/DataObjects\";i:2159;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Base/Tables/Facades\";i:1595;s:77:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Base/Tables\";i:3754;s:70:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Base\";i:3754;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Notifications\";i:39826;s:75:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Dashboard\";i:8373;s:84:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Education/Pointers\";i:14115;s:83:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Education/Builder\";i:29143;s:87:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Education/Admin/Tools\";i:4383;s:90:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Education/Admin/Settings\";i:6458;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Education/Admin\";i:16873;s:75:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Education\";i:89343;s:72:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Splash\";i:20434;s:72:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Traits\";i:23848;s:82:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Settings/Captcha\";i:21209;s:74:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Settings\";i:49067;s:77:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Tools/Views\";i:63676;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Tools/Importers\";i:59336;s:71:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Tools\";i:128210;s:96:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Payments/Views/Overview/Traits\";i:8145;s:89:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Payments/Views/Overview\";i:109387;s:88:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Payments/Views/Coupons\";i:4449;s:80:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Payments/Views\";i:149348;s:74:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Payments\";i:160374;s:73:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Helpers\";i:18682;s:89:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Forms/Table/DataObjects\";i:197;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Forms/Table/Facades\";i:7945;s:77:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Forms/Table\";i:8142;s:76:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Forms/Ajax\";i:9053;s:71:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Forms\";i:107178;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Builder/Ajax\";i:4728;s:96:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Builder/Notifications/Advanced\";i:5455;s:87:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Builder/Notifications\";i:5455;s:82:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Builder/Settings\";i:34491;s:73:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Builder\";i:173729;s:72:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Blocks\";i:10193;s:72:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Addons\";i:15762;s:71:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin/Pages\";i:47039;s:65:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Admin\";i:974105;s:66:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Access\";i:1373;s:84:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/LiteConnect\";i:28988;s:83:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/WPMailSMTP\";i:5536;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/WPorg\";i:3717;s:77:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/SMTP\";i:9849;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/Square/Fields\";i:16896;s:92:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/Square/Api/Webhooks\";i:20296;s:83:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/Square/Api\";i:80257;s:100:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/Square/Admin/Builder/Traits\";i:15845;s:93:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/Square/Admin/Builder\";i:29246;s:94:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/Square/Admin/Payments\";i:4246;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/Square/Admin\";i:90951;s:92:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/Square/Integrations\";i:8370;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/Square\";i:268588;s:84:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/WooCommerce\";i:5381;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/DefaultThemes\";i:8109;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/SolidCentral\";i:598;s:84:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/AI/API/Http\";i:5828;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/AI/API\";i:20868;s:87:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/AI/Admin/Pages\";i:2850;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/AI/Admin/Ajax\";i:14926;s:89:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/AI/Admin/Builder\";i:28096;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/AI/Admin\";i:47368;s:75:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/AI\";i:72910;s:103:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/Stripe/Api/Webhooks/Exceptions\";i:400;s:92:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/Stripe/Api/Webhooks\";i:24930;s:83:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/Stripe/Api\";i:80061;s:93:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/Stripe/Fields/Traits\";i:10688;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/Stripe/Fields\";i:32360;s:100:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/Stripe/Admin/Builder/Traits\";i:21887;s:93:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/Stripe/Admin/Builder\";i:35716;s:94:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/Stripe/Admin/Payments\";i:5916;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/Stripe/Admin\";i:81527;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/Stripe\";i:279585;s:101:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/ConstantContact/V3/Migration\";i:17747;s:100:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/ConstantContact/V3/Api/Http\";i:5749;s:95:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/ConstantContact/V3/Api\";i:16301;s:100:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/ConstantContact/V3/Settings\";i:20966;s:91:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/ConstantContact/V3\";i:73282;s:88:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/ConstantContact\";i:73282;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/UsageTracking\";i:30088;s:91:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/Elementor/Controls\";i:1106;s:82:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/Elementor\";i:58984;s:77:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/Divi\";i:11602;s:89:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/UncannyAutomator\";i:5173;s:82:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/Gutenberg\";i:46124;s:87:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/DefaultContent\";i:1569;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations/WPCode\";i:6044;s:72:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Integrations\";i:919373;s:66:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Logger\";i:32487;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/EntryPreview\";i:7085;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/Hidden\";i:3696;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/DateTime\";i:24592;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/Richtext\";i:5045;s:77:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/Html\";i:4867;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/Password\";i:10230;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/Addons/Coupon\";i:7461;s:96:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/Addons/NetPromoterScore\";i:5623;s:91:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/Addons/LikertScale\";i:9492;s:89:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/Addons/Signature\";i:3651;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/Addons\";i:26227;s:82:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/Pagebreak\";i:16202;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/CustomCaptcha\";i:6844;s:76:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/Url\";i:3112;s:80:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/Address\";i:30235;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/Phone\";i:5190;s:88:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/PaymentMultiple\";i:15265;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/Traits\";i:81307;s:80:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/Content\";i:2859;s:80:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/Helpers\";i:6835;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/Rating\";i:12534;s:83:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/CreditCard\";i:7089;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/PaymentSingle\";i:23339;s:83:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/FileUpload\";i:12596;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/PaymentTotal\";i:24173;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/PaymentSelect\";i:17266;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/Camera\";i:12463;s:88:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/PaymentCheckbox\";i:16967;s:77:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/Base\";i:699;s:80:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields/Divider\";i:3546;s:72:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms/Fields\";i:380263;s:65:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Forms\";i:479629;s:73:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Tasks/Actions\";i:55273;s:65:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Tasks\";i:78855;s:87:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Providers/Provider/Settings\";i:36950;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Providers/Provider\";i:47532;s:69:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Providers\";i:49239;s:71:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Db/Payments\";i:42992;s:62:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Db\";i:42992;s:71:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Lite/Emails\";i:6263;s:72:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Lite/Reports\";i:5435;s:87:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Lite/Integrations/Elementor\";i:471;s:89:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Lite/Integrations/LiteConnect\";i:11299;s:87:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Lite/Integrations/Gutenberg\";i:2441;s:77:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Lite/Integrations\";i:14211;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Lite/Admin/Settings\";i:4054;s:76:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Lite/Admin/Pages\";i:2501;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Lite/Admin/Education/Admin\";i:7181;s:88:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Lite/Admin/Education/Builder\";i:11770;s:80:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Lite/Admin/Education\";i:31553;s:70:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Lite/Admin\";i:64363;s:64:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Lite\";i:90272;s:68:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Frontend\";i:131390;s:76:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Emails/Templates\";i:16502;s:72:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Emails/Tasks\";i:2158;s:66:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src/Emails\";i:125035;s:59:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite/src\";i:3185005;s:55:\"/home/mangokm/MangoKnow/wp-content/plugins/wpforms-lite\";i:34832797;s:65:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/images/icons\";i:82660;s:65:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/images/logos\";i:9280;s:59:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/images\";i:402440;s:65:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/lib/rest-api\";i:27229;s:66:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/lib/dashboard\";i:40491;s:66:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/lib/audit-log\";i:112014;s:75:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/lib/Diff/Renderer/Html\";i:13804;s:70:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/lib/Diff/Renderer\";i:16854;s:61:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/lib/Diff\";i:34726;s:56:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/lib\";i:12217387;s:94:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/random_compat/lib\";i:43920;s:95:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/random_compat/dist\";i:703;s:90:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/random_compat\";i:45721;s:115:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/namespaced/Core/Poly1305\";i:171;s:120:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/namespaced/Core/Curve25519/Ge\";i:897;s:117:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/namespaced/Core/Curve25519\";i:1233;s:115:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/namespaced/Core/ChaCha20\";i:342;s:106:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/namespaced/Core\";i:3801;s:101:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/namespaced\";i:4232;s:114:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core32/SecretStream\";i:3715;s:115:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core32/Curve25519/Ge\";i:8472;s:112:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core32/Curve25519\";i:122885;s:110:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core32/ChaCha20\";i:6525;s:110:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core32/Poly1305\";i:16024;s:101:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core32\";i:438357;s:100:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/PHP52\";i:4175;s:106:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core/Base64\";i:15574;s:108:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core/ChaCha20\";i:5382;s:112:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core/SecretStream\";i:3683;s:113:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core/Curve25519/Ge\";i:8176;s:110:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core/Curve25519\";i:121840;s:108:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core/Poly1305\";i:12971;s:99:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src/Core\";i:447439;s:94:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/src\";i:1203620;s:94:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat/lib\";i:87773;s:90:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie/sodium_compat\";i:1302527;s:76:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/paragonie\";i:1348248;s:75:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor/composer\";i:41647;s:66:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto/vendor\";i:1390155;s:59:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/crypto\";i:1390155;s:96:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/modules/login-security/classes/model/crypto\";i:14301;s:94:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/modules/login-security/classes/model/view\";i:1813;s:94:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/modules/login-security/classes/model/text\";i:1675;s:98:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/modules/login-security/classes/model/settings\";i:4737;s:89:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/modules/login-security/classes/model\";i:57435;s:91:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/modules/login-security/classes/utility\";i:11223;s:94:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/modules/login-security/classes/controller\";i:194969;s:83:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/modules/login-security/classes\";i:263982;s:78:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/modules/login-security/js\";i:317951;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/modules/login-security/views/user\";i:528;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/modules/login-security/views/page\";i:17127;s:88:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/modules/login-security/views/common\";i:8004;s:92:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/modules/login-security/views/onboarding\";i:1749;s:88:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/modules/login-security/views/manage\";i:21490;s:87:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/modules/login-security/views/email\";i:1349;s:89:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/modules/login-security/views/options\";i:73364;s:90:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/modules/login-security/views/settings\";i:17961;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/modules/login-security/views\";i:141927;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/modules/login-security/css\";i:365204;s:79:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/modules/login-security/img\";i:48448;s:75:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/modules/login-security\";i:1140681;s:60:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/modules\";i:1140681;s:62:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/languages\";i:465391;s:68:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/vendor/composer\";i:36677;s:86:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/vendor/wordfence/wf-waf/src/views\";i:47958;s:91:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/vendor/wordfence/wf-waf/src/lib/parser\";i:126381;s:92:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/vendor/wordfence/wf-waf/src/lib/storage\";i:75142;s:84:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/vendor/wordfence/wf-waf/src/lib\";i:458422;s:80:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/vendor/wordfence/wf-waf/src\";i:729979;s:76:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/vendor/wordfence/wf-waf\";i:729979;s:95:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/vendor/wordfence/mmdb-reader/src/Exception\";i:1541;s:88:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/vendor/wordfence/mmdb-reader/src/Io\";i:2249;s:85:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/vendor/wordfence/mmdb-reader/src\";i:27521;s:81:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/vendor/wordfence/mmdb-reader\";i:27521;s:69:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/vendor/wordfence\";i:757500;s:59:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/vendor\";i:794791;s:63:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/views/user\";i:1093;s:70:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/views/offboarding\";i:8252;s:65:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/views/common\";i:30941;s:64:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/views/tours\";i:4949;s:62:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/views/waf\";i:126126;s:70:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/views/diagnostics\";i:18856;s:66:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/views/reports\";i:45080;s:69:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/views/onboarding\";i:18150;s:64:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/views/tools\";i:15321;s:67:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/views/blocking\";i:426132;s:68:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/views/dashboard\";i:60964;s:66:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/views/options\";i:55546;s:74:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/views/unsupported-php\";i:1038;s:63:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/views/gdpr\";i:4406;s:73:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/views/unsupported-wp\";i:1178;s:66:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/views/scanner\";i:200353;s:58:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/views\";i:1018739;s:61:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/waf/pomo\";i:58095;s:56:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/waf\";i:123920;s:64:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/css/license\";i:178589;s:63:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/css/images\";i:36376;s:56:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/css\";i:746889;s:58:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/fonts\";i:289944;s:56:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/tmp\";i:15;s:55:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/js\";i:780698;s:67:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/models/scanner\";i:44084;s:66:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/models/common\";i:845;s:65:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/models/block\";i:73831;s:64:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/models/page\";i:7216;s:68:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/models/firewall\";i:16494;s:59:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence/models\";i:142824;s:52:\"/home/mangokm/MangoKnow/wp-content/plugins/wordfence\";i:19601482;s:42:\"/home/mangokm/MangoKnow/wp-content/plugins\";i:102345441;s:61:\"/home/mangokm/MangoKnow/wp-content/uploads/seedprod-help-docs\";i:12903;s:57:\"/home/mangokm/MangoKnow/wp-content/uploads/wpforms/themes\";i:2;s:56:\"/home/mangokm/MangoKnow/wp-content/uploads/wpforms/cache\";i:1992321;s:50:\"/home/mangokm/MangoKnow/wp-content/uploads/wpforms\";i:1993060;s:50:\"/home/mangokm/MangoKnow/wp-content/uploads/2025/08\";i:0;s:50:\"/home/mangokm/MangoKnow/wp-content/uploads/2025/05\";i:0;s:50:\"/home/mangokm/MangoKnow/wp-content/uploads/2025/06\";i:0;s:50:\"/home/mangokm/MangoKnow/wp-content/uploads/2025/04\";i:0;s:50:\"/home/mangokm/MangoKnow/wp-content/uploads/2025/09\";i:0;s:50:\"/home/mangokm/MangoKnow/wp-content/uploads/2025/03\";i:0;s:50:\"/home/mangokm/MangoKnow/wp-content/uploads/2025/10\";i:0;s:50:\"/home/mangokm/MangoKnow/wp-content/uploads/2025/07\";i:3800152;s:47:\"/home/mangokm/MangoKnow/wp-content/uploads/2025\";i:3800152;s:42:\"/home/mangokm/MangoKnow/wp-content/uploads\";i:5806115;}", "off");
INSERT INTO `wor4890_options` VALUES("37377", "instawp_last_heartbeat_data", "a:1:{i:207190;s:12224:\"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\";}", "off");
INSERT INTO `wor4890_options` VALUES("37380", "_transient_timeout_instawp_site_size_check_files_a7bca322086c8ba36bdb5f2492106544", "1760107905", "off");
INSERT INTO `wor4890_options` VALUES("37381", "_transient_instawp_site_size_check_files_a7bca322086c8ba36bdb5f2492106544", "533629987", "off");
INSERT INTO `wor4890_options` VALUES("37382", "_transient_timeout_instawp_site_size_check_db_d751713988987e9331980363e24189ce", "1760107905", "off");
INSERT INTO `wor4890_options` VALUES("37383", "_transient_instawp_site_size_check_db_d751713988987e9331980363e24189ce", "15450112", "off");
INSERT INTO `wor4890_options` VALUES("37385", "_transient_timeout_instawp_site_size_check_files_fd19981708ff34a21b9e5bb46d02b74b", "1760107947", "off");
INSERT INTO `wor4890_options` VALUES("37386", "_transient_instawp_site_size_check_files_fd19981708ff34a21b9e5bb46d02b74b", "527823872", "off");
INSERT INTO `wor4890_options` VALUES("37387", "_transient_timeout_instawp_site_size_check_files_9b01b398941b6e13b0cf53e6df4b4711", "1760107984", "off");
INSERT INTO `wor4890_options` VALUES("37388", "_transient_instawp_site_size_check_files_9b01b398941b6e13b0cf53e6df4b4711", "527823872", "off");
INSERT INTO `wor4890_options` VALUES("37390", "_transient_timeout_instawp_site_size_check_files_90ceab736d5550af8236863459baef51", "1760108027", "off");
INSERT INTO `wor4890_options` VALUES("37391", "_transient_instawp_site_size_check_files_90ceab736d5550af8236863459baef51", "527692422", "off");
INSERT INTO `wor4890_options` VALUES("37393", "_transient_timeout_instawp_site_size_check_files_b85f21b826613e66146427171385d590", "1760108104", "off");
INSERT INTO `wor4890_options` VALUES("37394", "_transient_instawp_site_size_check_files_b85f21b826613e66146427171385d590", "53206688", "off");
INSERT INTO `wor4890_options` VALUES("37399", "action_scheduler_migration_status", "complete", "auto");
INSERT INTO `wor4890_options` VALUES("37463", "_site_transient_timeout_theme_roots", "1760111946", "off");
INSERT INTO `wor4890_options` VALUES("37464", "_site_transient_theme_roots", "a:2:{s:6:\"hestia\";s:7:\"/themes\";s:23:\"mango-know-hestia-child\";s:7:\"/themes\";}", "off");
INSERT INTO `wor4890_options` VALUES("37466", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/en_GB/wordpress-6.8.3.zip\";s:6:\"locale\";s:5:\"en_GB\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/en_GB/wordpress-6.8.3.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.8.3\";s:7:\"version\";s:5:\"6.8.3\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1760110152;s:15:\"version_checked\";s:5:\"6.8.3\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wor4890_options` VALUES("37468", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1760110153;s:7:\"checked\";a:2:{s:6:\"hestia\";s:5:\"3.3.3\";s:23:\"mango-know-hestia-child\";s:3:\"0.1\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:1:{s:6:\"hestia\";a:6:{s:5:\"theme\";s:6:\"hestia\";s:11:\"new_version\";s:5:\"3.3.3\";s:3:\"url\";s:36:\"https://wordpress.org/themes/hestia/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/theme/hestia.3.3.3.zip\";s:8:\"requires\";b:0;s:12:\"requires_php\";s:5:\"5.4.0\";}}s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wor4890_options` VALUES("37469", "_site_transient_timeout_wp_theme_files_patterns-9c349da9e69dbae60c293819092567a5", "1760111955", "off");
INSERT INTO `wor4890_options` VALUES("37470", "_site_transient_wp_theme_files_patterns-9c349da9e69dbae60c293819092567a5", "a:2:{s:7:\"version\";s:3:\"0.1\";s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `wor4890_options` VALUES("37471", "_site_transient_timeout_wp_theme_files_patterns-bdd6781424a32a36d188cda1027af120", "1760111955", "off");
INSERT INTO `wor4890_options` VALUES("37472", "_site_transient_wp_theme_files_patterns-bdd6781424a32a36d188cda1027af120", "a:2:{s:7:\"version\";s:5:\"3.3.3\";s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `wor4890_options` VALUES("37475", "duplicator_version_plugin", "1.5.13.3", "auto");
INSERT INTO `wor4890_options` VALUES("37477", "duplicator_install_info", "a:3:{s:7:\"version\";s:8:\"1.5.13.3\";s:4:\"time\";i:1760110166;s:10:\"updateTime\";i:1760110166;}", "off");
INSERT INTO `wor4890_options` VALUES("37478", "duplicator_uninstall_package", "1", "auto");
INSERT INTO `wor4890_options` VALUES("37479", "duplicator_uninstall_settings", "1", "auto");
INSERT INTO `wor4890_options` VALUES("37480", "duplicator_settings", "a:22:{s:7:\"version\";s:8:\"1.5.13.3\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";s:1:\"0\";s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";s:1:\"0\";s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";s:1:\"2\";s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:2;s:14:\"usage_tracking\";b:0;i:0;b:0;s:12:\"last_updated\";s:19:\"2025-10-10-15-31-33\";s:18:\"package_ui_created\";s:1:\"1\";}", "auto");
INSERT INTO `wor4890_options` VALUES("37481", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"v5GcAqf5I7ZZikht4fx;6&T+Bcqwe,74i.mkYXhQYpo3\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 0,\n    \"buildLastDate\": 0,\n    \"buildFailedCount\": 1,\n    \"buildFailedLastDate\": 1760110244,\n    \"siteSizeMB\": 233.66,\n    \"siteNumFiles\": 13285,\n    \"siteDbSizeMB\": 14.77,\n    \"siteDbNumTables\": 48\n}", "auto");
INSERT INTO `wor4890_options` VALUES("37482", "duplicator_notifications", "a:4:{s:6:\"update\";i:1760110166;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `wor4890_options` VALUES("37483", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1760110167;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:6:{s:27:\"coming-soon/coming-soon.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/coming-soon\";s:4:\"slug\";s:11:\"coming-soon\";s:6:\"plugin\";s:27:\"coming-soon/coming-soon.php\";s:11:\"new_version\";s:7:\"6.18.18\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/coming-soon/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/coming-soon.6.18.18.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/coming-soon/assets/icon-256x256.png?rev=2402574\";s:2:\"1x\";s:64:\"https://ps.w.org/coming-soon/assets/icon-128x128.png?rev=2402575\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/coming-soon/assets/banner-1544x500.png?rev=2683810\";s:2:\"1x\";s:66:\"https://ps.w.org/coming-soon/assets/banner-772x250.png?rev=2683809\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.0\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:8:\"1.5.13.3\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/duplicator.1.5.13.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.3\";}s:21:\"filebird/filebird.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:22:\"w.org/plugins/filebird\";s:4:\"slug\";s:8:\"filebird\";s:6:\"plugin\";s:21:\"filebird/filebird.php\";s:11:\"new_version\";s:5:\"6.4.9\";s:3:\"url\";s:39:\"https://wordpress.org/plugins/filebird/\";s:7:\"package\";s:51:\"https://downloads.wordpress.org/plugin/filebird.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/filebird/assets/icon-128x128.gif?rev=2299145\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/filebird/assets/banner-1544x500.png?rev=2350008\";s:2:\"1x\";s:63:\"https://ps.w.org/filebird/assets/banner-772x250.png?rev=2350008\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.0\";}s:27:\"updraftplus/updraftplus.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/updraftplus\";s:4:\"slug\";s:11:\"updraftplus\";s:6:\"plugin\";s:27:\"updraftplus/updraftplus.php\";s:11:\"new_version\";s:6:\"1.25.8\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/updraftplus/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/updraftplus.1.25.8.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/updraftplus/assets/icon-256x256.jpg?rev=1686200\";s:2:\"1x\";s:64:\"https://ps.w.org/updraftplus/assets/icon-128x128.jpg?rev=1686200\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/updraftplus/assets/banner-1544x500.png?rev=1686200\";s:2:\"1x\";s:66:\"https://ps.w.org/updraftplus/assets/banner-772x250.png?rev=1686200\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.2\";}s:23:\"wordfence/wordfence.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:23:\"w.org/plugins/wordfence\";s:4:\"slug\";s:9:\"wordfence\";s:6:\"plugin\";s:23:\"wordfence/wordfence.php\";s:11:\"new_version\";s:5:\"8.1.0\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/wordfence/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/wordfence.8.1.0.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:54:\"https://ps.w.org/wordfence/assets/icon.svg?rev=2070865\";s:3:\"svg\";s:54:\"https://ps.w.org/wordfence/assets/icon.svg?rev=2070865\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/wordfence/assets/banner-1544x500.jpg?rev=2124102\";s:2:\"1x\";s:64:\"https://ps.w.org/wordfence/assets/banner-772x250.jpg?rev=2124102\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.7\";}s:24:\"wpforms-lite/wpforms.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:26:\"w.org/plugins/wpforms-lite\";s:4:\"slug\";s:12:\"wpforms-lite\";s:6:\"plugin\";s:24:\"wpforms-lite/wpforms.php\";s:11:\"new_version\";s:7:\"1.9.8.1\";s:3:\"url\";s:43:\"https://wordpress.org/plugins/wpforms-lite/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/wpforms-lite.1.9.8.1.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:57:\"https://ps.w.org/wpforms-lite/assets/icon.svg?rev=3254748\";s:3:\"svg\";s:57:\"https://ps.w.org/wpforms-lite/assets/icon.svg?rev=3254748\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/wpforms-lite/assets/banner-1544x500.png?rev=3091364\";s:2:\"1x\";s:67:\"https://ps.w.org/wpforms-lite/assets/banner-772x250.png?rev=3091364\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:72:\"https://ps.w.org/wpforms-lite/assets/banner-1544x500-rtl.png?rev=3254748\";s:2:\"1x\";s:71:\"https://ps.w.org/wpforms-lite/assets/banner-772x250-rtl.png?rev=3254748\";}s:8:\"requires\";s:3:\"5.5\";}}s:7:\"checked\";a:6:{s:27:\"coming-soon/coming-soon.php\";s:7:\"6.18.18\";s:25:\"duplicator/duplicator.php\";s:8:\"1.5.13.3\";s:21:\"filebird/filebird.php\";s:5:\"6.4.9\";s:27:\"updraftplus/updraftplus.php\";s:6:\"1.25.8\";s:23:\"wordfence/wordfence.php\";s:5:\"8.1.0\";s:24:\"wpforms-lite/wpforms.php\";s:7:\"1.9.8.1\";}}", "off");
INSERT INTO `wor4890_options` VALUES("37484", "updraftplus_dismisseddashnotice", "1791732572", "on");
INSERT INTO `wor4890_options` VALUES("37485", "duplicator_ui_view_state", "a:4:{s:22:\"dup-pack-archive-panel\";s:1:\"0\";s:24:\"dup-pack-installer-panel\";s:1:\"0\";s:19:\"dup-pack-build-try1\";s:1:\"0\";s:19:\"dup-pack-build-try3\";s:1:\"1\";}", "auto");
INSERT INTO `wor4890_options` VALUES("37486", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-10 15:32:22\";s:7:\"Version\";s:8:\"1.5.13.3\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.43\";s:10:\"VersionPHP\";s:6:\"8.4.10\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:18:\"20251010_mangoknow\";s:4:\"Hash\";s:35:\"2729d61ccb91770f5100_20251010153222\";s:8:\"NameHash\";s:54:\"20251010_mangoknow_2729d61ccb91770f5100_20251010153222\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:64:\"20251010_mangoknow_2729d61ccb91770f5100_20251010153222_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:23:\"/home/mangokm/MangoKnow\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1557;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11728;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-10 15:32:22\";s:7:\"Version\";s:8:\"1.5.13.3\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:6:\"8.0.43\";s:10:\"VersionPHP\";s:6:\"8.4.10\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:18:\"20251010_mangoknow\";s:4:\"Hash\";s:35:\"2729d61ccb91770f5100_20251010153222\";s:8:\"NameHash\";s:54:\"20251010_mangoknow_2729d61ccb91770f5100_20251010153222\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:37:\"/home/mangokm/MangoKnow/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:55:\"Percona Server (GPL), Release \'34\', Revision \'e2841f91\'\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:32:\"/home/mangokm/MangoKnow/wp-admin\";i:1;s:35:\"/home/mangokm/MangoKnow/wp-includes\";i:2;s:44:\"/home/mangokm/MangoKnow/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:23:\"/home/mangokm/MangoKnow\";i:1;s:23:\"/home/mangokm/MangoKnow\";i:2;s:34:\"/home/mangokm/MangoKnow/wp-content\";i:3;s:42:\"/home/mangokm/MangoKnow/wp-content/uploads\";i:4;s:42:\"/home/mangokm/MangoKnow/wp-content/plugins\";i:5;s:45:\"/home/mangokm/MangoKnow/wp-content/mu-plugins\";i:6;s:41:\"/home/mangokm/MangoKnow/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:55:\"/home/mangokm/MangoKnow/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "auto");
INSERT INTO `wor4890_options` VALUES("37488", "duplicator_email_summary_info", "{\"CL_-=_-=\":\"Duplicator\\\\Utils\\\\Email\\\\EmailSummary\",\"manualPackageIds\":[],\"failedPackageIds\":[1]}", "auto");

/* INSERT TABLE DATA: wor4890_postmeta */
INSERT INTO `wor4890_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `wor4890_postmeta` VALUES("2", "3", "_wp_page_template", "default");
INSERT INTO `wor4890_postmeta` VALUES("3", "5", "_seedprod_page", "1");
INSERT INTO `wor4890_postmeta` VALUES("4", "5", "_seedprod_page_uuid", "e99af932-18b5-4fa8-9241-76a77f228225");
INSERT INTO `wor4890_postmeta` VALUES("5", "5", "_seedprod_page_template_type", "cs");
INSERT INTO `wor4890_postmeta` VALUES("8", "13", "_wp_attached_file", "2025/07/slider1.jpg");
INSERT INTO `wor4890_postmeta` VALUES("9", "13", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1104;s:6:\"height\";i:621;s:4:\"file\";s:19:\"2025/07/slider1.jpg\";s:8:\"filesize\";i:100461;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:19:\"slider1-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10207;}s:5:\"large\";a:5:{s:4:\"file\";s:20:\"slider1-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:103014;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:19:\"slider1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4710;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:19:\"slider1-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:59919;}s:11:\"hestia-blog\";a:5:{s:4:\"file\";s:19:\"slider1-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16157;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wor4890_postmeta` VALUES("10", "13", "_starter_content_theme", "mango-know-hestia-child");
INSERT INTO `wor4890_postmeta` VALUES("12", "14", "_wp_attached_file", "2025/07/slider1-1.jpg");
INSERT INTO `wor4890_postmeta` VALUES("13", "14", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1104;s:6:\"height\";i:621;s:4:\"file\";s:21:\"2025/07/slider1-1.jpg\";s:8:\"filesize\";i:100461;s:5:\"sizes\";a:5:{s:6:\"medium\";a:5:{s:4:\"file\";s:21:\"slider1-1-300x169.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:169;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10207;}s:5:\"large\";a:5:{s:4:\"file\";s:22:\"slider1-1-1024x576.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:576;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:103014;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:21:\"slider1-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4710;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:21:\"slider1-1-768x432.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:432;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:59919;}s:11:\"hestia-blog\";a:5:{s:4:\"file\";s:21:\"slider1-1-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16157;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wor4890_postmeta` VALUES("14", "14", "_starter_content_theme", "mango-know-hestia-child");
INSERT INTO `wor4890_postmeta` VALUES("16", "15", "_wp_attached_file", "2025/07/card-blog1.jpg");
INSERT INTO `wor4890_postmeta` VALUES("17", "15", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:800;s:6:\"height\";i:533;s:4:\"file\";s:22:\"2025/07/card-blog1.jpg\";s:8:\"filesize\";i:97914;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"card-blog1-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9621;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"card-blog1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4115;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:22:\"card-blog1-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:58808;}s:11:\"hestia-blog\";a:5:{s:4:\"file\";s:22:\"card-blog1-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13389;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wor4890_postmeta` VALUES("18", "15", "_starter_content_theme", "mango-know-hestia-child");
INSERT INTO `wor4890_postmeta` VALUES("20", "16", "_wp_attached_file", "2025/07/card-blog2.jpg");
INSERT INTO `wor4890_postmeta` VALUES("21", "16", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:800;s:6:\"height\";i:534;s:4:\"file\";s:22:\"2025/07/card-blog2.jpg\";s:8:\"filesize\";i:45949;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"card-blog2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11337;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"card-blog2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5876;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:22:\"card-blog2-768x513.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:513;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:43114;}s:11:\"hestia-blog\";a:5:{s:4:\"file\";s:22:\"card-blog2-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14572;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wor4890_postmeta` VALUES("22", "16", "_starter_content_theme", "mango-know-hestia-child");
INSERT INTO `wor4890_postmeta` VALUES("24", "17", "_wp_attached_file", "2025/07/card-blog3.jpg");
INSERT INTO `wor4890_postmeta` VALUES("25", "17", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:752;s:6:\"height\";i:500;s:4:\"file\";s:22:\"2025/07/card-blog3.jpg\";s:8:\"filesize\";i:102861;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"card-blog3-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15640;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"card-blog3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7139;}s:11:\"hestia-blog\";a:5:{s:4:\"file\";s:22:\"card-blog3-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:21196;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wor4890_postmeta` VALUES("26", "17", "_starter_content_theme", "mango-know-hestia-child");
INSERT INTO `wor4890_postmeta` VALUES("28", "18", "_wp_attached_file", "2025/07/card-blog4.jpg");
INSERT INTO `wor4890_postmeta` VALUES("29", "18", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:752;s:6:\"height\";i:500;s:4:\"file\";s:22:\"2025/07/card-blog4.jpg\";s:8:\"filesize\";i:130971;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"card-blog4-300x199.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:199;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16165;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"card-blog4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6513;}s:11:\"hestia-blog\";a:5:{s:4:\"file\";s:22:\"card-blog4-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22621;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wor4890_postmeta` VALUES("30", "18", "_starter_content_theme", "mango-know-hestia-child");
INSERT INTO `wor4890_postmeta` VALUES("32", "19", "_wp_attached_file", "2025/07/card-blog5.jpg");
INSERT INTO `wor4890_postmeta` VALUES("33", "19", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:800;s:6:\"height\";i:533;s:4:\"file\";s:22:\"2025/07/card-blog5.jpg\";s:8:\"filesize\";i:102210;s:5:\"sizes\";a:4:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"card-blog5-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16828;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"card-blog5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7364;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:22:\"card-blog5-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:85141;}s:11:\"hestia-blog\";a:5:{s:4:\"file\";s:22:\"card-blog5-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:22844;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wor4890_postmeta` VALUES("34", "19", "_starter_content_theme", "mango-know-hestia-child");
INSERT INTO `wor4890_postmeta` VALUES("37", "20", "_customize_changeset_uuid", "e670c222-b35d-4ccd-a2b4-468bcec32e3f");
INSERT INTO `wor4890_postmeta` VALUES("38", "21", "_thumbnail_id", "13");
INSERT INTO `wor4890_postmeta` VALUES("39", "21", "_wp_page_template", "page-templates/template-pagebuilder-full-width.php");
INSERT INTO `wor4890_postmeta` VALUES("41", "21", "_customize_changeset_uuid", "e670c222-b35d-4ccd-a2b4-468bcec32e3f");
INSERT INTO `wor4890_postmeta` VALUES("43", "22", "_customize_changeset_uuid", "e670c222-b35d-4ccd-a2b4-468bcec32e3f");
INSERT INTO `wor4890_postmeta` VALUES("44", "23", "_thumbnail_id", "15");
INSERT INTO `wor4890_postmeta` VALUES("46", "23", "_customize_changeset_uuid", "e670c222-b35d-4ccd-a2b4-468bcec32e3f");
INSERT INTO `wor4890_postmeta` VALUES("47", "24", "_thumbnail_id", "16");
INSERT INTO `wor4890_postmeta` VALUES("49", "24", "_customize_changeset_uuid", "e670c222-b35d-4ccd-a2b4-468bcec32e3f");
INSERT INTO `wor4890_postmeta` VALUES("50", "25", "_thumbnail_id", "17");
INSERT INTO `wor4890_postmeta` VALUES("52", "25", "_customize_changeset_uuid", "e670c222-b35d-4ccd-a2b4-468bcec32e3f");
INSERT INTO `wor4890_postmeta` VALUES("53", "26", "_thumbnail_id", "18");
INSERT INTO `wor4890_postmeta` VALUES("55", "26", "_customize_changeset_uuid", "e670c222-b35d-4ccd-a2b4-468bcec32e3f");
INSERT INTO `wor4890_postmeta` VALUES("56", "27", "_thumbnail_id", "19");
INSERT INTO `wor4890_postmeta` VALUES("58", "27", "_customize_changeset_uuid", "e670c222-b35d-4ccd-a2b4-468bcec32e3f");
INSERT INTO `wor4890_postmeta` VALUES("69", "37", "_menu_item_type", "post_type");
INSERT INTO `wor4890_postmeta` VALUES("70", "37", "_menu_item_menu_item_parent", "0");
INSERT INTO `wor4890_postmeta` VALUES("71", "37", "_menu_item_object_id", "20");
INSERT INTO `wor4890_postmeta` VALUES("72", "37", "_menu_item_object", "page");
INSERT INTO `wor4890_postmeta` VALUES("73", "37", "_menu_item_target", "");
INSERT INTO `wor4890_postmeta` VALUES("74", "37", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wor4890_postmeta` VALUES("75", "37", "_menu_item_xfn", "");
INSERT INTO `wor4890_postmeta` VALUES("76", "37", "_menu_item_url", "");
INSERT INTO `wor4890_postmeta` VALUES("77", "38", "_menu_item_type", "post_type");
INSERT INTO `wor4890_postmeta` VALUES("78", "38", "_menu_item_menu_item_parent", "0");
INSERT INTO `wor4890_postmeta` VALUES("79", "38", "_menu_item_object_id", "22");
INSERT INTO `wor4890_postmeta` VALUES("80", "38", "_menu_item_object", "page");
INSERT INTO `wor4890_postmeta` VALUES("81", "38", "_menu_item_target", "");
INSERT INTO `wor4890_postmeta` VALUES("82", "38", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wor4890_postmeta` VALUES("83", "38", "_menu_item_xfn", "");
INSERT INTO `wor4890_postmeta` VALUES("84", "38", "_menu_item_url", "");
INSERT INTO `wor4890_postmeta` VALUES("85", "39", "_menu_item_type", "post_type");
INSERT INTO `wor4890_postmeta` VALUES("86", "39", "_menu_item_menu_item_parent", "0");
INSERT INTO `wor4890_postmeta` VALUES("87", "39", "_menu_item_object_id", "21");
INSERT INTO `wor4890_postmeta` VALUES("88", "39", "_menu_item_object", "page");
INSERT INTO `wor4890_postmeta` VALUES("89", "39", "_menu_item_target", "");
INSERT INTO `wor4890_postmeta` VALUES("90", "39", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wor4890_postmeta` VALUES("91", "39", "_menu_item_xfn", "");
INSERT INTO `wor4890_postmeta` VALUES("92", "39", "_menu_item_url", "");
INSERT INTO `wor4890_postmeta` VALUES("93", "40", "_menu_item_type", "custom");
INSERT INTO `wor4890_postmeta` VALUES("94", "40", "_menu_item_menu_item_parent", "0");
INSERT INTO `wor4890_postmeta` VALUES("95", "40", "_menu_item_object_id", "40");
INSERT INTO `wor4890_postmeta` VALUES("96", "40", "_menu_item_object", "custom");
INSERT INTO `wor4890_postmeta` VALUES("97", "40", "_menu_item_target", "");
INSERT INTO `wor4890_postmeta` VALUES("98", "40", "_menu_item_classes", "a:4:{i:0;s:3:\"btn\";i:1;s:9:\"btn-round\";i:2;s:11:\"btn-primary\";i:3;s:16:\"hestia-mega-menu\";}");
INSERT INTO `wor4890_postmeta` VALUES("99", "40", "_menu_item_xfn", "");
INSERT INTO `wor4890_postmeta` VALUES("100", "40", "_menu_item_url", "#contact");
INSERT INTO `wor4890_postmeta` VALUES("106", "20", "_thumbnail_id", "54");
INSERT INTO `wor4890_postmeta` VALUES("112", "20", "_edit_lock", "1753897100:1");
INSERT INTO `wor4890_postmeta` VALUES("115", "20", "_edit_last", "1");
INSERT INTO `wor4890_postmeta` VALUES("128", "52", "_wp_attached_file", "2025/07/abc-alphabet-blackboard-265076-scaled.jpg");
INSERT INTO `wor4890_postmeta` VALUES("129", "52", "_wp_attachment_metadata", "a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1714;s:4:\"file\";s:49:\"2025/07/abc-alphabet-blackboard-265076-scaled.jpg\";s:8:\"filesize\";i:177441;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:42:\"abc-alphabet-blackboard-265076-300x201.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:201;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9278;}s:5:\"large\";a:5:{s:4:\"file\";s:43:\"abc-alphabet-blackboard-265076-1024x685.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:685;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:38937;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:42:\"abc-alphabet-blackboard-265076-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6521;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:42:\"abc-alphabet-blackboard-265076-768x514.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:514;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:26723;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:44:\"abc-alphabet-blackboard-265076-1536x1028.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1028;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:71662;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:44:\"abc-alphabet-blackboard-265076-2048x1371.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1371;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:115840;}s:11:\"hestia-blog\";a:5:{s:4:\"file\";s:42:\"abc-alphabet-blackboard-265076-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10954;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:34:\"abc-alphabet-blackboard-265076.jpg\";}");
INSERT INTO `wor4890_postmeta` VALUES("131", "54", "_wp_attached_file", "2025/07/alphabet-class-conceptual-301926-scaled.jpg");
INSERT INTO `wor4890_postmeta` VALUES("132", "54", "_wp_attachment_metadata", "a:7:{s:5:\"width\";i:2560;s:6:\"height\";i:1708;s:4:\"file\";s:51:\"2025/07/alphabet-class-conceptual-301926-scaled.jpg\";s:8:\"filesize\";i:266591;s:5:\"sizes\";a:7:{s:6:\"medium\";a:5:{s:4:\"file\";s:44:\"alphabet-class-conceptual-301926-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11895;}s:5:\"large\";a:5:{s:4:\"file\";s:45:\"alphabet-class-conceptual-301926-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:58610;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:44:\"alphabet-class-conceptual-301926-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7580;}s:12:\"medium_large\";a:5:{s:4:\"file\";s:44:\"alphabet-class-conceptual-301926-768x512.jpg\";s:5:\"width\";i:768;s:6:\"height\";i:512;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:37883;}s:9:\"1536x1536\";a:5:{s:4:\"file\";s:46:\"alphabet-class-conceptual-301926-1536x1025.jpg\";s:5:\"width\";i:1536;s:6:\"height\";i:1025;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:115237;}s:9:\"2048x2048\";a:5:{s:4:\"file\";s:46:\"alphabet-class-conceptual-301926-2048x1366.jpg\";s:5:\"width\";i:2048;s:6:\"height\";i:1366;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:186219;}s:11:\"hestia-blog\";a:5:{s:4:\"file\";s:44:\"alphabet-class-conceptual-301926-360x240.jpg\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14300;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}s:14:\"original_image\";s:36:\"alphabet-class-conceptual-301926.jpg\";}");
INSERT INTO `wor4890_postmeta` VALUES("137", "54", "_wp_attachment_is_custom_background", "mango-know-hestia-child");
INSERT INTO `wor4890_postmeta` VALUES("142", "57", "_wp_attached_file", "2025/07/Mango-Know-Logo-Portrait-290x221-1.png");
INSERT INTO `wor4890_postmeta` VALUES("143", "57", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:290;s:6:\"height\";i:221;s:4:\"file\";s:46:\"2025/07/Mango-Know-Logo-Portrait-290x221-1.png\";s:8:\"filesize\";i:6579;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:46:\"Mango-Know-Logo-Portrait-290x221-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3590;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wor4890_postmeta` VALUES("144", "57", "fb_filesize", "6579");
INSERT INTO `wor4890_postmeta` VALUES("145", "58", "_wp_attached_file", "2025/07/Mango-Know-Logo-Landscape-430x160-1.png");
INSERT INTO `wor4890_postmeta` VALUES("146", "58", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:430;s:6:\"height\";i:160;s:4:\"file\";s:47:\"2025/07/Mango-Know-Logo-Landscape-430x160-1.png\";s:8:\"filesize\";i:6882;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:47:\"Mango-Know-Logo-Landscape-430x160-1-300x112.png\";s:5:\"width\";i:300;s:6:\"height\";i:112;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4057;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:47:\"Mango-Know-Logo-Landscape-430x160-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3473;}s:11:\"hestia-blog\";a:5:{s:4:\"file\";s:47:\"Mango-Know-Logo-Landscape-430x160-1-360x160.png\";s:5:\"width\";i:360;s:6:\"height\";i:160;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3523;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wor4890_postmeta` VALUES("147", "58", "fb_filesize", "6882");
INSERT INTO `wor4890_postmeta` VALUES("148", "59", "_wp_attached_file", "2025/07/Mango-Know-Logo-Icon-512x512-1.png");
INSERT INTO `wor4890_postmeta` VALUES("149", "59", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:42:\"2025/07/Mango-Know-Logo-Icon-512x512-1.png\";s:8:\"filesize\";i:14742;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:42:\"Mango-Know-Logo-Icon-512x512-1-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6233;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:42:\"Mango-Know-Logo-Icon-512x512-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3132;}s:11:\"hestia-blog\";a:5:{s:4:\"file\";s:42:\"Mango-Know-Logo-Icon-512x512-1-360x240.png\";s:5:\"width\";i:360;s:6:\"height\";i:240;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:5523;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wor4890_postmeta` VALUES("150", "59", "fb_filesize", "14742");
INSERT INTO `wor4890_postmeta` VALUES("151", "60", "_wp_attached_file", "2025/07/Mango-Know-Logo-Icon-160x160-1.png");
INSERT INTO `wor4890_postmeta` VALUES("152", "60", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:160;s:6:\"height\";i:160;s:4:\"file\";s:42:\"2025/07/Mango-Know-Logo-Icon-160x160-1.png\";s:8:\"filesize\";i:4048;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:42:\"Mango-Know-Logo-Icon-160x160-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3300;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wor4890_postmeta` VALUES("153", "60", "fb_filesize", "4048");
INSERT INTO `wor4890_postmeta` VALUES("157", "40", "_wp_old_date", "2025-07-28");
INSERT INTO `wor4890_postmeta` VALUES("160", "21", "_edit_lock", "1753812703:1");

/* INSERT TABLE DATA: wor4890_posts */
INSERT INTO `wor4890_posts` VALUES("1", "1", "2025-03-25 23:50:31", "2025-03-25 23:50:31", "<!-- wp:paragraph -->\n<p>Welcome to WordPress. This is your first post. Edit or delete it, then start writing!</p>\n<!-- /wp:paragraph -->", "Hello world!", "", "publish", "open", "open", "", "hello-world", "", "", "2025-03-25 23:50:31", "2025-03-25 23:50:31", "", "0", "http://mangoknow.com/?p=1", "0", "post", "", "1");
INSERT INTO `wor4890_posts` VALUES("2", "1", "2025-03-25 23:50:31", "2025-03-25 23:50:31", "<!-- wp:paragraph -->\n<p>This is an example page. It\'s different from a blog post because it will stay in one place and will show up in your site navigation (in most themes). Most people start with an About page that introduces them to potential site visitors. It might say something like this:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>Hi there! I\'m a bike messenger by day, aspiring actor by night, and this is my website. I live in Los Angeles, have a great dog named Jack, and I like pi&#241;a coladas. (And gettin\' caught in the rain.)</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>...or something like this:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:quote -->\n<blockquote class=\"wp-block-quote\"><p>The XYZ Doohickey Company was founded in 1971, and has been providing quality doohickeys to the public ever since. Located in Gotham City, XYZ employs over 2,000 people and does all kinds of awesome things for the Gotham community.</p></blockquote>\n<!-- /wp:quote -->\n\n<!-- wp:paragraph -->\n<p>As a new WordPress user, you should go to <a href=\"http://mangoknow.com/wp-admin/\">your dashboard</a> to delete this page and create new pages for your content. Have fun!</p>\n<!-- /wp:paragraph -->", "Sample Page", "", "publish", "closed", "open", "", "sample-page", "", "", "2025-03-25 23:50:31", "2025-03-25 23:50:31", "", "0", "http://mangoknow.com/?page_id=2", "0", "page", "", "0");
INSERT INTO `wor4890_posts` VALUES("3", "1", "2025-03-25 23:50:31", "2025-03-25 23:50:31", "<!-- wp:heading --><h2>Who we are</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>Our website address is: http://mangoknow.com.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Comments</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>When visitors leave comments on the site we collect the data shown in the comments form, and also the visitor&#8217;s IP address and browser user agent string to help spam detection.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>An anonymized string created from your email address (also called a hash) may be provided to the Gravatar service to see if you are using it. The Gravatar service privacy policy is available here: https://automattic.com/privacy/. After approval of your comment, your profile picture is visible to the public in the context of your comment.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Media</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you upload images to the website, you should avoid uploading images with embedded location data (EXIF GPS) included. Visitors to the website can download and extract any location data from images on the website.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Cookies</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you leave a comment on our site you may opt-in to saving your name, email address and website in cookies. These are for your convenience so that you do not have to fill in your details again when you leave another comment. These cookies will last for one year.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>If you visit our login page, we will set a temporary cookie to determine if your browser accepts cookies. This cookie contains no personal data and is discarded when you close your browser.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>When you log in, we will also set up several cookies to save your login information and your screen display choices. Login cookies last for two days, and screen options cookies last for a year. If you select &quot;Remember Me&quot;, your login will persist for two weeks. If you log out of your account, the login cookies will be removed.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>If you edit or publish an article, an additional cookie will be saved in your browser. This cookie includes no personal data and simply indicates the post ID of the article you just edited. It expires after 1 day.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Embedded content from other websites</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>Articles on this site may include embedded content (e.g. videos, images, articles, etc.). Embedded content from other websites behaves in the exact same way as if the visitor has visited the other website.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>These websites may collect data about you, use cookies, embed additional third-party tracking, and monitor your interaction with that embedded content, including tracking your interaction with the embedded content if you have an account and are logged in to that website.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Who we share your data with</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you request a password reset, your IP address will be included in the reset email.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>How long we retain your data</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you leave a comment, the comment and its metadata are retained indefinitely. This is so we can recognize and approve any follow-up comments automatically instead of holding them in a moderation queue.</p><!-- /wp:paragraph --><!-- wp:paragraph --><p>For users that register on our website (if any), we also store the personal information they provide in their user profile. All users can see, edit, or delete their personal information at any time (except they cannot change their username). Website administrators can also see and edit that information.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>What rights you have over your data</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>If you have an account on this site, or have left comments, you can request to receive an exported file of the personal data we hold about you, including any data you have provided to us. You can also request that we erase any personal data we hold about you. This does not include any data we are obliged to keep for administrative, legal, or security purposes.</p><!-- /wp:paragraph --><!-- wp:heading --><h2>Where we send your data</h2><!-- /wp:heading --><!-- wp:paragraph --><p><strong class=\"privacy-policy-tutorial\">Suggested text: </strong>Visitor comments may be checked through an automated spam detection service.</p><!-- /wp:paragraph -->", "Privacy Policy", "", "draft", "closed", "open", "", "privacy-policy", "", "", "2025-03-25 23:50:31", "2025-03-25 23:50:31", "", "0", "http://mangoknow.com/?page_id=3", "0", "page", "", "0");
INSERT INTO `wor4890_posts` VALUES("5", "1", "2025-03-26 00:06:39", "2025-03-26 00:06:39", "<div id=\"sp-page\" class=\"spBgcover sp-content-4\" style=\"background-color: rgb(255, 255, 255); font-family: \'Helvetica Neue\', Arial, sans-serif; font-weight: 400;\"><section id=\"sp-ks8a8s\" data-mobile-visibility=\"#sp-ks8a8s|false\" data-tablet-visibility=\"#sp-ks8a8s|false\" data-desktop-visibility=\"#sp-ks8a8s|false\" data-mobile-css=\"\" data-tablet-css=\"\" class=\"sp-el-section \" style=\"width: 600px; max-width: 100%; padding: 10px;\"><div id=\"sp-vw3kvy\" data-mobile-visibility=\"#sp-vw3kvy|false\" data-tablet-visibility=\"#sp-vw3kvy|false\" data-desktop-visibility=\"#sp-vw3kvy|false\" data-mobile-css=\"\" data-tablet-css=\"\" class=\"sp-el-row sp-w-full  sp-m-auto sm:sp-flex sp-justify-between\" style=\"padding: 0px; width: auto; max-width: 1000px;\"><div id=\"sp-ggzp6w\" data-mobile-visibility=\"#sp-ggzp6w|false\" data-tablet-visibility=\"#sp-ggzp6w|false\" data-desktop-visibility=\"#sp-ggzp6w|false\" data-mobile-css=\"\" data-tablet-css=\"\" class=\"sp-el-col  sp-w-full\" style=\"width: calc(100% - 0px);\"><figure id=\"sp-brhhwi\" data-mobile-css=\"#sp-brhhwi|text-align:center;\" data-tablet-css=\"#sp-brhhwi|text-align:center;\" class=\"sp-image-wrapper sp-el-block\" style=\"margin: 0px; text-align: center;\"><div><span><img src=\"https://assets.seedprod.com/clock.png\" alt=\"\" width=\"\" height=\"\" data-dynamic-tag=\"\" data-image-src=\"\" data-mobile-visibility=\".sp-image-block-brhhwi|false\" data-tablet-visibility=\".sp-image-block-brhhwi|false\" data-desktop-visibility=\".sp-image-block-brhhwi|false\" class=\"sp-image-block-brhhwi custom-preview-class\"></span></div><div id=\"sp-image-dynamic-tags-js-brhhwi\"><script>jQuery(function() { image_dynamic_tags(\'brhhwi\' );});</script></div></figure><span href=\"\" target=\"\" rel=\"\" class=\"sp-header-block-link\" style=\"text-decoration: none;\"><h1 id=\"sp-jkhbii\" data-mobile-css=\".sp-headline-block-jkhbii, #sp-jkhbii, #jkhbii|text-align:center;\" data-tablet-css=\".sp-headline-block-jkhbii, #sp-jkhbii, #jkhbii|text-align:center;\" data-mobile-visibility=\".sp-headline-block-jkhbii|false\" data-tablet-visibility=\".sp-headline-block-jkhbii|false\" data-desktop-visibility=\".sp-headline-block-jkhbii|false\" class=\"sp-css-target sp-el-block sp-headline-block-jkhbii sp-type-header\" style=\"font-size: 52px; font-weight: bold; color: rgb(50, 27, 38); text-align: center; margin: 0px;\">Coming Soon</h1></span></div></div></section></div>", "sp-cs", "", "publish", "closed", "closed", "", "sp-cs", "", "", "2025-03-26 00:06:45", "2025-03-26 00:06:45", "{\"show_header_template\":true,\"show_footer_template\":true,\"no_conflict_mode\":true,\"no_index\":false,\"enable_recaptcha\":false,\"template_id\":373,\"post_title\":\"sp-cs\",\"post_name\":\"sp-cs\",\"post_status\":\"publish\",\"show_powered_by_link\":false,\"disable_default_excluded_urls\":false,\"include_exclude_type\":\"0\",\"bypass_expires\":\"2\",\"bypass_cookie\":false,\"access_by_role\":[],\"redirect_login_page\":false,\"redirect_mode\":false,\"redirect_url\":\"\",\"domain_mapping_status\":false,\"domain_mapping_force_https\":false,\"is_new\":false,\"page_type\":\"cs\",\"document\":{\"sections\":[{\"id\":\"ks8a8s\",\"type\":\"section\",\"rows\":[{\"id\":\"vw3kvy\",\"type\":\"row\",\"colType\":\"1-col\",\"cols\":[{\"id\":\"ggzp6w\",\"type\":\"col\",\"blocks\":[{\"id\":\"brhhwi\",\"elType\":\"block\",\"type\":\"image\",\"settings\":{\"linktype\":\"custom\",\"openNewWindow\":false,\"noFollow\":false,\"unit\":\"px\",\"srcaigenerated\":false,\"srcshow_modal_openai\":false,\"srcshow_generate_text\":true,\"srccodegenerated\":true,\"src\":\"https://assets.seedprod.com/clock.png\",\"marginTop\":\"0\",\"marginSync\":false,\"marginSync_mobile\":false,\"marginSync_tablet\":false,\"paddingSync\":true,\"paddingSync_mobile\":true,\"paddingSync_tablet\":true,\"align\":\"center\",\"align_mobile\":\"center\",\"align_tablet\":\"center\",\"imageBorderTop\":\"0\",\"imageBorderBottom\":\"0\",\"imageBorderLeft\":\"0\",\"imageBorderRight\":\"0\",\"imageBorderSync\":true,\"imageBorderStyle\":\"solid\",\"blockTemplateId\":false,\"radiusunit\":\"px\",\"borderRadiusSync\":true,\"shadowColor\":\"#000000\",\"shadowSpread\":\"-20\",\"shadowHorizontal\":\"0\",\"shadowVertical\":\"20\",\"shadowBlur\":\"20\",\"shadowPosition\":\"outline\",\"objectfit\":\"fill\",\"rotateimage\":0,\"hideOnDesktop\":false,\"hideOnMobile\":false,\"hideOnTablet\":false}},{\"id\":\"jkhbii\",\"elType\":\"block\",\"type\":\"header\",\"settings\":{\"headerTxt\":\"Coming Soon\",\"tag\":\"h1\",\"openNewWindow\":false,\"noFollow\":false,\"headerTxtshow_modal_openai\":false,\"headerTxtshow_generate_text\":true,\"textColor\":\"#321B26\",\"marginTop\":\"0\",\"marginSync\":false,\"marginSync_mobile\":false,\"marginSync_tablet\":false,\"paddingSync\":true,\"paddingSync_mobile\":true,\"paddingSync_tablet\":true,\"textshadowHorizontal\":0,\"textshadowVertical\":0,\"textshadowBlur\":3,\"textshadowSpread\":0,\"textshadowPosition\":\"outline\",\"fontSize\":52,\"typographyBold\":true,\"align\":\"center\",\"align_tablet\":\"center\",\"align_mobile\":\"center\",\"hideOnDesktop\":false,\"hideOnTablet\":false,\"hideOnMobile\":false}}],\"settings\":{\"bgStyle\":\"s\",\"bgGradient\":{\"type\":\"linear\",\"position\":\"center\",\"angle\":0,\"color1location\":0,\"color2location\":100},\"bgDimming\":0,\"bgCustomDimming\":0,\"bgCustomXPositionUnit\":\"px\",\"bgCustomYPositionUnit\":\"px\",\"bgCustomSizeWidthUnit\":\"%\",\"bgCustomSizeWidth\":\"100\",\"marginSync\":false,\"marginSync_mobile\":false,\"marginSync_tablet\":false,\"shadowHorizontal\":0,\"shadowVertical\":0,\"shadowBlur\":3,\"shadowSpread\":0,\"shadowPosition\":\"outline\",\"paddingSync\":true,\"paddingSync_mobile\":true,\"paddingSync_tablet\":true,\"borderRadiusSync\":true,\"borderTop\":\"0\",\"borderBottom\":\"0\",\"borderLeft\":\"0\",\"borderRight\":\"0\",\"borderSync\":true,\"borderStyle\":\"solid\",\"alignType\":\"s\",\"flexDirection\":\"column\",\"shapeDivider\":\"t\",\"bottomshapewidth\":100,\"bottomflip\":false,\"bottomfront\":false,\"topshapewidth\":100,\"topflip\":false,\"topfront\":false,\"hideOnDesktop\":false,\"hideOnMobile\":false,\"hideOnTablet\":false}}],\"settings\":{\"bgStyle\":\"s\",\"bgGradient\":{\"type\":\"linear\",\"position\":\"center\",\"angle\":0,\"color1location\":0,\"color2location\":100},\"colGutter\":0,\"contentWidth\":2,\"width\":\"1000\",\"bgDimming\":0,\"bgCustomDimming\":0,\"bgCustomXPositionUnit\":\"px\",\"bgCustomYPositionUnit\":\"px\",\"bgCustomSizeWidthUnit\":\"%\",\"bgCustomSizeWidth\":\"100\",\"marginSync\":false,\"marginSync_mobile\":false,\"marginSync_tablet\":false,\"shadowHorizontal\":0,\"shadowVertical\":0,\"shadowBlur\":3,\"shadowSpread\":0,\"shadowPosition\":\"outline\",\"paddingTop\":\"0\",\"paddingBottom\":\"0\",\"paddingLeft\":\"0\",\"paddingRight\":\"0\",\"paddingSync\":true,\"paddingSync_mobile\":true,\"paddingSync_tablet\":true,\"borderRadiusSync\":true,\"borderTop\":\"0\",\"borderBottom\":\"0\",\"borderLeft\":\"0\",\"borderRight\":\"0\",\"borderSync\":true,\"borderStyle\":\"solid\",\"alignType\":\"s\",\"flexDirection\":\"row\",\"shapeDivider\":\"t\",\"bottomshapewidth\":100,\"bottomflip\":false,\"bottomfront\":false,\"topshapewidth\":100,\"topflip\":false,\"topfront\":false,\"hideOnDesktop\":false,\"hideOnMobile\":false,\"hideOnTablet\":false}}],\"settings\":{\"particleBg\":false,\"particleStyle\":\"default\",\"particlesOpacity\":\"0.5\",\"particlesFlowDirection\":\"left\",\"particlesAdvanceSettings\":false,\"moveParticlesSpeed\":10,\"particlesHoverEffect\":true,\"bgStyle\":\"s\",\"bgGradient\":{\"type\":\"linear\",\"position\":\"center\",\"angle\":0,\"color1location\":0,\"color2location\":100},\"contentWidth\":\"2\",\"width\":600,\"bgDimming\":0,\"bgCustomDimming\":0,\"bgCustomXPositionUnit\":\"px\",\"bgCustomYPositionUnit\":\"px\",\"bgCustomSizeWidthUnit\":\"%\",\"bgCustomSizeWidth\":\"100\",\"marginSync\":false,\"marginSync_mobile\":false,\"marginSync_tablet\":false,\"shadowHorizontal\":0,\"shadowVertical\":0,\"shadowBlur\":3,\"shadowSpread\":0,\"shadowPosition\":\"outline\",\"paddingTop\":\"10\",\"paddingBottom\":\"10\",\"paddingLeft\":\"10\",\"paddingRight\":\"10\",\"paddingSync\":true,\"paddingSync_mobile\":true,\"paddingSync_tablet\":true,\"borderRadiusSync\":true,\"borderTop\":\"0\",\"borderBottom\":\"0\",\"borderLeft\":\"0\",\"borderRight\":\"0\",\"borderSync\":true,\"borderStyle\":\"solid\",\"shapeDivider\":\"t\",\"bottomshapewidth\":100,\"bottomflip\":false,\"bottomfront\":false,\"topshapewidth\":100,\"topflip\":false,\"topfront\":false,\"hideOnDesktop\":false,\"hideOnMobile\":false,\"hideOnTablet\":false}}],\"settings\":{\"bgStyle\":\"s\",\"bgGradient\":{\"type\":\"linear\",\"position\":\"center\",\"angle\":0,\"color1location\":0,\"color2location\":100},\"bgColor\":\"#FFFFFF\",\"bgDimming\":0,\"bgCustomDimming\":0,\"bgCustomXPositionUnit\":\"px\",\"bgCustomYPositionUnit\":\"px\",\"bgPosition\":\"cover\",\"buttonColor\":\"#000000\",\"headerColor\":\"#000000\",\"linkColor\":\"#FF0000\",\"linkDarkerColor\":\"#cc0000\",\"textColor\":\"#272727\",\"textFont\":\"\'Helvetica Neue\', Arial, sans-serif\",\"textFontVariant\":\"400\",\"headerFont\":\"\'Helvetica Neue\', Arial, sans-serif\",\"headerFontVariant\":\"400\",\"contentPosition\":\"4\",\"headCss\":\"#sp-page{color:#272727} #sp-page .sp-header-tag-h1,#sp-page .sp-header-tag-h2,#sp-page .sp-header-tag-h3,#sp-page .sp-header-tag-h4,#sp-page .sp-header-tag-h5,#sp-page .sp-header-tag-h6{color:#000000}#sp-page h1,#sp-page h2,#sp-page h3,#sp-page h4,#sp-page h5,#sp-page h6{color:#000000; font-family:\'Helvetica Neue\', Arial, sans-serif;font-weight:400;font-style:normal} #sp-page a{color:#FF0000} #sp-page a:hover{color:#cc0000}#sp-page .btn{background-color:#000000}body{background-color:#FFFFFF !important; background-image:;}\",\"useVideoBg\":false,\"useSlideshowBg\":false,\"useSlideshowImgs\":[\"\"]}}}", "0", "https://mangoknow.com/?post_type=seedprod&#038;p=5", "0", "seedprod", "", "0");
INSERT INTO `wor4890_posts` VALUES("6", "1", "2025-03-26 00:05:58", "2025-03-26 00:05:58", "", "sp-cs", "", "inherit", "closed", "closed", "", "5-revision-v1", "", "", "2025-03-26 00:05:58", "2025-03-26 00:05:58", "{\"show_header_template\":true,\"show_footer_template\":true,\"no_conflict_mode\":true,\"no_index\":false,\"seo_title\":\"\",\"seo_description\":\"\",\"favicon\":\"\",\"social_thumbnail\":\"\",\"enable_recaptcha\":false,\"template_id\":373,\"post_title\":\"sp-cs\",\"post_name\":\"sp-cs\",\"post_status\":\"\",\"show_powered_by_link\":false,\"facebook_app_id\":\"\",\"affiliate_url\":\"\",\"header_scripts\":\"\",\"body_scripts\":\"\",\"footer_scripts\":\"\",\"conversion_scripts\":\"\",\"disable_default_excluded_urls\":false,\"include_exclude_type\":\"0\",\"include_list\":\"\",\"exclude_list\":\"\",\"bypass_phrase\":\"\",\"bypass_expires\":\"2\",\"bypass_cookie\":false,\"access_by_ip\":\"\",\"access_by_role\":[],\"redirect_login_page\":false,\"redirect_mode\":false,\"redirect_url\":\"\",\"domain_mapping_status\":false,\"domain_mapping\":\"\",\"domain_mapping_force_https\":false,\"exclude_list_404\":\"\",\"email_integration_id\":\"\",\"is_new\":true,\"page_type\":\"cs\",\"document\":{\"sections\":[{\"id\":\"ks8a8s\",\"type\":\"section\",\"rows\":[{\"id\":\"vw3kvy\",\"type\":\"row\",\"colType\":\"1-col\",\"cols\":[{\"id\":\"ggzp6w\",\"type\":\"col\",\"blocks\":[{\"id\":\"brhhwi\",\"elType\":\"block\",\"type\":\"image\",\"settings\":{\"unit\":\"px\",\"src\":\"https://assets.seedprod.com/clock.png\",\"altTxt\":\"\",\"link\":\"\",\"width\":\"\",\"height\":\"\",\"marginTop\":\"0\",\"paddingTop\":\"\",\"paddingBottom\":\"\",\"paddingLeft\":\"\",\"paddingRight\":\"\",\"paddingSync\":true,\"imagePadding\":\"\",\"align\":\"center\",\"shadow\":\"\",\"imageBorderRadius\":\"\",\"imageBorderTop\":\"0\",\"imageBorderBottom\":\"0\",\"imageBorderLeft\":\"0\",\"imageBorderRight\":\"0\",\"imageBorderSync\":true,\"imageBorderStyle\":\"solid\",\"imageBorderColor\":\"\",\"blockTemplateId\":false}},{\"id\":\"jkhbii\",\"elType\":\"block\",\"type\":\"header\",\"settings\":{\"headerTxt\":\"Coming Soon\",\"tag\":\"h1\",\"textColor\":\"#321B26\",\"bgColor\":\"\",\"beforeIcon\":\"\",\"afterIcon\":\"\",\"marginTop\":\"0\",\"paddingTop\":\"\",\"paddingBottom\":\"\",\"paddingLeft\":\"\",\"paddingRight\":\"\",\"paddingSync\":true,\"borderRadius\":\"\",\"border\":\"\",\"borderStyle\":\"\",\"borderSize\":\"\",\"borderColor\":\"\",\"shadow\":\"\",\"textShadow\":\"\",\"font\":\"\",\"fontVariant\":\"\",\"fontSize\":52,\"fontSize_mobile\":\"\",\"lineHeight\":\"\",\"lineHeight_mobile\":\"\",\"letterSpacing\":\"\",\"letterSpacing_mobile\":\"\",\"typographyBold\":true,\"typographyItalic\":\"\",\"typographyUnderline\":\"\",\"align\":\"center\",\"typographyLetterCase\":\"\"}},{\"id\":\"jdj1i9\",\"elType\":\"block\",\"type\":\"text\",\"settings\":{\"txt\":\"<p>Get ready, something cool is coming!</p>\",\"textColor\":\"#321B26\",\"bgColor\":\"\",\"beforeIcon\":\"\",\"afterIcon\":\"\",\"marginTop\":\"0\",\"paddingTop\":\"\",\"paddingBottom\":\"\",\"paddingLeft\":\"\",\"paddingRight\":\"\",\"paddingSync\":true,\"borderRadius\":\"\",\"border\":\"\",\"borderStyle\":\"\",\"borderSize\":\"\",\"borderColor\":\"\",\"shadow\":\"\",\"textShadow\":\"\",\"font\":\"\",\"fontVariant\":\"\",\"fontSize\":16,\"fontSize_mobile\":\"\",\"lineHeight\":\"\",\"lineHeight_mobile\":\"\",\"letterSpacing\":\"\",\"letterSpacing_mobile\":\"\",\"typographyBold\":\"\",\"typographyItalic\":\"\",\"typographyUnderline\":\"\",\"align\":\"center\",\"typographyLetterCase\":\"\"}}],\"settings\":{\"bgStyle\":\"s\",\"bgGradient\":{\"type\":\"linear\",\"position\":\"center\",\"angle\":0,\"color1\":\"\",\"color1location\":0,\"color2\":\"\",\"color2location\":100},\"colWidth\":\"\",\"bgColor\":\"\",\"bgImage\":\"\",\"bgPosition\":\"\",\"marginTop\":\"\",\"shadow\":\"\",\"paddingTop\":\"\",\"paddingBottom\":\"\",\"paddingLeft\":\"\",\"paddingRight\":\"\",\"paddingSync\":true,\"borderRadiusTL\":\"\",\"borderRadiusTR\":\"\",\"borderRadiusBL\":\"\",\"borderRadiusBR\":\"\",\"borderRadiusSync\":true,\"borderTop\":\"0\",\"borderBottom\":\"0\",\"borderLeft\":\"0\",\"borderRight\":\"0\",\"borderSync\":true,\"borderStyle\":\"solid\"}}],\"settings\":{\"bgStyle\":\"s\",\"bgGradient\":{\"type\":\"linear\",\"position\":\"center\",\"angle\":0,\"color1\":\"\",\"color1location\":0,\"color2\":\"\",\"color2location\":100},\"colGutter\":0,\"width\":\"1000\",\"bgColor\":\"\",\"bgImage\":\"\",\"bgPosition\":\"\",\"marginTop\":\"\",\"shadow\":\"\",\"paddingTop\":\"0\",\"paddingBottom\":\"0\",\"paddingLeft\":\"0\",\"paddingRight\":\"0\",\"paddingSync\":true,\"borderRadiusTL\":\"\",\"borderRadiusTR\":\"\",\"borderRadiusBL\":\"\",\"borderRadiusBR\":\"\",\"borderRadiusSync\":true,\"borderTop\":\"0\",\"borderBottom\":\"0\",\"borderLeft\":\"0\",\"borderRight\":\"0\",\"borderSync\":true,\"borderStyle\":\"solid\"}}],\"settings\":{\"bgStyle\":\"s\",\"bgGradient\":{\"type\":\"linear\",\"position\":\"center\",\"angle\":0,\"color1\":\"\",\"color1location\":0,\"color2\":\"\",\"color2location\":100},\"contentWidth\":\"2\",\"width\":600,\"bgColor\":\"\",\"bgImage\":\"\",\"bgPosition\":\"\",\"marginTop\":\"\",\"shadow\":\"\",\"paddingTop\":\"10\",\"paddingBottom\":\"10\",\"paddingLeft\":\"10\",\"paddingRight\":\"10\",\"paddingSync\":true,\"borderRadius\":\"\",\"borderTop\":\"0\",\"borderBottom\":\"0\",\"borderLeft\":\"0\",\"borderRight\":\"0\",\"borderSync\":true,\"borderStyle\":\"solid\",\"borderRadiusTL\":\"\",\"borderRadiusTR\":\"\",\"borderRadiusBL\":\"\",\"borderRadiusBR\":\"\",\"borderRadiusSync\":true}}],\"settings\":{\"bgStyle\":\"s\",\"bgGradient\":{\"type\":\"linear\",\"position\":\"center\",\"angle\":0,\"color1\":\"\",\"color1location\":0,\"color2\":\"\",\"color2location\":100},\"bgColor\":\"#FFFFFF\",\"bgImage\":\"\",\"bgDimming\":0,\"bgOverlayColor\":\"\",\"bgPosition\":\"cover\",\"buttonColor\":\"#000000\",\"headerColor\":\"#000000\",\"linkColor\":\"#FF0000\",\"linkDarkerColor\":\"#cc0000\",\"textColor\":\"#272727\",\"textFont\":\"\'Helvetica Neue\', Arial, sans-serif\",\"textFontVariant\":\"400\",\"headerFont\":\"\'Helvetica Neue\', Arial, sans-serif\",\"headerFontVariant\":\"400\",\"contentPosition\":\"4\",\"customCss\":\"\",\"headCss\":\"#sp-page{color:#272727} #sp-page .sp-header-tag-h1,#sp-page .sp-header-tag-h2,#sp-page .sp-header-tag-h3,#sp-page .sp-header-tag-h4,#sp-page .sp-header-tag-h5,#sp-page .sp-header-tag-h6{color:#000000}#sp-page h1,#sp-page h2,#sp-page h3,#sp-page h4,#sp-page h5,#sp-page h6{color:#000000; font-family:\'Helvetica Neue\', Arial, sans-serif;font-weight:400;font-style:normal} #sp-page a{color:#FF0000} #sp-page a:hover{color:#cc0000}#sp-page .btn{background-color:#000000}body{background-color:#FFFFFF; background-image:;}\",\"mobileCss\":\"\",\"placeholderCss\":\"\",\"useVideoBg\":false,\"useVideoBgUrl\":\"\",\"useSlideshowBg\":false,\"useSlideshowImgs\":[\"\"]}}}", "5", "https://mangoknow.com/?p=6", "0", "revision", "", "0");
INSERT INTO `wor4890_posts` VALUES("7", "1", "2025-03-26 00:06:28", "2025-03-26 00:06:28", "<div id=\"sp-page\" class=\"spBgcover sp-content-4\" style=\"background-color: rgb(255, 255, 255); font-family: \'Helvetica Neue\', Arial, sans-serif; font-weight: 400;\"><section id=\"sp-ks8a8s\" data-mobile-visibility=\"#sp-ks8a8s|false\" data-tablet-visibility=\"#sp-ks8a8s|false\" data-desktop-visibility=\"#sp-ks8a8s|false\" data-mobile-css=\"\" data-tablet-css=\"\" class=\"sp-el-section \" style=\"width: 600px; max-width: 100%; padding: 10px;\"><div id=\"sp-vw3kvy\" data-mobile-visibility=\"#sp-vw3kvy|false\" data-tablet-visibility=\"#sp-vw3kvy|false\" data-desktop-visibility=\"#sp-vw3kvy|false\" data-mobile-css=\"\" data-tablet-css=\"\" class=\"sp-el-row sp-w-full  sp-m-auto sm:sp-flex sp-justify-between\" style=\"padding: 0px; width: auto; max-width: 1000px;\"><div id=\"sp-ggzp6w\" data-mobile-visibility=\"#sp-ggzp6w|false\" data-tablet-visibility=\"#sp-ggzp6w|false\" data-desktop-visibility=\"#sp-ggzp6w|false\" data-mobile-css=\"\" data-tablet-css=\"\" class=\"sp-el-col  sp-w-full\" style=\"width: calc(100% - 0px);\"><figure id=\"sp-brhhwi\" data-mobile-css=\"#sp-brhhwi|text-align:center;\" data-tablet-css=\"#sp-brhhwi|text-align:center;\" class=\"sp-image-wrapper sp-el-block\" style=\"margin: 0px; text-align: center;\"><div><span><img src=\"https://assets.seedprod.com/clock.png\" alt=\"\" width=\"\" height=\"\" data-dynamic-tag=\"\" data-image-src=\"\" data-mobile-visibility=\".sp-image-block-brhhwi|false\" data-tablet-visibility=\".sp-image-block-brhhwi|false\" data-desktop-visibility=\".sp-image-block-brhhwi|false\" class=\"sp-image-block-brhhwi custom-preview-class\"></span></div><div id=\"sp-image-dynamic-tags-js-brhhwi\"><script>jQuery(function() { image_dynamic_tags(\'brhhwi\' );});</script></div></figure><span href=\"\" target=\"\" rel=\"\" class=\"sp-header-block-link\" style=\"text-decoration: none;\"><h1 id=\"sp-jkhbii\" data-mobile-css=\".sp-headline-block-jkhbii, #sp-jkhbii, #jkhbii|text-align:center;\" data-tablet-css=\".sp-headline-block-jkhbii, #sp-jkhbii, #jkhbii|text-align:center;\" data-mobile-visibility=\".sp-headline-block-jkhbii|false\" data-tablet-visibility=\".sp-headline-block-jkhbii|false\" data-desktop-visibility=\".sp-headline-block-jkhbii|false\" class=\"sp-css-target sp-el-block sp-headline-block-jkhbii sp-type-header\" style=\"font-size: 52px; font-weight: bold; color: rgb(50, 27, 38); text-align: center; margin: 0px;\">Coming Soon</h1></span></div></div></section></div>", "sp-cs", "", "inherit", "closed", "closed", "", "5-revision-v1", "", "", "2025-03-26 00:06:28", "2025-03-26 00:06:28", "{\"show_header_template\":true,\"show_footer_template\":true,\"no_conflict_mode\":true,\"no_index\":false,\"enable_recaptcha\":false,\"template_id\":373,\"post_title\":\"sp-cs\",\"post_name\":\"sp-cs\",\"post_status\":\"draft\",\"show_powered_by_link\":false,\"disable_default_excluded_urls\":false,\"include_exclude_type\":\"0\",\"bypass_expires\":\"2\",\"bypass_cookie\":false,\"access_by_role\":[],\"redirect_login_page\":false,\"redirect_mode\":false,\"redirect_url\":\"\",\"domain_mapping_status\":false,\"domain_mapping_force_https\":false,\"is_new\":false,\"page_type\":\"cs\",\"document\":{\"sections\":[{\"id\":\"ks8a8s\",\"type\":\"section\",\"rows\":[{\"id\":\"vw3kvy\",\"type\":\"row\",\"colType\":\"1-col\",\"cols\":[{\"id\":\"ggzp6w\",\"type\":\"col\",\"blocks\":[{\"id\":\"brhhwi\",\"elType\":\"block\",\"type\":\"image\",\"settings\":{\"linktype\":\"custom\",\"openNewWindow\":false,\"noFollow\":false,\"unit\":\"px\",\"srcaigenerated\":false,\"srcshow_modal_openai\":false,\"srcshow_generate_text\":true,\"srccodegenerated\":true,\"src\":\"https://assets.seedprod.com/clock.png\",\"marginTop\":\"0\",\"marginSync\":false,\"marginSync_mobile\":false,\"marginSync_tablet\":false,\"paddingSync\":true,\"paddingSync_mobile\":true,\"paddingSync_tablet\":true,\"align\":\"center\",\"align_mobile\":\"center\",\"align_tablet\":\"center\",\"imageBorderTop\":\"0\",\"imageBorderBottom\":\"0\",\"imageBorderLeft\":\"0\",\"imageBorderRight\":\"0\",\"imageBorderSync\":true,\"imageBorderStyle\":\"solid\",\"blockTemplateId\":false,\"radiusunit\":\"px\",\"borderRadiusSync\":true,\"shadowColor\":\"#000000\",\"shadowSpread\":\"-20\",\"shadowHorizontal\":\"0\",\"shadowVertical\":\"20\",\"shadowBlur\":\"20\",\"shadowPosition\":\"outline\",\"objectfit\":\"fill\",\"rotateimage\":0,\"hideOnDesktop\":false,\"hideOnMobile\":false,\"hideOnTablet\":false}},{\"id\":\"jkhbii\",\"elType\":\"block\",\"type\":\"header\",\"settings\":{\"headerTxt\":\"Coming Soon\",\"tag\":\"h1\",\"openNewWindow\":false,\"noFollow\":false,\"headerTxtshow_modal_openai\":false,\"headerTxtshow_generate_text\":true,\"textColor\":\"#321B26\",\"marginTop\":\"0\",\"marginSync\":false,\"marginSync_mobile\":false,\"marginSync_tablet\":false,\"paddingSync\":true,\"paddingSync_mobile\":true,\"paddingSync_tablet\":true,\"textshadowHorizontal\":0,\"textshadowVertical\":0,\"textshadowBlur\":3,\"textshadowSpread\":0,\"textshadowPosition\":\"outline\",\"fontSize\":52,\"typographyBold\":true,\"align\":\"center\",\"align_tablet\":\"center\",\"align_mobile\":\"center\",\"hideOnDesktop\":false,\"hideOnTablet\":false,\"hideOnMobile\":false}}],\"settings\":{\"bgStyle\":\"s\",\"bgGradient\":{\"type\":\"linear\",\"position\":\"center\",\"angle\":0,\"color1location\":0,\"color2location\":100},\"bgDimming\":0,\"bgCustomDimming\":0,\"bgCustomXPositionUnit\":\"px\",\"bgCustomYPositionUnit\":\"px\",\"bgCustomSizeWidthUnit\":\"%\",\"bgCustomSizeWidth\":\"100\",\"marginSync\":false,\"marginSync_mobile\":false,\"marginSync_tablet\":false,\"shadowHorizontal\":0,\"shadowVertical\":0,\"shadowBlur\":3,\"shadowSpread\":0,\"shadowPosition\":\"outline\",\"paddingSync\":true,\"paddingSync_mobile\":true,\"paddingSync_tablet\":true,\"borderRadiusSync\":true,\"borderTop\":\"0\",\"borderBottom\":\"0\",\"borderLeft\":\"0\",\"borderRight\":\"0\",\"borderSync\":true,\"borderStyle\":\"solid\",\"alignType\":\"s\",\"flexDirection\":\"column\",\"shapeDivider\":\"t\",\"bottomshapewidth\":100,\"bottomflip\":false,\"bottomfront\":false,\"topshapewidth\":100,\"topflip\":false,\"topfront\":false,\"hideOnDesktop\":false,\"hideOnMobile\":false,\"hideOnTablet\":false}}],\"settings\":{\"bgStyle\":\"s\",\"bgGradient\":{\"type\":\"linear\",\"position\":\"center\",\"angle\":0,\"color1location\":0,\"color2location\":100},\"colGutter\":0,\"contentWidth\":2,\"width\":\"1000\",\"bgDimming\":0,\"bgCustomDimming\":0,\"bgCustomXPositionUnit\":\"px\",\"bgCustomYPositionUnit\":\"px\",\"bgCustomSizeWidthUnit\":\"%\",\"bgCustomSizeWidth\":\"100\",\"marginSync\":false,\"marginSync_mobile\":false,\"marginSync_tablet\":false,\"shadowHorizontal\":0,\"shadowVertical\":0,\"shadowBlur\":3,\"shadowSpread\":0,\"shadowPosition\":\"outline\",\"paddingTop\":\"0\",\"paddingBottom\":\"0\",\"paddingLeft\":\"0\",\"paddingRight\":\"0\",\"paddingSync\":true,\"paddingSync_mobile\":true,\"paddingSync_tablet\":true,\"borderRadiusSync\":true,\"borderTop\":\"0\",\"borderBottom\":\"0\",\"borderLeft\":\"0\",\"borderRight\":\"0\",\"borderSync\":true,\"borderStyle\":\"solid\",\"alignType\":\"s\",\"flexDirection\":\"row\",\"shapeDivider\":\"t\",\"bottomshapewidth\":100,\"bottomflip\":false,\"bottomfront\":false,\"topshapewidth\":100,\"topflip\":false,\"topfront\":false,\"hideOnDesktop\":false,\"hideOnMobile\":false,\"hideOnTablet\":false}}],\"settings\":{\"particleBg\":false,\"particleStyle\":\"default\",\"particlesOpacity\":\"0.5\",\"particlesFlowDirection\":\"left\",\"particlesAdvanceSettings\":false,\"moveParticlesSpeed\":10,\"particlesHoverEffect\":true,\"bgStyle\":\"s\",\"bgGradient\":{\"type\":\"linear\",\"position\":\"center\",\"angle\":0,\"color1location\":0,\"color2location\":100},\"contentWidth\":\"2\",\"width\":600,\"bgDimming\":0,\"bgCustomDimming\":0,\"bgCustomXPositionUnit\":\"px\",\"bgCustomYPositionUnit\":\"px\",\"bgCustomSizeWidthUnit\":\"%\",\"bgCustomSizeWidth\":\"100\",\"marginSync\":false,\"marginSync_mobile\":false,\"marginSync_tablet\":false,\"shadowHorizontal\":0,\"shadowVertical\":0,\"shadowBlur\":3,\"shadowSpread\":0,\"shadowPosition\":\"outline\",\"paddingTop\":\"10\",\"paddingBottom\":\"10\",\"paddingLeft\":\"10\",\"paddingRight\":\"10\",\"paddingSync\":true,\"paddingSync_mobile\":true,\"paddingSync_tablet\":true,\"borderRadiusSync\":true,\"borderTop\":\"0\",\"borderBottom\":\"0\",\"borderLeft\":\"0\",\"borderRight\":\"0\",\"borderSync\":true,\"borderStyle\":\"solid\",\"shapeDivider\":\"t\",\"bottomshapewidth\":100,\"bottomflip\":false,\"bottomfront\":false,\"topshapewidth\":100,\"topflip\":false,\"topfront\":false,\"hideOnDesktop\":false,\"hideOnMobile\":false,\"hideOnTablet\":false}}],\"settings\":{\"bgStyle\":\"s\",\"bgGradient\":{\"type\":\"linear\",\"position\":\"center\",\"angle\":0,\"color1location\":0,\"color2location\":100},\"bgColor\":\"#FFFFFF\",\"bgDimming\":0,\"bgCustomDimming\":0,\"bgCustomXPositionUnit\":\"px\",\"bgCustomYPositionUnit\":\"px\",\"bgPosition\":\"cover\",\"buttonColor\":\"#000000\",\"headerColor\":\"#000000\",\"linkColor\":\"#FF0000\",\"linkDarkerColor\":\"#cc0000\",\"textColor\":\"#272727\",\"textFont\":\"\'Helvetica Neue\', Arial, sans-serif\",\"textFontVariant\":\"400\",\"headerFont\":\"\'Helvetica Neue\', Arial, sans-serif\",\"headerFontVariant\":\"400\",\"contentPosition\":\"4\",\"headCss\":\"#sp-page{color:#272727} #sp-page .sp-header-tag-h1,#sp-page .sp-header-tag-h2,#sp-page .sp-header-tag-h3,#sp-page .sp-header-tag-h4,#sp-page .sp-header-tag-h5,#sp-page .sp-header-tag-h6{color:#000000}#sp-page h1,#sp-page h2,#sp-page h3,#sp-page h4,#sp-page h5,#sp-page h6{color:#000000; font-family:\'Helvetica Neue\', Arial, sans-serif;font-weight:400;font-style:normal} #sp-page a{color:#FF0000} #sp-page a:hover{color:#cc0000}#sp-page .btn{background-color:#000000}body{background-color:#FFFFFF !important; background-image:;}\",\"mobileCss\":\".sp-mobile-view #sp-brhhwi {text-align:center !important;}.sp-mobile-view .sp-headline-block-jkhbii, .sp-mobile-view  #sp-jkhbii, .sp-mobile-view  #jkhbii {text-align:center !important;}\",\"tabletCss\":\".sp-tablet-view #sp-brhhwi {text-align:center !important;}.sp-tablet-view .sp-headline-block-jkhbii, .sp-tablet-view  #sp-jkhbii, .sp-tablet-view  #jkhbii {text-align:center !important;}\",\"useVideoBg\":false,\"useSlideshowBg\":false,\"useSlideshowImgs\":[\"\"]}}}", "5", "https://mangoknow.com/?p=7", "0", "revision", "", "0");
INSERT INTO `wor4890_posts` VALUES("8", "1", "2025-03-26 00:06:39", "2025-03-26 00:06:39", "<div id=\"sp-page\" class=\"spBgcover sp-content-4\" style=\"background-color: rgb(255, 255, 255); font-family: \'Helvetica Neue\', Arial, sans-serif; font-weight: 400;\"><section id=\"sp-ks8a8s\" data-mobile-visibility=\"#sp-ks8a8s|false\" data-tablet-visibility=\"#sp-ks8a8s|false\" data-desktop-visibility=\"#sp-ks8a8s|false\" data-mobile-css=\"\" data-tablet-css=\"\" class=\"sp-el-section \" style=\"width: 600px; max-width: 100%; padding: 10px;\"><div id=\"sp-vw3kvy\" data-mobile-visibility=\"#sp-vw3kvy|false\" data-tablet-visibility=\"#sp-vw3kvy|false\" data-desktop-visibility=\"#sp-vw3kvy|false\" data-mobile-css=\"\" data-tablet-css=\"\" class=\"sp-el-row sp-w-full  sp-m-auto sm:sp-flex sp-justify-between\" style=\"padding: 0px; width: auto; max-width: 1000px;\"><div id=\"sp-ggzp6w\" data-mobile-visibility=\"#sp-ggzp6w|false\" data-tablet-visibility=\"#sp-ggzp6w|false\" data-desktop-visibility=\"#sp-ggzp6w|false\" data-mobile-css=\"\" data-tablet-css=\"\" class=\"sp-el-col  sp-w-full\" style=\"width: calc(100% - 0px);\"><figure id=\"sp-brhhwi\" data-mobile-css=\"#sp-brhhwi|text-align:center;\" data-tablet-css=\"#sp-brhhwi|text-align:center;\" class=\"sp-image-wrapper sp-el-block\" style=\"margin: 0px; text-align: center;\"><div><span><img src=\"https://assets.seedprod.com/clock.png\" alt=\"\" width=\"\" height=\"\" data-dynamic-tag=\"\" data-image-src=\"\" data-mobile-visibility=\".sp-image-block-brhhwi|false\" data-tablet-visibility=\".sp-image-block-brhhwi|false\" data-desktop-visibility=\".sp-image-block-brhhwi|false\" class=\"sp-image-block-brhhwi custom-preview-class\"></span></div><div id=\"sp-image-dynamic-tags-js-brhhwi\"><script>jQuery(function() { image_dynamic_tags(\'brhhwi\' );});</script></div></figure><span href=\"\" target=\"\" rel=\"\" class=\"sp-header-block-link\" style=\"text-decoration: none;\"><h1 id=\"sp-jkhbii\" data-mobile-css=\".sp-headline-block-jkhbii, #sp-jkhbii, #jkhbii|text-align:center;\" data-tablet-css=\".sp-headline-block-jkhbii, #sp-jkhbii, #jkhbii|text-align:center;\" data-mobile-visibility=\".sp-headline-block-jkhbii|false\" data-tablet-visibility=\".sp-headline-block-jkhbii|false\" data-desktop-visibility=\".sp-headline-block-jkhbii|false\" class=\"sp-css-target sp-el-block sp-headline-block-jkhbii sp-type-header\" style=\"font-size: 52px; font-weight: bold; color: rgb(50, 27, 38); text-align: center; margin: 0px;\">Coming Soon</h1></span></div></div></section></div>", "sp-cs", "", "inherit", "closed", "closed", "", "5-revision-v1", "", "", "2025-03-26 00:06:39", "2025-03-26 00:06:39", "{\"show_header_template\":true,\"show_footer_template\":true,\"no_conflict_mode\":true,\"no_index\":false,\"enable_recaptcha\":false,\"template_id\":373,\"post_title\":\"sp-cs\",\"post_name\":\"sp-cs\",\"post_status\":\"publish\",\"show_powered_by_link\":false,\"disable_default_excluded_urls\":false,\"include_exclude_type\":\"0\",\"bypass_expires\":\"2\",\"bypass_cookie\":false,\"access_by_role\":[],\"redirect_login_page\":false,\"redirect_mode\":false,\"redirect_url\":\"\",\"domain_mapping_status\":false,\"domain_mapping_force_https\":false,\"is_new\":false,\"page_type\":\"cs\",\"document\":{\"sections\":[{\"id\":\"ks8a8s\",\"type\":\"section\",\"rows\":[{\"id\":\"vw3kvy\",\"type\":\"row\",\"colType\":\"1-col\",\"cols\":[{\"id\":\"ggzp6w\",\"type\":\"col\",\"blocks\":[{\"id\":\"brhhwi\",\"elType\":\"block\",\"type\":\"image\",\"settings\":{\"linktype\":\"custom\",\"openNewWindow\":false,\"noFollow\":false,\"unit\":\"px\",\"srcaigenerated\":false,\"srcshow_modal_openai\":false,\"srcshow_generate_text\":true,\"srccodegenerated\":true,\"src\":\"https://assets.seedprod.com/clock.png\",\"marginTop\":\"0\",\"marginSync\":false,\"marginSync_mobile\":false,\"marginSync_tablet\":false,\"paddingSync\":true,\"paddingSync_mobile\":true,\"paddingSync_tablet\":true,\"align\":\"center\",\"align_mobile\":\"center\",\"align_tablet\":\"center\",\"imageBorderTop\":\"0\",\"imageBorderBottom\":\"0\",\"imageBorderLeft\":\"0\",\"imageBorderRight\":\"0\",\"imageBorderSync\":true,\"imageBorderStyle\":\"solid\",\"blockTemplateId\":false,\"radiusunit\":\"px\",\"borderRadiusSync\":true,\"shadowColor\":\"#000000\",\"shadowSpread\":\"-20\",\"shadowHorizontal\":\"0\",\"shadowVertical\":\"20\",\"shadowBlur\":\"20\",\"shadowPosition\":\"outline\",\"objectfit\":\"fill\",\"rotateimage\":0,\"hideOnDesktop\":false,\"hideOnMobile\":false,\"hideOnTablet\":false}},{\"id\":\"jkhbii\",\"elType\":\"block\",\"type\":\"header\",\"settings\":{\"headerTxt\":\"Coming Soon\",\"tag\":\"h1\",\"openNewWindow\":false,\"noFollow\":false,\"headerTxtshow_modal_openai\":false,\"headerTxtshow_generate_text\":true,\"textColor\":\"#321B26\",\"marginTop\":\"0\",\"marginSync\":false,\"marginSync_mobile\":false,\"marginSync_tablet\":false,\"paddingSync\":true,\"paddingSync_mobile\":true,\"paddingSync_tablet\":true,\"textshadowHorizontal\":0,\"textshadowVertical\":0,\"textshadowBlur\":3,\"textshadowSpread\":0,\"textshadowPosition\":\"outline\",\"fontSize\":52,\"typographyBold\":true,\"align\":\"center\",\"align_tablet\":\"center\",\"align_mobile\":\"center\",\"hideOnDesktop\":false,\"hideOnTablet\":false,\"hideOnMobile\":false}}],\"settings\":{\"bgStyle\":\"s\",\"bgGradient\":{\"type\":\"linear\",\"position\":\"center\",\"angle\":0,\"color1location\":0,\"color2location\":100},\"bgDimming\":0,\"bgCustomDimming\":0,\"bgCustomXPositionUnit\":\"px\",\"bgCustomYPositionUnit\":\"px\",\"bgCustomSizeWidthUnit\":\"%\",\"bgCustomSizeWidth\":\"100\",\"marginSync\":false,\"marginSync_mobile\":false,\"marginSync_tablet\":false,\"shadowHorizontal\":0,\"shadowVertical\":0,\"shadowBlur\":3,\"shadowSpread\":0,\"shadowPosition\":\"outline\",\"paddingSync\":true,\"paddingSync_mobile\":true,\"paddingSync_tablet\":true,\"borderRadiusSync\":true,\"borderTop\":\"0\",\"borderBottom\":\"0\",\"borderLeft\":\"0\",\"borderRight\":\"0\",\"borderSync\":true,\"borderStyle\":\"solid\",\"alignType\":\"s\",\"flexDirection\":\"column\",\"shapeDivider\":\"t\",\"bottomshapewidth\":100,\"bottomflip\":false,\"bottomfront\":false,\"topshapewidth\":100,\"topflip\":false,\"topfront\":false,\"hideOnDesktop\":false,\"hideOnMobile\":false,\"hideOnTablet\":false}}],\"settings\":{\"bgStyle\":\"s\",\"bgGradient\":{\"type\":\"linear\",\"position\":\"center\",\"angle\":0,\"color1location\":0,\"color2location\":100},\"colGutter\":0,\"contentWidth\":2,\"width\":\"1000\",\"bgDimming\":0,\"bgCustomDimming\":0,\"bgCustomXPositionUnit\":\"px\",\"bgCustomYPositionUnit\":\"px\",\"bgCustomSizeWidthUnit\":\"%\",\"bgCustomSizeWidth\":\"100\",\"marginSync\":false,\"marginSync_mobile\":false,\"marginSync_tablet\":false,\"shadowHorizontal\":0,\"shadowVertical\":0,\"shadowBlur\":3,\"shadowSpread\":0,\"shadowPosition\":\"outline\",\"paddingTop\":\"0\",\"paddingBottom\":\"0\",\"paddingLeft\":\"0\",\"paddingRight\":\"0\",\"paddingSync\":true,\"paddingSync_mobile\":true,\"paddingSync_tablet\":true,\"borderRadiusSync\":true,\"borderTop\":\"0\",\"borderBottom\":\"0\",\"borderLeft\":\"0\",\"borderRight\":\"0\",\"borderSync\":true,\"borderStyle\":\"solid\",\"alignType\":\"s\",\"flexDirection\":\"row\",\"shapeDivider\":\"t\",\"bottomshapewidth\":100,\"bottomflip\":false,\"bottomfront\":false,\"topshapewidth\":100,\"topflip\":false,\"topfront\":false,\"hideOnDesktop\":false,\"hideOnMobile\":false,\"hideOnTablet\":false}}],\"settings\":{\"particleBg\":false,\"particleStyle\":\"default\",\"particlesOpacity\":\"0.5\",\"particlesFlowDirection\":\"left\",\"particlesAdvanceSettings\":false,\"moveParticlesSpeed\":10,\"particlesHoverEffect\":true,\"bgStyle\":\"s\",\"bgGradient\":{\"type\":\"linear\",\"position\":\"center\",\"angle\":0,\"color1location\":0,\"color2location\":100},\"contentWidth\":\"2\",\"width\":600,\"bgDimming\":0,\"bgCustomDimming\":0,\"bgCustomXPositionUnit\":\"px\",\"bgCustomYPositionUnit\":\"px\",\"bgCustomSizeWidthUnit\":\"%\",\"bgCustomSizeWidth\":\"100\",\"marginSync\":false,\"marginSync_mobile\":false,\"marginSync_tablet\":false,\"shadowHorizontal\":0,\"shadowVertical\":0,\"shadowBlur\":3,\"shadowSpread\":0,\"shadowPosition\":\"outline\",\"paddingTop\":\"10\",\"paddingBottom\":\"10\",\"paddingLeft\":\"10\",\"paddingRight\":\"10\",\"paddingSync\":true,\"paddingSync_mobile\":true,\"paddingSync_tablet\":true,\"borderRadiusSync\":true,\"borderTop\":\"0\",\"borderBottom\":\"0\",\"borderLeft\":\"0\",\"borderRight\":\"0\",\"borderSync\":true,\"borderStyle\":\"solid\",\"shapeDivider\":\"t\",\"bottomshapewidth\":100,\"bottomflip\":false,\"bottomfront\":false,\"topshapewidth\":100,\"topflip\":false,\"topfront\":false,\"hideOnDesktop\":false,\"hideOnMobile\":false,\"hideOnTablet\":false}}],\"settings\":{\"bgStyle\":\"s\",\"bgGradient\":{\"type\":\"linear\",\"position\":\"center\",\"angle\":0,\"color1location\":0,\"color2location\":100},\"bgColor\":\"#FFFFFF\",\"bgDimming\":0,\"bgCustomDimming\":0,\"bgCustomXPositionUnit\":\"px\",\"bgCustomYPositionUnit\":\"px\",\"bgPosition\":\"cover\",\"buttonColor\":\"#000000\",\"headerColor\":\"#000000\",\"linkColor\":\"#FF0000\",\"linkDarkerColor\":\"#cc0000\",\"textColor\":\"#272727\",\"textFont\":\"\'Helvetica Neue\', Arial, sans-serif\",\"textFontVariant\":\"400\",\"headerFont\":\"\'Helvetica Neue\', Arial, sans-serif\",\"headerFontVariant\":\"400\",\"contentPosition\":\"4\",\"headCss\":\"#sp-page{color:#272727} #sp-page .sp-header-tag-h1,#sp-page .sp-header-tag-h2,#sp-page .sp-header-tag-h3,#sp-page .sp-header-tag-h4,#sp-page .sp-header-tag-h5,#sp-page .sp-header-tag-h6{color:#000000}#sp-page h1,#sp-page h2,#sp-page h3,#sp-page h4,#sp-page h5,#sp-page h6{color:#000000; font-family:\'Helvetica Neue\', Arial, sans-serif;font-weight:400;font-style:normal} #sp-page a{color:#FF0000} #sp-page a:hover{color:#cc0000}#sp-page .btn{background-color:#000000}body{background-color:#FFFFFF !important; background-image:;}\",\"useVideoBg\":false,\"useSlideshowBg\":false,\"useSlideshowImgs\":[\"\"]}}}", "5", "https://mangoknow.com/?p=8", "0", "revision", "", "0");
INSERT INTO `wor4890_posts` VALUES("10", "1", "2025-07-28 16:42:40", "2025-07-28 16:42:40", "{\"version\": 3, \"isGlobalStylesUserThemeJSON\": true }", "Custom Styles", "", "publish", "closed", "closed", "", "wp-global-styles-twentytwentyfive", "", "", "2025-07-28 16:42:40", "2025-07-28 16:42:40", "", "0", "https://mangoknow.com/index.php/2025/07/28/wp-global-styles-twentytwentyfive/", "0", "wp_global_styles", "", "0");
INSERT INTO `wor4890_posts` VALUES("11", "1", "2025-07-28 16:42:47", "2025-07-28 16:42:47", "<!-- wp:page-list /-->", "Navigation", "", "publish", "closed", "closed", "", "navigation", "", "", "2025-07-28 16:42:47", "2025-07-28 16:42:47", "", "0", "https://mangoknow.com/index.php/2025/07/28/navigation/", "0", "wp_navigation", "", "0");
INSERT INTO `wor4890_posts` VALUES("13", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "Featured Image Homepage", "Featured Image Homepage", "", "inherit", "open", "closed", "", "featured-image-homepage", "", "", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "0", "http://mangoknow.com/wp-content/uploads/2025/07/slider1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wor4890_posts` VALUES("14", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "First slide", "", "inherit", "open", "closed", "", "first-slide", "", "", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "0", "http://mangoknow.com/wp-content/uploads/2025/07/slider1-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wor4890_posts` VALUES("15", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "Landscape", "", "inherit", "open", "closed", "", "landscape", "", "", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "0", "http://mangoknow.com/wp-content/uploads/2025/07/card-blog1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wor4890_posts` VALUES("16", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "Drone", "", "inherit", "open", "closed", "", "drone", "", "", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "0", "http://mangoknow.com/wp-content/uploads/2025/07/card-blog2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wor4890_posts` VALUES("17", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "Convertible", "", "inherit", "open", "closed", "", "convertible", "", "", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "0", "http://mangoknow.com/wp-content/uploads/2025/07/card-blog3.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wor4890_posts` VALUES("18", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "Tourism", "", "inherit", "open", "closed", "", "tourism", "", "", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "0", "http://mangoknow.com/wp-content/uploads/2025/07/card-blog4.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wor4890_posts` VALUES("19", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "Castle", "", "inherit", "open", "closed", "", "castle", "", "", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "0", "http://mangoknow.com/wp-content/uploads/2025/07/card-blog5.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wor4890_posts` VALUES("20", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "<!-- wp:cover {\"overlayColor\":\"white\",\"isUserOverlayColor\":true,\"align\":\"full\",\"className\":\"is-light hestia-clear-top-padding\"} -->\n<div class=\"wp-block-cover alignfull is-light hestia-clear-top-padding\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-white-background-color has-background-dim-100 has-background-dim\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:spacer {\"height\":\"40px\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"color\":{\"text\":\"#3c4858\"}}} -->\n<h2 class=\"wp-block-heading has-text-align-center has-text-color\" style=\"color:#3c4858\">About</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"40px\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"container\"} -->\n<div class=\"wp-block-columns container\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":70,\"width\":\"64px\",\"height\":\"auto\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"align\":\"center\"} -->\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><img src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/feat1.png\" alt=\"\" class=\"wp-image-70\" style=\"width:64px;height:auto\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":5,\"style\":{\"color\":{\"text\":\"#3c4858\"},\"typography\":{\"fontSize\":18}}} -->\n<h5 class=\"wp-block-heading has-text-align-center has-text-color\" style=\"color:#3c4858;font-size:18px\">Lesson Plans</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#999999\"},\"typography\":{\"fontSize\":14}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#999999;font-size:14px\">No-preparation plans that include reading, writing, listening and conversation on a wide range of topics.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"25px\"} -->\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":71,\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"align\":\"center\"} -->\n<figure class=\"wp-block-image aligncenter size-large\"><img src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/feat2.png\" alt=\"\" class=\"wp-image-71\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":5,\"style\":{\"color\":{\"text\":\"#3c4858\"},\"typography\":{\"fontSize\":18}}} -->\n<h5 class=\"wp-block-heading has-text-align-center has-text-color\" style=\"color:#3c4858;font-size:18px\">Conversation Topics</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#999999\"},\"typography\":{\"fontSize\":14}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#999999;font-size:14px\">Questions to promote discussion and fluency, for beginners, intermediate and advanced levels.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"25px\"} -->\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":72,\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"align\":\"center\"} -->\n<figure class=\"wp-block-image aligncenter size-large\"><img src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/feat3.png\" alt=\"\" class=\"wp-image-72\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":5,\"style\":{\"color\":{\"text\":\"#3c4858\"},\"typography\":{\"fontSize\":18}}} -->\n<h5 class=\"wp-block-heading has-text-align-center has-text-color\" style=\"color:#3c4858;font-size:18px\">Library</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#999999\"},\"typography\":{\"fontSize\":14}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#999999;font-size:14px\">Vocabulary, grammar, pronunciation, idioms and more.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"25px\"} -->\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"40px\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:columns {\"className\":\"container\"} -->\n<div class=\"wp-block-columns container\"><!-- wp:column {\"className\":\"col-md-5\"} -->\n<div class=\"wp-block-column col-md-5\"><!-- wp:spacer {\"height\":\"55px\"} -->\n<div style=\"height:55px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Sign up for our newsletter</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Stay up to date with the latest information.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"col-md-6 col-md-offset1\"} -->\n<div class=\"wp-block-column col-md-6 col-md-offset1\"><!-- wp:spacer {\"height\":\"55px\"} -->\n<div style=\"height:55px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":81,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/about-content.png\" alt=\"\" class=\"wp-image-81\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:code -->\n<pre class=\"wp-block-code\"><code>&lt;div class=\"hestia-info info info-horizontal\">\n&lt;div class=\"icon icon-primary\">&lt;i class=\"fas fa-map-marker-alt\">&lt;/i>&lt;/div>\n&lt;div class=\"description\">\n&lt;h4 class=\"info-title\">Find us at the office&lt;/h4>\nStrada Povernei, nr 20, Bucharest, Romania&lt;/div>\n&lt;/div>\n&lt;div class=\"hestia-info info info-horizontal\">\n&lt;div class=\"icon icon-primary\">&lt;i class=\"fas fa-mobile-alt\">&lt;/i>&lt;/div>\n&lt;div class=\"description\">\n&lt;h4 class=\"info-title\">Give us a ring&lt;/h4>\nJohn Doe +40 712 345 678 Mon – Fri, 8:00-22:00&lt;/div>\n&lt;/div></code></pre>\n<!-- /wp:code -->", "Home", "", "publish", "closed", "closed", "", "home", "", "", "2025-07-29 22:08:52", "2025-07-29 22:08:52", "", "0", "https://mangoknow.com/?page_id=20", "0", "page", "", "0");
INSERT INTO `wor4890_posts` VALUES("21", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "<!-- wp:columns {\"align\":\"full\"} -->\n		<div class=\"wp-block-columns alignfull\"><!-- wp:column -->\n		<div class=\"wp-block-column\"><!-- wp:html -->\n		<div style=\"width: 100%\"><iframe width=\"100%\" height=\"400\" frameborder=\"0\" scrolling=\"no\" marginheight=\"0\" marginwidth=\"0\" src=\"https://maps.google.com/maps?width=100%25&amp;height=400&amp;hl=en&amp;q=povernei%2020+(My%20Business%20Name)&amp;t=&amp;z=14&amp;ie=UTF8&amp;iwloc=B&amp;output=embed\"></iframe></div>\n		<!-- /wp:html -->\n		\n		<!-- wp:paragraph -->\n		<p></p>\n		<!-- /wp:paragraph --></div>\n		<!-- /wp:column --></div>\n		<!-- /wp:columns -->\n		\n		<!-- wp:columns {\"className\":\"container\"} -->\n		<div class=\"wp-block-columns container\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n		<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading {\"className\":\"hestia-title\"} -->\n		<h2 class=\"hestia-title\">Send us a message</h2>\n		<!-- /wp:heading -->\n		\n		<!-- wp:spacer {\"height\":40} -->\n		<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n		<!-- /wp:spacer -->\n		\n		<!-- wp:html -->\n		<div class=\"contact-wrapper\">\n																			<div class=\"content\">\n			\n			  <form>\n			   <div class=\"form-group\">\n			    <input type=\"text\" id=\"fname\" name=\"firstname\" placeholder=\"Your name..\">\n			</div>\n			<div class=\"form-group\">\n			    <input type=\"text\" id=\"lname\" name=\"lastname\" placeholder=\"Your last name..\">\n			</div>\n			<div class=\"form-group\">\n			    <textarea id=\"subject\" name=\"subject\" placeholder=\"Write something..\" style=\"height:200px\"></textarea>\n			</div>\n			    <input type=\"submit\" value=\"Submit\">\n			\n			  </form>\n			</div>\n			</div>\n		<!-- /wp:html --></div>\n		<!-- /wp:column -->\n		\n		<!-- wp:column {\"verticalAlignment\":\"center\"} -->\n		<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:columns -->\n		<div class=\"wp-block-columns\"><!-- wp:column -->\n		<div class=\"wp-block-column\"></div>\n		<!-- /wp:column -->\n		\n		<!-- wp:column {\"width\":\"50%\"} -->\n		<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":4,\"className\":\"hestia-title\",\"style\":{\"typography\":{\"fontSize\":18},\"color\":{\"text\":\"#3c4858\"}}} -->\n		<h4 class=\"has-text-align-left hestia-title has-text-color\" style=\"color:#3c4858;font-size:18px\"><img class=\"wp-image-86\" style=\"width: 25px;\" src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/contact1.png\" alt=\"Map icon\">  <strong>Find us at the office</strong></h4>\n		<!-- /wp:heading -->\n		\n		<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"typography\":{\"fontSize\":14},\"color\":{\"text\":\"#999999\"}}} -->\n		<p class=\"has-text-align-left has-text-color\" style=\"color:#999999;font-size:14px\">Strada Povernei, nr 20<br>Bucharest<br>Romania</p>\n		<!-- /wp:paragraph -->\n		\n		<!-- wp:spacer {\"height\":40} -->\n		<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n		<!-- /wp:spacer -->\n		\n		<!-- wp:heading {\"textAlign\":\"left\",\"level\":4,\"className\":\"hestia-title\",\"style\":{\"typography\":{\"fontSize\":18},\"color\":{\"text\":\"#3c4858\"}}} -->\n		<h4 class=\"has-text-align-left hestia-title has-text-color\" style=\"color:#3c4858;font-size:18px\"><img class=\"wp-image-98\" style=\"width: 25px;\" src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/contact2.png\" alt=\"\">  <strong><strong>Give us a ring</strong></strong></h4>\n		<!-- /wp:heading -->\n		\n		<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"color\":{\"text\":\"#999999\"},\"typography\":{\"fontSize\":14}}} -->\n		<p class=\"has-text-align-left has-text-color\" style=\"color:#999999;font-size:14px\">John Doe<br>+40 712 345 678<br>Mon - Fri, 8:00-22:00</p>\n		<!-- /wp:paragraph -->\n		\n		<!-- wp:spacer {\"height\":40} -->\n		<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n		<!-- /wp:spacer -->\n		\n		<!-- wp:heading {\"textAlign\":\"left\",\"level\":4,\"className\":\"hestia-title\",\"style\":{\"color\":{\"text\":\"#3c4858\"},\"typography\":{\"fontSize\":18}}} -->\n		<h4 class=\"has-text-align-left hestia-title has-text-color\" style=\"color:#3c4858;font-size:18px\"><img class=\"wp-image-105\" style=\"width: 25px;\" src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/contact3.png\" alt=\"\"><strong>  <strong>Legal information</strong></strong></h4>\n		<!-- /wp:heading -->\n		\n		<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"color\":{\"text\":\"#999999\"},\"typography\":{\"fontSize\":14}}} -->\n		<p class=\"has-text-align-left has-text-color\" style=\"color:#999999;font-size:14px\">John Doe Co.<br>Fiscal Code: 12345678</p>\n		<!-- /wp:paragraph --></div>\n		<!-- /wp:column -->\n		\n		<!-- wp:column -->\n		<div class=\"wp-block-column\"></div>\n		<!-- /wp:column --></div>\n		<!-- /wp:columns --></div>\n		<!-- /wp:column --></div>\n		<!-- /wp:columns -->\n		\n		<!-- wp:paragraph -->\n		<p></p>\n		<!-- /wp:paragraph -->", "Contact", "", "publish", "closed", "closed", "", "contact", "", "", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "0", "https://mangoknow.com/?page_id=21", "0", "page", "", "0");
INSERT INTO `wor4890_posts` VALUES("22", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "Blog", "", "publish", "closed", "closed", "", "blog", "", "", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "0", "https://mangoknow.com/?page_id=22", "0", "page", "", "0");
INSERT INTO `wor4890_posts` VALUES("23", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "<!-- wp:paragraph -->\n					<p>Yet bed any for travelling assistance indulgence unpleasing. Not thoughts all exercise blessing. Indulgence way everything joy alteration boisterous the attachment. Party we years to order allow asked of. We so opinion friends me message as delight. Whole front do of plate heard oh ought. His defective nor convinced residence own. Connection has put impossible own apartments boisterous. At jointure ladyship an insisted so humanity he. Friendly bachelor entrance to on by.</p>\n					<!-- /wp:paragraph -->\n					\n					<!-- wp:paragraph -->\n					<p>That last is no more than a foot high, and about seven paces across, a mere flat top of a grey rock which smokes like a hot cinder after a shower, and where no man would care to venture a naked sole before sunset. On the Little Isabel an old ragged palm, with a thick bulging trunk rough with spines, a very witch amongst palm trees, rustles a dismal bunch of dead leaves above the<a href=\"#\"> coarse sand</a>.</p>\n					<!-- /wp:paragraph -->", "Appearance guide", "", "publish", "open", "open", "", "appearance-guide", "", "", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "0", "https://mangoknow.com/?p=23", "0", "post", "", "0");
INSERT INTO `wor4890_posts` VALUES("24", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "<!-- wp:heading {\"level\":3,\"className\":\"title\"} -->\n					<h3 class=\"title\">Feet evil to hold long he open knew an no.</h3>\n					<!-- /wp:heading -->\n					\n					<!-- wp:paragraph -->\n					<p>Apartments occasional boisterous as solicitude to introduced. Or fifteen covered we enjoyed demesne is in prepare. In stimulated my everything it literature. Greatly explain attempt perhaps in feeling he. House men taste bed not drawn joy. Through enquire however do equally herself at. Greatly way old may you present improve. Wishing the feeling village him musical.</p>\n					<!-- /wp:paragraph -->\n					\n					<!-- wp:paragraph -->\n					<p>Smile spoke total few great had never their too. Amongst moments do in arrived at my replied. Fat weddings servants but man believed prospect. Companions understood is as especially pianoforte connection introduced. Nay newspaper can sportsman are admitting gentleman belonging his.</p>\n					<!-- /wp:paragraph -->", "Perfectly on furniture", "", "publish", "open", "open", "", "perfectly-on-furniture", "", "", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "0", "https://mangoknow.com/?p=24", "0", "post", "", "0");
INSERT INTO `wor4890_posts` VALUES("25", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "<!-- wp:paragraph -->\n					<p><em>To shewing another demands sentiments. Marianne property cheerful informed at striking at. Clothes parlors however by cottage on. In views it or meant drift to. Be concern parlors settled or do shyness address.&nbsp;</em></p>\n					<!-- /wp:paragraph -->\n					\n					<!-- wp:heading -->\n					<h2>He always do do former he highly.</h2>\n					<!-- /wp:heading -->\n					\n					<!-- wp:paragraph -->\n					<p>Continual so distrusts pronounce by unwilling listening</p>\n					<!-- /wp:paragraph -->\n					\n					<!-- wp:paragraph -->\n					<p>Expenses as material breeding insisted building to in. Continual so distrusts pronounce by unwilling listening. Thing do taste on we manor. Him had wound use found hoped. Of distrusts immediate enjoyment curiosity do. Marianne numerous saw thoughts the humoured.</p>\n					<!-- /wp:paragraph -->", "Fat son how smiling natural", "", "publish", "open", "open", "", "fat-son-how-smiling-natural", "", "", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "0", "https://mangoknow.com/?p=25", "0", "post", "", "0");
INSERT INTO `wor4890_posts` VALUES("26", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "<!-- wp:heading -->\n					<h2>Way nor furnished sir procuring therefore but.</h2>\n					<!-- /wp:heading -->\n					\n					<!-- wp:paragraph -->\n					<p>Warmth far manner myself active are cannot called. Set her half end girl rich met. Me allowance departure an curiosity ye. In no talking address excited it conduct. Husbands debating replying overcame<em>&nbsp;blessing</em>&nbsp;he it me to domestic.</p>\n					<!-- /wp:paragraph -->\n					\n					<!-- wp:list -->\n					<ul><li>As absolute is by amounted repeated entirely ye returned.</li><li>These ready timed enjoy might sir yet one since.</li><li>Years drift never if could forty being no.</li></ul>\n					<!-- /wp:list -->", "Can curiosity may end shameless explained", "", "publish", "open", "open", "", "can-curiosity-may-end-shameless-explained", "", "", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "0", "https://mangoknow.com/?p=26", "0", "post", "", "0");
INSERT INTO `wor4890_posts` VALUES("27", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "<!-- wp:paragraph -->\n					<p>It acceptance thoroughly my advantages everything as. Are projecting inquietude affronting preference saw who. Marry of am do avoid ample as. Old disposal followed she ignorant desirous two has. Called played entire roused though for one too. He into walk roof made tall cold he. Feelings way likewise addition wandered contempt bed indulged.</p>\n					<!-- /wp:paragraph -->\n					\n					<!-- wp:heading {\"level\":4} -->\n					<h4><strong>Still court no small think death so an wrote.</strong></h4>\n					<!-- /wp:heading -->\n					\n					<!-- wp:paragraph -->\n					<p>Incommode necessary no it behaviour convinced distrusts an unfeeling he. Could death since do we hoped is in. Exquisite no my attention extensive. The determine conveying moonlight age. Avoid for see marry sorry child. Sitting so totally forbade hundred to.</p>\n					<!-- /wp:paragraph -->", "Improve him believe opinion offered", "", "publish", "open", "open", "", "improve-him-believe-opinion-offered", "", "", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "0", "https://mangoknow.com/?p=27", "0", "post", "", "0");
INSERT INTO `wor4890_posts` VALUES("29", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "<!-- wp:cover {\"overlayColor\":\"white\",\"align\":\"full\",\"className\":\"hestia-clear-top-padding\"} -->\n	<div class=\"wp-block-cover alignfull has-white-background-color has-background-dim hestia-clear-top-padding\"><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"color\":{\"text\":\"#3c4858\"}}} -->\n	<h2 class=\"has-text-align-center has-text-color\" style=\"color:#3c4858\">What we stand for</h2>\n	<!-- /wp:heading -->\n	\n	<!-- wp:spacer {\"height\":40} -->\n	<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n	<!-- /wp:spacer -->\n	\n	<!-- wp:columns {\"className\":\"container\"} -->\n	<div class=\"wp-block-columns container\"><!-- wp:column -->\n	<div class=\"wp-block-column\"><!-- wp:image {\"align\":\"center\",\"id\":70,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n	<div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/feat1.png\" alt=\"\" class=\"wp-image-70\"/></figure></div>\n	<!-- /wp:image -->\n	\n	<!-- wp:heading {\"textAlign\":\"center\",\"level\":5,\"style\":{\"color\":{\"text\":\"#3c4858\"},\"typography\":{\"fontSize\":18}}} -->\n	<h5 class=\"has-text-align-center has-text-color\" style=\"color:#3c4858;font-size:18px\">Responsive</h5>\n	<!-- /wp:heading -->\n	\n	<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#999999\"},\"typography\":{\"fontSize\":14}}} -->\n	<p class=\"has-text-align-center has-text-color\" style=\"color:#999999;font-size:14px\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\n	<!-- /wp:paragraph -->\n	\n	<!-- wp:spacer {\"height\":25} -->\n	<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n	<!-- /wp:spacer --></div>\n	<!-- /wp:column -->\n	\n	<!-- wp:column -->\n	<div class=\"wp-block-column\"><!-- wp:image {\"align\":\"center\",\"id\":71,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n	<div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/feat2.png\" alt=\"\" class=\"wp-image-71\"/></figure></div>\n	<!-- /wp:image -->\n	\n	<!-- wp:heading {\"textAlign\":\"center\",\"level\":5,\"style\":{\"color\":{\"text\":\"#3c4858\"},\"typography\":{\"fontSize\":18}}} -->\n	<h5 class=\"has-text-align-center has-text-color\" style=\"color:#3c4858;font-size:18px\">Quality</h5>\n	<!-- /wp:heading -->\n	\n	<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#999999\"},\"typography\":{\"fontSize\":14}}} -->\n	<p class=\"has-text-align-center has-text-color\" style=\"color:#999999;font-size:14px\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\n	<!-- /wp:paragraph -->\n	\n	<!-- wp:spacer {\"height\":25} -->\n	<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n	<!-- /wp:spacer --></div>\n	<!-- /wp:column -->\n	\n	<!-- wp:column -->\n	<div class=\"wp-block-column\"><!-- wp:image {\"align\":\"center\",\"id\":72,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n	<div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/feat3.png\" alt=\"\" class=\"wp-image-72\"/></figure></div>\n	<!-- /wp:image -->\n	\n	<!-- wp:heading {\"textAlign\":\"center\",\"level\":5,\"style\":{\"color\":{\"text\":\"#3c4858\"},\"typography\":{\"fontSize\":18}}} -->\n	<h5 class=\"has-text-align-center has-text-color\" style=\"color:#3c4858;font-size:18px\">Support</h5>\n	<!-- /wp:heading -->\n	\n	<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#999999\"},\"typography\":{\"fontSize\":14}}} -->\n	<p class=\"has-text-align-center has-text-color\" style=\"color:#999999;font-size:14px\">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>\n	<!-- /wp:paragraph -->\n	\n	<!-- wp:spacer {\"height\":25} -->\n	<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n	<!-- /wp:spacer --></div>\n	<!-- /wp:column --></div>\n	<!-- /wp:columns -->\n	\n	<!-- wp:spacer {\"height\":40} -->\n	<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n	<!-- /wp:spacer --></div></div>\n	<!-- /wp:cover -->\n	\n	<!-- wp:columns {\"className\":\"container\"} -->\n	<div class=\"wp-block-columns container\"><!-- wp:column {\"className\":\"col-md-5\"} -->\n	<div class=\"wp-block-column col-md-5\"><!-- wp:spacer {\"height\":55} -->\n	<div style=\"height:55px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n	<!-- /wp:spacer -->\n	\n	<!-- wp:heading -->\n	<h2>About Hestia</h2>\n	<!-- /wp:heading -->\n	\n	<!-- wp:paragraph -->\n	<p>Need more details? Please check our full documentation for detailed information on how to use Hestia.</p>\n	<!-- /wp:paragraph --></div>\n	<!-- /wp:column -->\n	\n	<!-- wp:column {\"className\":\"col-md-6 col-md-offset1\"} -->\n	<div class=\"wp-block-column col-md-6 col-md-offset1\"><!-- wp:spacer {\"height\":55} -->\n	<div style=\"height:55px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n	<!-- /wp:spacer -->\n	\n	<!-- wp:image {\"id\":81,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n	<figure class=\"wp-block-image size-large\"><img src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/about-content.png\" alt=\"\" class=\"wp-image-81\"/></figure>\n	<!-- /wp:image -->\n	\n	<!-- wp:paragraph -->\n	<p></p>\n	<!-- /wp:paragraph --></div>\n	<!-- /wp:column --></div>\n	<!-- /wp:columns -->", "Home", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "20", "https://mangoknow.com/?p=29", "0", "revision", "", "0");
INSERT INTO `wor4890_posts` VALUES("30", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "<!-- wp:columns {\"align\":\"full\"} -->\n		<div class=\"wp-block-columns alignfull\"><!-- wp:column -->\n		<div class=\"wp-block-column\"><!-- wp:html -->\n		<div style=\"width: 100%\"><iframe width=\"100%\" height=\"400\" frameborder=\"0\" scrolling=\"no\" marginheight=\"0\" marginwidth=\"0\" src=\"https://maps.google.com/maps?width=100%25&amp;height=400&amp;hl=en&amp;q=povernei%2020+(My%20Business%20Name)&amp;t=&amp;z=14&amp;ie=UTF8&amp;iwloc=B&amp;output=embed\"></iframe></div>\n		<!-- /wp:html -->\n		\n		<!-- wp:paragraph -->\n		<p></p>\n		<!-- /wp:paragraph --></div>\n		<!-- /wp:column --></div>\n		<!-- /wp:columns -->\n		\n		<!-- wp:columns {\"className\":\"container\"} -->\n		<div class=\"wp-block-columns container\"><!-- wp:column {\"verticalAlignment\":\"center\"} -->\n		<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:heading {\"className\":\"hestia-title\"} -->\n		<h2 class=\"hestia-title\">Send us a message</h2>\n		<!-- /wp:heading -->\n		\n		<!-- wp:spacer {\"height\":40} -->\n		<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n		<!-- /wp:spacer -->\n		\n		<!-- wp:html -->\n		<div class=\"contact-wrapper\">\n																			<div class=\"content\">\n			\n			  <form>\n			   <div class=\"form-group\">\n			    <input type=\"text\" id=\"fname\" name=\"firstname\" placeholder=\"Your name..\">\n			</div>\n			<div class=\"form-group\">\n			    <input type=\"text\" id=\"lname\" name=\"lastname\" placeholder=\"Your last name..\">\n			</div>\n			<div class=\"form-group\">\n			    <textarea id=\"subject\" name=\"subject\" placeholder=\"Write something..\" style=\"height:200px\"></textarea>\n			</div>\n			    <input type=\"submit\" value=\"Submit\">\n			\n			  </form>\n			</div>\n			</div>\n		<!-- /wp:html --></div>\n		<!-- /wp:column -->\n		\n		<!-- wp:column {\"verticalAlignment\":\"center\"} -->\n		<div class=\"wp-block-column is-vertically-aligned-center\"><!-- wp:columns -->\n		<div class=\"wp-block-columns\"><!-- wp:column -->\n		<div class=\"wp-block-column\"></div>\n		<!-- /wp:column -->\n		\n		<!-- wp:column {\"width\":\"50%\"} -->\n		<div class=\"wp-block-column\" style=\"flex-basis:50%\"><!-- wp:heading {\"textAlign\":\"left\",\"level\":4,\"className\":\"hestia-title\",\"style\":{\"typography\":{\"fontSize\":18},\"color\":{\"text\":\"#3c4858\"}}} -->\n		<h4 class=\"has-text-align-left hestia-title has-text-color\" style=\"color:#3c4858;font-size:18px\"><img class=\"wp-image-86\" style=\"width: 25px;\" src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/contact1.png\" alt=\"Map icon\">  <strong>Find us at the office</strong></h4>\n		<!-- /wp:heading -->\n		\n		<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"typography\":{\"fontSize\":14},\"color\":{\"text\":\"#999999\"}}} -->\n		<p class=\"has-text-align-left has-text-color\" style=\"color:#999999;font-size:14px\">Strada Povernei, nr 20<br>Bucharest<br>Romania</p>\n		<!-- /wp:paragraph -->\n		\n		<!-- wp:spacer {\"height\":40} -->\n		<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n		<!-- /wp:spacer -->\n		\n		<!-- wp:heading {\"textAlign\":\"left\",\"level\":4,\"className\":\"hestia-title\",\"style\":{\"typography\":{\"fontSize\":18},\"color\":{\"text\":\"#3c4858\"}}} -->\n		<h4 class=\"has-text-align-left hestia-title has-text-color\" style=\"color:#3c4858;font-size:18px\"><img class=\"wp-image-98\" style=\"width: 25px;\" src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/contact2.png\" alt=\"\">  <strong><strong>Give us a ring</strong></strong></h4>\n		<!-- /wp:heading -->\n		\n		<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"color\":{\"text\":\"#999999\"},\"typography\":{\"fontSize\":14}}} -->\n		<p class=\"has-text-align-left has-text-color\" style=\"color:#999999;font-size:14px\">John Doe<br>+40 712 345 678<br>Mon - Fri, 8:00-22:00</p>\n		<!-- /wp:paragraph -->\n		\n		<!-- wp:spacer {\"height\":40} -->\n		<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n		<!-- /wp:spacer -->\n		\n		<!-- wp:heading {\"textAlign\":\"left\",\"level\":4,\"className\":\"hestia-title\",\"style\":{\"color\":{\"text\":\"#3c4858\"},\"typography\":{\"fontSize\":18}}} -->\n		<h4 class=\"has-text-align-left hestia-title has-text-color\" style=\"color:#3c4858;font-size:18px\"><img class=\"wp-image-105\" style=\"width: 25px;\" src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/contact3.png\" alt=\"\"><strong>  <strong>Legal information</strong></strong></h4>\n		<!-- /wp:heading -->\n		\n		<!-- wp:paragraph {\"align\":\"left\",\"style\":{\"color\":{\"text\":\"#999999\"},\"typography\":{\"fontSize\":14}}} -->\n		<p class=\"has-text-align-left has-text-color\" style=\"color:#999999;font-size:14px\">John Doe Co.<br>Fiscal Code: 12345678</p>\n		<!-- /wp:paragraph --></div>\n		<!-- /wp:column -->\n		\n		<!-- wp:column -->\n		<div class=\"wp-block-column\"></div>\n		<!-- /wp:column --></div>\n		<!-- /wp:columns --></div>\n		<!-- /wp:column --></div>\n		<!-- /wp:columns -->\n		\n		<!-- wp:paragraph -->\n		<p></p>\n		<!-- /wp:paragraph -->", "Contact", "", "inherit", "closed", "closed", "", "21-revision-v1", "", "", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "21", "https://mangoknow.com/?p=30", "0", "revision", "", "0");
INSERT INTO `wor4890_posts` VALUES("31", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "Blog", "", "inherit", "closed", "closed", "", "22-revision-v1", "", "", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "22", "https://mangoknow.com/?p=31", "0", "revision", "", "0");
INSERT INTO `wor4890_posts` VALUES("32", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "<!-- wp:paragraph -->\n					<p>Yet bed any for travelling assistance indulgence unpleasing. Not thoughts all exercise blessing. Indulgence way everything joy alteration boisterous the attachment. Party we years to order allow asked of. We so opinion friends me message as delight. Whole front do of plate heard oh ought. His defective nor convinced residence own. Connection has put impossible own apartments boisterous. At jointure ladyship an insisted so humanity he. Friendly bachelor entrance to on by.</p>\n					<!-- /wp:paragraph -->\n					\n					<!-- wp:paragraph -->\n					<p>That last is no more than a foot high, and about seven paces across, a mere flat top of a grey rock which smokes like a hot cinder after a shower, and where no man would care to venture a naked sole before sunset. On the Little Isabel an old ragged palm, with a thick bulging trunk rough with spines, a very witch amongst palm trees, rustles a dismal bunch of dead leaves above the<a href=\"#\"> coarse sand</a>.</p>\n					<!-- /wp:paragraph -->", "Appearance guide", "", "inherit", "closed", "closed", "", "23-revision-v1", "", "", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "23", "https://mangoknow.com/?p=32", "0", "revision", "", "0");
INSERT INTO `wor4890_posts` VALUES("33", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "<!-- wp:heading {\"level\":3,\"className\":\"title\"} -->\n					<h3 class=\"title\">Feet evil to hold long he open knew an no.</h3>\n					<!-- /wp:heading -->\n					\n					<!-- wp:paragraph -->\n					<p>Apartments occasional boisterous as solicitude to introduced. Or fifteen covered we enjoyed demesne is in prepare. In stimulated my everything it literature. Greatly explain attempt perhaps in feeling he. House men taste bed not drawn joy. Through enquire however do equally herself at. Greatly way old may you present improve. Wishing the feeling village him musical.</p>\n					<!-- /wp:paragraph -->\n					\n					<!-- wp:paragraph -->\n					<p>Smile spoke total few great had never their too. Amongst moments do in arrived at my replied. Fat weddings servants but man believed prospect. Companions understood is as especially pianoforte connection introduced. Nay newspaper can sportsman are admitting gentleman belonging his.</p>\n					<!-- /wp:paragraph -->", "Perfectly on furniture", "", "inherit", "closed", "closed", "", "24-revision-v1", "", "", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "24", "https://mangoknow.com/?p=33", "0", "revision", "", "0");
INSERT INTO `wor4890_posts` VALUES("34", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "<!-- wp:paragraph -->\n					<p><em>To shewing another demands sentiments. Marianne property cheerful informed at striking at. Clothes parlors however by cottage on. In views it or meant drift to. Be concern parlors settled or do shyness address.&nbsp;</em></p>\n					<!-- /wp:paragraph -->\n					\n					<!-- wp:heading -->\n					<h2>He always do do former he highly.</h2>\n					<!-- /wp:heading -->\n					\n					<!-- wp:paragraph -->\n					<p>Continual so distrusts pronounce by unwilling listening</p>\n					<!-- /wp:paragraph -->\n					\n					<!-- wp:paragraph -->\n					<p>Expenses as material breeding insisted building to in. Continual so distrusts pronounce by unwilling listening. Thing do taste on we manor. Him had wound use found hoped. Of distrusts immediate enjoyment curiosity do. Marianne numerous saw thoughts the humoured.</p>\n					<!-- /wp:paragraph -->", "Fat son how smiling natural", "", "inherit", "closed", "closed", "", "25-revision-v1", "", "", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "25", "https://mangoknow.com/?p=34", "0", "revision", "", "0");
INSERT INTO `wor4890_posts` VALUES("35", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "<!-- wp:heading -->\n					<h2>Way nor furnished sir procuring therefore but.</h2>\n					<!-- /wp:heading -->\n					\n					<!-- wp:paragraph -->\n					<p>Warmth far manner myself active are cannot called. Set her half end girl rich met. Me allowance departure an curiosity ye. In no talking address excited it conduct. Husbands debating replying overcame<em>&nbsp;blessing</em>&nbsp;he it me to domestic.</p>\n					<!-- /wp:paragraph -->\n					\n					<!-- wp:list -->\n					<ul><li>As absolute is by amounted repeated entirely ye returned.</li><li>These ready timed enjoy might sir yet one since.</li><li>Years drift never if could forty being no.</li></ul>\n					<!-- /wp:list -->", "Can curiosity may end shameless explained", "", "inherit", "closed", "closed", "", "26-revision-v1", "", "", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "26", "https://mangoknow.com/?p=35", "0", "revision", "", "0");
INSERT INTO `wor4890_posts` VALUES("36", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "<!-- wp:paragraph -->\n					<p>It acceptance thoroughly my advantages everything as. Are projecting inquietude affronting preference saw who. Marry of am do avoid ample as. Old disposal followed she ignorant desirous two has. Called played entire roused though for one too. He into walk roof made tall cold he. Feelings way likewise addition wandered contempt bed indulged.</p>\n					<!-- /wp:paragraph -->\n					\n					<!-- wp:heading {\"level\":4} -->\n					<h4><strong>Still court no small think death so an wrote.</strong></h4>\n					<!-- /wp:heading -->\n					\n					<!-- wp:paragraph -->\n					<p>Incommode necessary no it behaviour convinced distrusts an unfeeling he. Could death since do we hoped is in. Exquisite no my attention extensive. The determine conveying moonlight age. Avoid for see marry sorry child. Sitting so totally forbade hundred to.</p>\n					<!-- /wp:paragraph -->", "Improve him believe opinion offered", "", "inherit", "closed", "closed", "", "27-revision-v1", "", "", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "27", "https://mangoknow.com/?p=36", "0", "revision", "", "0");
INSERT INTO `wor4890_posts` VALUES("37", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", " ", "", "", "publish", "closed", "closed", "", "37", "", "", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "0", "https://mangoknow.com/index.php/2025/07/28/37/", "0", "nav_menu_item", "", "0");
INSERT INTO `wor4890_posts` VALUES("38", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", " ", "", "", "publish", "closed", "closed", "", "38", "", "", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "0", "https://mangoknow.com/index.php/2025/07/28/38/", "1", "nav_menu_item", "", "0");
INSERT INTO `wor4890_posts` VALUES("39", "1", "2025-07-28 17:21:43", "2025-07-28 17:21:43", " ", "", "", "publish", "closed", "closed", "", "39", "", "", "2025-07-28 17:21:43", "2025-07-28 17:21:43", "", "0", "https://mangoknow.com/index.php/2025/07/28/39/", "2", "nav_menu_item", "", "0");
INSERT INTO `wor4890_posts` VALUES("40", "1", "2025-07-29 18:10:20", "2025-07-28 17:21:43", "", "Contact", "", "publish", "closed", "closed", "", "more", "", "", "2025-07-29 18:10:20", "2025-07-29 18:10:20", "", "0", "https://mangoknow.com/index.php/2025/07/28/more/", "4", "nav_menu_item", "", "0");
INSERT INTO `wor4890_posts` VALUES("43", "1", "2025-07-29 17:26:24", "2025-07-29 17:26:24", "{\"id\":43,\"field_id\":5,\"fields\":{\"0\":{\"id\":\"0\",\"type\":\"name\",\"label\":\"Name\",\"format\":\"simple\",\"description\":\"\",\"required\":\"1\",\"size\":\"large\",\"simple_placeholder\":\"Your Name\",\"simple_default\":\"\",\"first_placeholder\":\"\",\"first_default\":\"\",\"middle_placeholder\":\"\",\"middle_default\":\"\",\"last_placeholder\":\"\",\"last_default\":\"\",\"label_hide\":\"1\",\"css\":\"wpforms-one-half wpforms-first\"},\"3\":{\"id\":\"3\",\"type\":\"email\",\"label\":\"Email\",\"description\":\"\",\"required\":\"1\",\"size\":\"large\",\"placeholder\":\"Your Email\",\"confirmation_placeholder\":\"\",\"label_hide\":\"1\",\"default_value\":\"\",\"css\":\"wpforms-one-half\"},\"4\":{\"id\":\"4\",\"type\":\"text\",\"label\":\"Subject\",\"description\":\"\",\"size\":\"large\",\"placeholder\":\"Subject\",\"label_hide\":\"1\",\"default_value\":\"\",\"css\":\"\",\"input_mask\":\"\"},\"2\":{\"id\":\"2\",\"type\":\"textarea\",\"label\":\"Message\",\"description\":\"\",\"required\":\"1\",\"size\":\"medium\",\"placeholder\":\"Your Message\",\"label_hide\":\"1\",\"css\":\"\"}},\"settings\":{\"form_title\":\"Hestia\",\"form_desc\":\"\",\"form_class\":\"\",\"submit_text\":\"Send message\",\"submit_text_processing\":\"Sending...\",\"submit_class\":\"\",\"notification_enable\":\"1\",\"notifications\":{\"1\":{\"email\":\"{admin_email}\",\"subject\":\"New Entry: Zerif\",\"sender_name\":\"{field_id=\\\"0\\\"}\",\"sender_address\":\"{admin_email}\",\"replyto\":\"{field_id=\\\"1\\\"}\",\"message\":\"{all_fields}\"}},\"confirmation_type\":\"message\",\"confirmation_message\":\"Thanks for contacting us! We will be in touch with you shortly.\",\"confirmation_message_scroll\":\"1\",\"confirmation_page\":\"9\",\"confirmation_redirect\":\"\",\"store_spam_entries\":\"0\"},\"meta\":{\"template\":\"contact\"}}", "Hestia", "", "publish", "closed", "closed", "", "hestia", "", "", "2025-07-29 17:26:24", "2025-07-29 17:26:24", "", "0", "https://mangoknow.com/?p=43", "0", "wpforms", "", "0");
INSERT INTO `wor4890_posts` VALUES("47", "1", "2025-07-29 17:38:33", "2025-07-29 17:38:33", "<!-- wp:cover {\"overlayColor\":\"white\",\"align\":\"full\",\"className\":\"hestia-clear-top-padding\"} -->\n<div class=\"wp-block-cover alignfull is-light hestia-clear-top-padding\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-white-background-color has-background-dim-100 has-background-dim\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"color\":{\"text\":\"#3c4858\"}}} -->\n<h2 class=\"wp-block-heading has-text-align-center has-text-color\" style=\"color:#3c4858\">About</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"40px\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"container\"} -->\n<div class=\"wp-block-columns container\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":70,\"width\":\"64px\",\"height\":\"auto\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"align\":\"center\"} -->\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><img src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/feat1.png\" alt=\"\" class=\"wp-image-70\" style=\"width:64px;height:auto\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":5,\"style\":{\"color\":{\"text\":\"#3c4858\"},\"typography\":{\"fontSize\":18}}} -->\n<h5 class=\"wp-block-heading has-text-align-center has-text-color\" style=\"color:#3c4858;font-size:18px\">Lesson Plans</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#999999\"},\"typography\":{\"fontSize\":14}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#999999;font-size:14px\">No-preparation plans that include reading, writing, listening and conversation on a wide range of topics.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"25px\"} -->\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":71,\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"align\":\"center\"} -->\n<figure class=\"wp-block-image aligncenter size-large\"><img src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/feat2.png\" alt=\"\" class=\"wp-image-71\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":5,\"style\":{\"color\":{\"text\":\"#3c4858\"},\"typography\":{\"fontSize\":18}}} -->\n<h5 class=\"wp-block-heading has-text-align-center has-text-color\" style=\"color:#3c4858;font-size:18px\">Conversation Topics</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#999999\"},\"typography\":{\"fontSize\":14}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#999999;font-size:14px\">Questions to promote discussion and fluency, for beginners, intermediate and advanced levels.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"25px\"} -->\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":72,\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"align\":\"center\"} -->\n<figure class=\"wp-block-image aligncenter size-large\"><img src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/feat3.png\" alt=\"\" class=\"wp-image-72\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":5,\"style\":{\"color\":{\"text\":\"#3c4858\"},\"typography\":{\"fontSize\":18}}} -->\n<h5 class=\"wp-block-heading has-text-align-center has-text-color\" style=\"color:#3c4858;font-size:18px\">Library</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#999999\"},\"typography\":{\"fontSize\":14}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#999999;font-size:14px\">Vocabulary, grammar, pronunciation, idioms and more.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"25px\"} -->\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"40px\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:columns {\"className\":\"container\"} -->\n<div class=\"wp-block-columns container\"><!-- wp:column {\"className\":\"col-md-5\"} -->\n<div class=\"wp-block-column col-md-5\"><!-- wp:spacer {\"height\":\"55px\"} -->\n<div style=\"height:55px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Sign up for our newsletter</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Stay up to date with the latest information.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"col-md-6 col-md-offset1\"} -->\n<div class=\"wp-block-column col-md-6 col-md-offset1\"><!-- wp:spacer {\"height\":\"55px\"} -->\n<div style=\"height:55px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":81,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/about-content.png\" alt=\"\" class=\"wp-image-81\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->", "Home", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2025-07-29 17:38:33", "2025-07-29 17:38:33", "", "20", "https://mangoknow.com/?p=47", "0", "revision", "", "0");
INSERT INTO `wor4890_posts` VALUES("52", "1", "2025-07-29 17:46:55", "2025-07-29 17:46:55", "", "abc-alphabet-blackboard-265076", "", "inherit", "open", "closed", "", "abc-alphabet-blackboard-265076", "", "", "2025-07-29 17:46:55", "2025-07-29 17:46:55", "", "0", "http://mangoknow.com/wp-content/uploads/2025/07/abc-alphabet-blackboard-265076.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wor4890_posts` VALUES("54", "1", "2025-07-29 17:50:02", "2025-07-29 17:50:02", "", "alphabet-class-conceptual-301926", "", "inherit", "open", "closed", "", "alphabet-class-conceptual-301926", "", "", "2025-07-29 17:50:02", "2025-07-29 17:50:02", "", "0", "http://mangoknow.com/wp-content/uploads/2025/07/alphabet-class-conceptual-301926.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wor4890_posts` VALUES("57", "1", "2025-07-29 17:58:20", "2025-07-29 17:58:20", "", "Mango Know Logo - Portrait 290x221", "", "inherit", "open", "closed", "", "mango-know-logo-portrait-290x221", "", "", "2025-07-29 17:58:20", "2025-07-29 17:58:20", "", "0", "http://mangoknow.com/wp-content/uploads/2025/07/Mango-Know-Logo-Portrait-290x221-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wor4890_posts` VALUES("58", "1", "2025-07-29 17:58:21", "2025-07-29 17:58:21", "", "Mango Know Logo - Landscape 430x160", "", "inherit", "open", "closed", "", "mango-know-logo-landscape-430x160", "", "", "2025-07-29 17:58:21", "2025-07-29 17:58:21", "", "0", "http://mangoknow.com/wp-content/uploads/2025/07/Mango-Know-Logo-Landscape-430x160-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wor4890_posts` VALUES("59", "1", "2025-07-29 17:58:22", "2025-07-29 17:58:22", "", "Mango Know Logo - Icon 512x512", "", "inherit", "open", "closed", "", "mango-know-logo-icon-512x512", "", "", "2025-07-29 17:58:22", "2025-07-29 17:58:22", "", "0", "http://mangoknow.com/wp-content/uploads/2025/07/Mango-Know-Logo-Icon-512x512-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wor4890_posts` VALUES("60", "1", "2025-07-29 17:58:22", "2025-07-29 17:58:22", "", "Mango Know Logo - Icon 160x160", "", "inherit", "open", "closed", "", "mango-know-logo-icon-160x160", "", "", "2025-07-29 17:58:22", "2025-07-29 17:58:22", "", "0", "http://mangoknow.com/wp-content/uploads/2025/07/Mango-Know-Logo-Icon-160x160-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wor4890_posts` VALUES("62", "1", "2025-07-29 18:01:09", "2025-07-29 18:01:09", "<!-- wp:spacer {\"height\":\"40px\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:cover {\"overlayColor\":\"white\",\"isUserOverlayColor\":true,\"align\":\"full\",\"className\":\"is-light hestia-clear-top-padding\"} -->\n<div class=\"wp-block-cover alignfull is-light hestia-clear-top-padding\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-white-background-color has-background-dim-100 has-background-dim\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"color\":{\"text\":\"#3c4858\"}}} -->\n<h2 class=\"wp-block-heading has-text-align-center has-text-color\" style=\"color:#3c4858\">About</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"40px\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"container\"} -->\n<div class=\"wp-block-columns container\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":70,\"width\":\"64px\",\"height\":\"auto\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"align\":\"center\"} -->\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><img src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/feat1.png\" alt=\"\" class=\"wp-image-70\" style=\"width:64px;height:auto\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":5,\"style\":{\"color\":{\"text\":\"#3c4858\"},\"typography\":{\"fontSize\":18}}} -->\n<h5 class=\"wp-block-heading has-text-align-center has-text-color\" style=\"color:#3c4858;font-size:18px\">Lesson Plans</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#999999\"},\"typography\":{\"fontSize\":14}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#999999;font-size:14px\">No-preparation plans that include reading, writing, listening and conversation on a wide range of topics.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"25px\"} -->\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":71,\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"align\":\"center\"} -->\n<figure class=\"wp-block-image aligncenter size-large\"><img src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/feat2.png\" alt=\"\" class=\"wp-image-71\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":5,\"style\":{\"color\":{\"text\":\"#3c4858\"},\"typography\":{\"fontSize\":18}}} -->\n<h5 class=\"wp-block-heading has-text-align-center has-text-color\" style=\"color:#3c4858;font-size:18px\">Conversation Topics</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#999999\"},\"typography\":{\"fontSize\":14}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#999999;font-size:14px\">Questions to promote discussion and fluency, for beginners, intermediate and advanced levels.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"25px\"} -->\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":72,\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"align\":\"center\"} -->\n<figure class=\"wp-block-image aligncenter size-large\"><img src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/feat3.png\" alt=\"\" class=\"wp-image-72\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":5,\"style\":{\"color\":{\"text\":\"#3c4858\"},\"typography\":{\"fontSize\":18}}} -->\n<h5 class=\"wp-block-heading has-text-align-center has-text-color\" style=\"color:#3c4858;font-size:18px\">Library</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#999999\"},\"typography\":{\"fontSize\":14}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#999999;font-size:14px\">Vocabulary, grammar, pronunciation, idioms and more.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"25px\"} -->\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"40px\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:columns {\"className\":\"container\"} -->\n<div class=\"wp-block-columns container\"><!-- wp:column {\"className\":\"col-md-5\"} -->\n<div class=\"wp-block-column col-md-5\"><!-- wp:spacer {\"height\":\"55px\"} -->\n<div style=\"height:55px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Sign up for our newsletter</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Stay up to date with the latest information.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"col-md-6 col-md-offset1\"} -->\n<div class=\"wp-block-column col-md-6 col-md-offset1\"><!-- wp:spacer {\"height\":\"55px\"} -->\n<div style=\"height:55px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":81,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/about-content.png\" alt=\"\" class=\"wp-image-81\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->", "Home", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2025-07-29 18:01:09", "2025-07-29 18:01:09", "", "20", "https://mangoknow.com/?p=62", "0", "revision", "", "0");
INSERT INTO `wor4890_posts` VALUES("63", "1", "2025-07-29 18:02:05", "2025-07-29 18:02:05", "<!-- wp:cover {\"overlayColor\":\"white\",\"isUserOverlayColor\":true,\"align\":\"full\",\"className\":\"is-light hestia-clear-top-padding\"} -->\n<div class=\"wp-block-cover alignfull is-light hestia-clear-top-padding\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-white-background-color has-background-dim-100 has-background-dim\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:spacer {\"height\":\"40px\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"color\":{\"text\":\"#3c4858\"}}} -->\n<h2 class=\"wp-block-heading has-text-align-center has-text-color\" style=\"color:#3c4858\">About</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"40px\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"container\"} -->\n<div class=\"wp-block-columns container\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":70,\"width\":\"64px\",\"height\":\"auto\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"align\":\"center\"} -->\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><img src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/feat1.png\" alt=\"\" class=\"wp-image-70\" style=\"width:64px;height:auto\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":5,\"style\":{\"color\":{\"text\":\"#3c4858\"},\"typography\":{\"fontSize\":18}}} -->\n<h5 class=\"wp-block-heading has-text-align-center has-text-color\" style=\"color:#3c4858;font-size:18px\">Lesson Plans</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#999999\"},\"typography\":{\"fontSize\":14}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#999999;font-size:14px\">No-preparation plans that include reading, writing, listening and conversation on a wide range of topics.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"25px\"} -->\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":71,\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"align\":\"center\"} -->\n<figure class=\"wp-block-image aligncenter size-large\"><img src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/feat2.png\" alt=\"\" class=\"wp-image-71\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":5,\"style\":{\"color\":{\"text\":\"#3c4858\"},\"typography\":{\"fontSize\":18}}} -->\n<h5 class=\"wp-block-heading has-text-align-center has-text-color\" style=\"color:#3c4858;font-size:18px\">Conversation Topics</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#999999\"},\"typography\":{\"fontSize\":14}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#999999;font-size:14px\">Questions to promote discussion and fluency, for beginners, intermediate and advanced levels.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"25px\"} -->\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":72,\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"align\":\"center\"} -->\n<figure class=\"wp-block-image aligncenter size-large\"><img src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/feat3.png\" alt=\"\" class=\"wp-image-72\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":5,\"style\":{\"color\":{\"text\":\"#3c4858\"},\"typography\":{\"fontSize\":18}}} -->\n<h5 class=\"wp-block-heading has-text-align-center has-text-color\" style=\"color:#3c4858;font-size:18px\">Library</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#999999\"},\"typography\":{\"fontSize\":14}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#999999;font-size:14px\">Vocabulary, grammar, pronunciation, idioms and more.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"25px\"} -->\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"40px\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:columns {\"className\":\"container\"} -->\n<div class=\"wp-block-columns container\"><!-- wp:column {\"className\":\"col-md-5\"} -->\n<div class=\"wp-block-column col-md-5\"><!-- wp:spacer {\"height\":\"55px\"} -->\n<div style=\"height:55px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Sign up for our newsletter</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Stay up to date with the latest information.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"col-md-6 col-md-offset1\"} -->\n<div class=\"wp-block-column col-md-6 col-md-offset1\"><!-- wp:spacer {\"height\":\"55px\"} -->\n<div style=\"height:55px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":81,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/about-content.png\" alt=\"\" class=\"wp-image-81\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph -->", "Home", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2025-07-29 18:02:05", "2025-07-29 18:02:05", "", "20", "https://mangoknow.com/?p=63", "0", "revision", "", "0");
INSERT INTO `wor4890_posts` VALUES("66", "1", "2025-07-29 22:08:52", "2025-07-29 22:08:52", "<!-- wp:cover {\"overlayColor\":\"white\",\"isUserOverlayColor\":true,\"align\":\"full\",\"className\":\"is-light hestia-clear-top-padding\"} -->\n<div class=\"wp-block-cover alignfull is-light hestia-clear-top-padding\"><span aria-hidden=\"true\" class=\"wp-block-cover__background has-white-background-color has-background-dim-100 has-background-dim\"></span><div class=\"wp-block-cover__inner-container\"><!-- wp:spacer {\"height\":\"40px\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"style\":{\"color\":{\"text\":\"#3c4858\"}}} -->\n<h2 class=\"wp-block-heading has-text-align-center has-text-color\" style=\"color:#3c4858\">About</h2>\n<!-- /wp:heading -->\n\n<!-- wp:spacer {\"height\":\"40px\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:columns {\"className\":\"container\"} -->\n<div class=\"wp-block-columns container\"><!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":70,\"width\":\"64px\",\"height\":\"auto\",\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"align\":\"center\"} -->\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><img src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/feat1.png\" alt=\"\" class=\"wp-image-70\" style=\"width:64px;height:auto\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":5,\"style\":{\"color\":{\"text\":\"#3c4858\"},\"typography\":{\"fontSize\":18}}} -->\n<h5 class=\"wp-block-heading has-text-align-center has-text-color\" style=\"color:#3c4858;font-size:18px\">Lesson Plans</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#999999\"},\"typography\":{\"fontSize\":14}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#999999;font-size:14px\">No-preparation plans that include reading, writing, listening and conversation on a wide range of topics.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"25px\"} -->\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":71,\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"align\":\"center\"} -->\n<figure class=\"wp-block-image aligncenter size-large\"><img src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/feat2.png\" alt=\"\" class=\"wp-image-71\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":5,\"style\":{\"color\":{\"text\":\"#3c4858\"},\"typography\":{\"fontSize\":18}}} -->\n<h5 class=\"wp-block-heading has-text-align-center has-text-color\" style=\"color:#3c4858;font-size:18px\">Conversation Topics</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#999999\"},\"typography\":{\"fontSize\":14}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#999999;font-size:14px\">Questions to promote discussion and fluency, for beginners, intermediate and advanced levels.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"25px\"} -->\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column -->\n\n<!-- wp:column -->\n<div class=\"wp-block-column\"><!-- wp:image {\"id\":72,\"sizeSlug\":\"large\",\"linkDestination\":\"none\",\"align\":\"center\"} -->\n<figure class=\"wp-block-image aligncenter size-large\"><img src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/feat3.png\" alt=\"\" class=\"wp-image-72\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:heading {\"textAlign\":\"center\",\"level\":5,\"style\":{\"color\":{\"text\":\"#3c4858\"},\"typography\":{\"fontSize\":18}}} -->\n<h5 class=\"wp-block-heading has-text-align-center has-text-color\" style=\"color:#3c4858;font-size:18px\">Library</h5>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph {\"align\":\"center\",\"style\":{\"color\":{\"text\":\"#999999\"},\"typography\":{\"fontSize\":14}}} -->\n<p class=\"has-text-align-center has-text-color\" style=\"color:#999999;font-size:14px\">Vocabulary, grammar, pronunciation, idioms and more.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:spacer {\"height\":\"25px\"} -->\n<div style=\"height:25px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:spacer {\"height\":\"40px\"} -->\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer --></div></div>\n<!-- /wp:cover -->\n\n<!-- wp:columns {\"className\":\"container\"} -->\n<div class=\"wp-block-columns container\"><!-- wp:column {\"className\":\"col-md-5\"} -->\n<div class=\"wp-block-column col-md-5\"><!-- wp:spacer {\"height\":\"55px\"} -->\n<div style=\"height:55px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Sign up for our newsletter</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Stay up to date with the latest information.</p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column -->\n\n<!-- wp:column {\"className\":\"col-md-6 col-md-offset1\"} -->\n<div class=\"wp-block-column col-md-6 col-md-offset1\"><!-- wp:spacer {\"height\":\"55px\"} -->\n<div style=\"height:55px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n<!-- /wp:spacer -->\n\n<!-- wp:image {\"id\":81,\"sizeSlug\":\"large\",\"linkDestination\":\"none\"} -->\n<figure class=\"wp-block-image size-large\"><img src=\"https://mangoknow.com/wp-content/themes/hestia/assets/img/about-content.png\" alt=\"\" class=\"wp-image-81\"/></figure>\n<!-- /wp:image -->\n\n<!-- wp:paragraph -->\n<p></p>\n<!-- /wp:paragraph --></div>\n<!-- /wp:column --></div>\n<!-- /wp:columns -->\n\n<!-- wp:code -->\n<pre class=\"wp-block-code\"><code>&lt;div class=\"hestia-info info info-horizontal\">\n&lt;div class=\"icon icon-primary\">&lt;i class=\"fas fa-map-marker-alt\">&lt;/i>&lt;/div>\n&lt;div class=\"description\">\n&lt;h4 class=\"info-title\">Find us at the office&lt;/h4>\nStrada Povernei, nr 20, Bucharest, Romania&lt;/div>\n&lt;/div>\n&lt;div class=\"hestia-info info info-horizontal\">\n&lt;div class=\"icon icon-primary\">&lt;i class=\"fas fa-mobile-alt\">&lt;/i>&lt;/div>\n&lt;div class=\"description\">\n&lt;h4 class=\"info-title\">Give us a ring&lt;/h4>\nJohn Doe +40 712 345 678 Mon – Fri, 8:00-22:00&lt;/div>\n&lt;/div></code></pre>\n<!-- /wp:code -->", "Home", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2025-07-29 22:08:52", "2025-07-29 22:08:52", "", "20", "https://mangoknow.com/?p=66", "0", "revision", "", "0");
INSERT INTO `wor4890_posts` VALUES("68", "1", "2025-10-10 13:06:30", "0000-00-00 00:00:00", "", "Auto Draft", "", "auto-draft", "open", "open", "", "", "", "", "2025-10-10 13:06:30", "0000-00-00 00:00:00", "", "0", "https://mangoknow.com/?p=68", "0", "post", "", "0");

/* INSERT TABLE DATA: wor4890_term_relationships */
INSERT INTO `wor4890_term_relationships` VALUES("1", "1", "0");
INSERT INTO `wor4890_term_relationships` VALUES("10", "2", "0");
INSERT INTO `wor4890_term_relationships` VALUES("23", "1", "0");
INSERT INTO `wor4890_term_relationships` VALUES("24", "1", "0");
INSERT INTO `wor4890_term_relationships` VALUES("25", "1", "0");
INSERT INTO `wor4890_term_relationships` VALUES("26", "1", "0");
INSERT INTO `wor4890_term_relationships` VALUES("27", "1", "0");
INSERT INTO `wor4890_term_relationships` VALUES("37", "3", "0");
INSERT INTO `wor4890_term_relationships` VALUES("38", "3", "0");
INSERT INTO `wor4890_term_relationships` VALUES("39", "3", "0");
INSERT INTO `wor4890_term_relationships` VALUES("40", "3", "0");

/* INSERT TABLE DATA: wor4890_term_taxonomy */
INSERT INTO `wor4890_term_taxonomy` VALUES("1", "1", "category", "", "0", "6");
INSERT INTO `wor4890_term_taxonomy` VALUES("2", "2", "wp_theme", "", "0", "1");
INSERT INTO `wor4890_term_taxonomy` VALUES("3", "3", "nav_menu", "", "0", "4");
INSERT INTO `wor4890_term_taxonomy` VALUES("4", "4", "category", "", "5", "0");
INSERT INTO `wor4890_term_taxonomy` VALUES("5", "5", "category", "", "0", "0");
INSERT INTO `wor4890_term_taxonomy` VALUES("6", "6", "category", "", "5", "0");
INSERT INTO `wor4890_term_taxonomy` VALUES("7", "7", "category", "", "5", "0");
INSERT INTO `wor4890_term_taxonomy` VALUES("9", "9", "category", "", "0", "0");
INSERT INTO `wor4890_term_taxonomy` VALUES("10", "10", "category", "", "0", "0");
INSERT INTO `wor4890_term_taxonomy` VALUES("11", "11", "category", "No-prep classes.", "10", "0");
INSERT INTO `wor4890_term_taxonomy` VALUES("12", "12", "category", "", "10", "0");
INSERT INTO `wor4890_term_taxonomy` VALUES("13", "13", "category", "", "10", "0");
INSERT INTO `wor4890_term_taxonomy` VALUES("14", "14", "category", "", "10", "0");
INSERT INTO `wor4890_term_taxonomy` VALUES("15", "15", "category", "Based on authentic videos &amp; news articles.", "10", "0");

/* INSERT TABLE DATA: wor4890_terms */
INSERT INTO `wor4890_terms` VALUES("1", "Uncategorized", "uncategorized", "0");
INSERT INTO `wor4890_terms` VALUES("2", "twentytwentyfive", "twentytwentyfive", "0");
INSERT INTO `wor4890_terms` VALUES("3", "Primary Menu", "primary-menu", "0");
INSERT INTO `wor4890_terms` VALUES("4", "Vocabulary", "vocabulary", "0");
INSERT INTO `wor4890_terms` VALUES("5", "Library", "library", "0");
INSERT INTO `wor4890_terms` VALUES("6", "Grammar", "grammar", "0");
INSERT INTO `wor4890_terms` VALUES("7", "Pronunciation", "pronunciation", "0");
INSERT INTO `wor4890_terms` VALUES("9", "Conversation Questions", "conversation-questions", "0");
INSERT INTO `wor4890_terms` VALUES("10", "Lesson Vault", "lesson-vault", "0");
INSERT INTO `wor4890_terms` VALUES("11", "Standalone Lessons", "standalone-lessons", "0");
INSERT INTO `wor4890_terms` VALUES("12", "In 15 Minutes", "in-15-minutes", "0");
INSERT INTO `wor4890_terms` VALUES("13", "Course Bundles", "course-bundles", "0");
INSERT INTO `wor4890_terms` VALUES("14", "Worksheets", "worksheets", "0");
INSERT INTO `wor4890_terms` VALUES("15", "Media-Based Materials", "media-based-materials", "0");

/* INSERT TABLE DATA: wor4890_usermeta */
INSERT INTO `wor4890_usermeta` VALUES("1", "1", "nickname", "M4ngoKn0w");
INSERT INTO `wor4890_usermeta` VALUES("2", "1", "first_name", "");
INSERT INTO `wor4890_usermeta` VALUES("3", "1", "last_name", "");
INSERT INTO `wor4890_usermeta` VALUES("4", "1", "description", "");
INSERT INTO `wor4890_usermeta` VALUES("5", "1", "rich_editing", "true");
INSERT INTO `wor4890_usermeta` VALUES("6", "1", "syntax_highlighting", "true");
INSERT INTO `wor4890_usermeta` VALUES("7", "1", "comment_shortcuts", "false");
INSERT INTO `wor4890_usermeta` VALUES("8", "1", "admin_color", "fresh");
INSERT INTO `wor4890_usermeta` VALUES("9", "1", "use_ssl", "0");
INSERT INTO `wor4890_usermeta` VALUES("10", "1", "show_admin_bar_front", "true");
INSERT INTO `wor4890_usermeta` VALUES("11", "1", "locale", "");
INSERT INTO `wor4890_usermeta` VALUES("12", "1", "wor4890_capabilities", "a:1:{s:13:\"administrator\";b:1;}");
INSERT INTO `wor4890_usermeta` VALUES("13", "1", "wor4890_user_level", "10");
INSERT INTO `wor4890_usermeta` VALUES("14", "1", "dismissed_wp_pointers", "theme_editor_notice");
INSERT INTO `wor4890_usermeta` VALUES("15", "1", "show_welcome_panel", "0");
INSERT INTO `wor4890_usermeta` VALUES("16", "1", "session_tokens", "a:1:{s:64:\"811a0cfb7fe9ff026292932344012dd7858283b36fc863a864de0698bd7c1137\";a:4:{s:10:\"expiration\";i:1761311181;s:2:\"ip\";s:14:\"190.114.41.211\";s:2:\"ua\";s:80:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:143.0) Gecko/20100101 Firefox/143.0\";s:5:\"login\";i:1760101581;}}");
INSERT INTO `wor4890_usermeta` VALUES("17", "1", "wor4890_dashboard_quick_press_last_post_id", "68");
INSERT INTO `wor4890_usermeta` VALUES("18", "1", "community-events-location", "a:1:{s:2:\"ip\";s:12:\"190.114.41.0\";}");
INSERT INTO `wor4890_usermeta` VALUES("19", "1", "seedprod_personalization_preferences", "{\"show_templatetag_settings\":true,\"show_woocommerce_templatetag_settings\":true,\"show_edd_templatetag_settings\":true,\"show_entry_settings\":true,\"show_entry_settings_2\":true,\"show_entry_settings_4\":true,\"show_entry_settings_5\":true,\"show_entry_settings_3\":false,\"show_entry_settings_6\":true,\"show_layoutnav\":false}");
INSERT INTO `wor4890_usermeta` VALUES("20", "1", "default_password_nag", "");
INSERT INTO `wor4890_usermeta` VALUES("21", "1", "wfls-last-login", "1760101581");
INSERT INTO `wor4890_usermeta` VALUES("22", "1", "wor4890_persisted_preferences", "a:3:{s:4:\"core\";a:2:{s:26:\"isComplementaryAreaVisible\";b:1;s:10:\"openPanels\";a:2:{i:0;s:11:\"post-status\";i:1;s:23:\"taxonomy-panel-category\";}}s:9:\"_modified\";s:24:\"2025-07-30T17:41:00.340Z\";s:14:\"core/edit-post\";a:1:{s:12:\"welcomeGuide\";b:0;}}");
INSERT INTO `wor4890_usermeta` VALUES("23", "1", "obfx_ignore_visit_dashboard_notice", "true");
INSERT INTO `wor4890_usermeta` VALUES("24", "1", "wor4890_user-settings", "editor=html&libraryContent=browse");
INSERT INTO `wor4890_usermeta` VALUES("25", "1", "wor4890_user-settings-time", "1753811602");
INSERT INTO `wor4890_usermeta` VALUES("26", "1", "fbv_folder_startup", "0");
INSERT INTO `wor4890_usermeta` VALUES("27", "1", "closedpostboxes_dashboard", "a:0:{}");
INSERT INTO `wor4890_usermeta` VALUES("28", "1", "metaboxhidden_dashboard", "a:3:{i:0;s:19:\"dashboard_right_now\";i:1;s:9:\"themeisle\";i:2;s:17:\"dashboard_primary\";}");
INSERT INTO `wor4890_usermeta` VALUES("29", "1", "meta-box-order_dashboard", "a:4:{s:6:\"normal\";s:109:\"wpforms_reports_widget_lite,dashboard_right_now,dashboard_activity,wordfence_activity_report_widget,themeisle\";s:4:\"side\";s:39:\"dashboard_quick_press,dashboard_primary\";s:7:\"column3\";s:21:\"dashboard_site_health\";s:7:\"column4\";s:0:\"\";}");

/* INSERT TABLE DATA: wor4890_users */
INSERT INTO `wor4890_users` VALUES("1", "M4ngoKn0w", "$wp$2y$12$NOaqYwSPVxWyE6MlrWMUZO2ybSHYBzXrh1WuZLQNeFr1BpFnQooDi", "m4ngokn0w", "catfleetdesign@gmail.com", "http://mangoknow.com", "2025-03-25 23:50:31", "", "0", "M4ngoKn0w");

/* INSERT TABLE DATA: wor4890_wfblockediplog */
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0_", "CN", "1", "20345", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0G", "DE", "2", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0%", "US", "2", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0Y", "IN", "2", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0Y", "IN", "1", "20359", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0", "CN", "1", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0", "CN", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0J3", "CN", "1", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0J3", "CN", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0Ա", "HK", "1", "20355", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0\r\0", "IN", "2", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0\r\0", "IN", "1", "20347", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0\r=", "IN", "1", "20347", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0L-", "HK", "1", "20345", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0", "VN", "2", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0", "SG", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0}W", "BR", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0", "US", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0", "US", "1", "20347", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0\'", "KR", "1", "20356", "waf");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0̤~", "IN", "2", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0̤~", "IN", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0̤~", "IN", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0jsp", "HK", "1", "20358", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0jsp", "HK", "1", "20359", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0\"]B", "IN", "2", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0\"@", "US", "1", "20361", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0#J", "US", "2", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0#J", "US", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0%<c", "DE", "1", "20360", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0\'3=0", "PK", "1", "20370", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0({ŝ", "AE", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0*`", "VN", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0-7ܫ", "US", "3", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0-=P", "US", "1", "20342", "waf");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0-0", "PL", "1", "20363", "waf");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0-", "RU", "1", "20358", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0-bF", "NL", "1", "20366", "waf");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0.eS", "GB", "1", "20344", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0.L", "IR", "1", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0.L", "IR", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0.L2", "IR", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0/", "SG", "1", "20345", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\02S", "US", "2", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\02#", "DE", "1", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\02#", "DE", "1", "20347", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\02", "US", "1", "20347", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\02\Z", "US", "1", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\02>", "US", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\02W6", "US", "1", "20343", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\03Y;", "GB", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\03Y;", "GB", "1", "20361", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\03[g", "FR", "1", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\03o", "CA", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\03Q", "FR", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\04a]", "SG", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0;n/", "CN", "1", "20347", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0;n/", "CN", "1", "20349", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0;n/", "CN", "1", "20361", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0;}", "TW", "1", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0?&", "US", "2", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0Am\Z", "FI", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0C", "US", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0C*\n", "US", "2", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0E", "US", "1", "20343", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0E", "US", "2", "20344", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0H!", "US", "1", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0M^a", "DE", "1", "20360", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0MDL", "GB", "2", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0MDL", "GB", "1", "20358", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0Nn", "HU", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0Nny", "IR", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0Nh}", "FR", "1", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0P0K", "PL", "1", "20345", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0QX4 ", "IT", "1", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0QX5a", "IT", "1", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0QX5a", "IT", "1", "20344", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0R", "IN", "1", "20349", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0R", "IN", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0RFJ", "ES", "1", "20344", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0S;c", "GR", "1", "20349", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0T5", "SG", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0T", "SG", "1", "20362", "waf");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0Va", "GB", "1", "20345", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0V0", "US", "1", "20349", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0Y-SY", "RO", "2", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0Y-SY", "RO", "2", "20344", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0Y.k", "IT", "2", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0Y.k", "IT", "1", "20343", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0YH,", "ES", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0Y ", "DE", "1", "20345", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0Z4", "RU", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0[y", "FR", "1", "20362", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0[", "FR", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0[ռ", "RO", "1", "20345", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0]Q", "RU", "2", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0]Q", "RU", "2", "20344", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0]Y", "TR", "1", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0^", "CN", "1", "20361", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0g=", "MY", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0g=", "MY", "2", "20344", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0g$r", "VN", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0g&", "ID", "2", "20363", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0g*:c", "VN", "1", "20361", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0gHc", "VN", "1", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0gHc", "VN", "1", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0gHc", "VN", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0gJ{", "VN", "3", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0gJ{", "VN", "2", "20344", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0gMK", "ID", "1", "20349", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0gZ\r", "VN", "2", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0gZ\r", "VN", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0g\\U", "BD", "1", "20362", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0gnT(", "VN", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0g", "AU", "1", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0g", "AU", "1", "20347", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0g", "IN", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0g", "IN", "1", "20344", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0g", "IN", "2", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0g", "IN", "1", "20361", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0gc", "VN", "1", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0g+", "VN", "1", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0gJ", "BD", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0g", "BD", "1", "20366", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0gZ", "VN", "3", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0g", "VN", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0g", "IN", "11", "20355", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0gz", "VN", "1", "20345", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0hS", "US", "1", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0hS", "US", "1", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0h", "SG", "2", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0h", "SG", "1", "20349", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0h", "SG", "1", "20360", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0n-", "MY", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0oo", "CN", "1", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0oo", "CN", "1", "20345", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0oo", "CN", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0q", "VN", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0r.", "JP", "1", "20364", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0t:K", "PK", "1", "20363", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0tN", "CN", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0tN", "CN", "1", "20343", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0xL", "CN", "2", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0zlj", "PH", "8", "20366", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0z", "PH", "1", "20352", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0{", "HK", "1", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0Z\r", "DE", "8", "20353", "waf");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0\0", "US", "1", "20343", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0jz", "SG", "1", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0}BP", "FR", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0ɴ", "US", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0;", "SG", "1", "20347", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0w", "CN", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0SG", "JP", "1", "20361", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0]n", "DE", "2", "20366", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\07o", "US", "1", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\07o", "US", "2", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0]", "DE", "1", "20345", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0~", "FR", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0", "US", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0/6", "SE", "1", "20345", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0", "DE", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0", "SG", "1", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0", "SG", "2", "20344", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0t", "DE", "4", "20344", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0A", "IN", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0Ae", "US", "1", "20347", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0K", "CN", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0˵J", "US", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\09", "SG", "1", "20347", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\02", "BD", "2", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0", "BD", "2", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0\0$", "US", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\07", "DE", "1", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0yg", "US", "1", "20349", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0֒", "US", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0֟<", "US", "1", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0Њ", "US", "1", "20349", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0W", "US", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0W", "US", "1", "20344", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0cG", "US", "1", "20343", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0", "US", "1", "20358", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0>	", "US", "1", "20345", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0", "SG", "1", "20345", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0ٌ", "IN", "1", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0", "DE", "2", "20344", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0", "US", "2", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0<", "US", "1", "20345", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0<", "US", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0Vk>", "FR", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0I", "VN", "1", "20360", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0;", "FR", "1", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0-", "US", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0-", "US", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0-", "US", "1", "20359", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\08&", "US", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0	y", "DE", "2", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0 w", "FR", "1", "20349", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0e", "GB", "2", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0l", "IR", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0(&", "CN", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0\\n7", "CN", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0)", "PL", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\07", "FR", "2", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0O", "IR", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0", "US", "2", "20344", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0s[", "IR", "2", "20344", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0s[", "IR", "2", "20360", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0)", "IR", "1", "20343", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0sX", "BR", "1", "20347", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0", "ES", "1", "20345", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0", "NL", "1", "20349", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\06", "CL", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0jQ", "AR", "1", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0jQ", "AR", "1", "20361", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0", "CL", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0㸂", "US", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0\r", "US", "1", "20347", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0&", "PT", "2", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0¤", "GB", "2", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0ÚH", "FR", "2", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0ÚH", "FR", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0", "DE", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0&\\", "GB", "2", "20344", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0,", "CA", "3", "20347", "waf");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0(O", "UY", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0˟", "TH", "2", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0.", "AU", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0.", "AU", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0c", "VN", "1", "20345", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0m)", "US", "3", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0&", "DE", "1", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0э!", "US", "1", "20357", "waf");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0Ѭ2", "US", "2", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0Ѷ5", "US", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0b", "US", "1", "20358", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0", "ES", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0Ո]", "FR", "3", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0Ո]", "FR", "2", "20344", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0ի׹", "GB", "1", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0I", "US", "1", "20351", "waf");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0ك\r", "TR", "1", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0ك\r", "TR", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0٠=", "ES", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0٠", "FR", "1", "20366", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("\0\0\0\0\0\0\0\0\0\0Qײ", "KR", "4", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES(" \n\0 APV", "DE", "2", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES(" \n\0 APV", "DE", "1", "20361", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES(" `\0", "FR", "1", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES(" `\0", "FR", "1", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES(" `\0", "FR", "1", "20361", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES(" P-T\0n", "NL", "1", "20345", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES(" \0\0\0\0\0\0\0\0\0", "RU", "2", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES(" \0\0\0\0\0\0\0\0\0", "RU", "2", "20343", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES(" \0\0\0\0\0\0\0\0\0", "RU", "1", "20366", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES(" AB{\0\0\0\0\0\0\0", "FR", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES(" AF\0\0\0\0\0\0\0\0", "FR", "1", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES(" AF\0\0\0\0\0\0\0\0", "FR", "1", "20345", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES(" AF\0\0\0\0\0\0\0\0", "FR", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES(" AF\0\0\0\0\0\0\0\0", "FR", "1", "20355", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES(" A\0\0\0\0\0\0\0", "FR", "1", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES(" A\0\0\0\0\0\0\0", "FR", "1", "20363", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES(" A\0\0\0\0\0\0\0", "FR", "1", "20361", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES(" A\0\0\0\0\0\0\0", "FR", "1", "20358", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES(" A\0\0\0\0\0\0\0`", "DE", "1", "20347", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES(" A\0\0\0\0\0\0\0\0", "FR", "2", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES(" A\0\0\0\0\0\0\0\0", "FR", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES(" DU(\0<#h7$", "PH", "1", "20370", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES(" k,\0\0\0\0\0\0k,", "DE", "1", "20364", "waf");
INSERT INTO `wor4890_wfblockediplog` VALUES("$\0a\0\0\0\0\0\0	", "IN", "1", "20358", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("$\0a\0\0\0\0\0\0@", "IN", "1", "20363", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("$\0a\0\0\0\0\0\0@", "IN", "2", "20367", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("$\0n\0\0H\0\0\0\0\0\0", "VN", "2", "20343", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("$\0n\0\0H\0\0\0\0\0\0", "VN", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("$\0\0\0\0\0<T", "SG", "1", "20359", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("$\0\0\0\0\0\0\0\0\09", "SG", "2", "20343", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("$\0\0\0\0\0\0\0\0\09", "SG", "1", "20360", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("$\0>x\0", "VN", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("$\0>x\0", "VN", "1", "20349", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("$\0\0\0\0\0m\0\n", "SG", "1", "20366", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("$0\0\0\0f$.;", "VN", "2", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("$0\0\0\0f$.;", "VN", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("$0\0\0\0f$.;", "VN", "1", "20361", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("$\0\0\0\0\0\0\0\0\0|", "VN", "2", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("$\0\0\0\0\0\0\0\0\0|", "VN", "2", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("$\0\0\0\0\0\0\0\0\0|", "VN", "1", "20345", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("$\Z\0p", "SG", "2", "20347", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("$\r\0jHf", "SG", "4", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("$6@!#w`\0\0\0\0\0\0\0", "SG", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("$6@!#w`\0\0\0\0\0\0\0", "SG", "1", "20362", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("$@1_\ZsX", "CN", "2", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("&\0\00\0\0\0\0\0\0\0", "US", "1", "20347", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("&\0\00\0\0\0\0\0\0\0", "US", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("&\0\0O;\0\0\0\0\0\0\0F", "US", "1", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("&\0\0O;\0\0\0\0\0\0\0F", "US", "2", "20343", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("&\0qg\0Qrr", "US", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("&\0qg\0Qrr", "US", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("&\0qg\0Qrr", "US", "1", "20363", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("&\0<\0\0\0\0<(x", "US", "1", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("&\0<\0\0\0\0<(x", "US", "2", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("&\0<\0\0\0\0<(x", "US", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("&\0@@T\0P^Nv", "US", "10", "20358", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("&\0a\0\0\0\0\0\0\0\0", "US", "1", "20345", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("&\0a\0\0\0\0\0\0\0\0", "US", "1", "20362", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("&\0\0\0\0\0\0", "US", "2", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("&\0\0\0\0\04^P", "US", "1", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("&\0\0\0\0\04^P", "US", "2", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("&\0\0\0\0\0\0\r0\0", "US", "1", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("&\0\0\0\0\0\0\r0\0", "US", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("&\0\0\0\0\0\0\r0\0", "US", "1", "20361", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("&\0\0\0\0\0\0\r0\0", "US", "1", "20363", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("&\0\0\0\0\0R\0", "US", "3", "20362", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("&\0\0\0\0\0\0", "US", "4", "20366", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("&\0`\0\0\0\0\0\0\0\0^", "CA", "1", "20347", "waf");
INSERT INTO `wor4890_wfblockediplog` VALUES("&0\0\0\0\0,0y", "US", "1", "20359", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("&0\0\0\0\0,0y", "US", "1", "20361", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("(LKeɏ糋", "BR", "13", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0z`\0\0u \0\0\0\0\0\0\0", "UA", "1", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0ր\0 \0P\0\0\0\0\0\02", "GB", "1", "20343", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0ր\0 \0P\0\0\0\0\0\0-", "GB", "1", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0ր\0 \0P\0\0\0\0\0\0-", "GB", "2", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0ր\0 \0P\0\0\0\0\0\0-", "GB", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*AU\0\0\0\0\0\0\0", "DE", "1", "20345", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*AU\0\0\0\0\0\0\0", "DE", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*,WB\0\0\0\0\0\0\0", "DE", "1", "20361", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*,h\0\0\0\0\0\0\0", "DE", "2", "20344", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*,h\0\0\0\0\0\0\0", "DE", "1", "20349", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*,\0\0\0\0\0\0\0", "DE", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*`\0\0\0\0\0\0\0", "DE", "2", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*`\0\0\0\0\0\0\0", "DE", "1", "20347", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*ߨ\0\0\0\0\0\0\0", "DE", "1", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*ߨ\0\0\0\0\0\0\0", "DE", "1", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*ߨ\0\0\0\0\0\0\0", "DE", "2", "20360", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*ߨ\0\0\0\0\0\0\0", "DE", "1", "20361", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("* \0\0\0\0\0\0\0", "DE", "2", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0\0\0\0\0\0\0", "DE", "4", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0\0\0\0\0\0\0", "DE", "2", "20343", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*E\0\0\0\0\0\0\0", "DE", "1", "20345", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*E\0\0\0\0\0\0\0", "DE", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*J\0\0\0\0\0\0\0", "DE", "1", "20347", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0:\0\0\0\0\0\0\0", "FI", "1", "20361", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0G\0\0\0\0\0\0\0", "US", "1", "20358", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*~\0\0\0\0<", "DE", "1", "20361", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*~\0\0\0\0<", "DE", "1", "20362", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0\0E\0\0\0\0\0\0", "PL", "1", "20361", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*$\00\0\0\0\0\0\0", "AT", "2", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*$\00\0\0\0\0\0\0", "AT", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*G\0\0\0\0\0\0\0\0", "BR", "1", "20361", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*{@mG\\\0\0\0\0\0\0\0", "LT", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\"db\0\0\0\0\0\0\0", "DE", "1", "20349", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\"db\0\0\0\0\0\0\0", "DE", "1", "20355", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*o\0\0\0\0\0\0\03", "RU", "1", "20359", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*o\0\0\0\0\0\0\03", "RU", "1", "20360", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0\0\0\0\0\0", "NL", "2", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0\0\0\0\0\0\r", "NL", "2", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0\0\0\0\0\0\r", "NL", "4", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0\0\0\0\0\0\r", "NL", "1", "20355", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0\0\0\0\0\0\r", "NL", "1", "20361", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0\0\0\0\0\0\r", "NL", "1", "20362", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0\0\0\0\0\0\r", "NL", "1", "20366", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*U\0,9z\'?", "DE", "1", "20347", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\nL\0\Ztp<4", "AT", "2", "20349", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\nQ\0\0\0\0\0A", "DE", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\n\0\0\n\0\0\0\0\0\0A", "MD", "1", "20347", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\n\0\0\n\0\0\0\0\0\0A", "MD", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\n\0\0\n\0\0\0\0\0\0A", "MD", "1", "20362", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*r\0\0\0~\0 ", "NL", "1", "20342", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*r\0\0\0~\0 ", "NL", "1", "20343", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\rY@\04\0\0\0\0\0\0\0\0\0", "DE", "2", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0\0\0\0\0\0\0\0", "DK", "1", "20345", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*L@\0\0S\0\0\0\0\0\0\0", "DK", "1", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*L@\0\0S\0\0\0\0\0\0\0", "DK", "1", "20360", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("* \0\0\0\0\0\0\0\0\0", "NL", "1", "20363", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\"\0\0\0\0\0\0\0\0\0", "NL", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\"\0\0\0\0\0\0\0\0\0", "NL", "3", "20366", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*҂\01\0\0\0\0\0\0\0\0", "ES", "3", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*҂\01\0\0\0\0\0\0\0\0", "ES", "3", "20346", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*҂\01\0\0\0\0\0\0\0\0", "ES", "1", "20347", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*҂\01\0\0\0\0\0\0\0\0", "ES", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0\0\0\0", "EE", "4", "20340", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0\0\0\0", "EE", "2", "20341", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0\0\0\0", "EE", "2", "20343", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0\0\0\0", "EE", "1", "20349", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0\0\0\0", "EE", "1", "20354", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0\0\0\0", "EE", "1", "20360", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0\0\0\0", "EE", "2", "20361", "brute");
INSERT INTO `wor4890_wfblockediplog` VALUES("*\0\0\0\0", "EE", "1", "20362", "brute");

/* INSERT TABLE DATA: wor4890_wfconfig */
INSERT INTO `wor4890_wfconfig` VALUES("activatingIP", "190.114.41.211", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("actUpdateInterval", "2", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("addCacheComment", "0", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("adminUserList", "a:1:{i:1;i:1;}", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("advancedCommentScanning", "1", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("ajaxWatcherDisabled_admin", "0", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("ajaxWatcherDisabled_front", "0", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("alertEmails", "catfleetdesign@gmail.com", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("alertOn_adminLogin", "0", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("alertOn_block", "0", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("alertOn_breachLogin", "0", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("alertOn_firstAdminLoginOnly", "0", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("alertOn_firstNonAdminLoginOnly", "0", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("alertOn_loginLockout", "0", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("alertOn_lostPasswdForm", "0", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("alertOn_nonAdminLogin", "0", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("alertOn_scanIssues", "1", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("alertOn_severityLevel", "75", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("alertOn_throttle", "0", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("alertOn_update", "0", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("alertOn_wafDeactivated", "1", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("alertOn_wordfenceDeactivated", "1", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("alert_maxHourly", "0", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("allowed404s", "/favicon.ico\n/apple-touch-icon*.png\n/*@2x.png\n/browserconfig.xml", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("allowed404s6116Migration", "1", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("allowHTTPSCaching", "0", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("allowLegacy2FA", "0", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("allowMySQLi", "1", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("allScansScheduled", "a:2:{i:0;a:2:{s:9:\"timestamp\";i:1760330968;s:4:\"args\";a:1:{i:0;i:1760330968;}}i:1;a:2:{s:9:\"timestamp\";i:1760590168;s:4:\"args\";a:1:{i:0;i:1760590168;}}}", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("apiKey", "80ee7c0a899b4c21607f96da0930edd46d70a769cc55c087ecbef45d2a7d80037cfc83f2908ec9dde05ee5240995f37446733912bd58788f2a6245f832e10172", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("auditLogMode", "default", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("autoBlockScanners", "1", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("autoUpdate", "1", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("autoUpdateAttempts", "0", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("autoUpdateChoice", "1", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("bannedURLs", "", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("blockCustomText", "", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("blockedTime", "300", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("blocks702Migration", "1", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("cacheType", "disabled", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("cbl_action", "block", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("cbl_bypassRedirDest", "", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("cbl_bypassRedirURL", "", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("cbl_bypassViewURL", "", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("cbl_cookieVal", "67e344abc00de", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("cbl_loggedInBlocked", "", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("cbl_redirURL", "", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("cbl_restOfSiteBlocked", "1", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("checkSpamIP", "1", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("config701Migration", "1", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("config720Migration", "1", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("coreHashes", "\0\0\0\0\0\0\0,a:2:{s:4:\"hash\";s:64:\"92f62ca3e391f9dfc36b01725176079fea57f1c9f3a086ccf7e57c3dba981b35\";s:6:\"hashes\";s:359392:\"\0W7ht#	q)d$\0\04݌^\ZYi_O_#\0	|zovu1P2M|\0[fquR;G9elWQm<X\0S\\6¬q#XeKAMe\"$\0t]Җ`wH810aܲK) E\009[	$:MU5ȦC\0\"xxIIkCMx}\nB36*\0(띰xJ{hϮ%\r^:(5\0(ZYY@Iqȗ#T@\0+0ߨP;PO\'^p|NsN6d\04ߗt\\vQ޹\'_ajxҦ\0?`K]i2E+DNȿՐ\'\0E*G=\'{>9@E8E_1\nZvٶ\0E=jȋ|p8.½֤SGp\0EqxPa>bvDo4VG;a<\0I&Txf(}6AC\0AGgҪ\0[eL-Ov\nör\rM˼\0^N弘ae|K-ܰɜ=\0b&F%|w*Qr;|/=(A<\0cpR/:`\\-j_pg_|;{/2\0hQ롣7GNʹ7(= \ZgLQyl\0hT-)!Z0s9fl\0hkQv6Pr\":RF.m$ϭI\0{v4+9o&1 G3<*Ca\0#B5j$#j!bNj\0JT*.[χ+R\0ۧ4(KI|0qD.^v\0Ó\rƱ6 ,J	!d7nh\0oNWl>4ԚM\"LVI1\0ݧw:9az](0_\02ִJ$:79Rg\0veH ?T00c܈\0iք\"]^XD2](\0/o):4]_+̔c\0\'\Zktҿq	u`tAdca=rD\0_j/8_5:/fO\nq)Vu\ZHVP\0˼o%?NWǏN{j\0D9\0IZ#0N_Id._urYxe?\0e*@t\"q	ȐN5H\07KaH@UIm%Ox\09wi5}h\0%QPJ mc{>*1scӀR[ZB\0Z̈~0=G#CZ}*p\0T|̅_S8O0μ¸06\0-bsG\n(hr\Z.n!ez.YxʦDIXVfEWeG]q!N<mdM^xP;A\Zgl|ɡ*Չj<LP0h$E!JlQ[V6ӠO M%p/E  N+.WFZ)6	jnNؤ^}0[PKXs+ȉ,U<Ґ2zHwcB0sD;P=\'2	\0Df:$\ZUӍk*_pi@zawS[U`|WSPD羟Nhb!#8i>kq6RE5:\"dt\"ߑp+OC*gx`(Ih&_PA0);:`YIa]묜oQV\0ZGJX<|ø#;Bi.qXA4uU+ױϱT_^gyzGL\"1U}6:Io.^IG!y\'CFƅE)<@>	Hj]jI9YE8PA4k\"\r8@F`Jl|(㜦q{V~u<DhJɤ%X5t (Bwڍ o*cϬ0xcl$	4mωQ8zݓi{@;y=b,hl?1bQg_%ӄPm*NOW+\n:eHf8WMuI1W\"rnjIVdλ^$2lbWQVL\0/M1ο5\ZNo`vA:`{rf_S3/sm?d^͔0X0#q-ml*#L&$FΪK#\"`ԈMCWd$2]%*6\\dpۛ!s%]ZYoݿr;G\"%2>	{ WD0^bc_cIȞ2E4\rev^%ǝ^K6\04dSHޘ42p⦿ו/?	G15 }x(r:a,zmKH1|/+8RPAh>lM;y6J=NB]u9a+855#pGu&w]-H\rRW\\5\'=J:TxC6BM\0CKfCWAޙ(\rf%E/PsZFԤoD-x?<uqXQ7ai\rICpEKykѩ}ˣTX[ƲurNn)k!?ٟ..dVxn#6w?4%c@\\$p\"&p+^\Z{5|f㵅SLo3ExѥUq`hC=\0,4Ok8b\0s)es(WH/9Io	tPfw&񿊮٥_<hq4uZ[n8Or7z V#KfZ])G0H01YL$RRAhJ6Mw:/7.ڏPh.BU-ї\'Tsz+ppHaP04D!2{F͹|ItC*cǆ>L4nUp\0w\n˒iYIÿIi~A: 0Z\Zp8$h\"d3\\pYQᣎK4* ң.\"*Ϟ\nsCdͼ&rbхKC(vRJĂkb_v/x0(lL[~yBAs撗R8uK(Ki\0*i=7|-1~8Jc<Fh}Tcm<a8F\'-*0Ěd@p\r7ە@)D}dXȼzR;OHD;3\"AkiGijk7[`̳8S>NP_@#1\0ӥkDzsBt,GޗغKu\0Mx>]Z\"z8ŎVM˻yULKCWa\\ˁ\n;0Ġ\"fАΟ\'\r͍DdMt.y=U7Gշ܃-,-owi_uo8RZ);Qdн,sǿڴ$2j),\n\' #69\n^	nt\"V8M@H؟Q[S$ږmK2efte4\ZQ}Tnǘ7vfg\0Eq]kעkf K@HWTSҺ\\@*\\dKi!-HBU@;T&1R?s.	6|\Z3GG.fVy`)\".o[`ϐ\rtI[@i͹V싳%S&r2`[hinjnviU\n@,+!%u	re4+JuP$#\\ *h5sO+}Yx3&.)oJd5jӨ-/G_w)Oy\Zg`J\r5n]S̓&t,WNP2\"Ş,|^y޲/\Z(A-pc[gPHl:e+71]/ƅBMj:@ѫG+Sfd5#mG2?>~\\8cmU=SmV59HbSVub:r??2.z*5,w%12X*dM}B=c.zy)7pE?.1PpHs{//6.#xSE{o#IfQӹ<bEJ|8v(8C\ZP.G-6n>ڟl1([\0POѭ2mQ\n\ZeW[md[\Z2Vi\n6Wԑ\\<OEj2QYeտ(U~9\Z\r%&bW q\0mc$&ru@˖mXݕ1cf}uh&h欩O\Z6X$\nJVejhRɌT#\07n#c0x2ա_\0?qqu)T|/\\(mG[Pml&CJpḼE>+`5şwo(^5U_gJޔ<N6o8\r$iu2u:N艶\n@YJj8mL	\r|X6/46J?XGX~uic\rpQ활\r?ce}QCjV\nh{F/ܐ{:LTӊqgȫ?crȸtdH{K8g>e\r޼i\\|}b\0sFB\rTJ,Q$TDh((ZdzD-jf3&᎒^Ú6}QU@xd]n]	+hhDvO_;ƀEpY.&}_	QoSnn̵v\0)SnR\'X^khɑi7Ӥ:DILV\0yZ)K\nd*Y®s<!)܃J¬ܘD~%Roc7\rL̥0祀O 5 =nN,\Z;pBH/QRq%=O\'[!u.ꗰ~~C&;?PwCuFa#EMooai5Y;>1݈]^]RɢNFMJ,iI.2 >1Z;ר1ԁ$!W:<~$e8_@gFobLRdF@yoFt?h[xo	=6SA~t	\"~AG>2Um&D\n\r<~\r/4$r_FAGuf5S#{\"Ɲ	SxDq5/w_W:+f1zg\\YmxGO0jo].㖽gclPJ;/vwXV/]WzB=f~:NFa6ա\nY \'i+`fGYbmUPMJڡ0&\Z+9ez\nTȨ&8egZƛosel^.cp#>|A|F>4A\re&:\"Vwe?!\'meXTy\n*Jړ\\T)):(	.iMags`*C?5ɫ^;\nV5%Zg_j:k&}|;jdzGԬfGm:bTP%@1\r\Z,Wl޿RCvM$O4-K	o6lb1E;7x?-ǱZzE*nkEm@1sY#1$\Z=IbXBr?ͥ-!i>[8<ڋL\\A˫!١\n2\\a7YrG7Nл\rR`]wBκ@kp&h4ԛ2d@_K56Bj{v1\'/mI$=D֛&Ǿ@+բosjAmVɥY,S永p0@Ԫ/&,8\'X#e?qO.x&*p@lΒ/ktp1\ZQU|O\Z(0\"tV[zd}gg=}wx*!PRz=i S\Z\Z4ڶ1523\r#?EQLIm$ZB\Z!&~?L_ê\rϋKo?{͖Ck`7\'/]i5\0?r0DfGXh6܊:cDX[\0qyq6z	-\'><S6[2SC+2f!OgveChI)9%\'R~LȮ-\\c*Ksʗ&d^ߚp;B\nv;<(;@Yx\nM3Ȧ({rE(ug_	ܹ k\rP`8cͷۃ2ԓrځ;0mCb%%-)^\\\0t`k@UOŔcp>!8HB6=b!Hy˖(	4R:vpU8\0DIVN$=K<р\nŹqnz\0OS~K|$TlJ2Dx1~qtWZ;qlJ(v MN*{%>}CC?GA*ҊT7S\\dpbOwf\nTEg\ZU\r\\<5Q[Dm<ebc4@iջh=M#8HcZv&y3%,PA=[$R$-Zi\'uS<8!6pVݓ,|)4:?gUC?~gR-,[8N\\yXQh\">s#M4 6鎬M&$!2d<\\	|\\?g\n4Gn<?Zpgcr*M:w&\0@D|i|(t~0:;d/Ѓvl<pe1yYrjLA\"}I\n&{mcK1AQCWKNeӌ&ЎuѡIqtn~T	_j-%?70i}eiVBet~r\0\\^P4:Xͫh	ƿN_ z/h=ZO&E+rXe{emX<:KS`W+9	Q߰2+XyYf,Iw,VM4[O\rIi5*\\a^m\"؋);ӦƘ\ZL_;y{r>K^sVS2oH֏_)7z_oeŭy^/?h;@rK%LPP+;9L/6: ѭ.^Zfc(|_]U͒o~MEh,/\")a|Ykjqc,}KnsRpdF[\'r5l蔝媀Xec2BZ	Qjh!>&ɐ4|]o\'7+|fo^\Zs@Z2]i](J~n3ϝ=c@{걡C5dpEt9=Ưc0y0jƄL~w[xkv[j*?I	W[wZ8FqYBw\\	HsHYު{27QzХj@|9^.l?2ܞـhjqo2kLJQc\08|VD>Ι+N\ZF|#4m=9cuANں)\rmMADos,ϣ]G3n	ڄk4z>G,ҕRw&8Jie@<M}<,\"/d$gJ	Ŗ7l}aw|׫T!\0\r`ASd\r}TgRLh!1R&\'kD\':8YިKAa-RHT(:=ߤ\'\\\0|8(]xZvJ+~S$ً6vgAќʋQ?j`J_ןI\"رg&6/#׶	Z+(9N]0&b\0V?9\".I3P+>ف[!:?-%6.ݱE\0\\48|u3DuT2r)rk+`NiM2]<	h\n˥3CM|9ɣ.sc~	MO35F\\\0,vS+pi|#ր\0azgּ(.	w{pdLu5>I\rZ\n.\rJ*RT	!A&UBtG=_:\\]>i?η@ڹaKպ*Խ+]ҮgƉ^62G\rS|;iDW:fLw ]X( 	7DTM^f\0vE)$=Xn!l=@A:V56Ux5Px&:VV-qXA9M4-t\n{}MI	=\"!W삵5Ws`AE0N.T0b([C7?㤒ó@,yxb_5;Rx1aij;c,9+S[@\\{ꂔe:g}zoYd% +[B f<3)|v޹U*F1>B%\\cp(xZq@51aIxMOYU\r:\0כ=kF\\TE/n]CE#Z%9\'ZY*I7C|Aot1#4䂹\Z\'&8\0\Zi_MwKQ̜5K⯦gH!Iқt$sـi\0S\\lL1|.f6{c:E,Gm9;:ͼff)I;&6\n?dtƆ\"]	l`pT<ҙPoi=DᎯ0Slhsgܺ{,ƦLX-Q9=By/?ZѹWchsM:^߹B4FRM`7lD\r¤H*y)\Z|<\nx*i ߎqZt$/7{m_,`,(d	/ܠ0u;2=\".kT!Ȃ=4(SPYB\Zd;˗1ʧ]`yL\'b43ᘈVrd&Zm_q8q_W*layN˪rWpfG<lm8%aKu)`C}21;4eG0\\cRhK!^W\'`h`P*ͤ!j1m!~Jz|垝+WƣVFYr?|\rS+%FF/C*7>ig!*]j+.{c@xbH\no@cWUڹ|<xJ{ur9wcb\r\n|9,#T$Sm4b(*6,KUΐ\rO]Y<y}\Z>ɺHI|PX9nZԟ>$4WyKt0|h?\\*Bbe^Έ;VT1cj] k,Q{cLz=\rKW_ւE#\r^JPUaFH͈El^O9A9/\Z%@b.` podf?jrYe|Hh>,ecRes5-D=<:3ϩM>r6Ԥ%zuۇ7}F[yx]kݭYr9IV,C2\"Vlp]l2Pf>YRp`\0\rPqyF/W]mE>Kp֚Jbvw`*wVAZ&BHPWe?a06d&`5јpvpƺvj%믧g-۝,*|#YvK.};wXjE[Vx<t5{@/|\nr$zp3\\Ll#JCv\n6jnՆsi_vj|Y	Y,i,Åk!8c\ns}*ʘ)>2qe^)P$R ^LUXJNgOQ&$L\Z$0!xnGfR@Ol,>iv:`tQ*8\'f\Z(Is;|\"!o.1qd<\nJ;H`Q؝6pqI[hrI5Q	}^R=%(-&g*3ZLw 9ʚW C5{&j񛸮\n[wa%\r	\"An3HIs:Yae0BҲyPp\nﭾ!Λ&Ʌ\'M4BS+\'4&$ءVggog~m/ؿV,X=T˥C͙g.LkC\"m~AA/P%~f!~;` +Hʉqǌ`\\CjvTo`=ƺ.YR{VDn+\nW+\r39Nυf?F/&t+s\"#:Zܯ4㓉&_k`z?eO2iLy[l@\r >	G Eh@cU;ڷƑaDe:`6Ieޠ)Ɲ\\$&6\"xF|w`AZ_+vL\r}NP1|;Z8gXlb\0vt6_Ұݾl2bqÜ$H}>db㳮QONTP!οM{#ءLcW/%U[w4<$ZphUv	l,s\"\rm`YדUXZps҇HIw-]MJ_xǃ^Ms6RH@	&冾Bx@dlIu$S0K,,&D&dM+MArJ6	Y;U&4=5KQia3	r͠7q6D^e1y:+oѩB𴶥Ɇ;KE9\'>z`bR#UOPgsHo)nWrxSX;hVz\ret<W$Z/UC\nN0i(eb?G91{|;\n$ynȚhME:z/a-;qֻts\'jgw:5@*9Vμ[EBu}<ṑo3	QEO\'bb8\\\Z#d4*?dQ]Bx.|9D:h@Q/U\0-|_ۢ1g-+}Ԙ!^iBJ\\W]f@@w=	\"`f}[8r~AL!\\Q		RI+/\0\nũ2t(	+xg͋\"T@]];Qĳ`	ZJR@N\0٘<aV0o&0	D\Zi7LsN~z)	$$opñy2\"tAk,c\ZIy	,Ado \'Q3?컚5V_$	.]kZ1љmG]x0	0\\$zt7G|(֟C	1/	j+GEb*/i͙K1ڲ	64 2DMM$\r澐i\0	8\\ŬjAʔ5+XoTm_|	Ac5Lc9ĞFLxöCy4	D-q[=$xOkӐtcP	Myu$1ck_Kofm%	ZVE\r\r4m斢n`q	g)[.r\noi{4Q\n\r8H\rfX	gIn=Ǐ-A=\r\ZgtL	vlٮ!Pm\n6|ϔK	xy{-i\Z,3NOgLJ	~Cȫ7:s&ujt	K2wy5 ~88CON\ZjZoF/	a.{\"cWCz\njRZ#	+{Rلnt,Ǟ`|U		#t̹p=I\")F	y}`3;\\.2V!4LӚpe	 8ҘP0\0a5\r1	,5KVť۫\Zcjϣ5jk	ʝh/w\\\\2wc*;/Hθ>l	֓-\nqUi-$h*ml	FkjL?!uM/T\r`;$	ߏAWnD6>\'VT<è	WA2Lh`i%iv2޴	VhLC»>U8.`@<Kh	~GqR˒76li9`ZZ:a	x ?hҙTꑠObS̙L)	ͿU%OHޡ@~x\\6~\n<:XhQATop28>\nC26	MQPLlx7pޘ(oZ \n*<ӳ?HM\'VL\'[R\n9*7WT$#/3Qsui(\nّkUˢNV{qOFC\nVY\"׳\\X@;t<H\\\n)^	`-/3{):?\n@&[DqSBN#FB\n!x\Z\"i)*@9jܯoeiaKo\n#\\,--*N	Vӻ+:F Ӹ\n*An.]Btv!WҧMw9F\n+P_tQVo7n\nz#8J\n1V<WkNʹ_Q5~¼XM\n50~RwKf1̅~h\n6k55]8r+>\\7zk.\n<#\"KyzMMbm|E\n<~J&,\nkxrͷ78ɜٜr\n>[]:D++<39#nT\nDfdvPfOn:aгX\nHp꧵^\rf8+5]|ԶS9Е\nK|\'y[n#\\Sh\nOj{DamJG\nlآsL	Vnr(\"b^ŧ\np;(J?1ѲNpm(C#wC\nv?u	fh62B?2\03}\nwd72\\V`+D3\'GS\nxmnV=OD\0T)U\nx0խ&IqX[,;Cfnȫ\n}.ve\n?.zE+ɡ\n@R\r(\ndR}#Eyr\n\\_9()7\n/S\'g߃v\n}r_zG\Z6;nin\n`]J<))#͂D\ZgS\n{G2]o?-iq!\r1 0\n9dg~@|B-ڐ6=\nxeEu7YgB5\n}=LFz3zң#U\"\nT[Cp(,_V+L\rۨI(.\nsHчc -y//?\r$M̤j3\naqYKJҔ΀p\ZJj\\P\n\nڷtn\rEanJ;}(ҙ.9\n W\"w\05S Nrh\n\r\'J\r>b2@5z<xP}\n:ba4Bʄ۴;!8\nO7ÄF.֔	][BwвW\nRya2pчZ\Zyhh\nC0pFdl\0\"u~2\"Tp\Z\nv[\0XZppi.c;~&\n뗓LK)3\\ ӯoH\n&)h4_`FL<:`#pf\nLW/#tvm$m7޹;}p\n󇞇v\rA*~*5=bf ?\n> X-sY\nL BΘ]\nRW#ވ Qē4E[\'z\nS/̼#@%,ul$tT\r)kOdS0Xz_h8@2];^<J+)~bI$NܱL|e\r9y\r+m%g!{[/qydE>^3i%n\0\"K61kK(]1zukpR!YC7/,A7䮾9l273Λjszn<)&!@pK.c~[&\'1SSL{z),\"wWSJǲKMt3}?ץ墨?^}U>C`SuᾒMcccdD(QZ{L GNJ\n	⪋\\\ra[J?T?Gd(sh\ZU_\r[:Evb{i5͢tEݟ[iz@VuKEbt˽]6d7eUYIkA\rv_6+q)ź(1),v³`TΒR\"G0	Xs$tBUI+uCRSF2>3`v\':js(-N^H\\%G[TQLE\\>w)֠N3:VS;CT\n]yG;^ʇZq`\Z\n qXW\\@>˜2\\UDÍtWf\\hA}2=~bzp7XGП}ߛ1GhD+s<됤~꿂OП_O3e,g_]CrJ2m5CZ\0/@@11ns$QPFYJJLD\\2jDծ68g\n)ezl1MH&Cſ8tf耶ӍD(\rXa7\r_FܦiF{!۩p˜S.>UB|2ӜOU}(԰tΒ\n$_lclaBYQSGJ@9~є\0ݲK`XMUCL۶:#÷^O>)==k#~kĸ!D\Z_8?HMХ;Pczhm/iZ-!z̹=䆀0j24\n:Wn\\C2^5*+R\Z7S$|+cvͮˤgYH_^F1c*+\0%G;_dE}u-4w\"DeUFR7pO_7)ud\nsbh5tc2ĒZVR顃[l#4>&{z֛#VIa}nl/\ZtZ4^@MB)PR[,F/Ý%2sZO	`I9zZ1εEl|lh]:Yň3	\\gm̻1)q+#b^0rRAcINOõXxgEQ\"J_j2Z3n,!6o&*b&6<}Iq^|2ZWctVҰzo_ҲYn,J́TNB(-iDrȭ!wzL{Jy7-mG鴞Y[kEn#XviwR:M7KkRD. L9{GS0).~#m}:2Ttn(c	WP\Z6Grnw%SJ*n\'ͪt^VɹO*(7Y(Vz|%\0\'jlص$hTC՞N8kȺy*<I\n(x$C\n@Y~C,5\');s	>2$ym-BYVAlͼ2VS#nX6XDUT=1O@,x\"K\0[P#>(iƝO(Ϭh?tXfl@oCKKRK֥. )\r&d5s/,\"dNkN= ]٤.2nKih.5h0w\"ۖ2LlX\nCpÐ =\"aa4yyCiEGN1&Jҙ9:EO_Q֮?k-h_J.&t8&mKX+CƆ\n!;[oVF3Dl2 [֠Mt\0D̓^(N\Z3;8z%gq,qZQ,zg?xv&W=DX*\'\ZSm(ų1OZ}m2_71]S	x򽭟Ek>^v@D~\"Le N\'vɇ;W\\ҍg\'Tw22\rމ#<*Qf(.Ùyeoj$[\Zj(yPR%w@%``dt\r\n~U<.T\nx XH\"c}n=\r\nF_Zfv9;ܘ6tWcc\r}䟹-V\'eCCʅe-2,0\rG\\׸ϔuv\\x\'!g}>\r!3+tEj$-7!A7ͶNg\r$}<吰f\nxX7hh\r)ir,(U,=OiATTc!\r+BV	`\"T+(Vd\r1?;IB=S\Z2֥͐&׆ZB\r5CٖNskl\'t35\rF0LbT7\0nY\Z\"N>{\rNIYԯ!6)IY\rQi^\ZB|fC-/rUY٢B\rX[cdpSs3%.X|Aw#(JL\r]=-KJ[LNY^ڥf.j{~\r]EiCvEF{yD|JPf\ra{p9(A)ˡ̮SPVs6#i\rdw#%D5ʂ\ZB./q=}/\rnu:Ft\Z\"P9qPRPA\roh}}iVAԁH!v>4}M\rvRHSϙ/xR};ئz\ryҰ݃#Z$0N\n@]\r}p\'qD%<}&-#=s_Oa6{\r+Jq )<^!<v|\rA[\0T\Z6!✷S\r;\r\rBtý6t+G ]Fxn\rk<vWPvg(Hтc+d7\rYtW^}rIxۯu$/dMk\rU:w,&Kp&\Z\r1K,)>_ѩ-O[ƺ1L\rM\'7B MfPLBKo\Z!SJºy\rr	ɲ:ْoP4DB\\\0\rT@hQFM])\rXd	D\nqbc\Zu\rblY!z0^ 38\r{z2?ĳxQՏu\rٓC7,<p,L~rYs#\rL&ބ\0}muLJi..5Gl\r\"(qq6ZNş&h\rدG;ļ:\\wO\rӕF	6;hXYYԠR\r\n*J6V^%W\\y\r\Z_ES(ႃ:pQ\n8AVg&Y\rL}upm^8tJ=h ʺQs\"(\r4S9*,ڹ$\rMX}|*\0@:GC)̦|u9 Z<Pr?s2Nʽ[}ҪvAx>Knh<2lTTDLn*ɖ>XYHKr[[	d\'m@msǬ}t!\0$Lf8&[>KAa9	hNm/͛?M!^NC4އHw\\އKFk¡G\\L:0LoZ&*\'h?II3z(BGQ#`pS:eJ&/ʝaɋ`\n}\Z\\x+G\\%?\nۡ.=befQkj\0{p|L`E	RM&nph*2ٮ@ؼRO6}㕓悫-FkRV6G_e\r\"}Q^uYtYsNldU|7tUFYn[\nק\ZZ\r\nd.ji!!aIWRHjwHBBuXp\0bUe$Ok5E@yWg\')2Y_r!JU:Z)*0S<zp\0I[\\s럔|Q0&v*5ox!!}6vχ@zpn8f!4\\yE\\q5\'k(GqЗRu]E11]Q[7*a3ǾhNgB7s|9S-L,Uc\\ki6uJ\n3*F) aLJ0U.񂩰z0KviA&4=Dq!蓸֧f;4PZeO!vx.e8jY0\Z\'H!}\r>lCik=ӴPP1S/0?U!͝%GƔ[n` {!wsT+iM<_8Pt;*Gn^-g\n.ƪ0[/LpӐdD\'R}KvY3sȓӨ\rN8\ZA۠abZF?1j<\ZOKnx̽xa56??Zvw=2H:)x.o\\JtLUoL~CMAdC3fly3kc\\h6 )6K5S$ʂ8⡧5gg73lsuؕIR|Yea-&=5ucx2:QP{ǌ IX\rrWJXؾyZwڠ0YE\0身i\\>˨ˍθ\r\"PT\ZrG;ູ=*芈QA\0drQ2Ҽ9_ׁ|7wq;,rLX\\35qv.R߼h<<thD$\\,t\0_gX%4.tP]>JT4ݲCǢq#c;wj5p!UQ2Fg=Sh+jK!o:[rh(:C:9y55@pԙ>|$A%m)-Э}#MUknnyX#1l$y,`pMj]#WBTm7gy\Z]OYTbPǚ昁8C0ٞXӂ}`L>liI%$YD3KgjVFM(b;ˏKg&\n-nzEWY~R\Z+}}GZ:,6˕gϲd[g~*|g$ihUfW\".q-rTW+*+j=B z)8v:tVY\nEPArbPZ#UexBS6F셥Կ\\?wc@2,P0x`ՁdZvs.k\Z5\0yX$j뤋I8@t={9v>:̷M\Zϵ\rBt\r3} QMehKlbvC@Ki0bnj:$L gra0\n_Q/<Ux &S8y1^::&s?tC Y\nH$$T̞}^pfO]ǭN3%\r\\-AJIRNe|pmi:Hc$BFqMs)}p85q:YbϪlaj&dW8iKs5KK7Pxe\'PHHP=,	]?!2qػ{?Do nO=+goYqa|\nk3L#LN}\ZEO\\0uFOR\Z)U?v[]+SY,|MxmCt~U:|l%\0Cz\0ā;S\'bN<vwLSڻsT|>Qi}GD7OF5BS$_+EE4$>VaӸgxz2p;R lZ֮3z(Nov:A_-3x\ZJB@ky50ݍVJ#1+mŰ\0tG|H)gPL/(O)G.GnE\"L·_ Ok+pV5m\n/나\nQ(;4.`RwGM^<D,*R	/#?z%D0ʓ8)Ǟ!Tuwmt5o\n2A\"kߚzPhe}B\\t׋_V1\"v-m5\n6XX%ɶB{\\!}o,4{ȟ>E5n0S؍|lSPpkGM8ԹfEx;˝O[J`uOv&_-]\n)>	Ρ\ndCg+E;|x$(t`\"/\Z=`>4%iqrRnI&~.YBi>h?@!\\`Rh/F_ͻ(8Y݌>]&oR֫	ڲ}Z	w%(\'ߍ\0`qֶp~rI{4);\r;)6qi9C2td64Kծ9AdƦN.\0zs`%Kh\nփ;1R0S\rX1N9?ȦN@9(IU[Wn{_AU)۳!Pdlw+>;O-Bx۳xxDTB(D&LhyML)\\VH3_@AJ!_drNNkm>vҢT\\=|?R7lcXzS%MO߁DD]80]\\k[w0%~J`\ZP>mwF\ZV\\XRǇdG;Ϸ6<wj;V4dhTV\niЎ$>,84.\Z]7#WkԷ܏>Dj,pk~*d}[H?iK[i/(^m-h~c$i\Z-h9	ݼfDrS0.HeL3r`jG]2g塛Jr؅\0t\\4c-Ȝ)͗۷@c.V_;q:uMXbWZ`Eض\rSky%/-u_EC?oȹb^\rPm|\n*Ņu~D!@WTgNLC\"M61ɿ\\)ji]_\\]-V|ʓO>;O$Pw2mb#6C2ao2ᨁFˁLW%\rVJ~p$P(qs؄K%y7M0^8?>8ղ>KuF0B|ӝlWz6ք8Jj\n g^\'\08Ut(e`Cvk+fG5Y+QC\"(GbYSwk,ɥJia%\0RS;\rs}o%XOwR	\\B;zb#qlESW,f^ayZVZ}m/PAL+SDLex骴@m!~|dET9v,WыʀKK#\0f羀G~poPq9\rbL\\92׬n*HǬ]=,z?	\rN@WpGPP\0Aw:oHRRESGʏT-a*Qf,S7q̓<U*\";br^&7jFőұyZA\"Y!	=kSB-I6@̝MTVqxx`Jߩi.?w~/\"wU{Lf׏1:դy;&ۆ޹[rDbNv㤄\n\ZwrkHuEN/JYgSi)}^~_Z]\ZILҖh`WbDZ	6AmwlrE07zd^+3IBk1Cy.RN]o}0<,eS</ܓ8C`d|#wv8\" 4&ɐ1i,J&~-Bw(&!f#s(CmFT7Dhegr19tҠPCT2IUXjF\rPJ6\\d$Se=g;i\0@Mbw,C@R M+۝JްS0ilww4:\"D!c+3bH0`#\0\ZAzNcfP>Ј6Iꄻb\nA52dcRPD߾Ѓp>=[Z\r#A@f31_<jUhb1*Cٓ`^,P*-V\' raQ%m#ɑdj	澨E\"͝nʶe\")!mKsOv(QNYCwo}z/+x8x\Z݁[DAW/OwĪ\Z83ۀTё/*2^o/v@X5O]d|y;גܰ\n0\01x?F(8V/`8Іt2:]XK%	EL償7,hо>#s\"$ܱӳIяq3#Src:׹wLBU\rxb{3TT44\rt~nF^mKYN\" N-Cb\"CT!3gH>$\Z[I0ա(D-hq	<\rNru7&x%w2{	\0L .BzYV䣊\'&	*Ewrn~4RRhp$$8f`046K&nol&Fax3s&E\'\n thRDP>(F-$>QA*0l[,{ᛂC6??ѣF%CJLg4\"4g^=Hp/ͤLUi172;-|:\\aH};ӪFk\\ŘDv:8(uG4\rH\"wOA)7\r&8bI{bɏ,WTkNkI!&$1|~)U[A7EOxƟ:Y{ 2gXzjE+-}^d.\"\\Z+j{hN.m۩+6r0_$R@ݎk2W_UGdjUY\rρF%\\V[z7j.\nT-\r)hQxnd\"j; ? >RKLATy6bSkOZP2\r\\{N[M>_.?pbNZI&9*V?F\n\'p0O	9@5E~UqX{4a4=PҞ%^\\$rfz;@h謬&f{2T,Jgtbw~AeD1kn\naa]~KObH$(\r_\ntl	# OqEHBw0fYbv6Ax	70)P;\01M{}i!!ÃTK=9(I>uQ!z0t6ާh`G )U\r:pKBR_Eߍ\n}HNf΍0/,uI)-[\0=ֹ?+;Q/׬W/{Ti->I*WIBbtI\'ЕXlDAURprmm\rF6طi(\":@c:<R)%+:l9klu[!\rZSWIG%Cy*m?۴/\r!iAHK2w:%.;j@۴)H&Rװs0\rjhs\Z4}?RwciFz\r_c;QAFcSl\'8r%$e;(`PJRQ6}%\0wQ1h~BB8}⻙IΥ7\"i⣶pw\\zd$\\4Btn5rN`o#6׺ʌʤ!gy{8٢7\nމO>T,]~(\\l\0f\rZꋝ&53v,udvweˎGTz0=\'_몯nS׉r EK@dJa\rRh,mizѪ\'jΘ\0x|ڦO3ĥbEmsQ(ӶtAʌ\0IWqc͗Os	x]}[\nHq|.񕔥\0HO.}5\nQ4Hw@8<Sn-GaMRAӯ	Ώoo`<DYQa^<w]gT1^0>\r劸֬+)7X[_u۱H]\"¡`nrXa/=0zz꛳<:(;?~Rq3ٽR ar\0B;е=S@dc]rRּn <6<c=ORvBn|JIn;51VDVb!l^B2&֊j/uSK6ǐHiI (.fOdx,0TbуIM\Zk3!sO=sWeNrFS=F(=S+\'W1XlJ.*Js9&$\rNZ/aUƏ`dL?>C|^vs_%W\rJ*fzKHmKYR;u-M(uDڕi:fvM,,z㡫?jk[0}wN)q.٫4{טMg@x(åÒӼݠ5jjMiyj5w0~H46SU<=8p/4_H1h(pA9u^fBSbG?e?q7#pjڥ|ɨ\0Yd_LOC8ky2?O]`:+\\@og\n@jV\"a3(SD摲՚,okg\"$ф0/ZW<.O|aV3EFW^@l24K<\\/#\ZskIGl\0t\"lrM@p7<XD9vi1E4Ѥx,HEUE~+3#㫀BqXǯS\'KzMr#6hq	:@߮\ru)Fz߭w}dpn	Ru`t{pD&>K9WbE3ާ)<KSXn7k=0	$\nYVnqo\rWG.8W@f0lҞ6jZmcbVpFDEG;E440b.(vkNu9_Q|N+GFvyBt@I	/<|xA\\HbXyofz83뎡LȹM*-kYxJ5_*\0P\'Ju=F)8N1՝?jgI\'k¨R~`@9P[)hbQRgJq-E&s6;WЬOu0J4MC}\0혯v1n]血\ZUL/X\nлtBx*\ZЗBˉ^%E.#7_ٿn(~%frx 6o]O\\sM\nT27oڠCcKWUrKpBWR@J^8g`c˰mupa\\|/Jy2fy\'G!lG}1+TjbV\0\"R2qt@WkmxGV͒׵pz4\ZFS\"xң?8^VcÌ?ossS>*C֙3fE$듌!\r&?5{A\04DASX\n>ZZ]Gwe&[J#`	:*geg:yrRi$\rs\'jm]Wtt\ZAWj(胿֐y\'9)x?I<LPSqk訍n!>x\\h|,e0?s4kX!31n7ٵ ,{n,Lmu\Z^΅hU}1}=ziu}eƖE֥즍ә¯U2? IhR&bYO\Z\01Y2&ۑpAU%fCod}6ُ5dkp-i:4QkyX/Iyó?TO:v)ݝ/QXl5<==)+uʩmk (ĕR^HZG:X0z?_K5C]G9Tw*:m\\wW68Z\\\\Wՠ,>,_͸G|<H%uO\rZa|ɋG<+HH4ywy\'hzx\"v\\p$%aɩo->\'^1uu-f#a%bO[\"{uͳ\Zeor<(~,ɜgPR]6)kvͲaT	&We&C,\"}K;\\h$7HŌ8Sy^bo)cHvSn_(aWcʹA`kBʜѮ,2S^ú2K\nb=FpusV9-% _r%Ü-3BOg黿WlMf$۟lT%b$eD\Zѣ0?ޖft&!-U8<Gz<3\0R-k,u׼)\0\n9e\n!I9KWǼ?_IaYOrgYɘ@l+XSZjǛa0L˰po^#qZ/~UJO.ŀ#E5*\'Cqk?R0}<̤. $^$Rtsmskmw޻`.A_[rE]J#aDXt1\\j])k~!+,m^],@.w]N_ cǶx\06QBf}=!Cj]j1;]55Qdd*kkig{usy{%t+ןb512DYH,Q_pf0mq\Z+ߘ4D,EǡGfy5ܟ@n-ڞ-1Ia.}oum5C^6fe:bTUGf6Qƒ\Z9~1J$>I:E\ZK[|4γ]/lBr\'8|J=9/fz<IGj%o$JJj7B)YbgM\"l $H:[Sf.}B;`4DޝwVD{&Vi	FXEgfX<4q.Z64N`PK?C4\\w67+ eN	36M[yFRDm:PYh;2TSY+m=&TǭUpSh#%I.|o/egP\\bvj?{Čנ@S.<m\\,T3y?PԈ+o!hbس\",OƔA%*KqraUWjj:MSC\0EpڎU=\\ف2%72B9WO\Z衣s[**d~%I1Tn\Ze|D{1\0>N$)*P<=	ј7smi+Xї9k\r?rqQe-=TbbL&Y=Ozγ2z!.w\ZFPASӃPlZN!&Qw|c;\0,2aڢUPrYo:W3\"6uxhߠg>\n՞V5|m~s6%HK1|jkX:7\0b;Ie4uv[\Zi\"Ե{|$\rj150CfIΰaBqG8Ou>WþSئ3)]TCˎ1B\"$Ϥ_}G쥤ax=#F4Y[^e\n41LHݩ̨<W`e	U&zտRB=PKqFu~\Z8W2\0Bo.5eo kV뮧fEf$\0~	s\0q(vpμf(b\\	e`hp,-n};F \ZlGⰯ0ucTnUpg/q@Q!Xw>7.l88AX\\)zyu!8Iԉo)\'zR^-M1\'\09c clW;E5+R=x,[w=jClU-wB6PUD;MrHF8j\ZtñuA\\tjs\0b-uWA\nf_b!o%˶M=-bHA|U7jЬ5LX DiU(leQ,	naTߌCӀ#m>+,(/@Хד2xwsOe4]q[CơQ1\\*-ڷoXܽwxr7.|a\\tlu~T|6^*~\\ݛZkuDIYQoj07.X4+g,g(4%fW|Bʓ#y@b)T6Z0x0mɈ`Z4az*xVg2H(N6Z*mcb]Jmu%9OqH]\ZqlhgvY6w&fU\n`Vr{YU\"V1	]98}.@\rf[ɖ&1^g+fV`6)	5Z`\rw1R(!@Om\n.ESjrKuj ܖ\"HI5աy6I8y\0T\'{MAn?%}e\'mWlV%pA9Xc<_:l#(gd@q2wa?1Z#BZJ}P{wvW@ǀv)ɣ,ĹvV-nzWE2DH!~\\ꩠFN?kxI_G|OT:\\IOQ}.z.Kkęv:x5=UD\nƄ`GXt*\'\04?`( ݸyiV(~n&^VTSn^Ey	u\0ci^Su%D{ox\\4\'1\n+IR%f((G`x8\"9ynw\rt<tjJLv9P%ӥ!gda-7)*\Z`Q_{ITC_Aaf2-k-2T4j2\0:0pG&oAMq5@= 1~XCՑ\nl.~{\\Y}D@gNc]\rSt1\naMpi@3#\Zж/*t\r6<X\rIFLKq/ݨv85=\"ޡuPxN^+5H9_r?MΩԴY5D`$BfyISWq؛rcWc71ҍ*tSc\nIC\\vD[CE8PR\'4jUjTw\Z(&=\reL|)aj.}vQ߹S\"yNw}55T3?׬nEfh+Vnw-ro\nÀ߭%.:ʎZLVC6\rd\n3[@\r܄\'Q=\0~F}\ZOƛ^M$˧;ͪ!IbرpOvi럙_I8[7dPu\rv\nŒ+NA΢:W<\'Yr1,=ծDzA/y)wXKHڱFsmJS,˦F?bZ\\|bQkn\\\\4_}12LJk<kVms,U\\r@EdSB4,hܟ+{̗r~aAďcKAjTG/6\n]<E&@Ƿ(\0a{|,\nsͽ٫+,|VJ@haZݻN/F]\0cOJhÙ%]2xJPO\"o/Ƿ +Ra,f6!\\I&C##&=!ȝpxǻ\\72y\'hu͹D\Z\0Tٹ?Q,\"mCS!3Fиd+qz.2M8_6wsEUP[Wґ43\'콢Lk.\0rK\\Rҵ\rE74e9k}S|w{$Iscډ:t:8ц}b;`\'aЯsI%zp9C\'Z\Z}fN_нR@, KtZ.o/ZGpy@1C\";a:L{4\ZUuw\'瞟hQi5z\r&Ђ`~\'\rQl;4V_j %Upr*O[lpTUA$/+e/֥V4]>\ZZɰVL\rXbc#$x##!.EVn\r6u(Tm[Ku\r8IRmA7g68WQB3XAXx\rn#w&(q;67ɦߊx42m:Z)tFec1b0w~{wcj|m]a_7q/\"]$&<Լ	QY)N3$Z,!<!9\"\ri\0\"4ߕml\"WKxI0$\r!L7K3@\"[q˯v1 K&.,Cյ׬N4_K*X5\0ZBʣL~Ͷ7PPF MfdIJ]0֙8p#~\\oӁ=1D,p	ڱ4zή)F\r8xNz$wFm$\"]Xe\"?|2Y	Ōt-	*ٓځD~ٷQ_\n=2l$EࣟvTը2H`oHPOnuDpRֽRnOk2Ω@7 \'yUٙK;O\',zBk<[qj\\-/:b.?swY̞I\rʡ]eQ>o%-ka[4*<3@I:7}.a	̑HMϩ:CBsҀhPla7Kj9	qFCOc#y\r<եl4֬(w	]cEӷn-/@[yz*4mJf-=RF6<p\Z@/b(S;wAq^;Tι[cJ1W=D8\'8w\Z`pY6~]Ž2~xVN=!\0Htz%Ov8Ph1T8?TBX\'i.᨞;:D_=$xB2냙$5)SjrxVH̖X\rmrf6(p\"\"[yB(uR/F(IR-[ҟ1.;\"=1(C]e(O9N-qCVWgKjxXV=/\ZݞZ|^q+DIi]Bxd-|5QCv,?adkVl	@>	8[wt?X扊>V}lEWR*9)7mvXbڷ\'or꘯ϙPXg_~=L[[{\"D`KpUl9=4dyoGuuZY:>gttC!.йeayiG8\Z[pzbi+sfֲiIar!k}=S^\"Ȩh:@moܛMbrђ$ z\r2K=;ƭ+w}Z)[!p	Z9@S\r0,t`2plsW\\h9\Z{\0p5dx{u҈ʯފ)08aIpopABH7MrрMhVyBP#:݇Lx8) JOb\0!X+c͎Ǯԑ8@Ghar6rʂ\n %&ȥ`\'e*`>y6Z-ͦt؁	Vc}i;iEhDݔ[-l+\'2YU~nZcttMh?Dm%ʋd]h!7Jqw`5d/A*KK=Bj\Z\n2~\n\r=a⸬]7\Z\nŬWOO,ԺNE\Z\r7hZBLG+vSd2\Zi\r/quVcx-ll8\ZÚZþި6W2lI96G\Z93Euf\0/\\Tk&oH\Z`t%,Zή>:2A6n$< %\ZBXf\"ԭOݠ%K3ѓ93h\Z42o^iw$Se(I}P((\Z\'@^qR^\Z6$<\rVr~\Z.ۨ;~3vmqu<fr\Z9ǭ!A)\'u](]>_\Z<q٫љȦ>5*A\ZQ\nS^M\0Ù]M\Z`:c\ZTcς6[LBcl\rxR()a?\ZY_tz)8b#D}%]DmyYV\ZZ_(`ۣD&}bTR[\Z[Iʙ`:}V\ZTDn+/`{\Z^\\%kOei:io\ZvqpOQ#j/vL	Z|5Zt\Zxy7{ zQ1+5:#Mu<\Zdhƨ,ȊaܑiK#A\ZKI-A\ZC~#u@j\ZtY-{RV ۷FR!%8`?O\ZJo;PKΌ(?EoZQ-Υ<Q\Z7i$t4a\"~(oF(\Z+C!VרPc5rXm\ZTw:keAh4\"%x.Pg\Z>F9AH,`qGex<e\ZHD%dԨ^dvK*\"Q\Zbi&#\"P_s-\"?{Ӄ\Z;4JpRӗڎXV\\2p&\n\Z,l(\r]kB@?-$A\\r\ZmҴ`S|0	SsEAL\Z\"qYfCV7]neRb·\Zu@\'\\KL82Br\Z2HCo\Z\"\nڋYT\Z@ѣK3GwmsX\ZИ+!~(\ZI{**=0\ZtH\"G4WfGZu\Z#ʚYy>z\Z䜫:H2fם[Jm<x<0\Z7۴>0XϘ\Z\0|WL}TA:x1昘\ZAS[[kn/:%>\Z\'_\ZKGUm0;A򳡆-vn\0]І{lCMvɾ@ƑT97C=]al2i\ZD\"@.hBAtLs\r>N9G_s=\"`v-ǍT\"w_\ny\r\\.yZ3Ήc3m!pr\nN8 +g̀{HꔲȑКQު3WM M)d.;ABQ\'#~o\rS\"2Sm49ܶ7!+|&,Y*l}Jpx5K5&\0CRdR5P,B&L\n^p7rϩUwՙ\Zԧء>vwRG)|/wQOC&/z;]\r}w6Q\"_֭xH\r\Zi Zr`((e;^I/hۙλ\0=jw()L\\]DQ4KA\rŖV\'Mr\Z3DF\'Qb\0i٣7M8Ϙ{:+iQf7Ꜯ&\'dWzғ|1Ɏz\"v9+9w^_efB	ס+찙z|seQgJЭz-X+|@Vcx瘝s|0]QœdHAyx6]_Qv_3Rx}|%DSPɊ4-|~Ql6ՒvF[ƒ,:k$f}C+>!l(vɶP5T⍠!wRLjZ^\'{ )8m}.\rd_n5i?W)b,Pm[4ЛzDĒB:\\`^V=w=\"[<U܀ĵA)C~`\rsT&	| ̨7g+\09YCW-GMdz[g{a&@CfĂI\\@O+ӷjO8g.hLٲ􉒄Ք\0tu@bꤼ&{737ki֐5є3N0P5y}@٪b1po4Aasl6bR\'ha{/\"ru0yLi(H\'v-3*3^c(^U#gphؗ\0J_答GCKǺhF;۔z{:7bc/LV9bar~D,?ѠGd)FAu``mH2>M;c`vmٛڿoۭraچc,=sK>Pסe)9RB[|4Os\"#%^zsc1;{՘8RJʶW/r 	١$-s1ʎSPER_S\'DF<B#GI45MCgY<-bO,w[r;l~Nppcr(:6eJG7U]\\J5\\N(-\r\0U3B)38$\'?ipOd \n*\\*e܄9G[d:zS.iuN\'uIXuM\Z|nV`- /RoH[SZeߵvesJ:ZGl%fՄ0AGˎyB\0u2+YGXI/II⨡{\'UGWC4VUA4~&&@G0\0\ZtaBU֙ΟDzjҽf!O_X_j\r15-Q_Y\ng^ʸ\"|.[wwq51DjLH^t+?\Zci{íq@:[bdl9ր,ܱMS,elNr}6f.x?+S\" juXF]Kiǐ*2٦~EAvA$gn\0O!\"j:(!b*C\rz\"{t\r uMHs&.cD0IΓ0T4(/$z<@IWJP\nT^tۜEǛOg\ZXPECno`+ilI{aEA|]-!NŃK\0tXV/Bae)uV-%&LxLӚn=f6;cT@P8a*6f\'ɮD=I)^sb\ZZ\nS\raAD\"4}mhhK@s޼mJ+ÚB\Z[(M\\sVᢚ=mTtOzoM-Ted)$д=,7݅L& v3+kCJI\Z<\0P>%@5v%( JaI\\ѓHO\'\n(Pӳ\nr	s}DI0..uZ{|~YJbmLh笇[\'{0ɞ1X**yhsluʒhkFNʨ\n,U|록W\'?z$ëŰ4\\e\nX5)aTԩ %2Ryūi*%h%$)`v:#f킣%\r) 7e6VrE[mQ4nx(Sn\n;y{%_j/,htD)WMF4~\rV7-K@mȍ:UO|صe-/.xd\n:xA-H>Jy;<I8w2A	ڸ؞02yK|_%d`29xmlQW薕U=dZ	ʒcWZ:wP{6Ly?طcI\n߾B2ߵzՠevzCrM}{gsb(בݱUKIC.,d[:d\'Y`Ae3;yam#lf/ƿa+RJ3ƘU{^qa%IBЛW<VA:	\Z4c? ,\\=lL^<kLsjҥ?bɖȒ|B?-(+xd6SOnF${W\"k\0߫\\`QtMOpPIjҗ:K-`UMun֧Z	n,­^fqFo]BeIY\rf6y;6\r)]$@Ӏ)-U<^qX_@,_f+4K6_ɚ&k(s͕SpzәҒI/cUȫd4BnDQn+RJ1ej6mtmv+pE$q-\\䒟EYj+,D5;%Xrcp3}Z\"-<e6q+[{s1\"3d9ۚTD]sT^ؒhuk|%`}3?M±KXWMEX,P 6;\'6\" ds\r=V\"n*R-!`CG֋م\"^eJ6YNDK\Z\0zf[l6BF\r^S`qcydݳv8-]ÊRW\rF\0޵;D`5_-\n|5.ް8!9:%\'&;CrAL*3q8a\"+ʹ\"[:ґAXɄtNXK@ZX熫#]$\"n$Foef$S4C;wVR[h\\o(5OGmשե3shf+JC`ßɬ#-\nn.#]>4I=WD7[|nz6pR¡źU4&.\0}UJ5}&JmyNL5\r\Z0s3B.\nVF3)? @D.tOSnA7PmV,utm;a3~.3R}^́@Z1nQ)Cl6W^\ru6!$0KJ\r22ߖ]Ó\'L$_9I$e辢=ɽ#ɾB@\0pcIqU)8)tu\"\nNěcY4II]ߦ)NޢVB nLc\rʿ5	8m[XsNe#Vr2BG3u*0oBǯh }CoG}Bdg!4\"	j;1cx,9#txa2g@$Dɔ)R\Z,&!#͂R@p\ZMN/r4[@92\'q.;FrP\'l,%DzK [+u{TD<g1e^>b6chNE4#\\GYZ>>4Lja|cj%HaZAQb&YZo>Qr͡CM$A,4a͈PR)ܢMsմ9Tղ1Rs\0ll*\rJ\\QZ_0_ZãӒixEއ5|Q^2\0W:mE6l.E_peNO/*mvȿn6*zoni9\0T9\\>$2ݲjrwhjI^%]8{/4ϼ%V5PIʵk)}WR%#&)fz;U?:lmY($V,oǉ֘\"](qMTUЩw͙CHN\0I<v6$-ȓkZOp]\"r5SfE-8\rJJ.  e..OƏͧfh_2E~WCWXבh,rە\r$qd_Y_T.ZuiYk.\\{g:FhdaGI\0q׹a\Z\"D\'ϰ\Z;I>)$pi\")l52żOr\"SmRӡ^(WYXg$OE8+iDj-}*3yXZjoy\\oC7[.F=ߋկ9;T>gQw=usn@=]N1%P0.\"NE{3e`|,斴A~2:^\nGZT,]ms;Gra\"U7@pJE#z:e`,Ǭ޳.E%C\"A\Zk<`\0áhd>Xy2an٢QC[pTӜq(%7NO2zXK\'47uQ9`\'	wx\ZW\0&a\"w##be\\f2TP7AdK&)2}\rpb\'W1Q5[ۋ)\r8۝5:?*)K-G,v$ ]\n1K$픹0~QdTlNH*ʟtmɡ1wrBR}\\ʆ3v\r$lnrN!EcZWq85qr@7G̑贉pPS3&k_H֮N^L G d/K_F7	boPf$&(کMt8$PqM2J;!ުr4[SUs3Ҷ%IVRۘ]7NijR\"~RO|⺥fZvMYWHkI=\ZQjEǟ^Bh>6ESXzgO\'ǈe]yie=^`S:\rb-\\|ۃ9Egf]Hh~wwO\0LhD:pJ̺γSy9s68q\'o	UN8UW~(rMڠc4boT,>\nu	U`.9>Y3`yk6dz\n?qUg0\r̹Ca\"n,jtt?j/&b\"\n<5.Bzn1YY]}{6^\roʠaXܖ^	2@Бw&:\'0O2| X`[Z76.-*PU-8m@e05\\wMv1.ʞRB<|ZXבeMp	7d[?Q#zRfįytir\nLpMՙm}\ZH,RqxǧIK96\'Gʙ$[~\ru|DϻjcTxFw7?D?Fa\0^ͼi7drSI@WG\Z2Ւ#*(-@h1+K(a]!5?LQ9$+㺏>T`AlI\nDR:[_I3ywtן#F3=22I8JpL]]}0n?)asRP\n2Rx}푔9.\'u{tF`KʗrO	mJUP+ߑȚmX逦ڄi-O@e_ȧ9dcLeRvQF7ixދ\nJrS5btLȒ|nS4$KJ!Nfm+OSQ\0zfxHNl;^e~k>vP\"=eŪ@~P 5	!-e&hN+/?Y4^ 4\0ْ\'/XMK,f\"*Z$4 h%\nfJ(UZu@DRzC C1?dQȂ~c*1ߗ o^enȤtv̇{y|u? oIڞ\"04NϨ 3hDrzP2n>} $#LKKa\r2zBj|A58J %W7]?q@Ѵۙ .,2F*z&@;`x^#.W(` :kYMjxRցִP=T_U~Q Hʱy4BW@c\\JqGC Mc4@?wbٳ{6\Z4:٠*f5 WaQxD2-q%ol(]?A ZI|,Y_=ݥ)ڼ,\r@ _0g WX\Z\0S  ia7+54(X\0ٌɺAY\n l\n°&|\"wK~30,>P&w m2N8a>BdLUoVd^ ntڭtBi%+J\0C\n&4 xỤ\\_vLc27RFNHI]. ywD+`ӱPJEvN= fHfG1O2Lju15th0O \'Ơ $nX37N<g YL&> G\Zu%X-) dNЏ|j`(Q-\"%qz\"g )>Q|	]vC, 7ćK4sNs	Q<s| *ŷ#r&sR_2.;(.n ¢~&cǶ$IxcQ# \n	\Z?`%Tp6#IRlR u:i2۝/Yiq ^67+k`ۍ]BGp pԖ\'/2KjרtEM ӌ[*ktC`x{c!ՙ\ZVWSst ^ּ>W5LZ4yD/ @W4n*tQ`EJ))e%C oe,	Ň9SyK\0> \nʃ,%]b(ѕ)) toA&Бm2}4xQUF u_w1DOhI O#>ܬ+O-:;>28]s: \ZyÌ{o+	OmQ\'Ova	!Bw픴Q\r\Z-1O!Tvα!ڨ-Ohc.\ZH6!ps4zQ$\0!)u^)h\rȱ>uOK,hc$!,els\\055.fOte}!(dTUᬦw=X$!.o,1$	iXgt|!\Z:LEԮCrO!(Ц}EC\rd\n!3`DTdk3Z26}!5AR/{CaF9Z_t%8,=۫!:\0%/G?6஼re_gax&)!?U!)lnUn(\ZǅFZn!Pz4Y-CiYk-\0nb:a[!ZmNxI>W>%*r^#\\QD!^lZO5~ӚK)ƿHCȄĔF.R!_m~avHkњ$\"{w.ˊh!_P?m3^9X\nCWG\\N.!debK$,Tb>\r4!i\\ ׌eQ\0rz.+;\0\Z)o53!nX\nD!Ao%j=m[<;0!v͚dQW^>n^_ayLI{!vn=IMM<+%uϸ!\'o]tJ:soT!Y|lT%ZR/dAy*mZ!x6^q>F70VֵV>>!$1ŭ95\n2d\\aW\Zq3x!:qɴ&gz68֛d;tV;U!&x[w)ȃcNSa!>$wĜF\n%`IJM6o(!*/T^zdOԵ?T!7U`^:8o_:  !&to(afR#Mg{+A!5Aà~I \\v(cF!*r̽y硌լge!!a)9&Ǒ\Zx^1(٣Uj!(\'eЎ\r804@dD4KSkV!aZU/<rg$R4gZ0l!\r;m1ϼ.{r6@CHc^\"A!ĩtXQ\"ђm]2J!yA!CIJ(,ޢ^\'7^6B@vM!y@pmH=2-JW5\\3!6\"\nx\0:p^P0vc\"TYKJ,/\\/ d\"h>:Q sikZ؝Ew}b\"1ao!GMM4a@łfv\"-<pa@ 7٦\":+@b$TAt6r\"!#/vꢽ>8h{g铩@Ye\"!+F;QHwAh<!\"\'Pٍ\ZP?R+.-n p\"*@ߺzf61Kp(g/}\"-dNN63P`ʜ`!ڬ	q\":fnJ\"-vSX^\rˠ#\"BSC#Q ߜO(=\r3\\Y\"EwJ#ԭqBeM1H5j\"JRIx9Wn\"aԙ\"L0]ӆ٥y)UeP^A\"[3[@\'`$IpE.ҹS{\"$0\"\\&S^\rxQf\"^-5Y0Y-m\"`85v;\Zȁ:-f\"`AH(UMHls\ZZ<\"aҖ>fٻVu\\`\"l1sǄ\nA:[5i\"nNv?Kg^:mBlbZ\"{\"&_Q,_x-֢0m\"+f5f(gdC<i˳]uƨ2ļ\"9y۟\\^X}*>aTX@1F\",=Xt>%/\0y_`/cx}\"$l}eX\\%\'AJ\"	.F͢Y\\gFy2\n\rMZ\"G$@PĹ\Z7~ԧOƦpdb\"):ze0E8=!7Ӻl<ZP\"/JK}uvaHQLE\"8꼑O8[8%Dfb\"!zFۺ6&\ns|\"B_J{k7p5mjY:R_\"e۰})sѓʫt[\"i/V\"ʊǏ5\".Mp-zx)R.%.8\"xbZ͙.=BNcDgh\"\Zܚx^ڌ	u#Ѵ\0k\"،V2M.\\e#Nȡ>.:I\"_rЏMDZNa\"2e܃A#Q)\rj|\\rm=\"Lp6-@!#^kYڮXVFX65\"=\rB>\"H@Z#XVWΫ\"80#>nylvƩrK~8\";z`~g^_R5т(#\"[.Av\ZzAIM0l#^3yw4=$Q/Z~{K#ğ_ܵ?W/C+UKG#2s\'|x,q´ޣ\\\"\\*dq#Lj@P\\Eȼnx$Wҫr1پ6}#޳&-hQb%˩z!IY)#\Zl5Zyc! aZq!{,#2;#/7\n QrsE&]IeYcg#6Gkee\0ۚIޏ̓\0zN#@^=}l5@Wsa	#a V#AX{V[sاv\Zuu#C?=Z\\N-ev\ZwGU!J\Z#E\\tʳ,hmo9Ŀk}|d*X?o#MZC7eD/wfkip\\#Oyw;pӿzw,!:;umj)#SRm-zşQ\r: QV#XN?$xZsװofz],\ZRT,E6<k#fW*o_\nU8_\r֣z#mbTɸ=V187>#q>{~4eڨ\\MZL#_Ӂs(sxa{ۍ{A-##2Otd+˘iXdm@\0\ZL#1f J\0Wh,SA9_Ѿt%#̨wA/c[&Ge\Zx%%=C[a#gCY<bIV?Ji^aUB#yĽTf<,9z,;P#ә>ho/>,Fm@`0#g#WVCPdvJ\nBo4,Q;#Ԁ2VX78t jH#B=<΂nj毇寤TͮeR\ZٻA#\06|РYD̰أwty#xꂍ\\J[UznC8]F̳#Xt0!6ћlFF#M+B*TvGǒ?oLJs#(42L{]{˖e~1\'0#BoKmuqGKL5=O#r1k	I	^#?#{\0b$0g_%*<vt,Xѥ#Iwz{t5ma: Q#V}驛F\'y#v	׼\"Ù6GJ#]=0\n\rĞ^\'<$_-\'8uPc6#	KEum$\\SJ#fdGΚЯ\r]\r2\r!$J*pg¤ysr	TC$\rܷ2ݓϼ+BɡQ(-$6>lI{Æejg\n:eR+5$Eq<pQ(&{=Xt\Z\'\r~$ r{Y4?뷝P	QU(ѴS$#\'b}$X:cľm]\"V$<\Z6J=e5q>ҽ+mkF\"S$?\ZW7m(w{K\\۶׮jt$AB|5&<(^5t#O|,Jj\nh2Y$Cr{3;Ln,uw`7pE$Il;_W\Zd۩Έ\0fm$XA883k.b4DZ쥽$Z2g/I4%Á	UB%H$^W+NN	һ@yA$G+Z[($h/*ÅZOx+-롖HةTE$j^2	ܽ4`QQtyTr\'$@`X:W3ð[;!ؔh$V&<% 旅.l㹯$N	П_40DW-pAZ$g)î^ A_mGʐ)7K$,<7j3҇c(d^$p嚥\\jGێD<u9OxlF}$`6\ZPG>SҢ\'z0\'Hd$P1URUb^4$}1(x$}4}bl#NLx(ȌpW7$?2sȉFG?TC?EkBf S$E,_wMJI:W~$z({#?\'3/Q)$SN}T#/\r{+(鶶$`5~VWClZ	|GN$۱lЯsF,ųeIx\Z:>;3$v!K}PRadC evmjN$С1:kf\n#7L(/jF$AuU]-`~7z~$]:)~KF,B4w٨/c,H$ԑ<*Y+`p_/Ȟ)Od$Yl<yO{lg٬gә$՟!a\\ކryXͥyAx3$QH(NBQ#Ⱦ|1/@$7pGQ]GxN0X7n9|$`MHn#<K*\re$LްA,\Zƻ5b^<=S$yLtʁ9bzDLBt$`j0ɒc1-K@\rfnR3T%gERh,uxxǤ@%[@^h^r$G<\Z3xDp%%klf;{݅T_<{x%[4d%>NmCsPC|`	ӹL\Z%JgJ]E;EB:OBbB%LIf͕}Y9&yH2nh%M&Pǌ2oXpzp\nu(H%S3BG\n9K\"Ufq*Aj5\'ϱ%Yy\Z@ڤ~&Ǩ1#2Qi׮%[	kdT95|}-U$s_W{%l}pf7_N0yڔ)V%nMǮiD7@qV#vE>TCdW%v+4)%Oi+adgF2!T+%{ܳLgyQ>\rP\ZnHr%.\0\0k[w\Zd+K)*m!LDB&%kr _SpE3%s Bԣ<rlB4إ]%ͥzE_&!z?#`+~	`%?\Zvbq]g5Z)uѶ\Zo\'0%*FJKnP3iݚU91CW%nk_\ZQ7Mϐ#5?%f3qEb<r]B[S@k1\'b%Yx<A!Ԁ	Yrg-s%\"Hk,2 }ڗE%>fXJ&Ж>Zy2p#%07s\0\'zM|:9#h7dJa6!\\%ƲaU>ZZ	YD^@NN%%xg 9AS:lL>xF\0n%ւr\n3B/\'1\nzt%ؠ̓?%\0nm6/[lC%8X_Ҳ%$9ٔ*_[%#ބԆO(P\0TV%%צ\0\r<Ϭ_ay %܉`nTKxCt%ޫ+x[o{\r\r&Xy&̷-;בuH\\s!5\0&\nuOb&\"Mf?+AT(M&ve(*>֬(>[1#2uZ#&pj+Ҋ%s<\\$&In	w߬so/*A&**sׁ)?\'=fu3͈&8MdP	oO}QDU5Sb0%&<uG1/l\"?Ws^kE2CBZq&Ek_;ۆ?pƄo+zL0&F\nA=+jBM6~(DK?*w2K&J ѴO|d),)	ɰ+\Zt&OUQ}}l&̦lz&Q^\nSSu\nhfR\r78t8&T)\'4:\"vt*\nJ\ZR&am{[>Bv\\` :nwc)ߗ%Z0&j1D5TeL@H`/Ys@E_&kçC\n,\\lMQ>ЦO=_1!&q45O3.A2YsFz&vi#yH?4ql,xyC&|O	g)2*׫7o-r?&!Ῠ@x#idاKkuj&[on laϳtWLQOQc&0gp5:H@(۲yH&yZen_&0A 5&Ès5d3)d,\\6<->&ٖ`#tޙ,Q)D9&t*2~|1/U8VY}$&ny/q[1ʡxپTz\Z&uz	:NmG[ \\U61&m4tXF@RʏbL&Uǀ770\01Ѵ`OY-Ms\\&$gX	pj	*4љ 8&жdII28!.!е̼u&K`29O?3U{`2YH:21&0i\'I[gkYg̝w\na	l\'_CpS^0\nʑW9#AY\'pp\'l_JVSu8VHJyC\'dKeʾ:;1]S]^!\'DĂD1`گ/5)F1\'+F.}M>W\nwJ]}&#V\n\'(\0*Pg\Z$\"PHG!5jN\'0dli0ky6|.ZL]\r._\'2.JY.~I_H\r\Z86\\l>u(\'@?B{uBti\'S?\n=PC\'F.1E)H;l/.n7|W*\'GLs\r+QN*+r;_1Y\'HPbqq\nQ.8׌M\ri&h}9,QE\'KGԌ`69&%\0M|\\y\'KFpCA(^>Ur\0@r38\'S{<?*f;/{\'v\'U:=n;iK$XJ{Օ$ت(\'Yax}삻.$2\Z+\r\0y\Z=r?=\'ftgx9I8&l<	P\0\'\rQh(3\'jH:RiMFpn2A\'k7^Y6֨{J/՚ɺdN\'yDuߓ>Wvd<U=NskYp0U(RC\'HT*#M%GLR);ĪGs:v\'[v*<w?_@;pXAUI\'D%jQS!lt!,A*\'Q_+g*drVǠ\'*\'ȷC\Zigh7xL)2\'%Za@aaI|6J\'pGg_P@EuE-jbc=H蠕\\MW\'$1,;bL(˓̰O\rMgд\'iZ\"Ʈf=DFG\n_B>qY޴\'*ǋw)M>SY\nS4vna\'MSV$\n+8Y3]c\r5z8&\'9_eZhZVa釦vu[*S\'N9rg_TȻkBy\'q&1,SNj64cG&Z_3j\'֪*	[\0EE*JrVsc?\'^5j%Vl{={m@\'sh83[ 	܈3wK`aaqB\'m/lr8*l	=$枒=h79a\'j*,A.+-Tגּ*\'-i_ᤛ@$0Z7hܕi]\'v<mj:YvSG2mu\'xrXk.~b5ǟ<M\'/a xySWo\Z|(85@)Mr?\'*Z\0evyW\'!LxtU?O]ˊxB!\'gmzqgS\\|z[SZfw;J\';\0)pf/AC?]bǊ.@)5-(5\\&HFI7l24=}`jVBj4)(:MQ =ߪyyLޢ(Cd?hvҺn*1ZV(=XtwɬD.=H\ZS\Z5w(?߾nT Z𦆽\\98vW\Z(D\ZokUBO)Cx\\iMoN(E\0	73/>u0AH*$\\(L-\"}7aU0-=tTe_(M3SyYzkl]AGH}ё~M(OH1hIL`~աUAܵA(\\ðw0#rF߼٥^GAcw,t(_{ޫؠbr,cl^ajZ(a8)~%cG:~\\\0p#tF?(fp\\3{?\"];>WqB5mo(h\rEAO}vF)y{&}~%(nssTj+<$|rE~(tGLF=hz\'R(\nxi_P(y:wj51\Z!`<!_(}6͛\"$#(wye\r63TQ-YT=G(Θ\\n lpuꑝ&]yiJ)(ک\'ޫQ\0آ0ZC:(kɗɌ0\"v e]]k(bI}x&pz؃,%q(3\0)\0XG<Gs(ɿaV)}џ|^y[9(fqiIp,K(*#DG*g>I:2(έȸ0.4oX~k>bj(ǒr]B*pUEu%l(íļ\rC	vSKO]l]t(sqr?vgb棳ߺ/QB(m}:փ{Fi\r~^`@2$(Ⱥڛ!=Lv]uAۋJvxM(Jj$/f<i6a\\KlOWz(ڮwS4Blq`8zW:5HI(f\\}u, oGeZQBd;(\0\0Y<#>d0+jw(rbg;5KtΚs)z4phziTv/԰x)m9C$t0۴H@&wOp)\r܍+GM:jf\n/t<\Zt)qm;K?ʽI\nqKqeͷ@)!/PdtO;DCᤉ7P5)\"N0SdPOj锏n;)%^Vt_\"L&x?.Ҫ*|2OQ))nNpiMO+eP*5yjXb)HL{GN\"eYHt	dE\ZMm@˟)JJQ%x\Z	r](R`)OyXK\'AA}a̣r-hķ)QF޶cBWk!)T|݆S!G!Wh\r垸?D`)Z\'sA?xsR/ۖ$]X)Z!YٍPA;]n)`Sc~m1M`\r7o)aQOhС/zàS\06`)xtQdonu5Pa1(^)}VOg-w/^w6!E~5On)5BUak7!3󇼘.v)D7^ޞ>?}4u)C{#n6G/V\"?)4\"m:D[:K~>b1E()<yt\r.kP9u9)zuc`lQn.`\ZjRdY)}qNm\'!0Joq,T)@\\5rK\r.]p)IuK/%(F/̼ҿ	v\0^߻!)!eФR݀zgg6эl[{)\n[L5Psm&{مrmD)C)@4\n\0/(ج{:.3D)Q1٪p$2˝n#[z*/	*?|)@ ѵvP4\\W*Y\'-c|)io[G\ZC)Eϳl\rhd!)vIya\"?@vpYAqJ>)~JkȟiK;c(HT!DTnBt**b\'G$Õ^ӟʆ*&Sƽt0*X_\\:̄wMO^9LTr)UFt*Yե\'yieQepJL+ޢ*Q:fͥD3?ZfHy9ba+*%ҹ-m\\(<`}yx	[l*.I0PW\Z\Z?Ow*wn#ח/  s62*, %C$ޛ?+߰4<R!,*0?\rYoXd	:@MFI)*:9%.Zb!,Owq6/_L*@X1iᰣ+kOOR8\rkʌn*MFC:)q|]\0\\ϖ=\ZAM*N骱wju\r3*P|˿(WaOBAe:+*RNڔ%>+߮6n^wj98*SFPrSRk-RBl_J*^sJ^1@EHٵ5EW6>i$*en|ӗQDU[M!B\ZX2Ugy*j4m3:P0\0\0O9`*k /YlI>CK:xAn6[*\"Yвe9Zt7b[fj$*:sm\0*P=!A/bHḛz*mҰǕ(ySlSXL	3QnT*ԋOSƋMnMZ%NdmeX6*YD>)k\'YO+j*UY2F*(9͌v&5d2|ќo<v8*j?tPޞk$?,L# *ˇSoSS ,byKVB\n*ѹ{|\"ƥa6&	lD`=ަ\0Ur\"*࢞˱%\nԪ9g}QL8ᢸ*Y\\r=5p	Ťn*nTHSaQpGegz*.C)iXF89ю,*XN{Dݝn$pF*n0pd5yw&?^8;N:9*jlJ[ĸدiu*_	*wVS1Y\';n_b6*=^t2\0j?<-\nb:g>}*6?ǶFO2HM~	c!+d\'\"S+ȵqCgr#Uz+&ùoEKnK4lBL2h`3+sfhI7q z}04+%<hat>++BPxP\'\"XpThw\"e+!׸4aڵ(N.G0+(Oi~.I%ƥ?\"~Y之boQ\\Y+(S6%iOY^+u%>++d\0wR<=8)\Z&gPo+@VhȤMy[Z{+EˎR9KB$\Z5ާWd+I* \"2:Gflp=+Kc3<]<2Bs(9H+LJc>\'W&(S˙@Zv˃z+Y\rV?vYrqK墔ϲY`p\'°r+^Hu߲֨nTZ7+k!o}>VIM[ݳRׅNvB++p>?9	v=M|+u i\rnQ\\24eK9tM,O\Z+UMDaHeהF@YV`^2+Yik&x}ӔQ2m3Wk+kd\Z\'ȍ,GwwqN+̢/nN p>I-NabwMWc9+%O\r݅f\ZR9uRw+/ th689|Ze$8Y+ZP2lv,,2RV~I+\"\n\ZɁ$#(;#R+<\ZXep^1JH|F]4+CpdR^ӻF#b׏UԻa4i\rѳ.$]+Ѹf9!\r(\")kjd+Zr\\azk̧αk+\\`F~)?9G}B1+<([}n\'J=Y]2+ Wqz\"[נ˽_{+c}(h7|Te?ʰo%-,\rNMd_z_T3$7Xc.5AX,r[*=ڗs@Urx*,{,XمWvY9bԁ\'7 }\n,_ּ +%$G\rK?,D-|0jB&6CX݀<I,#|xIh܈G:`3{_^c,\'Y*8$C#95dWGN8,Pp?ǆ::vM!ܑ,_%U?{*k\r?3ޙȴF,aY}PR6`)Kfism ,hg8պLɋZ:\Zí>7,l8Nn\ZDl1s j:{a	y=SgJxa[,m\ZrbJ|&\\\"C8)O},v䯶X!T]02n},Vn,ܹ^]7S6n)G溪|,~8׿K3k.FP?R()ojrt,I!g-AW}-`5A,X)ENž]0z>/9͛r ,1^7\rx6$\'.SWF,!\\u|1;8}srE^,lTѕ%P~Ȝxq\r޶f,A&B[^$NΏ<V`ۓr,S\Z\rz˃]Ӭ#pD*tXk,gE^\"5¸6FO,JNf_{irGoR?,,)Z\'fR0Т%\n0,ڀ1f,Ms]B#^X=d`,B/EԪ.\nWU&e8us,gmjk>Ui\ZCdݚNS^,ԀJ`j0A\n*LzG,oDhjXw$Yǐ5v${+,iS~?:5^:b\\BGQoz!bvE|,=hYyHo81@b52,㯢/z]_Wpd.f,U{+bzb!U ,3z*j)2(]Vbl,\0Љoت!ū\\0cs~,V[55+O3ȥf8i,.Wj;Ee,7	4T,^nY/b!TpJU˿7gD,9ٖrܕu*0þsahZ,7j%~ՀjdwϜ- \0&_K:|▴,Yȴ4UTđ-HrQB\r=@*qZoA;Q-\nrhx/tݐk[=uh-޳wP8;sY#a5J-7R1}[namb+(c4ǽi7-7bkٚA53gFEk|^ڒn^)-z̪coi)2rz-7v6y5Pu6@~c1ո$-#;ŹDoIYMAu-4akO67ZޡR)&~	-;i\\3.\'=Ϗrs\'1\0<-@g %uON\\}@lf\'-Ax:g;)\"@Zzʦ	Tuw-J}/*5\"&\0<[&Abj\nC-QFk~JD}KDE2[汿m-^v5Mwy(8G4ff-i%]AL(4W__ȯ]`Ac-s5,X\0[b3C)Ea3QT\n-u|5CD`磩QrG)&-yO\'$5hLh<\n-۶_)ʣJ>w;|`Zna-j6\nT1d\"t9}Dh#Ϭ=-$\'2nIO<ܠ^oPh\'-Z>X\0]5(-ܹY0N%}-99\\B\rVեȊ(xz~uS_-HP{cܻ:n{2sZq:7A)l-8j4TV0Y-R܇j-MaODBT@I&#C-w@j!n2G6_slW}JS-iE@罷0\0\'\'w-L\\Z%Er_^nniWB-mC5A-ӌl^.ԫ;	><;nC\\-Վ$\"shHpi[[-בt!o_!\Z|ʓ+Ԭ-ת1:c&h	ֳ4VF-ؼHm!3\0=Mwx-,%nb6qs~~-6bitQڴ-,h8faPjgW>q\\q0-kyn:Q2 ?x-vw\\yU+.$aWݕ2.F-[/!!ZW_~H-gR>?\\1cd.(2GKzj\",55+%{	W.D<1Z=VMܟ|MSqį瘫x.~\rB|\\}:tJsfZ.\"wk~?\'L-ʅ+?.(l)p8Rc6p,LX.#$.N.\\\"Cuj%HEJֈ^a.%%،kɐTaEQdu8ٍ~3.)y\ZJ\n*Fh,TTuԃ N.-}@NT$UPBd}!^maA.3e/\r6tXiy^bW~s^GvA.=Wĸ9ҵķZ\\%Әd.JH4?/9V~PLϻ#\"-/I˓or.KnG\'z=_ĨK\nO`r9.Z=??KYZ2\0fSzgG(n+.bV(CQqݬ9B}J]6N	,.d-vۺŒ#u7)ғ{.nz]̿jtD\0CQgU.{fZ%{34`zo<\":qe5Ab..I)6Zn)\"6\Z]\r3CFZW.PA\Z|(W@]qnAmp.^O:Q|n[c32k5jy\".)G]C{.=C+[p-R.Bx~Cd\r(olv+k\n.4bP2t}BAڰT|͗׹aC.e0\"@4Vft ٢:+F=c6.$-&(A/`Ln`\Z>.N_c+		\0^ds.ƺHi@:`3p);b\n\'d.@keuQDRkofY~}.$4ZknK\0M5hÊ9djf.G9^-R;*I6d!nz9Iz.5\0mx\Z	xY΋.n%5VlOnk.SP*6;]XRCɆ\regf.йhdBiHɀns᝗\\O.:%q/}!*:r\Z^E/uC;,!0AA+Cǟg23/0\rZΣ\n	1$ISuwt1%{/^W)H\\y=Z3%1q^QdaH/<E=C$xBHxJ`Jw/&dxG:IVt͆YjM?R\"/BBP{fZyfL\\;k3Y/ld{\nCiHjUPs,/5`qRYj9sh(V\Z/#ׄז4$ǽ~r>-h%8X/+cFusuwfrg;D;*-/2/,b2H=XӲ\0DNb1/.٘ÇKv\\)wS//5+Jm,/E_-;(\0q\Z/41mP,cmrAۓugM:/5\'`ri~!!W;;_\n,C{/70/!BsݒoBͻe}y^/8e^Mja[dC:1qT/>wi`S{oF:i8/>]PN\'|^⸱ u韆?i/M4H&ol=|@uQD}Wp/P6GY3؋rd?l۱T>/P~ĦczV \\ȀĔOyi-F/T0FM|u]4d-r߿7P/_9^`5JҼ,YajKEl/f3sa-\\O!I`\"D\'uJ/iޒ\\SHOcPd[/o-7`Xf$;,rӍo/r\0ДbJx!*ޘ/s8[9BqM٧ZS{#EN3vua/v \'I5R/^\nBR701nQ=*Q/|w΅jRzZHcxS Jb͌/YlezIGzzss=\\}/GyIda6ܢw/rU:uԖ{d\n8,);7ej/ԣZg\0cVץvdZ/-pXX8Gl~c/U\rk=]\\\Z#x~\n<!/	43sx|\"@-8,^F/GO%<\"!5Ĩ`0<hCJ/\0NKoʩۭ詡{ngg/|`zZ\0^\n͎#0\"\0@/ldK$\0	\\Dj\\/(wJcG:/mw/@יw+cYV2/XŃY]IO/)˲jtS+KUVSx\\/?<@qv4?rcm5/Ì>=Um`!98jC3]aff]f/ɢ!RLZ>	&>D0vxq[-yrPm/FA@TZ5a )LOfWRl!\"t/[6F\rSO4lދb9/JtR8֓9HdFأ8/SVS4zlCoӌ\r~/OC\"qҌ$,1o.99+5?<N/NYA-Ruj>Fu@X/7\0qe\nO^0sԐ@7Ty/\\YA8.qevGEw4ΧOl/d\Zօ[U[`{,2|1W[̚/rL F4,	 [IQk0/O<n;\0NL\'čd\'v50!Q+7`G#\r)S<\Z{b0C?Bk\0\'́<ג+F/&\ZC0o7Ԃ؝^\ZtU:+0Voj~E`L\'\n8~RkbZ{s(0.nI5C=\"nu:z0COܢ6YyK8<GTJ0\"PPy\n].R{z]\nK$APB$K0&#b93LC\0vX<cɘTX0)5iKejՈT|F$4t0*Q>Ώ$:Uj01\ngε_/Szԧ*4>063BA~%ics4z\nY\r/V*@cc0>px@3G@>EZ\\::h-0F6^ʤp	,wR}nlDoYDȌ\Z0F8s\0N\Z\n~pOiD?O0J;;Qx*,Uľ<g_;o-H0KUzl\\	; G3#?\'a~(ǐ=(0X!ލ\nB\"`Á6D KP?_0X73S;\03m&)$K>7wtT\"0YJd6/4mqM		*Iʀ0[nڕrwe&E_JC䒈0iG/+UW3Ii\r·8صS 80sa`\"*m(|-=9ƄA@0}$LG8׈!g>Y9̲>0(<~U-t.&]%/w1Ro0*{N&9i]:;nkww0i\ZjÈ~3~NU0Q9\'j\rpWCmg0bu+<0x:׃!f햺o}PF$<٧B\Z!Ms0]1A|]96j&z0~q{֊=x򶆞\'M3I0gк}bIYwe.G0pʊR^=Yo(a*7`0N77\ruDeJv5?0?d\rrե%é]	ws.0pm;Շ-vdg\"s0,d9ɘG\n6P$JC97,nH0 mA8^Ě\ZϙJ0}E]Pylg,:|iJ9Jkʋ0o9אð!\"LƣF0o*ke@B}Ӎ0ЁnDhu NO=\"C47}G0G/L΁$CZ,+I.	=N{eNr0!(UNAj%&EoPrAM0qeR1:\'QDuhVwχ0\rXyq\\d]jŉ: +R(7Η0ed sXQ83Z0?@\nQƟq0	2zRo@0YiѾc1ˁ\Z[^r0\rHCx^\n#QY4NX0=|j5ACD& ux9cWI1\"߉-Pq!F]蹒16uByȺŦjFo1|gC	\0\r;1O7qqj1\r*h\\BoB}_XD71!3Q*\nX}(bz=./1\Zi|tl?u,gL\r<7\'ZZ~1\"C[Rq( ˘@g?1&ZV0c;dClξP`c1,0љLv/\r>%\"1.+;e&IF@ЄH(\0?#^1/pJVQ2v앀]L9e?4J10m1mh11\ZBcAPPAiT15V^,gK|#0Idlo15>7lTS0\Z\'($̙z!H1D;JeDv\"gxu޹QCx	1E(|TVc-N¿-~zn}.1K6]Lݲ]`rS{Ul1\\^8.ljЅ4x]|1]T2J\\+	i6SvS,E1]Э(P:@n\\\nPG\\21e䅁8oNT:w8<:1u\'Y	/%\0B\01-#$p&h5hJm9m.1k8w1D\Z2,qʨ]1qр1Jλz~>l#\"X1SP^&! !\r\nO6\'R 6a\n-1H\"gyц*&\Zb&fK1_X#/I*DN|qx ]\n\\t1B}=\0)	㊢Gu\n1f@g<g-vIP8ၳ1׋0*E3:/2pկ\0K2^(10\\E{F㣟ZO85;41l\\RaQQU=bC\\I\rvp{=1*z+z6(cVϙ{Vշ16s4>gHTs*NVB1\n	Tk5t{j.\ZB5$V{2 ă`|K 6<#:Gׯs2/r7fK\\қi:YO2!l/`2=}rS~U<<IF	J2%0i%%q-:96Z9W׎}R2*7;8+[Tw`23ـV5l0]e&fQi25ǶBV7jb_RnC26?ô%I8#AaW=ҀVONhE2@:Uo+UJ7˄&yScj2AWB]b}cޏB#2BQb9L\'͛BBT2DlyO_!DFjF^=-vQ\"T2v2EɈzvi=8OU0+J~w?>2Hs|k-D`]^9c,2Mp=B+6A9 =)2P!g;7T2<\"m_5?	22SLb{Xsǅ*@)Q2WS\"M?%]RLԦwC+0Sˍ2i˷ si\'t/Nw.yE2j/ROQ<w`rѽj0<[7wC2lhmN2o3c\\yr0C2Ҁg2vziM%\\Xt#$e*2{yC$%BE;4>f&b=r2})vD$t2.P엳2AG8Q2YeAņЈnIX[;ͮy2=ybB]~+7EGO;5l}2F3rv;Ĝڰi0L{?GJB2x~vKos=ә̳<ún2鵍dl\"w%,}2%bSO5 ]	Lfǘ\n^2ӆJJ/CC7N֍׌\rji2#@z}+>eMhX֏r.Dp2,f]sXs=R08uGnOZGĚi2c\nҳZB5^DaUȷ6-\'GcF2Ȳ[+Wˆ-LA{2hwRe2MmQf!=s*2\"!-2Y|\0~I3\Z3[I2Qr	e^!=ȜT5$C.­\Z%֭2ؗČ_g[)@23>,.2SUo	ؠѠ]S5wn2-;/{Maޏû\\uy2ٹ<dI=@M8>4c!^i N2Mx4Lp1r#-h%XG3~5\\TB?+m:e>lo3033<}c2NɓLbsĂMu:^6[3=5Lc+7LCVg\Z3fKfY8~Dh_驪%*&zF0-3!\Z=$dx;$\rEgT{\r3!2U\'o>ZLJڇv3&9/@b6-\ndՄ_N&1JU763(J{*\r[ܽ}W3339DkNd\rF$O2>acc;S3A\Z=qn\"kLEI?e3E!ރXO+)\r^gPǁJ3FNAxYXߠ-qSHUm>I3Oj}.j	^W/Q(ϿиhBC3X<fD\"<(<(?[)\Z?3Z:2$FyP7bء: yM3qZBN\rT\"X@Vٶm8p3r=	aԅ6~1t}k3w	qmMY|MdLJE3z̚4tv*e3yZq\'3i刍Z++<A&n?%309-śz8JP7`W3|Zw\Zh|Be5j3J~wUV.gD%ޠ.P	<Q3jS2TZyb(33A{gh胳uPbWfiU ԝ3ΔI!ṷ(Tx$>?3Yv[ha4n>=!P;ai3oOnR\\쓸{|c>W43B\\EuB<7qy(e﯒53DUBf0dbkTJuMY,N3p  >a-z<v\'83ǬR2ڇP]aLzpO\r~G[)It37H00ԭ*:>a_r`g3լKYCX-kg9[۳҄3f\\ucF_{j݅eiol3m)>8}8͟cWCx32/ιDpnXe\0uQ\nO#G4\0ީXGnw\0#َ4܆S]TrnUF0\\4E$#i@=!%9(:cltL4\nOҩi;Vt6\'@1IȋW4P\Z+KibEWВq`r\nQL4\r(HO_)yJwL4K\0$|%ܰ^qB۱&K4 $~Ānj -\\!ZU\'Ֆ*Bc4,jE6@9&YPd4-;*B_|TB !\'o\nQn4-\n4	NY.j_M]42b`g\"r,L	Kό@4>;o?9-V7g̻!\Zsa4Lg`|iR鉐6Al#4N0%WWUShtCa4RG;Wzl;21hA0S~	;\\4R;23[s|\\cQjcTx4We.e>uɑyVc@4XX(ayIDZ?:Yf4]ou\'umNZV;KejW>T4^tfX9#T<ٌRDuhTQ4gѓ7G>\\JZl24igM\r\';kŮEQ:4C4sk\ZHD.MK{\\a\0%24UQ\r1#_fH*Idl4jU0FՋŸ|W#\ZShb*x4+nWH3CEK\r4_,kN-H<:i2LYkve/4L\"S8\neV2Tyi4H}AC{Hh/}sfY45rs3IFy#[4%C]q@m7kDW*_4P0x6<69ݔ:!4UEKV֧%$\'HU\n4tKti\n%J9wvU&GL4]]@w:yٺX)%ǀ[btbsm/94jnqn-xuj<mO4%_^^[2ɝis.Ǫ-4+_[qpv,{l4ˁY2˽5Mf՞v2,.\\~4V2hк1f/нq`!4\Zr}McP\\GϢl8E4Չ\nѰwOͼE7L{!Ix4U	\Zs҅hRnzxg!4(4H7y\ZR0xsRV4ݒ_v9ݜw\n=4}P@o<kZ<+R42d񝴀4ʓp\\z!\Z#,\"4\\gckH]?jJ͓e4G8ԞWy0ֻovJ5]ŵDȰz2xX;~Ĺj95M:g5x=hbC*ujH|\ZH58u_#gxTጷ7#l r5\n֚8qW@CHҘ\\eg5c[/8>8g1ZnBȥgx58!;	\'9Os&A3XL4oP5NE~3#jI\"G m5?DP::#lk:q7@T5rDpxKv2WJ5IwNezվEs-M$g$5\\lÅʕ5kod._.K55#_D؞;}6]&]&ig>W5$;/mkz 𙠓pA5&LTt3L:[%E皿5*¨Po;,XȋyE[~5-u1:U_٧D\rtٳ	$DZI}n572cN~\nkڍ[P2I2R5;eDڳp0V={P&F	5>!\'Eogdha%GVV4ݻM5B`DSx|4q|ҭ^]5Cr̯/S/X?׏D\nQƚ`5H?%)JzI<Y6WJ2Id5U~^cc>LQG\ZA\'[2fx5YY+W4~:j/:ّ,j5YK՟ꖿA1u\\,[Pc@.m5ox~,\ZF<H5okB=:XsH~iME,2H5q	o0X\nԏR_xU\'֔!5vWvls)(-2RWMHI˕~|5BS®j`ljNTZ(T\"N5\'1NQɐ4$C+G5ͱhYI&BiUI?ґ56XGa|xq[bIp*5p73aa)I>/@5	XxtB\Z}OL=\r6I5,8ͤ|x\Z+ΗB[n}R#5<8SIR\rAssf[HD35OAs}7DO_Un`[gc5dhJ9b578BQI_.R5M#nґ6n3ss#H8345(b3:H[IvfFV\Zg&01awq5ՖHʬPQrb.e;s0K5Ɂn vǒZo*PUz{	.53eakh!XhO\0P,O85ϦDUclF&z`*\ns#A5քocꚚp\r\04<y$\'5҄,H7Y.nܭ\nSZ%5f`dP&r:]ﰻӏzW#[5`mU$0%H%W$-/ㄭ\nJ5`Hֺ>R5EOI5􄤑\rB%v|nh)5$lB]fE8f,}pQqtBZ1O64]p@j#\\-qLWi6/\',\0I]Q	6F$5d&Wӳ:.́DytFv,6%\"\\\\4N*F`Γ\rL*=6]֥]xEW;Z*6߻T\0}п/{FE>m636ϑ?d1eڡ9Ō?w?ICz68ό̝+Ժn^V7)z	6=G!J|Gl̣8(xH,Q66G\rkH:\r,6Yէjh=Q$rFa6H\ru fREtpIUwf6Tq\"xv&&\'; \r<؝6XW\r2Ya\nND;3>?)?V6]Q~3w6nx@,I}i6^9UkhZvPq\rZZ[о876k>׺	QHa[ב]{9F6lǡՊGUԛEVyu07}6m<g\0{tX)U4N4M36pq\ZM\'(i,3!SN2ݟ$k=P:$6tY~\'IY+65}jghy:6RPJÒ2]bD\r\0JnRiZ6%;[0!K3GfṞ7(%<6}o\ZSuS4̀n\rh6\\楅Tb{)p2u,օɥ!wlb6?\0%;541:r!oN#`\'O\"]6H6֌lVB@4I圫\r6]pt=VXڦfY6g#TBht{C4{bA6嘵h+2P{/c\\6!s\'6fHs(r@q	6J۶2bE{\n)_Q[A!@ۻ}6iyqG,JO5˻6ɕIңMka_G#1m6K(OG%)aq/.qƵ<46ެ 9 UvM7wUk\\xm/6cѴ%ͺǴu9fO6ռ|d5l¼g40\'B`V6E?)lk1>[3M\n:MK_;t(6\\\ntÝ\0`6͋&)nek\"Sh6)\\շI-\'EK-f.VNױ6UmЖ%?MSA^=X|U7֗]|銜Ȑ\"%⊉o7FILXh7ISXeiNn&役day7\n@3l,UlL԰XfRuDYRsm7Is|UXbuǜLhJG\"7MI.-*\r7ȧ\\ݱє@bdx?7Onm{(=ߧ&I	P79JhP1L\'!(֦E˷7<^_p* j\0p̌[7)J2,\"\ZV#b{7\Z>Q;~ogYF7.IGJZ|8yF7R|ϾQҟ	GݭJ7T1a}嬡b#,%[ɳT7YRV_WI8NsȌi$yhU>7]UP*2Ҫ#bV EXj7b18!U=ɀm{YQ7dqL<z3q;V7m0 䞤3ţK7\nFg0bݕW 7nvhXd\"͉Jڈ7qp.}a\r`7nsB}@Ӆv7􉞞D߿&\0,\n*$?<׻7ق\ZE.E{(YKhd`zk7=Bƍq$\'&`)NTMG7R2ڽ\n=u1:=U1̌#7=$m@	mDqL,1\0T6U|7Қ^!L#.ut 3v!\nAEa,7Բ:pvN !4t@طB}w\"7ۍG-( H61$)T*\'ܭO_A7#q$TT)Foe\'&?Prj%o7j6gK\nF-s]~LH7=^P\':eʬ\n,7\\ڻ\'GM*ORu\"7A}esىA}Kƶhet<1X7@lDIR*)UҵR&\0e7|&,SWĦl~e|T5o7`3ΨumpFel&u8û-tڲ\\)!k% sG\08K*}\"}uaک}#V^}^g8ػrQ\nEAhg(P8;*w.lv^7F׏\\8%W#VqF,V_nCy{N>=8,geJ\n-Ft[nw|8/)=\rU<XJVE84د,X-i>X< .f`iPb8<&&EKxbغx&zW8@9e{Ӎ#ңn\nYփL8HZL_\Z?\rbĻ`a9#ffw8Kǖڴ\"-??,[{/Ou|Ep8UGS5lrx\\)\n8`ѰMU8?i$\"O{8iOݾBu\\-@8lm@#.o;O]+\"k}8n`bzN~eCq׈8ngz\Z,bT@Um@Ъ~x)e8o0;ৗPj둪9I(hm~8q9E?	*6%?<{#8q*hA>K\nC)jj	~;48}\\X\"M|&(^7|v,8~/S#WUD~c9uuTv8-%s`NaL	LMʫ)8uvߜ_0-锴񢷧U28ux:+H\Z+2O)ڽBx8>i)\\\nWx3vd8\'[%,-Yl>Jׄ+:rGj85]̺ՅP:1o#p@1P詷8?D]-4~d#sW$}\"mn\'9eOv.S88D\Z	h;i_w>%-8Eۍo\'=#2\rpq̨n#8q{YmU~3/pt0\r#8bn^f8<$`x5ln>>8!S|wrD|۽Ć/R|yV8ȼ?$[g1N4}{YKJ$C908}=SZB}.NɳV\Z8ړ1b;0eR juU``is8z>_(zg7/B?4Z0p\0Fs\\8E/ůKK\rЛx]2jIԐu\rkz8~K[MXчd>PgVEnam8u\r\"Z[9I^?T=8lږuHk_<$ϲ[9X\0,8]%-a^t4灢E]պmӍX9\0D@a\"tQy`@s92gK:raW;\'ӎ192GYHi,AD2WL 10b9>|yɮ,naS>\\S9FZHâ̑A*K𮶳ppCڛq9I<Ra~Te8JG,d[Js29Kgy3T:U}JG#f?m9Nv5_/9mBB9P6ATa~R,~F\r։+o)\Za0p9PŠ`8_K#,lSVd*6T3-`~9T-Hȏ :91S\\\rb?FC9WGZDIM?\n}9TDmG\"9Wm\Z XQ?uM\0Gu7nO9X\Z?\"-Q=I<%h9ZJnl+;CG;	+0sf89c.$\nܒ>qEӑh&M`XJ9e9Dg2[Oe-DqTnoK-9f`Ewo{)Q1W<ɋ9pmRzmAq*Z3V\n-9w, 2hITX5\"`[9yԆ&/AXHi{b7frw=m9O<@Y緼Li{I?<9^cC{קTlz_89Sx]f(kD[Va\nI?m93ԍ8Aϣ=謵V؜9X0`cNazӜJT&3U97TBR#[\rO:K)X95V]*sꈻjq7˨39%t]Z,ԄX0?*H?N(9{iP㿻j\\dQny-=7?O\r%9$GO.v<Rej)P\"9k7yVcCUys\r3Ytݓ]A97kwI0 *uzWV(\"D9æ%!bdV@O GaM㾨\n{d9n~AbHcx;Bo>1<9\Zø,B\rͬdν_ 9J|UA6@)Y>$Uٚ駥6b\"9~%q2^JD3]Z4qT9]6z*6ujL\0<)+\09$2!躏uΙ)\0Я9qBYaهsdyPù(Cl;]%:Z?SjMa\0yJc/E#8s: NVN|w]JӥU@N:\n1.V\\dS=\"E,vv0|:~U@&}\0E]N/\'GYb/EQkD:t:\\:YF	q4h:`&6:R4,7S$<P\'\\GEvrSfk:cbQ|{Mk-|Wm\"n(#U:,J!\n2)\"NE9IZN8&:CI%BY\"^=EL5ΝA):HIW ]-(a.HM>HBnĬ\n_^:Tr!\0U5̃Gt90ȳR]n0:]}j,N_8u8K`/%3`4-:cY-swJ£f~7$$?82:k6ZJWj?vA^a-YE8.,%:mq&m@mS\\SE]ya:\raۃdɛ	,u\nWeYtUW:	W[_Omҿr>*y:PD|T,hS9h\Z4:O3֛KiD--*3K/:j\'}!}DD%X6D:\'\Z?D-Sp\'Lo\"u`p:ID%Ω9oMZw29:a-9O4Bv]p&/\rm6|ޭ:I.OHmA(\\͚/^`:me0i7Y,<Yވ-|:e\\+l*\rV]HO\Z:d eU&\0WC}>a4:ЧVTM{\nO7L:馈xt[cJ=\Z\Zh0:,$VEΏPܡfc1c,֠:MZ^RQK`6S|(,:R[-7ijn:`VA\">cBtًu\'S\n:Z!IٌK[M:\n[vg%Gpa?>m_k5:U#?_jL2S2UH^;R^y]%a3_);te;\nUFFZ^/^7>h)N;(6lcf/V?!;Qx[r4}`ZNSx0dX3(LƷ|;!1	1sAqSY`N&q_b)o^C;\" 2hO_gNNaЕ.(o,k;#Ax]ޥEծ+\0qmM;)@+ɝbq\'*aiQ|ȹ;*!//<TN3x	҅%#;-5˩mN&c7|;1C̀(>\nOM1;57Q#I \nFtGa;JE]Nj.1*EgWM;Wͭ%H)w<~D|7V<J;dߩ,Zz^uXј8}l$Y;fx7$p}ĎJEDӰ;glSɹ\0G,i8M\0;q:\n@5=$o;qf%()cw$Ad[e;rthؒVg(eg1AH;zmpKm\0\']s\Z)MR!\\U<;\r\0osoB>Ô]ucrբT;j¨9~ǚpOQKU.x?`\';\Zm}gO_t%nȅۯw?;0f3+#\\*_~*X\\.};&<Ld<4GF;uNn73\Z(	?^]5.7k;0NU-\n$ΡJ;чQZ[h^2u*;}8wE!$2]ﭛ]D;7DnRWN4@Js`I;Pֺv}MZֵ&V<JS;ϟj\\%zv}d83e_;ԸPI@?56tkN8@=4;;C9a\nS5]kݳ鷌^;Vx5/*=.I~\nD2;خBX]b +jGݸƖ^g{9;ȝ)wEp⸼H/R;mGRV{\"uǹN0;\Z+gE p;wG;琤B}G#G?!*Q_2;@_M-Յ,(gBC\'4/;]A(1x&̮^l_k8c<sXD;\Zzspra:<F࠴\0D;PwQtsρ<\n#x]H_Y_S,NL00Њ<5ꩺպv\"Șڪ<:G&D]ԃE3 	uݜt< `2!l~sDU=TR@I<!{]wfְz=~SA>nJ<%HF7$iޘt4%꽆gy~{*rL<\'<\'[Oe0Րu!X	g</u%c$)#cD(]7]$(</ʹ\n۔F9#uyk˦<7+nXM\"d\0=Anw<7SdT	{~}&(94Y_S#+T\Z<?ni6~ϊzӭDzm\'={?63T<OG/&l\rx*\\wXX%?5e<SH>xɁ9|f2QνmF<Z0|rAI~}	jL3ڕi=<ky\\bD\rh$o	aBǒK<m2[gC|0ڌ<x:wLdd|G%N=s<{AkD`0AG&d7=\Z;*ZKO\0<Av%yH_\0Wy2zij<ES,&.U`EVfb-<\0͐$5ŵǙ![G7]5+<ms43p-I/8\'J }.<H.<1zff:/|5F\"<^}<P,vuSk53lD TZ~O<k{=UnQ \Z\0KI^VxbX<**Ju&9p2a-.<.xnEej?\'o2\Zh<:-Rr{<Q+k5GNh \rƫ\"C8<Ό:9/(\\֎tl]ǳ^82<Ŝ9};)gXfD`JFЇX<uUGS´o&jdXS?5l-$g<ԫ!q2{Q:΅2U?<yE2֥ VK:J8\Z\\\n%<%G]\re);^%G5f\rpt/o[<\'^_(˙v޸q,!>8uRU0=x0B̢a\'Fݸt0}Ԋ=\r2v>L	Sѳb23fճ=qOvHbO U;\nA8rʋ=>j\r;|sXRL7ŦS=A@5Ӿ;\"vkkaϛa⵴.kgE=\r\\ZqѯMw@m\'xJ=vw]Y\r+-<1\"n=%x,\'}<*puXpsH#r=1lGLXeQ&.X6cyfkb`M=?-\ZYA;3s9VѦq]Ԫ=Mbg`<CX6.4x§{=M챾֎ml	\\\\Mpnu=Q.$*n1$ӘᮔeMc(o&a@=Qsf#1\"C+3b5|<PC=]\0D_dW6CY/Ř+*K}׺f=^Gj̣+`R{Z=b,N>CMfH˵8ouW=c!ʅ֩!䰇b@uh=eIqRm\\t`h,i3=u2;=|kH R=u=wq:\'`CL,IHEǕ\0g=|D+ff2h%M\Z\",{ E=s|բ>f\'[}R_=,-.	Vs!R\'V-qs=ڹ\\0$[#b=$H3f4DVrj!?=O1BVl`<y|RAZx==M@},JFh1=@smiNmÕ6iTjQs=88:MDi,IEaRt	=F\'O**EbQ\\7˪03=/_{<X#]#@]ac@\r=JbDC:\0Vs=Dʏ.^2D=~JV\0\\gk5w!-9kPReMZ=\nʩ֡4Yqz;+sTv_=ű(NbiJ#wf_4+Z=.	ە &IgCq[OS=dtz\\IgN\nd%?8e%`s2I=Ӡ-R 9&7c$_l>}w=u3w8C,glam\r%a=\0td\nJeܐZ<sn6t=R\"v>t&MG(ImyF;=,;E1ĸvY\\`ît=`<0h\'/̢\'t=<YAȚSgDC?\"=Vc7lkd>\rF;n^UO/~jFe\0ՇV=D>Fe1<k3Vǃwu>%Ԧkڃ3ǡ,\r10#}_w>7f:Y]9B9n\0I\"Jps\"O>\Z]ƚB̏Xvذc.N2NҹЯ>\ZD6:Kjm֞\ri>\"8*S@-bH\"aiEx>\"eY-:037,jO>#9`4}>ca&,#5 L>W1(dQ3s$5+s[&Kun>[\ZuvzM%YA?>Kӭv軆>pE;A\nq݃,(2	>rf	/lٸ$\ny+b+0ZH0wbVǝ>w;Ҁ\".H\",8[	)%(>ݔ(CvA|qϳE܉f\r>@ZHӐǓ9)W|9^~>M,Aak\0m,D>	tN}%7 6>3uBjl2wmPk|>+1XsVTC>kWoH[G.l)簥0>]1\\?_)uZHԆ6mn>\\FMQnv+c&pX3>ͩA\r 9I ݴU9D-jy>(g`3k\"Mdч@bE>[5yw}6uGF>WkrD&>rSȞ@叏YfN>PTϻ7r`K˒#F>ҏ4G_)MDyV>EoG0W^ڭ>&in\0Y9>xf?)SvRKZnR>gpH9!%.Ύ\'oxLp>ԹW^;a*qoic>e;|w Rv	Fx\\n-eu>+ލ^5vU6,d#?m\0r>G+GY/Cꕻ܀6r&?	]M.nb4sT+H?	X<[dV?	s,@_Pɩ?ڟ>!dE_5;$~$&Ơ\r?) wYxmN#\"( 0wiIٹ2i?K26Oڅd|P>d? \riA$h_N!:J?\'Ѐ|8i{_z_)-2=wmowС?+îAZJ2s%o+?,guV-Ub<eAǩKN?,şGЅ#>-Q:?1]ijZҦ\nj&g34s/ ݆?3ͳD[qJŎg*hY?5K϶jB *DP?4^?<hH.{HQxo,ù4w<?>ec2uu?H\'SD><56̧5c#_{8cf?M;\"<(Ϟ ѩ?IB>ە?Od6Cu>Jrhte?QOxR\"&Z-Cj\r?_6b%㻧֪KxLb͟?e+9ھvۥsLƐ?X?oK|JSbVz,C4?w@Q׶wT\Z06\n>=h?NPf`g AeR^\\PH%?ٺze9\Zr[d\raKQWz+T?e%0EmG;	cPQq:n{ǂA?OBu%D+.n9Ba?h]0\0	BLJ?;o1\r!U<PnDQ?)32kKJoQh>\'yhx\"\r\"B?O//%NW0㍕M4\'3F?;-MH\'NP?REƎ2_ۖ4=\ndp?yQ&a?C.[,BA8&?{U$Lofb\\^Indv?\r۴<~S1.QEm?-KtdޕvjJ3wV?`{W e6W,\'=B9?YꝤ;ܮS{Bv,J{9?(6et\rV\\J.˙k;?W^z\0Y*`\\P+-Z lo?E4@+>~_tev\nh? JimN\r<\Z@$yZΤT+Ifؒc#pC@vPo4OuY7jѤ@s\'b N9E=оS0V{K@kX$ΩPB	=PS@\'~/yKP@B@)3	V0w9~]J/D?\'8K@*5]Gր3)A{Aq@9I}f1agw*k\'*#@:xcÆPVqt(*@CARA5P}%bI^C3@Lo֟Gj_x0`8C{p@`@SYKf%6y_0MI4Q9@SzqqOJå뒙zy8fE@UJL$)\ZO\\|bS|oR@Z=sX/$Xv\0uy8=7@^<۬\'=fn+~w;\0@`7ZǛbvP2t@hlqҀ@ei@mfՄR<<$E,?7п@mfjمնo#MR7 N~]@qbjuO ;x\Z{%y	*]@s:ҨV?QA@BLOo֍)fJ@u |-\ZK\Zbk^R4hMΨ@vKިk%~|``<5P.@xh7k7(scQ(E\Z,@yˎ~S|t(@l,f~@|INAY:_I⡤a*)gF@~bR鏒Z^g4t\\E[]x.@ll4w2lq3P\"@\nfK{L:z2Ər%D0@F3\\;e0ہNQP\Z@ny\\gGBs5w>l\\k@;ExS\r=KA-py@\0!\0,:/퉔*6K`@@ɦ =Kwٸ\rk)\\Xsʑ] ܈@Q4PlN،F!K@Ć?kn^0rAkir}?Dp%D@΁PcѴS	ʹ˼x@\"ӗ\\tߥ;K.\r \02\\i@,(؁UUėi4R?[C@%H2Z6#yU4I-@X\09QLޖU\Z/\"6sA\03:\0,ߛ~gѰ\\r,(@\ZtDA$0jg\03dhfGTG)̷!A\Z39b8.>=坼xؠ	A#	m@obm{p1f	S}lSA.xs$z	Auq\\Vu;-+A2!Dؔx%F	٥OYA92!Z9^v*\0D8\Z=Qy\ZAbA:(xʶղo!VGpYkf/PA;ƒ34۸FM+O/;~[jM4A>]P9j|u3\nA@V/sn^P5h\0\0\\@4~e>ZAB ݤ̟|{5tQ$֑JEgAP\n֫Tbc)q8JzByd?MAfY\ZcČbe`D1NrdQH?Av{/Gg^6~F\nĖSA	AzCGFs3ՍO¡M<Az#RH[`Y|Җ\rxҬA{}Wz4\"\Z,s,W.j\n.A5Nkj(W{l9XIk.Q\"#Ac76QN^\"Bz͍NA2,0F\rv<qb9&ǰs&/AZ%6PÙH[h\n@ <A/eʣP3sEbz%xK#TANXЬ:rf?]FO	Ƀ\rAư_If50x:xAHg[rG^kΘi<\0Ajڱ]Uf89byFvw1$eAU:·1kqHvr3MAć|iqvWj^<w\'5AN~mDD*W \ne\Z^Dhu]A@z$zYumpܔ^6/bA8OвOzyK\Zt\\Aiߤ^fW͊ßv#\ZgaA\"0=15K,j3bQzWJ\"ejFAJnbӿv(/DȝlstA)6.k#a\rUAe[	v̛3kg\n\"݌A^KU~szp~*`AQB1tq(5 G9ߔY·?AK=kAA%%㒔	_yŧiAUBLKNS\n`$TsAtx</YD:=o	uA)_bKAzg&k:pٕ`A;1\\-r14Ŝc\0#AdůP.9+-mmJLgAcs1f㇇)3+[y[0At(eo|K]` }kNmWNAR<K!tDJN]F!ƚ|\rjB\07r\n75HτK~+DBoB5}\r}dT/ШȐ؎,B?IӢc1.P&{v	RHsBBI\\ccx|c\rwHN,4?B\'&~l7u㖛0\Z7%\Z.@B!!$ケք!V[]ǐQ\'B%$<mMtDf]iA.\Z5JB&JP:olG|P:q_p!~B*/zn-TfYzO|EVB6jX(O;\'No(VB?]̵[zH2JMHLNBY7i\'~e.隧!JZFMBen\nD+B(&R|\Z8<ވNBq\\uM.ejfIߨq@ 8}pZb\0Bw{(#٫7ri٨h_\ZslBxdK׫\\V#\Z%4$q9MBF$b$.-zFneM*/|B<UeQm3Y\nUrQLSBV\n,O{Ƃ9Ң,B?Fq:_=k3BMZrDgKZy{!dVB?֬U6pA\0~\ZFBBE!+IB=;7+Z.V71ZeǓtFB.tɱF\Z#={?h3UB<\'^DyWo~fSfB(G»s] Ofާy9IBdyت[8GF5}g*D6B>.-3ۊ`0\nﷲBPG;\Z*ЪpԧW;+B<=P\'\rl5hhH@Cp32ɭvCcBr;SI\nу<˛+D>B|f-7JZ1B$O\r6#(B{\"~K&4lm:㽪i	BR*8ŘT/]s.9T(BU\n^EFEי慎qdBۥD~ǖܬB>\\_EqlOxy\naB\nġ?}VxqAaIwA\'6BaFǐOfpњq	BIq0q\Z* Z>%C!lBf!!VpJE\0$Bgt<#\'g&\r4&9䰖-Ø*;B˛G{VgVF@4S#<BTX2d#GCUPMrpkzCs(P&z&42T\nÕd.rlC6m菛ml 2}$\\A/Ci\rﶤ*Ϡh`>dlC>0,cJvy욓(T݄ICN6Z:cz15(Es{(MC\"K+	J#JY\rlq^C$\nLO\Z{NEMd~eC7g>֨\'={D4.)p2C8%(@i=5&\Zc^[Co[eeW0)CFNCDeAU4.79@?x#ĶCNycf$):ч\\+2CQAFFCzR[ZM`Gbf2ApЋCRHǘk{-]$V\\:׌%GCU)YObpͰbn45\"\ZCc[;֏5mnfHZ.&LCgI芩f8RWUS6idOCjCR $,#@j2\"QRSþ&Cjᥥ-DX\rHKqM`oCnUc]L]Ģ6C1rCt[P9o&іcvCǡb;CuZx3l~%@v5ySť#e=;C{\0D*9&-]Ŷ4\'C]U:3<v=\r\\G)Cvm9)wlNd?>oCXKY;hG\0K4U0$g\"C4)iǌ<1u\"CO5XW	NJ6C]ת.7fbʹo	$LpDC~r2B8\nInnCH?!ې/u}yC3(`e#b3Տ~;o4TC	ۇC.ɦ3/:\n3CoCXRХO`ƻG9\nCjU#HL\\Y%\"rS{tʪCru|K3ޑ\\[KcE\ZwC{3N7}gwnSI=5W/CyԊJDoHy$+|C銏`	5.?kv6H,\nbZC;LqQg\0Ex	eKCOW%tߏY|&0V\\C*$nPJC%^-9^:C\nH8IN/駟\nE^zoC9~f~&%{	7ȡ[{aOyDTҜ75$&[o=om	pYv\rn㩍XD@qyGP@0p]r/CZH]DsexdzV}co`)(qGDg9ե+ww\'YJEDXD9^q$Q є+\":,DI4GU`~\"۰L|aOnDj07q-%YRKUD(Tu}5{ \0+5g7`)yD,]繫2q|O{ӂTD2Pwr8IeW})sn\0D<X+Zd dizzn8D?j^*{2	Wc| ]ytDC\\N\ZK`ao2LJSw5:LTDD68s\\!g\Z01=)F,2\'$^YDHoBT\"/T[hN;*wo^DLSggݨ?猑ϞY1ћ hDT?tF&xC@Y1)DgTR0yDTZU/y=*JpZ\n.@Q^}DX{L96Ef=k=7:#JY#sΉeDd;^kZS$>6kzDd<@NX\ZfHyEKsiDd~=\\?~ú-\\\nziDj/hҶ.fj$;_O	Dk52o+פI0Dp\"bPmEN}^[:qfDzT[(1o|\nT\\\\Di\"Ǟt۱R@8uvuDTE)$Gets̮E\nDq3<W͵\n\0KІ:JBDfm] NX2CNDh\\#U.M2i0n&͊\'D\"KꖌT+qr9tJv!!D5R?;\Z%}z\0)r`D%}ImF2=(\'+AXD\"e9VIm425CAP%_D~}0P5%+TUyEfqr\ZDƎ6SxhjﰌG]ii_DU;F=dZK/h-$X#DIǎwΟe&Ag.PѺ^ʾ(Dþ&=D	o{\"T1\"C3U>D\0wVvRwo~MRD>alR \\qi[@RDܘܚ	k>9o$#_onjiDTX6_8T&\ZUc\Z~@Q3gTDq>z}D:g1XsR4D鰬+6!orLiʦl҃Dz\nr#o8]q˩8gwD\"sIln1dN?Z\nΜҧD\nDKbu4iQ\':-!:	2Wi\\DN-I00?4zf<HnDإη	ێ}L	$:n8YހE|ls$z3k)bW.:})F9E\r_\n	%ܑE/]ԿC>UKkE\rע4/X!3~\0]E+[JJO¡5v[$cJ¦	JE i4-E ²}_Bb 7E(ڏK\"y69=a1c30mE*h5|y;f\rka퓤~NrE-g9+	̈/+n;>Ea	E.\\D%kz}D8f8b䆖sܐE08L}qe%vB|:hwE6&d#TQHh+\'I.\"-\'\'kE73~K\027r\"U%-_:E8-j\\˹lf]SaE:kfdtps*H@+I35_\Zr3E=C(b}7{7$;.lOWJ\\SwE?I\\JP_q(yF4G\\j$M>BE@̣Bnb8ϜNW%EBadnF5fbGofEG-=|6W +xA0Icq_+EHϬ)mou+Q\0b\r\'iEJVU2b7jMy8]nF}Z?4EUd6I_GSWinblcݯ\\EZ<|U1\' SUAPK2\Z*\'!E[\0RmP-8tNWzkwă8bE[{24Xa4/ٞ\\VE_ۃl\\*ud&TUyKE`f;u\'wI$0Vo0H3]Ezl۹	:/ү~($E}ZnՍ.G{$X(jyqo=E^{fXl~$\\{z\0D5E6x7nojah.e5Eu)lE4觏篓WzFE\'%Xm-QsĊKebbXpbE;L&ͿWa6^쫝QP/E1&km{\0ҒtnɿHVE{޻ͿR3sCmvVE-8\nuT/§Ώixr& 3E|@Ĥ!1j<]Ĉ 3QʍeE7ϳM!+-\rG\\l>ŵsLVE<|\'Ze8!5h{rVF$E5쓦ql^onF2uD;EЈ\ZT׵$;QE0Rp4RRb\\`a1&gEb]qul#Qj,RN0Q(E!!ͥ)r;n6EkS1$`^EĚ0[/*aEǰĎpbreO@E5QL4ĀM&(E(vi\n.Kw\'6QE]\"-@Yb$~\ra1%F ͥZZ(5JCk\"|dwqFǾ\'T%c*|kȃu\ZNMF?AE.|s`jFkfSGK#:ݒmSk%FhޙHmkܲ=F;(J0Yr(Nѷnm,FwسY=!B\rJ9F!	P\r\'w:(Q\n=jlhjF&`\'\0oL;fodھQtnɱP[y*F+\"2|+FUÊ;YIፔ}f}|F.Az~G-v^t^0\r6<ЅfhF2Lq\'s?~8IJ40*=\"FFK$Vv*4?(8!P;=ĈFI[<p*웾+N,^]:l]OFOV3\"!kPFVїa6yp\'3]\',FW*#a\0;+G\"{9\"nkAF^Fbh2؏MA^frCFt@Z2+Aw	<J\0ꄤF{Us+6 pR]چa 	6F}&w=4qu\ZX?F{WB!Fky&@gGfVyFcȓ\r`F3ri]$`LMF4*P$nu9s6&u͐~gFMK=U4Fá>OhXf9FF֍n2J#>@7~(x@E?[&F4O֖._%d,nSEw\rFLW|<$$W,-z\Z6F	Fi֊>_!s3y^7.BrXFKiV-_j4:n>F;FNF$و&`\Z<ɒ=JZ޺Fy3n#;FPQR/Yv+&KUQFY?9esݪOa\0Fzgsf7BXзIwEFuh;Cg2,\0nyBJAVFԟJϰj׊1Uד3Ȳ6$.Ftv\Z:;`jʠBF6jX>z2HR\r1K4plFzH~\"O09ep\ZjH\nF!v4;d飧sĽX=͞k.F*\'\'v耯*z9o58#DL[hnF,r;3UD9fDtuM\0FRNJFaf?w;^|)U-fbF!\"n=2WMw!_YK`G٢LF!ݿ]n#25G\r/sHUEȇzo橧G03XqYBptrLG^ЗαtGe)\\GnU>)_\Z1d/ڝ2>\ZJG\'\0ExjL+\'_Q2a1.}iƞBG(3&K\rQGtc\Z[.XljG*|Y M}gn}`8O|~G+xڍaȴѾ䄮C\0B,LwG1;3^	 PO\\[ֈb&q57LG=z\r\"O#K}DI\"9/G@cyI,p ޹=&GBTg{yÈCI\0\rGB#(>+:Ծ\Zh/TGI}?\Z)[>\"n`CcfG[kȖGRt--S铁ik]G]˽{0nّ)mwhnmTC&G^P[ְa+䂓݈mg ?Gsq\"qk,&u{ni>mGs}꣩~V/	ݭ[:Y\\Gt_!HXЫwcqe6>TkGwW\0I*)P\"}@<нPG|xl#%,Cf:G~x%퍾˳>)d(\ZBNJ!G+8vͮ1g*=^5V逅\n\'G@PȃU! 91XYMQe \0׍`G?}o>UΌ5O*q&+v3\ZRmh@GX	\"\\4ֺ\r=xGgr8,Bc]u_a\r̊;~GW\r\ZG$7iD>b^Ϯ4G.ꃺl\'4TɚݑGĳYqU鄦l\"	,]fC\"sG\'Y75Tjd5:X}{G[\Zs%:fw<ú\rGH{p<ZtMh`KALGXB~c)Yf]۶_$R=t\"Gp欱|#Ác^Jm,%\'-GB<.Z}aBl6$\ZÄ\Z)>G_PWDJV9\'\Zd%P~VGN41gb|_u:;ߟ%RGc`B+91l%S;8B!Gm]p\"T25k5/q{VG,z?|,ΫME*OG:}\\\r#}guHAf%1h*#\ZUEUh>B=rH\"`sÏ	|W{ʭI_1TH\nJ8fj\ZEH\0ItYjHp\r\0VQ]%<	&si\Z[HHeQe	=:2sO8OrȜŖHoh5A&;u$N]\\AHsP_v5a|&GdBH,o1@O>㍕R{5keH1^FJA]Xv80P;V_HbR~H9!Agi5\"0\"mK\'>d d|l6H9mPȥ\"Tթ/5{!#^H<bO!U9R6Mry\\p03zyH>p>˂J߇1Jdt4J&HB]=|\rUJ¢ Iwj ~HDlD3tyc닢.HEC%fcVL3мfBL3i ;pHEf.*)|)<YˋԞHIb 5mˤIrN\"vNrc\\HN>+fVQщ2^HYS{NGG\nWH=8H`kfNLh`o[agvEHa:VNOuO)Mߙ\"_P\\N0tHaYB3GDۊY|_]HhE.Pڬ.MeMo@\0WHmuipp<p}~\0\rOh4\"IBH{8;sP%;q9\\}IWH\\hl	Ŀ\rzƣC4AS&yH\\֮n4JYrYx\0%4<{FFH b!4lK %Re6w;k\rHLݙ\'y(Rot9~GM<%NH	F7\'waqrf*VV+tH٤]ê\0{/| odlJ/1HQ0z/t$ځ7)IH {\"!b(ArD]R;HJ` tHV{H>l\\!;e)>*L^Hk\Zt4EJ	/uDHYD9($C[q|x9H5\"wqnG8xCZ(\07H)NF{W#ZDum(@+HƎ+@Ib^=QvM6_iLHt)gË~yV|LnH3:Bk[e<KRT6uLbhH>@+qj(~]v`즃\'H?rVtێm4RXH >+4x6\'ܠOധ(HE6Ib>G+x\\gHZ,\'1^8ޠ[$ckQDHIw4B,E3VZZskiI10%V`ޮfa8~(I\\\n/ęoHG!ΕV{Z#zI\nM9%gfX$Xm<~ucI0XouizH9EGm\r\"DQV0\rxiI;BSGlDkl,\0)I;oW~\'#`6[ähI<G31*Cqw6]vށr)I>tdQXB#AgI@/҈8GƝaXxwIG=ꗢ*䫚/pmGp\ZIGQp5u\0c{}A>IJr ډ7$UCjҔPf0\ZINE篏j4G\Z\Z}CJCIZ4ֻ{җ7taxВH1I\\õbD_kvNAF\0x6iBIl%&e}IK2Y*%;,\nIy\r|qSA*	}HPI|07ane;\\UI!e];iyD\nIHJ֐VRk&0\ZI	a{꿹+>Bp	I_.魟CNgB@jTI>ٽ^iliA$UM>l)$iIg-ӮP?{uORRr%~I]VFoJw4F\'^aH\\^k$\\YI?R`#C\'\'\"\\j\0aR_I-Y07Z\"W߿	\Z_\r-LIO2%2AlVi. 96s\ZIl2Si.kR3}8V!<Is\n	-/X^I:E6bɀHeE୒GÄ hm\'IP$K~Pmhf l<!,%fI3d7Z4U!VR\"߆Kod(IѠhqLD~Zwͬ\Zz7ÕC1IיpKmHAY!REIڧ\ZgBQ]bgvu,ˠԷ~ܠIiw-ƹ7_K	A/qD]i؜Iۂ>?WQ-U\nuTc1d˶IBE!u)ȧZe\Z]>$:1IBqM 5{s6 liY,ɦde\reUI?5jn7+#IkScIzV%N)S\\n$-/A@`JR2_s{\n/vgLi:%J_uMu0[uɘ{)\\de{<J\':}-`X\Z$\\J_/\ZۓVU>`\nZz%sq6PJeN2\0Y by_BQJH5bv\ZkV.AKJ/QTi)a}Ѫ]QJg:2(lP7\Z,ȧJ#ޫ*U-=\\??f#ܻ\"J(|\"Dw@΢w;`SE\']J,ԭГ@1<:Gu/=\'XX\\J/䰑Wēk@)EeRkULJ0^iN餸yLms{(J2<0U=\'oǙJ8}\n$p]\nIH \0JJ/Wԭl+j\']5JWejJAU]1^s?Z\0JX#jwӚYUZ+v*+J]Ơ<SMvidz>অ&<dCJ_cLЄ1%QQl3=J`\'D!2r=ije!O?[XJc=[)K5\0,S*:F\0Jg0&FP}<T\\u1DV9>ShlJj;K;s\\2~4Jkhp\n)1uk=eݯrz?zJy.\'H\rn_\ZG\"\'f..9nzJ~=;녞#	\"K\ZE+13J3AZ[;` 3˦oJ࿕&ʞъ<׈IN\ZNhsJ4+`b	\0Yy6WqDÅJ5.p>\"$IǷW.iNJFWEDgDp\\sqJ Vsf^0G\\JϻO)%amx¦`E.\r۫~?AmJ#,禛v\rxv>bv!\\UpzTJYF >%PMF?iOJ	p5vv8( JhM<c`RW3ʧ2ȆJbjb4Djw*4鱋p-:Vx@~JN@`P)@-8YX-Jskv:ShWI\'1SJ6dAl{Й\0JhJzQno\\	:\0S4tJ־TՆ@\n\\Hv\ZOJߏƁ}0.pe	G^~QyJJ~`L߼5KFl2?J$E!\Z\"wONЇ^mJP#d	T먎=v*Qftz\nJ.ַ>7dؓ*~}Vb%EK\0~,]9?ޠ0e3率K\00&r*1sU_\nfdb}KI1Z.|=3S0\r8]+KO=VAN:&1όE7ˬK8E\0=yH&Ih}\0+VS%K3SxFHnZDa۳ws)*xK3\Z{p+\\Vj\Zkr\09lÈ\\!K31WSBlQ<aK;*\nYԩ\"e{Z7&%]@h7>i$K;PasznZ*dWđj]rKKi`֤9-rJ/x\r$.ڞtKPF1)o47@VOfU5gK]3)\"8oESkЗS\'兺$CWK^wNS\"n1	SDPICCkKa;׾$(Ui{iN)hi\'T͌Y01KbC\ritꅣ\r?\Z6Ke]o?>M3<XKxd]p씟6r7q7nhXJ!K{Z,6LGV}$HxS$-h}XKTB;˃(WoH\"\0:0ˀ`%K%JW;E)K;.8^&\Zt%n|TKRhqђ*b8`d>Khtâªx\0,\nywKsBdgv5҄VD~KjxϚnѡ5.\ZN#OGKzͼ3cޖ22?C@b_LK;ztu,1}V\Z&!5W,(Kv4Տ\rPi}1HNBrKk$Ht80%\Z\'%  	ujKs;oZÏYS!eKOEnAF>ڒd3\Z_0D)\'K覦*\"9Q.g,a(WK\naڄh)Ĉ#巆BP$;K~YɸUڅF6I\n훰DwҩL}Ae ݂Ȗ?X:bL\"՚Lx789jŜ,WQs\ZL$Nn*\"C)-:v\ZilS=\0lL$QA\Z3oT֟xp\\Ci5L&z֏ͭ+	*&X&R&eL14{- _|\0zu!^L1ٚo4?_J.f\"gyqL8\02$A0g3&pn:ZधNk&\"\'~L8\Zzc<=KztvxLD\05(]\'5.9~p?LE\'JnE@lr!3Άv\rLLsd+BlYs\'5fJ?6LLZmh2-s,+<s!@tpzGLL)<ՔjFWB0#pmLOHTcK6.e;]Aes˿SFLS#Vo8ki.e\"kߦpLq4ZյH\0e7f=\r\nDC>OVLz7\ZUۼx{UW?EQK0\Z`hlL1nKTP+V; jL#f}ك;T#󵞅lڂL<~[]ĶJ\rln[!L[qG9עEpqZb5g[k=!nL$0霕A]`HX\"	q4\'L(pyp]&8,\"6$cM׳Z}uLP88ظb\'Q,{mѥa@fL\'0\01!۽.{Ց|&LF\"=	*F_Oy{J*v	L|ޱ\\t^L\\:-9L[-R+|\\٭⦍;yLf6=([х`#7~(aL{eT&\rM큃/I澟J_R6L9\0{/FH\'Nʇ#l,wLmܣQLn~hGʱLO<e7j};h&K9< LC해1%PǭVq{{r\"H.QLCUhU;4n}Rmx;ČLvWUkd4O-b\rLvQ4xA>krk-\0LG0O)=/bL;댰ޜA|Lh\0\"͚3KZ|L:}%,\\}~8\\Oa8DsXLܨ\\H=c\ZIpbxn5IL߱|(3aZ\nĚٺ\n5nL*~ΠExI<\'ULhk_fBL]E;B/y/k]r\"< H$LRHxsq5]Mf9M㈠x/\"viD9EMFMj^([o71ld*M\nA\'J@cVM|)=5c[!MHڋTYQ6cf|hMVsh$Cڝr+Bw&u&kMk_!:óa#\\	^1Mvb-vE;6Ep81YM\"e?|O5$pҌa3}rɑM)ZB?>EL5BPNot@M0lv)j\0]VNy|b{#4&iM8B\0Z?$y3UeZIM>wv(7]@Az#\nmlM??Ҏ{۳оdCϰ݄D=%MCÜ*v2+Lt// MQ/L\',@hr?%08ɂlMSB?grm[ΚL;@MY~q_$19w`\ZM[i%MAD.l.\Zn pTtMjfۅ\\aU18=\rQ%V?Mmb5.גQ\n2!j/Me:3Mm,pwz>d:W\ZOMnT;BZ5̓_{nNf2MyL;-ڛ%Iu\\K|,̞f] MyD|:Si^d-}9\r{M;*jh\04\'u\r_`t\"O͝4MKxG̽-run=*oMĮ.4jW[a`A>?6eXMvf\0p`3:%#&(OM;a(#L~ήC}}M|Æ j]w<(IN>=|Mr^إjZs]؃ V|l7{BpMk?[.0fY]d\"dI雌M`A(qɻ\"z\Z0(yOͷMV(sJ:tT瓹ή5/b`M?P/nVV={1IfMq\0q.2ݾA/^G/QtrMӬP=ȍM>lwov\0M\0{z=3XC`$3bٞq<ɓM.	-yɊO[ @WKNM[HK\\^:Lk28q&GCjiM۔%>-oy\\3}>#A%,M|OHOC0ؑ9\"1 E0Mu\n$T8A^~]eA\r]p$M~Yk@L\"#\"/;cvj~\0dMϸ\ZP\\x\09F\'?Շ=MD\nR卸X=jнMSp}T.!$|N\\YNݝEh\Z,P.gKNmgl)A? NN@vNԜL۾d	\06AYNegRwSn\nGКqNw1j|ˈl?|*t\ZnH]N$\0`ϼhk+]uح|:+N8,.ڮloTDؘR|9c{7wN9]`T*L)w\0+Ã-r]N@;\ZGʎ.Aōn_aNA;ַo5906lÆlyzND|چ{QV GzD&e^,[\nNL2hګF$H[=NR2\rQ${)NU{Wkz\\mlf#7N`?g\Z؂ˀzrze=s%>Nb;4_l =k缓+\"ּB,Nnq>%J+(æ7;~c+ncNp.j샣f7F,D2٭:2+,NsFyW6xh]g$Nzҡr9;,=䗈dGyN~5[xaJ8auda%N~Q+ĝQizO*lnf)1Y!fNȩx=.ےGnca(N\"?XhLf?e!#+ov`nN\n\Z!D]\"sBk#4Nb>R3Üz4BQlYzN&\Zc\n7˾\Zŏ6H6N:Ǝ>%,7	g`ez,N\\pt3+,l\'cOQ+ZN*R%!aEAÂlLʝv+`0ONvޏLTgwR\\Gh,NIo&8M{nJ\nӐONe>h@J|jlŷp>UЏNj$-GE)&J4GꝝTNkӲG\':2]F+Nu.J=,1.JakT~/ANvdw\"[ʹKcQ8iΨNHm	$3乒}oN8]]@-~iDGB;\r*KNYGDbi\\iRL<&\'?<U3XNAM>:;]\'yiTeN|qEPHk~BA~χ?|⇛K\rNWNlN4~ J&R\\xd׾tR_ O\0QDƼ`P|*~EտĢO93知/㱫Ξ&-	2c8\"\rlO8\Z0e4JCI]lFO$r1e`KkN1DI\rWO4h	8mobIDbO	Y@9P->5Uw\n\'OBJҚ8WiM@q6+@c1gO6n)X_?R)K_EĿORkg)eFèl,@O٨|e]|mK~Fӂː;J\"O+/xi|T|T\nelKzO({\\ǨU^D%!䶣XXJO/b;Mƿ.\\TI	h7D}L0=_O0]/g1Ay\\պ@Ǳl9ҒO:XZ%M;	;?՗l%OAt]2~\'C>pGOBHҽ+NzʋB43u8g\'NOCdo^r?Ӳd8&VODENUЕ$|Y~\"TnƬ\"OGޣY8+]^wtX]ݯs6QzOH[Byj[#A縬8Ė_7	rO`$63\\v\'M1hq*I22*O`X]y}\'X:!uS6GVQuOa>W_VKH5\\?R*\rOeIVi\\q<:mWDlK̈́\'BIOh>;͈ek|zw :Oi֤5ck=G6!S0{5/&Opb6<Fϻi䲯Hp\082C*Or\\ru;J(GB	O_#7E;Or#Z<B$B|cwAhLROB!f_9.NN$z(۠Oe/<H}	JtJ3KO%zwvW8XF]lUOҏ<餫q2d\r,w)	Og6r\r\npHַ̐|O)£qqi:\n5qOAR`qL?׬O3vv\0Uow\0KOEHǆ>&D>KqC|1}QOu\\\r\r$-k}3`\\kxOF\";1}̠y}[OW\Z9aq(:3+*+m;Oɩl23Be)e8,O>/wmPi)RSkHWROo/Y)?Y]8h\"OzŕyQp.U<l̴RUsO~xwU.]bfW`hW\\ܭmO]2<2\nQx}Q78@OӭLYa:bO_UQU5aM4OE_\0C43JEU\\-mP\nkH6w#rv{0=頻\0i.PzZboBL]+n@$G*QhtPIVU\n=K㦧Ywn_P\nO#~# |F:Q>݄GPvP=KCtgHC\0PkSZz0DϫI,1h]jP0ffGRWvԏ]OͫoP7i᡿}l<:G#Gx@N,RP8ۇ07ֶm/ÒE%WaP;]s),Fg%ゼ*(3t\'Z˳%4P=q\"\\&4o0iPB1Bʍ8aSh@<^!|\nPBH<}FJg=rvqPD+ˢRƆ5BhX]lWPR4[{Aucѵ.KGp^h73}P_M4WM$\r]\n]|a*Pc:D3yNo&t*Ѱ[:kG\'Pk:ESv\ZLa\"i\0SO2s=Pns%p=cz{\n~0ј\'gP~ؤX7LG0QdkL;}PV\nB^~Uh yr.F>6pNP\Z=sj&N1>Mj_hPps%\\* #Q=QCg8P1mK=Y4$	r֨\r(|/g˥$P6m,ȱm&7{/ki+P\"KU*PLct~Tȁ Y3P][õƑ\Z14մ#PĽ7_cZs82F%\ZFJ:7PPJv!zGkhz8nV@PJK|\\q/Sq\ZV![wb:^vxP*HƲB?BnƤ1K ]sgPu_13Kd}>n=\ZVZ&cLFP3JFÑm\0[l%$\rPK&O5\'RTˢ\"Lr<ϑ6P,\\Z` !s3PWJ\0w~\ry!R\Z[BE&@$\rP]qE[ScܥDb!,jpMqP݄NƋɰ	jbe5KNM,$n\nkPO\r\0݉U}$a)S~\'A\\KP-GmAl:7bByBG7 k\'PD-\ryUcxURiR橐[PG2ܴ[b:ޖx0s;w`P%?kN&{(bG!㝨P5FA+p\Z6o6Q%GU9er<!lgXQ	Jm3o۰? p;q喓\\Q\rLd^!DG4gt׵ʚH\"QwfhkgawnP;@P\"QAYZbDeO0{Y0XvQ\Z0B\Ze>&qTcNzQ&g듣aI\Z5Ec&#M/Q*۹MQ-JAB@Zsrs! .5Q4Gj%M)s&l3>M19Q8.f\Z`>z;+8$3Q>+]6\'Gq*r-UZ\\>#)MQBTp\"|{b4kw*~kQHâR@|\\L**FJ *QJrZ#6\Zd&!;]sZ\ne7 QKP;XӦ_f)ӊC?*QQ5n8<pg<DXTFQTAS8(:v\nkL[$vQmsG{RcXS`	.aGK0O*>TBQtAFB;<b|OPtgyWZQwG\"x\\qbg+RQ{͂qZ/)L^X>oioG6Q|RUΡˍHW1`qyjm=Ql+.┤kK8.ɵ!)*4OX Q]Bἃr4?N&uZsQ^QJP X)l\'2@\rte\"QJC}fL[`%%˚ſbiGQzzu}Ϙտ>g&98QB|ܪ\\{ΆkK4)QH\'<~dhçr$uí0Q!tL7	\n,N{Nw9Q[#Tӯ`0QԎRIQN\\smGi&!0\'2QZI(,p1\0ɐ݈fXا>Q:Uss@#WC׷PجQˮ5w=Cz?\r.h+p\rW4UF0Qҳ|I5uA7,^j\'\ZQ~uRkH%6tuY09|*/Qܧo7mZKe(jň/q*>c7Q\nZc4؅	gie-\'kQGz(O1Ǡv^SI~Z\\=\\ITiQB9S/*yI(SFL.c+_hRH8zqΧϧX}u[#OzR7)p5m(cn:i!:(Rc}A*3(x\ZwU\"\'`R|75I|f(j\0R(߳\\ߥH3U=NKR0_W閵w\ne􆌐\n#	R3_ýiPzeԹ(zWZL0N\"R5\'?̽]f:Ù\\?c`mwR6yI#٠2\niQ8o>?mRAm@1񱗂SR)Q1RF-ϓ|nkv_i&dwRR,A6*PʎA==OؗV\"Ը,Re{(TFQA	ǴNRgE&eL\'xJb!@n,z}0LRlm7(ʗ8Pۯ6\\b$Q|,|;l2}Rr2+P;ʅr{\0L]ۇv+Ru8ip=J]wBRy;!%a2Hlrztl\'\ngR~\'΅\r,_RnɠmyBR2]\"PÓbK#p_uRp_Y{i1tm`R\Z0b5gU\"k)wC^N+*7Rf}_r*8#MZ\rx⌲pB2&Rh((YBެQKMR \rNy]{\Zώ)4qRB(yR*;>Gg\';a^4(kpYR_L +FkR]`5NR)	_:W{F i[\"u6\rսAfze)&ReA	}VDC,sX\rÞReJ4}6e^[YFLR^֩	R,y^h1	@۠t3yֺRgc6G .a%y]wQARۗюDEn>[x =O6S	&RksMM	q;Σg0ERP\"bM=sHmu/MR{Xgɍ1T~=Rោa:hxE	gkA	+R1AZl{q\0ȇ ;ˢS\nAL/\'}?hLog]<Suw\Z;$BQ-zUL2?Sž	SEغɥO\ryw|+QxwjXS֠ǃnDJH0h@ہ*Nt`JSyX]~*Q]IED8ŋ;_nB`S-R{L!Z([:~_.rStBmۄ4t\\N9H6ÑS+W{wś,3:sLDzoG]S/HOmGS.>q-!\"\"WS2\Z]U츖W2BS84+WJh4s4z6fSBdqRV+?򎻯0SIX\nK-Q*w&b\"pA@SI4\' |\rz8D09l8,WKSKIr)},2xqj6+iDSZHs _BKPO+-MO`2S^[m_,Y%q[GD=oS_>xN\0MB`}$a0O)S_C?}>\"ġ\Z\"ϑS_RvFF5߳7s\"O\'GSeȮ$\ZrxLw՞L~Е5ShVZt^~͛\n#$֒\r5VSh`.!1eUG19rj<b4$USt\nײ^>}GlvLg+e(+S}MWs\\KGcVGm4Q#SԫO<ռ4YhfaDx]\'S庸S	SHb_U\'Lҭ5ByP\n8SJ{!YsiVoKSUSu7 n=ة*eJ7!HS1)po#g4#.<nS,o5ȋ\0\'Yb-XjQ(,FS-yq./v5At*S1VDFET4fہNSPy1UEa-)쏄eS+X9!/PI !SS\'/ !Zv̠;\'$GȒS;;c5L*\0j!sV5SP bW\n[\'LS9iW҅ $S\n@Gf_`IFaQm]-<SGx8I@U#ǙN\\JtS||I2!Vi趦AS̏[;cC\ZE4?6SOkM\"؇\\)e}\"SA4c\\D56-#d*ҽӾRS80Ȓ󢯵QI_4S\' w\"DԁI`#\0r\ZǍ\ZaT	y^\n\\ew\ZKWrNe/{TLĥ\'Leڻ?ZCv[U]ZTX%Nuz~cƢC	W[Tz1PWj=bY\'ǪtNT)訓{\'T*YnZv.\r_\"\n)jeT!X$uSQpr0xRUT%$b4\"Nt4?FWT\'NJ<zrۈR(JMT\'_<Gul+CۂxN(mT+?E\'])?^h vzT35TM;LhT\"riʉ:~]e\\T7IBaA*QĭTm7aT<%:H~^խ\n/\'ư=rT<!M,z[~>V2#}E)TD	5dp<+QH{THdyx? mP}63VTIĸgMY/~[_h/;@5cTKJInYJмAP8EBTT2?%iI	`V-  ՊtTV\\-OKXǯ.ŹNЙu1^TY;GV\\7hW~O\\Q{\"T]6$IZI-֊C3y%jNT_ GlyN2Ni3Tge\\PMwQ{ki}\riTt\'yFa\'U*o@TZ2f#\"U56|Yg\0(&0TZegҫR!Mx0^l\rTus)m[|lI\\³\ZɁmUTjMΣGjxI15oT3.Q>7J٫I JWaT%v)/WQxfɝ܅JLmTFHQX@fSBDh8VI?T`zv3(Ӆi\\mrXp\\ifTɥC4-|(\0t@=}2MuWZ41T͑{hEaLP]#Kc4%~7NTJDm\"NVgW%lK<T0uiV=J+KR֑\ZLר I݁WTw_`zzv5`rP[}~3UːTϓ0.ð!hP1s0dTm9v.x9Tc3p,X\\=3V\"zT#IdiQmѼFn)#$6\ZW@RST .&:ouE/$&6$UVΙpWx$?⇼PUcZal(+;\Z&E\"HyLU\n3Lf66.ѫGʂC˱UUl?lNv60\',(N\0&U$C7!K!IG\rST)\rU*ٗƱ߲r/̤nsΩw$6.=VU04+@qj?35Sr{ۈR;͎U;STS2.}1XSH&XE6UCϲV vqAK:h8q{>UKCW͢/Z3\ZӶIqUW&k?un.No^Xۅ5PUWnݢDU_xH%:T`9ަ\n\"=U^hK9FdLEkfd\")j\rUed}\Z%g5Ƴn9}Ul6>8Sᒻfu8	q~$rUmPg[6m	ecY;U}8:l֑ŗ[J҃\'gUaxc0b)i`WACL܌5UyB\'l;FVӸz`|\nC1BmUk\Z\"4i`FVm¬GXiEU_ayg=NQm~j~noU۶B?wN -Čm\ZէUhߕ ipd\'s3UnwUM: ݗL-^)|;%UIac|-\Zk̮\0J\'U6ɣi3b-ڋL eB[\nkUř!¿rIqq[jBCYPl%U!6QqWga{Ć! M֓$zUo1?lsȷ\'^y~YU1X\np8:X+u8.YgjDUݵdRj(gE콄\\6%du~UWqPuUT=?V#20f~\\Uꚬ7EEԢn;魺9kU@&?bKR[,3m.\ZѮbUxvȎ$@\\Mc I @ /wUɧk)I)G55	fR7U𒃔`Λ)ͽHEl#ez@DUeDDkX5\\h=,U\Z8Z\0U.X}b,WsfyyEQF_[Um@N[&ĨDSKm^Kbf=YOVb3(\nUű1_K)#C(~WV;-!6HO[\"pV%ÚE˂2ayxm\"%gVPjh>?2\\GZSP?3V,{+x}-\n uM8g>,l{TV/?|`0V6K Jg^u|gVA\0דDN`\n)Pk9WQҌŻ>VJJdHER_82OVKaFqkNi7PVXWԖx@*kU?P6Ѣ\"5VYj8b5fc]7WiƘ2HN}2^V_QZH؛N\\&IUb󚂇\Z|}Vkg};GpS;`RG#i\0NVwDZ<J:]gzq)5VxG٘o)y0`cVGcъ(w\Z\09^V࡛J[luXkUv\"PV>\n7b_2F.\\cxZ@\Z+df\nVXQ3L!h\"i#:@V̲D33>/Qu`ʤR@@V/q>^b\ZgQV]<G\"+#Gq%V֫\\V\nͳwœga\\~J8wN:mN+VEI0uX^@&2*֝XVk=|oLLPM: ZwF{VbqPJ\0?HYzVΪ\Z\0G7h\"]c..̭IkXVq{}A!z3V~<\'=V$UCՔ\rp_~#Vcm:ZWi+lb))phV]as-X%2t䟘9e\0|\'F}V?]g+?D95u8ukFV身p6jMZVn[z3-?#BV*:ߍ>I<7{+%WaVq \Z\\8`IahNzhˏ\"[Z;V#i)A\0=-A,Dg%VGdV>Efw)\\QQ.Hz\rVk8v>KP3X{:lc@WE&TVU\\O8NOy!byAvZW\n8?R`\\d0\'O}1W\r5|aU͈3(|ɓkW֪2|0NҵxǣYO24pW7G1r_<kr307WnYmtZG?L/%p\'kmW$A/N˲7Y5\0k;uvBNW$F<WW\rVآ{U29ŽW%NqG+4;iiW))_5g&vֆZ}=lj^\'rԮW1b萟찊?ym75^IZе	ZW;&c6pDX]`gP׌U]!WAL3\'j\r\rNfFzaqUlWI+ zBm/O*U\00\'1WJIW}PrN7MÉyWYYsǬ/ǓtB&MV;cˍ\'ӲW`fE/C2r)lPCCj?Weō_ցݲ:Ɂ}@RWиEXWfC3Ku!7J!l7˾bԿWh?Cexl}$ӈOJc_WnCaҦA)yEw/Wq$!MW^fq]]Y/e>xW3\"ѿWr:P[	B\r6\ZXKWSĩ/WsyWhaϵ:[\"5acQQt	EWs%^f4XbFLLF<šP7WwR%G`{\\]3+G]l-`WyӀV]@aMxezEhsQgmgWo5ҁRj?UZ(O%zWݖlS_\\Ufh5n$WxO`5$=U>oWfpUg!Ry#?Y^Ws4ByBw5 WF:ڮU3dm0	WѾ\r%,Z	A+u82,gL\Z_W.pX5@R;/ƙ\"ͼWqd9ǘZ`~:p\n-vnW2)Bsui}KxN5آ0W{X㮊y35\\@5MaWf.\Z	`,Hj`?ߎ_4YOt7WP.\r?(W256wHUkW9,P2e!X:^uIVnNYW} 8.tf0\'	WO}leVd`10bW@XXP H_0Nc\nZ`OXU?Qk!_e+8\"UGXU\"*JU=?InpWi-7o	gwX	P=̃m@))Yhq5ϬKX\Z?yv}hD.嬛Mv)X\Zp/}պ \r_<\"\Z!}X(覔7+Nb&1Y[; X(f\03Jm<\n%lrX-\'ޅuً޳ (6/-#X6KԞep/Y29/<\ZBdvX8P_9kQa[-mS\'<@!V:XGbϓy(o9R4DK\rr2ݼуXHPpE%*+%tf`Xb}̿L,gCy~eb\'\n41Xc\"h.AbqKӹw_U@9XicR)RǠ.#`jjŏ3?Xp*-[DP<V8A#sAgSncƽXtɁh:bpDahMEj	Fw(XxT29(?S()	X`X2]ɗɨR6|nwTonft5Xź= )e׎.xipX\naK\'ݪ[+gԧd<7#X듫LCYkUrS 	Tx\ZXL]O}Fw	Vy\"#aq\"=rX{2i̭Pa$胸4|;iXe$<q>jM5̸z>6X=2H۰[$n%R-YQ4pXG.⶛$\0wBp(Ϸ\nȦX!w4-<[EAbgzXm%c)2MQu\\9\"c4XPIJpe8 ,cm[Xt]\n\'ru캍˄aZX%B{0y2|kTUgm#YX)G&Մ,)ClrY.ȦMXϏS0vbo@}㍮\ZAE,KX}wɗR67uMT!ܟʷ\r2XxEKƪ.,lX>w{oyi%UHqAcXr5yw]jγگzж\ZX6~<i0eMRa=6X~mW;CF\Z;\\>ፀSL3SYV$/@=V-dcYE4eVLF/Uk,~Y)~0rck@U0`.ZRY#poAQ^#hUogdsT,Y*NÎzNU=jbѽoTy)60TY?c*_a)\0|4St}-ʁYA(B4d@0:v]Лk\ZYAD]ʈxYN.7l}eKYBRb-tsxco@ԾPɫYCϩϟ$p˯=qj=hs\"(\ZN)YD^MSeP_kLq?m2YKT!}8!zS,~\"Z+Y]++!>G$WmˡY|4GY^{1U4ϰt{n|75!\0Yek\Zkt~n4&p#ӜYf%\"Mq;5f\'YnmksS5g]G #yJ/w^OYtmk9Q煇0`NiYvSu%C_{	Ą#NQgKY%FVOc$m3\rYl5pY=!\\^ox>S8Y-Y(4:O}ձ/\nGJb=QL}Y2gEtiqƏ	eeK	*ߧY`x^.H#ƹ/24ēcY@e?W\\\'lm^9ďޮ-+YiiI0)R	LgGNxJy*cVYN@l#yQ7\r|6&zkY=&~.QLF˛՟Y3kYnTvY+6!6E5p1YiH\0U3$L$uHsYQxCd\r?F)VWgJVLN(Y؉c>:	mEyѪw\0IYt\"5Y[盢Z[kٓY7ɡܼa/c$ۮ7\rDr\\.FEYF+afZsB|j:^\\1dY1n8DoXa0ɫqp&EY-Tc`a3yj߲6LX~ZY?\r**&FjEu絸?ZjLw\'ǲLF;]Z4rB֏znբ> \'dRZHzn;)oߵ3QSk^=s!Z,t	KW\"hm0a=VZѦusV0rLt6QZ\Z7lOi2C~vo:Z!:(Ħ׽Z$0XWNyzSNMaްqAwa>ZG\n+:P|>sPc^M\"qZJP[:cEH\n%g4~Z%4\'\nC`Zó4cj/lZ4O9uF$VLA_PSktZ6rUB!tRytJI0+dI\"1Z:\r}nZ`tj!Ll	{bgZA:Vy5bIG{Z/h\0qTZDdD׫v5h*(\"3.QZF8[%=΢u:Tf?*X\'ZLh\0ԯNq%a*-4(AfEk+)xDZS-v/<?y®.xUZWjI\Zg*(T\n\\Lbr7tɀ\nEAZWr\\#͕	!^lt|oC lZX)V>N\Z]}幊l:6AZ^x  -}:ɏ\\rNZaCw=ϑAvd^?;Zb)VlJfdX#lW@ W Zi-FS) UK@Ia]q.yXZm=,\ZZ\0M%}E[L)oZrVHͮecԁ͏YAo_PZz+FgA@NQ>Y:] Z}i,LFsBZI=41Z\n\r~YWmU9FtQZIꠤ#W{	!bY6fN[%B\'ZS-`~nV\"\ZUMT;?ZӦ8yikP\Z3葊]Z8!!P8~\0ehZ \rT-L	r֍0ZXVz$PjZJĭ\0dg:jN*#}\"a.61+c{Z:c\Z	ɺk{O;nJcjZ֪m떕\"|OJ}^@ƻZ?;!k{\0.ReC70xZR[Cb>wip٭drZeJh&\rxZ,;lmpn]a0Z-r廒^*`t6/[<hZifJW-z\'s\n.\\0gZ9	؛i\0٤2ޚJA\".C-塰ZBLws³-M}GlEMmE[F̛PK\02@L y/U[\n1RU.#.*E]z[\nxSSYP垫B_XK8Sa#[\n*k05Da4;\0/_7a[bCx Q8ܚ?z69a[&(܇\0ΕljGn[\Z$k˹d?\\{\Zݐg/_,ip<[\0k\Zض_w?n3jSO[$r(ڛ8tbMq\0>5F[/A1~|24O<<[54(KL9&-kGRK$z,b6Fp[8si!@뮝{Bu$f<[B-?31W8=\nQ0 }8`[B<s*;չC]+Ss[D\nphSuo9a`\0B,\ri[Fl%@eObBKՒS[NLE,2}uB9^[]9pmm:M9B>,A2[b.	\n$0,UK9	SV[cվ\\\'9EG\nB~FvLqV[e2<wt5Hm|ۯx#F)=h[e6S\"ñxakAyR[rtO\\|M\n\\!x+*xH0[s-ݑ_HG]TJ^ƙAO7P[t;}n[ZVL[qTu!-.[u#\'KF}a~\ZY	1L.p[yP]~!͊&]#n!~[}waMwz0J@ou+4k[Rb	c[[8akI%\'n& G[)ߋT0uDWP\",Lǫ[I,޲ZF[/!fz3uqnn1ώQN[mۢ	l_Z-D,Ef[%yKRb6=F\\ad[U:˃VN:OexΊJ/Z[~KX适[\r\"\Z,3z.S\";r[١BZ{y/!gM,[\n)>l=lV;Ow~ [m?ouyRt/lhWCuZ(+s[\0j8|dx߲)Y58]g/^\07[f\'TOTef==&i[C^mp	mo[EP\"b\0Ɋ\"BG܃$[6;]qdJ\n}ʂɥD[8Vs%z2z47\Z|GH#Bo[yV |t\r\Z/]X\\m$[ޫONiN%je2ƨpߎG2K(.[fSmYRgWϥt<)8ݪ~>?\\װc_AXC^`\\{\Z,t\\ɭGͫFV6BZ@۪2X4Mw\\	 D8&	[mQRt7QG\r\\./ջ3ʇ01}\\u?AJX>ENcVd.|c	mel}\\OoO7)˪9K.Amr\\\"K7뚁=H,3C3șl\\.nFl\"8\'SX\rKmKh^\\>tt99ZQ;3ؾa\\FAQ\Z8c]=Mp\\Jt.N4\08\"̥A;(R[l6\\W=*z*$p{5: M\\[\05L.z~O))&g˻ \\lϸv{z2?H9l	Mt#er[\\sq)|IJ<ͧ,xLI2[K0Pd\\uÉX[\r|!Tޤڻk/w\\xc,kWba̎2\n[e]\rsJ\\y5@0\rcx?q>8\'3˨<<\\|߯T(t2Dn\\3\Z#\\#G71\0nXsd\\?B:{Ӗ73LΔJ\\mM)0e$:XM[GC\\\0ȝRzqȑ>Q}VW#K!\\_{[GD%@Xo[tOx1\\HODĨ{d}d2sI1eO:yѪ\\Cw?[/I 7\rB9~$tl֝\\-^q8%jY;&ͤy\\&ep<䥟oGsشwX[G~S\\dAu7]\r[$W½y֙$\\WɼSW#6+2}O}|FT\\I\r\\ĉ 5\r\Z!t81\0==Y[;$+\\}(}r=x6z%}>U\\Λ;3X]3{{8ҒZ\0>\\&\\˫p30p\"Rz#`ĭ6\\$m]IE#(\"sc1.\\XKD\nR+*%PЏ}q8\'FsˑY;\\صt\Z߃hs4&[pTgP`\\ءeA0?\0}̥qJY\ZF\\v V}+Qܠ.͠t7gd\\lCv!Bwnsۘ%y\ZY(\\=0b򜩲2֚ `sTR<\\\Z(TbBWy9AK7H8\\3SR\0NEu=ߘo\\yT{MPu|)?\0@\\1B\\y@P޿^$VM7|])\r5t\\.=tch\\\\!U bu\\U6ӡj݀]bz܎6x+}\'rҙ\\T7Y&Y_v{3[MH9TTލ] |$,bEw`&uI\"5`a]F5&-]V4dB@F]!VNbY#E3`1W%N9])SwMU՝XQ=X|]6p@DUS	YBN6Ҁq]<rֽ4j\nhNRz/>]A.ɤz.j/z]Ggpx?_-lcw.9kG@\Zh%]HB	m3сhܯ0x!ek-]JebUf7b^p3KOF܍⼶]NqCNٓԁ}~<a][	BJƑ諶ʡ^k{)s]^cC=t6pTq3WZs]`~$mg[K5NdjsiRF]fC-\\Oa+밎#i4x$jK]p^Īd{ףKt\'Bd;]t눞+\0(:aZ\"\\d]]&]5zB+(ӲE:[^Ni)Il]&s)8XE_~\r&R3\n4]Ɇm{w#ߟ^,n,>]FHrP-sen|Xq\rmf`y]Q˄=PݵuQ{>ϐ]:&\\	Qʓ\\^Fw&8}~wJ]6/J/8̖RR2{E]CŀPy(c:C#8]XG8\0Y`LR1qfy,56]֨h;bvsL\0#,UCL\rWtLl)ͭ]}_gXqwfuCh,;SI]m|TosE\rH(lU]vY\nu)SEE\\>A?]LV]r6|Ww\'Y]V05,MΌ9nrDUu7]ؕY\'Tҹ0 P=<q^+FR\r˻ZP퍙gN^~</=Ny\"<loH#@\\-5&^	vz~P~,3wb5^TȺ^ķ>`}jNG\\\'̅^>\"5J+fi7h&CϭX2\ZK^7qUd>VNchap9k<^DDj%;yBsZƙB{zaJP^!q1CYTc2xMm2fMY^#[ao0r\ZZX\"^+5iMY0ȚKFdkI4^;M3ƞl/GȈ\\G( AYyc(^>r=`7\Z)x^?R0-Dwy0WǥZ\\G/x\rsH^@$0.\ra:_ޕb<1dNdw^AG^7 ;6`*$^v_^I2ńyNI_\'2GMtO^Jp!<ʛYw\n)l^Nbu\Zx\'!T8o	yY|~C\'^W;s]-4V84^ͼ,i^WYls\n	\\u?Vy^g KcZ0(!~zW\":N^mm[(C,m.^vDG=msv^uPTͺ/,LfCT/V|6 }^;P3G-FT/ܐƼ%!@&+n^zlߡŢ}e$g%ڐW$~v h^R|7^)4(5;^ V\"_\n~+dXͶr^ΜȜ5y\\s%^,\Z!V>J1k#=տȷV^ q(j \0If}\"l\Zm^$VE6rh1ʔV=̂^g.CٕZ(] \r!.fB6^:UrUЬDUA6YfCb^Ujx{+\"&?5YpѵD?T^\n0{zs>Nz/@6R^HR7-IAÿL#~{چUď~^c%n9P53:2Uv^݌)nTh):3\"WjEv9NnZ-mѵK^߇Ք,&>l	#U3;^Ru(.q	FOb5\rIi&^拾/lP{FFJgcht:M@D^PK:`XYqpI~^zX-	XIս}:&wfc~:py^<gh/Z4JDis^.:%5)4Ncj,6|^׋܄yiTWaD#Fu2_2f\nw/ީ}\r<8Z$_M7ĘTf&%Z1S/-v_|BO\Z߭/Blk|S|dǈheP_9&?e;]\04_+)[g\rMs\0z(:V\"ۧIw\0s_,aLO0lӔB\\U{Er@4_=>7b\n6h鶨Pj|\"xhy_>mjT(\\h3-QHcE_?,Ibe}8\\Las/_EhH)ߦDN<гJ_H Uca/kF$ZbKUB_R-YTew&0^+j\"ds_T_:rcߘsN/]\n{zJ_V,==y!kx/R1P_`|BȂǰ=ǆBy3b坶t_bUhDbU5֪DwG/m_duA#fE*.\nn9T\Z9pYbX_lbR,\'IheRD8}H_oYٱRQ_}GJ1m]~_{gg|n%e~sCiB_|RBG\'8z[|\nZ\\E>L_x0mMQ?_)>w(_K8nd{οR#2_7Q0WA-@\ZCTM2G_&.{#9oQzW-Y_37~q/j\n9S#s_ՔJ\nZD.sA	1d Ͳ_64	PK_`I˨1?L_%MSK9$yg_G_<Wqع%ggf-W<\'_$@\"4](XUjĳfIs҃_IGx%܍P8!S+_?`\rV/IHnsN%	cy_(F_YUsEƹT4qPMDSF>C6_\09zQT.oxlIޝʄC_כ?&mH[JRc# M6E_j5_iĐ\ZNDs+n:J@_,@\\S7loFPTިG9_3̥3*m	h\ZnM kX_\\5dŃ^fSC2tvٝ9Yw`>:6ԩf	µ(rP`1:	u34vYya%̸\"t`͋LX~/l\\!\r̽@Ir`6Wr:MVH7ߘ*5_e?D`)W#3)333=M`sG}f`;pRqܘ9UA1ni`\0`>K˘JN\r@¥Y09C`>NgK)p&0L@e\Z`@P0z:?ma_Jt[Eo.ׅ`D`]ݓP6}\0+\\nO(>AQ`T.|	۞ĉ[bTI`X,\'I\nXWqcˊG`]Q6Q^\r\r=ѥc[`^ʂAJ=֭Sa򒡼3K␘J``tD;?^+ʓ5mP|&`dcM\noDZ\nbf<y`fJ>^ZPsYjNKBi`%a`rn a(N跮\nqH|g`LW|k`u֚oLXC⬧RTt~qb`zA`PQ+F\"bwXiV,\nR`{YhuAlTN-org`\nR ]s?Idi#8Gp`QV;`_1pRF;`lU\niB^g^ܯ68f}`hs4DU.f$Ea<p[`\Z>f>-\n})ޞgGK!`2nԆ]֗mB+#GJ=g\\`!\r;^wjMRU\"&ݻIʝi<l^H`WC\\2\0cHEɡ)G`>԰Z! ߕ`Dr$\r:\"D\Z!@2x{A+`*}СFб˕Lar}`;lƛ\'phpk\"h.`=Ix\'u|ΙK!`dIUgQ|X!f~jm%Zp`r{R.1BiKk)5M`E[s1.FN7<vl`Le\0!HI(c%В E#&`.D{J`\"92ԙWp`ڃa\nV,`=Uqu\\CS3`E%_=\0qQ,b7Ncf0`䢼i6FTkT fsn@Q`S,Ы=3 R=hR1\ZM$`.XAJ~R\\[ͬ@No`$)k-Gx+OX\rhK>[x)\0Pa\\C҂LnU[ܠ{\'Ua\nU~Xs\\\r>cf\"a2>b[/Wtz\rlyoUda\'ɎDu9MJ5u|CmFhS00a1A,7%v=0<~>ua9INq#yT!8CUa:qƨdy7wfDs\nRUoVaC$qas6[`u֓@W]-ͧaR%\Z*<\0MP./BaTjI#o/(xL\r{Ϊ֋$awXOypJ旙ヅ-ˈo.נawAV >[GAI\Z cr\\la{Z;KU@UdMfa}1Z>)Lꌻ6i<y6q\Za=яY\Z\"!;!AkCcW9]@a]0.Wz(nn0*6׎daހ?\\OL0z7m{28a`)jj$L(_V)D~4J3a55\Z\\7w{Լ^dTKac|I@\\Xeo避e Hl-aO\"Oq4%qV~b+uaAunat%}XzFafKZX~ͺ3b]L<7a,\"Ɣ_*{Zmɛa+J#\r/_TQPOl齎l?aW99=s\rl)jb_A}apzTvƢ3<\'\rkRUaCShZ2\0-	#tilaE<2`\r_ra\n{!{Qدa~ͧZBvLj*Ah*ba«TtVk%ǎwش=:\Z&)0mawz&)\Z֥2c\\daa3[EZA&#:	UxQa6N\\L^aݐ;=G@azC居Z݀;4r=Θ|au//v:ܩ\\G=^C灩T%*aUFW\n띀꽢w.C3`sauY]iZܤO	Uh$\'a2(	PWۘ{K=S7qoa5j[ЍN|,N=\"E%+BaDmERBt\r?fQaZ\ryxVvybbd\\r[!\\	,5:Wtb\rC?DK}y/;|MT$?b-a?<\Z-r\r$Z|Y\nb>m`7H`ヌ|X-ˑ}<bG03⊼\rQQQ@vIF.3Mܲ%UbHfc͝dwv/ݖIe\"qO!&MbH\'}|AQ\rs(_D#bJm-ʧ553P#A{6\r54bK76VP9$GA;&ekbOQwùLѠâ9QlrlbP9ޤyPg\"Ę\"VbST2ΑCCD\\`ݮ>E?J3bWYKa\'1~lXk|]rOӟg\0nbZG~u&\r坯1楃/+/ibajI\n\'[4D&34\\ᮀvbb x6#%^mQwldmbgBxɖ)#B_ur߮+bos6>_s$	b\\8*4(bx͗߇JNe@RPb|9+2Pyn6`b#T;i8bu¢,P@Ӊh5.*bRILa+.-UnTwb@]K2i9n_ގzb-!}أrT\'ΟgZ+Sabh=cw\'\Zb=%WBt1stNbb<LHS׸\"5\0XJb`/#+}n?ybW(:|[K0bKsmFdAیR$	bbٲJ4k&rhX+vOt$b0#ϦA*>pjqL*LN*\Z4beрM]=B+`d5ͰX\0b͊Hjxd\Z2؟LZ|\\D<hjb͌3;clG\nX\\>Opn7SbDd\'F!~J*pDb;ؽw\"S8\\z}N0b}miz|:mZJbQ\ZBZQXNT6{hBqb\rfhQ\"?k22bmb􈀮9!X:\r3_:mcbZ@v\nKR^&wu@Mn֮Zbqq[Jsآ_~4/`qc}Xq>D\ncK ?߇\ZUT/tl?\":3c#ƈ|FwJ\0`w~^vEpLLcK͘G|\0wO>W! cέQa\\G}1USV(sc<Gէ)hZN0˳w\Zc\Z)Z)d*~SF,Wkmkۡc:UeHCB\")Sε{c%sB2%%YI/6@yu3Hgc%;M?J+?\nYXk΄c&~LRt j>گE@>Ǣ`c<!tF:TyfXcC_>KhCG^S4cH\rsԃH6Rjѿ;VgtrKcIH1Ũ?\"= \nw\"{xcI)N9\0TmQUՃb h4YvcSgy(0^xa&[5 fcT2骘\'Te+b 6;cyc`G٥T~zF+UȐY,cdG/LVVyKTb2chvi8R뷊U.L+sH3Y;cqoʯ4-U*Q~zѼVct?DRFd\07IÍh0 qK9L]/\rdc|*3~`oQAHw0Tc#!^#wq+T=Q5cW; X5\ZOE3١Si\rcudyOT.`~<jx.\ZaєW6cCkU6ۺh<}0Bџ\\c`P\0\Zư9cO`H;гCe]ϙTc)\r?	IF}YT\"Qy<c9כaIaX8\rr,F\"C2SycHoԓıRU~oϳ,P)RWFcj޾?l\'84F=/3;6)_qcVxy(#il8L}e޷c.sH*-ب_:%;R\'Kc!#Bi*+\"\rnIƈXÉwcʗBZ7;_Zevd9NR*&(	꣜|_+V`d\"+THwI\rW]kYm]sd$Gjw}XXyu2Z=Io*6d%.\\hODÓ;}JmK\"5WEd/e\\sS:짆$flmojd13\'mzU=&٪$?t׉$h\"wd2/K~+kqς6](nRєݠd5[&*%\rG8	pS-쩟q`97d5!@06pOQ%waK(nlTHdAPE4җIƦ!j\nf6mPedBݑ\\EgE8\nƱz\\\rx/dIMB;%9Y$»Qa]pX?«\0dOJb]a%t,Nsc>dPBȓ\'=99Zx{q|G%dPⱱX.]9FP+zdW\'MJe~vxh{s_|qaݴeͬdf/dBlهPQ=#dhSo&@Rl}Khѻp2dhX/Ah8\01!p-&}7zy2\\ldjqe^1wK4IntfVC22@qdr\\=yZ].ɱ dunZ)zOOzn*59ǓO6KdyETI `e(ު)ŔhY˥Rd|ImtP瀨96|d	Y@@+ғgʐ>$/d%FY>eApHX{c\":d_|BT/,xmrSzd̃qx?\'?lJkS#d߯ٹ,Z&{\r#qߕd>W0:UFYv\r	KdIX&܍s!,,\ZVwYLd肇Y}W&T\nIƤNAP\Z6dZ`l};VJ$tdrSzn<N{1J,[o6`WodĥS8LfO̒-8ahT\ZdFY:@	BZ#C\'yuY^D)od7vKׯ?驟ǺcMNdB\\dǮOW-^Em	<0Dp>d0(X}v`\"déٝ|>L+*٩qkꯜd@d%1MMo61VkdWP;B،X:d*M?\']RÊdWi^$_fd{_UR7Io(~6,\rT\ndri\"fvxʅeKA?S2dNWNVSCƨ!\\K;e!*Td902h,A*;3OAe0~,|!kr5_3e\n]az^abS͠]-e#/^tvV~rBBGqۍ=e4cr}cٸeKWCs$Xg-e5kyH~^}\\f#6e:iKp[8qBQě(3e?iafޯׅ\\Rg2xePx3aGL2I<hʫx?VӆB`!\\eQ-0C\r<mFk9M\Z.IeRt)V-AU`\\E4FeTm?Uy7,K\rpSUn8ͷ@e`݆.΃:jE\ZҰ5\Z)eb5:RB ˜OX+el%oѴm3VޡبSs?elPFX 7E5)<ȂY_K8\'enR.	OFOXPhYC>WeR;*IeKӯ0,YZ奡Zk%eerbB((2H~kSBe[edr\'ˑm?j\rKLߤQkxeY̻Ls{T=BrvIFUK:eh\\G\rD|uL=~\r\r~\"ieg˗>2Xm޿% *+Eފe2MB\n\070ZzF%seEB	Lzt=F,faZ{ԲeJ*bV,CvbʃP~$e%[ǺjqJX%ly\"/eؓrJQ(O@_y\'+*&w\".e,B<C\'T*G|a#dZ?8\"Neљ$S(O׷kP.:6S:PyeNױ?$ 5e% i3eb|(G\ZrK<7e	<!@L!f=EY\n2fVL$/DEf!Z<!%ڊ\'\ram%Xpf_R0%ҚPYXR^;3m2/fl/ioVL5rpHͅќ5!fp0U~Ƒ]fO#iU|dpf?#ʊ`aYZ`BfTf\".rwK!঍x		JOAyf& &.j\0_(zb馣<~Gf1\')UɺO+pP\rkζf5=/-mZ<1rA#\0l2$Gf6\'`9iPX \\UVcf6cN\'Ό$jy㧹46Zf8<2r\Z_- s}f:ǳTE{S(߭E5/,,cd\"f?sӊ1@cd`苲6fES̨ @V13usK<\\{F#fG\'e\\M>Z#,gHg< fR۪8A)Q,5\Z}=JZ;}ӂA LfS~\'h,P.E1J>3&`B(Lfb\"=g.>{aۇaNl;)O&a,WfdEUXCНZ?Ѥ(\Z|D@fhP18jIU?7zju+j(>for\n&٣/	E.FM_hfpڗI-Ǔ\Z%av}) (\'W#bfr_܋p[,t8)C\n`pyDftP`zoT\r	/OFm^+fxFaYp`5\\<ǼpmXmgB\"sKf3fq_5nASJ W+jfh*>P^([?if\\S[bCHތfpf`Â8쮃ðK9(\"϶q,3 {kofs- K:J{0f?(mZnҳh;ފfocDl~1yFf(f9Ȇy7,W2)[*ofʫƶ3ƺŻك9,GfJڷj	T	G[AK}N<k =fπƷW7~h?OcfՌQ$RU`oQ\'\Zf ]|i\Z\0ֶ^ۇfO*Dx)cUmD}_ů*fUv!.,S~vG\ZZ\'f2g#]\"h0Vq)0j%Ig\Zn	7-V-hJiVggm2oDHTq&hT4gn6/jfsehB3\\S\\gӦ\rW:Py}p!;\rc	%,g\"Uf#WƦ\r7I[\0N5g(GE\0+fz.?ME?q̝@g-Є#h;>	|3zBVg04CK+vV\\\Z`,VP.sKOg6BNp&\Zgq:sdg7k;vƣ7+Ƒ}>1g;74٣eZ=`7y!uT9V\ZgEѭC$iOŧ<3.|WgJ]vubՄ(it-0,jDgV|ӺgaWoE\"{QTS{>g`]>R(4?wZ:geo Qѱ^m,^nw㘳ageڋ5,gU:g?\"#)ShvggR7\rB~k*waNߢ4giI?F]	{[Ε$^#d	gkTPk\rqfI:pB\0%rCi*}gkg|y\Zog\n+acJgmI~\n~L1ydq6vJngy:Q}yȝ3i<eg	%mgy[lr|lH Ў7_uwEgz.9{ƁP&	H/ʾq\rJ%gLlaۅ	粢{e;~Q7aYgaaq$+q0k+&;\Z\nl$hg\ZgRz˂\0}.VԄXog%b]Zjd)-pFj 9g >0n)X2)0?8ygH7f*UyRD1ag5cszP\'@&QuR͈\\t$\nzQtg>ٗYl\r\n	PmAgns얤R)K>Rmg;a¿]Xr~\nt¹n29gVw\ro+,qB/qdL˃\'4#lgRA9%tS0:\\t&;bEg\r]Savo&7!أ*;{1g.$o8q;Z7tz?ǰ滬ڢ+gnͳ,zI(|ɪgɟ-S#bUCG	9a$RivgΪ#KQ]\n44wKgH7Iʊ|HiųlC޲gXmoeM\'|f%<>wRggdv|U=DFB;~jZfgӕWѦ\n[T\nuA[zGzagW<p`#MA͈H5	<s2&h ]T^ifI|Fxh\rʒ۩#jE;ի}Qe-6ĀChZ\Z\\>{%4F\nԒwˮh|#CU(28l9P,J`wh\"n9(ah޿[GQ<\"h%d؃s՝5jMdklh%{vg%b{c܅1O4r{\'_wxh%Dd_U,p=qd)h\'+:ugcYcg=hh*ӥq8aeA!&|9);h0zNW:\\jX%@f;h4cJQ_JV	pEh@ACY!I\rA`A	HP`.hBkD]{8h~-2q aZzhI x<%ji$hQ-D.&P{ة*hT}M.B,543A.7~Hh\\|qA\"_;^gcw\r{Ph_|!k\0ս^H$Z6yIh`f72L(Ca\\c0--?{haix.~Cוi<_ihs%5o֒ʀ4dkJPxPDihv>m[#_0kwh)Cd6Pha3̀njeciO~C<vJp<h\'?H_N^\ZoY\"EF¶x{8Ehh)>o,.Rj;Ϙ9ΉhZ}bΔrӍ>h\Z]2B02ݙܽ@=qYG*Ch\n7vռud9/TM&ohtŊ*;l.^?SZȴ>hzT\',늨\0	lwJhJYIB-#¾;رdrhͼƾekY\ZfmhVC{B{4Ob]=;X)(Xh[U^J\'~-u8\Z66|Nh3R._ K<IaŰhB	ZtUxW(b\"S+6\0X@hA>bekڍB3_RƲD`}h\0|ܝ\"_V^6h.5[-ʌT\0.&uP[%xhsX>ַDN}nA7vhh<gs).זW0xZHCDh]3l%Y+!Fo^=hԉ$ЕbLhm*˽LXH~2ʺQjx\Z7h<N\'j,J-\'%H!hռo8u\Z:8N7IM!\Zlj#7hjW\'gl\0Iء<$bX7hP?YjFVAY|φ+,1hF5?uPF1/\n?qH\nNƐtbh5EgX5ٻC\0A=h1pF)ydʱvNyN/>uiyr͌e-{]/j\"di\0i+gȏ2H`V:X\'likmŇSauWa`L3	\ZK_Li\Z%2l@uFi=_\0Pհi\Zq݈$0tf0!z4S+Blwir	!8@DaE{i$\"uH\"=D^gki(	(q]<\r+@	uߕ$/i+;N3̖ EݶA乴+i8pmG#_[ՄΖ\\[}=`E\ZCHbi9ƙ͊8g\Z,bmmJQi:;0$PvF\nSp2ֹi<Dwzӹ\'|uviEpwܙխG)j/vB\"=>ƕkniJ6,,T|hX*	ii[-R[4̠/IwFE	UUxi[ 2SY\0HCaQH\\i^dp.swKseClKm2 i`WVdgz\0 *N᷌^eipZ&`Un$P9xA	ӉĽ\0i~::lwˉΤի8Qi(wAiE@=r,}z`mewK@K$VMdiYebR&P.U{vfxm)iYܪXuؿC~B̭S=fi}eP.P|S[wW&w4xipwA_sa^`iMW@U}POOJjr4M_E{i0yNG\\89\'1+8*HdiiYS\'댵`R^yg4if\'\"Xe&ۦxK7lrT\Zn\"ijӨ\'i	.\'kWwHo9eBQin\"}Vu3)!ƫZϼ~\\C^&$iʱL.1ju0u/&S0iY4t4|->1]f)JIZliv*+&&@kM&Q͒i\\BiQ|[s3A/zir\r\rXij4՜D`~MyOwڐii<\nv-,N7[Y&il%ZFd=}3liYtiHjH7Ʉ?í:E\'eRiқoHӝJ1p@tio6 ?rG7N\"؜uIliy~6^Ӡ2Ȼ>[2ڊi5@N?e15Om_f9R\\\'7cŦit.%-x;\n>r#,K+ȷic\'͔Ҟ>:2nQn^Siw=9ۋ^	%ʷ ??w>	\\Г\n/XixhvYy){V\0W[,i\\NVѠ38bO\'tЮG\0ih0=]8YE\n*ӽnsiw0-vH;&=\0YHR}3<jh\nј(&EeI\\s`|jIW+{FСK\rAg	(X8jS=s̼*a	jg,Fi6VeZKFj~3jif|\n<_\rFvv`bjb횄^Usv8$bM3yj1Pmx GFIzw7bH@j!iH4]eL8\rSlcbj\'hQKL\0j3}m}:mK$j.QY#?}SRjj041@EX<\0+&Yj$6gCj1%F^;1lHJ+0 `j6vt5r#gAWFٞ#Y ~j7+vyEat;ZoF1{j<	ѩ*$*srM`eҋ!j=8PNT\r]LTC\0\nj@߁F]JUgD>\ZtjC,UMa\\kdDwiۭjG\'C1Khb*|YFjHq\\hA5z\nmk(\nbfjI\n&U@4o=w|xӡ^jOg?x =}K0zZ#IjPV]g2LRSlwBqKjY0?3{hQ!j[\'Gk8|5[+)37[2L]Uvje+=˵hOd\n:t(t%1jh&1Tao-;K\0%\'\"j{3JX4>7^p<j{jҝekr9(Мj|TT*/#[;U[B?,ܐ`5j8ڪN9q9\rD@fTUj4Cu\"B(7\rXF4uNcÈj66	ePCqtO;5(3TjeM*ijP.cHqI<;whBNb8\\8cj=Xi_ְނpߤ^ѮjKd5KGrr6Ÿqjq[@Ta`v+sfj+]\'A蟅|hCsj	-%ZL9I~xmHՃjo9\nՠΒy[1	Ij\ZpISbʟS}_Väj&Zy\nr[!đ֑I}	I+j~˴nBA-ԘFOZ*3yA^j[r㳇:9gsjb{fR\nCHl-)qF楙hj5`mF`NFK¹^.jnQ>£|grPdj`+A+95 SJ:9rj>~Z5[>[v]owjliѵw>\rq6X17/#j֯cQ1\0Fo fyHD0@)Cj]I\ZKxz՝^!bujp<ǑWZܩsS-Üje	nJd*unq@1.pzjSwKa^&4	tB۬iki85{?}\"!AW,@zUkbM\rC,|&P(MklqUsn3\\}%2?rzB̲k D,<g:-5Tȋl<A<k%\"gN\ṋ^*1u@&zOk2{z$\0+3QӉX˼ Pk3ޜ}i$|@޺UXRעLak8HS\0h!=wbG4k9OX3M;3#Z6wG|`1kC,zW׼<!?4xwY%kH%|QeHz\rYo6Fpi0[節kLQQ+Æ,AalENT@fkNIP-\Z7}HDC;ή>EkOQ|6[簮+UMT/2kTk\'be^9$?UcƮ9BjkUM,kEH+yJvyPKӨe*k]^=u\Z;d2kq5SɃXtb#nFVJk~S0\0s#HgjjBÚ`}+kIrnUühf29,kg6k^.tG&]¼k>bU>J\0zi\\T15Fk}w~kKo>K>EWM\0P3kl/OPcᕇ/T%@vYkXD\'wMC\nᎺ\'k{G9W1h`sҗD`Mk<TI71%%\ZV#ti c_kH\\,_\"Rm\0ps,aWdkQEE,ivDDBiRWk,\rB.+2/*6-][\r7Rkw6XN\r0cՖk3/B	ߪ\Zp\"Jghk!V\Zq6wz~2\0Wnj\0kF^.6=06I\'[kɷdZqNЛ\Z,F\\\ZD+kԨ\nARX(}&܌\nl(A5<kUۜ[9؀jL2u9?uk]70Tq#C֠Ҳ0jkZu,=\'СǗ:̨k:4j($緪ck&v]0d+mQkP;N3p\ZxqRWk)_H?zr-	5k~֙t`L5uY؆1kkqek*ni 0/8յ;n_E\\lֻqS)?\\Zԭ!?l=Q>|ZɊ>F5Yl!}[zm󪧥W#	\Zl!3E3G9߭!.0-4 <l*C\"fBIIx@v$l3 aA]\Z\\EB\\Ƕ4l@*RIW=\n$Z\0~\Z#:9lLU[dg.\r5p\rQ<[vr0lME9>И{L{Z$\"LwlaՠlQ>gO[Tb,M 	\014{l_](7e/6dpk#l`Elx\0.s͡&G&lf\0#wc1[qq\r\"PN%lf8Ȟy-1itmYbdVli\nle7HFĪhzWln`m6ʆ	I7E[(U3l9l9,7EŘ͍8~ZʩlH݇\r]0${	%O!lv3\0~*_;F2vlfL\\_Em;XFBWPlBfiұ6|ݔ&@Xcl!OeuyMm1/lK$s0FP|P\\VS&6B=ѲRlbd#ZIwr0P,[D4lĒ!z\n(M/RAh}li4쿦rnu)Kj5W	lm0h#25!v]l4VC:$l-Cjؒg\\rľϸCIClפiR8\0Gqq,_jmU|\"lꍫ_rmT[/\rmCS}\\/k\Zlu>,qwE	ѐ@0+Ala{!hPw{%&Y0Ғ|tlL\\=RyMGԪ֟LZq0\\ϛlgh |vt?*Θmm\0\r>ȑOv<kaeC@mO]^-,qsr6V%Fڻmeч_TG\"^jU@s=Fц5|mJz*sXUʨK\n\rvi}Аm\rXC9Sguh~RkYmem?e#T@aE`ۗ>+eMnn#mN\nTmG#И}ZYՀ\"mr:S򉨃73?kuLt$m9(Լy[EAI\"Be]m4v):=rlʒi@C\Z1m5oAK<fX]zu,#	3sߵm5_%$JSl#x~L #m7wW&emC1ac	=27m;A\rd+j7qNy	v\"PmB2phʧϦl`70.uՠ\n3VOmDTZ\rτ(czGܟKl@KvmNn5N:Xcd[SX/Mk,_W=YmV?|tBtW0]YǞskxm`6뽩%Hjl̬?.mi[x3jǎ\'<ڢ2ː\Z\\ml|,C+IbI$Ө\ZHΣ^\"lQAmlԟB:,%c5iN9mnm>ގQQ0504|$8]Wp_Ltsmqr۟W[z`\0fWmq~+E*U{:f~InmrOzIyǲqv˘qZimx\0\0evq 8<~T%Dmz7|WC	qLp/qLB`4}ըm|i)m`mI}IdKj+9V̀j|,ĥm~<]xL1A8z\0-)@ʅmXHdZd./]\r\'2QYqbmm=njp߮\r}l8Þm(~n{jeS-]lm@4q $E˻9+m`&k%RC_8&Fx2qSmoyfrGT^5\\kp0[*!mv<.K	1\\ WPL`mשs]S7LAZ&<섖v߂fPFmmG =~5OURD\\Wqem؊}BP\'|{M2gבYmQ\Z_b	E+MrL\nADmOxlꀟoPi2=mw_Z ʈ_/47ٻ$<mMڽݩ=FV7RͶ}9dg=mx*q4F.<0PK9\\>D[\0/.GmҽKBjSrJ3	3\Z]mӥ\'麙RҀҌ*z#:,`$cmJKG*aC;X`eʍ3{@m`ek}âyF[u\ne^m.+ek$2p&S`1q3m\\D1B]8CIصYkm%ʄ\\[<-N2ER0mj8tɗK\r?G*zm)iҎhsl&GCj$~\ZN nD9~=Zorbn\rr= sgV5Qno[{>%a8d5r}X<{nDs&UCn},i\0v_l\rn#O/jbwP&i#_`YОn%ѬNyش<0]儗칞Fn%᜵%9qi/RocLhh\'n*$Ţ\Z;n0\\Q{Mn4cyp}%4mb&+uvBn5jAx3fL{iƎ9n>,S9# \\%+9u_P,nB_؜\0.w;2MNnB%E¶>9d[[}3+hl_nH.01UTTd	`%vӍa6{onLz<kɅ7k-\ZAADפ`(2nW;σ܄ؖk T\"K[\'$nZuJƻLczۨcf=qu[$nZ\rc %mGV@m@vTIJKn\\ /J-+\rX*JiHn_XK\':U䠱?55iD>W\"Hndk.Cz]9fi0jϏ\'YGg>nhMaK#\rc%t2O5npggz g5s.n5LW4nq0#O}\"ENt!CntCE1*9s\Z5jsBa\Ze\'n|]1CׅpHW]xZCcL{Jn|6|FӺPLTn}VwrS8=On쏇>	%KSn~\rq $p\0%0wJᱥnTĉIvyOiǒ4Mxn-Q1H.x(jի8XDn!5]X뭛S;u<}3U8\' n-yu_\":~I8*2Yr5npXɛƗJX{a	nd),axć!n;N9@I-z̹>Gq n҇Av2ON.=Qk5on4)4A9rPn0oF!V_1\'xhs<z=njwc=јZ7V=urhnl9MrI2;4:[$\0n\\Q}[Y__ڻo;!2n\0<VEկRmKr72kkSe\'#nҨ`{̔bTmMf\ZQc%nG0%E(G&WX1tF!n>y`k6j\rĝ޹GmInՒTNt\0wɆ #h9pXH%n灴U¢HZOh?\rnטTĪC[at(!\ZV.b\0n # B>8VUmgnH ¡n	4\rI.)3hhv&~Bn1hx;iLsU1OniL&M٘x=Nf[y=/Sn%akXEȭHȒwho+UYݵߛr0~xOs,2wohQdM\0;HՏp7Co\rP<)ňأ/o\0EŤCwh#9\\铽|oE²tQQbo\nrQq\"/o\'g<Ke>S$ۺAWغo2q\",Hf!OצwZ=PLo5r+}o38Jo7\\jUB/O4D`0`/Eo8[N%:	V*\nل#SALo:G$.\Z%БFFhSu<o=|V:ܮcH)4懛7z[_r[oKSc3YW$y6Vl21@9>oNy/\r*Me	Um<E^oNBv:yu֡(?l^0E|-oSK)p\r.F&t(6gD)coX+\rY{C\0u#Oh,ty(9<o[Ĥ~)4&^Sō~e7ob$AE\rK$:+8Uob3!O\'fLK:odw¶&dZR5^ف3~togÞw3@%>#W_SQyotpg4{/QP>sw)=ovQ\"c4yIARKSUo}HK<zkh CDٙ-f/o]̀h\"xdHM\\joQt\'FOSژU.Ro\ro\"Hy{](ȓoLM_@D*X`,oKͿ_w4M:Py[Q4JGog8J_Y՟\'c3>2	:o}\nd֑%?M웪;oC{WuKiW|;\nÕSR7Jo0^|,b3+\0T60o#(!o*lBe[뢕33Ŕo×؝ VZ8#0xV~6p\ZY}oʣ3ӌȯ|(u!nJN\\_=oׅCHla՘qnF}uo<b<vbxE^TTV\"A-ot.[kΣ(y^Z/Jgy(0?ox_4\"yh@KEw,aoɑE+wdc#{AC\Zgo6LWN3oH)CUHkfٯo֑R`#:֥6dǈ8\Zox6}DP\rMb1a|iNo{|^&$Cgo˘/ܚ|o\r1d._f/7qAEo3>˵\r]\\q7Xw1XPPoۙ\0Cgs0e7Nf9^1x~pE ߭Jߓpfh6CpRbvj+9\'baچTp?qx}~|ɈXu;RV1`p+ڃ.efL\0Q6+Ԣݳg;pW|bO<fc#_V|\\;Zpm+>\\#J2=)\ZXӮ=P	~rp4ߞv礱]re$CfJp%h7=APc(@Ƽp#e\'Bg_nY	.@p%{erB	d>HK5-c1>}p(%x5IYKfMQ	ڭL_:Gp1bNQ|Cl&91{VgZp1ߔ}J`\nFgd\n7xu7#Ep7RVĊ:^L~һ:TWWp82*Occz(uеasGp<D9ٌ	DpH2LReGMp>\rNh\\dof>}l p>2xtntqbpLdvX3\">bǄY_[Mϵ\'p0pTc Oj-΢	suj4IT#pkxѥLҗ)DAzYnV8pss\nŞ\r>,|LyKp~$\ZtB@gZz^Lͥpuq0{X}+\\\0%*p(Pe>c<]k_ մ[mp C?ɱ\0Yٗ)۱06p!.0d/ir3DNU\0qsVp#eC{)bŪ@H(ʋ>:YؤkpyJz\\EHՠT`\n\\7pBώj%T(:\0.夨XDp%јȮWz̀+QSr=:5p;Y}zGЙ|\'l>pYѹ!eu0v?.j[,Ĩ!p	mq$1SAQA9bIpW	/\r񒃄%\Z`pmӘD.uIdn1wpۺ {Z[\ZՌdO!nrp Moə6nypwWp=DY\'cqŭgaw Oa<;9pԻFia%!Oũ&F;Bya[pҒ/FNIM]\'ޟA6:Ep>+Q,2Ye\rcr2gpu-i,pWc}hpp9\"-jYs1h\n8	k3Dp2W|[MQWwv$|Cp<*wbEHzL%Uc(,?)zpt[bmM_Iz\"[j/Op+L,Wy4m|CpϱKx;=#{`_q\0%k\ro8?A9,Yȉzq,\0:>|ACzlqm^n&hO`t31d2Ֆ?>qgba,O%VqQ&B\'3`˿n@\0?\0hqmi\r<Ёݶ\r:;ǚhq#+R>.3vWՏ)2a7q(Fl苗njpEr-R~O࿾SN+Kq*ODlW2a\\,D%1<ܭqq.\Zk؀E#q\"q/~B+G	WD6S x%aV@nyq=1#;+\\^p$qC쀏k\'/:7+VMQkqHAN%X\Zrq	(UwU^M2Un1qP\\KpƝ+>wg\'$J(RdqY3i\'GC?o(\0\"+I}lq[8dws#bj:75q`-:`R@\"lю%/_\"#h~:qcO2vh1(O2g	_XZUqijje*ZHG[?=?jzԄFaFqz+kאFz37-R6>#n&q}bNOnYV8YR3SHC\rjq:&Kun-V3htC\\62 f$\rqX.{зOW6Mo*xJR֡JGqwսt.\"7l/EdZa2qϑ\0d@Л0l,֦tDq]E3b釃fJ2֬7@qCP !3а_ d	ǸuuiGq YƱe$irhNFIl,oiq΍NlFE7gVr{qe&\rCv2t`ˢ\0dx-Ix6q΍e10qEAyFɫVqU5\"-(sx;P%PɣTqʣuG(aV腐7fzLmĳqΗvCF0w/Qc}/[ q>H+eQu\nd~d]=߿iWtqB\'FTDGUlf`]]#q$1W֑=J=<-\\#q=xuJ(ƴg}?\"2dJ(q\".9xy)(1lTbrŃM\n.HD3wmybrw]Ʌ@{w$ׁyob r6+,&6VЉG3t:9)Tr.r}#76G(y}qr\ZW	ܿd,ֈL_@JJApb\\r<Ke2K{EÅOrrqs2\\J]\'cU>\r1/\rS\"9r FW얬lvrp)d7r,	RBf0z^*Ha*:r,q	|ƹp&e7C%r4(^0F1st\nr4r5Wn@]u.IPA2c3r:Eޡsi1`\0:vϢeC)rF݈oebMє?%p^n󠶍rHawVm7c:ܐa4{+=[rKX?kz^C9X\ZeFY38_rVj-jn[Mw\n=pɲd4cr_!LPpf<vs$\'orfi\r~ύbXm頫drheUCs\0VÝ7?[\0f[-~rl[MÇ\'H$>Q_rqJ,>{9=\"\"%^\"Ck3@rsDS_\"?3%k^\'.Ʉ\\Y}rs%>sό?BnBdM<:S{rx.ttѵ+tI!X?N@r{dXZ7,d|9D(v$\\U2]WVWr|1	P.;FvrF0^ػ	R^rb4.5o\\jn(rO`NE+5eDp^5\nѢr*)+3B;#!h6U+8\ZrVk.)<?33&r=~βS%rbS䢈%VȟV[9n!ϏrY\0jo;q>w,urل\rUfO++~*ohVroZ`a%,@H\"J7xrm\"]=an$7-j\"\"4)NMrrNP_; b0fL\"9uS,r;/n#~؆p$`͚W}>r砕Zqx/E{</^ $U^.pr+So$k!iEGH/.r눸#]!c\\(*P\"r*%P2I7\ZKaq#rQ[OGO\'ԘLˇr]`8b@#TF\'w?ݒ6rٴ@c@{RCGd^>>E\Zr߂CZZ{L!(;r>}z`(ۖ2P4]U3:s2(ǌ1{qqjyqZ~!fnܾgs	tNq*o\Z\"<\Z7sB\\g%-3ya;β	t	/s#a\\8Q0sl}߯]6sH\Z|\Z )SgyYAYeАO`~s\Zr:<[Rd}:Ydy(ѩP\"Ps\'j{FCh\'GMg0fs( 8(\Z>e6ARQ!3>φs+\rU\02#\Z~z݀hss.CU۠M^oSF86Es.!o\n;@[\nɫ:#YzTT2>\rs/\\~К̄˹uߠesA,8±0˩5В/sJS	.n(SsNlD\Z5̂2GWRFՖsP34	5>۲#vGpsP4ͮ4qo\"F\\	^:QٷsToz6{RQe3zpps]㺅lS_0^v=sr).RKf\0r\Zpc&{RGpsr)*yKB:-,f٢VMtCFPs-Z:qtZukCH\\xĈ:j8s,(4ҍpۯг(kJEӸAs#nq0{RhCLzOEsus6E[_K\ZK#n(w!˲0s#Xۖ+pFXT%??crSyNκ&I\\s\n\\H-/F\'aYʣZ9Y镎Z/sةYޤ.֢=cJ{pW(\0(4}\n\0sP]nߌrT{im6isk@%1G/Z}ut<yCSs_dYekP(HP6POsCw	9٩(x\Z2oM$\n-Z\nsUO@P]^ؾs9sU$$Vgb\"lxms/1K-ˑYxye߽sɽ7ɐ|m.D9&d1lPs\"[\0@lkS&VusK#m1\rQ\rӫH\"\rބs8N\Z0-1¶M=1s#[-&}en_֛ĳ,\\%sV9ƅYl#\'@2\0_w94s2il)1yjuHuMt5(I:E[t=m=w\r[p9͆\'t䬥t	`$K\0H5O?7;PCt\ZeA[^a{X(5t\r{k?ikC\nLḃWyt\rHEwCl[ mt*̽vdW;1!lH9\'<	Cftߖr#qx>`|k[k(\Z۩F=<utϳ₸*e}j-[qA\'t)s:ĭfA$˝,h4NۄtlT^7?1	[]#T#t1]$mi\"lȽ=R<ωPlkf{t4үbrCli\"Gt:sr9ca>S|0+/\\3j@t;1RRK:-u+EqjKD}tByiC8ͿL4DQ\0oztGք2\ZF]aYJbptG=9\0aʮb>\ZOzc1}tIq|\ZGwP8^6eNcf	tzo@tRkZ]yb\"܉]qto=9ږaH&bWH):ctGE֐\n!3w&[$ftrX#\'XlmRq{88F񀌋t=)+ϕ©XT*PjaEt\Z8|y(e[\'w	_=mN<<AΩtGV&^`.^2IX&$G9, MBt6\'ӾX~\rL,%ݾE@tCa8f\r*?G\rG-t-aӖоHZ* ޟ,ktAB٠B=)RhO\"g;t2zvf#:M{%t*8\r?MLc9u:vbet>\Z/AG*6e.Qit\rs/wZ\ry2Dy#y7tǌҴ%.<As݅,[(.tؘ\0:MB\"TSjtЕs)WjDrDi<6NFtḹ]޸HZMmmt{yҒ?Zlc`Ds\noqDt\"mb!51T-\"Ϥ\nf\rvAt\ZfɫyNQp+\\2\ns]EtVPuQF5M7u\0o\rs!\0Y\'r8U}ll;!Ͽ>u\0eBHռQ|3d0AIuY6GD➴D3mVgЊu\r}[-BU`BErZnZ?*ufKM ]=_mA98\0u˚p&\0A\"i_I\'xu(#^u\npR]B55{ouLr#W@h`vLcy*+_]`u Nr8\r1\'p{qbs/u#gTd.CYgЋUWa{u$U\n<L}B;~ްq.6u%Ա8,Hb\rG\'8w0\\,u)rB.pc=t\'s)<Iu-ѣAHZ64?ѧ:}u6,]g8MUd]87NXʢ}Mnu>7D-$|c\0iX\r\0(FOW-u?|P4TVm+sqdm~)u@?Ԓ$p*%r(b=ϝAiuB\"AӴC{h	P=uK\"E)+؄Ea/ut\ZuL;ީݒ<sby\r7JV5[*ZzKuQk}J֏C^	M۸uj9Bt\rL/.n]2j1C]@u|̈Ǣ*w&L|QJx_BF*	(u=ۦRnJ+^Z\'=U\'u@jh0/ \'0OMuS$z>JxD:p`q6ֿNYuDΜ11{i\Z-jВu]$) w5h1#}8t\Zu;rjJ%0$UC:\ZY!u#eo^3|xPu	x{	_Eۏd(^6ujPٟz܈uP_C1X\Z :z2EO- vD˩uCOҊXRyb:N uF*҃3L{ <pJu^1<W,\\VudoC3a-^\r.Q}	u)i?aW\Z`y4ӗ[^\'u[\'\nnRXoӦO|u-@uҶV>LE\'f;R%\\~ju\0RJWh@$6yuuy1H6Wuz؅+<Z<uݪR͖y#.D6F3Nucu-(,7nsIm<*su65h*ưYK Xuߘ][|:Cu&J,Oa\\TcuHU?/:꺨Aw\0x2ښp>Bu^dn[F\r3g@`}Ȟ	*<	v\0WbmA[8iERS0E`7d~v\0kETv3dxeʙ\0z?`v\0:)б\"(*=Mo	M1mK(L|-v7c\0|q[jQ[&LƗPNlv9\ZR\r2@]3z#\nq\r3v\\$YTp>*V&Q=^ÍC{ExXv\r>aK2{-Y7SXa8LvA4[Uw8I5^vxgggy)ΦҸs!@XQRc1Fv#\rm7boڙԘ6/`\\3`#Tv%_\0b$m&`(=m<b\Zo0pv(,H:%2Z!]C)739\"zv(=YFcĻjt&[p٢v.ΡWԻlqHor\'Jm7bv3)<>ry(L1yU\nvfav4Z}k j>X˚WR/%j5tv6\\yvT\\M	FQKGu0v?Hmrq\0L>=e\nSRv@nL!ro\nڷĺvDs>sSX\0r	&gA\\Ӳ!O,vD&/4xm\"ۢ0ICuMvLwn,䲴K\0\ZfjD᧞\nCG2pvQCNލyUO5YHlCvX\nU^+	kCǨs[9\\!vY<\r4e6oR;ՐC;vZd¥bNpz04\\\ZLIvvgސ^ \0`vQ[vx1ջ}0/w3cg(pv|^цEOx̠Rƌ$GvĜe7\0qnc^hڣvb3샪k\n!{;]\\;~=J8vc #]-ߪx bҌN]v*#( RhLFoxv!zߨA1 `[-vC	a\'F;z(eJLvhй{h&ȶqc1cb%M!vp<;>`Cx Gv|Pu<>n4pR.sI<vqnںI7WF1@6)\nZ{|פv2ςZ7QXwFu}vɘ(f]A?pAR\ZaƁ& A9\r[2v4~\ZjAw	-.|t\n#8vΈo5IGHMrg\0LCHvm1/HU)m(<AݤGw	ZvYE4ŦRK堣b@;|_@\0j1kv{_5[tZ;a+̝X\nx\\&vA߬Ĺ*4PtA{o/=va-iQYhJt	Hi2&i~v=}톭:vt!)T&4v\Zl8݊sUz	wנ`g0O!+U\Z4jV9woHpÎ \"M^Y\"SՓwA!(v.Bc?[D\Z;vߍEUwnOk_pQb&-Jw!di]1]-3>~\0oVHw!ے?ERS^RLKAw$1QDiLꚑ6N@wy*w&C}5Qْעu<4Uw+hLOw(# ̕0|]L\nC̠\nmWw.<n(GFEVB\"wa kfIw0?pn~(3e4B!QwƻLbw0}`#@ZE\0ZrT\Zw;*Ҙ\rp<L$\r\rH\Zw;[f]XÞ&y2,Fw<[S%ln,-S~]MDpǌw=c^:^N[ X%%N,w=li\r;|Hͳ6&}U0}\nfw@c|h(HzX[_:x0)KwA|1W3,=3V*wDigk\Z#VJ PN]	Y\\8dʜwHGlqc5\nVq\"=]wM.#S{.휜DG8q(FwP:B!n$d2e|6ӹѮ:0wSt+\ZאַHHܷzHo\'3{w\\,`oiY\'cp-_;\".%DaYw]<	^JdOhYHמt.(@,wfƿtoXXG\nFĜcIs*ߤwlE\'~N\r4dAˎ@7j;.W[gwnSs6qBqHAz5SwqqFIoT\';B«pJd騞wu諪lK 3A	;$uFPG8RwGTĈч_|\'K\r,#scwqX9\0V\\%tw[˒VC2X\"k2,G\\w\rMw~Bͣaը1ԝu?n \Zodw]}GݠJ?fPwd\'ќٍ5(C0awP~.;g4%%&9:G&wmqdDo$R[WAPw0̃|^;YmnLi24w5beZs`r4>KL XsGMwdN@*طzQm:)wհ$]ck\0ŏY\n0}wc4yO.~H{_ʗVГw҈rxAe-?HRzw>Sa	?̜sziþwΟp	lր> \'.:0t\"\\k/w\n~;H4ǜ/t_vi%]w^q92:_k_]z`=*1w$h04~W\\GTqx;)wM:.h,fhpp.;~/:Bw߹xo\0(+%5BBSrl?!Gw Q~uQ41\nx:w/bݱ\n]\nANA\0vLGx{s{U-FiTȹ	xxҴ@_;Wi>z595xvA7x®NF=Lh-_ރF sIs]|d \\x\n	sd26*Pꫡft45bzx#oC:[L6lrz|w3:B=x.`L{v)XcnXe\0)x\ZJͮƒjP8=1J[v4Qx\ZE\\k!\n\\D6R~xwؐ^tFx{֦7`-Ȇx\"cBӴLOȅq6*A//|TT3		x3z	lrgRMq;âh0:Ӷx3M1w:̪xM(y/2,x5r#ЇXt%JFCD\rΜ\0x7.%~BHWHhkG03W6a7x?&\"BJ\Z	6Qf8E6^KUq\'OxCniЗ\nZ$Kp㘟L\'xGր3Xy%\'3 4\"9I.xKP%LaڡUx\nGUTxMM=x!9ӚǥjxO|#uEBO(%!fUN޲x_QH{~6[@4\nw_*M0xbneɠ\"&ӈ`A\nL]@xh@jAέΰhY*~it\nw\0%xhd@<NA R>h=xlشkS˓%+;r]>di\\qexmmSYStOw`>8R\":g,>x+RlL\Zk5>vưNDxQ\"0?L2CuB˧>xQnggW.6Yz#IĲxkOml3ƃܮNL&exu]!%\Z|8c˹?<M+GGxtEc\"^\0yGؗh(=DPYxDfLС67[\\F2ٿr +xے03WOd{63X+Qx@&|z\nbu:\'\Zr|+x$P&}`\\QyGpr*}9YxC\\A*1JXgQHhDgx:3R(\r\Z6va`xŷ(G*&IAvф_R!?xȈ\'eŎ4m#8uVhxo?!lN;8g_[jל3&΂q3ȦQxA@\ZOt+pYc\\ 2Yl\\xgظ(FHHՠ,g@k6olxTn^Jn\rC@ԠG\\xDwc#Uʤ;TLhԆx\"N\\tkPX<$.6\Z>n#uxSn]Br/u<\rxR#V5*]	$,>TxTqHxl,B%\\O!S<yRxԴW%\'7&\\az< AKo%|7Ky ݣx#\rjۤETCIfnZy	.S=	[5@a ݇Oj2\0y\n#:3i;lB[*Uxy,$/@ӳ^O/\"Ҿʹ<y-8<@<]Je<w^ۄCY0By3KdX]q&C/-I¼Y(_y8Vx^kjONl\"3`y9t$JfƟ\n[dwy@gթVysRmmcS\0=NyK6h+>AW[,1/y^&	\r&H3\\F[5\0/yc++S&a1gխ[yᗃĩnyd-fr\\>X1ʠ-QNyg۱JgzVx=Hyr:\'?eOFZ诮\03y nvWb-re?yNT<Ry8e(@$k(\Zy㈔4tFKv9g>M@y JөuXm:(@yx?Tp3I|	;ErU}yǧ8=u<&(3e_`\0yUb\'d04to/\Z+]!d:yzpM(`dӍQ*/U@,c~Ryde+_6Ne6g+.M!yW@]aX%TyG9J!aZhA ;61t\\֧|yu~61ZɁ\\/[l(yݞzҩC`IQ:Nw;yL$L	rjkKjVx\0Isy3?}ϑ*50vJ~@zF+1@,0CJO!zb֬۳ygFbeE=zkܙeRFN+^GɓMz~J*&S|#\0LX(M)yvzjgzLjR3Z\n\ZГ(nf\rz$p~=Pp\'eyK!v^kz&}w4\ne-!)vz7\"YZ[\0]1!Tejzz7)#ϦvE-1gVz;npûa]ON	Bz@ӳSvCb-߃zz	7<@2JzMi\";6>_{wzOP\'K#w>bdrfL^I>c6zP*$	e(WI![(ܚ>< zQ5nѶD 7Rv-\"vC͑DNzUm{ڿY>p֥xw\nTmw\Z~Iz]n\\){xf#h2+Ch|,d.za=(лy<e孍zbm\"%xtOΠJ`zBw߱zz=[8.V~N&3rvEzvbferigfBwzee `~wG$us4oō8z$Egg9K93)U:SzH&/EU+L-bqzR\n>ON	Ո]~uN,4bT~Rz\"1\Zq6O4&t.smeLzWTUDU$DRv@nS^9<=\\GzpYuOEk2h!yK&%KʏAzrOU]LWq$NAwNz0xk[ic*͠02ZzVr;l?q#RS6OAz\"|5ܗ:lW8]PbNC~zХY\'RHyRiV~\nȿyzoZt\\$Ƌ\ZKu#qAmtXzܡۄQ$NLvnݡ̈́d\n5pKzZ`c^JaN1h_z[/\072pJd	x\nzB9O~+i	ѣ2Mz-6i	F<>LO<kԨ1\nr\\z_6`3~spFFD]`7FzkϤcQ=oJ)\0.e2 ,z;ŅKA\'50\\!Ng6NazHma~B;@l\'eۼsDő;z}1cd[j3%ϐuehoڥ:{3lp^3k;\nk{2w\rOHSuܟnӟܢ{ű	87:(W9q0&7*}6c5{wuO8!LfH⚋;˕A[lGE`<2{*^YtHmMe,*y{ ?.g<A㣯^\"6\n(J%{.jg	7[:ǵָ߂g0Tv{3NGY\ri6zYR3{5^MlK:\\!qUtlvR8{5yȆdj2& =IU,qC<mU{6\0D5\'XD#cpN2e0J{8Pg\n]1Bװ,}LH{:7c\\pY@b3V?b{@न$g+Eg[r3{AK,![C)p4ͣ1{EA\n	6Q`U{M3#_B?ng<vw-i{\n{Zn7S{\ZCk,_\r;5{i;|-#qYd_;QH\\B%{kg%?O=75d9Ba\\{nH(>}Q(ab>\nFY+{vq.L303dDQ]ZD(ަ5{~82~\"HPAU2Spm;.{ܒѩl\rӰF^F=X95di{A,qw7Tz/zg{3Zњva\n$(>FWn\'I5{saVmH	ٱ+r<ĸT;[{yg\nP:ot\\LpEަ)k\'{\rś911T_P,[D:w{A*|OjD`j\'3;VWhC{$7ov(1<g\rF4JĔ<\\g!{n]\0ֈn\r<w˷X):{,t4S)hd;}K1{9<NVtgG\\e@.rgھ{;M2wժeeZ|Q\Z9PLn{g/\\Eǰ\ZI|\'ᄛDi!H{OW=!̏W\\\0vR&~Gʽ#{k+t}Jf0\ZP\nrhkߘ{!~wpWb!5váj~\0A`l{ЩN7!QZ\0E1ͦڤ!g{m\\5</nJ PK{,>&˷xd:mwѠ}&{Scd{:jUFݯ-}vᡐ{<Ƹ@(䠔7\Zfоo[<:~p{xP *+]L|p^=n|m{cD1\"D]]=-c\\|\nLW\ZSUf=ů,Ug|]o(jF\'*١ƗEF$K#|B!.\r->HgixܖA\0V|#vh`JOAx\'^|%mm$OK>űYFv?{@5|(\\Q&j\"n	\nuѠ|+^Fl7رԴ5d;|/CqQR>2uM@oy>|^|2ieC3WI@ǼX6!!|7Yt\']oҒ`΀p]|9!=ޠLMe2k$svw?|Ed\rq#9\nJt|FYc~\'B _-dl0h|Qh[sob\"Af/$||U6s\ZJZ\r~5\Z|$ݚ|Uw.G]Nlg#1uʚ|Y\r:l_ƙ=ݤ.M\n׺*|Z:q}+NՏ3c!|%)\'h|a%=uUnq=ag0QqA&|b)MGA\03Y\0QyL=|m!5zdlگ4uOln{+P;\r|mxJ~HyodoN1O,5P!G|n9q蚶FXKCp13\\\rb|q7rߍ{,\'̌\n_|ukpf1eO,5]vR0=I`|{F\Z)c	5!q8c\\kpK>|&돕1`	B	Nt-se[|-ߑ:oӁli<a+%P|R\'gAEێqqT!:O0_|c;c6ܦ.\\ԑYf%m|\r٪	}Ui=;|@A6)ջ	E=L|fR/^d|\Z$\"_wB&it\Z||o5}G[=T^!(/-1B|@&o|X4Pu@Co9Rd|zp-vd.,[\Z|QbF|[W0_\rxN{|u_Nac:-;|pѨ7{͍+F;}U|-fFjxQk_\Z4K{|ʃ[^Bcx͂Ő^@<=FD|ˆӰP<յ>DdA.G}}_|ͭύl٨W{v[Lk+|th;DuȒL}SOB||z,j=gȷ	TF!wd|N!xV$W8qIAC]1!	|N|~hx5w&A AeGeõ|ؚqY4z6bd#}~Bh\\]:A=-a\0}^\Z%Eݷ2=c̃PF٫}_ئbqی(h=Fļ}	hW?. \ZR*kC$>}n\\9xrk/tN\nX$c}*3:f}i\'pāU*5x}ARwU`A7hɞբv;|}CY҅8#j<Q\0Ƙ:/D}C.-a1t>ߔW1\0Pwv}D	4?s.M*{TȇFd\r}G:~0~<nV-P\'\04BI9}Jz0$1Ǜb#,=}P/jS>|Z!6ϛQ}Zqh>bulu+_SW.|7 $}`|GD]h\'b8Nw-V@\rΖ˥}bƋx[-gFˊ欄ratM}c[/NHjnL\ZXm}eExI<gB\Z9skf(h}n\02(2)d>ƁeK;nCs}n\0:%[Ǜc쮲I0Ljy*u}y#ũMssDj\"}{q}S\0o;y3UE_c}1%npWc%98%\\Gjȷ}nFL bϋڼ]\rlG}C!Mk;\'?]]VWAeBߊ}F|ŵ:։{ʏfV}Pd,_P91+BwF~M}DuغiI|{&މg0}D*;FRw3bGon(XydU}w9!\'C|Ma\r-SF},B7=kf GqCf=\Z1}Xo\'Mx4	DABD$PGs}_,8><s>s:q_:>}ʞ4!ʐY6Y%dXSٻ\0G}-??^[Z(Nbkv.o}f2I[ϟpD[sa[<<\'\"}-6\'fnTY@y_{|n<	}߮Y+H	ܥ`֒#ʅx-6}m-+vi1s\nU8u})H@VbR\"\"ͥ0׹ok}yڻ1򓌗F}Ec,Nr}	Wb2cfHByuP}yMT>Wi]t~\rU+5>\0/Ö05U)G~ţ\\)7O;海E/\"@~e24x`Qx<C4_~\n-5RTw4}3}w3&y7~\nz![QcCXuK|O\nftB~CpV_<rZJGԹ?ο\\~mY<b(uU:ZiG\"♢899]~-v6%i2@}f\0k=~5:ܙFLWs@놘N7~>,O0F2vF\r}ɞkTZ;Ӣ~C|<Zf0^bi.~xn^j:~DZST̵p-7Eev_QymK\\)p~G686*\" f\Z=^\r~PjgkΖ	f:\"vEy0sߤd~QoE3RoJ9>Xε\"؇1~oLB[\\#JYK,JA~uǽ_#I\nm	yh\"\"`~v~zS5ȢiyXpdH~x\"&/V!ca6ft^~r dKHq#%YZꗉ~QSncX۝;0±1{\r~e>?I$VЩb@6G:u~6WT-J\r昫gĉ/K~f~-Fjq<8J3߭bt~^4**:rCs%uKhd~\'>yTp\'YğC~A!\01d/D\"N~2hQi6M*^A#FD~7^V%Fќd[~`LQ\'}|T3 Hfn~EUaqRh}?B@:䰧~47*s󽻓edzn}ꮈ[3\"~`嫌<B\n鲙%]X}\Zi~Gl*h$*V{M&UlI\Z\\z~`xkŵu-jĭ<+ԗ!lE7z~ЫqӋSn|C.c:Z~;Y줛NPl&4%\0~д\"\'6xgk?$uJ{R^~)+: 1Ŭ؈\"la@MSӽk~Մ:٫\rrq03aͽ!{-~v<gz_ݑ	RC	~5B[1E~P%b`V[L*#헭~XJ8+%uB\r=ɻ~щ,e\"*\"+_Jw~ I.XrAUV f_HE\rAl8k#h@w}}	Nż	I6h%^?`vY=2{7ntA>^HsnD\0BĈߟ@c%\ra?Ñ	;;{,__\'&xmfR2Ih+Nq$,!%>o5&qZq-So4P9u,*3R WIJ<\'ֆω(<ddgfL\r9;`\\tMQDj7iDfba9Q[٦\Z~$cPP1D\"\"6?+c:3S%,#̔c~rrwC[`.\Z}ͯ74bpM\0wdJ]@ܶq*>Pz0PUtMW;`[ոiku?E<0 }Z5ij=8D_IP;aelb3ݱUu+J^22\r8M.^(\'{ɘ\r\r=[!feT#o4)~Բ+@wGՑ.4COiCѺc#%<\r2\nt$eu_(ujp!\0[;Xh2P5\\֌(Dr3f!UHQ^3\nACi[kLa!-G~@7̍po3dO]/:\"-JN>/:L\n@XdnVT4X)FI֟!}6R}䯛=bԉ@JE+ersu<f8slpZ(Fc1\'濉j$cFePnaަ@##s0Ĵeq)]-׃q\rOVPKLѐ(Е#uu.\0$6i2nt_ov߉pjOYvqQ,|a6-=S֍Ipd:>%޹Ч{Lsq^րv>~urZ_-n\"	\ZI1{[PU?.0f`e{	h-c]\0rNg%_#kCӠ! !ns`)^a&u\"񬵹V ~\"aee/P+r-SXB)Jò@$-j|QNրE\\9~ *jϢIY\01sX	vaCHޯ9΀Lik8>:Gs^u`J=TN`Q5cUFa=OŌܰT\\hV``,=OYn\"=_얀X8GR\0z_B?<(Ќeo[]!slEXs\"̀u:@Go5 {`dQz]<w59qJ-&]DV.&vw}Bvp75\n*a}t fGE{#G	;c\\73!}\020͌Bi\\5,k?L*_Ȅbu%dNv3 tp>?X?l:\"W\rCQsgtS`raN׾8LTҘ$xDs^h_!kC\"1\'_Ԁ齡ۣzeZ=*q%]GţZyg܅+ZNy/N>3Zjf@x9lPyfIu&p32ƀ8FH>/>(Y̂fXW	=0&&\r	\r).qz#b*ܢ1VZʀ/699Ԡ])\'>OkhWSb^S\r)[eD<݀zG7 m\rnɲ_!S	ڳ25Q]2\\T\"oLܝ>0Ki©9(	\'HBd_:Ȉ8Pf6*#6:cKx:1#٨- 	4KLLu蔓6.l37$؃ee\0JA]F*otdB\rkιa{,>R*yx][4L	i~޶>H%|:T@1rzGzԄO~iE\rY35)>FS=(k)Ytו䩋ż8]c>%9\rϤfzU<Mh&EN+рہH O>06}#<QnwkVYԇ/ @E^n[\\.I֩`Jxnb\Zcmܭ|ۀ\'&Z˥~oƗZږ\'6\ZوO$l9^ws\'yЏo5`@G?Fj\0wX]QJk(čM$i4]gfQ:fsl@_<8&W\000l#Y0߀(O/Tܛ\rマZ>i1\rKhUq*|/ N\Zճe?ΡG.(dÁ0-TK#i>l.Z0K]6x& zؒA6$TMxEft<l>&އCy\Z|W	Y|z>6}B@Z;̐\"PZf\\%Jah1WdG7_r<)\ZѝK~.iW\\ y\\FeS#lt^5:~/b]{.\\+B BZ3#`~H\0w/>Mq-`՘nK<\nAo^{\rf4.xi:pYAdBK\r!U3J݁nm$]cm<r,#\0!8*J1܌Cbwypø\0EIntU]װhUU.ux\r O#ryR^2v *PL<ŧSҙd;ضV\\w[j{F9{\\dDā]HW\Z_)tWV+nNJtϠw8ث܇Si.=$#	b/:LV䁜{l_3t ny@8\ZfU[}UD?\0X*Q}w<K䲷iJuHe\n3Qy9\"wފulL.9K@r7fp^\"esPv7[,=A++HҬEL󁵋jQo<>\nYg1bݳ]aX{\0鈀[_8YRCUpzB\ZԿڤW B84lY<Tiִ	J]8Nػ\'yX\r2\njV/P?,Ŭbf`)A.?q_L1t4mTd6Wok,Ӯ?aG#xv4z1ڎ!JT|_A*r]vz/aS5DhmɲĖ-o%3->ˊB7J?n)p)=jk\"/%>y3,-I4QWT#\0X^w@sI\n\Z3w u>e!Z+r-W,R:f|\n}\Z;ےg%@tlsjjrƂP4RkՖZ8,2|nTD.f0l<xCqZ`h\"$vR9yۍo4h:	\n*-}f7n^D{vSAP+ʓ0:uo.!)_.㤼]\\6D]0H3IQDxFn 	-\r70~mwktĂ:>?ޕ~鹌3UC]}>%[0Nip<,.ES觸FK4Nq\rUOt=axܥ?NNx`V.g;GӄBq /N@STuhd>;6#Y@A\'{YsB6/s>1[3\nfJ82Ĵ{YM\Z.Ii)R~4b>1ՂcŢut	F*G.fkIOȺusDrz-|%fƊ2gn2I {C[HrA\ZbiMfMpJ0K}p``!Ew@\'pBۄOuTۖ܆lWGUaGb{\nikTvQ4E\r0E)lǻƕ8	A\\ik-ZN:l`&@򩚺`\'a1k̖VS+\nWyM9>U:\nբ\06\rQ\\lz?9yNqJf0]J]]\'*^*_达Ht|ςC/M;K\nAt/ct4ipv8-Dv3p҂]#$5nn-fv[D.ٷA \0gw@Ƅsң1em96X}s?ǂߵ۱}\0G[&^;fg8Ogm\'waTPanmS*@GނRs7ӑp,y<}b(RSG;{#R@O;ܟ1t_[_W%h]W#[S7ΰe+i\'f,B3ͷTY܏̇<utC\n]\\J=\\\rRqL腪p/ĤDQ.Gȗ{<)MP@xy`E\0E	ՎJ+|yE^8}ؚnt&Or0!5¯iF)BT1	48(d56GJ\'C:R,;Z,\ZFB>,\\	Xwl4>o\Z[_QjFa*{VǴha{&S+<\ruڼ`B7D{D/Xae|LטI\'-^ﮋMG*\rjw6.$Kyo_3D&QB2\0T\\\'_WHum_n(7SE5JfMEw^Tw[Xj4sG7A)kP6j3qD:%Ȫ8D3:f.}%-&,\'=K[!inQa`E)/:jo\Z/Ff>DM%3\r6PdC>b51T@\rG$D^7~݆90bS,mTr讃<\\&e\nP\\*Fy?|IhFIXFHE\Z*9ݶף/BF	>&уG̣rVl>lA&N=H_ycáNkzG\\_SHД%-gDEkJ54A6#\"b2SvJ@{Ny\nD;V&I3dORvPڞsM}N~5_4vPKp5bm{mP8㥔Hu	U1؝ڸ>)T}4:4SmUi!.<eܨ0(m\'@Eq?VYW>\0\0qM[Ol\"o 舲3S\r(7VVU7(X\rdű`P$WE@4xTVkJ8%j}q/X&VbRtN>\0㚿aYjqOL1v|b}|UZKp:Vzǭvm~_ Yo$bܤr924?yk[]I8eԨsbcvVhRkFKO	t\nPk 2S-q;A-blv\'8dou.c->8|X-ph&Oʖ}[nti>~fKJ` 3uxEr4wzZZS$梖^c|ٍ4|c8\\Þ9Y__s,͜,\"$!nK8Bn۳%L`N/~s܆4}?\\QC`Տ&m&=C}cS<%`	L$k㈼O!Fh[Śڟ&IEibܱl@!C]Tm#h))/~sP\'0:IWUsA@;J/8qڪgÃ4՝~iB7q\"lDAבA=<h9)AltXB6\\e~cĆf3,%1^9z©|yg8T:5,uڄFjX4\rW<0Y&3p8-\rlt3hyefQrJJʺꦿa\nn`@üKH`>-g{V9\\.Ip?H[sBHxGqZ8/Z%Fw<+-;QngpՌplVN-_.^YymĊq^MK=^AuE+c0,P$Io?5jԘ浻wIK`9q8VZg`<E\ZD \n֮\\{AkUk%#$\r|cNmCxSErMrRq5zW\"f\\nCXB~&$CUҬ#=ďG21KƃFaY\"%\'+ڥI4	\\oW>OV핾w_BL?=I u^j0<>/g7!Vn%W89Ӧ$$%OXT&b.\n>Ltd>.\\J TC~0=/1=,OJt:en967ycԅ3[`&0VVCNC(x[䔗	\024*#LR&DO\"C<VG-;ɉրJF\"טVXRH^v,\"oQ,xv˘o	abg[\r\\IPG1hFY:w	bd23̉]LE* 78>bLhܛڴ?h`}]hrIm8jKwHjgB@]Byq+6ƀ=_7h0ՒRYnw@>Z<TN+tiĝ^~aָ>8\'|mFTȍ1krhݢ:Ms^y=:P\"gxp+ky~mȝG|F:94uZ7>fثDiUgp٩v䪄{\0/9\'x~Ѱf7Qˊo ,|$Aߌ͝`s݄_S;).;ZLC\'8W_w\rz]޷vXք#bxN턦qFLg~~4Uڟ+\r ?ξz2l=!ߤ$x}=|lSR!-p\r!증Ȅ\\&O	&#ܰw_J鄶;m}e(~y0m=},ο	e&],Jpw4~0\n܅e(866gPEt	sYkMcǳo1+Yl璻V#N0kkTw$ࣳWG(qϫp_jf?8omc5֒\\PM%ժКm5KgQ(\'s+Uc(cC93Q?A\09e(rQZQ-:ñ1ZŴCxʞdd;Zb^ݭj,mne0@vk\'Qvg\\	T0J\0(=D*ۘӵ>IWNJAG\0n>aA䰦H (XJN5\\<*m\0\r4$IVpY;v~yc_\n`\Z(R]jA\0Z(ׯ΂|\0#~^y2ctH&DO\rZϊ@yE|s.1e!ɂVww\'zt\\FP%\rs)[n?K \Z9\'c؝	Ů|BH;C(B$፱Ÿls@0jd2S*\rKT(g.كt}	zCS0j$ԒS~BO$SAn?\n%xM,RYIj6s62a)wdV圥1J{hV \'/<W[<guo[2Ř$3(-p/03Q/LB>S%f຀Bڬaj*41Ko Jb-i.9EA~+|%\0@mKN D3y>۰*7*/	\\=Lo|I&PKn8}eN06-hosi֐pVw%%:3CQ#+g	e}X2	CX6MD/.=3\0;N(OfK]iMCeEv#h-=]|#)r)\0\r\0xҒ_q(9[+B[@%s5FŒjfpvGV;Ir~uezE~=dKjL՞元^xm,@v3o\ZuU\"i\Zhؐ=AAaMvx!!90M֗y-t3oXDwX xTA]W)\n&#*g@$\rvd/٦o-wqʛ//ب%H=#ul@ht1TGwctln74@qeZ\0p7gKzXFDk˥g%h#lXnG^Q2pQp_5pB#:Np[Fd*n9	^ݰە7mI)zkp1c5c$pS[F	jb<CmWm,7d뷏1\Zh6x:i6Lf `Oz1Qkm:U764uW6][&HjFj6\rnX\Z8N//&W6 %;@֎W~\\Aj!^Eh{RPٹ:co\\dZ2	h{\rjhO	gp3X|)F}h9P*ŅwH_q~e`E:{Q[8Ėb΅k֖Ft\0\Z\Z)f>YeåfuK(K_	&Z2Ji;sb~~:K 5(Їϻ\n-\"}x$f]. b!pOg[ysEG7B)̯Z㈅aki Ij5L.\0<3U9->:v/ZO65J78{#^c}z3bdT\'W~Uwi۫uEfIrqpEW?#܈*\\f}ժm۽fPa|s1jϱCunQjҾCJճѸJÂWS\"VJZɌMڛDNJA1\0sP+?>~y\ZYmp5T\"V\0QDWΧ)\nc\r1T2Ȼ/wt*5хRbffoE.\\sI[(.E5Mh%IL*4y@`ŉ_r<JFUBUnӆdp4H!WlkVv33A.<3df3]bv<%pIH:W=Άgq )	@?\ZefZ3a +irFTn Τ~NpEZzU)\Z!:y4g+PZ=	D\'9ZqpDY\06)|)0x;Q[5SXc&Dř߿RY/sk\\h6kK4&my0gFgjqM]+vLY֥-\')} q2GZU\"|MgqzP7Cg3rB^}j_W^b)ZH߽XeM<!K\0ᆧO?af~ÃzҲ\0dE@zˆ	9 *|-B\'\nCm!G~llz.׉m>P%~.!0$udn]5įon.`[X\0G\'ѝ⁀Qk\0%ɝȷdTK:oVLE2.W1/%[p{:ò̞c<\rw{3bP;:еfoN0mq ԙW弗k@{	_ ۹\r=ոN69\np=x/NӐFs/ȗ\ZCeܻiL$@V_%ņ?RϷ7㡍@mBc?mJcDX+C]D$W+fyi><\\4]\nc\r6K-}Bl]H|Hӈ-	r(\rnb|8ҚbPOI45[\0>o@χ^+򍭑MrV5-\r\rJ<)kW嚞SY9gv9+gR>$jAb׹W\"0AE=cݶG/twv7K㛴oGǧvtaAX9{TeΌ0d:ʟF*}O#>\ZR\n>1V\nIlEKѦ?Z0JTULeU2wIORy1Nhu¿I}؞)iVxo%r?A%F+[GBv +\rX	x6R\naX֫5F\'ԇdJie&k	F{Zp=U^d\n\0m3G&ewY^tMUed;9K/\0/}J(yZhiq5t.ȡ[2٬֍GDkq!m4@x5g@Ost7zQwtQKr!}^{vnݰFP/q [yG\0M\0,7x/@69	ЊE*#/p?iQkgƱy {#N!6$\'W:V9b\'X?rw?jZ{OYf!bs5&)ڧFZv΅@g(:%fSÇ\\o%E9Pˎs]h͂R;bE:\0p&a\rI/	<fyM\rؚ56N[\Ze:nVچn#A7&[/=scҴLHDlCbǫooMI]2|P^<qD+nox>MOYM^_d+%nG#Hд%ܘr܇@BU&l zw.NJ<\nӔw2{SU%	N3yu;VDcmWH\'KgR\nЛT RsC4Y??ҫzȷ)FN9l,V@USCZ`M@׷uѦLem`_FQ/IPN懐-!u螧ŉaŇ)֜#](Q\'nyzMa|y~ ZҊ%Cv?k%\\Z83P#W(P)\n՜7|#|ig@Alg3P;}q8F\"+Su>=th@~1J#x9QbvL\n\'brL\r8֒\\8cI]uZͨ[\'i#3]bZ\nx|uc%h)q\"Ot&;Ji24{3.(^Z}řۉ*E~(0;Zų481O ik(r.PƌؤxnGAhYI壈.o\'\r8?Seʞ,[los/E^`\"܉R&\"װ8k~i؈0v6-Wk)(yjRv5ӓUē*\Z\"Lv::	ȔjF9r t?!IUK.\\ʾ@V:2Gۈ~O_iS\nJI>)D3j\nEI5xp*I\r!	PifVqlFDI6	IȱLkX|2T6Q1JP\"Aұ\rSP4In\Z*0A\'ϫp/]R2=mى3]KiѡGzHJVS><ɧX[\"v-V!v[8bjjCPx\nۦ!1eE:Bǉ8!>EaCteQs,MzX{\\[(HfCPAvm\ZNO\rL£ɷߎF\r;OxV1W]c	Hg;IeɈy5FY^4}!?~W_	@?2lW{*2;ˈTwFw%v*G&09tVjΈCBݙx	`1\0Tx:S~F\n\0<8h,O\Z_SAሊL.)ΉEk-@͒ʜbeWCΙqG6\"HWW@XJ#^oZ!Şpstՙda1,69%ef;V5+~nDmnC!ֺ4K)݅3_ʈW%t<\Z_bi4ﾋF	9;2|D;+]J>`Oi]QvOw{M(v_1[F*J@-$ވT$TDMR녹~F-5陂{?L\n1TYQ\0^W18/<WͻW5^`F	xb V>*ت\0Wx&_	3g_`Bwi[\'Yd4 w񪰋;/u)٢X\rn.\0j-N7pR$ΐ:%g/_o[B\nKKxm|T*H9K@kdfdQ0?W*歘fa9{~lyEќዸk[C)\0ُڇ]S΅HDWIF~<X1g9]=-Ҍ>š08(	D#z>>>O-a\r4hHŔHblXT\n\0y\"HTs>&h]Ҽ89xTa)aRTfB-.Rc/nM,=g$(}BݮD9i@]dE^%;\r˵ciF~9l_@։+)w\\::,SF&+yjd\'<.~;~^8-ػ2RN@P2i6?zZy¶TF-i<w#݅k:!kW{iVB}0.Wtm\\CAm7tbv[5S{GRi6Lͤ~[ٴ;R6y0v )dP&Z׫1q:!w<u͙R/\nfJhvi5rr\\z\"6q%	!cr)\0\nD\'	8H> kQ*;MuO*-\\jlGw}V>%{n\\z;ɉmkew[pԥ1%7cp!L7wg~]\'=,79v/_!P`4oMb#:;\0(U%@ډed+\"-~$6x@96\0Nω@C]^hb6LKAyoDYJA<G\nuwS5b#fJWneoRެAW_fEn[ ͻ˺̀n4ev4$֌/\'䕙tvl\\l]V.DrfGtWO_x>lvyz@IGs2+!oGH1R_\\e+! ho%9ӭՅǱ~.K$a&tLT+l*҉ك	KWe2P[, G7o\\;C(۔H\\ݘ9f/V|i3<Pin\ZEO,5<F	ZIW#4Y(|\nHn0/<C~\n):!\Z[tAmEJp]HVoCu	17,su͉v,KyJceFG2u]\"\\#3\nVdH-SL86ݶ;6	);]Ic}tv΃FJ|N%ɀyO=PoУ?\"^cίk܎oT+%$[&ysFLݨ,dp2,+*_	{֊6!L|u\\:D{nG\nc>Pd0[kJXǍ.hy\rr1geA_gĊoy#ބ<&TUo|6k<XL;+MKةGt? LA$G?Cq꜆GGTyQOOue`hoL\'|\nvAۊ|P:6hL6^EzPuK;l)GChqkA\\DXsSeF݌/zq.hk7\Zç8?tq[N\\c<S\"UBID\nm?5f;S}gjLdH\'jnJo?g7$>QOPL&\0Q{o:8K@H3T𥋤\"M,O=:G>ꊲރuheO08xٽ\0y`]Ytm`!l{_,DL+2i4ǄʊŅ.z;& qû9Ԁjփ7\nTtiCbOK̊9kk)ͤ3Q~iδ);jX5`)V\Z\rB!A(?Սn舍qȧk3kh8#ꏉ_ߚߢZc6wO]v㯦0NVɀkbX9Q\\\\7LL?\0GXMuxظBg=d̊%WӸsK{:T5%6]Dum,zoFSIa)~aF=2wy2_16	eu˸dgMQWSYokQ`m{Ҹ\nք=R#Q\0K\n)}$$N)ad*\'I<})ػP*lwKB($1ܠ>jqvߑhXwd,_ߔEfӧ}ޜs2C`h`W>X:*NY/\"d[ÏŮ\rGQh-s}%%&9w֋7=!EʇQ@3/069#pcpCMboGMKp+m+Xb!\"8zH0i V(+kaP$5-]C[%=F܈\\\"YgD)2\0Ւ\0U(rbwǋ9k\"m{R7a%,qJM0w)^<et	I\"V\r?4(]N`.tHU?ǵ_-ϟb7b\Z	\'fp>UG\0Gc3I>έj_/*DӋRJGL1\Z8oY=1rZ9@-BxiUM?q!0_Π+\"g%甖O0[!<I9\"NEhܕAOk>f59%,<9;]9˲i0Ic;Ɗ@pХP\r{I\0odQ?!YGwXET(r=ryE7Uw%g$%%Z-[%Ƶrs%Ri	o7񕢍(<Cy]1ԣ˿DGrc\nˋ/Dz@{ӄ0/[Lc\n?8-=1ы	CJ-j\"XUZuޟȱAjn\nrقi7˯@\"C-\'(po/Ç:&sۃu ^&HpC3Q3#9\\\n#Ihq24>M{zƊd%ѻ6\n\rR\r;;-3/ыڊj9yv\noC/`nyus!Rd/hZSC	]_90 )\rT܅rX5D1z{cQ4&ڥ[Nm4Čx.\\\Zϋ뵀8Or_m$3`7#&^H[DW& ʴ~z[0uO[j2\Zޘx8o1bprpW-{WFvv4[i?irzGa׋JE&A7!M)ƀoJ\0Nyn}-z_,pLhO܌pCR[Ȥdʱx\n\0k93kcbTxvT`!j_5B5(Ȼ͹X]LAQGoZρ/\nىpR?61.xl\">܁%|oʮo3dl݈s9w./ xF\n\'#N(u%p \\#VxqqCLyuU,*;be0#v}P(\r*(rc`0;cU4Ô#١љCC6?9:PkZI%-U?M$@EFKxq<m΍HKoH\0Le⢒U_F=`o^FpiO@^/W>CtdKh]x:WWamX\r!h6Kw?o=7o|<ԛRSKVQLnwrs7gxP0_x_z֓ɥzd^ЧGDC.%{?_z~>SQrOOkfnVlf쌉8!\'X;	`>( Mݕ-ɩH\09k]4:B26e]MH=\'t8%BiY4OէZT.H:A9\"xim8I*\0}(H֗d~)vvHrǌTs5\\Twa%AkC>e@O33B:I1a>d\0ep#KKE\rcgyZ@^IͮsL:}|9ƶKXkه!.6{OlJ[!?xԒNvAi-$NUS`~ߌӕ_nAlλur}DfЎE2fpv\\KO0YM.Ԝl5b@cX[߈Qfo,k x~6uz`؊ii7Rq3@nM5݁7-7#KT7n.=$qY\0\"M(͙-?M\Z5!dVF&|NQgXȇ|aы_挹7Q\nOraHQ61%ٺxO[Aa\r\ndpH/	Ԭ*b5xsrtZTzismK<yJD@.;0\Z\"`҃=ȱRvHmf`lsW5[S\01̐~d)ڷ0\r7k۰:wvg1B9:u#`OÓz,n_BB\nSd3WL+&쌑cD`_edvJNᕪ>bg2ZTHFS}!*rUjk$4mxYIXv*b]Xȓɿ0foΰB&΍J_\rk@7W	$w(MPXpC}ݪV.\0W/%=M]ZX>\n>.\0x5#^WPrE!oϦI]1PCN9\\f1	2vvm^Lyf(_<>MЍfvq\r7jZ2)i8&<0~퀍m+#DUR\r!GHl&#VU-ѫt&ubvZѓa_I\nBcybiXfK׻Z HWrRkLCʝڛ/x\0s-Qہ#\0n{uuty9q{~Fu~4[\ri]\rWh0@=rIKԮ~gğ0ȣ)!ѱK&@<\n%	d>?:_ΖC)g]%nQwU[ٛҒS{ze98쳕Ggt!3]#޳jN7|&?0_e|!z\")kf(\\RW;ύg&{Y\rZ(K|I`ڍǰղb>Y>r]bχ39M8l_\0GIprX>m>ÃOUyvH\n;Q^~E&9PP#1Ɲ9ɞc]Aıg\"WAҧ_gsUM-Gm\"cm#{t##!6\'D!ʭ+}cUH8799(#\ZrImZHiFڗIyVowT.X%7owփ)(%h_h>b\\֡q<pZq3gl󪙛#iUP(sPg/Dg}#&H3&XwҼY:zq{I<sUxtWgAO/mưBrb,};` :6PqL:*;,-@nTY/unB8mUMܵ\rcLH)5OoJJ[\ZS0C@(AL/Y+\0!~7$BL鐗㊔5W]_ƄibFE&;^QnGB71O[\'Gd7z\r|q-[8k* .\n,o7?ou4<HiKKgD#L$IvxD!fϖcDFC ]5XQ\nx!sTP¾T1!].[^:1#<q\'?:	`BIrQq\"ZF~ަ-de*|ܗ0`xŖdfcuo26h|{Y*W%MO1\"bQjH=G?̡TB@0|ZZE.j}h&n:R8_l#,Yl(X׃hj#ɫzzilW]!rtT$MKP\0⶞lO\'d}eI\nKAuЗs6|q]<Hݧr@Xa\"cƎ|W00R嬶8Nh.s)7\0;XRؙi8TY$I78ٖj9f\\tI7Sc4,O/`һc\n]P;+UKCK7]U\ZdQTƑC8՝X!PuQRSGCiViMJ\n12\0x1X؎*hjye+)\n>+y|\rT=2&{$Ʒ`z#?@\\\0u5tiktj3\rhvacJ\raӓg-AE{ݤ3RԸ܎T(P!=+-r\Z?\\{FʎFMGzp	(_v²&^,`lѻƒ\rzZab\">Mrٍ@kry~ĺC9lxu@Hy>7HfF4<\ZŎ]sLoxEl!\0gUg\nG\"G-O\'B ^c~\\fR;#]1@Vkh@i,۾<)RPo12sA\'MBˏ	|N[ig\"lՄ\n*z\0Ǝ.ނΏl-̴_U>Èpaja1\0;`T!߳h_~#cҏ[${-T\n뚉[GokAh$maߢO2gu+<bI*S1?||w~`Ua=\n3+h9\n\'KK6l9A_E:jގR.&:YK-:oRF*&\rJsJ\rd^hYefmVr%)ӂx	c`9ri	1E?c-o~qjVTrgy{xCRo֪҃H~3\ryD#o\rpj@\'%PF@uaUA\".z߽@7箏f<go[R4rNyOX4Qh.Ssw%ڒw@ENFphEǡ\"!(!~߾V[[x6 6ď(\r\"`4-XolKk$돩%U	m-8MKFz),x?_M1Z\r))u^?;h3+\"˭bol3mzoΏRrgXbw]%<Q13lID8t?Z151P3?6o۞Ͼ$W0)BOᄺMX(ѯf7yӖus#i$	\\Xi </jս\nڦ*ϒ\0+ؔ%V黉yw\Z110+ޠ]  \\UC_s磡4]jӤ`w\'BޢPjiۏf1L}\04n91#m!)~ʹݭ>Q5ƾbW+6.47􅺚buZT۴Qs\Zp.(Y*釨u%yyeSh\':x\\F`fsBX0]L\0W=,[}|\\ƄaЏ2P^W֡Cۙ#5ѯ#MlW\0#_EٜL]Z>bډuuoz5*-_\\a#2|B9\rxiCM}b2jsEkw$؏h|aXxNGZn7Pt#W!bz{&xmQ /RstŰ06<WU.s:I>S#Ѕa#z槦9_WljEy9MT-6fOlb]9P𽅌@1^xzoU5e2y)q n +⯐xƐzdPuOBPf99\n{ΐU0iq ,1øώ,㐏_icB7H%K \rO(>_4f6y8q	tOY\n\'#i+EY\\Ц0|ϥcC]L}@L(͙VZg|_}U)I=8!T[@n4\rS%rU67DnJǄ#Nni\nꐩ87^*S$ @K^/T\Z2LJլ@~\")?A<%++	Bֿ i=¤[`_E5H&#.\"X%2RK#p	yOcu.+Qҝ`,Cvݘ\rOs\\݉ onYǵ6@~WYti:/$<h0)DtH4>~Q7n<$\0ՆP0T\"\n@+\nV)-d C2FyO87$kHFܪx⭛ i{PA͆kdM\nՌ4c5@iY&5^^H+v5ƿ^54Ales^ؐפRcgӀQۋc@yvj)/stm~]F$̳5̋~4Nd^/Hv2:w1N	#2*T%ǟ*A@N[턻A{)pC1:5$S{hzaFª]-C\0&ʿοLS=p޺ȑЮ*]a/>^o</9?sLv#;4O-	_A	=t巡d]^#Ģ#q0<DܛG:)1\"{/pTjٖ\\\Z?M3d]L_|DIH5-\0.n{1)\n-QG\Z?Z}/3\'l:9w):I)̒]O9!+Y6L$-fq&趇khC{dvc^̟9eQ_Wo{_HJй{&32ke-6T7QʂwL.谇M=B֑]\n\\wo?JH.%s|㑣q!_ m;\Zt7q39l\\il^j;J \0>VpBqw{zP\Zқ~prmQw	wz\r\0AtȑN\r>--bmYUMeIq\\=R|Yy+T݅́v	b)/12)b\"YB(dQH+BtT)aHsvx}>Yjo\'\'hXJ]zT]B	}<{TWI_i VHY(oߠF\\?!;a_A&$t=T2Q}p m55@	^n4k=\r	_K\"X]4@NS	twҠaF^\r*8~hYiֺ\0T\"2ÊrިT!!,~rm?eI縰OE!@Z[|i(~_M8U.pFw:E`MBLiE ;ԊRyћjp]c?\nTMOmKw`J4/ww-6̒S.^C(59tHY9  ˒ qnJ0\"dJݍR\Z5,jd\'YBcH7*(ߒ,$ީk.vq.B!|Yxᒸ=ђ/} 	ԾA9{!wa.3`tm5^7}MR`-xɒ=X/E\n\"RS-w~5&$3uGsY_ԭ	8?%-6 z&%ILpGD\ZkI`8NH0ÒJGU$ܫ3ރE:O2%!-랒]	\0Xܖ\"JBn0b>H3,W6y2]KYb G\r_駰Jv{[\\ŒawxJ\Z\\Hqb%Q/^R|?Eۚ]r9i\'\\WbG\rG}k8Nf~lrAQcr-A$:TV8&E75gowVŻBћVj|kp&a*9oŌ\\Crb!ԒqYjY9MHEX[Xst4ݎ%o@LIߟu\Z\\o8Dv1?d#XQLcnYX)hjGwK6vf3/*xW .ks|w=Ͼ\"hn\0d8+ȫ\\CShJt|1s(/Շ.<@CaCcnd&1PX%dJ<-ٌCx8`\Z%F$U$g@It6<I!*a.%e5+p3d^bLLT]@G3:Omo]?G[!Y֒Sߏ1֓}dQ*t/^Röb=9@dr 2H4ъJMBѦ}\r202h(G:?{r\"\0\'5wݳt3c4Y\0VI:>	m]|\r,:kK9	\";<wc܂FP|.(\'J97m1ZڅF<߬(B$pXyIp]hYm~LR,4M!\0ڧ҃	hkΒش<8ޗey\0VO\\(\ZX\"FqU{iM$̵<4lؤ80/\n}J`3cl6HW2ťAB ?ۺ_R*b9t\nmAo\\}a~q&{;&~,\n 5e=\"FSXxVԫzzw(\"蠂$Z>)c|&.\\Eȯ\rҔD8<\\S{]:wXosD4JKi\\C&H8oBD 	9z^q-76,svńTe}5;u+,3.-Ï9#F}EjvA\0&5xP,z\r&8gE̓\\c>k,-\rhiIZ+^ FFVWF5br&Ub4\'љ2@^̌uHs;za難\ZH\ZgKl&dglCCR7lxOPw)òYjݠcCڜM\\Uf~<49\"Nv?K2\Z46;\nF_>FY\\38fGOp>Kes!2BS\ZBeLƓ3#ھbj52=<P3vPȲKLa s,ܟboY\rqYfxMw|W$<&h70_;V|KeuϏf&	rk7N2wFuO4-@ctɷ3(kG寲\n΃CD#6u\ZքEڣ@K1y\"/S5 M38i)BC[ܚ}w)Kp҂UڲI$ho܍~\'a+_~ZWKi7/ZHz&0,y]9Y&͆^|W(~|\ZRcg\0M+T#Nv:($KѼyϏ7bf㓶?R-ej2#XH\nd5\0·x\"}v}u0\nM\nd>ᓌ@fy>?M#  ZgA~Tf;@,z\n&@]D6NI\"\"{41`:jcs=쿊$!:[\"P:g\rISlУ/A\0m{jqf-WJ1EfP ݩw#F7up[Tmw\Zjn\"S/Q5`j΍m=a:Ym~Ynr87EC\nj1sD!#~L<hNv*?HA^3Jc)U@3k{];ĉaՌQ{nTScZje\"ۮbmQ,QmMs}MܹnËzfZ[SغoOx@]]}b2x$ $Ӭ#X0M1_6my	C!?_}շ.2On/cXqfvFL1XˠQd8k55ai*UWs⇸s{qKcBψ*\0&Ƽ\0?wo%R kfwp	Fώf<ey\'Qݑڼγ tTcT꣇Xv|.2d]&IOuΥaA,D]9$@֎=EIR2(EzhN욓јS$GJNglc^d}\Zb/}[<3hJO|ENC\Z*ulCFoE^\'F&\01T9B\n^HH^zS&^F޿hY;knݔuyҺ\0v&%0)^\ZA6tXmFBl>z%KЊ0u\\#^#\\L@c.Y?,Zi>~V@2\n 	CF[KSaz߅ԄraG5;~\'enٵw0֓Q5\'PєD[eqzyx+OsegP=<,iD|H>S|F	0[bIK\0oةpĲ|ZAi5pC\"piN1.MJOrYrؾvߑc!dȾ|J7MME4QA#k>nTa XZ:3oƈK.)|TSOcwDٛOeij3O)|=c4H/(y鮃\r[y~	cޘ0izʂJ9&\"%Y\\|5u .!\0bL	[JkD)(fd[;#5K}H4Ȱ\\H-t5\"G\n˼^V\n&<4mEJrk[Gg,KIn\\D-3_Zݟi_L5>}R%ZA>%|ɦ/Q5b\"uTJ	e-BpWCcixlwub8\nwctf	\\>2պl5zZ8q}\r2	|gj6&@(ѭ2S:,K24Hb]QymhhB%Ux|m`,oii`5A]IIX#Ia__I=S z@*S|5.HRQuJ_jW<qsJ,/B{q_kakY{$7F--s➛G2,a?d@];2؎|}5\Z(m>Dة1 JJM_rNP$u0PoSlf=[Iu3mK=V\\ԇ|ޕ KpLi9M6FP 4o#1{߷rٜYaD6E-Ѡi6,-B2)Y\'Vؕ6Mj	m9$*xgU(x9;=JMZ}`෬e~vJG`)Nԉ`$C\"§H}THq\r[ߡJeSCMpkJ;\\a#c`S->Ie\r/N^wk`ݸ¹\r? ytbg=!ӫaíj.+fc@W|=\\}[M f\nn!O\r0!LRg?2zlY	iHtq)$TSmL0YoH|R?@uuiQ1p	2& (yR:1?^+^ߤۢRuTJ#+/ܑ<=aĽ(}xpza{0\n#μh=M;\"yR[7zDC:Tr6ֻq&4k{#\"\nv2?9E/sxٚq4Q69`\"-tP(cn/>f:K>v(J<S7ع2أN!*|WRIa_	t`ꋷMoHj )1\\* xf1k(oEWg`raӥ)b@HO?5>PQ	F缃`\'%Yo۰&dtQ[\\EV^\'4rsϢN]-;<v}\'P[Y%/?_@e&9!9HSԍra-1ĕ8+H.	*Es&:4}t*N$onjMf> cPhw񾌩I}_>y>TZ֕Е\'Gpp2[zDwNjÕgm3J]m0A)5JNrYBz\"s`M:}{*G-̺(^.cPs0#	n_VZ^h7&~\n쭕1+\rnf&)	*~3ЕX=Чl1Y^2xO^;\04;%B|a\0Հ\Z0L)#^W;9$x0Gin剪RK׆]`\r?Lu5Rev&-kUobE%{\\2mPHh)jSF).Zf项,,$N7qn8\\vΡ7ܼzL{{MTG.{})cBrFQ\nPv|BrvnG\0\Zb8;G7F[~:n5\"F@T練I+@>H#qL=a.cU\ZMwJ× \'b\n}\ZQ!x\r5DQUK܅ޖU)1s5BPaǲwРUȂU+_$i\nSgjV9(s=V#^k=P9ۚ:wVCYn{Umk6ld$\r(\Z\ZG|Tpi\ZqM\0UUHH/P\n֖}}pc8QxΜaؔU\'͏i#_hdw2閂:(O.Xi+&	ME	zFg>Ơ?r0SU=ntꖎo1:ѳ\Z>A\rq7BXVAӋ64/Mkf0O|%6`	PIY;I(ϋYۖ:\0 ӲmAXVK|h1O%	Auf/Z\rGs<h4vuuH_^+YH}oX`[/	.K\ZJ:hts\0N@`/Zxo녂͖oWxۺ!Mz0V_.=*ym\0#\n9ky,OQV8^\0~%g,ۖC{!YRa\"	`F?MUǭ[*«stSuHZ1VvTV)vɱ͓1\ZܭV]i&\n̅b.ʄ%Ũk$ Ȏg?Ҧa:&3ܸ<uLJP#=9+Fs</X-ɯ4W\\\nR{-W^ qIB:U{G@B=\'&ȖG|ud-pyO\nnCt\r$eI8a*\0DB0)]JqeMs䣆q	+)dDnq4ٱxr*ӦwRZ	ZJ\r[jjՂrVh`FrES{bWP*P=Nϻ;\Zi82_ 7j8nYb@q	IK`bdeQaA[ز=	2m0s`R\"V*FYE*HZLT\\6r:*OHN܈gn<@>@ATm~FmӠNll>hG7K%wsZn{8IʶWgvZFϜ\Zb7B¤I2Y!ln}1dZחM0T?2FޏE޵Tȷ]dF\\\r/BM^UЮ^ʋ\n,$e˜Z`@Z=l̓d}^OgM5Ju0F;\nNC(ЗnYH_tPwOS8\rs-nZ=njqUv]\0x`dqhU}xFen9>j5d3=YsNqqpcuȺtV5Ȥm9\Z8q}u}o8>&V&NA,\rjYzL\0ڛ|B-R7IH\'i+^Fߗl$d3\Z&2	%\r%~W8hs+dƃ*&9ɯߗ+n}`+j	QCPfԥEZN%=	$ɗAk#<QDO7nU\"\"\ZMjuԗ4KiMg2`g*[\"!vO\r#-SZ8(ɃAҷh/v.O2W\n9f/3MM;#GڪWO&tSO\ZƘ򗮟:.PBIPil 9h j	d*J?^wzTGЧ,ė\n\\yq#16&Z\n8ӊM|Fa\n|4&c^\0YD1-8Lt;kn$coa4MQhAUuBੋ9ELa=T/8,i?5ka|ꏑGT,=޴P/6&..	6yhCkOJD؍Rj^}]!zDW+jJ4i\n=g@qJMR_SubK?aq{R\ZlS~栘vYl|Lu\n#?T\rsŋDv;UZ؀Z{t|3ۃ.mTi|u/;^(w=ˇVyG,h^nsT\Zd-E$wW*Hk/aјoZi(r]\n=+WU}O/inj4u.ne\r/9i^<GrɊcn/*,\ZͩX>Q{+c,ͳmڊ9ϯ\\-/O5dXS^`M.KU/))fߧغjFAUתNSIw*/\riwl%7Rc(Z=mۗA\'j;LB\"UnU{kDM潧+	uwe]&Θ^/:qQoBf lG2Ĝh\r=ɬ˥cHw{TRz>=MƘw`wnN3=͟hKrrix^ՆB\rEb/ZJfmCy!9JD68غ@@[d}Bk\'}I^L\\95NY;?zaE=J8[C=Sѡk{[kr4FF1ܿ39L]!MBN1F`Rl>)퓆o807MRn}\rľE~Ő\r\"\'쳓04tbtwK\\iUVD}3y(s$T琱a	Aa|;Trɯ(&o{!2oʪD^D1,GKfoat}߆#Zsv\'cg0e\'WN.2 \n9)Kb}SpMcPAYXk:\0^U1K`hsG+{^٫X(ߛ M[>mMUr\0<pi~-O~\\8CoMt}qqXAiYQMޘ	\0pKNrG\"#EJp~&w _ژl7Sͻ%p[!	AR\\	q;ǝtQdPpo6=uqe4_oqtp^Ba@^#!\"~vR3kDi;G**RYBhAF*psbFO$>(&8CC\"6\0W@Z~4\'7H%Eq Ʃcn\0L*Sω03j]<XvrkRp}NdHwMuЋd{pɫ-SESHѿ`;sVҟ_T	1KT0ynϐQCj,c]rRƨib<_ewބ/bO>ř^䣍ּ!7^~I]Ӕ@ ncQۚIa>bG_dEh)pFq7f3!R(YpOi,mO#?Vb,C-ܢcž\Zhl>aʫb]Be5xba;Rrm]Bc~=XUm;nVP+xSoY#B\0su@M#rDKv\'m+p\ZYv1]@ôy$]6qK (H__8:2zY*ۤmro:lT9Ɠ7Uabs&sQ*%P+݁\04[_ݙx8=bs}|Ǚ^\0)\0Oy=g֘eQb\\z^.wUq%AHAC$Ys6v\'}rCt\rK;\"\r)]W|in\"Z!G۴&FGNc,SUHۖFYיo~܇] OLHPx	9lKS#n6@#Gbb5_*BpX㙓l9 Z{~_ܛgj6f1Խ陛j%Tv^\r^K^pER	%o[$lnEZqP_}*56C	3M,A-mHFY4!_n8XFӯ2t(Q]\r%i\\~򇿶Foih5+y(r\nx_uf(Xq><\0Π;1/QrVw\rAU(\rbe&U6[F#`l,+JxLGV.sиhĭbW|XR[й@\rr=[u\0T9<	c&Aw\ZENER>|t<bK(C贵(s~ssYqi6-%1L˭ݐ;\ZTtufVrfR}Go2uY@\nWܑк%?;`,CՋBxVu(|/9Jې@hyFZ g/&,\">JB%+@\'(K4\ZU+hA\"?_6GAm!3h\"Vj`\'PtQ>w$鿚]$8=nxMʈ;wF{8(-YZ;T)}	8\\WУ(٫P]B쩚+*G6jq`8&R1`\r\Z{5yG\\0Mx[-8`/ьwMp3wN`Nߔ\nXex{<P6YE[3oHSVИE]:S*˚>wRټ2nX\\9_U6\0nD{vJ-C:IJ*H]9[F|A9x~drIRŻ(\r@B畆WɚjV\'S+^d*\"yP(*ٮp0P-:䥩TrZU/Fγ?nhKxcZ/([[;#;.HAۣc<Ep&U\ndJ/A86Sq90HDQEAOKErBʳgUa1/qX夞d9SyrCT\0ѫ.ʹYbjNZMƛ^AW{th:{Vp\rs(\ZlޮO%dshLc+P{Zؑw4IM<hsսI\\5\'НLIxX`EѪB+Ap:G:,*Y+f0𬚴vțܚ5%šxFxµ|Iޚ՛K{P|L/\"El+ܢGwˏְM@`Sn+*7[xlO|r/՚݈a㵇a}iƫǱf]{;^o /T8\r슂NQ}ʤө抚5aEVbUgv<Rv,vwMϛ\0O\"/\'Sc\0_Wa]KݙfWhGLf?u@<\Zm)l\'Y_$|x;ŢGa&7n&W\"C.w&׳?/K$^ce?^ZdO#%Xxʆƛ&0M/WGbv?1m.2%vA;y=qB	5?4!\Z[x]OWs\'CChz\Z먛-F8yd]3f^6Cwٛ4މv!w7V\rQ=;eRvZ[2ЭA>6BVW?\\vҧxPEp6!IP@$u[vwUS8ʕa[PCuxr\'k*2e#b&%󂒠WH*W|<`+/pӕI v李]vtrDY92mVv6AJs,H3ZVWQg~x! }+`aiOaZqLz$J(AԲy$;BY)ɐ@+kFIG>ۇS+4q|{ڨpuLͦkvxG+D-Ӭ3+@wF_+x˷Ӏ+\'C`!V-ODDxCa_-֛/{9j`c@ :IIjZ6jlW+ 5 \rզI9Yk.&T ig+ꏈ/dNگR{g0؛&oBh\066+u0*`mɌx-;i]KP!:MuYSꥦ%Cp,\"GENVȻ:^w\nW`E5xU#ӛNNL/4p`41Pcq271I^ЦZWP3i8Ϲ߹!(EٛmwCӏSrj(QI೶Qʻ^Ɨ(DT%e].\rv0x|DvnZUC7Upx,wÛej؆^DByފ(\\P\rR5|D]wVҔvy2M?tqokg$v\rޮߗfd՛ďG`O؍,jh{Տ#BLŊ2PPaH7#bZ{H&w8#ẁvNxklfB2QWkUڛإ\nHV{u4O~voOw~9K4oY[Ke\\RG}LʐY1L~wTLws2K\nsDШD}\0bx:XJHlN~kMK)@svH]d5)fmn\0:0NIS0Y\0i$%sdy9KGԜ\"**RkhW`٭R|5nu-\\:ԜY\'KFa,@\"-iu?*Fv<#otQYM/;-Ұ^G\Zag^eM6AnO$KlJ{^4asi\"\\|xv\nFz!1T%Jo50̜N#Rgj; \r3Ki{sK+a4 Z]}Oc]ʠ|b3g\Z1ZS%4Vb*P[d8geͽC\Z\ZS\nq\\NZ;D?yNcek\ZSj0134])ζK0қz\'uzu`̶$˜\"XMN͆&V\'#ǙO(ѤXW⯁фm|\nQ#GX&+\n~o4x-|4R\rݟjVfl,%d:?-ǯM!kgF6ݱRlj0-kq2wSc?dUH\nQ73hʫm<GM]3p+LKNǜ=3P@ëǣЩaR]WiMHRf$|k|s\r̣64\rIbmH?C\nDԈt9! DJ\nUl~x#~w^ @!N4\\:trQ\'ŕUe=<5ͰM|W~<~J(u☵B&OeVɕT7}J#)qOƜtCӕ-X*p@tȜy\"?Qvl+92bd+zvbM@yZ)>\Z_ hsYz8օ܈܈{sf|߶}~(=5ǜO1f*\"0 oeq~\rܡ݁)8|KQy1NKrR;\0U;t5S5.}nzǽ4UIqmaqUDpz롅q!唪Y~<I653t7n?7SJds;=LV|,8Tg0WNQA@kC@휠aTt.t:,vpڊ\0LCTNRщ@;COuJHHDhW}*v\\B/7KǄ2{V#s]G3<8͗ݏ9\"\ZOϧÉƓ{ONr@ז_I[]\0&`G_gy7􎜷XU镜Q٩\n i/$:tniKSf]cX\nn\ZF°3`^\'ɍᢾVܞ~w%e>Gfc#EuOTf4Sŧ}#3XDt(kRSu0a\Z;w2m{ECF=ppJVA#\\1{AD\rq}cpIa \"CĻܜV\"\ZkYcnUkYY$-,y\rhy#!J~̱sJxs%Q\Z ûͥJOmO:ϙlW5r,`tѵA;撶nfZ}N8dLZ&Rf$,Ȧ*T2DB$^Vygə~|\nPSLk0GsRoa|1\rUtJ`g04	n՞FLZ٤59L\\u:$sX1&Xi\ZqQIW#(4\Zb=9-C/s#^#x|6(n#(SL8>,~M]:fR-_\rX\'rX4<V;G\'Cd_$|W}{S5\n!pjmZs+rVhTs#tjv6ˮCۊ%G8q)ϥvǯj7Z\"Se($KVCm[;W8<{b\'ŏq`\n3o޳B@8Jcýn&Vɹ/[)ۻzDMWam<*!x+\"q/nWNEصx]d_aܹౝPO?#֪_Ko(:S^\na#MH)7o\ZW<[gE>b`*eNݓ\r	^3h.|D?\Zߙ2ա\0AeWIhHj	gQ.X]zѩ*gwlpc-]myotDv8HFl7n,\'If=*o[9vgbV8/h B/^xGq1%S9?R#B~::Xg5[mQӨCM.C\0W{4\\vkΝTt U)b©iàvգJ?ǈa]^ޓ	RV%e.Vdf*%ҥ	h}npO+o`H{^لuj!/mlن#\Z>O;jGgR0GlY(\"y4h/E삡p4337-sգ+f^煙z:򅁖F͑Ýڢb?@˨]rH!|(a׫vC,T1>K)||yDp䏂Bנ#A.{Ari=M-?/[f	nU!798^94M3[.>괭p&M1*C4éGNÈOAp1v7.wV%2F޽YpI!\'(\Z=Orz`\n]n5.-iw!j5<ϝߵzCF#L!N@69jc@% ܝC믭Z5761w00PQyA9Yi$?L$bmjT0)庠|l`$\\{\"?~cj:èƞǇ\0(8GfWipJpMbVgC/V!W3Թi9*mVw~ዾrG8C;>g?	JkZP[:UjB5E ̙wў_v_jkM뺞pٻ\r}jReN$\r(ԇ~YG=C\nw9G)\\M)4vo$E(v9DF\rU*n2ձ=1]SX\Z˔5C,Sn=m;5(W$QFERHў0xa$k٥4a&dkGS#<x5㗁i^LLu3NTHR3|Ϟ7$htT8c.ݣn[\rhot>)\"&%q٣u4KM$oݭ{A\rMHϛ\"\r٠4թ!	ӆQIQ\Z(B}O^Q4uTv1S)i`@dZPP\Z<ކm_{tW:7B`\'dͽݺtk?uϞYtR>W03H<P+\\-HZo W=g8dS\r	j^V:M䌚0o7Y|R9߀a| lYq\06&KxS7Ȟi0OmgQҊ.0ά3@%)\\Nzo\'\n]g\ZuF1`Ej7+._$ٍ3螚2t0u`K> 8]}m4cAl8l\nkwD|&$JElF	,ɜ%ܓjꞫB\\ENzJ1mLЋ+<f{9p4m(K)A(:\rSlVl&r\\;;P26_\\~JߊPF`a*N4.;>ȂY\0iFD\\I>s~>2dU+e:ǈjc/߫<>;\\\0_1% 2xcrfjQM.ATCgZxtNɀܻHې%kH\\ZϼOaJaE7dh|C{#tth:jl^𷣎t;\\TaL,\Z5xH`4ϞqB\\)6ѾpDW{ۓ۾!$ʤ5g[9\\o\ZGl\\l\reO2;-fNIYYڲe\r\0Tw,7w\"MQC	etL?Gw~<k\"`	[`b\0}p0WK$W~\\:\Z\'$m\0ԓءpcrǓ2Uԡ.cW5]H6M\Z)^Ktz `t^u]58ipvk\Zܟ%T1#W$)z/WL#󸼺K~YYLKBE!Iq-ZE{Kѭv__\"l&ԟ3I49qZYFU	-&\"(641LP5?_wƧZa\rB\0:/V\\FK&f	:79\ZQ!#`2|nNgV|ĆÿW/r P\rM7eA	sD\\צh!L#dɢ]\':rQFGߵ#b?yg	ViW\ZXJxڵՍȋ՘˞2\Z\"s&Ys2j͢G<O=g!r%ӟl?\rD(y\n+Nͧ\nQ*>L|Yln0yQj\r\"}A(bf}<q*V8,xҸ$ݠIBS; ɕ8rX/NzZHQT>E2M,}z3ЗRqZ@cVQ񖓑Un)\"RCLGvwWB埁ax?_)!9P|qɈgZ*ۿ7 ?w	y:v=PO!խ1lL\'\\udjFוVQC3x)!TU33Ws/wqa_KBz%KYŸ\r}Gs>h}G.m$\\U{yy_m{NNT>jݠ7ob`/	.AYDZ<Xm\ncuv&\0fY}4dy{,Zuh}!aXɱ96#ݟ։L`Aǵ?s,Kwʨ8T{m]RWrޙV BaןҴ?5nP6ֆ>{\0-xe秦FzJO#%ĞI,SMV[u~ Ű2!yz\"\"\"yͼ_۟NDur3T|VǄf\"e1<-8gj\'VNPxG\"ay)|UޟFRwp$qJՃܝ,[\0OhQ+oBVjᝄSFGZҾ\ruBVo#Iv4d?QlHJ6\\2me8(6D\0,3#>arVPEHɝ\n\r.\n6R3\n4kx>\ZC\\0\Z%he[>K5\Z*V\\z%xĦY1xYf[FX6cǠt<\"fS؂wwͻC㨁wQ̠*uk;)gRIb~\Z-BWB`v>O:]R8GӇNC/nU(Y0h/?c?êC4V +ucr>\0_s7UP\"G#.t x0\0L;\\%vBqx+7?mbgBNUn\\6#%;ϸBs1M+J5C$r<0Ġɋ[!͇黟\\d5crFM=]^ܩ	_n=Ý&o\\LP2ur~o(MFS*:l5\Z>ZDrgoEIHPg^]n0/Ǭs?FώIs\n4^TXr&Ԓl(EC4)\Zb%cb	QJΌqȔ+3ycٱbɯ+/M|H߱le;1tjY/%Uy\n	køgD6i/ĉ;z=jAySG:懖esm7!_Tmhx#4dFϊɠrK(12e^Zr#jWy5-e	G_m r?gWՠCWoFR4b$|L1	Y l!:5Wb4#>)cSu ڠ^2z ,pF|[`>*?_&1r2ѥ@F?&s~ՠȧJH\"`V($̻.LxkWNg<M8&0-A.iz;LK]Kr\ZTzWrY[cRpX	Hq\'dc&9R\'(oy if\\Rg_13)16Oރ^L;ˋ.#LI.]Hh<89{DJ|.w\ne:a+Jp(9ٰXΌ\n)I&%6d詗_M^ũ	ea\0*p̕^ XE1oO-Ӏi{=\Z]IӸ?x_M<3rߠ1nv\0jHk7q-;C9R_i$Ԋ6tqm4_rnʖiu\0603+$mX_δ8W	O~gD~Qe2DU_3R_Ț>MZ&Չ$u*&?e`=89=\0ܥE݉X8Ym	㞉QlA\n!gCn|I#*0\'pT,RrءA5s@{0-%\r\\*t-ܡ^U˴wPg]\Z42\'N	\\dچt}:@\ZO~u]m\rp>*9wdg_+o90֊soʊ/]O]8\0qg_\Z^E6{:,\';ZB cNء\"!gxuE\r̉8i&F2kmdrY&~-ɶgz1594!GgɃ{G~M^*\"o+ǡ?w[℟迢Z q!\\\'-Qx\0LD-Z#SЦ[%ɚlz*mҢHjavDYg!iZU21I=5ٜ~Ǘb5\nPW1 \\>͞uLv}:wP([fޡ0Z`@Dc-4ʛv\"Ȯ5{Vɡ[[\nudv8fRDlա_%DEY%XbϜt?N\"򠪈`_uU=fTs	B*=u(z&O0e$*}֢Zh\\wOWwSi7G;pB!||)AP2\ZgBHJe\0P9qɀw>Q>\r>}\\g۱tӛU+umK\n?W`6*W\0QN\"d|#xV\"\0ݤƫH2`zs2?_ˤtFPN_ơzw`oi0Vj\0يlj.B\'|Zøs-p0p@[Lf\0\n1)A6\0\\˖&]kPVoTGlA\rtoQ1 G\\6?r\'﵏COR7ɛ<vD5ǌV8/v3|Zg(m&d@a1kv<+r	HbXҞLW1&@rJڇ(r!#u8b|O6,JfǞsb_`6K+l|S.P^*+UlG|kK9Ge{µQ)P	3qjDʎR>i̔2X_[jǎ7HLȯ=Tn\\lml	l9/Ȭx`:eu)n\'\ZcbCӖ`bʅڝ_0Dҡ$gexkHo 26Lb\\I_+|ؒ\n&=EH}\re,ycڮ\r1ǁ5￡#pt]f?k4QūAq٢E\\|:DNl,l#CD%o2	`Pqŭ b\nȤy#vQȢ\'@2碠ԂmK]QРL!jRkV=~R[C;>fMBR+mvn	t;=%JyR%0\nf/eÖIL*ԟrWt&BmvWU%!Ȟ]_obhq\\\04{45	m\"yWlGm/yЪp!Z{Eٖ.ZqoB\rH7#wI$Klh5b4:ѕWnw%#Y]B>Sm_3D_:]6\n*@r~,;xǸw/[\nM颔\"$>X	\nb.-zԢ0oЎ5>#lWW(etjd3Tg-ZBF(O)\rfz?\'5+s\\\n(%^cԽâ5ѧyOD!>|.r:?T_\ZZ%U4hj:QYSKgku\'/~d\rigmh=\r0CUR\"$dé6)>۝;CS4QX>qXOsm\Z\Z@@2o0|[wcWCKF\'FuQ3^y!}ț~Iـ>#H`ğRR(;D>IS\nE]mY5c\rwcD4AqQixWD2oF0+vBJX\0TPO]\Z8UmVq^o#ZBaCuwIT-$e*1g|vv	věW\0(@j^xh%n<?ʡZHe^dJh)ٿ vSh_=XDpi-wFa\ZPN;ˮhJ4jk#U!w,C:KV	mBB;3ӯhP;)ړVz\0Dr?{.<n;V.RsM.[X;a^^,rUxRH0w)@v<i(Ώty8_yRTx\\h~D@n\\ǹivz{\Z]_q|@TbsBzV&Τk<#m)s̢kgoŇUʢA\n0x^<N/;TӲ<,ߗ梑x%&yp5L&][RբYBѵ\0\\4:\rao|(;Ңq?{Q%8ѣ=\'N4oÒsTƊHzתGv(z;ZU-<Onٳ\ryŠ(ݢL]검NjuzahpF5YXgߢ͚˥gXgTD\n63HO)->!\"\'$t-}M	nWRb$gE*\rMz[61p9ǡkTb:X%n\ncYT5ߩRߔQY;	^+z:%,1z(\Z\'|T9JܢxJ;vww|U-%=F@XЅ2yA4\n$%f}ܬ8ӟ?>-z\'֒̕yz^ȸ7j10NrAhQ;bK;}YP\\\ZZ4DcX_9(k`\\v>ۜI|KPn(*t1Rd9dT0At%{wWJ)	9|,jwE2YAՐ!gGGu\n90ivqHoD{;(V;hKhpM>gq=tGOwmjd)ߣ5-=؃N\0OGWw>Sۣ\0$Q%_{1ގ7څ\r,?zDx&fv 1fiUra	wiĆ\rĎP%\"rX$HKAhɍr\0aF1mԍ*ٝix^\\-Lj-x~MkS2|4[cF\'֒5NZOվkd8P?Alm :2MmX:~ڣ8,˴tT^ע+\0^HHQuK7SUf.wN7RSV%6){Ox2NAU`<,MWt\\+TÄ\"^J%VCy3BVtIppFy/sܮfp\rCꕌM}8[\0>.lJhez:4Rh\0t8\\!#{`k-FYLs0S$`3\'<n6-C:G>wcf뾮&Q$sWp@\rx{J_Q6_TySclsv$h\'\Z,2svCW_h\r?@-\rNIۙeat@^[>](*hp׼\"o}[b@\Z@Jѐx,||4djrXN8,UAWG$G%(ɪգN[s<Ď) Z9QBwըrɯ\ZwaЀZN	\\m2v,ˤw.|0E6\"i؉<~EDpt\0*5\'y?]Haܐ5/\"FzCC!/{a\0%棶J%g\0L;7R꣹\Z#SNhɣ\\n&],hmwV	Ț8OѝJ:77((]28qsMu[ץVWЭ4pp7ԣht\0҆ls\\ϼrgJ苧ַz\Z ;\ZܕAwWIIw	|d2Lu=#JR9:x\Zzbi[cON 8V\ZKd׃;,2>6q!eCG/lQWIS/]3Gmw\Zr.\r|.B#@RY5eW0ɀJ9ӿG5f\ZzMMet\\ӑ;M˳֥/e\"e\"B\0YiE<z?eL<M\\}v6W*Pj{Рǖy.\"aq|2?=0w :\Z8zRv`\\.).^pĔ\"Zڏ8\r??d\n$Əæ@G9/bPˠ&&ܒ]GȞ&M79hW̫;UҤ\'o\'[{:!@\0wn/E{~2	Evh:mwWdӨ$7\n<\\\'N6GX+|wi==JB6yj;Ee7aܻ*fD^*[W}Zf4NrmAkIwSL(/rʉrzz\n2~pH[Orm>D\nڃ\n@h]WˤP%HD>ٿff?_2Y\0d#vTUЦ[TmGnamqY\nTorqKKVϠIiq?,y&r/(lb[3\r\\P\\<ff^L(uŰ[&>U`+	KvȯPW^<P^E\rT\n\rEI޺i94l\'dL_s@Al./Ϻ~b\'jo2`~dcmc\Z\'쌞CDocr <#P5rhf_Dm֔mN+KlNj8_8iz,w˰eNw<PBZCkSIQ!\n}ixx;YAt!ED=?SL^L{VOu-Qd;++O;vD)(P9h~B񛜛<v	xRA-/KQ!/<z],vɮvJM(0(&#쟴>_Q7%l|[l|ߘAIy~k\'$ё^Y\"awE.뤯G=[FJ4@ŷqab#vɛmw(Gٻul&&Е\n\02Tl!!LjԻ^Wkr#ؤY)ːCuB̌@%C79QM;gjȑsuJmBXL\r%ˎO7B͆&!S&,\Z#nd\0nXf6?,=ʤ$_*9ڋ7|rNt*r\Z5[\0+G]V:Rx\r?2(|cmUvtPV& K\'9od?pGZ{e&\"S\nTkN&(uu0!ϩ7$V9դw|N\ZvFd6f~ndZ$i*\'lAt<Lk<.Sq*n/kA۫sΎq2J!r*$#g/\01ذ/MZQ6y\rݑ$QVk-;43),bC$PQ\\\0=qⓗYͤt4d$] $dK%O\\`toG\"*+cW dWn`DM7,֠+uJn3Ƥ+ΊM?\ZLrZ%\0\"lӤLϰ68(&rR\rIKq<ln3݀{B(ٚG; M_n%CV;HQᜱt[ evÁͥ9#ӊGر@,uşpɭ,N\'92=O4<JshWx:v9w[zݥ\Zc*!0@`߿T-W9ߥ$\0sេ 7Q.uRnM)Y|\nA0a\r%inߞkMjC\'*?k\0$}\\+L^tw$ES9:-;0ud,yX\rer׍&lI¿\0X5aֹ2S,|=;*S5ZuBq.PJvUپy \0TtéȆR\'\ZC>*	QU X\'ClԂt뛂y[DI}m^uV::pbeN}hFogNQ	/	y5θci	KN5ڈGeQB\Zk`ämu9uH| ܖaQLUoFݿ(#+6%+ cqwn]^ǁu1}`HrdX\rjpʅ)}ʺ}%~?stbd/:l_5IZdvgMf?KOv/&\"wJH.~WK7@*=CYBW\'[xfm쎵1Wopـ\0ʫRzFxV:a&i!:<^$U4tʭj<z]`fb:D]<<:Ŕ_+Y32wՒcPdy}R.g0\Z~{vhƇwRjIyphgs[UށxAuV?qܥs&:C㿩\rm9>zo|.󮥍Hic!I).ehCƴd̖NÔNpW3b\rǩP\'RIR\0)$utl];+\ZjAVnk;Ȅ7%`vUntpqR|Kd7ĥ wMӳY\r%%\'aOA&xyY۵VȧV#zHRUdv?QwZ^X	h7庵:vN5O%<Q*&>!V@Pf_ȸ[G&R92&DDcQEQӂ_ofIo	}B3&Y$Pʥ?_z4j\"/~jXE<cF{kZxS?t\"Q?(nr3A]]hi{ ԃƧcJbSp7߶n\" ]钘T55E\nS8}|\nͯްA(>j2Oƞ}VOצ\07Sro/̽S\n[Mz.ŃZzLƧ!}\rrL,^s|٦\ngJduT8w(=\'1\ZH9Y遦e\"vV!tXBv\r翕1wD{so	kjLAR	V\ZzL0Qwb׀хfR=k&Kps֍y\Z@?7Gc#EU)ϵ9D[.NVKuZ\'ނ?*s,YI+[܄s(\rG0;J;\0j=\"(P]<X3qK:O\\R]l,r\ZybD4m%̆\'?2[Q耐8/sG7mw){\\I \'Q}mˮ$R4U:k$Gw 1@uiL0Kĸ:@?Zt-(D~$mͼwjx$\n^EE^؛36v!l{PVwS!nH`Mm`=pʳCڈ2H+\"\0Ud:\nO*SРH5\'M> 	2=$IRLل.\r>֛n]9^	aPs\'\nBKM$꼓rfy6yݵ[eTRË\\F<1)(FHWa\rw9Z_phRf}	PޯZ{֢JZbRu+$Jp)#蘥>XV%gm{g/׻!\ns|\r_N7rц-,r_Fvt_᜼PNz_X@KOuKMFq:RSO uѝ|=o%-t,u. \r{z\'O,iA;\rvgDpX܊|9mQYC8ñɥJoνF\0O.Qm+vHjEodFX*?)jf&WԔLbXWQ_N50u/	3KaHxeUUHK^Ǆ_%ך*\'Blm&^/ر-Mp#<_˥d^5\rtfa#,&8{|h6m|(ĺ̌&ֳ4@78pJ7b^\'ׁ@RrPئěn+܂ˬ\ns5*D^k2mi^+Qf\'N,ntR&*\rG0<7%ah/OpR2SPK?x7.՞*LuK֍_LI+|\Z:2\nuѶp⯄׆ڧlS`W@\0J6\ZĦv2Zg,z[^ׅYgvaXG]~rݶ&HWeʺ3⭤YZV%Is!бj8>\0ئnGUvi3DCA6D`Ls<ŢtE>PsGALBg2k9KhGm`rfyt[pK^o\n>s$ѧ\rm(FGNV;@CoٖmSLTGv\r7X+U]\"͂G4-?&m2	5N# NWj#Q~p\n#HNo&WZMl\'o6mG;?`iLNo$ީO2g@Yh\\]pw1F)Q\"@ȳ\r5e)qouvR#[6-UU(UyYc\"	miSQ-9l77W`]7n齼[։pzP.ovmAK6x	\0]\'\rqlix%L\0蛱V\"]0db)fʝipB&<(U@:\Z@m\\9@g7uōg#SE	blEjHRrRxz\'-U\0E$RFOQǧqOy4`5ɥ)d)]\0J|Ms`bF+u\0#\r LmNߌuuc^=¡DU{.į.տ]d0ӧu^uRWMŵt*\nG\ZyKEȱkd&׷)4܏˧zEvGL7t|%\'4%fp#eh-h8q9\Zx	VG%%h/%R/ήqeGF^6`vBI	|2PS?hFMaȂUE~zާ#^8Zy7Uܲ={s&FW\n쾢5:TȺ0Gcؗ{ewTϧ6L4cv`N-wuT#rXz%-W\r\'Rj]hjM8ܨ6/c{ICVM㥅auR_	\'Hu)WC}D&7,HnY[H:B\":sȆkӠbS^ؖ@?fu}׽gCi7T8W\"\'x37uD̎~B^$r@ا//vf,\0Т8\'pCu;\"$LvyA=<ͪrRs	j)m-ENMA͛	,_~Y?ck_\0T0ykM38W\\Q7F\\14g3\'%L| {W%_g	@M\'F|S=Ւ\\[8(YY蹆kFԇO9H\'[|R>]vv*4A~[뎙v?lNO-\';$>I<\'+Hf1ҽb\rKsuT{~e. ߜ\0Ì\\k4\r*H\0\0%ZñΧ\Zazߏ[_K}P0;rɑB@?@[P^3D5Vw\0\r\'TS!#m|:Ӕ)zY#ʅr6FR0$JMuvef;*P΢`eέuK>fL/tٴ*\0#.pGVJ|\"\r`,GhB	ЋZfgZ@\rm÷rυ(&K`\"7˨l4!\rZ<Pl_Ψ/\'F9r\Z!p\'6D;%^-xh%O4y:X0^YuGyDQb&?~ur4Ў[z^(gEpֆriݙhF=yZQO,<\\t_FwKĀ/L%@=-e-I+Rz<\' іrvqSKU7Wߤ_i9q=7a(PwƜ&|?|aɇbGaTس\\oUe\Z/31@L}*XH3i*tykE|Mz?e3g}xR\\QNXMGq_r5,%s֗POc@sA^Nx[h;682LQG lY5k滋_Qo	A4fgSh%=ZN=_Qu~ҿ$3GU4&\" KF]A^E}yZu\'TL7\nf`jT(5o[wOP\\>0{cVM!nM.W;^3.[XR7y}ਆդ<N?GX4-\"Qgm+cx6c.-~ciHZc$1l]ҨtURT߯Xj7($.;ب܄,U}yzޏ+\Zgͼm3	{ɟa6]0\n*()\n},-Dzua20یoc\Zy|ϨǞ\0zvVMAJUla1 ƷŨrX>5SƤH[{Pg٨V!6\"	BЃh9.F8gި\r5\'MQn8z>l2D<1x0y%pfKZive8:c;%t}5;F[?EXnG~Zݸ\\B[)z츍mB\rN\ZlCyI\ZJe{<^f:S[lf8փu\ZO~B|A&݆BJ8?Mzexn޻X),#ӨZט\n2wEz&~x/HvO#^[f8: M3M=D=u~Ju`Y[#*ΓMz*!aZ	b&ڏPƱ[Ȩ )/\"CV=l1_BӰlj8{ߤ6&z6=\Z)nk/zTRdekvL |F KGO]5^AG\"$A[?	q&YF@<ݖh+ѐa#+~c:M2(VA/|b.jd~ʆ:Yrz#|4L\'iWFTЎؙr775%HBi{Pd+k%5-$p\0ZjթZ=􍓣-KG]9ᴜ!23IMF|DFIJ53m,YlwNƋFO-YcPo=WoPhڭeEe\\\\y2#niF3Nr$?YhY͞ƶ:WsJǰrb03jg\\mPPjxv]7J6Y?kKT5P$j\"`\"vR\nl_`_.Xv=G3,Nՙމ橍G<iMŇNоRr0_Vu_Sl\\d,L;\'x^_fjpL˓lnZhoR]CZ\ZOlZϏ:l1ԯ\ZTؖm;\"⸼\\d9ȧn\\\ZrR\\갪[S:Uc$8=M;A6M`xƩ?<%\\=/Bh[CЎ\r	u IaL/Icd,]aJ|n\"68ev7,pc\\\ZջІG%Oo\\.a84r5$	C\n\ntYwrc\'Sy:Gt\'_;NÚ$E=3gw]?\'1E\n9ZxG1\'~8[`}.,]|օпеI۩]@ޗB87\\[ʨ\nKJѡZw9:bkH\ni~w}\\)x\0OYj}nb̚w[$QӬh,adS\n@KMU:T`Tc[1,IGIWop+U]p=N\\Zg$,:3;Q0Ճ  *0$b+DWӟ\'(q.\Zީ#	:uQ%m`nV/BN\ZcNCCnø\Z$#k\\=ZGv܌o\raH%oWkh0io|ԧ3h.95at0*nT $%,oe[`<osPb ,nĤ&0|zi@&R|\'ȝ\'cL:b_LXx0Iʪ2,D`zxc}x-<mӪ7NSKٚu|A$hrǪ>a䬎 w&t️K/_}FA#I%d{F\0+\"6ƹȪJIZ;w%!W9ѱS	}9nN->tB/ԣ(q[T&7,Ǽ]m+7^꫒vK7T<CFbjgz	18W\\}x?u]nNpK깪[Eu\r:&i|:50= SUu5^_w|)W6c*&Ī]Z\r4b\npXP~z,L&70l6sĪi-|?]BdҺ?*mZ88ĸpl`&lK#U{mM6,ҩyt\ZwMiƐG>B\\gѪv`(1in 5U{Io4BO~ S>ڽ;g.[/N<Bȫ[y}BxwIZЧ&N-)͈滃~5|zI(:.kN\\QASh@_I%z9\'%8z;T|}_S]7m輖Lڪq7)r_m3@xZVy|ϋ\r*gH-#=a$--9\'cڪB@\\HN8PߣD./1Mzg{ŷ;`x\r3iڪQ\"QY\ZWj`ɗ2CH<^qqYZavJtdFjHэJaw_rYYS`\0<w3=SwT-|\"uVc  wuy~B5v7[k$lȅ<ت?I&kEYB=b*ҿ3Ft՚ Q憐DP؂_?y`5m{T<gF+j\'pQq\'De6?{W.Ƈcj\"}Fpz.T&lGMki_\ZQ9혯]ԧ`	2M>	c\Z@.(6,/jPVV~Mf\rNDo\n](_,pgi1}.͇3wz$W<leP[?草p>H!yZg\'VR,|OEElu\"}7oSL6(R5(-\ZO?#lΜVKqCmg.\Zw!\"ɿ}\0,E5$\0]U{#j#E^C5őܔ)==mfht$#mvtq%wc\r[Gvi/(7^V५)\'z1*~6UE4[kP)ZϪ٩EhImJ+Ru_9iٹ,Gc4D8:f\"YA\0c7[/hf=@05H0\r7tm81wӮ\\^`Y~F9+nz2h{0NB1qFƽ$25#D<)D@TXįwLpE^rn2ͪU?嗸W\\VeL,A/\" 4zX1][MT@JŁm4N2a0Nm).:Ҫ}P׆ݱTG\Z5hɕ	АU_}&:pg3Z?b] K7]%vc݈(YUe%!TFedGKs,vE A4\\\0o7)j6LuiWAlb5:]Z~f,鷿ܻ\ndh ~ӽXj@Ũ\\-B\"B;8H/dJc_	-iE\rV^Κ|櫟`4.{mϖS9\n]bG+\n(x7\"\"5nWIia|i(|~odR:OM\Z^ճbK`1\Zr7F&G쫻tNr&ZG8_	|~ުbYZXxW3:W\r\Z.ΐk	،@CB+=\Z؋ޥnU,Y`hGz_ݮo^2S\'VAFXj#[ͫ3H@!+siA$uN9T+ƺD=#wjxyӋhOB.hѤ\\4uho\Zb%xA2;bIqS]B^	Qk4	SdKO4k(@F%<ږv>?跘v)YZa\\pCP;fWV\0sl^}!/e*XCր\n.E¬2\Z)|Qnqg:JKk!W&P͑\'UJmͲ,8pG\r̂]Һ׀w\n*\0sN{\0 >_ /b̙Ɯ۰ fm}1ّٔ\nh=DM:$Q#2\nSzx弶!k=\rb+Tyͬi9F[+31zt\Z֌&/b#Ci\"O-4_piL\0Q[\"Kr&&7Zd\r\'#Wl);*=$99Ocor]Ȭ-b`(d\n#D!ά.AnZn\rO\n=י=X]]\r/u~<Qƃ1<^RS\n~nBȐ6Ywv*ax}%CĴMn\0ol:usWO(PX2t <JHvi	b4l~eFmj=gy0&/j#xG3򣽷~z)BJz|7{R@oNC}B\\dWUeviU}67FJ |)Gz~3NTK~VVeazUܞ|-T[7|XNC	T`kd	&[,˲bVt({^?լ`͆V#o_	A<X9rd\n9Ӭd~&XG\'6ǳ`27Ҧ>fU4s2c{\\%\Z\'_h%hC\'ٷY#xD	P(fgYjr!ERu/qFڧ7ϙz<L¬p:je ݸꐬCP%Zw&OS3\0\0VȬ]!T5\05x>|Atuia20Ĭ{EolP,qhOF	Df3*\0EhK\rESugX(4A0g%7]+ҵ._1DFɴ.Dvzӟm/@yGzU;Ϭc)vQݹP>&ۛ3͗1Ok\Zz&zl}׼:]Fsf*M\'{Hsl\nmL?C-欳Y6c\'\Zvw=)*o7,M!mۖ\n=FK 	..>D(FӮ浱ۂ|	Z5ڏ\'bn?ȋfG ̫ct13{<3gB䂮_\"F	8%Ί,N<5b&٪O-R6W=q;76zjyI`F.\rCC!qc_XϫZWg[SSmv[ߖȋo撴\rV>=5t[ߓ@؂ID^T@@Vp@TU۝rOY0hb_%/_1$Z~xψX(U<1?ōcl\"Fwlf\0su1h,OTU̬$&^9]WgG\">Rwp;ERCͶnM]WKʭJoe\'7Xw(ucJ[1\r!*H#*庮\r]hBf!N1Z[Qj\"0Z7-WN5EwC韡9J&I/j(Ӻcq8$t=OꍆppK,>EҟJB\nATO&*ϑp=\Zs\Z/yF&}=\\HV@r\"B ̀zϗoֿŢ&ȣ%;Ga3~YƼ\n\n.fd\\>8{ΆAHJ:^}04dGp\03><Ѳ2wB.T\Z{1>c?+{ΤYAvE2>1}\0:aFkZj]@Heaё۞P+z/(rKߠ};P@NzFd2خ|8I%yuS\nڅ| A\"$U=&r֖jʭW>Q6SwZ-jn٭X<7G4ye)\'p@M}:_XiZp.\0\n!§R\\)7{r9Y`a)qW{Cd8zŤs\\\\)ִKeQ]~eڀqTq|+a\r牭jfZ\'|$B-˗zix2KKiw\Zlƈjmo\'	\0gq|V+)OTo,zh5c5t\Z`sq;Z\n9SmLHz\0z\"HPl缳?x4P,E宭}ab`Zn/^5)~7?\\wxBdxwS\"BhF}J=M0})U<lj@X1LH\0rXg	|!YK;Tτj9q(?TDBu=781z`~R\')F]\r^n@h5⭱՘A-z򼂣.kѻ/񃭲V\"5PG7}j!mYZvrIƒp.ҋ{p\nv	\ZSN热9͜zide䊂\Z&{{\0΄yQtMp9B8Sܣb84{JYE܍xƵ(٫EƵ5d=?Nrs.Py#RK5l7.♿ IoX~giنo+\"f$Im!}9W9f\ng@oEYkү,i\'oO?-\n	Hx9*fЁäO2:~,)ZUsk\\u5>$=81+GÁd92д$1JՖ31G3pRm班ߩ\"s|[vӑ{o`YUR֨̐T\Zy	@+8ֱ~8;&ϹqL̕*(T2)	H	5l\"\r,A@794c}vҥGv4]#S|/z?ZHm0zy\0^\0̝ED+fDPTFdyB3*\nT8ouxl%MYL؆g\0 yȭ\rt廻ķc?ZSi!M[\"k`rQ\'KbL}efO[gvD`ۮ0nSfaPG7)foKv\rƶS@6[<߻?\"m$,[wAV\0;T}`x~t;\"9$DYð(fZ255<H[\r<Ũ7iU\'z:	 nKJ\'kZ&-!T9 6/z@6T&\0Cp˄$N\'Pm<RSM3831PEm^f($nTwV;LQ724W}1/12n\"{+g,ڮFNn7r*/|`1F VlR^<4u	^=+%A]ꍸ\r|ɾ;aDgeBK\r>}O_	+}?tsW][:JZO|$D[KIAS l\ZߓӮN͋-m4|0\0;W4bQ(ɞ@tal2XcIRL 29^d6_V$C8t{SYn	g@eŃG\ns9Tc=1J\n\\ Ib\'h5_\ZQɒi눙OsJ:h[ڮ	ۮ_/SttRʔWCUx~:rQ⨮vTipeAd[he2F}O#&w>FL=EHHwwEpVѼsc`Pzl\ZCD#aN3\'XZEؑ]}܃wz,<?P&䮋b\"AyMGws	YN0#ssj6tvDzELZdM몶W9ITLcr\\h	=YkHTxDe:#aQ=z.GcFmPK47Mj9|\0i&ĨLu!J%*kb$ZRfi`2pj9\'-gar\n}o0mϿiyۂl|4hPǣܗ>$>W~773WqŰNO~%\n}\ZHI¥\ZTWF>Ų_IrxMXKhmKZR\n{_?z¨[6aB2jf7fL~Elf\Z]ܤVB\0n%M/[;*&/_/!rz}T, izO\08oPY84U7̞jp¾$et%Tn5?*BRg\nVD㸀E/?fj\Zh!ɒm[V,4c. C wH\\dm?*\r4&#4NeTsM!r٣0aT\0ڲ@ޮ![0J\06\Zj6\\?\0.k.m)Nu40d0nh\"$ֶf yF1%eزURKwaWwYKL\n	-*^e\"e(_,g\0$\rO;zjJ,nq U8cKy_]R\'˷dO\'xvW\"jC+o%~{\Z\0`OT{>\0½	L>LY8C˚ӱ;LH%roq+NKqO\rP\'GrHqi26qGg\\Pgz]s3$::	OSC`B\0`R-X?r`6ÕS!nMi:A)PU~1DC\' [y-NIzc`#0ѿ߯/;HA ^uA-kg;<	`>7Ts|46fB!{C*i΂\Z\"c9qLԬ *7pJpc7ٰrCN<ͩe	/CL,\rtlu}~[3TzQ%^~1oUK?[*die_!sB>iYFfFfCDg~|oCF֥*oA@Χ$cɯmoK[Ey=2<t]_w,ٽ!SfwfBڳ&JV7oO6S`njVFmT`b3&.jݤ(qSjp!puzI0J\0&\\Arr/+ vr\ZZ_yczjcB,l45M^Ttğk쯟z/qMZ&Ǥ\rF=?b־vW^ܨ/,Gpߜ(g:ݒ\nN8Ms}<?^QO,>snv1b`n9$\\qV鯬@dß-ȧқxFkbszr1BMSDАy&.3xR*g0Xh%MncCE+c:\0e\rު~\nMw_a<>VX\Zl5j~d3v_hi07ǧ?{e&ک(6JdSBgr@i_S\0͏\'4n@\Z.^di$Gٯ6-֢\0qxw&a\'vVҧ#cwr4w%}P,HR(F-\\CxD.k~(MRE)Tf*˳Vc^݌@+_ZA.tT6a\"@Jm l/hSٰ &^Sh=.M\n6SQaHt3*fФ2CP\ZQlherq7)8hs]\ZU*FRg:(B\\=M)_Iu|K{0r:L|ԋ\Z/5Lr`[RBؙW*_5N^;&:\nW1*UyKeŰS!.!5C^ی	İUq#\0HD`>v+O鰍m^bu\0]&50{rNA?io&5:F:e,Ur:fIeSs=M[Dۦ@~OQsIq|nR7}\\:3ҹ\\dAye8h@ܶEPB)A\Z^Уu4,9:o>7p|RToʡ*!(mL%!%&hgPM=5wYְAݻFds`0$${^=ll\"VĻu\"bdnA:ViUvBOטq0/0羻+GE鰽+7O9Ѓ9G_dGmmC1U?Gš!\rr-{()秐=l2^m\ruV20ژM{iJPgzȵsIf~[Qs6l߰ٺj}jgՐ{+Xg2<f7&T6bbeV%]RvQ$/sCU)Ot߶/m3R?X##oW\0qWU;\r/wZL 򣷢5cZSNMt*)5T$`(hGS~{h/AЄaB։Iv@@.ǿqTt-.^\'呰%J(V/+M餱\0.y36x> [/.tT]wpX%]VĊ?Bb\'ap v>)KB%2h{iۆo&\\({eFf~|4uoAf\\ĐQ(Ë\Z%|^]Y^F#c*(#\n=<e^ҷ\'#S=wW|K:\0kG%oC؂l\'N\np_Ď+$i7=I5iB4<ұ,FgMRhjYı/<)pQКP_sZ0TXA#6{K>~qI=!12㙝Je(n!6^)\\9<SW #G$28&]ӆ:&=!\\zRhp}@,rQ!Ud5\'6J6i\n3ITYrT8_\\np/fY5uϱ\nEfaqZ:ұh&)x/zv[5q㨱l-]DP_rkHr\ZlL\0cF}ű(P\rDɪE;u&l Tï(\n̙[oa@\\gFӅD6|i}+A.g2JOl𲠌۱k\n}D cE6%]{ר{bLn-#[\"61zvi~_)X&8J_e -O3gF\Z4\Z/җ|CAb9g=><P0\r˵c+\r*+H\n$^ѱ\r&>h9(񇾥P\"톱&>HLi#a\"Of,8,M4a!_~њCO״&8Y:_r2yDhh#)Dѝ1MJw蝱a>g}k\'foǯ)n0K@w9vҖXٕor.ng*ɲֱ؉\'qP#ŷ[`~;HkMXML`b:$d\rwHxa?S@ߦZWwPwIб,s}naonA:<)3ٿOuOis>L>\n&H˼>#ꌆ7ڌq,0lo&*A]\'ZX/L9\\+Ϳ<wC}\"	\nT)Q\\u:b&pű}BH.G;d\\ZCψ\Zo/bo#Wױ.]H>Z*0oo4mPA^Zzq-2b	xYTQwf<ɯ]qmf~pż=LJhWgy>!}Y,:vαy!t{e%YV7CbL댪O{9\n.5Y6}oџi-(~	Wρp`$<\\5wJkSf36ǧǛ\"9MaU_hI>,]CͲ,	w1O{*Yz5,q&AG*0s牲1i:S9\\,$ْ<\ruv26Fg;%A? 9nٍ(֨P]<Ƕ\'r1Rp}8ݘvGK04yYc!=6|*H8CuPdOќ+\0f2%7\">iiF*dZ+.YjLm3;Q\\lUyu##ed	A3Q5RnIl\r0!ţ6σ&k!v)p1\'rSlY(7wAO)FP]6sƥoKFLZ,:jsVxZ[$H3ܲ6_1}Ѭ~\"?BwMҳ(N`qدU>_b%(#p1u+Rε\0\nw&\0J\0p<w}ð2*i@_v8KQ`Z\r~:u˫?^IPt\'8+]kcS4dH11&G	8y^t7+B%[&}]҆\0B]3۫#Cd5F!!}ݭ@t{ۻToyJ(Bf2H\'h!\'* ɹ*C;ԩyN*)J-޴1vj.wŵ`αto8[fu~@f[%y1BǷqk\n*;z8jcbbq΀IZN6Kܸ_+:<-Sò9Y-ŉN)#:ASR_ÚDob|\0ձ0|xizJ;ZZݢ|f7S]Mmq#c-aPF& \\(1(R^\rm)O7x{@*;=ʥ>\Z\\!v\0b\Zb~F&#BYmհ<udфju@#E_-FI7y^-\'<^?bLi=xײۏ@s;Jʘ[ԗI>~4ۼ=w{v^ȽCqF:@S~)\nŝV~Hdj/\\L[ZP~__!/\'8;_(Y+k5[DUm+xaT^q޵yP7Ax\0Łֳ.\r\Z$ACSwXZ{}ajD}b9\rN@`jUG g\\5w-Q}QUxyݷ̰	gҍb)J%TxxVeU&-%\"!N_)\\*1ð1+RݪoITQ{h5TdlP75o3rX\Z&?V\n)K-M$>HZF-$v|r\nwĄY&A͌k	/mdӲjsCo>^IÂptLN$mԔݳEF<3g{\'mv~DEfMM[S>	s\n /U/By?\0NSzPRQ:Yncz1ܳNs\"*\'7p$ixȭvS>p[z]iZ`r°ҦZݳW<I>@n*Jq{ͫB[<V;,[BA`jXf*M$u\\;]\"N2Bg\Z|TΌrЏeq`GJy$:xty*Y߰%d>	iHb$&n6p\Zea::8AfJ;Ak\nf$K>\\E.z۸FgS:򐚂$h1	Ei>D4rΝ#<7r^Yi\0*zP#7}q{7f4y}pErPCmU\nF곁^H\Z&E5CCq%.ABʣVڗC;7\"AbIYI\0:)ѷǥ`wcw#y}Ua\0n-cI~\"ɱnk{;IW>*1v?g&3\nNI+a\Zs Lzf#4C\rVvby:83o\Z\"ڹW[?~Ns֎Ps٨_JUB)h\r:{Yh\0o\ni#uޡhstrϟ?ɐjA>V\r֋ouг\\.$kڽehnn!!޳6%>԰-\Zug	}iK4KTTb=2UኰOB`˳-h}	SE:BDEm%6ҳd3\n^Қ	-H6+1$x+T9]-!Ivs[h?ƳپB>Ȯ6{ޞV9~Q\0929{qKξД!I\0(I`ӷۯ	(hs-љG$%TBy u\0:7c>хObN<%\"`תs[Il9iSQ9ѓ	zXlةxי;gdB]E\rr8ϳ.B4+F!\\0euԑ&dmgg藳+N+RfUPt	9xl2Ū[jƗIh*@I=hQۦх0rç\rbRvO~nw}߯gK3Տt¾p|m,1O(bZ϶lK~ˉW<[ܣfaճEn(|TqyWX{{~d4jkM }_`Pdό)`Te$DvEZ6f+()~Xx}rPxkz+* ٮ\rm;PddE|[qXʫo2\r\'2qPѮg9Vhݴ`ɼXL>m\"T~:#o%_9Ҵ:x)d@bc&9x!\"aDr9aC53{A{*эb2Kwwqҿo&GD͢a\\Lմ+^	pBJx7?Q[0qBCoMpkM]O1qb/4!$eZȿ6%V+=匂ߐե^^3PꬒsH{Af,[$dnٴI!>@Y{<Na+⃞78c*QtS,8ν\0T\'LOOxZ_E1T1VmHY7tR~k{YD+)Y;]^e-+An5&_`\0N։ @-1N֤K9ZkoO;?,iRfx~r<fplsr&){ΖYPzs{mr{+cq6_Y:kw@m|?pez6]暐@o,N6{jq4+SHx{?fm3`ar6fΏ8{Ja^Է)w1Y:մ+mvS\nb7̿L\') tG}\"A9ioGjQBܕ׸r&Wșh/{NC~4K{$^Q\'ԌnIteBK82̽VnF{i(]fӴACLq\ZjmbųX\Z70(y`TuCdJm˴\0U38*5`w.f~5g%xYyH%\niU[C-֋x\0j&o`Mx h`H䴻.#,t\0W&;yc<qЌ25ݸ;Nk/VR.ԩ$.6}[-6{3(af\nHƄFeMOþU?!n<֟4$0=9Ɵ˴=xn%vA[y8n\n	(h!e֋kٲlZя|Қ[oeCT<3ߐI(.et.kbHk[b0Qy7ǊE3Sjz$\ZM]68DzkTykm|-Kjĳq2ic^%ܓKO?@]y%U?vwXl^{qʴZ,\ne4g{pSFs=[]ߴQ1UT]*f\rzoȯ$y/d8cmt;6 EE/ eRd\ZƮ3`yD68N?%aPŧ)]NC1Cv^E.Tc~@O5JLW\\M!DJy7F(<\noM,ZAGm\'%`RvdP|v%^Hj闲7<fcZv;8`1OYﲆAQ2:*t\n\0}j60`h\\C{E+4hO|;z(\'\rqmכ~Cd蛾Y&1Ou;wh{#6qY}6GWȏ!~Zãσ~SLKjJ|4<&Cn\roۼ0+ˍ>|PJP!0k5u H-K^`rR,\Z<1*ml@6Tѕ\"Al7qˡ8[)N0A/ʊ4Bj<1P\r!|F	aZALV0>ٵA^k\r>⵹:QB\'Eaњ4GtX p|Ρ!\'!4_G%e5$K;ᆼ1\ZH!fceJP$B|&21Gwߵ~Hg9L԰M=w:UKץDIH&dtM6&۵Npsa{繌4mB[\0Q\'{A(V@L<\\^9fճxO b8Z	k{<مJW~\\재2dyqE~߃!>\'cstxqLJ<)>F%6KYïAe}ˈ9b]{nyuoב]jݯ|lޟWʌ/]DA]	Ǻdt䵳Z*J^;6Գ\Z~IDծ$xPiAU-]=\rj1[Wf%>qp<Պ\nƑ%Q	h2P\Z=t<[0CL-YEQ;C_EAHG˝bZD\0PVpl9k,!$ERTNgkn%-5XO/ F7^:u̞rU&?z)C )^^c%Wm$ۣeCC*YgA\r}ӳ-7L4չߔYLkCNJ.{`̡Fa%Ir]`Q:\'bL g}dA	,rwKw/>WR9sq9o\rNҵF}塓k\\@n^ZEx4&zkʜjMU:~oh}5[;RfɈ5k_jQrQ<ct׃&ЈصkD+9۵V\'dM2*^\0\nq#\Z䉩e޵-vv#?{QQ|p.VϵITv5܄Sy8#GyF$\nr`ZpGG*\rr\n>|Yw$\rGW[rX<{\',MH)`3s \09Q̓b/c]xUƭ9XeS\Z_$12z\0bvՁwۍa֒K&W4xW璪Z)\rԓ(ay{;˶+4_DP;_!v*9pƶ2fQ,+<\\\0\\\'⮝	=$(1\rۖ/zhT<]@4gq\0AqU	\Zh$	әr6E0l\Zn)G$:_QFRo{%*\Z/ΐӛ<|=&_iiܯfC#za/ؽVh{۞<Nq݋+2	˘k4M_Ćs\"1eY|2Y_ޞxy9*MK׶Р\"`5yB֘,l,Cz,aӶu!4ߒjF\nz\\W|r4]eRDJP6ƗC	pڶ\Z bϒ\0E0+F7̚\r<!-:Z[Zj\nwYEѳVָ]XO(ş}BX<bwΰFo2ªrV*pAB++q̶{|y5yh~[rcẶԚIqʊ\rij\Zn,Ighܯ^{ (q7\\%%G!&*QK	5Ic@e\"\"\\j/o%ӌl׬֩=1wCb]Wcj\ZwmްV2t!gI_\rxLI~j?M`?Ιکqނ>T;EOY\0fzh̋{J~}%6Ch;68ҝ6z\n~0܇ф<8,USpP|V|z=*fL8w\ZMd̶\r|EhAXl+]10pqҚi.}	4J)B#;3dߧ_rEDgW\r/\'pZ,5RNSQ͊WQ1Gb?p<,ɑOG[\ZxDsuͦޱ4EXD6\0ܗDCxbQfr03_LA_g̂0WjiHUSզCzTd&\n#j=a1SCF#\0(ľ6}%7\'9YXYn$#	aX2;B8cHeC{z_Sk ɷ\r01iŤڹƢ6야#Ogsĝ5pտoZßG\Z~.H0.L@ەC)#T\0n%.{ׄZ[yt(g^YS&zY9E-08\rktm\'Ɔ^-&ɷ*ԯ)1vFcC\'M&.1e+\'gǪ;^|OQڂb`4O-.xufͼ!ÈD6TISR20mz{T()1Z5-PqBҖMGx99d䁊N58\'AзN%ABO+>5pZ3aqσ	aWUͶ:OIXD9_GMY+ķY{T7UqֹbT]Ci*8.yPB\ZYe޷qvRkŅFʜlf\"P]=\0NtDTdܹ0\nZP\"P]mF򹛷vNtvjI?!\\\Z\"4<4{}aБ8a;[\Z&+:3W뢅?\ry^\\{oc5ԭUzQWC{&GK)Ǽ6MG\Zuΐi\r`?[6555e\"$#MK8ZRLýGfĿ\' F:PM]O>g]곷np[go!X.4=J Εȕ\01/%Ԇ5Yـ\0OEftc@0_	?Q΀η!LesEg#\Zwjt#M^(Xq	ȱ\'#r)^	0\"95^s	؎\"ck%j!qW$%[6Pm\\IYe]x.g>2A+x->)ȷIw0@j/iq*%vbb<J<sjĺԴUzﷹsNuR<.\ZwL9縙;O[x`*8H*r.P#Zv:.NMVrz$}9:qC>,|40F|=.2ǐ{E[rPE~P(^\\>]!r^8¥Z#u`x+I[0NM[xV\"2FqHƕS7[Bx?Ҹ=w\\I\ZhkƷ8m̣_TvQ\\[\06KJ\"᥹oMO||zO[Āqʟ<\n\n@/g(lW. _{9ߥfTLX\ZY?NfPۣ!t5ܶn!ENӗ=[p\rd|Lv;I̒R5{0vY7N\0	Ǹ46#\r0J7\0[irB-p\0,ܿ\\ԠUG;?`f*iƭ1{(H ԌDXY8kcTW<+F2i /Clg9NvDB\"A@%#PO^F~{Ůk<k7B1\'+hL^^+#e).\\Q\"+?F֧Z.\"^6CY3}AQ5M*p˼7	tDGDq5$/̐6z}_T4xma#E8xkPnH\ZZL1A]<<00>uX$={+cܧloT\'.E]\"f)|nsMdm˸IfR\'}MkyIUDeI>BWrK\n4Q(3JV.)Td	6B1rN/=En9-PMɉ>oոX}~.C-~BHU>{Ȣ\\hiqŅm	wb{Ag/Ÿ`\rLCU8wn^EV/HwCeNNņl&W)U^ &ǰB@(ubf35ޣ\" +uuQ OC((H툯%[sä6I--mDW42V9X-ԁ^LG8㸢8@v\\rK\Z	GqZ2}+:k\"QxDC<WFNB\Z 	{yWPJi%g:R>ev10\\#昸ޙ)==)eFKx:5D9@wDK`ɻW\rc}fp9|uj@\'^M8G|IQp)7v)):O\n`\01Z\008n5ݙN؀:URʸpQ8_\\ V9Iv)CwW͸؂Ϩ\'<Mtv$d]#짛߸:&*b2f}vQ,.ժ˸h#(Vx3~\rCVPĂFdX[nJ@zvT\Z0:t{^!=.`8G?|#C=(6כVR897v	`دe-	C@vχƾ2z\"N.6f,S$YӸiuh\"KS1R+/;j,<^6wWpإj!LQ?qtʛ.Wa\'ntӡTT8lhنQv\'|j*iY.7/XM7~Y+/\\1}kJ?dA<aC3:[nX \ZA\r҆ErBЋg⩔/lK.03	i$2)aAhE6D}>9O_=K@3yW`EV?ѵA\'7زV%3׳Eq=v,V\"/C꒹3`֡$=ܥʲʹP>.y9z={4\n?^N^YNr_gQ~x=8uP	kŉ/LAN3)>	<fQpPX*el5 WoECC=\0{ק\"};龡tKa9EEL|9j9cM`WPOm_jWG\\bojHSmd5|N|bȄ<6i	ŹV$RYCC(ݞ7:!J5S\rP7YgCh5_>+\'NW]x!+>Ԏz4J1~JbfKWݤUjes֗#yڹux밹d=ڒgz ~[RF$\'̓SH[f׋p@H\0cw=b=gx{st?\ZԴ;,:UA\0ݏ^{o[ږ2A$Vȱ,fb%;+]H3\0*ցߧ\"ifMЏ59Km`v؋^GRf﹘&vcDOvcQ]P=$aFjF&|uPUMeG1⹟jEk4pڠ\04hC^xU	߹bۥ!	9~Ggl򪾨ȹ[D#8|3eAHd ?/@;dY2)RNqu^V[#:9ҕtGctΐ3|o?D^a@ CCN&PꆵJヘӤOnPz틬D*ERg^	Stizr{cYG*3\0ȇz=Bl3u@ÿc1,ʤ6:SBȴH;^`)ui\nI2q\'QwAyIS4v_p?X)a)qټqfL1J|b(#}\\EպʾUL&#b@Z1M/yfA/b6o&ء[tJY$MA؃q6\\Y?+c2$)68*Ȱ:E6[.7\'L7eqO/<2c4\"p\0To!RwCKxD>#~`cjap\\	F\\ڴw#ܺR2@}zPWE4Rc	ĉۓjڔ\'nM}9`AR)y$*[|˺OVԧ7 ֹj	Nx_S$P4knPMk4MH\"1֗)VB&ipU .Vitt]\\;HIdDppSsJǢ\ZC2]hGFN<kݨk!2A(D6̩Uh?ֆ~8lȪ4,Ǟ?u\0\"[wp4GKdZLҪ)󺆁RZ93]UX TtIlSs?SylkJ㙸3g>ڷdGzfwSC<CY^[(:ba>XE2㺌帡~L#?p˝$(=5ȝ^1iW/f>P:.L	St\0.cvO\roW؊xCiȣ\n-\Zƃ9̭=LDT$ס\r#\\XhT*9]`-gWI@Jܺ[]ٸ^=;w8%VGuJ˞v\0f{8:\Z\09AB-_O9k|	(B2rN\\\"RLFvɩơ-&iŚ8~9$h/|\nWJ<v\0uĺwnhBhTGwg *EDuk*ugh2%.g0K>⏺G.P@J3tBkD|$Ts	{E6svjf?M7TwϓgiѾM\Z\\ͅx4$Yb\")Hzd<\n#K/PEbU*\'-DNHh!cW8*>mMb\r\n\nqqȸWbNېWτcA7*H)sդ*RE\rW\"U~5T?M6m̏fڻ|5|k-#8I0]	ք\Z4xLB^\'9Z\ru)Φ}- kMRh;fRe_7T=`#ya\\ګ:KB8co4>G+bI57XB\"RӦ»+Sa\'\060cer`tm >)&1J`ZI=cBfeƷC\06&FL\r<\ZR#캝Ldp=@fIWX\"8(|K1nKz= \rɻ=k=CȾf\nr\'WKÛw9T1lJ$m#XWmMB1QwoX4bxc)@D˥kS3hAΘR)+}A6a˯|9Y\"i*UL<6\'I>bv.|T\0\rEgǶj.htb5p<eZps}[Y!m#elp.x\0mxP/d;sTsM=j%0bNtR&y.sE$il(݁b];!\Zg~:\ng$d(e)ڻl{y#]iFF3J={$˻t_2x<-˜wqIguDnM=i\\He`/ϻ{tx7iěO~d+fGL]{z5,=B;hbɣc̻j:%o24vY/p:P(%\Zf9Y\"pkb}qB}rQK\0{B0`,?]/1{Ƅ/:Qv>rr)qAo\r:;(S>T(YFwiG< \nӻ?󐵵J+d;>w=yJf\0b=Tzf<ߓ9𛻴B!V5R_Bx< |9\'bL*^PXBa	0v.dɛn(Jb@iJJ31Z\n\\ȩ|kZ=\"ǻgW[сq@4B?DZCJІ+za0X݁DvJ#uMҥ]o<R{\Z@G+/Qq}\n8\'[~\'1dÕYxmR0tJGռLтW=YImҍ||ò+W$UV{r0$5 ԥݨouP\Z^nNit\06)#At7GqK4턳=0y2 3=Q+PAr9g;!\n]Hkf8X=ePer	m[KzW`\0m5V+֩,XY5hn.ce\"ӌ	\ZSCרb\r Bϝrd.:vBi7J7]1kk1G¼,`|]$9`,w\r>-W7*_|u$ ܏18:C^j\rv`<:gj6Tz308Xh^~m~Uwes-rF֤ǣY ,p7U)E.Y\'ȼ+kz	W8Ӂ0i@׉wD u׵ބ22RYRP4H9O}X-*߳rcYgx--v6?[@~|c\n5ּ60覧esW(=:W?fD\r5ק	ߋޙJ6qmE_\\<A=hD@a-b8TT܅Pק`Tn(I܉nhg\'gABUFǧPd4P[E_0nЍVbA-w]=gj8\'Sf(\rF]¼dqZeȴklW`ePfb>\0_+^V=^%~t\nc@P`2_PVbBȭItJ̀rc\n6/5y«q{arHEsiKCco?*&ҹ\Z穁UievmWh#T5)Bko!|-\\\Zs[p_W<e&v)\"py({Os\rA3Ǣj!8}BξEq8Mӵ6t굳\ZI`u3k:paϞ7r=Sek.4_\nz(@?[EIn}\'`C5֚%{A/^/,S6DTp.?+7{*r)prAJBQvep) RbJ>ԝ`ݷL5ԘwnÁCP_2\'pҞ0)XI}I<NyHy+3H(H^eE1oyN=Crb\0z	 >ܪM<m\"\\ߵjB9[/+Gހ̚!C\\XJ0*\rda1dg֌HFY?\n}Vք魘nrw5ꂺg*~;0MF)Um0܈#b\0T,1Ԅ\0/JL\\{\rͯ_x!stBPrS7/nQG)5izʩAx\0v1sN>cID٦I0-{bkK7xeҲ]֗~f}Al\nXMe7ʽ\nyC\ZF0	2x2Uv*;:jl30dsc\0q|KF0_qYsBKbַb(7^:˽1Dc.Laeow^`wNOPx3C,wW̑>\nc6iS!ຉ46fۘD<mj\\u^э_Mǽ@ی?bf{U\nv	{:kamA\\<BDtػwF_C˥\nLM4`7^[RDx}G<Y8V#rQ$[)znáW;WѠݥ`WAA\Z!sn?Rvm}ax{diN\06Ok}ʘKn=`<MejTܙ1iXԪrFfvCoJᨷN5qKZ_V#pW]BS7jY4ciAW\\y)9S[f<\0+{$/ؽ~YW4#a0<g|.JDSy\0a?A.+˪VtX$2w&Ľ3P2+?E]tr+Mk$ؼv̜f{xԽ!6 \\rUÃh-~u?\Z_?-lM2#ÞP/	k7AJh\r)L2=RY3Lt/dۋY:Ǝ}<3F[߾b^\0a$lb\"sEPId^ۢdwymeuӋ;%枧\Zlr \rT鶮Қ\09;1ܱ\Z3=A`eԦG9~rsjJO&:̰<x$p&xC*:Ĥg^L\\FqA\"@[;Kkq?By:P\r\0!EÐ#MOzq~Γ8,Ձ\\PVh̚e^9Ǣr՟/޸j!TNTح	fteS۰ѐnlÛ-	g䅬+.S^Qiͦ&YX1\"I+r|wT1a>00niow\r.)CHz\0ɞ_\'/tl{FjBUE;9(Kz@8\Z!G6ͮe,\05+\Zoo`yfny=Cժ8:ν	H߂@	fD~7.f 	TGCgҫ,R¾eZTW0w X$q/£1S4rjWVe#RC$[gVajW#rE!Q\0:ܵ9GH*5v#˒~e`zZ Fo;ԫl̑*}3Tǀ7	фVFLv!0-nD(@&6oZ&!1&՝fӚfs\'~?$bX\\mfkJړIB()&.}_jhF(֫]*|Wjut.!\Zf=>/\'^OoE0R\\BIM\\O&ƃ펀|!Kt1@Ir(t_~@hVy(;3\'(?G>cgxWʡ̍V-EArDx++`c`/[΂-JHnC@s1j^Y\\cݣD>r9KQБ\rq-FV0@Tن\nZ~\Z,o{l[UEX}AJvd\Z<`eaX9$Go)ոr?S*8q¾Zv{ڒAѧs趐~nkX]ʾg<QQc=SIp\"a\r:4mW;խ!,)FfE2SXySMqjBqnjn?Mw][fv\\mS^F\rsd~\'}=3xA9lp\0ư9e.Ov럙uR9\"9\rꃛ|+ce;Gᾇ\ZXkrLrB}	TFqFqDZq	*y\0zac=L~qn=4I~+}1j7[UBi@lJ\nJvBbsŎ#T%bܱL徝dh~hĥW9&((O\r0^1F) ~NԹ\r|\"Pim,)h۫!XnU	GRdF42{p|2pFg>*\n1/`\0%\':H2ڃ֏6Imm)qppJNnxh\Za? 4T\'6aȾo`g{Xi@\\rFsfY2X7\n@k%|/@J:y$LqIJ仒H\Z\\L^\rs=\0>mN$rh)uF@1˞oA<TQǾ*5ogf+{jҚZcri^=4B֟ўKf\'?=Onư^imQq+\r:Po\Z*3qҐs2i5MRGm4\\4N\"8\nn\n#SeV1_\r>VW=RYHi0iu[Jh~A\n%jƎ]׹t52\"8\r94Jb r1LLd32X9	Okbe\05dSlȔO^,RNsSn/ħotU ba5TQm)k˦=뇑\0 \\ȿ9$D_P!d\0LpOk7NlLn\nq%\"4ӻzP\rUVJH8<L&x2*n;Y{uDW[dg{\'B7^Cg곶n}10n|UMh^T\"wF8Jѫ& RRH zf\nx̗CJ=Xӎk+*.bZ[rvC-Y7=wS`D*˲eҤ(*Me\ny j-[]^醦$wB3(^Wd Bsn9iS*LDEqSP/kEaƝԸ¶deـ\\upO̊J%9]A_2h2yQ;~\nf)Z?\"zI\\N乍$Apfl_:YT^,FdΔPgẼV@P8S0JȪȉ]l7}r %#bpC=,O7ЍMEM(se.I/J4h/Ѓ}p|fX\nחn\'ϝ.4俛Cd8M+7b6l&ln)Z/@*6yR7,䓡DFfl~0#FyWy$-\rm}Q4%{{`\"2nE*V$W蓑eB2o,J2Af.1\\(d.\"\\nqFw {/:a\"ʷxcRYKSMO-vY |Iƀ^Q.aW(f˿b\n;UBʅ_b\rARc&!b_7Ygn½E9[9|<C+~Tv@.|s>0OA3jA1\'-v.R	$&8Cվy[{3*lRBEnH.VR3+ֽfjv5+AvyrT)\\sEYZ&kW+i#\"iR,k2qX8	֠,It8҂Y\"Ed4ҍ2۱hrpHοUN*>FZВ-z	̑Tgqd	}w/?V!q?x &D?-2:ab0S׿NQn	1\\^d/{51Ѫװ\" NT6npF*5LE\0J_1aH#~諂	~ܧG8)N*蹉*01G9	AC<naړK+{D@xEa=P;\" Q)Fr;Rhb_>5_s h?ͫls!1}WF8|VapV\Z2#R3Q=HjQi,Z#&p\\D\r~7i/$7$R9LG&m[ӏp(f$RzXJ\0q,V y|7I-LxDjKRJAzTZ8t80pVۍg<\nE:0o?%[V_4Dg\'sאknybe-\"<Γ<\'xQ2\\&#eDm{U\Z?ViFVHp@\"V]q<xt˙-2Dw0L5.\0$Vua+EIHh{ \'%b[hΤ\0@C8d6LJ̪ݦ̖cCmvڡcO\\ޱDic,7[8NGs?3UQf~-X5\rJV-c%#ep~8Ϛ]kdnOEŢ7?>A2Np$up6Y`ȏ#vR0u^/\'~,sJ$Tl>6H<oBr[n׬*ªXz\"ʣYcC1|,w9**L9nHEA_<\'}@iX^k̹	3ۅ\"!QHQ\'켹Rh0мUh\n5?Iq9LSC0eGDeVQ=ʧ!d~+O߬a#1Ȫs9;\0eoH߉T$FT~KK`ec=;;igi!H\n\nu+o}Яn\Zdq|j?RN>AA{z=\0tWs	a݁iiW[/;qP~Sr|L8eV@5 ]UVm8S$/# tGr~ߺ6aJMF=%81s#Z@+:b_$4_m2BJ\\5ߏ\"%	N#YkWAc	$ؠie2g3.7^VtYU@Ď\'~(:>k1NkԆ	3Oʂل9kǋL[:&钸(b4YOV =\0_>ڄtV-؆b\'	[9y.~?\':J2F})cilY~GAS\Z3H	Q9ͳo@h_!1S/xBMWXr0aFd{Qx`Kp>(mտ73El&\"8RdQopXqLȆI\n;I!Bq6ƱS8,^+\\鏯\")>(J,eb5\rG1[U {Nƛ=\ZH~h=UP|?7TvA2YB\\_i6[RomK.x1+w#WҶbcr)W\r<|@r{?R!>\ZaeUz>EfZQlW*ZghK8&W{319,ucN#zNe!+rda!\"QYP56#*Z<vT\\,R$t\n<wzKyhb9戋A\'س\0ug)2JDp9p\"#dXFײ{siTuI< F~T}]LOyԬ,s2xpFT-ou	TT>&Wm_xИ4rk)$)SLˏP3\\,|A_A/F!g1jf#\Z/W]z#緢׭n\n)\r@7r\"\02CD7U~|PzG..9\n^gJְxiFngזϤ:q4w\nr#J;Uٲq6JJq%1<6K]TsSd1DSZ\":4b}XւWRi`IDfbKLJ_JA<DƄ$&lSB]>LZo#Q^Vx#RsGWėT\ZZ%u_H\"ȮV~	00j!ڕ%UIY?Lf*hGY-ql3<ZuN.YizQS%\\6`R+}f5û~dP݆Q4=xPPÑaܨ~~&{lsHHbн\'`/ރ}X3\nD{|	QaK0Rb=ѶX׮,c\n5ikh^N@\n+@?PP]n1x\0haߌ5>tٌ^8BrZ`^jt:\0홰B6#\r\Z1@tξjkln~~TeP=\0lv\"k	Ȥ$:5ԦԷwyѶuC#ďAUf{Kb|\ZIlL٩~!;z!i2B.h8L*N.ZiY2wZkU\0\nRs=Eue\r(ʺ-u=1{K	~ظ1`\"L\\|!KOQUnN3\'v}n[%)w{{uYնk~U]k&=:hˌ\Z/e68.w.Dk< drOjo\\B2)4CNsHh6w>wq{r¨R{YO1ޱ97pz53Mwl3;q8^I&\0	 M5\\m#c2o~(pnf2m&Iܧ{f)jS CIQJr%tS)-!V>d*jPF	;QƵN1aG((L\n-~#N,rsMwjiqzG7\nIO>fpB\'R_,xW)_\Z6zyVi_ձ 59cYŦ)s0J/@(rO| A>m/[*nB_RG-YX/ZKq0$H]po=\'sX&͋E;\ZCa?\n=Ȩ@L.zw8m=q6\Zaިʒ@GiX4NvTVH$L^}`5\rX0g q3NY0P,E9=!64l0JDGmKv,p#ƻ;\n]KM+XRq]Yf?*Y\0\Z*s\n7)]Vl^B>-t@^~W-O&4#h{Il-cSOV̔:+*,\0}81@lhbT7a+y$[7;uC=?\0 WڦGB7k;3Kd\0.e^7AAM|Ni;m0*?+AlV$z	KR&DGm1eE:âslRg[>{e\nژx1RUň].\Zn$.Jh\ZS	3`-Z*`})0p[aׇ-\'\\V\\D@·LBcmէ\\KǊmb\0V96 \'?nH`y+>Fm$jǼ\Z	+eY65qJpQB#hGl`0BWԴ\Z:~Oű@8~o|ΰ\rTJcÄ@Pw*\'0M\'D۝c1חdÉvp\Z߾VۈZ6jjËH%fV֗M^^4\ZÎsUKΩDYhIl_&nØ{X#ރ\Z\nv<f}pZ$ÙK;JwH佐)KKfÝەt}y%Jn<~\Zjægmp(_YNjs>ESiì\'WU g+î\'iFM$n0T`<_\'6Lî%3F%quѬe+aМkcò\"ӃƋT^ނw òUhc.]0\ZcZô1zv^:$/Ӵ7c#eUIõa/U~\Z	xN] ڥ]Eԫ.F=|ۨJ6Ձ7(|Y\0H7 SgҲ3j:֩\"0hM\nd% !0#׏on?8Eu13\Z:VCȬi3_#\nOvv1/SӀl@\Z@]G*CJIǼC1\r|sE\'qK!T!.s?g6G8 \\2x_5\'wB(ɭ5ok5	<q0\\֭K&RsfiK$cN\Zh	9ҭdЈVoc8Q1E/=P%T>\\aJ.N\Z\rVoguD!rbR\rX݃	h^/WXgjU@6%0I\rof0r^]@2Ʌ0ZGb^	.LI*ҭa9wSt[D4e6So5RZfޱ<Ÿv 0!!N֢ƽKr=)4u(GC\"<OmSd]+vD>m\0a)7t2ͫA6ax}/Aoli\rlc\Z7o	L}ՙ\ZH}Ӝs-8{dZY\rinwNx/G:yLª%XܚlYD};7s̻ƪ?ísͩ5D>Q#*^_(VY&I@H҇[BS[1[u\'Teg:f{E ,<d2A4;_82mIp+pG0~G\0}֘lUC/aZVgL Q\n(vyer	6s5QZ_^mN^\r?+\'K?))0=ηLXaOxϷ>{eh?[>oQ_Q@u\0>͛7KaĶ\0C[ -;VjI|-7@ة\Z5]#knn\r)1:\rxg	l!؜S\Zc/$.BEk\'ZFy|AoDa瑔\":DJZ\'z&%tumv.)ْ}an#XpEQ\rnvPUIEAL`L_2,Mt)of.z%yns+L,אMѧ7刘fm{軒8,=Z k\0\'vҩQPā;\n0dzQP^.YO~[Ć\n	v;Jp\Z^}fH^Ć}ԾdQi=+J43/ĉ7*2mpvjNZĊ7Rm_f.w{s?豙T20(ē.p!ih08nd7MlTRĕx\'u~ze|\\Ev2rĜv 7giUeޫtȾ!͓<AaOgĬ{zKE[j8؈Oݩr5dĬa\"_Ty8aOoыoz=A̳\r]y~1]	L(p_TOpwC~VBUn}w8H\'Papgп]bz%Vt(J\\ֱnڻHU\\,v4z@ܖC(`KYT8cXX7Wz|\Z\"\r hz\ZES)nnMRa-\"?HV5EA~z_&䄪cm+lvG]%]e\ZpK3=V#ejiN<V]\Zr?_}9zНfi`CeĻ3q9qR0aJ.v;q]m,\\ؔZr.\n{/[\n&9A<Ɵw4zg/;g38$W**fS/,Hk!]\ZjqBCc8Q\n;X35N&\'_BlGu%?ncfdvdF딸6$~T@T|<ʓ}DGBwiJOZ@-.qHx7\0;4\0\ZoRD\ZIlQyO82MACd(D˳c{d?Jv\"(p{v;fˋ &UuuKǁ;<I=VMS<nb+?$M!-hcv~1fsg6[¶j\rN11swRN7+!h%ڦW0O\"4}AK}Rzj~Ub;J[xU^$d`v7fErR-yV*LgbJx.g0V샻ZesWTm^\"QќG(͢eK@^(1]!\'\\i>W$\nc_bog\"Z>0F\0tdSiqb߭D^p;wmupj+[*_\nw:Ob:^o_gOnv}Jv4$v.LstEyj:odFand]}PsrKS#A/\\\n\Z\0c|ffņ\0!G_N!K6ŕxNp}a	fWrtŘ\nC̃X|uv!Mř<T>]|O\n\'$K#\"j,ř;|U8p(~Aceś<=!-uW=T\0cᄒF`šͦS~(raWRYអuYde6|Ţ^\nJVVq{SiB)\'E0ŦO\r+\0A\nN85pŦp=q%;[̛Ym	{ ŷ\"NfJĂky 74kpiL BbtVV:Ϩ<(yk^m<e6amԮR%M1;zDk16∃\rBXњzyޗ3QѡK310uqh#X4&alռsp1R}cM]H8yw\n!\\\'}3^%ɸb %<b\n@t!0%/;+(݀t\ZU)t	-b[)>\Z\rg6ft \0DALѿ*8*RSFKMlIe$RnO.#S&\\{_MGI4imNTw̿6uj\\ޚH\n w28+lroP@s>L{̞w\nPeÅR$BRnR#+c93C_E(]3/NST2G%~8@g{SmȩN$#={4`DMoaYmyt@GT&IH3#8IE@sПN^P*\nDճ0AA\nkz}*$cS)KxX1Ӽ~bݥ9wEE3|:Gu,vhF&lor\"<żp8\'\n\01lx,tayqi7r|\\VlȾltdA4f@HeXqrk *2нY#sDS<Ϙ5M2^}Ɓ\Zd%\n[Kn0!&^pƄ+nT\0o<\\?_.,OӔUƄ@=*w,,g\0(=QQB3Ɔ.yٚ\nj5I^6&g6ƌ%{cUkw\r^p%$L`ƏJ@&uhr[jzq-u	ƐfB䍎C<Zx0譃Ƒd;RaYS.bl6[^DƜ5-Zdn3I\rC\ZHcAƩÉ\0ͷ8\0!EƯ<1ֳ-Pf@G\rGyƴ. g]Jz`$LKf<ƴsfOC|ut=)k% Ya@ƵIg\"ʧ[ r8pVgR~()Ʒ^Cۡ2$\ZvֱtqZwƺ\Z4_9lRkUk\rP\'7/^`&\'\ZBPh,QjO]ĭA}t`y\0+®Gxz&T_q$ge\"W9$6Y7oFm\'-˼\Z>A|H~%3{o}]+^_j2R4-z69\nX0ׄ!S1ӓ\Zb\n7#-EQ> ųtF\\\r?vWCYnqC}8|/dE|#cOBy2ic޻M\\<d^\"ą9ޕANĔ򜜠\\bZ_uC,PI1[\02_2>JV;C)$\0O!`H9znD	rY[\"?\"Z+aѨۘ4%k O/c񦱯g\r~ ǐV5?BBEC\0.q-u/yL(o $i1a0EQaQ2F\\>0\"y>0Pn~}5TI-Mhin\ZP@kmY#/.\nw\'O-\\mo}%-\0{<tXĝի\Z:)\\ͬO3+kD@\n{	ݒS/-6Rӊ\0I1@4}C&a䶻rJZ=tz6OeLoXr\ZִQJ澥e:P\r(uY\n痬}K³Z?A,\ZYPEa{ά(v~PPTW?Yum<slMaPL/+vwdaHgNoU%ܛ8|`*M@^oxhl i?Pt\0Grda\"$S|msrǁSzQc\\N~(fZFJ~\n<ǉ13 #TeD\"ǔYMgE+UX57HEht6sǫycC,S%PU{GBG4ֶxKtyǼZiѕ2`6h+,ƶSa.dNGkNךP\'hH>[Ұ[g-d9#	35{Gg{tgڽƛ{C˙댅\'0B+ϟAG]\\(\nPo,m]|[<yS݀<N!)vFpw\\s}s`\0@{{8ç~\\,HlŪxs3]>S䞩\0bz]܊0gmmĢm%QHy\0r|}D{Jy3W6;X^\'P1|р8&dK]enM\0Xiw1(:s#8D\\a{$S:[J<g+k&jQ^ޢ\Z\n(d}QeSA\'=;>[0[VgQo	ƭ\Z[oE	E4v۬>t&gk&e,\0tO:܀e	:chd\"\r+fUʰ4xY*Rlգz+aR\"͋kDxgd]hE_#4\'\n&qeu4\\pbo>^)B\rŠYCj9 _\\ޕqZԋ|A ӆu<̍þs$-u\"{3y@zTd9_3Nf2?(;\0AkUF)Uc\n5Kȷ84]$0T`1b\n=Wp=39\"֗;oF\"&\"9 (z&̱r#z\"#7K)γßȁuƧcujӄltȃogQfE-fȅ~7F3+Kuʡ7-`ȈIy\0]Qἣ(ͲȉVg# \r}\'f;MV6K`ɗȍa<,/΅2\nb!%w)ȍ)tff(A3F=WЩUȎ+/T{?DcgBo#r?bȟ;\r7S,i:27X.gCtmĜȨA8P\rhܾ]ZJBȵ08S9M\\1ִnហ/{4ȻIŔqd<Plm,9/,I;?%8QMRqGI\riy[.]_zaZ%U$DW-{};y*0՛s:@&O\nov#Ͻ0D#2|M\nk\rnܕ#a~7ԺMާ/<]Ft֏ˢP=`y/#\\:±BkPn;^jA&ގڒLjDݲ~^tK%GCbԌB\nO/A u[qR\niu|TP\\Z>k-A7^C@Y;fWto/8峋F/tn*!:\rj}TVEIB,ʔ#1eFqb)g砜yO7|b<sVjM|Y1<b!U>|۟!WYjY#peX\rx\"Z5inِˁe8hNO=;\Z,΃_{*O%EHL\rjM0(8ʓ&G_`䘓,*J٬k5쾁Vf9=Jߒ],z;}pSy,7sa.TˌO1q\'5[~>7B\r³ѱ\n7tvsiN0wAfLF30DѝbSF\\vl%\'Ͱ^3E>ˑY,XRk2I?~4]4KF\"vI(Mb}brV0Wne@GXY|	v=g8*P݆wWilB1Jr@}5\nL2ZQLOP(m|9pYuc?-F=DqJkfn%6O(맇P-cχJvX/s;3C`{{Sܢ{H@s=EG1:}{~,P~&=NOz2r:mtx߽\Z,YgWz7Kҁ\\ȩL9ɇSQ50NRz./1ѫDɘ@v,au\'٬sN\0bɢ::Kq35Fpu@ɥPK6Fme7ɥ͛Fw\"\Zt;j?`*)gɭh0eIeRݞDqaP0ɮamș@DmPJɯ	j[IY|ԲbX$nG>LIɯO3eF㛆v+.r/>,ɴ߁10Rzʵg\Z߁ԑ7ȲХ6/]\Z\\>/Z8/Ԟl:r̢%<\Z\0Xr:\0`w(=6r1=h508$ rZSo\n/GEA_l­<DO+1:}fۢf\\\03<-aQВu-|YXOM\0DQɾށNWf3	ͪjb30|BZ1Y\r>w٬TxaHm@\ru0PdO,czL蔫\0͙I|jI`s4:mS\\u%R,7,x,c9#k×#$]5}ԃijMP\rսϢgFlaY֐\r~Lƚ`:hTp%B]g\"`.Eq-C̌(QV`\'$zO^}Uk5%C$PT\Zi<,vG<R?\'ri.ҪV7<\'q)@:6\\UZp[ˁ96q <R_\nYBbS\"B2Xg/OICܖBA-+GQJ2~snm1+uf\'sOd.<~ NtQhFR4&VAWKxea~ꃗr<T\'\0(>UxWiHb-P^%B7[\rYA\n<0K8.ķANtk9^{sx*X\nbsQh\ZP?Ly8&>IB+aSŀSU˿pJ0{5qRY+*VZ=Y9!$,9b}ȣ/i%ĳ՛~b)+\nYKfksjPռy~/P:Ks#+$)twqˏ\\N];L?sBis(܀zHO?۷G۠ԙ>Z	~{oxҢ6f	R`w%\0x~6Tb>+q8F=,yg-Gyvm\"GB&i7qʇ4ni|UDM鼄EkoʉTcv?]RZ!_ʌb|tP][JN@)X<V*Xhʓ70VSS%\n=~dfu9ʘIe|9ñH>DB*x~+!fʜ^խMz{q40Cou5ʟ]bFң^ExDʥxuMKS:+Xe^.|Bݮ*&Jʥv2Z}K_	jIl09RʨG}TXLBu5^^4|AKʱ~o2\0?SV=Zsʵ7MWrZ-\n|%0vzʵ (*-t+\\eAYhJLMk;PhJK{+f0|#8:kϢefH>\\pV)$|x<S ߪGG0hdr鎄\nljs!~BOl;iKe?>VPbAy+L/SՌ$.bne͞BTp@ǘvDz|3E6E	j\\P(11C`m5^tMldk\"[7A&ɬ8P]jJG&nb0	M\ZVggC?#$/TA}\\DU^\\m$Io*ẾV\0\ZΨ̭BtI>E9Zb.橫=!}@,Ж@9ڏ++{44@7![ #އ*\Zmhp6o(JƘ4bE7D6ͮ8d9#Zѝo\nT#t9rd77=~׊u(,\rDjTO~\"L=<*2wwGUՀ\r3\rIsYΕAâܾcw6V	qsF1Pd\"BUxlrXwc<z!\nbOF)Z{;Qի6O,dABYB+RYH,<^&<-^[uelh[ߤTƯ7aSsQʕE|OfBZCЍPfy &Q\rw+4JPm_q=kB\n\\p\ZG\n0IpL35pD^8DX#qֻ\'fs.37neg]{NjHvEx,%%NA 6;34*E;`#5a.N!q?M*]- y3,4P9ƕˆM8X<}@R;PHotAvˉeyFݙtT庈uˊ%(|⛩vq\0}\\lnˋ8ِ?/L8\'n^iB7&`%\0ϙˠ9HǱUhLgN{1W(w\nˬG|\0fˌ,w}ᚋ릞۹˶bat+flm:󝲇˸g{)[;k@	9.!{,EC˺C\\=vpOW)[СM˿K3Ao\rwvǤ-%2SS{zb-ͨѹ\0T,Kob\0@ҍPaQ[+}VK+H4]?^Dk=3!Z=	kB§*PyX&%0V>\0VKN*oz@\ngcR9%GY`(J0p-5RU$\r3u/`Ԃ`\"KPK/+R$f!띁>7Mi_\"4	Zg\"axh\"\'Mi55L)\\eVA7rdmĶbe4EAfWRJRh`B3@CT,WMz(=ǌ	<S36ɽ\\nSF`VA\ZeVb:9%zLCp1P7Ro\"-g[>(nĠGWB4c-}r/߫,{78+nW[&l$hߑ#T)\ZL-70_1;&íWlYfTS42@\'\\wӗ̎Ui5/#PNgz\Z&x?497Ihb(̂&}*T<c\'c:y4Og8ĲFG\0\nZ7|?E~]S/_)#-|tUҘAq+SO\rz~(fYaιy=A\rC!˶SJ??uJ%#VJI_N]kW<Ҍ-8SZ1>n/``]Ƣ V])#dOX1rcؠ{˂!VӕF<NfW9BeT8k,Yh\\cYNeYiZM\'=	al+ǤBMiT7v1X~J=_[i\riJqo2ҋe}Xto|zJHް>|ǃuu}9%@B0?W\0C~BZ6gajC@B ̀oSj|R~)3\"̅P/\r_\'28\r\'ч]̎1BSb`;\0&:Tu%f^ځ5̓>-Pc/srt)xK>l$,\Z̗1~P]w;R@>B\Zi\\Lܡ̚Q\0u4J47:\"R,6\0\\̚*\r	-l!T*Z8ƒ]̠UeCb`aމbz/ȓU̠VH}5A֦6\\4X9{PB- ̡*:XAʚT@R\"W-\0^D̨tX\'Jܳaim>#Me̩\ZTQb[cU,s~$F_\ne	̰簃bp4iшB6A̳88#C	\nPcђ$GZ53̵ *o2d*_6c\nzp̸\nXGzy\\KqWQ̸\0SE6pOx4`!4Z>@	;dkIL\"gp{xE<gNS#Wnj+qJޱe X{~k\0a֒9pA٘Ǎ++NTbRs&a&J_\"OTa\nS.7ĝX`j\nf}DErb}\'%0*G>_.bZLuw{bau9K0	R$(fFJ?CNТr7eAVk];YE䙡m6%\\3de\nu8K8BTI)W\'|=dz	!ÕXdv,0lC;s췟)<-()G`29TZt9Ƹ-nB̃;]m8ŉn-`u&tߜSuj2kpW6{0@\n-t9L@/o*@@S!o(MX&\Zx/L9)f]Y\"cQ^;:O@e,/cv$-VrTsYݥ/h)`6+ڲQf$]\r.߬!J5|!3\n\0fByjZi\nFغ\0 µ#7fhCaT\"ё^>2^~\"-;CKX2H6\r\r7֤	p\"EBA-4Q4{BN7H{.j=1|#⢐lƟpEI-.\rQ1*a	D.6OG\npQj8.q}PҝJ:hQ[\"g4vZL|KjGW޿ayEȾZ8%!rRqOcGƳć3by0u|^/W8-fwCT;<YNxt_n/yyf\\u:66k<RV8:xȑ}.	G[djEi0p\\0ap͈{g-Z}^0:~+>x[P͍-Dn>-r118\'-us{#͕_w^	@8L?\0Y\0WVܷs{͟~jZxae\ZH=>ess6_ͨ8Q\\fMJͪVOe=|oX;77Z!ͽ1=͍N]z]wn@xaHJ8G\"獃N/6j)RV9 \r+?F_Tf*.=4R=$yORvnX3f%0y8x{No:KѰy+!1EÀ\'Uʏ %Ix`Lbɚ[_I%ǆm_|SLha\'\n	(\Zđڨ6wf|<Cko7G\"f_i\\G=X1!54V?g	(,T*i\\Vvߘ _VUz5N#wG)y+8\'T_gK\nh,a	d|\ntC!T\"h\Z+\"	ëF+7h}Ya!٩!_#*B	:_0vˎp^:ezjhXgٿ2&.(SGl^NC&/ρAvD^f\n]q/[5)Ӝ&D%GwYk0y잼6_`\'\\ *cGX]׸j%=%<IрhV8qWNk͟G33AHR\0S\ZN| \"hek>t3Sm*3^e9|#U6UOTbo~_7\\7Hms.:[)dMd|Z_$Lb:&RA0O/i$FH3&ձ2+,%7.GnBEqOȈ}] ULryis/.yN+4[xV5+D\"G{\\u-TƩ\\Xi{ !7)v.R91,=N+1,Hh#{d2SgzfĞMJKKY1΋[_wS^[xhºםݻ6DΎuL%\0M0@ΒS׊*KAjf_}/Γ&[f&\'8I,AΕN:9R}5U\\_^s\n|Η)nS&[{T.6Yi*HY_Ι::=T)kD\n38B0ΜЂ\'8a1 Z9pnReΞ+\0˰WѴcHc\r	\ruu~,Π	W\ZY]\rbZlȏ^C\"xsΡH~ǌ6a3ΘLK-B#WHrέwJ.ֹ҈r~w=4jӐήOOy#MPubT2.tٰ݉ή޸F\ZgTi0bwiαD	!\"F8љpUAIJٺtA8ZγC(Fu?qtk!\r\nw;=5ηrN$nzgAG@7\Z}A;/wa3xqbG<iMV,ĥ^m+u#n^,\'o\\8{NՁ\'xFv/r%CRj6ăڷ{0EΖ׸@Kx :IL\0ƚ|C	&M6\"E;?#9\rְ!W\"ӣ6>xkTi`n7(}9/#T?eZNtM?OYqJvǩ(}U\0T\n?42ݖXu~y`lDPX`dӂ|ћ:D3CSookj\\0[-d8;\Z3\nYz\'qs8hUq7Ȗq&u	76w5a.gƙ`5:74\nI{cqZd6Xd2ÿ3!ˣ.XI3R\rVh d`+4Y;YƏZZt#}&67&\nJ0AmCғw.n*2R&Xr]Suz<6uQcV+mH>8Id(+߈G$ԯ5 .ZJYؒ<\\-PM+[\rO/l{Ąă#|w\'\\3$:=/ƶxƇDHsgCklStUa\"6kHDUxKU>5JߞITb)dN>`eLJʧ-LE{_E\0	RB}M231ɩPEX},N~S w08fNsEC%\'ۓߟRf?\rNڻ&ICJpy:Ih<#lIzRb|X+	IfhDdIop{#$U!Uwe\"]t OKm~\"Une\"4\0Cp/5|X@㺪gp.\n5_Uqڠs?K3^kǧ!\0޼L޽\rbգݭ,aZ0P\"s{N3r9[>!ؤgdsoAD;u3j͏UxN&c񌀑$Zhjt\n:W6TkƨRt4Su$:Yksh-27`hA8%luݚ>-:[BǓ|*Cǣ@vEjf;6,ϲéH\'Vdz\'9*!	f\Z*eXrχ87!\"(Rϋ2\r\ZaDD{oϊ.ƓOˆ\'K@w.Unό=_}+~(ȞevrC[mKϒtSt:}MKj\\,O,:HsEJnϘgb!BUKtj:E6bS$sؾ+uϹ%虬Yu{].גd.@n11RR_3o07֩zaϸ$a5QcVjv`dؽc\\\ZZ7m{k\\ڍEY\r>3,\\B>FB~D^7&85mmYQ,|:Kʒ%DLftd7V1}`d		jz^QEQ>[!Be&z-~y$LB|$g_*qrޱQ#N#{Ș]$Rdw\rI-8?.}~\0\n]FeQ@5xn?Q	NIDѴb\\\rB,!t{4UX̾Oۀ?ZjfGcМ}v.^H\rf6>LOW\\u4ħ(8.m ֿ<xZʷnn@yќx15Thy#cǿN5 f7!10)SGe	5hCG1oh0!#bXWbp?\nQ@xHc(X.Gǵ^K,8b2p*XOLa/{ؒawn\nyL+|6C\"߂OΌ#ihze>s05iVroFʛAMY|C 4۶l!zo}s<QI>QBD|tLVaW-DkY͐MI;c}8e3hhx,⁀vks{	IF)|#pSRNbTisUYX}m\",W9:۸.෦Ho\"b[<\nDJ-\\W\n(o\r>ѩbqiHBgebtfy\n@şjY`STͽjJX*ZmTJ{)Aon;9%n[:mtog87PvZ:EFMqe\'i&]Cͻx._X\Zs,6Lb!G3Jv^5K`GCЀTft<;khyU.X\')7NVЄ}h\"\"<Mas\\i5?1xMЈb߶!qá!$-bЎLX]\'kAm]J7MBДlWh<S=\\\"0iCDMq\ZЗ!9^׻\"ZP2/!\r\r\"	1{UZҞJМTсFC)k|WjNɩZ]/e{Ф\nlnn7]+\\@b1i\'3Ц (ΘIbT\'x;4a&N_7б!gK[LW&Ƌ|ҫ٠/вe^K\rs;SeD+Vc,/NнxBnH`(VMa=d:5߼о;c\0ׄ5s+{u7^п?TҍYV<10v+Sn.zH_5N̷Rm,[r}r`ˬ\"(^\\)rDr[#ᤓ\\SkxiSrzE\n΢=D^߭kF5-n!x`Oksu=J$u	8@Zx`#)+poPˤhzY[|`;];b#7]X+s6b`&h2)VKF}Ոm?*f搭@%Tķx6ҒOӄ9Ą9.z8X˖<Rh#IJ* Tq\0t<bCK7jBYCn»̹)B#)\n@}nF>k7X*ve{}b\\ntr̎R7eJDZ\r_.>Q}ֲ|ݸhOjL1<a_/\'mJ\ZNhUgRD`*IȻ_\Z+bZgӲwIP0ιo-jC$+҉u?\r	;+#]0q(%L{0d &X2I\Zʜgq-WBBusٿ	#g2&*0+AޭkhϘ5Pp9\n0PP.3<cDNK^aR-64Vfzo6Ə7yHg|S\Zneϕ7{oz\n\'S	O]wIj0:|[7iC/9\0eiAn\'EgiG>SN\0HG,9QWhKB+u\\ۧ-;-R8kp4C9GE{/{0i[tb#\"Ko8e+UӳsOw3RWJ̡f+VUm9jOD]L4?\0$O5X*i슘#Ӡxzq蔷g\rӒdK:DфzیX;KBu$H;!G{:ф!`mRutY\n 0/kю<\nZ4^n\r1.աTĘAђ&kO.*V`єS2[HR?\'Up{JL`і]z,+d9Tj[}0A;\'4ў))ݑE&gWyǯ>Ʀ+ǶV*CѦ!dsh s=C\r.2\"D+	v۽ѫ6mGjؑ@W*^[h+Ѭ.AQ%8;+[}2\0Oѷs]^ߕWfp=EOfѹT)f-D/kFbyH\nqbm~	+jDŧɽ5hmCs\Z\Z?}ҨK9ՂxRݨe|\n9O\n}\r/vd@Z(l-h_4\ZT/2<\nB\r46kQ=ezmCUOI+W%U^K4&|\ns-_n(&E>O\r)N-޳J^2\0ґJ)@2~E/:7P*ms*V	7s/lFZ\0)f3 Z&vj6\n`\r$%eG\Z8	cb#k uh(\\Fpn10e\\a)J<!F[\ntP<t-O/X\\4\rOKRƩeDړ8݃j0@4<Y$<gleDa\"0\\HF d&\0W&Tvj*zX%#jW7\"eKCds2R\'Y((r6hŧ+#%.!$ʔ/))Hoy.+zXc=o;_f~a>v.đ3E9D>	.2,!7mt٩wd]҂5:Uq_#@%}1i}.k֛kgpݑby9Iqq?S4Mڭ>/]OB*kKy;8sÐSճP\Zi\Zɶu\\\n]lk\"?mQHm\"ͥ0z<\0*{}YS[w\0m0H+\rq(2=]$ɆpLdGa2x~e_Za5ڹ-{UVdHbtߔ0cEwQR梍zr^R_vn>.OΒԔrV(-W#Q?`GuGp~n-rxa;(ܙHVC,3\'kBqa\0>z\\MGjh)CnZP4hHzQkq;ф=zQݬғDjkh)fxwLQғsa\"o?Щc9CҞ1g2	ʻBs\rVXLҵ;\\RnDyU#m\0aQ-yj$ieYi{p\\-̠K<\0SYJ2	U<T8ڪf.$FL6wfj\\iAxkV*\ZEPGaiB}X(59;kcH\0|g8>q8\0\'NSIAʍ*^D.oR|D9O4[J#F%Eؠ!PZ.Xza/o[xPpU|\"8hj8\"Bp2%TZԄzXt!W*)%=o#OoxqLx֘\nd`3MLa	\"<Ɲ2,*5pG3U<uq7/2\"ώ24\ny4<~0˅uki*T4H,@[#fy:c,@+\0xd^U=Z0׉;w2^f5@է3=>+Yb,\\eYtG7gsE?:zM$qeƭba2E!tdP¼sBc%<	Ӎ8A6HWvMȝ\0lSdb&YT?W\0;\Zq11fPuN\\8nRΪJ<h+=	9oF^O3\"	^jj)RBxBL =I5E9g=) \nqJ%GU\Z9t]E`HQgj\"Xks	&Q=IjEN7\n;R}lpfVbmmhc\\J~9HJ$[x[֝~m/ȶ>ũT.),l;;o[ӁcΨR(I(>1l\ra@K6OMӆˉDgu\nY2.C0ÎM(Ӌ;sdO&hgC0u![+\0Ӎ\n\0,zbfUوbr\\Ӟ*سjEW;>$:̈4dQ+aJӨ+`qs{9OFxvNms{ө-;-8vW\"2g&U	=foOӮ¾&j\0vS|.kӷĆ{线m-a.GB1n:sN΍H\\a,Inj&z	#ԍokU.m=I@SfMGSbK\"dip2px~uԜ̶:wyj=ҕī6xyձUڬ\\hEn^^߯`hk[Ն~zpt(tlJW,%fq\\kU+[k7$[mHJFM6\r3UQDxSy[9l:Z=`Ȧ4W;3G1=vOio=#cؙB=83_QGXwl\r&Z\'esz<\rZl@Wzj߲%p-2`z;	kgߋ>u)j*kKz\nFفePw*SW.~5t=Vp̦.gDd(fMt\r|AXP\r/?B<\\|8W)\0j|(	yz633Wq\'x0`CAW\'>ݩA$s8*w,^4EưPp_uQ#tG_/2 }K\"w-\0CV!)3UէyRQA|sa3jqdPOdR}{b? Ȫ1#YٕT4cޑwHA	<f@ԁ|hC@C<&xZ0U3	{l.2pyz ც̓\0Vr\nsg]go\nE\0\n%fcNHvnIinE}Zj*!k&RA<i}o8Hr,R\'qBY?Ԅ#9TB?!RˇOs>·A0ԍzߑQw.OB[NsZ7Oԕ|VmaqR<lɹm[I%#w|Ppԗ&Iپȡ\0	Pa!\\c7ԜI|y\' vdŌ#Ϯtԡ*IbW]3UL]T)!EAqԥ宂EO1\":9(TQ\"M4%Ԧ0-/\\kW%oޏ\'E)DԦ2iiCnGJn=J܆\"KԦ7RVWYwBU$!d&SF7ԧDλ@Dr)SdYWZ4I԰/92RSH+Z%R.Ը4i@ۦ\rLoaT\rXnԻ!=3}hC&}:^L_{J8ɳh:L9TX=1[kn0q&rOfA[Ȳ4ɏݐqU}R\"GǄLg+\0vQv1R2ߡ/Ɣ~Ϟ-\\ \Z@G>uyгL\Zp5eQy|V&ͳw=^jneko@l_ky~YWŢA\\\n\no]9*-Dہwp!Qǳ@;e$%ߩ.axn`fw?6y}>m\nMR暎l\n;r3`]o5B_\")2n~MtAvJs#.&0eKYx1O?N3,y;ӗUBC-mo`3^jΌ#V*z>X{xGOm_V=5Հ\nݎE={{PiyY\n\n-\Zt4A&E(6~e|vHl;R\ZVyf`TØ`s[!D:3\"c^\0kPA\rrZj?T\"(/`)+r6Kf\"@r{Se:4e\'\'i^SEv/sս\rDAYNN)>\\55?`KxVе>hgoQ1\n%D{RӢ\0M+2Ӣ5GMrUe.#Iu}9#13^*\"Y䩘ﰟz;\rM@jc3.R2-<cM)0͠\0fg=.\n-3C~ sϨ?1\0z (mQ\'X.ցS(A:	BH)/ n0;[`3\0&VLҕdL&G*v,؂x!r^OeZ}{ 7tBR#\r\n0f_`۽Zt)<j\0[\0ƄpڵfO\Z@\\HXE[hYTUƥ\\)w	$ZwG\\\n}(nawC9-AIQEDlGFO`mČy`]vayTzwyjmˬ\'fښGz=bIU=zb3}u/R}ĒGN2*RmWF~mK$QՂ+PbX麺ss鐗?\n ճՎ1m.JM\\kV?1 [`u>\0!,Օ>o* ,_wE]I`[3Ֆr\rGVpGG݊X3;՜5Iˆ3էKnLm\\UkJصlLա~@N4Lv$tգd\reOu3+Wdզ`A^{Bb\rN\ZմͅXτ6u\\hBնt#?H{s1!&\Z AkfLh~Bbv6ƤJľ**X|icy-u6pC-$*\n8Yd^^uYq,c$:$(Yz/gԘ\ZEyEkH)*ylփ/J	u⨴>;;OU<çG![MŎ~?SBmQtJQ	.?q=lI\'^Z	fO{0lTFsEˌ\rf56&X뚲Ց&|J>#\n\"7`)w10.^R:g~{lE81XT`CYHb괚fՎRS\rG41^~;ՃK+e_7z+n4߼aS>6jhiO6#\Zl,cq|Tdٹ|-WT!ۧ(!OX*7Al\"ngn{R`[Lƥoߏ \Z`V%yٝnҕ;?2W\rn&ap6fK)^o灐Os<A63A߯%wZ5-Dڼ@E2찁;+i_B;l*.BP#yascv	T+$7ٗw7U%(lfU}hp2+nDʭV88`*,qJ>rXſhI-[H9UXP%Ĥ~Wg,?,N;?H\":P%i?\'ho3U 	~n6>i~M#rtPSsx\0˖☤xA|.~XLLtر+&)rPK,~cyhGKShuPm(5,|MT\n\0OJTօ58VI0=YֆvBǑdX 1fvHy)l֍x+_Ya؆CPlNb8֔MWj\\G\nVmGR|֘Lo5הH\'bzp(֚jQ/eiWNq/S\0֚ă3͒\rΝĹTN3_*.֜_[2(y+9}QI*\0A\Zʁfg>֞&ur|i+Q`ŸM1U֠)8l/ZR=Yp֭}YT3l\\\Z<oâַ0Fv dܷftx PY3*	Z\\!l1ҍ\\]4\'7<U~AF\0ey>olTTIOO2Iu>&˷uUĖ{+p\"WN-@m\0aX넍!KƟ\rVKNrc\rA~n%}dxpXBȣ1*OR{!x` &{;uբ.XvaeBʫeQy4o@Qc|AȦM!\"NAɦA0=CAb\'L?QLrt\"2Ϋ[;Ab/9\Zk*Uٶ)\nHHA(r\nѭLiD\"߶U\n.%K.PVvZښ[\0ȗfE6טx!=UpbhRϝ\ZtdbDU4o$&BYAWe7wa0OZe_.8Tckdo\\o~(y&jF%@I(.#5U[֋DB@i~1X7>b*VsdǊuZ$F!l&*8#WBrC$D`K\r{&n!O9Ն\r)\\0Xne]]U_%\'7Ö\0W2jʙ{`,VݖA_G\\\\vJxM~}b}3}x.01]!֥\nc3*aVֆeƗԟ2f\'\'fWݕl\\2G29ROt\rC_4czSsTAqcڷ59aO҄?tC03Y2:9\nrOl/QgJ22<c8ezdK^đr<T{#wM)PHٹkώ%7f+$.~ӛMxkv\rns]%́TĉҩVe =P\nVwځ:_5\0V#~g,}~Glm=(Vt`e^{Ǝuj-{V=O\\dT5^+`,<W؈NlSf|u(O#`9Vޠzd?6\rj??f&:s[#RDs;ʅimdJNRj8?|H!sђi{OT6{z480og3xFR.:+Ѐ~@WOE-\ZUjw<hׂ[3,=Yӻnz;LQS1\\|5ы@׉*#mj|nohH]ޔ3nה(0g	̂T1L/\ro(ׯN䬀3B؟K,|7i*_)&C_װ&䄇2C.aeE0,9䅱@3F`h\"^\\&ZFoU<wc%dU.^qsFky\'ZS54G[\\e}*<|L;z)!HJ){\"GkˠBq1xx?&WFf=x;Ҹ.uL	1(&:SWλ(pUH\Z7Dʣ/0?zЦQ7ci*Z&M.^u9^~}c匠E+\'~fo6\re)0v?cKk\\B{\'e^5zϏF+Xe?_jaꟌ9,16;JmXq)\r,l<@I	8|FCI׎	WiX=ՀpG)Ԝ2dL{035Y!VCs-L[Ej>Af\Z\n~S20_ɟ5/cQ\r~jb41 EEz,ݧIAq`GI\Z{!M}OLbdpOhVÛaM@iD4Bpԣ\ra}+(q#ԜD]KX+kw?z&Bɶә9X9,<w7V1̒1(MPg|&)7HJnpiήo(F rr^$K1Y$YH5OEL9-N:\\.$/?b]\',р!H4O5M&JDK0FNw0\\Ps-\"d,世n7z:nSKnR K3NAAjA\rӼyտSTvu!@bv7NgVC%{U­d!G}	{oF&-ы;EX3\r΁bƨ}cp\'hdh-\0e[e>m30#Od-lX\Z_u%U\Zf5]p;4]uHsjءœ\n[HH󤣽&@|M8(i0o7ulឳ~4u	k@5=({\"X<؂0,%Z1fdOʁUd؇tЁ(&o*B<E؎\\X)Ш®4ʸcWþ#E5ӂe%/h]޲#ш9`v5,nRjtݑʦ/D<EAvW$ZN;/E寀8ٸS\n*Q_1Xjaa^ەb(c/:+~Ze;#\0ts}F*O`Kv$|\0u%rvBT iނNɫ/=1Ib?Q3Y4T	3#y]r];Dm A\'4Vzp}(TOoVTX.oAU44G}:pN4oxQpY,Dj0\\lM51(R;\\gՌe՞$\rs/a!c-@M7-P&Bb|D,UaE\0674z0<,xR$\"o:Xg%_,j薶tC@ϊ&8Haq_/BuZ&?y=ӡC6d6m\\]vay?Δ-[91\"#G|hHZK\Z>BAnIQ_XDeBYP\rK -woѸ\Z`YEi9m豵k̗g>F53$F~&T2aFI\n:<-JL	T*fZ/8߬U(WU{-V͗8$4l\\L4y\rotf`8^Y|b!O\0ڹkZj W4^I\nviB.).vg٢wT3`=@lTzŜ8)}~H}qh\r\")kǨQ4\\X9P ]Xil//~Ri\'\n΀]h`zAglq!@&F#.\rddSEfكR;\0۬4|A8MRŗQGOʴFsهOx,{e>zɁs2CܳٗL쇾nq1ũe1)ϽI^ٗNai9U᤻\Z{٘\"[,T#H5\0F	\rRosٙ$ѰRej`^7葟%yٜM9\Z/\' ٞ4bVttkEp%~D`%\0;٣Z7uNY$%@Ky\0>CM>٤mSm?޾jr^آٴ M\nWX\n躨||3ߜ++4,ٷ紱1]ֲlzbVPx̜=ٹݸ [M|\n7	dŭ?/Č)-\'Lԗ x!Uw_nFa>e3;vztPi(d|\ZVw7BAzzMk+O5@&},pyF(%Ld\r*n=YNtZ)P\ZF}ͰLO!3+VAWNOV5}<*$X\'\nޭ$leS,kL]*]>N5c	Ynl)\"Sl\0\'\ZAP:$yx\nPcqqpuu4F݆$ӕ66g%!/X=tf{Rp_yݩFs3Gb8N@X6vwf+ow3KvPen4 Ki	d$劮W _p~*60#?BTP|:Xk>`WO@!پp}_0[\Z@d\nf!B>j\\R^3VcZ=.\0܈\\\',(&M1^t&*/:7`P\nS!:b=(mybVaIjWp(!A<(X.#R[$V<Z>f+mսRh_i;1zm;X?=s|VFƢIdE<8m=x\\ٕZViLW?Od_+e~vJ.Ewj#_\ZܞfnN7U//g#JKӒ]堹|M_|y?c>P`\\,`56E_+ˬ*$sނi9F	h@XwpYtktՄPjNk5nYM\n}2 `Qv_\rzB^=rԢ`ʼ5qN	`څc:ܾ|@l\'e߲~چL-u5Zkw=03O* ;XJ\'z0ڈ-J&@;Y~W	[vW|Q/ﻤ5ڍٿsP!\0VtbM]^\'Zto^ڐnA˅%!%`V;[.C_ڐ^I\'HYjtQӡ4,<.qڡOmi[KN^tK+6۽ڦ֠~	wvFvvG-ڨ*tAPf7*̟z0aYګŲT\"\\S@ޥ+0yrx9M,ڬ4 V!\ZIU.Rv!sg%ڮ(\"Y<%I 0c+	Mv1ڳ\\D\r\n2t?ګ[t576e|ܷڴaWtĉq)N*x*q;T0ںQG䃞uGiԯg#dN,֢_5^W{KbfZZ5@gJo0n2hFyPXp^Mƴs>\ZH.\rߏZ\\UDOtޔ&ŔLZO\Z4$E@Q045RsO(lizR\"`, P+>A|W|hX$=]\'??zZ-[a<\Z\rdջ`k_[aJ{p\ZE=(XͤC=8ENk^C2Zʀ UF|c\'Fm!ԡ|~dkpF\ZWXQa`!}\ZWF\rXQ-[?l;])O=bֹ\n\"K \"@9NJQa^QiRz5nȱT~~{~bGߨ96ѡƳﴓt_Tts?c$TV/09Fg	~nS z>fSA\n\n+0X>JXP}1St8<\0͊J-v\\s	pJTX~\\sAk\Z-=}Fb᜾TEw!}a}.& c-B\'Sj?j7X	wm8/%2Ω|r.omVkDK#8S2z5R#2op净,Xp!:Esv\"y4AG\\r1\0Co~6@C-\ZSӛ\\Ȩ#>ۂwT\\ +=ាb\'^xK.ۃ\0x(r{)k6n4-1;PfۑBnJ\nڌ\ZJEa\nD]ےI~Y*wNknKA/lJ4ۙ:RG7 bE3mlFkۜoΖe7t♬9nAzۣ԰<К~_m?##B	(ۥ~b%w\0 z9wsn>Dy1۫S!bPTD{\0m7SvIۭM:EZ<v(@^eK\0۳}sYDk6M(kGNة\\B·۶1kЙ|6UwS\r#O/&uۻoXc\njJ#@R0`ۼ/$%&U.Tj5D-8FQ\r%.mX\ZRGdExH4/?D]Tn4ܻ\0CҞn^\\5R㖩\r;gPklr<CD0*\n)_c1eM\r~<L[s{/0I_\n5aw]>-=rmx:.owpԴ6b@WFk%FU}¹x	`hyYɛmβ-1q[42\Z@r: ӪNlTD,\';=%~	H`ֻ<g*gx#:h08^L\n/9rvsub\'Y-W/Yvw8[dg;jEmMe=!dgXyq*>V.K}iP!M?~\"u%[,l+?F-}M)57c{#}]P8mhR@_=R&IFb#hڥA>#\0`@}6[d=w\\+y%e-_R\"5/kagW7+^J6^NihOJkfiBD̉I~.lvPgwv\r\"aMI\\P;b>꧒5>7Dublg$\\\0Z4\'>͓g<Q2\Z{/\ry7\0XWX+Nk=z^z)t?Ū鳊<)+$>BFVd03mR2t/vS 4h\"hAD\'\'|6[kF=\nyiU>JQv3XߢwYk|_#cxTAt@3ޜ\\6\\hLa门b|\r,7@\\\'>0i9\'fJ8Pi\r1엞Qz֢G#mn+SK&sщ\\;Yq9wm3t	ЫQv#`i-1ٞUh܇c1dj+șZL9׳ky*N%!܍ 7YjkV\Z34Coyܑǣg\n4 ]D$WܔQms\"t.\'\\O{R,srܗEV8֋i;fe|ˤܝ.rYMDMKqĹzZpܟY<GB4\\N<o]>GSܣxL#!E~p#wp1[0L\nܣ7p{D|d%mi܁ܥmX7S8-.}F#{ܰatjK/2\nkhp:ZܱfXI`&:=^bKG\0.ܱXvWw92Bk!ܴ&#kpe`򷪱hfsIXNkǗ!JB(AL.V#8de\\B_&:K:\"$_\Zgɍ\rL&J`5?pSI{ǫ2jPfGi+YHK	ئU콊8J1Pd:Db׀&f8Hk[%ٔAAQ+*->].Qi_mrs+n0Of֠7y|peV8Y\0ٕhZ\'joWBw\nO\nQp5A~jxtY7\rdRG$>v9LRma稶\noN{mnP,h+p]h4Xd!FV#PX6Zg\0x-8EmbE\rH:mǰN{^QqP$	Zm\"6N`! B\'wCˮ[3,v~)2=ZMWB[(6)8,GG0wm+lz}%y-.}|tg\'fj\0X.0{\'~K.sJIPګ&nR	2B؁,qp1 -7zX:JX}k;\n5Vr4Q7Zf9rfKSf3q\"|>6P}#aX{fO|a\nu4Rr}?cK\r\'SGy>KXrۙʳkDm4J溧u;5Qf4>nBO@M8{\nصX,(jfߧZ\rV:݊w?L)Kf4ٺ\ra~tnTݎInsvXݏKcbD\",1ݙe$ҫNDgyBNTw\n3m:\rݞ?\'1\n*mG_{?&}>_Dݟ2j\ZZ4~7&}q>;Ԛݠ~[١}rܪKm0\\ݩzKuY.mi4*UTݯyv0jm 4ay2op+ݴ\"cYO|D\0;.Ѵ*NݴKbT3y*נ\rFݾ0[0\0RZs\"wL`T`٥MIQZLic\r=(3g`&}5)s}me2G[̭h-Pyz%Oҟ?om kL5ڛ1.x\"_ѷ@08&͜v;V.3w](6:ŇXTl??K#ZG533unM5Kh&bV\\%Z$iC1~s\\6rۘ\nΣ6@~g3pX%%k(;zF-c1<u3k\"n0!^|gFr*Ӆ{6tt|hfS?f_z`y(H2\nyπ8FpBkʫ.E\"y3(ɝO6Su՛Z&\r%l-cF.2bIsC삠Yk\\kFܛ$W5.ڪ}~o\ZvS,	p\nb!s!ͮ]>N#j:\Z]Aۛ>=Tx{\\7RAg[:	c89c/\rZcۗ(޴[	i\r&\roe}a\'*7Ak1Ga&ٞ:qɹ͔d^bσ[97C\Zqv7`nʤ)#2&SZ\ra:jlnՐym;P.SF>.wg:$\Z	V8{V9/jzbbhF+\0~9,Z&[U`L$؀<Ea>I\"eZ#2Q\"1Ȩ@o\'OMJOᴋne@n.K5OnP%sљllrb\nQHdrQ|\'e0x?L-ǩ/~f0әS\nZ*(9~bDbooIN1!SWjHc4+{kZbTUݢw}_\0gNј^f?=nªXtǞC{%f\"Z_m=Z>D[{/m9qN9wN|\n֥sa-]Ĳݚ%\r@R_SZ\Zj*bTO5pp`)s~xd(\rVJi%\"Ex|ӌsab_ $W\0Ar	Ot7\rށCkۭ@1ǐ&v\ZOzW@{`އ?~AnM l [&*ފuZMzwKV|\rܾ/ޏبQߑ:kd[SԖ()ޒj)+9z4@IOW*ޖp1iМ&19ޠ}D3̲ޚ 0 +MτΧżDޚ$>*~wa\rxޢ)NE->J,98\"t<aQtޥ\\}9QZ\rHO\Z+C3\r͇q,ުO@ѱYXmFĩchwCެ><f;OOƭ[8Й,AP(ޭ_N3&Ufs0n9,#Q	mޱ\n1$d8v^!*3#͜v@3&hN;yB\ZN 8	jxoѵ^r2$VsDn`R+hS8Ѧ$2Lq!wKH>]x\Z\0XQl~?8ii8|Le㡣ϗ	PzC?I܊ݍӸApwV;Jg闯Mhy\\J?FsѠT$`!s}PwE\\UӷHYQ\'\0h$z%ι|q1͞)m8ZZpt[wI_y:&Rz\0[˦Y+Oq$\nr̊4H	yz]WRH&\nơJxY#$m>ۍյ?U\"$lz+aE8IJ;0	:@#gihڮn?U`/3ܙ=^<OT%x\Z܂it11EgU&21YI\nf	YᦊFrL7uSt֗pǯ$U-m(+h#gXin-Z(;C	{$\Z˪\'_.9(IF\' ~V>򘀹EY\r,iՂ!\r2nD9T%T֖\r>ƾ93V@ŊoRDhgԷg,TAY{,P\0~b\"܃n\0A=MAƛG%\"b[DoHS		EN%Nhe55;ӏ\"4pz\\P+Ί!v.-+3A?Ru,R<F{;xپ۶Ix3\nzǖ۝QVERP$$N%+*Qz(\09gMEje^\0S}ԢOK%Ev3m<(%h-n&Ue\\Xj`nُ|&k2ʰS|I߆Ryru(ȐnwGs\0d+*!9#v@|z%Ӷp,ro;B5\0CyaFvVNcۊiBaTfX|jbdPCW>b$=Otǐ>G8jj48-sZԏsŝf?߅yRz5T\0DU磣	w̯߅A\0h54ϧi<V]jDߌ\nrsgɴ5Z}̼ߌI-AV	D;JRvaJ#z#ߌ녔BJ+f,q*WC\"^_V\0.s@ߌPܻ\0{QЩ#m,x\\`ar_ߔ}>&Iy	pby18gJ\nߕl\'FJS5ڮ\";%fߗ۔0/\" ,NВ|H4fRώ\"\rߙ?뼬j=:;{le_/ogNkߙw, sƟlalkHJn?&b+ߚ6-/{F\\Z7&(K]l<DߠB.qf6*_-WI4K2ߧ)sg,He|\"j̋2(߳jVuM(kE]p݌SXWI\r߹VNA=X\".\n߼^iA_GiI	2;pm\" `vI=߾[]NKu@2QL@C42f>Ņi2~<gqԴTϗ~%>M,lH&?jϘ98^JTOʮ-W\0%F6d!G2X&@m\nqnA_Nj^HCOWQԍ6m_5};[Iel\"I-tl$:C](v>0ל>iV+ԗX@]	9\\@wr^V[׭H\"|iAuh,Fi|x7N*TZj\ru^kbڵ)P\0[\'.l7^\r?%RcIglQRx\Zˮh(*ˡS®-t{\0\re7(C:	\0Y-,&?w	q	\r?K3/zԗcyR-SZo3ҳCAj	M^_mCA$sǧ55پt`H\Z&: %7?Tbos,@)k4@\'{.kΝFo[ո]rYbɬ+hslnY?(uoմgO:!,ꏑ2&(c%\nPB(13c)/C2n6&R,PϷ B2ɖ<tfp\'P6߱)u@4AN[W΢\"Jqp$ArL*95_q3mor_d)әGMYG6ֶ	_scNrux9/aPztLXpEQ#՞A=\n;0HdNo<Mް<#BJp*\n؛WX&qb#sͯMĎ/?wHR)\'MvS;^\0SCom94]2IeEkq`ЯGCo낈[3cXw(ch@N>އ͘RRSo sByc!lm! S\0xdl~TӺZ==F\Za\"ёِ	MJh^`7Z=^ԯč1TgرDwhl	nWڋ&;W\\)[ΨepTuԑ_x4\r[	\r+~\"j\\粃h_EV\"R҆cNKU|u=rW1c5g^q}oiӿFp&KIPʽD[E=3iJ[ax(aBtgP	B\"ૅعQ^tJrޑz\"ϛay&-*l)B6];லytf#f=˳XKvAS;ೄ\"-dJի	U{&, \Z/:,ǔ\'(QG<C<F\Zm_=|kBô4>]Ffw\'欚Evm8ٝ;0\nRlSk^G]p袣0䘯#NZ(R(6#Z4aĆJHڢ#eR7\"d730~l,rsך)ɢOQR\ZQ\\3$5Ƣ4,K¹vjrqGGmd8r\\B#!E!,cl5B\\	W\"gܷ}}/Cܰ/ŏ@XY!CaOL\n:r2ZhzT-|b8\ZŚy8_<-am6qE>Џ;wFC-P#Y\raP`^ܚ梨||CC0v0K\r-p4,KY(I%b:밸\nyör u\"0Ok_P xDQ/tvǹU8&.aYA=6	ݼ4\0e0*\nyǰuCA-;gZYD-(6 ل]MZ-<%F-4J\0)Sִ?k\"4Z./M[Qtn.?χIqA?Tj<woRI4x\"#4ϙw2E7l41M:@{ŕ	!-L	ď\n!5Ocjϣ$2^X~#S/J	+AI\\09N93Y9œWb>pzG٨Ep.V\nq>;(Z9\rkXe_^q(ѵ/̹gZ7EX55Lط\'ǺXh22&Xt-aZnj!YߕEhB\'~8X!\"ንԮZ3-;ѮeY3[6*v᎞O,khiYe8;w*Aފ&\'D:Ꮃ	bS<X7ÈSAgUu;9z5`v>dk}<6 ,?nі@(ü^k\\cȀKB۵&|UB\0Y;@7GJ۽揷+I-i3<ᮈXjtcIA1lhRTʀ]\"X`VCS5Iٮ\Z;&>x$-&z+\01f9; =MN}Qźe\n!d>a%+eT7 ҧgI?#T90fPPi׈яd,w=	{|\ZZoϢ.i>zYX=AH߻l@a\0-Wp]U\ZeOlP&A{5[8#=G{tj\ZC`qR%D\"/w?Z)H%K-xrNpꔨ%E[a3\\;@xq$Q.ŉ$`\n6BnrwB,)iM\\R͎U= 8޳˴-hF9kݦXf<\n2/^hm*\r7jSlר\r/<\rgl+Q_r-mPhQ[T*-|b\"y󨟢\0|=aBW!ׂ`*?L!Ll`$,5%m,\nu(ޞw0+;ľLɓ9{\Zd`&B]/0dADt|[ji_ZX.g9RTZqDɩ?\"hK?=&KoHJ,a	rU9\'s?|NtN<L!;b՛V9t?CQ #2k8Hdw2!iJg|YXR0AtRWE )օuTRYT6r\ZIZ)[w[]=`LÞV GLmJafo\0We2`:Z?^X=Gγb<HGwE21wha3(J@d_㐟3W1rTYg)z럳9=8\'KI\rnh\\|UW5hgi߰Z5Y!)*֜GOqj+EӁ$$kX>A1T}`rn~	|HesILfjR.`Gjk|\\m0tZІ#fwMQ 1ZYl}|f4U:`&c~~?.30G\"ipN+2eKcۯ	4I2<‵`iz y}fWmhGmM]H\ru:4̩i7[GDE	Ac$o7\\QF%6+E{#I\\ޑa/jqŦX쳙r/a4v)w}U+谆{3⥾ϵ瑉N)]W1+Z9`||mf:F%-/ąEHPxBx\0[lf&.dkHEm-d7Sk%0u. :If	ڦ%5@Q85ʂ1-5R-2\"Zh@O&5V69ڽbr9pfuLe#V(oVͱw&KYžJw_{S9{F.ymn*$\\lG*EM\nl׭m[-B8YٺdJ6S.V594*fH	r*\0Y㱿;+h<RV_u&R:v\0}\nw3puY}e	LGl:Mu/B7ELjoDtsoyo!dKF?Ėh <^r>1u_U0?<Ģbbܙ	Ggia@{ {)8~p[#ʁQM+[I$&󺳴g;\n=/?Ilbi8AHxV5A?vi3I2*,b@vJ6adVBZLC;wxY^-сo/@87?!c^H\01Jgnk_dN[%Q`|!(c21F=\r\"8d0{0ZS3ڢ;!ٺOh=rRgV/>3	vj\r|\")\"5SR\0{k{6@F\ZC;:\"P@=W>53\0$E*Iz3^MP4FlwRCH1\0H\rgf^Hq*v6Mg2IYg_,\ZI.&;ӾrL},\ZLRd?{3EQL;jXLV<SgU|4E+5C828ҝb2am|*L=EhdX_˜&h6_?q|,}d_ӊDEf/pipEf9(k$ᨕߧ\'K066jo\'?_8ۗ0]$47F\ZA#[RAr57{07f=9GcNyΟor|.2K_Ôx##f@#|A\ZU\0jJΆPM6.\n?|إƁ\0xYy8 ~oΥTXJ)*aL#Vŷ~0_QcQRw^~0u8gV42B2,uʕn}~҂Z-なTy@}ɠ	OH`Siubh`GS\"Ŝ(Gu\Z	sEP|㞅iwγ#oS,92\0cL@FHsM\rc\Z\Z^G-VAd36	>ӯ\Zz?<^޺%8\"yٱOlB=VGh!K<6Yl.\n1,\'JңpDT\n\\ŁrPKnCI9ƿqEY=Uk0ӧnM][s;׸\';\'=Z8{DbJ8S#tG;JMfPԊ;5BO6PV&\ZOy`2BDͷ\'l/aYeHaّ>v-Jq;(5nOjnYZ5qPܠ4o	\Z }&\"]+1Zcfڎ[4H@&UqB#+SdotJ<$BI䴪u:\"cjVl{tYjZ`S	 |DzgzBtWnW&c\'J@{Trq	Ƶ(ͭrBa54oQX\'Mh;|\0Ra\"B@CRo*kJ+0}VLf6	ӆ`lI*H3La5Lj\0mn\'j};Q{\"TioK߈S#6<Y]Ȱ)Cz`:\\Nߍxa#.?6G}hoB %L@ĥbu(FHP\\ȯC9!cnN*NJg}Yv7Oh%.\"AX*U[ڥ)6Ky_LenLm=~A4nj\Z6^\'Z.A5#\ro#E\"\\=qnKm>.+LW58N8tcuwxă;01-u[𤧤a_ 7hP\Zvܪ\Z@fF66)\0c/5ldeR׫HZVh`YNk`ɵf$q|#ֆwbYqU*3̨ @.|sTup#ωncAx9*̟/xx}y5t\ZK7|V`&=0ziuIbinYR#Q(*Å\\Wí&c׬b	A.OÚ7br$D1߁䬇()x&^nB3.xJc䯂:roO\'7x9)yj;st\'=Kw:*~XI\'>JFW}#B$J)?wk6(.Tv̯1?dRڣB>JmўO$ǡH5Nb7ٳUw*)h	+ڞ\nɨDV\'KD$Rq0||M߬6tӔ:S\"h׽Gּ?\n)QNkU4JM\\V^1urYޥ1mwt&Cr\'BMFu\Zx/D9zHOD3ܹU溻]3Q/\0q{x}28\\und)ٍ~&U>+TKF(,`:7Qp˩JO!\0^L*<jv|aǱ-FZQTƷn\r{\\[o|Ke``\\5)!%`vAH\0eq$WDjK+{jPuυ~\r|FSa(J}ȟA\r/.Wl/ule~nGEv@h@OcS<I!rbK.j*TDD?հ{=iteRXSFoFQ!6,ᰝ&:Ek-hpyB\r&JT=dj9)\"1=RIC<G.xbF5$Q:/M0ܩ!L(\"`xf1QJ	1Pxzuѷ;gtS7Gn+Q1rgQ yg5.hfhm;k W8ˉnt<_(ZFViҨJ\0AB)mBƲ \'NLPO?AMAbyMϐ;(uj?]$C&eJ+n@{@.\"#`|\n}JHAshvPf\'B2lONL}ܽV!V)\'khS-OtšoL\'7oB_ǂuJW}߿MV `芷L+QQO}#P5s/SZc.r %}5-/-RWEٺǎδUmUV\rOzW-\0unٲ@Tg\n`Z%,zfw#nؔ50D*/rxP]3z\Z싿xtI\"F?.^\'T\"##\\L+&]ҮvhEovb=-.XTYnPb+j?l)$pSRl8o鼭bg\'li,lxu^Oql?úgb =#\0M)B\\ep&kgqp tmOüJ\0cw}QԭFr?\"qɞeK!W~.t\0S0+(,`Y:!obhKO=M<atj0\"5CAwwKHY\"0d~k:\nYïy.5 <pI_ *W-bS_<5嗞fO5E_k&ܥ>A5ގm>z~8!Aپ^TA;`3N %hԺaM~Rp_jS5g6G bЃUG#aYeDooP?DO%ڵN:(ҫ<:(&3hxU!,K{ZӌUJk#HT]^U\0Tj崠&Y|s<BJ	(zڪ\ną[ƷGֱ!IzA4N:ӊU	[y-)5廵\0Ӂ733\Z,r/s	ʐv[Ns+jg,)wZDUvR>k<vd]\\eJdڒN{0vYʖWG½,jk:B_Ba\rc;pvgm-,&+aɭgW!1\r%B\0/\"k\0H>\0T!s]ݷ_\"TP].힭j8\\3c\Z^@i# UcjHq.!۴	^U\rsK`Gr|3^렍4ӗ6:7z[\'S1ILx&z\\LKcu[;m幡F}I-6n$[Si^Xu\Z^ȇ6YYp1$\n92%V0D2`qT&%q5y\nVڌHt:<k% (1.a]_F.41Tm-XxE_~Ne|P?n\Z0e5,q@u%rR97ĩ5b#pIueIt9]\05^\"$ْMhm6:WCtN`=9E]=s\'aHV\r,8{ygH;Hnp@\Z!cxNdiGeAI@\'iۤz\Z.| ؤ(=16ƚMϸ-\nGk*bTJ-2<8Ko|nF&Q It-Z\r˅HF wb9ѿ\ZxRc6wc쑐?XߵD>\"|?FH<I0{eQD {~aK\\-B\ZS>X2ÈHԳH+fq\rXTwUZcF`Y[aZ](5z!UN[a9{jB0P`jsUϚN?\Zbi%ܴE^g2z,@QVoUKjaWś\'yYz4v\\\r̍Tgv|{/}5%s|\nP }\'|NYF=={d{hl\'Օd`\'H!F\nݼiN!0핕KڥTJځs 2&Fwp!\r_I\rަ,/,Vɩӄ%昻iw66Iz?1]f$` R\".FRDy\nV>{1E ƨz<PBղ`C/-=]\"_曗>@-=	g_棑<;$~:mvfXs.P/{-SP+fQp87i!*IGo}=)8L*fqC|/#pf0lsHx\0$ޞK,80/Sё}l:XbSȣ7\Z,[xR,<X6Kk	oyAw)}\\C	\n=JX!\\U˝|#6{\r\0Չ{o׶gbUh6XE.Run5jO\06\ntu=5Q%Ǜ|߂YM\\Jabj#*l\"dV5mp^ݛ$NC\r71Wu>Qfg$5G`^Ġuv;6Զ\'|\rĕ%VTjbGarU~\ZoZ\"Tɷ\rM +	`gOlC; ǰibqGU@O\"ɬ:l}s1iJoZ3w/at{&Oc&J]k_*3MN84Ȉm\rCT5CvJ2uU%Y^k[`:hilm+k\ZZ D<ަ-	h~tΔ`KSàc(FӲfi9Mm6aK5Ȕ4\\4MY^exM~ƟXbr](GP\rS](\ZArtZ$10\\ʡ*)t1@1\0וKW\0-4O2,t[]?Y9q{VE@)0d,R8-cu	3jF?\\piEE,8)Tn,qM9 Ĥ?ؓ0Z5>HSFzȲMRW3\\\rq1?XEGDfLSq`	ٷc!>|]-mwOM㟁	_vn{0a\0TY{/5\'q,sPWMQ~@ů×͔瀿zM4\r;D_D-!<8Z%¢炿E$>96g\0È];l\0l*\r\n%E\'tF䝆煶\Zf=?;[%j{jMa7牵T&~34	H8$d {!d 895p(\n±vJJ|5:Jhroثl]FA1_\n!痰fWeJSZwkXڱӍ~\n}@=\\YYC]ǢYZ>qX[p\ndS3Wδ5cZ\rlY-cWo6\n(ƞ[#i[5Жг4\02m&h`q\n\")\nSe]~&^vw笤4ѣ¥1RD{؃6BM A[\"Xr\n+3 =3)N7翞!o-R_ű<Qڪåd#EQT$nT*Kz:e:Ŝv|چ`z`I{zC9]W9Ջʸoz=pr7K3ʲ\'oDf{pϤ?3\nΈfwQά49E\Z\'x$񯏓ѡ.+rm؀=M:/ۦMiF,IYGj|N-ځGU0):+r`Ǹʥ0F\"؋nGo$WWAaOPBo#>p)\0$\'\'ߠbQgD@<4(n\"NZlg@vPiЃ$]]F]v\Z[/B=`zzY`]3)]:a>?oez:G႕GL=#Jn<:H\0H\n({S=gkyo?xShIcU9X<FfjT\'hچD8Շ|BD137`%qY2ʌ?ǽͷ]y\nI\\d0MUps4(Gq~8?1	`F1~>\'ţ遢\n<Yz\'jX`frQ\Zȿ4MF/-fr:CK\nNB\nu\'r\0~DC:{`I8]PY5Hgb:<xݢXM~9s^ys(KPEʇ,s\Zi(6貿!gъk8##SƦ=-ȪM^F`VQi\rkx-?#(᫤7ohus;jٛ+bQ3lIDFGmk,+Yy.2\rt*q7,j_HdQPY@-dxj)dmx́߻?.EĖс+PDTx\n*-J6QWS\0_ WMGa^Y.@9ݱ|X!l%1+w$5H3J̽qp7fuC##MAJck!ԛHFfK\ZR$HLw%7Mȴx  >?\\RɪJR$&wR\'*Tvj^!с\n{X(@:y,}r<HmYN~Ue,W%9bb*w?\'HȜdº˱勭wQ~&x\nX\rQ/8Ҹ=Vd~o;cYly6/.$>n8orF4-膟.qyģu*;5PڵHO7S莸^6?\"tfB=˰	菏E/=]X^Wp,^_Ib8C~\"F>@a{aKմrz\r[FV,.>k\"o{H[B5llZY\n~P.x꜃ Nî(gF\"GbƩ4pV|@ZO\r<_ī<ݬв̰jsqp0fjXK$mb5e%fwYUwn~i;V%TF~e|,|6D߶	\0ނPsY*<zS?CI1OT\npݚ*>ThJ\Z/&BzFR\na*!_^貿r`Hab03t;K]-\r5CM@\'e\"@\ne\r\Z	-_[&ow@Ya_^f^(\rO>踭,\\q󴛤X`AbG3[]S\n\0 @r\n\0*#h0*v%)t[H>|빛AtMҒn䠦cirfoz1B+r*Llf<w!~{,fhz:ycj?%C:~qնSo1%ٴTS\rبz_39>b_9ưzEDR[\Zʍ\' ]r>< *0V\04~tUHGLV(.V.6@CI+KK7\Z >L\remoRօd?t7\"@\Z,_lK`ڇ.RSQ\'V6<;i=x9ϲ	R\rYoúxz_T\\\0xK!G5[T4GzݹoɓHL4` (;Gc_E>@[)$=AL	CMpdM&zTz!@I\ZgLQ磺1Zktx*5Ii44O~㯯3ZOtkϯmaBn]F\"Y<	EBKiI q*lmKңk\"MQ?pa؂4{8@-mY&8ϩq\\T5|\0RۓjT0ɈN\Z%>knAyUZH\\ۉM|\"޳QY}:鄳~㾥ݐnn\'-҉V>酹X@6q.辳*a_鈢ڛr],?i(R;}>銿6=\0A/z#9S5*,ӽ\rگxZE92ޤO陊CYV~EV2(zI4>ѤQV!yvpc̒P`-e9rJK\'t>;E@m\'@&,bVYw(M6髥ħgZCJo*^SB\'}cZ>	Md%/;ϮfWɰ1NJRiBOӬBV8X5b0\nF6\'1iAe~u9}9ZHb!(-k ) hpC%Z}=s<۔[Z#g *ڕPKz5~N},po:\Z;1\ZE?Ic_c#ňM_\0iFWu,7*ܟ&,hvn\n-[\"nE*9p:cZT\\:_*zt*{	9l!~QЎܰI[k0\\FNB|tC۵ً1w}<F˧7(MW^iP\"0i}IhX::O\nE`	SΝ43mgSlD>J\'8:?\\$NtDAgE5tg\nϋ`><#%B\'4b&#`Q\n.	.E@ю.%Eg@L<(_9\'cö]tl +m_ RHA U5;O}ZmC)BX&|m/=J9(Jhn2Anh@yĲͫn@\ZrT$\"xq6Wnk+s6Y!=N3>g|S(FjǕ\n;e?1o]3\'#.GHX4PievWsoڋLQBWbexAj,prkjVi~)f:$/Ճ9$ƧȏkꆕKIwY\";S)A;h!z})\'72y?)T2T\'6<P4nk?\\˅enPt]A\"3#q Ɔ\Z)+l\0#<9\"ϕAvhzJ>AqW&zUV\nW8 `\0ayxHõנc^d_;f**Քڋ{\rM{4ו	Y`(0hS1i1Lo>%QBͬ/`ʗn~.m*E৐h\\q5GiR7\\P6PyWέԽnc^=O%;MK*<fwkzE7%́\0<ȍ?-)fzSHΏͿͰ9O8^^]t*f%YE@Va+vi^RwL.E\0Jgމ,iK4sF&ӯxN}3(#Wq:fSꏪ̂T.mىY:#w`_5<`Whj0g_MTJ\npc[_:E(.)&$*~(gf9}!\'m@{y 4[힀/}%U\nZ/ne~,\'4Ek\"1\r$z#kw.Pт3]Ǎ\"8FJiƗ{\r;c\0̢ce:Hb>R@\'=vYkSK$\"=xlgG2aSvQn*^+7\rYf\rR12bc\",5\ZEf	{\\R@5)y&֫\r;&VH|	-*<W8ax؛ƿػ5|V{׾A\rreAFzK`[Wbgۈ%9ٰk(G\"&`z\'fD}ږj\ZЈƂ\"?EzcRz͞.V~!$H$<OwYIT*{jDՋ,EEcT*52gTC׎.xyH<wOy_}Ϣg}O$0ǵƄJnr++(Nwvh^X6pB\'T}ge{./L[	6k8W\'|ǘrfH	/A.ya餷#c^SA_7\'hcv]#\':zFkcMFjXvM 챤Iʌ?(5]]FrA~{tJ?Kl?Yk2W>-MPN`g?\\\n\rK\0J<ǘ3bxT:W*r-6fpxc,hoNI[\\`nB7$·#t\"Sm-C`ɊsE#)(A[h\'gvﴈEˇf*tHmLJ	rehgm?oDGX$)\".AװStqAVIB₏.;\0s`jM||ԄK\"\'kBXcϊVDss|kaOIh9A\08(?K\n͠~ ]#tvg;s@|NYud>m&ԅ\rT.% }ZNtaZf+Ǡ\nKb됤oϙ,/ɞq?sCvF뒛r|Oq>\Z.^	J14ϳ4/M(T@3n8=T⪚^Wg랊=8\"hT\rV2:AO\\FFX6:<װSȳ\rWH]T)!=\0!en81\"P&8X;U^LDL94ݬJ݃ClE<aǈl.ēz]\n\Z:zs\0nĽM4|	h3g}hp,F!D>˰D*zK:?MiF(E`@$wn8\',54,;{Uxk,>e[7NJtt@`2Z\'SV\"*XAvkOxޡmdFFÅf3]ل5G`nb,ݣa+6)rb4ʲg}SxvֻaʩD\05SS-*^Ӆ\\wJVҟϏ`*kCckjqZY@qD^áWWZmIQ9LxeD6֤4\n}#9	;M		ꅱ/Y6_wpkw0%`0vl\r\n?4ɿdpY0	ȕ%o%J\nҧesiG\rE=KIy!Yv*\\_>r֍On_4`/-\'aYI|6T%4fݍ\nu4њp~xq¡#U|\n`6`Z4\n\"l\'U8ykSlصAf1~}x	@jawKwGJ`I~J\Z3sS$9g(GL8!<zKriImVe(iCx/?OEqi7A:3\r:>>~</E1.	?[A],H\"x7=~\022?2=,+)̻ng3(Cl5viSN9WȜEqDa!_y	QVGK҂sv@E\nF		M%{a`,G1$qZg朾#a.=\nl{TN\0}AvA$=08QjV\\P[pHaF~yQˊr[JKǺn3`,\0d,m`\Z98Ra>rZ!e%duH/l+ޠ.I6(mx	>aY#Z&Mp;xROv/:\Z&i%?wA5<bwX\nʱ\0%f{싹=>dz0\rHoH/RVMΤgY&9R@N;>SA|쒑n CN\':0zf\\$7\\웎yRj\nMx\r.s΂&졪\"z>/W˪ص -rڵvMo!In6_ga8y].^5Pn>:,GIzR쮝yY#ǳE	92vnjs,_Y{\Zk]ٛzJ^z|N\0a69A1N%+YjSF%~~P\'lX{~>}{M9l+:A}00.@L z\\ )\'<:SV;d>t/\'\0T1LvkN2\ZDJbDm+szȪsvl03l囔\\HiܵxfLl#@Ťe+!yu{a]Q$}\rYudXELlX*8H$X^?Dx׹=So\nhѱً!J~ẞǡɹn.5H)~1\ZE̊Ὑg\ryuCx;P{kyM#h.?t#ɠ\"z)`hz9R:8G{Se! eae:˪SCQ9(X؟HgPĚ$mѭbzr	S,-6;!X,s<Z:Й\'S3R	~:+?o㱩ۘKk7<-r2/\ZQ&Vo\'*fxD۶lC\\:r1l{RI+_#ap[o|\':@A} E3WIkk0y.9ivFv2պ26\'\"\ZɧV:NmwG3LsK[8D\rA՚R|yI<3[CCw饬2,)w_DʉԶ͂6j40FSc\"~G8<\':M6/U9)mۄ({V3R#/.pBց\')r@OWT>S0\0;QO%$K	\'͕{)_ĝ#/q&O[O\"²,l?2j&*\'Wj8*DE.\'Lpϭm4Q,k$t3?iYϲYڷO,PePCkA\nSuN\Zo_Տȱ(5]I{ٚXLl#,\n<{v\r󽳲,gGmo<o=:P}\\Jfq,=DMuEQ[csFf[СDR.1;5WDMߟS\Z\"lH̳1C\0]}gO(!,4H5oD*ru-{{	3j\nWMbXzp)\'F{Pniq9XY}KT(srmȈ6b%(/\"EZiE^dJ\0pD80	Ͱ߅ \0B^]ϋS\'/bQ^DtBΉio̳l5y9Mb&iKues<%qѬ6IF_\'Q73#5XNxL+֖}	gTj,)0f;7p>y|7|17̣T:oFbmz74|X1#{/Yio(Dy(-s\'#֛XމΆ>MjᄬTɄ^:1h&urC\Z풏9Fܐ𱐠dְH]@ePaI?E;wX}GW0gGmKҵ~W}u}vm7=EKY4yŝ&)ԧ0x)/mۅrUz6ُwMbRo[sERny.>ڨmQF{7@D&[j}wREv3ׯ=,4ٚS3C?}lEx\\\ZbVW\Z/:U[T<4{AG5Fi	y*dq]OX=xsՂ\'ydQn\Z	I5@7ܓ1apcnZTȴ_r3KܞW[B\rDݬvp#346>kc*O궓Rd%wob@Fj\Z\n)	|>j*욬e3p]L}`/\"ƗJUFp9x>k眫A̾4\\`DX1عWJ]cƈf	uJ0fj\0ցsZR~]**M7+cGAP%Shs\"rdS2!{֣:=Nzg&$F,lK급/Í9zÜu\Z\"dm(qV{y{/9]Fy ɲ\"S\0)e-=%k\ZOV\"5*\ZX͹[I|4r_xS*t^&/\\$r\\`ʳa7%eűCS6ǀh2.^WwHî4n~2p{wq\Z.(WaH1p\Z~Z?Ql0\r&tE_)[\rs%cGblAiRՔ/pu[\'/WX.bJPTjf(h\' vfGE\"*,	 |m`C/\r~/#b\ZM͆]؍iw:jU/t#L\"utPw\"xu}z3ܖⵕzjv\r&lݷSkgLx|(.ayѫu#\ZڄeuuI;o,1{[rѸ5b,B2+YGHQMp+i2vCm*iQLCH8RvJjo޼f2RFt	{[O5R¸_q	6pOņǶG=6b4?fs^Y\0^T!`xC!}!$J|~A&ثT>g-8RܨޤR86S9Vs܏TOԐ:&fl Evlٕ.%CF,x,ֶ^~qXiKFd$Agex8AU06$҃o	{<\r{~%mp2X[j_aGv@2b\\ɣ IY/dx19/E*\n|Dh@oJ5M0ؠZ1j\r:TF(utH$D*R5wPi\0~*JjT\Zw?/cg)e_\n^}=J_4\r|GȣJ@%0W--]\"\0\0\"C\ZHu`AE@ov-fҢ!~Z~&qN7 Z-r$E\'50h$i&A[qeb-DpUL3ӒңKKW5HUCaB4B\Z3b\nNyoHNmQvaN/	Y!v46]3]3<ڗ\"v8^8G\nUop|a0*Ar.*!:\r{ڗNn9<*=t󅡢pEKL[Mrx%\0F0OʸʪT3x\0Ggpx2H:@MI٠p߼\0@LhHs[lq 5\r(@/<8muQO|P\'D~fu,ͿPGGnX\r_l5~QZ7جaNZ=x7dQ*e	ɯ~bPtf+<,#U^HqdtKT?Po2ҾPuA_*}~\'K9;4p\n+=UO}6Ԋ|}<yV1vKQ\rޮ$/u(muJs26PXhy&8<=LSSuh8V5h׆10%a5b N\'ﭼ։Khxޫ(R1=~Pw)zG].?7z<WeO+UY9Y$\"1^?lGidMºT+In\r{M_໘`3x8h=\nҟ`;$rKkyo\n%Ig\rөr8`7AD/\ra\"1\">xk7:$_\0 㽼\"j4[-0fWMpkSc4L#\\rԹF \"$qc@\nzkFz_Q髅ۉhKX\0VY CKnAO] `oCK^ln1Nd0\nquy`	.U8uiH<pShZذ/\';8x*9_O[Ş,~ S2l\r.O}9fPko2,=A}P˖X+уyY/XXꄦ-U幝ܒI	ĥqQSqOXڟlF}OeS>K*F1+T#\r5k,PD+>J5딧n%29;*9^Ha0V\"OvNz=ώ\'0 +i)|d\Z%]bL0˄.\0URqk\'i_i,\nG+L.\rQ\0%\'ym_#?1.$V.dj1;߬,7)ǵ70swUJ/cILax6oi5E1\0² 75mw>Z2Q2K=^N^\Z|\\2_D9tr[Njِfg4vnܒB{:r>|4)anĊQ5OSf^ToɵqQ\nIS}V#N7=ɷ5r05ʻ!۷譛dN\"Uc,@jq @{a0J5\0fDyYT!-;+ۤKYMzgD>h]3\n0_эWg1*VFIPxfvL@pR_1W\"dg/\n\\vd>IW[\":M)2_YKNK%[xn!R;KR[:[*w(1 yAfW \\4?f?Q	Q:xĺￂ+Ќ11]5\rbbEÆRG5$9bJR[LWٷO3E}{Yz#@XaͰ]()ck!~s~hq0X?8̅Hi,+x͵SE9r=#_~\\/Sͻ(YC/#/D$ߔnJXI17k&4o\"S1Vxa85F3^>6\\V6 Ei*X,/6}\"͊%LJ~*\Z^@ҳh>PMߔƁOd,}%]v	\ZY<}]s\"\'&Vd&u| L$8c4=}Xj(	;wgָ,\\R oj!3}YxwbpalCϨ4\"rT4_u{=7V	Yg$:+noe}\rF8Uk\0,i3?.P`MFKVBqYX}.HJq[9w!\0|bnQ\'iM^^xkg5su]<ĉB(ImIo;ڻGvTFT鴸s$\nllYy[w5q\'s{9a\0Iv\\VmN(ט3\'|.k\Zsn/䑛Xf~Xr[0$koA{2#am\'Y#O(&\r\n0{z7j{K.(\Z\0<!rv+=8U\n)TC	\'9s!2|5/iVV#VA`4ډ3z\ZrK,IޗOexџi}.ǪVڏ!MdE.,nHkQ_39y\nb-5c,Rdd^#QҒ\Z#q^ƓJw՜L\nnKto5(k{\\ؙ@Fb&[$+%\'o3\'r.]9cxߚY9\\~{\r>ۭ,EYBBIғKPӟ]VpŠI*}mo~v/ocdFe?#V<cfǶhj}upIXpھΩTW\"f#1EtbjZYRh0}#*gI20hxD4)\\dw} w\0G>(,93_;G_1Mˣߦm@Ї> cg;NOqH>v6ԽƭSyCxVn{JHsLJ}FMfPC\'Vۨ/H_n{FW?^ծV CnEeXցvK%}FG|bZE@R蓉yd(3HSgU9G&KGWWSe[lNjN	-js\Zjh߽CșIEQzWiIF=B)Y	&6	4/@:>NbUa9e׽RX?楐1ih\ZҕXT9Eߎiц	k!PBxQA.Tۄ๠ێqvo<YXƔ\Z]6(Œl19J\nLv&=GVkr2C5m~q~wB;\\q\\8N!-X!\n{9\0΍J#6a/,n5ո<5k=7+ygЪ -j/\r\"]?\Z;rfXᅸeXtŪ.+[咩H{v./s|UZAh$DUs~;M3Hn\0{z_;R(I{\'\01rkDXmWMKtV8Ɗi88m(^6Qxx{M(UP1,W*r<ntJZT\nUo\0RÂ=XǵX.CQchdc\0Mȴ\Zׂ?}ac#kQbm(({ia^\\vJ.ۂ+d~ |D``wK=iUXӛFODed\'[r!kW)vl3b/5䩾!@	nK^$NVjqNn\rXvద֧7jHnU\Zr`JBZޅJX0u9>!v1dEdTsx`{ӯ&c-Qu![W\nDX\0.6\\HxTq{>gwVо2\'6vą>Ш&D6X]`=s\01y5z4O|pA5P%Mu#g]zmܦ8u(fy2Э9exkzB46)$\Zdfp~Mjp}/W.MMOdXnu͝UXo	g3\"Xv{jG8Z<M<6HͱE\Zm5`NPO;0Ϩl kP@Ef/Sy9NY=2gN\0 |G6RVM\0xB[wHy/=u4_c	ο\'M|4N\"d	\0B7oa]O\"U__(\0T+Q>)m\n+Y76\ZN`xԞqÀsƝ}=D}[vy&զZxRpV.j4O=66]B{ 4$-Q\nlOշ	JaO`^<!eV-\r7LtBR`rژgE;+\\)Hq{@dX{a2H=oL޻]=FO=ٝStկɯKs3s=#q˞< I\'r&ulMK6.*;VBKˠOG6Cm:|!%p8Ug𿌫QD3gU`s^ȣG[Mѱ9rgjŕDP[r(Os/IإvANyqoʅ#&]#mVەrȹesKY3j2({\Z-7\r]8Kx,V7[{\n{etc4gL=6mzQhZC`s=oU+0S\n?W7cz	 TαiߠPom\\D5~!󬐁B(?]ND݄~oa[ceU>Tø~3$:󲞾MhM+Q˕1Ыgc! L\nv\r?v}}\" 0*|;Z0J776WHGY3kPRWz3V.&QVs4)QP\"Rt.ЗeW_6|T->{rC\n=kRdj6T\'\'9 V\"\'2]yTaC*Ata\'X%=B-Ep~\'u)>eH}Olwk3H_cxNpnx{V@C-t\\5;l7s)w$Y?	=1~$EM\rKЂ9!L·NdggQx>pBĺ﵂Ƅ^;Q!@#AĒY}3*&?eb,B?sf!D.SJ/xknZ~q6Lꂨ$?{II%&V(Aw<䩻c$a=!3CPY.c%0b?O%APp/.p;J>)Mퟴ[%>xd]?Z񴝞1-U;olVY O	/Kmf+D\n5q)9W/`kWV*_i_\'hMaCQW~K0X~D<>5O!	U\'IaӴ9+6fF7r,?OLr1A͵$EFS&GksP<sY6O#lA-\'GMP\Zr(gau;YR>v\\?skUT !qNwE8W\\ ~mV|ݐ\0!ٖX6_KGqiʰ#2?\'u>iav/%1UEd_w\'ޢKGs*<vgKu<gZ*1iΞMDdey cwԪ̀R^\0!<fn\ZihFWcaonx#O*1yu.SA`\n	tp\'\\ˑ+&􄷠iR	EVPDhq2ó!k G#\'`&fB!3`*u4c	\Z{\r@l(2uJ㰿m\\<zGX	F<\'!#-Ln@A!@fg!ڗɪeTKrjeUt-VJˀzا`*#jxZ&\Z{C\rB]Y#<\0!_M~(k_MWFi]Qqn43ɨ*+ނh)}֫Ų3pv`r9H(cWޏK\"$Gϭ\'6I\"Vɜ=0\Zh݆֭<e1L!ӳ\ZDKi@*SĘRg	rz2,oQaPAI@@z$Z)k@\\E>\ZxϕFUlt*gV☲ù۬BjLNhZe%D\'G}w2#nI\\beܻ\'ݢD{,k,z\"\'HW5Je@R/kKraZP  <qa2{̀S(SoӄQ)L r$ؑATZR%nfTX^CfdUƬ\\fHvNEʥYRSTS=Q56h(B9US,kIwOJsIIwd4\"醗0_h^1DHl*Z /Cmp\0]ǫXPP&Jdx-cjHtfݬ?D)\'hcF,ՙ;&,U3R(u:_x#Xɡ;D2GYQ%\'@H}|=.˰%)HB4V̎^\0CQ0Jv38\nQfY2%Lm)gӿcsM+=VB*4|iQlpt>%y1PbB5p=տV\Z_xFR/MC1Xr[pq9D/(Vscq\"c!nX@$MXXP2(m{0->O{93_R[B}\n[;	I2qU>[3x>	CMp&Gsaj@}~1QMuC@\nF	n)̈́IxVV$Z=qUOcnZASky8,?v%y\0f\"+-PZ\n)7k\n=snWyC8Q~C\"	;kRr{vx(DJ*qb\\Q3ѣ	z\\jg\n4\r\'R28F(>F2 QKLY6j.*Y/:V760w8([oWK4d\"Qj6h\'Vh~Ad7DcA\ZHzyIQ]oH\\y6-︫ḍAi3d(ދ@\03:[vi/eb0Bfk	jV]\"zha	hu.D{.%<DNNM^^/jC9tbp)AvEA[;g`dmHM Pw_%Ke>,劃\0@-(3onjnqL^W\'G2Ըgw<#FX&l^B9}Fsn[pb	`5qS7Xb3qC>Axq6 .EG\"\'K\r<!!dep\Z	0mz%`.۾H,x18q?L}]U^9p&`nM{ nL\ZN:J0L2\"L⯜t2f\ZZ,%tU,\r8窠rQF%>:1WRͩQi~^G\'٢%HJX䢁`x6J&,\\LM!vѬѠ\rN?_p$р~#03?ek	ax7+A\r	E1D`64Ġ_W|qBǮ+ɮ:7p/+\Zz:MKpo*ANy9MbL,\r,N@cmdiynS/lLumlG*DUTڌ̄ʟ[wTy61?\"pL,V{;$ҙPn6;伢PB\\/b \'>7d(-8.QMygGrw&3ؼxvJA7 ysvo_jH*BWY$6`vr`G̃S$ 2|>YwMW[ I/H-j\r%Dy`\n\'urrOZqO+P4g.{^W/![qu6{\\BęL4\rLzT &gɖ\r.:)Q7ݣ hbO\'?Խ@=|Adj>׭N,t,\0Ѓ\"cO-\"bY(VW|/5[rɷ*MlrnzWm:fO&y(H!Uc%rT.qx=\0`vG2ݧYzUCIF\"I8c_;k6RrE?{dG_A7c0+^Eh1{6bRxG]3Jh0y &`n;R=hڨ)-9U,%k1X\r LcN;<K{*kLE,t*J.	*歁\\5c%aPTgxȻ~+UiM!x<8~G)\rCZO8@;6fU4ƭ{J<#m~S2^5z=|@ ԃ\\HVq2v5o,\04`<J99\"j\'UI$N|5f#RM{o0eGeԺ)8X7IѴE90.BAe4>]ySPk=9ifCu	l6E#Zt,#<\ZL4Z>\nM2\\lYߌhfXFU!}\\֊_ȕo/B\\!Gg}\ŹxAplH4HM&ɥ|;J%4㬘fVVk=euxWRM]Nڊƕe\n}*\0x#@_cs<Z<&^SV?RÊ]	s\nx$	\Z~Jivoځ Df&ȣWBmʈ݀);Egi\nۃ-!7\rd>f83c(q9\Z)U@qZ\Z7BI8)}~y	ªRHZiblmu1]E^Z_|l\"	qqѰɧӿlpK9 ^/t4,Mv7j^_9<΁4Qu SpnIk/Hh(_+8pkVc+.טw+*㹕Sh>7w\'FKͮ6RԤz8\\4wcysM)9@2.]Xcz>)S=\'PPZ-Y^V/Bc5a\rRIG>?y;+\'SAED>qqa_؈K)APv)\'-f7Z `tP6ö.sFRpAT.,EHQLv\nNO_1f(̯tbjA,7q>d\'@@x°E]|. Aj\ZM0ǥ\0Pu&WA2-[ 3]S.\\0ה7_	U5MX|Leu.39B*\"ߝ	zIaTe	l:\"xo\ZOH1:cϛ\n[B/\njz\'aFL\ZH-L	`$p1/>:rVǙ=={OrJ3mZ2:d\\6_Շc*4RxgJ9G0>zc&IÆb4~*LQRkg!ifnb.*η$gwT#;?`?;\"AY|X;uTqO)Z|y)qJX<5c]#M`Ziu?_Yddaw?oabN$gI+R.e\Zptᣈ:\Z`\'8y`gy&Ķ%lҧ&u<({(O%:Ep/kAϻžNE(n\"E\nt%IMA?«P,]#Kd]p,|[\'Q|.{DZpܔ-<Gș;fc\"0\';aA\"&MT\0%}:ǈahb\ZX iv74ͨl[>{!e	XZIRT5\'_f	B)AdOOM)Wg@\0i9\n?g{gs	gOXI#n!F#Yȼv\"|:ݯCG#\nYE[Vw+Uf;P\0oY.i%-%F\0[n1Sa+]g\"VO<1p~);?hz<Jzaș6}hϴa[V[YؕWl:績\'?<\n(Xܰ6v;R<+AKٿ<Qܨ<BE2sŎ)?ԟB	*ZOےn+z`ߗ]^$dgGfNz=@~c[oƇXomG8@~n?	x*ՑxkS략9URݼ\"EI {`z$\0ˡ>-\"D|5 ,}	a쨀qZ6hֲCR=8Hΐ<>yy= ؃Gө&0*u\0u\r+M\nMƿ4fLxWS\r(LWn?,/z\0KwlQ2\\Nr\nrBs~fa_MG%2q0/ғ:;eWG^M	:<qF_\Zqcf\Zb=\nG*QDdH?vMʈP,KA]H%AQ62Z)Y\n5n\Z7DP$	8F\\\'Ap0}ɮ\';5Ϋ<gNMgJ\"~dxȈ޸<!B|$k݈# ei%0?8@0pwywjD۞V蚹xRBBy%hWvǶm}nG>pѹW5wOE̾mG. Ճg?rТjs$_D&֗H᝭s%vx-#?	H\n,!Cӛ/S?@\\nF5Mz\rY{T\rS표^BMT5)\\Np[>&]:.ѥׇ4U_r2ӫ/ڽxC6yFsoQg t_&\\Uص`I-5􇲫S\'hnlhʫjF**\ZWnfrP#3mdnnunpU0 l6ZiRw֢$¡桘3D\\[I~7s)<5hOTM&>m2X^a&˩\'\rVUG8 v{)L&x~@}7@*YG;s>_I9Q}u\\$pqE!wwD=O$l\ZI9<0ox>kB@}iﶧp8.U3dIL1\Z?f]t2Ј5	7\"du,IERl\\Ix$S(]4PcUv᢭(co:\rkʪ7eL߸9@zpT\n΃,\"w,L Rj\0)Mö́ɯTνڐ$_SЊ|ΖG|l*oDZz+Td|[yaTK|nD~v-;&W0KF8&$G8hr!w;7\"L~ޅLE`!)lʛhLףZ[9G%3[ҚO/̩3z4ΚC:Ufz^^Gn/pR1C̬202J΍<:_B!s*l6\"Q_ȹ2a7<\\U}\"As?C9`r0É\01yiN7,N]8ϪC,01Sͭ-abpYx{VcolNGqlkba^>VVchKb<3{3Jt\r\0f-8_!ӃtOLfWO_YN>øU69$8XFCP-\n:=QQ^0ñԟyb@Y(J5}׸dt`Mur:_,u\'}]R`HƂUz[w\\=ʼ\0[\nKix-b>\Z``\n&OmGeP<g%p(B:SQ)CQ}y3ˎLu,EdҔ\nN-\09pM0+~06Z&<ѡw.e@NC\0=/6!1oAuEoFw9\n4\0\\%wM\rg7\\%G8%*\'\'2?BDExel?4:6r½c	h{M\\J,k\r??\n!B5;1P:#XBG=VC,Plu(+{ҏaqG NO,y8;rT:^4Um>\n(<Ke#pjm=N+Ar	);FO\Z/ކf?xȃ9\rQP@\r\ZROJSgBowjUb%x峑Rڋno\rM}.!y8ؙU/Sz\nEOwF.P)n><WS)_]Ya\'kY_otr)CEIm/;ggŭƱ0`8^\\Ƌ~hc۝sZ2 Wy*	@5iD0d?ϛLrC9m&o}\\/sQ~y~uԟwan<p$	[2e%jUM*.=ԍ:ckuYKV;lR~7<w\'TOE[q:Sk! ˎ\\~J7$kSsYme(|.ŹzZ[]y<op=t6@n&%§Rjf\077B+W+WQ)~ILkTH*:9.BeƢFQQ4Xx&$lHkd>[)طfά4@L1 /vNJ3\n._LEP@Uât_.Go%vCF2T@Nmab :zfa]䶤^Bu\0$b\"1,	Hp	3:X+O2>dpmݞ\Z\'r\0L=D!D&ǹ	\\,^x5몾lc읋qoןK֛+>xy8\"lqN!_\rт>3f%؂!a29\n`F_h*y.ZۭP0\"j=xat\\KĂB^\Zyz9Pvߩ%u/7[&J9*o9q?Dh9wǏ;Z)K~Q[::js^Z@2nve)e_u!9]we<΁iJkN\0	A!OUHm!E=uMٍOI0x{MyR\r~SBSThZs*[?	POvDŌi*b*;ةDڨn/NI}7+ƕAl欿Bt\'stshwk1]\':&etbt*\n\'Z%$^*BR_~;Ak8\\=>J1~(Acqo%TFO-GzJTN>\'#.D=a:\'jK WHSߩO8ь+oP_ݢOad:̶&E \0@ؼkP	n2RI\r83u}! U1\\3jQI@`,HqmjXzn-P`\ry~E~|\nRi)fl饔e})ld$e .pzfݩ\"l?h[F*Üh#n LdK%n*ÀIF^ȯܒW@~ݘ0(UޕM!\0מTžd8(h]sx\"8pp9Y$SH,iw:ށin|j6;WFGT`l 9睪PkKVd*U\\8!Ҫt5_ZVu?%xXey9`AcuRWJy&`<paPc`9X\0MoDO=hW\0 7$RTbzHpf?@јݲIG]qM;>l\nA>khR8rƊxA+Alӱag._nZtTP%IC1ԇ3<;:OyaĊ2ݦwʩq,{n<Rq0͞Z;kA,L\'q H@9ĵMc1Kͷ;jJ[An>P:74iwqcs @\"/š|sP|0ô-\\~EEpAb*嚽s34!J[h7e^JTuVڅ6co*]Zb/<|1bJR#ԲYunnO#\rF1_Ң\'Sz<J8@bdNRYpa7 6rmr:=j.ry~/lu4l-v>u\\Qi窍gDH	;\0̸A#ā\nwa?>w{TUuz{cex\" 3g#((W	r3nt[E$踘mڙy/_,5V^,~<FXBVvc\nizNy׊}˜.\Z^S6\n@5PS7vۤgPA\0]Iʒ|*w~^,j.CJ3\nx+U1wz)\"4+B\\*T\\\"#Ȑdq%ɏII%%\"ЖX~X4;;]*	!\0Ki5sc#K^0UToh	&\"TQWvRid3m`a3\r.}|d p{0| n6;!h_Oe8|I9Vy;G=<ei|MqZ]V[]&I-q9)g0IRh4ڮIOĨ?cWNS%f\'\n,8wxFж!&\'TgOrP~tgng(W{v^Z}ȐC6ݞ+?۸ZPd?P\\kO}H\"F+:̵LZKA^qPCtZy\r<qwl%7=Y_)pS?8}w3BN\Zԕw^iW@\Z_\r`Bv`Wp5pЎ(W\\	c36\0\'fry9H$Ī50K5:\'Ċ$Ժ~}۽@֖\"Jf4*Ww븺\0㼸h_\\Nw}\nm\"{Z>1k||}PCTCA׆dŪC*k]0ɾ\"Ͷ#8KxQQL9omѠuu5.q* \nzu_B.pOQaT#:Cgzo;~]b^R<l$ә16r|\Zゐ5bT2ph=	9.q˖!˽U)Wl7J:]j#jR	𪏨|z03]SCfds&{MLA7FPLܸOV1SlfwV1	l?.\rƂ\" ;-ZYя ۚ֍,)ԅƨ;p-e*`[p5U׻iYf$\ZjؤBywͳ{n!z[>ft4n9+:WY@r\\o=9\'&Oa(P+pUƺc%U%oVrt}k*w\ZX\rb%rik\Zh\"rd`[n	tWE\Zr~cRp!{۵茸\n\nt.s^tE+WLկCҩχHc\'pkGxo$=0\'O~\0kJ\ZY[餽\\K:I(U\0eͧ8&:	㼸\ZBgaz<k]KiŝABR*6Fg,<\n-JlUMs%Y\'ThZ;P.s.1q+܋\r4~\n,}Pu|+\r;kػ/G\\#XOb<)wx&؅|t#*<v+7UZ^5>w<ePiz `d$W6̬XNl>+8ޖ#y\0Klx=1\0Fp+Fz|FR$PduU18<KnspGRb%~w(C3!L\\/9)J,{m#	L4x_%Ɍ5m_X-<ݵ~(H6lPLnMBy:L0j}y슟WSh5GH;|hYCsA83d1x;V((\ZB\0\rlŗBs#3?+WpPMk]<px_\"RLkiGAp\Z\\?h8Q$d1ˌF@C씯<x,ª幵^plY>WF7:q9Gi	[BV[Uĺ\'GPP(ϞS3Q?(H|,;pH@yƄk}{[W{LG.vOǫ\"I$C#uO;]$dg63* *{J\":rPnoRn+5-R\nqyM\r6IcE,M+,ǖf MP[Y&\r,YDxxVތ\Z~VDZ6aW_tʩk[ l-\0%;w`=\n^;HgR2gi\nB_[\074w5qs-8#c<\0/n\\8ߔ\rPmy1Щ3&Ttȹ8=SPyYmmUIOF	!}\rkZVKxڨЯ~?qO~þ`Ϸ7i.KK{1Xq\"SSw	4p<Cβl$CҾY_G%̗Aygl]2~tRs;3@\"_d/5%9U6>NcVMTpW \r0Z|\\T-BD\",QuܳnVsyf(G8hM\ZjG2\\1ã%jE^.A\ZXm,P\rJhTH_s=Kbn2`MYDũrWDe!_ג޲Uq[~#+	,f\r|H]ޔȘ?utHNX*\nO\r?=\n(NH=Hmj۰ҕwݝZɥ6mgH<mbm^f(hjQ5\\zȋWm>vPBSrJ-3Q[}X5}cxQ#\0tgFNv[HD`]ʟXv?p_釣!!vG7ܹӃV۱ɘO\\LFYѲXL&W\"Ĳ}:kS-e&sc6G<a^(\'&i,kP(GɎk&4Uew>\r~F\rﰒɤ\rUռ\rǠP#bQ{ΟXQ,-\"k}a뫪	P\03Msl/)Pʻ=]1hؗ]m3ĺXqÏj_y[+xEV0zxi\nF\n74欋\\M=Oh;{֗88}\r|ѫ^@Fj=ln&ăJӗ~lIu)]hj,DWrEaz0zL;-F\0U*/d.>z_MEMՏ-/v_څc?,U&\"R[R|L<uQRVxa)3hR\rGBM3p_~qo8i\'!G8<U)P2J[Qp97F \'>OMq=,`\Zs	b[yiC\0Tq@W~up)N®mU 0p3Tvw9n\\&#,@^pBsB:tQ2r{ṜgIU9\0ڡSwq\\(LpR^Lw:bD^J<#lV B<&bB筢09Z/|1p_mo<e{FEP\n-,5H:z\ZN\\6%\'^\n_-WNvR98qKn<J{bZ]X)8P`fܚdxF\"\Z8\"Y7^\nh8q3[NfGvу!Ec7:@\r%-,$ykW^I@UHP?Fa,\\3딢ߓ{B2AG<&%߼w$cTV¶\r|f7hCp\ZWOy\rvۥ8wG+dUxXcѨV*6i(HXw6[|JaʹЖq^Oh;xA3-\rhM>kv7[du^?r=ȕEo	2lhׇd̂zR<2K7I5K)`0U	dsͳTI!1&j[656i8ntl*?/]\Z4tX*5io 8_1vb̅@r)y-\0\0\n\"E s8т\\2.p·\"F6Zؙ\n$zz\rx1{HvQ\0`e_EL|bNTF\n+7gvnKwu%bv&(9`\\&S9~{-LKŝITi;u!\'}ց2:e<DjҔNϼ)_ D.=SE]7a*H4R],}\0mE:!7UeH> -%G(m\0=Ѓ0U_B%̢}#Ӏ9f>E.`ucfh9O©I(DO;^Klظ!/?aFz#H.[gٍ̀srY*Rh\'?DcIfLOGІ\'CaofZ=z3Kʒ/݀Gky}Ѱ\0*3Nf8bW$)81♠Y\rܖ-GO\Zaj.V~#aa;ݐ߃tߤ:dU%f{xi<f;KZ9ްNWj_H]͚VIR[냛B[2kG>-80Mrb*ߥV.Qcoƀ5xdU.\'evTʤ\rv[| ~>x)WpWa6B}(ҋyp\"c\'rrF4k~P,oʂ-~Bʾi>1/#)=+?+i/L.ZsEM}aHK><#uסteg~*}\ZXbHM\ZVځԾ#yXoa\\DŞhebh?)31us_sШdϭĕ\\H$^b/ݬVI>V*R/\0ӷ~r%\"8lbκ\"7eE=n~͙\'2C/r\r̈\r;JUˑ-\\Bҟqv@, C14-zd,Pժ=b]Td˻ن%Ə6/q?	CQc2 Gehh݌^@˶\\},nۛ~AF,Ʈ:QlO!\0Uс14%Ti{<nн>!2_Ud~p7O\";}ũR|\0", "no");
INSERT INTO `wor4890_wfconfig` VALUES("currentCronKey", "", "yes");
INSERT INTO `wor4890_wfconfig` VALUES("dashboardData", "a:4:{s:9:\"generated\";i:1760099220;s:3:\"tdf\";a:3:{s:9:\"community\";i:7069;s:7:\"premium\";i:7115;s:9:\"blacklist\";i:7008;}s:10:\"attackdata\";a:3:{s:3:\"24h\";a:24:{i:0;a:2:{s:1:\"t\";i:1760011200;s:1:\"c\";i:10079983;}i:1;a:2:{s:1:\"t\";i:1760014800;s:1:\"c\";i:8799038;}i:2;a:2:{s:1:\"t\";i:1760018400;s:1:\"c\";i:8668277;}i:3;a:2:{s:1:\"t\";i:1760022000;s:1:\"c\";i:10015162;}i:4;a:2:{s:1:\"t\";i:1760025600;s:1:\"c\";i:9603962;}i:5;a:2:{s:1:\"t\";i:1760029200;s:1:\"c\";i:9654113;}i:6;a:2:{s:1:\"t\";i:1760032800;s:1:\"c\";i:9427999;}i:7;a:2:{s:1:\"t\";i:1760036400;s:1:\"c\";i:9205163;}i:8;a:2:{s:1:\"t\";i:1760040000;s:1:\"c\";i:7251365;}i:9;a:2:{s:1:\"t\";i:1760043600;s:1:\"c\";i:7030299;}i:10;a:2:{s:1:\"t\";i:1760047200;s:1:\"c\";i:6878689;}i:11;a:2:{s:1:\"t\";i:1760050800;s:1:\"c\";i:6502238;}i:12;a:2:{s:1:\"t\";i:1760054400;s:1:\"c\";i:6406652;}i:13;a:2:{s:1:\"t\";i:1760058000;s:1:\"c\";i:6653916;}i:14;a:2:{s:1:\"t\";i:1760061600;s:1:\"c\";i:6908417;}i:15;a:2:{s:1:\"t\";i:1760065200;s:1:\"c\";i:8018979;}i:16;a:2:{s:1:\"t\";i:1760068800;s:1:\"c\";i:8361129;}i:17;a:2:{s:1:\"t\";i:1760072400;s:1:\"c\";i:8544725;}i:18;a:2:{s:1:\"t\";i:1760076000;s:1:\"c\";i:8689247;}i:19;a:2:{s:1:\"t\";i:1760079600;s:1:\"c\";i:8447235;}i:20;a:2:{s:1:\"t\";i:1760083200;s:1:\"c\";i:8216421;}i:21;a:2:{s:1:\"t\";i:1760086800;s:1:\"c\";i:8150799;}i:22;a:2:{s:1:\"t\";i:1760090400;s:1:\"c\";i:7924498;}i:23;a:2:{s:1:\"t\";i:1760094000;s:1:\"c\";i:7215023;}}s:2:\"7d\";a:7:{i:0;a:2:{s:1:\"t\";i:1759449600;s:1:\"c\";i:129771818;}i:1;a:2:{s:1:\"t\";i:1759536000;s:1:\"c\";i:125199080;}i:2;a:2:{s:1:\"t\";i:1759622400;s:1:\"c\";i:174182794;}i:3;a:2:{s:1:\"t\";i:17